/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.RicercaTipologiaErogazione;
import org.openspcoop2.core.config.constants.RicercaTipologiaFruizione;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.config.constants.TipologiaErogazione;
import org.openspcoop2.core.config.constants.TipologiaFruizione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.TipologiaServizioApplicativo;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBSoggetti;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_serviziApplicativiDriver;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.LikeConfig;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDBServiziApplicativiSearch {
    private DriverConfigurazioneDB driver = null;
    private DriverConfigurazioneDBSoggetti soggettiDriver = null;
    private DriverConfigurazioneDB_serviziApplicativiDriver serviziApplicativiDriver = null;
    private static final String PREFIX_ATOMICA = "operazione this.driver.atomica = ";

    protected DriverConfigurazioneDBServiziApplicativiSearch(DriverConfigurazioneDB driver) {
        this.driver = driver;
        this.soggettiDriver = new DriverConfigurazioneDBSoggetti(driver);
        this.serviziApplicativiDriver = new DriverConfigurazioneDB_serviziApplicativiDriver(driver);
    }

    private String getPrefixError(String nomeMetodo) {
        return "[DriverConfigurazioneDB::" + nomeMetodo + "] ";
    }

    private String getMessageError(String nomeMetodo, Exception e) {
        return this.getPrefixError(nomeMetodo) + "Exception: " + e.getMessage();
    }

    private String getMessageDatasourceError(String nomeMetodo, Exception e) {
        return this.getPrefixError(nomeMetodo) + "Exception accedendo al datasource :" + e.getMessage();
    }

    private String getMessageProprietarioNonEsiste(String nomeMetodo, IDSoggetto proprietario) {
        return this.getPrefixError(nomeMetodo) + "Il proprietario [" + proprietario.toString() + "] non esiste.";
    }

    private List<ServizioApplicativo> servizioApplicativoList(ISearch ricerca, Long idProprietario) throws DriverConfigurazioneException {
        ArrayList<ServizioApplicativo> arrayList;
        String nomeMetodo = "servizioApplicativoList(search,idProprietario)";
        int idLista = Liste.SERVIZIO_APPLICATIVO;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("servizioApplicativoList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(this.getMessageDatasourceError(nomeMetodo, e), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(PREFIX_ATOMICA + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                if (idProprietario != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addSelectCountField("*", "cont");
                if (idProprietario != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (idProprietario != null) {
                stmt.setLong(1, idProprietario);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                if (idProprietario != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=?");
                }
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                if (idProprietario != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=?");
                }
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (idProprietario != null) {
                stmt.setLong(1, idProprietario);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ServizioApplicativo sa = this.serviziApplicativiDriver.getServizioApplicativo(risultato.getLong("id"));
                lista.add(sa);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(this.getMessageError(nomeMetodo, qe), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<ServizioApplicativo> servizioApplicativoList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.servizioApplicativoList(ricerca, null);
    }

    protected List<ServizioApplicativo> servizioApplicativoList(IDSoggetto idSO, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "servizioApplicativoList";
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("servizioApplicativoList(idSoggetto)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(this.getMessageDatasourceError(nomeMetodo, e), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(PREFIX_ATOMICA + this.driver.atomica);
        try {
            List<ServizioApplicativo> e = this.servizioApplicativoList(ricerca, DBUtils.getIdSoggetto(idSO.getNome(), idSO.getTipo(), con, this.driver.tipoDB));
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(this.getMessageError(nomeMetodo, qe), qe);
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    private ISQLQueryObject buildSqlQueryObjectAutorizzazioniPorteDelegate(String nomeTabella, String aliasPDSA, String aliasPD, String aliasSERVIZI, String aliasACCORDI, String aliasACCORDIGRUPPI, String aliasGRUPPI, String aliasSOGGETTI, boolean isFilterGruppoFruizione, IDFruizione apiImplementazioneFruizione, String filterGruppo, List<Object> existsParameters) throws DriverConfigurazioneException {
        try {
            ISQLQueryObject sqlQueryObjectAutorizzazioniPorteDelegate = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable(nomeTabella, aliasPDSA);
            sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("porte_delegate", aliasPD);
            if (isFilterGruppoFruizione) {
                sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("servizi", aliasSERVIZI);
                sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("accordi", aliasACCORDI);
                sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("gruppi", aliasGRUPPI);
            }
            if (apiImplementazioneFruizione != null) {
                sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("soggetti", aliasSOGGETTI);
            }
            sqlQueryObjectAutorizzazioniPorteDelegate.addSelectAliasField(aliasPDSA, "id", aliasPDSA + "id");
            sqlQueryObjectAutorizzazioniPorteDelegate.setANDLogicOperator(true);
            sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPDSA + ".id_servizio_applicativo = servizi_applicativi.id");
            sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPDSA + ".id_porta = " + aliasPD + ".id");
            if (isFilterGruppoFruizione) {
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".id_servizio = " + aliasSERVIZI + ".id");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasGRUPPI + ".nome = ?");
                existsParameters.add(filterGruppo);
            }
            if (apiImplementazioneFruizione != null) {
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".id_soggetto = " + aliasSOGGETTI + ".id");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".tipo_soggetto_erogatore = ?");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".nome_soggetto_erogatore = ?");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".tipo_servizio = ?");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".nome_servizio = ?");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".versione_servizio = ?");
                existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getTipo());
                existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getNome());
                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getTipo());
                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getNome());
                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getTipo());
                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getNome());
                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getVersione());
            }
            return sqlQueryObjectAutorizzazioniPorteDelegate;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
    }

    private ISQLQueryObject buildSqlQueryObjectAutorizzazioniPorteApplicative(String nomeTabella, String aliasPASA, String aliasPA, String aliasSERVIZI, String aliasACCORDI, String aliasACCORDIGRUPPI, String aliasGRUPPI, String aliasSOGGETTI, boolean isFilterGruppoErogazione, IDServizio apiImplementazioneErogazione, String filterGruppo, List<Object> existsParameters) throws DriverConfigurazioneException {
        try {
            ISQLQueryObject sqlQueryObjectAutorizzazioniPorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable(nomeTabella, aliasPASA);
            sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("porte_applicative", aliasPA);
            if (isFilterGruppoErogazione) {
                sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("servizi", aliasSERVIZI);
                sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("accordi", aliasACCORDI);
                sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("gruppi", aliasGRUPPI);
            }
            if (apiImplementazioneErogazione != null) {
                sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("soggetti", aliasSOGGETTI);
            }
            sqlQueryObjectAutorizzazioniPorteApplicative.addSelectAliasField(aliasPASA, "id", aliasPASA + "id");
            sqlQueryObjectAutorizzazioniPorteApplicative.setANDLogicOperator(true);
            sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPASA + ".id_servizio_applicativo = servizi_applicativi.id");
            sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPASA + ".id_porta = " + aliasPA + ".id");
            if (isFilterGruppoErogazione) {
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".id_servizio = " + aliasSERVIZI + ".id");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasGRUPPI + ".nome = ?");
                existsParameters.add(filterGruppo);
            }
            if (apiImplementazioneErogazione != null) {
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".id_soggetto = " + aliasSOGGETTI + ".id");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".tipo_servizio = ?");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".servizio = ?");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".versione_servizio = ?");
                existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                existsParameters.add(apiImplementazioneErogazione.getTipo());
                existsParameters.add(apiImplementazioneErogazione.getNome());
                existsParameters.add(apiImplementazioneErogazione.getVersione());
            }
            return sqlQueryObjectAutorizzazioniPorteApplicative;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
    }

    protected List<ServizioApplicativo> soggettiServizioApplicativoList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<ServizioApplicativo> arrayList;
        String nomeMetodo = "soggettiServizioApplicativoList";
        int idLista = Liste.SERVIZIO_APPLICATIVO;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterProtocollo = SearchUtils.getFilter(ricerca, idLista, "filtroProtocollo");
        String filterProtocolli = SearchUtils.getFilter(ricerca, idLista, "filtroProtocolli");
        List<String> tipoSoggettiProtocollo = null;
        try {
            tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filterProtocollo, filterProtocolli);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
        String filterRuoloServizioApplicativo = SearchUtils.getFilter(ricerca, idLista, "filtroRuoloSA");
        TipologiaFruizione tipologiaFruizione = null;
        TipologiaErogazione tipologiaErogazione = null;
        if (filterRuoloServizioApplicativo != null && !"".equals(filterRuoloServizioApplicativo)) {
            if ("Erogatore".equals(filterRuoloServizioApplicativo)) {
                tipologiaErogazione = TipologiaErogazione.DISABILITATO;
            } else if ("Fruitore".equals(filterRuoloServizioApplicativo)) {
                tipologiaFruizione = TipologiaFruizione.DISABILITATO;
            }
        }
        String filterSoggettoTipoNome = SearchUtils.getFilter(ricerca, idLista, "filtroSoggetto");
        String filterSoggettoTipo = null;
        String filterSoggettoNome = null;
        if (filterSoggettoTipoNome != null && !"".equals(filterSoggettoTipoNome)) {
            filterSoggettoTipo = filterSoggettoTipoNome.split("/")[0];
            filterSoggettoNome = filterSoggettoTipoNome.split("/")[1];
        }
        String filterDominio = SearchUtils.getFilter(ricerca, idLista, "filtroDominio");
        PddTipologia pddTipologia = null;
        if (filterDominio != null && !"".equals(filterDominio)) {
            pddTipologia = PddTipologia.toPddTipologia(filterDominio);
        }
        String filterRuolo = SearchUtils.getFilter(ricerca, idLista, "filtroRuolo");
        String filterTipoServizioApplicativo = SearchUtils.getFilter(ricerca, idLista, "filtroTipoSA");
        String filterTipoCredenziali = SearchUtils.getFilter(ricerca, idLista, "filtroTipoCredenziali");
        String filterCredenziale = SearchUtils.getFilter(ricerca, idLista, "filtroCredenziale");
        String filterCredenzialeIssuer = SearchUtils.getFilter(ricerca, idLista, "filtroCredenzialeIssuer");
        if (filterCredenzialeIssuer != null && "".equals(filterCredenzialeIssuer)) {
            filterCredenzialeIssuer = null;
        }
        if (filterCredenzialeIssuer != null && !"ssl".equals(filterTipoCredenziali)) {
            filterCredenzialeIssuer = null;
        }
        String filterCredenzialeTokenPolicy = SearchUtils.getFilter(ricerca, idLista, "filtroCredenzialeTokenPolicy");
        boolean isFilterGruppoErogazione = false;
        boolean isFilterGruppoFruizione = false;
        String filterGruppo = SearchUtils.getFilter(ricerca, idLista, "filtroGruppo");
        if (filterGruppo != null && !"".equals(filterGruppo)) {
            isFilterGruppoErogazione = true;
            isFilterGruppoFruizione = true;
        }
        TipoPdD apiContesto = null;
        String filterApiContesto = SearchUtils.getFilter(ricerca, idLista, "filtroApiContesto");
        if (filterApiContesto != null && !"".equals(filterApiContesto)) {
            apiContesto = TipoPdD.toTipoPdD(filterApiContesto);
            if (TipoPdD.APPLICATIVA.equals(apiContesto)) {
                isFilterGruppoFruizione = false;
            } else if (TipoPdD.DELEGATA.equals(apiContesto)) {
                isFilterGruppoErogazione = false;
            } else {
                apiContesto = null;
            }
        }
        String filterApiImplementazione = SearchUtils.getFilter(ricerca, idLista, "filtroApiImpl");
        IDServizio apiImplementazioneErogazione = null;
        IDFruizione apiImplementazioneFruizione = null;
        if (filterApiImplementazione != null && !"".equals(filterApiImplementazione)) {
            if (TipoPdD.APPLICATIVA.equals(apiContesto)) {
                try {
                    apiImplementazioneErogazione = IDServizio.toIDServizio(filterApiImplementazione);
                    isFilterGruppoErogazione = false;
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("Filtro API Implementazione '" + filterApiImplementazione + "' non valido: " + e.getMessage(), e);
                }
            }
            if (TipoPdD.DELEGATA.equals(apiContesto)) {
                try {
                    apiImplementazioneFruizione = IDFruizione.toIDFruizione(filterApiImplementazione);
                    isFilterGruppoFruizione = false;
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("Filtro API Implementazione '" + filterApiImplementazione + "' non valido: " + e.getMessage(), e);
                }
            }
        }
        String filtroConnettoreTipo = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreTipo");
        String filtroConnettoreTipoPlugin = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreTipoPlugin");
        String filtroConnettoreTokenPolicy = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreTokenPolicy");
        String filtroConnettoreEndpoint = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreEndpoint");
        String filtroConnettoreKeystore = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreKeystore");
        String filtroConnettoreDebug = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreDebug");
        if (filtroConnettoreTipo != null && "".equals(filtroConnettoreTipo)) {
            filtroConnettoreTipo = null;
        }
        if (filtroConnettoreTipoPlugin != null && "".equals(filtroConnettoreTipoPlugin)) {
            filtroConnettoreTipoPlugin = null;
        }
        if (filtroConnettoreTokenPolicy != null && "".equals(filtroConnettoreTokenPolicy)) {
            filtroConnettoreTokenPolicy = null;
        }
        if (filtroConnettoreEndpoint != null && "".equals(filtroConnettoreEndpoint)) {
            filtroConnettoreEndpoint = null;
        }
        if (filtroConnettoreKeystore != null && "".equals(filtroConnettoreKeystore)) {
            filtroConnettoreKeystore = null;
        }
        if (filtroConnettoreDebug != null && "".equals(filtroConnettoreDebug)) {
            filtroConnettoreDebug = null;
        }
        boolean joinConnettore = filtroConnettoreTipo != null || filtroConnettoreTokenPolicy != null || filtroConnettoreEndpoint != null || filtroConnettoreKeystore != null || filtroConnettoreDebug != null;
        TipiConnettore tipoConnettore = null;
        String endpointType = null;
        boolean tipoConnettoreIntegrationManager = false;
        if (filtroConnettoreTipo != null && !"".equals(filtroConnettoreTipo)) {
            if ("IM".equals(filtroConnettoreTipo)) {
                tipoConnettoreIntegrationManager = true;
            } else {
                tipoConnettore = TipiConnettore.toEnumFromName(filtroConnettoreTipo);
                if (tipoConnettore != null) {
                    endpointType = TipiConnettore.CUSTOM.equals((Object)tipoConnettore) ? filtroConnettoreTipoPlugin : tipoConnettore.getNome();
                }
            }
        }
        String filtroModISicurezzaMessaggio = SearchUtils.getFilter(ricerca, idLista, "filtroModiSicMessaggio");
        String filtroModIKeystorePath = SearchUtils.getFilter(ricerca, idLista, "filtroModiKeystorePath");
        String filtroModIKeystoreSubject = SearchUtils.getFilter(ricerca, idLista, "filtroModiKeystoreSubject");
        String filtroModIKeystoreIssuer = SearchUtils.getFilter(ricerca, idLista, "filtroModiKeystoreIssuer");
        String filtroModISicurezzaToken = SearchUtils.getFilter(ricerca, idLista, "filtroModiTokenStato");
        String filtroModITokenPolicy = SearchUtils.getFilter(ricerca, idLista, "filtroModiTokenPolicy");
        String filtroModITokenClientId = SearchUtils.getFilter(ricerca, idLista, "filtroModiTokenClientId");
        String filtroModIAudience = SearchUtils.getFilter(ricerca, idLista, "filtroModiAudience");
        Boolean filtroModISicurezzaMessaggioEnabled = null;
        if ("abilitato".equals(filtroModISicurezzaMessaggio)) {
            filtroModISicurezzaMessaggioEnabled = true;
        } else if ("disabilitato".equals(filtroModISicurezzaMessaggio)) {
            filtroModISicurezzaMessaggioEnabled = false;
        }
        if (filtroModISicurezzaMessaggioEnabled != null && filtroModISicurezzaMessaggioEnabled.booleanValue()) {
            if (filtroModIKeystorePath != null && "".equals(filtroModIKeystorePath)) {
                filtroModIKeystorePath = null;
            }
            if (filtroModIKeystoreSubject != null && "".equals(filtroModIKeystoreSubject)) {
                filtroModIKeystoreSubject = null;
            }
            if (filtroModIKeystoreIssuer != null && "".equals(filtroModIKeystoreIssuer)) {
                filtroModIKeystoreIssuer = null;
            }
        } else {
            filtroModIKeystorePath = null;
            filtroModIKeystoreSubject = null;
            filtroModIKeystoreIssuer = null;
        }
        Boolean filtroModISicurezzaTokenEnabled = null;
        if ("abilitato".equals(filtroModISicurezzaToken)) {
            filtroModISicurezzaTokenEnabled = true;
        } else if ("disabilitato".equals(filtroModISicurezzaToken)) {
            filtroModISicurezzaTokenEnabled = false;
        }
        if (filtroModISicurezzaTokenEnabled != null && filtroModISicurezzaTokenEnabled.booleanValue()) {
            if (filtroModITokenPolicy != null && "".equals(filtroModITokenPolicy)) {
                filtroModITokenPolicy = null;
            }
            if (filtroModITokenClientId != null && "".equals(filtroModITokenClientId)) {
                filtroModITokenClientId = null;
            }
        } else {
            filtroModITokenPolicy = null;
            filtroModITokenClientId = null;
        }
        if (filtroModIAudience != null && "".equals(filtroModIAudience)) {
            filtroModIAudience = null;
        }
        boolean filtroModI = filtroModISicurezzaMessaggioEnabled != null || filtroModIKeystorePath != null || filtroModIKeystoreSubject != null || filtroModIKeystoreIssuer != null || filtroModISicurezzaTokenEnabled != null || filtroModITokenPolicy != null || filtroModITokenClientId != null || filtroModIAudience != null;
        boolean checkCredenzialiBase = false;
        if (!(filterTipoCredenziali != null && !"".equals(filterTipoCredenziali) || filterCredenziale != null && !"".equals(filterCredenziale) || filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer))) {
            checkCredenzialiBase = true;
        }
        String filtroProprietaNome = SearchUtils.getFilter(ricerca, idLista, "filtroPropNome");
        String filtroProprietaValore = SearchUtils.getFilter(ricerca, idLista, "filtroPropValore");
        if (filtroProprietaNome != null && "".equals(filtroProprietaNome)) {
            filtroProprietaNome = null;
        }
        if (filtroProprietaValore != null && "".equals(filtroProprietaValore)) {
            filtroProprietaValore = null;
        }
        boolean filtroProprieta = filtroProprietaNome != null || filtroProprietaValore != null;
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterProtocollo : " + filterProtocollo);
        this.driver.logDebug("filterProtocolli : " + filterProtocolli);
        this.driver.logDebug("filterDominio : " + filterDominio);
        this.driver.logDebug("filterSoggettoNome : " + filterSoggettoNome);
        this.driver.logDebug("filterSoggettoTipo : " + filterSoggettoTipo);
        this.driver.logDebug("filterRuoloServizioApplicativo : " + filterRuoloServizioApplicativo);
        this.driver.logDebug("filterRuolo : " + filterRuolo);
        this.driver.logDebug("filterTipoServizioApplicativo : " + filterTipoServizioApplicativo);
        this.driver.logDebug("filterTipoCredenziali : " + filterTipoCredenziali);
        this.driver.logDebug("filterCredenziale : " + filterCredenziale);
        this.driver.logDebug("filterCredenzialeIssuer : " + filterCredenzialeIssuer);
        this.driver.logDebug("filterCredenzialeTokenPolicy : " + filterCredenzialeTokenPolicy);
        this.driver.logDebug("filterGruppo : " + filterGruppo);
        this.driver.logDebug("filterApiContesto : " + filterApiContesto);
        this.driver.logDebug("filterApiImplementazione : " + filterApiImplementazione);
        this.driver.logDebug("filtroConnettoreTipo : " + filtroConnettoreTipo);
        this.driver.logDebug("filtroConnettoreTokenPolicy : " + filtroConnettoreTokenPolicy);
        this.driver.logDebug("filtroConnettoreEndpoint : " + filtroConnettoreEndpoint);
        this.driver.logDebug("filtroConnettoreKeystore : " + filtroConnettoreKeystore);
        this.driver.logDebug("filtroConnettoreDebug : " + filtroConnettoreDebug);
        this.driver.logDebug("filtroConnettoreTipoPlugin : " + filtroConnettoreTipoPlugin);
        this.driver.logDebug("filtroModISicurezzaMessaggio : " + filtroModISicurezzaMessaggio);
        this.driver.logDebug("filtroModIKeystorePath : " + filtroModIKeystorePath);
        this.driver.logDebug("filtroModIKeystoreSubject : " + filtroModIKeystoreSubject);
        this.driver.logDebug("filtroModIKeystoreIssuer : " + filtroModIKeystoreIssuer);
        this.driver.logDebug("filtroModISicurezzaToken : " + filtroModISicurezzaToken);
        this.driver.logDebug("filtroModITokenPolicy : " + filtroModITokenPolicy);
        this.driver.logDebug("filtroModITokenClientId : " + filtroModITokenClientId);
        this.driver.logDebug("filtroModIAudience : " + filtroModIAudience);
        this.driver.logDebug("filtroProprietaNome : " + filtroProprietaNome);
        this.driver.logDebug("filtroProprietaValore : " + filtroProprietaValore);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> silList = new ArrayList<ServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(this.getMessageDatasourceError(nomeMetodo, e), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(PREFIX_ATOMICA + this.driver.atomica);
        try {
            Object sqlQueryObject;
            String queryString;
            ISQLQueryObject sqlQueryObjectAutorizzazioniPorteApplicative;
            ISQLQueryObject sqlQueryObjectAutorizzazioniPorteDelegate;
            ISQLQueryObject sqlQueryObjectPdd = null;
            if (pddTipologia != null && PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                ISQLQueryObject sqlQueryObjectExistsPdd = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectExistsPdd.addSelectField("pdd.nome");
                sqlQueryObjectExistsPdd.addFromTable("pdd");
                sqlQueryObjectExistsPdd.setANDLogicOperator(true);
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.nome=soggetti.server");
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.tipo=?");
                sqlQueryObjectPdd = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectPdd.setANDLogicOperator(false);
                sqlQueryObjectPdd.addWhereIsNullCondition("soggetti.server");
                sqlQueryObjectPdd.addWhereExistsCondition(false, sqlQueryObjectExistsPdd);
            }
            ArrayList<String> existsConditions = new ArrayList<String>();
            ArrayList<Object> existsParameters = new ArrayList<Object>();
            String aliasCT = "ct";
            String aliasALLARMI = "alarm";
            String aliasPDSA = "pdsa";
            String aliasPDTOKENSA = "pdtokensa";
            String aliasPD = "pd";
            String aliasPDTRASFORMAZIONISA = "pdtsa";
            String aliasPDTRASFORMAZIONI = "pdt";
            String aliasPASA = "pasa";
            String aliasPATOKENSA = "patokensa";
            String aliasPA = "pa";
            String aliasPATRASFORMAZIONISA = "patsa";
            String aliasPATRASFORMAZIONI = "pat";
            String aliasSERVIZI = "s";
            String aliasACCORDI = "a";
            String aliasACCORDIGRUPPI = "ag";
            String aliasGRUPPI = "g";
            String aliasSOGGETTI = "sProprietario";
            if (isFilterGruppoFruizione || TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                sqlQueryObjectAutorizzazioniPorteDelegate = this.buildSqlQueryObjectAutorizzazioniPorteDelegate("porte_delegate_sa", aliasPDSA, aliasPD, aliasSERVIZI, aliasACCORDI, aliasACCORDIGRUPPI, aliasGRUPPI, aliasSOGGETTI, isFilterGruppoFruizione, apiImplementazioneFruizione, filterGruppo, existsParameters);
                existsConditions.add(sqlQueryObjectAutorizzazioniPorteDelegate.getWhereExistsCondition(false, sqlQueryObjectAutorizzazioniPorteDelegate));
            }
            if (isFilterGruppoFruizione || TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                sqlQueryObjectAutorizzazioniPorteDelegate = this.buildSqlQueryObjectAutorizzazioniPorteDelegate("pd_token_sa", aliasPDTOKENSA, aliasPD, aliasSERVIZI, aliasACCORDI, aliasACCORDIGRUPPI, aliasGRUPPI, aliasSOGGETTI, isFilterGruppoFruizione, apiImplementazioneFruizione, filterGruppo, existsParameters);
                existsConditions.add(sqlQueryObjectAutorizzazioniPorteDelegate.getWhereExistsCondition(false, sqlQueryObjectAutorizzazioniPorteDelegate));
            }
            if (isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                sqlQueryObjectAutorizzazioniPorteApplicative = this.buildSqlQueryObjectAutorizzazioniPorteApplicative("porte_applicative_sa_auth", aliasPASA, aliasPA, aliasSERVIZI, aliasACCORDI, aliasACCORDIGRUPPI, aliasGRUPPI, aliasSOGGETTI, isFilterGruppoErogazione, apiImplementazioneErogazione, filterGruppo, existsParameters);
                existsConditions.add(sqlQueryObjectAutorizzazioniPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectAutorizzazioniPorteApplicative));
            }
            if (isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                sqlQueryObjectAutorizzazioniPorteApplicative = this.buildSqlQueryObjectAutorizzazioniPorteApplicative("pa_token_sa", aliasPATOKENSA, aliasPA, aliasSERVIZI, aliasACCORDI, aliasACCORDIGRUPPI, aliasGRUPPI, aliasSOGGETTI, isFilterGruppoErogazione, apiImplementazioneErogazione, filterGruppo, existsParameters);
                existsConditions.add(sqlQueryObjectAutorizzazioniPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectAutorizzazioniPorteApplicative));
            }
            if (isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                ISQLQueryObject sqlQueryObjectServerPorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectServerPorteApplicative.addFromTable("porte_applicative_sa", aliasPASA);
                sqlQueryObjectServerPorteApplicative.addFromTable("porte_applicative", aliasPA);
                if (isFilterGruppoErogazione) {
                    sqlQueryObjectServerPorteApplicative.addFromTable("servizi", aliasSERVIZI);
                    sqlQueryObjectServerPorteApplicative.addFromTable("accordi", aliasACCORDI);
                    sqlQueryObjectServerPorteApplicative.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                    sqlQueryObjectServerPorteApplicative.addFromTable("gruppi", aliasGRUPPI);
                }
                if (apiImplementazioneErogazione != null) {
                    sqlQueryObjectServerPorteApplicative.addFromTable("soggetti", aliasSOGGETTI);
                }
                sqlQueryObjectServerPorteApplicative.addSelectAliasField(aliasPASA, "id", aliasPASA + "id");
                sqlQueryObjectServerPorteApplicative.setANDLogicOperator(true);
                sqlQueryObjectServerPorteApplicative.addWhereCondition(aliasPASA + ".id_servizio_applicativo = servizi_applicativi.id");
                sqlQueryObjectServerPorteApplicative.addWhereCondition(aliasPASA + ".id_porta = " + aliasPA + ".id");
                if (isFilterGruppoErogazione) {
                    sqlQueryObjectServerPorteApplicative.addWhereCondition(aliasPA + ".id_servizio = " + aliasSERVIZI + ".id");
                    sqlQueryObjectServerPorteApplicative.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                    sqlQueryObjectServerPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                    sqlQueryObjectServerPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                    sqlQueryObjectServerPorteApplicative.addWhereCondition(aliasGRUPPI + ".nome = ?");
                    existsParameters.add(filterGruppo);
                }
                if (apiImplementazioneErogazione != null) {
                    sqlQueryObjectServerPorteApplicative.addWhereCondition(aliasPA + ".id_soggetto = " + aliasSOGGETTI + ".id");
                    sqlQueryObjectServerPorteApplicative.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                    sqlQueryObjectServerPorteApplicative.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                    sqlQueryObjectServerPorteApplicative.addWhereCondition(aliasPA + ".tipo_servizio = ?");
                    sqlQueryObjectServerPorteApplicative.addWhereCondition(aliasPA + ".servizio = ?");
                    sqlQueryObjectServerPorteApplicative.addWhereCondition(aliasPA + ".versione_servizio = ?");
                    existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                    existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                    existsParameters.add(apiImplementazioneErogazione.getTipo());
                    existsParameters.add(apiImplementazioneErogazione.getNome());
                    existsParameters.add(apiImplementazioneErogazione.getVersione());
                }
                existsConditions.add(sqlQueryObjectServerPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectServerPorteApplicative));
            }
            if (isFilterGruppoFruizione || TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                ISQLQueryObject sqlQueryObjectControlloTrafficoPorteDelegate = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("ct_active_policy", aliasCT);
                if (isFilterGruppoFruizione || apiImplementazioneFruizione != null) {
                    sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("porte_delegate", aliasPD);
                    if (isFilterGruppoFruizione) {
                        sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("servizi", aliasSERVIZI);
                        sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("accordi", aliasACCORDI);
                        sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                        sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("gruppi", aliasGRUPPI);
                    }
                    if (apiImplementazioneFruizione != null) {
                        sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("soggetti", aliasSOGGETTI);
                    }
                }
                sqlQueryObjectControlloTrafficoPorteDelegate.addSelectAliasField(aliasCT, "id", aliasCT + "id");
                sqlQueryObjectControlloTrafficoPorteDelegate.setANDLogicOperator(true);
                sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasCT + ".filtro_tipo_fruitore = soggetti.tipo_soggetto");
                sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasCT + ".filtro_nome_fruitore = soggetti.nome_soggetto");
                sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasCT + ".filtro_sa_fruitore = servizi_applicativi.nome");
                sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasCT + ".filtro_ruolo = 'delegata'");
                if (isFilterGruppoFruizione || apiImplementazioneFruizione != null) {
                    sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasCT + ".filtro_porta = " + aliasPD + ".nome_porta");
                    if (isFilterGruppoFruizione) {
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".id_servizio = " + aliasSERVIZI + ".id");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasGRUPPI + ".nome = ?");
                        existsParameters.add(filterGruppo);
                    }
                    if (apiImplementazioneFruizione != null) {
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".id_soggetto = " + aliasSOGGETTI + ".id");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".tipo_soggetto_erogatore = ?");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".nome_soggetto_erogatore = ?");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".tipo_servizio = ?");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".nome_servizio = ?");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".versione_servizio = ?");
                        existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getTipo());
                        existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getNome());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getTipo());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getNome());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getTipo());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getNome());
                        existsParameters.add(apiImplementazioneFruizione.getIdServizio().getVersione());
                    }
                }
                existsConditions.add(sqlQueryObjectControlloTrafficoPorteDelegate.getWhereExistsCondition(false, sqlQueryObjectControlloTrafficoPorteDelegate));
            }
            if (isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                ISQLQueryObject sqlQueryObjectControlloTrafficoPorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("ct_active_policy", aliasCT);
                if (isFilterGruppoErogazione || apiImplementazioneErogazione != null) {
                    sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("porte_applicative", aliasPA);
                    if (isFilterGruppoErogazione) {
                        sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("servizi", aliasSERVIZI);
                        sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("accordi", aliasACCORDI);
                        sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                        sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("gruppi", aliasGRUPPI);
                    }
                    if (apiImplementazioneErogazione != null) {
                        sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("soggetti", aliasSOGGETTI);
                    }
                }
                sqlQueryObjectControlloTrafficoPorteApplicative.addSelectAliasField(aliasCT, "id", aliasCT + "id");
                sqlQueryObjectControlloTrafficoPorteApplicative.setANDLogicOperator(true);
                sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasCT + ".filtro_tipo_fruitore = soggetti.tipo_soggetto");
                sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasCT + ".filtro_nome_fruitore = soggetti.nome_soggetto");
                sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasCT + ".filtro_sa_fruitore = servizi_applicativi.nome");
                sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasCT + ".filtro_ruolo = 'applicativa'");
                if (isFilterGruppoErogazione || apiImplementazioneErogazione != null) {
                    sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasCT + ".filtro_porta = " + aliasPA + ".nome_porta");
                    if (isFilterGruppoErogazione) {
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasPA + ".id_servizio = " + aliasSERVIZI + ".id");
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasGRUPPI + ".nome = ?");
                        existsParameters.add(filterGruppo);
                    }
                    if (apiImplementazioneErogazione != null) {
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasPA + ".id_soggetto = " + aliasSOGGETTI + ".id");
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasPA + ".tipo_servizio = ?");
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasPA + ".servizio = ?");
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasPA + ".versione_servizio = ?");
                        existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                        existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                        existsParameters.add(apiImplementazioneErogazione.getTipo());
                        existsParameters.add(apiImplementazioneErogazione.getNome());
                        existsParameters.add(apiImplementazioneErogazione.getVersione());
                    }
                }
                existsConditions.add(sqlQueryObjectControlloTrafficoPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectControlloTrafficoPorteApplicative));
            }
            if (CostantiDB.isAllarmiEnabled()) {
                if (isFilterGruppoFruizione || TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                    ISQLQueryObject sqlQueryObjectAllarmiPorteDelegate = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectAllarmiPorteDelegate.addFromTable("allarmi", aliasALLARMI);
                    if (isFilterGruppoFruizione || apiImplementazioneFruizione != null) {
                        sqlQueryObjectAllarmiPorteDelegate.addFromTable("porte_delegate", aliasPD);
                        if (isFilterGruppoFruizione) {
                            sqlQueryObjectAllarmiPorteDelegate.addFromTable("servizi", aliasSERVIZI);
                            sqlQueryObjectAllarmiPorteDelegate.addFromTable("accordi", aliasACCORDI);
                            sqlQueryObjectAllarmiPorteDelegate.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                            sqlQueryObjectAllarmiPorteDelegate.addFromTable("gruppi", aliasGRUPPI);
                        }
                        if (apiImplementazioneFruizione != null) {
                            sqlQueryObjectAllarmiPorteDelegate.addFromTable("soggetti", aliasSOGGETTI);
                        }
                    }
                    sqlQueryObjectAllarmiPorteDelegate.addSelectAliasField(aliasALLARMI, "id", aliasALLARMI + "id");
                    sqlQueryObjectAllarmiPorteDelegate.setANDLogicOperator(true);
                    sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasALLARMI + ".filtro_tipo_fruitore = soggetti.tipo_soggetto");
                    sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasALLARMI + ".filtro_nome_fruitore = soggetti.nome_soggetto");
                    sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasALLARMI + ".filtro_sa_fruitore = servizi_applicativi.nome");
                    sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasALLARMI + ".filtro_ruolo = 'delegata'");
                    if (isFilterGruppoFruizione || apiImplementazioneFruizione != null) {
                        sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasALLARMI + ".filtro_porta = " + aliasPD + ".nome_porta");
                        if (isFilterGruppoFruizione) {
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".id_servizio = " + aliasSERVIZI + ".id");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasGRUPPI + ".nome = ?");
                            existsParameters.add(filterGruppo);
                        }
                        if (apiImplementazioneFruizione != null) {
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".id_soggetto = " + aliasSOGGETTI + ".id");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".tipo_soggetto_erogatore = ?");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".nome_soggetto_erogatore = ?");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".tipo_servizio = ?");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".nome_servizio = ?");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".versione_servizio = ?");
                            existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getTipo());
                            existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getNome());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getTipo());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getNome());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getTipo());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getNome());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getVersione());
                        }
                    }
                    existsConditions.add(sqlQueryObjectAllarmiPorteDelegate.getWhereExistsCondition(false, sqlQueryObjectAllarmiPorteDelegate));
                }
                if (isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                    ISQLQueryObject sqlQueryObjectAllarmiPorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectAllarmiPorteApplicative.addFromTable("allarmi", aliasALLARMI);
                    if (isFilterGruppoErogazione || apiImplementazioneErogazione != null) {
                        sqlQueryObjectAllarmiPorteApplicative.addFromTable("porte_applicative", aliasPA);
                        if (isFilterGruppoErogazione) {
                            sqlQueryObjectAllarmiPorteApplicative.addFromTable("servizi", aliasSERVIZI);
                            sqlQueryObjectAllarmiPorteApplicative.addFromTable("accordi", aliasACCORDI);
                            sqlQueryObjectAllarmiPorteApplicative.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                            sqlQueryObjectAllarmiPorteApplicative.addFromTable("gruppi", aliasGRUPPI);
                        }
                        if (apiImplementazioneErogazione != null) {
                            sqlQueryObjectAllarmiPorteApplicative.addFromTable("soggetti", aliasSOGGETTI);
                        }
                    }
                    sqlQueryObjectAllarmiPorteApplicative.addSelectAliasField(aliasALLARMI, "id", aliasALLARMI + "id");
                    sqlQueryObjectAllarmiPorteApplicative.setANDLogicOperator(true);
                    sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasALLARMI + ".filtro_tipo_fruitore = soggetti.tipo_soggetto");
                    sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasALLARMI + ".filtro_nome_fruitore = soggetti.nome_soggetto");
                    sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasALLARMI + ".filtro_sa_fruitore = servizi_applicativi.nome");
                    sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasALLARMI + ".filtro_ruolo = 'applicativa'");
                    if (isFilterGruppoErogazione || apiImplementazioneErogazione != null) {
                        sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasALLARMI + ".filtro_porta = " + aliasPA + ".nome_porta");
                        if (isFilterGruppoErogazione) {
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasPA + ".id_servizio = " + aliasSERVIZI + ".id");
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasGRUPPI + ".nome = ?");
                            existsParameters.add(filterGruppo);
                        }
                        if (apiImplementazioneErogazione != null) {
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasPA + ".id_soggetto = " + aliasSOGGETTI + ".id");
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasPA + ".tipo_servizio = ?");
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasPA + ".servizio = ?");
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasPA + ".versione_servizio = ?");
                            existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                            existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                            existsParameters.add(apiImplementazioneErogazione.getTipo());
                            existsParameters.add(apiImplementazioneErogazione.getNome());
                            existsParameters.add(apiImplementazioneErogazione.getVersione());
                        }
                    }
                    existsConditions.add(sqlQueryObjectAllarmiPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectAllarmiPorteApplicative));
                }
            }
            if (isFilterGruppoFruizione || TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                ISQLQueryObject sqlQueryObjectTrasformazioniPorteDelegate = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectTrasformazioniPorteDelegate.addFromTable("pd_transform_sa", aliasPDTRASFORMAZIONISA);
                sqlQueryObjectTrasformazioniPorteDelegate.addFromTable("pd_transform", aliasPDTRASFORMAZIONI);
                sqlQueryObjectTrasformazioniPorteDelegate.addFromTable("porte_delegate", aliasPD);
                if (isFilterGruppoFruizione) {
                    sqlQueryObjectTrasformazioniPorteDelegate.addFromTable("servizi", aliasSERVIZI);
                    sqlQueryObjectTrasformazioniPorteDelegate.addFromTable("accordi", aliasACCORDI);
                    sqlQueryObjectTrasformazioniPorteDelegate.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                    sqlQueryObjectTrasformazioniPorteDelegate.addFromTable("gruppi", aliasGRUPPI);
                }
                if (apiImplementazioneFruizione != null) {
                    sqlQueryObjectTrasformazioniPorteDelegate.addFromTable("soggetti", aliasSOGGETTI);
                }
                sqlQueryObjectTrasformazioniPorteDelegate.addSelectAliasField(aliasPDTRASFORMAZIONISA, "id", aliasPDTRASFORMAZIONISA + "id");
                sqlQueryObjectTrasformazioniPorteDelegate.setANDLogicOperator(true);
                sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasPDTRASFORMAZIONISA + ".id_servizio_applicativo = servizi_applicativi.id");
                sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasPDTRASFORMAZIONISA + ".id_trasformazione = " + aliasPDTRASFORMAZIONI + ".id");
                sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasPDTRASFORMAZIONI + ".id_porta = " + aliasPD + ".id");
                if (isFilterGruppoFruizione) {
                    sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasPD + ".id_servizio = " + aliasSERVIZI + ".id");
                    sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                    sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                    sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                    sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasGRUPPI + ".nome = ?");
                    existsParameters.add(filterGruppo);
                }
                if (apiImplementazioneFruizione != null) {
                    sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasPD + ".id_soggetto = " + aliasSOGGETTI + ".id");
                    sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                    sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                    sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasPD + ".tipo_soggetto_erogatore = ?");
                    sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasPD + ".nome_soggetto_erogatore = ?");
                    sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasPD + ".tipo_servizio = ?");
                    sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasPD + ".nome_servizio = ?");
                    sqlQueryObjectTrasformazioniPorteDelegate.addWhereCondition(aliasPD + ".versione_servizio = ?");
                    existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getTipo());
                    existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getNome());
                    existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getTipo());
                    existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getNome());
                    existsParameters.add(apiImplementazioneFruizione.getIdServizio().getTipo());
                    existsParameters.add(apiImplementazioneFruizione.getIdServizio().getNome());
                    existsParameters.add(apiImplementazioneFruizione.getIdServizio().getVersione());
                }
                existsConditions.add(sqlQueryObjectTrasformazioniPorteDelegate.getWhereExistsCondition(false, sqlQueryObjectTrasformazioniPorteDelegate));
            }
            if (isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                ISQLQueryObject sqlQueryObjectTrasformazioniPorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("pa_transform_sa", aliasPATRASFORMAZIONISA);
                sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("pa_transform", aliasPATRASFORMAZIONI);
                sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("porte_applicative", aliasPA);
                if (isFilterGruppoErogazione) {
                    sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("servizi", aliasSERVIZI);
                    sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("accordi", aliasACCORDI);
                    sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                    sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("gruppi", aliasGRUPPI);
                }
                if (apiImplementazioneErogazione != null) {
                    sqlQueryObjectTrasformazioniPorteApplicative.addFromTable("soggetti", aliasSOGGETTI);
                }
                sqlQueryObjectTrasformazioniPorteApplicative.addSelectAliasField(aliasPATRASFORMAZIONISA, "id", aliasPATRASFORMAZIONISA + "id");
                sqlQueryObjectTrasformazioniPorteApplicative.setANDLogicOperator(true);
                sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasPATRASFORMAZIONISA + ".id_servizio_applicativo = servizi_applicativi.id");
                sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasPATRASFORMAZIONISA + ".id_trasformazione = " + aliasPATRASFORMAZIONI + ".id");
                sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasPATRASFORMAZIONI + ".id_porta = " + aliasPA + ".id");
                if (isFilterGruppoErogazione) {
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasPA + ".id_servizio = " + aliasSERVIZI + ".id");
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasGRUPPI + ".nome = ?");
                    existsParameters.add(filterGruppo);
                }
                if (apiImplementazioneErogazione != null) {
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasPA + ".id_soggetto = " + aliasSOGGETTI + ".id");
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasPA + ".tipo_servizio = ?");
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasPA + ".servizio = ?");
                    sqlQueryObjectTrasformazioniPorteApplicative.addWhereCondition(aliasPA + ".versione_servizio = ?");
                    existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                    existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                    existsParameters.add(apiImplementazioneErogazione.getTipo());
                    existsParameters.add(apiImplementazioneErogazione.getNome());
                    existsParameters.add(apiImplementazioneErogazione.getVersione());
                }
                existsConditions.add(sqlQueryObjectTrasformazioniPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectTrasformazioniPorteApplicative));
            }
            if (!search.equals("")) {
                ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("servizi_applicativi");
                sqlQueryObject2.addFromTable("soggetti");
                sqlQueryObject2.addSelectCountField("*", "cont");
                sqlQueryObject2.addWhereCondition("id_soggetto = soggetti.id");
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject2.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject2.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject2.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (tipologiaFruizione != null) {
                    sqlQueryObject2.addWhereCondition(true, new String[]{"tipologia_fruizione is not null", "tipologia_fruizione<>?"});
                } else if (tipologiaErogazione != null) {
                    sqlQueryObject2.addWhereCondition(true, new String[]{"tipologia_erogazione is not null", "tipologia_erogazione<>?"});
                }
                if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                    sqlQueryObject2.addWhereCondition("soggetti.tipo_soggetto=?");
                    sqlQueryObject2.addWhereCondition("soggetti.nome_soggetto=?");
                }
                if (filterRuolo != null && !"".equals(filterRuolo)) {
                    sqlQueryObject2.addFromTable("sa_ruoli");
                    sqlQueryObject2.addWhereCondition("servizi_applicativi.id=sa_ruoli.id_servizio_applicativo");
                    sqlQueryObject2.addWhereCondition("sa_ruoli.ruolo=?");
                }
                if (filterTipoServizioApplicativo != null && !"".equals(filterTipoServizioApplicativo)) {
                    if ("clientORserver".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{"servizi_applicativi.tipo =?", "servizi_applicativi.tipo=?"});
                    } else if ("client".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{"servizi_applicativi.tipo = ?", "servizi_applicativi.as_client = ?"});
                    } else {
                        sqlQueryObject2.addWhereCondition("servizi_applicativi.tipo = ?");
                    }
                }
                if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                    if (CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{"servizi_applicativi.tipoauth = ?", "servizi_applicativi.tipoauth = ? AND servizi_applicativi.token_policy is not null AND servizi_applicativi.utente is not null"});
                    } else {
                        sqlQueryObject2.addWhereCondition("servizi_applicativi.tipoauth = ?");
                    }
                    if (filterCredenziale != null && !"".equals(filterCredenziale)) {
                        if (CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject2.addWhereCondition(false, new String[]{sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.cn_subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true))});
                        } else if (CostantiConfigurazione.CREDENZIALE_BASIC.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject2.addWhereLikeCondition("servizi_applicativi.utente", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true));
                        }
                    }
                    if (filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer) && CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.cn_issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true))});
                    }
                    if (filterCredenzialeTokenPolicy != null && !"".equals(filterCredenzialeTokenPolicy)) {
                        sqlQueryObject2.addWhereCondition("servizi_applicativi.token_policy = ?");
                    }
                }
                if (pddTipologia != null) {
                    if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                        sqlQueryObject2.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                    } else {
                        sqlQueryObject2.addFromTable("pdd");
                        sqlQueryObject2.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                    }
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject2.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                if (joinConnettore) {
                    DBUtils.setFiltriConnettoreApplicativo(sqlQueryObject2, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                }
                if (filtroModI) {
                    DBUtils.setFiltriModIApplicativi(sqlQueryObject2, this.driver.tipoDB, filtroModISicurezzaMessaggioEnabled, filtroModIKeystorePath, filtroModIKeystoreSubject, filtroModIKeystoreIssuer, filtroModISicurezzaTokenEnabled, filtroModITokenPolicy, filtroModITokenClientId, filtroModIAudience, checkCredenzialiBase);
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaApplicativo(sqlQueryObject2, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            } else {
                ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("servizi_applicativi");
                sqlQueryObject2.addFromTable("soggetti");
                sqlQueryObject2.addSelectCountField("*", "cont");
                sqlQueryObject2.addWhereCondition("id_soggetto = soggetti.id");
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject2.addWhereCondition("soggetti.superuser = ?");
                }
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject2.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (tipologiaFruizione != null) {
                    sqlQueryObject2.addWhereCondition(true, new String[]{"tipologia_fruizione is not null", "tipologia_fruizione<>?"});
                } else if (tipologiaErogazione != null) {
                    sqlQueryObject2.addWhereCondition(true, new String[]{"tipologia_erogazione is not null", "tipologia_erogazione<>?"});
                }
                if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                    sqlQueryObject2.addWhereCondition("soggetti.tipo_soggetto=?");
                    sqlQueryObject2.addWhereCondition("soggetti.nome_soggetto=?");
                }
                if (filterRuolo != null && !"".equals(filterRuolo)) {
                    sqlQueryObject2.addFromTable("sa_ruoli");
                    sqlQueryObject2.addWhereCondition("servizi_applicativi.id=sa_ruoli.id_servizio_applicativo");
                    sqlQueryObject2.addWhereCondition("sa_ruoli.ruolo=?");
                }
                if (filterTipoServizioApplicativo != null && !"".equals(filterTipoServizioApplicativo)) {
                    if ("clientORserver".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{"servizi_applicativi.tipo =?", "servizi_applicativi.tipo=?"});
                    } else if ("client".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{"servizi_applicativi.tipo = ?", "servizi_applicativi.as_client = ?"});
                    } else {
                        sqlQueryObject2.addWhereCondition("tipo = ?");
                    }
                }
                if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                    if (CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{"servizi_applicativi.tipoauth = ?", "servizi_applicativi.tipoauth = ? AND servizi_applicativi.token_policy is not null AND servizi_applicativi.utente is not null"});
                    } else {
                        sqlQueryObject2.addWhereCondition("servizi_applicativi.tipoauth = ?");
                    }
                    if (filterCredenziale != null && !"".equals(filterCredenziale)) {
                        if (CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject2.addWhereCondition(false, new String[]{sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.cn_subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true))});
                        } else if (CostantiConfigurazione.CREDENZIALE_BASIC.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject2.addWhereLikeCondition("servizi_applicativi.utente", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true));
                        }
                    }
                    if (filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer) && CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.cn_issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true))});
                    }
                    if (filterCredenzialeTokenPolicy != null && !"".equals(filterCredenzialeTokenPolicy)) {
                        sqlQueryObject2.addWhereCondition("servizi_applicativi.token_policy = ?");
                    }
                }
                if (pddTipologia != null) {
                    if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                        sqlQueryObject2.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                    } else {
                        sqlQueryObject2.addFromTable("pdd");
                        sqlQueryObject2.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                    }
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject2.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                if (joinConnettore) {
                    DBUtils.setFiltriConnettoreApplicativo(sqlQueryObject2, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                }
                if (filtroModI) {
                    DBUtils.setFiltriModIApplicativi(sqlQueryObject2, this.driver.tipoDB, filtroModISicurezzaMessaggioEnabled, filtroModIKeystorePath, filtroModIKeystoreSubject, filtroModIKeystoreIssuer, filtroModISicurezzaTokenEnabled, filtroModITokenPolicy, filtroModITokenClientId, filtroModIAudience, checkCredenzialiBase);
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaApplicativo(sqlQueryObject2, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            this.driver.logDebug("Execute query: " + queryString);
            int index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (tipologiaFruizione != null) {
                stmt.setString(index++, tipologiaFruizione.getValue());
            } else if (tipologiaErogazione != null) {
                stmt.setString(index++, tipologiaErogazione.getValue());
            }
            if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                stmt.setString(index++, filterSoggettoTipo);
                stmt.setString(index++, filterSoggettoNome);
            }
            if (filterRuolo != null && !"".equals(filterRuolo)) {
                stmt.setString(index++, filterRuolo);
            }
            if (filterTipoServizioApplicativo != null && !"".equals(filterTipoServizioApplicativo)) {
                if ("clientORserver".equals(filterTipoServizioApplicativo)) {
                    stmt.setString(index++, "server");
                    stmt.setString(index++, "client");
                } else {
                    stmt.setString(index++, filterTipoServizioApplicativo);
                    if ("client".equals(filterTipoServizioApplicativo)) {
                        stmt.setInt(index++, 1);
                    }
                }
            }
            if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                stmt.setString(index++, filterTipoCredenziali);
                if (CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                    stmt.setString(index++, CostantiConfigurazione.CREDENZIALE_SSL.toString());
                }
                if (filterCredenzialeTokenPolicy != null && !"".equals(filterCredenzialeTokenPolicy)) {
                    stmt.setString(index++, filterCredenzialeTokenPolicy);
                }
            }
            if (pddTipologia != null) {
                stmt.setString(index++, pddTipologia.toString());
            }
            if (existsParameters != null && !existsParameters.isEmpty()) {
                for (Object e : existsParameters) {
                    if (e instanceof String) {
                        stmt.setString(index++, (String)e);
                        continue;
                    }
                    stmt.setInt(index++, (Integer)e);
                }
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            String aliasNomeServizioApplicativo = "appnome";
            String string = "orgtipo";
            String aliasNomeSoggetto = "orgnome";
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("servizi_applicativi", "id");
                sqlQueryObject.addSelectAliasField("servizi_applicativi", "nome", aliasNomeServizioApplicativo);
                sqlQueryObject.addSelectField("servizi_applicativi", "id_soggetto");
                sqlQueryObject.addSelectAliasField("soggetti", "tipo_soggetto", string);
                sqlQueryObject.addSelectAliasField("soggetti", "nome_soggetto", aliasNomeSoggetto);
                sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto = soggetti.id");
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (tipologiaFruizione != null) {
                    sqlQueryObject.addWhereCondition(true, new String[]{"tipologia_fruizione is not null", "tipologia_fruizione<>?"});
                } else if (tipologiaErogazione != null) {
                    sqlQueryObject.addWhereCondition(true, new String[]{"tipologia_erogazione is not null", "tipologia_erogazione<>?"});
                }
                if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                    sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto=?");
                    sqlQueryObject.addWhereCondition("soggetti.nome_soggetto=?");
                }
                if (filterRuolo != null && !"".equals(filterRuolo)) {
                    sqlQueryObject.addFromTable("sa_ruoli");
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_ruoli.id_servizio_applicativo");
                    sqlQueryObject.addWhereCondition("sa_ruoli.ruolo=?");
                }
                if (filterTipoServizioApplicativo != null && !"".equals(filterTipoServizioApplicativo)) {
                    if ("clientORserver".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipo =?", "servizi_applicativi.tipo=?"});
                    } else if ("client".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipo = ?", "servizi_applicativi.as_client = ?"});
                    } else {
                        sqlQueryObject.addWhereCondition("tipo = ?");
                    }
                }
                if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                    if (CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipoauth = ?", "servizi_applicativi.tipoauth = ? AND servizi_applicativi.token_policy is not null AND servizi_applicativi.utente is not null"});
                    } else {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.tipoauth = ?");
                    }
                    if (filterCredenziale != null && !"".equals(filterCredenziale)) {
                        if (CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("servizi_applicativi.cn_subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("servizi_applicativi.subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true))});
                        } else if (CostantiConfigurazione.CREDENZIALE_BASIC.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereLikeCondition("servizi_applicativi.utente", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true));
                        }
                    }
                    if (filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer) && CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("servizi_applicativi.cn_issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("servizi_applicativi.issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true))});
                    }
                    if (filterCredenzialeTokenPolicy != null && !"".equals(filterCredenzialeTokenPolicy)) {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.token_policy = ?");
                    }
                }
                if (pddTipologia != null) {
                    if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                        sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                    } else {
                        sqlQueryObject.addFromTable("pdd");
                        sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                    }
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                if (joinConnettore) {
                    DBUtils.setFiltriConnettoreApplicativo((ISQLQueryObject)sqlQueryObject, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                }
                if (filtroModI) {
                    DBUtils.setFiltriModIApplicativi((ISQLQueryObject)sqlQueryObject, this.driver.tipoDB, filtroModISicurezzaMessaggioEnabled, filtroModIKeystorePath, filtroModIKeystoreSubject, filtroModIKeystoreIssuer, filtroModISicurezzaTokenEnabled, filtroModITokenPolicy, filtroModITokenClientId, filtroModIAudience, checkCredenzialiBase);
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaApplicativo((ISQLQueryObject)sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy(aliasNomeServizioApplicativo);
                sqlQueryObject.addOrderBy(aliasNomeSoggetto);
                sqlQueryObject.addOrderBy(string);
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("servizi_applicativi", "id");
                sqlQueryObject.addSelectAliasField("servizi_applicativi", "nome", aliasNomeServizioApplicativo);
                sqlQueryObject.addSelectField("servizi_applicativi", "id_soggetto");
                sqlQueryObject.addSelectAliasField("soggetti", "tipo_soggetto", string);
                sqlQueryObject.addSelectAliasField("soggetti", "nome_soggetto", aliasNomeSoggetto);
                sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto = soggetti.id");
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (tipologiaFruizione != null) {
                    sqlQueryObject.addWhereCondition(true, new String[]{"tipologia_fruizione is not null", "tipologia_fruizione<>?"});
                } else if (tipologiaErogazione != null) {
                    sqlQueryObject.addWhereCondition(true, new String[]{"tipologia_erogazione is not null", "tipologia_erogazione<>?"});
                }
                if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                    sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto=?");
                    sqlQueryObject.addWhereCondition("soggetti.nome_soggetto=?");
                }
                if (filterRuolo != null && !"".equals(filterRuolo)) {
                    sqlQueryObject.addFromTable("sa_ruoli");
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_ruoli.id_servizio_applicativo");
                    sqlQueryObject.addWhereCondition("sa_ruoli.ruolo=?");
                }
                if (filterTipoServizioApplicativo != null && !"".equals(filterTipoServizioApplicativo)) {
                    if ("clientORserver".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipo =?", "servizi_applicativi.tipo=?"});
                    } else if ("client".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipo = ?", "servizi_applicativi.as_client = ?"});
                    } else {
                        sqlQueryObject.addWhereCondition("tipo = ?");
                    }
                }
                if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                    if (CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipoauth = ?", "servizi_applicativi.tipoauth = ? AND servizi_applicativi.token_policy is not null AND servizi_applicativi.utente is not null"});
                    } else {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.tipoauth = ?");
                    }
                    if (filterCredenziale != null && !"".equals(filterCredenziale)) {
                        if (CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("servizi_applicativi.cn_subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("servizi_applicativi.subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true))});
                        } else if (CostantiConfigurazione.CREDENZIALE_BASIC.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereLikeCondition("servizi_applicativi.utente", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true));
                        }
                    }
                    if (filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer) && CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("servizi_applicativi.cn_issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("servizi_applicativi.issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true))});
                    }
                    if (filterCredenzialeTokenPolicy != null && !"".equals(filterCredenzialeTokenPolicy)) {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.token_policy = ?");
                    }
                }
                if (pddTipologia != null) {
                    if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                        sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                    } else {
                        sqlQueryObject.addFromTable("pdd");
                        sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                    }
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                if (joinConnettore) {
                    DBUtils.setFiltriConnettoreApplicativo((ISQLQueryObject)sqlQueryObject, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                }
                if (filtroModI) {
                    DBUtils.setFiltriModIApplicativi((ISQLQueryObject)sqlQueryObject, this.driver.tipoDB, filtroModISicurezzaMessaggioEnabled, filtroModIKeystorePath, filtroModIKeystoreSubject, filtroModIKeystoreIssuer, filtroModISicurezzaTokenEnabled, filtroModITokenPolicy, filtroModITokenClientId, filtroModIAudience, checkCredenzialiBase);
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaApplicativo((ISQLQueryObject)sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy(aliasNomeServizioApplicativo);
                sqlQueryObject.addOrderBy(aliasNomeSoggetto);
                sqlQueryObject.addOrderBy(string);
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            this.driver.logDebug("Execute query: " + queryString);
            index = 1;
            if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                stmt.setString(index++, superuser);
            }
            if (tipologiaFruizione != null) {
                stmt.setString(index++, tipologiaFruizione.getValue());
            } else if (tipologiaErogazione != null) {
                stmt.setString(index++, tipologiaErogazione.getValue());
            }
            if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                stmt.setString(index++, filterSoggettoTipo);
                stmt.setString(index++, filterSoggettoNome);
            }
            if (filterRuolo != null && !"".equals(filterRuolo)) {
                stmt.setString(index++, filterRuolo);
            }
            if (filterTipoServizioApplicativo != null && !"".equals(filterTipoServizioApplicativo)) {
                if ("clientORserver".equals(filterTipoServizioApplicativo)) {
                    stmt.setString(index++, "server");
                    stmt.setString(index++, "client");
                } else {
                    stmt.setString(index++, filterTipoServizioApplicativo);
                    if ("client".equals(filterTipoServizioApplicativo)) {
                        stmt.setInt(index++, 1);
                    }
                }
            }
            if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                stmt.setString(index++, filterTipoCredenziali);
                if (CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                    stmt.setString(index++, CostantiConfigurazione.CREDENZIALE_SSL.toString());
                }
                if (filterCredenzialeTokenPolicy != null && !"".equals(filterCredenzialeTokenPolicy)) {
                    stmt.setString(index++, filterCredenzialeTokenPolicy);
                }
            }
            if (pddTipologia != null) {
                stmt.setString(index++, pddTipologia.toString());
            }
            if (existsParameters != null && !existsParameters.isEmpty()) {
                for (Object e : existsParameters) {
                    if (e instanceof String) {
                        stmt.setString(index++, (String)e);
                        continue;
                    }
                    stmt.setInt(index++, (Integer)e);
                }
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ServizioApplicativo sa = this.serviziApplicativiDriver.getServizioApplicativo(risultato.getLong("id"));
                silList.add(sa);
            }
            arrayList = silList;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(this.getMessageError(nomeMetodo, qe), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<ServizioApplicativo> soggettiServizioApplicativoList(Long idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<ServizioApplicativo> arrayList;
        String nomeMetodo = "soggettiServizioApplicativoList";
        int idLista = Liste.SERVIZI_APPLICATIVI_BY_SOGGETTO;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        List<String> tipoSoggettiProtocollo = null;
        String filterProtocollo = SearchUtils.getFilter(ricerca, idLista, "filtroProtocollo");
        String filterProtocolli = SearchUtils.getFilter(ricerca, idLista, "filtroProtocolli");
        if (idSoggetto == null || idSoggetto <= 0L) {
            try {
                tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filterProtocollo, filterProtocolli);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), e);
            }
        }
        String filterRuoloServizioApplicativo = SearchUtils.getFilter(ricerca, idLista, "filtroRuoloSA");
        TipologiaFruizione tipologiaFruizione = null;
        TipologiaErogazione tipologiaErogazione = null;
        if (filterRuoloServizioApplicativo != null && !"".equals(filterRuoloServizioApplicativo)) {
            if ("Erogatore".equals(filterRuoloServizioApplicativo)) {
                tipologiaErogazione = TipologiaErogazione.DISABILITATO;
            } else if ("Fruitore".equals(filterRuoloServizioApplicativo)) {
                tipologiaFruizione = TipologiaFruizione.DISABILITATO;
            }
        }
        String filterTipoServizioApplicativo = SearchUtils.getFilter(ricerca, idLista, "filtroTipoSA");
        String filterTipoCredenziali = SearchUtils.getFilter(ricerca, idLista, "filtroTipoCredenziali");
        String filterCredenziale = SearchUtils.getFilter(ricerca, idLista, "filtroCredenziale");
        String filterCredenzialeIssuer = SearchUtils.getFilter(ricerca, idLista, "filtroCredenzialeIssuer");
        if (filterCredenzialeIssuer != null && "".equals(filterCredenzialeIssuer)) {
            filterCredenzialeIssuer = null;
        }
        if (filterCredenzialeIssuer != null && !"ssl".equals(filterTipoCredenziali)) {
            filterCredenzialeIssuer = null;
        }
        String filterCredenzialeTokenPolicy = SearchUtils.getFilter(ricerca, idLista, "filtroCredenzialeTokenPolicy");
        String filtroConnettoreTipo = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreTipo");
        String filtroConnettoreTipoPlugin = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreTipoPlugin");
        String filtroConnettoreTokenPolicy = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreTokenPolicy");
        String filtroConnettoreEndpoint = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreEndpoint");
        String filtroConnettoreKeystore = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreKeystore");
        String filtroConnettoreDebug = SearchUtils.getFilter(ricerca, idLista, "filtroConnettoreDebug");
        if (filtroConnettoreTipo != null && "".equals(filtroConnettoreTipo)) {
            filtroConnettoreTipo = null;
        }
        if (filtroConnettoreTipoPlugin != null && "".equals(filtroConnettoreTipoPlugin)) {
            filtroConnettoreTipoPlugin = null;
        }
        if (filtroConnettoreTokenPolicy != null && "".equals(filtroConnettoreTokenPolicy)) {
            filtroConnettoreTokenPolicy = null;
        }
        if (filtroConnettoreEndpoint != null && "".equals(filtroConnettoreEndpoint)) {
            filtroConnettoreEndpoint = null;
        }
        if (filtroConnettoreKeystore != null && "".equals(filtroConnettoreKeystore)) {
            filtroConnettoreKeystore = null;
        }
        if (filtroConnettoreDebug != null && "".equals(filtroConnettoreDebug)) {
            filtroConnettoreDebug = null;
        }
        boolean joinConnettore = filtroConnettoreTipo != null || filtroConnettoreTokenPolicy != null || filtroConnettoreEndpoint != null || filtroConnettoreKeystore != null || filtroConnettoreDebug != null;
        TipiConnettore tipoConnettore = null;
        String endpointType = null;
        boolean tipoConnettoreIntegrationManager = false;
        if (filtroConnettoreTipo != null && !"".equals(filtroConnettoreTipo)) {
            if ("IM".equals(filtroConnettoreTipo)) {
                tipoConnettoreIntegrationManager = true;
            } else {
                tipoConnettore = TipiConnettore.toEnumFromName(filtroConnettoreTipo);
                if (tipoConnettore != null) {
                    endpointType = TipiConnettore.CUSTOM.equals((Object)tipoConnettore) ? filtroConnettoreTipoPlugin : tipoConnettore.getNome();
                }
            }
        }
        String filtroModISicurezzaMessaggio = SearchUtils.getFilter(ricerca, idLista, "filtroModiSicMessaggio");
        String filtroModIKeystorePath = SearchUtils.getFilter(ricerca, idLista, "filtroModiKeystorePath");
        String filtroModIKeystoreSubject = SearchUtils.getFilter(ricerca, idLista, "filtroModiKeystoreSubject");
        String filtroModIKeystoreIssuer = SearchUtils.getFilter(ricerca, idLista, "filtroModiKeystoreIssuer");
        String filtroModISicurezzaToken = SearchUtils.getFilter(ricerca, idLista, "filtroModiTokenStato");
        String filtroModITokenPolicy = SearchUtils.getFilter(ricerca, idLista, "filtroModiTokenPolicy");
        String filtroModITokenClientId = SearchUtils.getFilter(ricerca, idLista, "filtroModiTokenClientId");
        String filtroModIAudience = SearchUtils.getFilter(ricerca, idLista, "filtroModiAudience");
        Boolean filtroModISicurezzaMessaggioEnabled = null;
        if ("abilitato".equals(filtroModISicurezzaMessaggio)) {
            filtroModISicurezzaMessaggioEnabled = true;
        } else if ("disabilitato".equals(filtroModISicurezzaMessaggio)) {
            filtroModISicurezzaMessaggioEnabled = false;
        }
        if (filtroModISicurezzaMessaggioEnabled != null && filtroModISicurezzaMessaggioEnabled.booleanValue()) {
            if (filtroModIKeystorePath != null && "".equals(filtroModIKeystorePath)) {
                filtroModIKeystorePath = null;
            }
            if (filtroModIKeystoreSubject != null && "".equals(filtroModIKeystoreSubject)) {
                filtroModIKeystoreSubject = null;
            }
            if (filtroModIKeystoreIssuer != null && "".equals(filtroModIKeystoreIssuer)) {
                filtroModIKeystoreIssuer = null;
            }
        } else {
            filtroModIKeystorePath = null;
            filtroModIKeystoreSubject = null;
            filtroModIKeystoreIssuer = null;
        }
        Boolean filtroModISicurezzaTokenEnabled = null;
        if ("abilitato".equals(filtroModISicurezzaToken)) {
            filtroModISicurezzaTokenEnabled = true;
        } else if ("disabilitato".equals(filtroModISicurezzaToken)) {
            filtroModISicurezzaTokenEnabled = false;
        }
        if (filtroModISicurezzaTokenEnabled != null && filtroModISicurezzaTokenEnabled.booleanValue()) {
            if (filtroModITokenPolicy != null && "".equals(filtroModITokenPolicy)) {
                filtroModITokenPolicy = null;
            }
            if (filtroModITokenClientId != null && "".equals(filtroModITokenClientId)) {
                filtroModITokenClientId = null;
            }
        } else {
            filtroModITokenPolicy = null;
            filtroModITokenClientId = null;
        }
        if (filtroModIAudience != null && "".equals(filtroModIAudience)) {
            filtroModIAudience = null;
        }
        boolean filtroModI = filtroModISicurezzaMessaggioEnabled != null || filtroModIKeystorePath != null || filtroModIKeystoreSubject != null || filtroModIKeystoreIssuer != null || filtroModISicurezzaTokenEnabled != null || filtroModITokenPolicy != null || filtroModITokenClientId != null || filtroModIAudience != null;
        boolean checkCredenzialiBase = false;
        if (!(filterTipoCredenziali != null && !"".equals(filterTipoCredenziali) || filterCredenziale != null && !"".equals(filterCredenziale) || filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer))) {
            checkCredenzialiBase = true;
        }
        String filtroProprietaNome = SearchUtils.getFilter(ricerca, idLista, "filtroPropNome");
        String filtroProprietaValore = SearchUtils.getFilter(ricerca, idLista, "filtroPropValore");
        if (filtroProprietaNome != null && "".equals(filtroProprietaNome)) {
            filtroProprietaNome = null;
        }
        if (filtroProprietaValore != null && "".equals(filtroProprietaValore)) {
            filtroProprietaValore = null;
        }
        boolean filtroProprieta = filtroProprietaNome != null || filtroProprietaValore != null;
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterProtocollo : " + filterProtocollo);
        this.driver.logDebug("filterProtocolli : " + filterProtocolli);
        this.driver.logDebug("filterRuoloServizioApplicativo : " + filterRuoloServizioApplicativo);
        this.driver.logDebug("filterTipoServizioApplicativo : " + filterTipoServizioApplicativo);
        this.driver.logDebug("filterTipoCredenziali : " + filterTipoCredenziali);
        this.driver.logDebug("filterCredenziale : " + filterCredenziale);
        this.driver.logDebug("filterCredenzialeIssuer : " + filterCredenzialeIssuer);
        this.driver.logDebug("filterCredenzialeTokenPolicy : " + filterCredenzialeTokenPolicy);
        this.driver.logDebug("filtroConnettoreTipo : " + filtroConnettoreTipo);
        this.driver.logDebug("filtroConnettoreTokenPolicy : " + filtroConnettoreTokenPolicy);
        this.driver.logDebug("filtroConnettoreEndpoint : " + filtroConnettoreEndpoint);
        this.driver.logDebug("filtroConnettoreKeystore : " + filtroConnettoreKeystore);
        this.driver.logDebug("filtroConnettoreDebug : " + filtroConnettoreDebug);
        this.driver.logDebug("filtroConnettoreTipoPlugin : " + filtroConnettoreTipoPlugin);
        this.driver.logDebug("filtroModISicurezzaMessaggio : " + filtroModISicurezzaMessaggio);
        this.driver.logDebug("filtroModIKeystorePath : " + filtroModIKeystorePath);
        this.driver.logDebug("filtroModIKeystoreSubject : " + filtroModIKeystoreSubject);
        this.driver.logDebug("filtroModIKeystoreIssuer : " + filtroModIKeystoreIssuer);
        this.driver.logDebug("filtroModISicurezzaToken : " + filtroModISicurezzaToken);
        this.driver.logDebug("filtroModITokenPolicy : " + filtroModITokenPolicy);
        this.driver.logDebug("filtroModITokenClientId : " + filtroModITokenClientId);
        this.driver.logDebug("filtroModIAudience : " + filtroModIAudience);
        this.driver.logDebug("filtroProprietaNome : " + filtroProprietaNome);
        this.driver.logDebug("filtroProprietaValore : " + filtroProprietaValore);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> silList = new ArrayList<ServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(this.getMessageDatasourceError(nomeMetodo, e), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(PREFIX_ATOMICA + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject;
            String queryString;
            ISQLQueryObject sqlQueryObject2;
            if (!search.equals("")) {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("servizi_applicativi");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (idSoggetto != null) {
                    sqlQueryObject2.addWhereCondition("id_soggetto = ?");
                }
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject2.addFromTable("soggetti");
                    sqlQueryObject2.addWhereCondition("id_soggetto = soggetti.id");
                    sqlQueryObject2.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (tipologiaFruizione != null) {
                    sqlQueryObject2.addWhereCondition(true, new String[]{"tipologia_fruizione is not null", "tipologia_fruizione<>?"});
                } else if (tipologiaErogazione != null) {
                    sqlQueryObject2.addWhereCondition(true, new String[]{"tipologia_erogazione is not null", "tipologia_erogazione<>?"});
                }
                if (filterTipoServizioApplicativo != null && !"".equals(filterTipoServizioApplicativo)) {
                    if ("clientORserver".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{"servizi_applicativi.tipo =?", "servizi_applicativi.tipo=?"});
                    } else if ("client".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{"servizi_applicativi.tipo = ?", "servizi_applicativi.as_client = ?"});
                    } else {
                        sqlQueryObject2.addWhereCondition("servizi_applicativi.tipo = ?");
                    }
                }
                if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                    if (CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{"servizi_applicativi.tipoauth = ?", "servizi_applicativi.tipoauth = ? AND servizi_applicativi.token_policy is not null AND servizi_applicativi.utente is not null"});
                    } else {
                        sqlQueryObject2.addWhereCondition("servizi_applicativi.tipoauth = ?");
                    }
                    if (filterCredenziale != null && !"".equals(filterCredenziale)) {
                        if (CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject2.addWhereCondition(false, new String[]{sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.cn_subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true))});
                        } else if (CostantiConfigurazione.CREDENZIALE_BASIC.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject2.addWhereLikeCondition("servizi_applicativi.utente", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true));
                        }
                    }
                    if (filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer) && CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.cn_issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true))});
                    }
                    if (filterCredenzialeTokenPolicy != null && !"".equals(filterCredenzialeTokenPolicy)) {
                        sqlQueryObject2.addWhereCondition("servizi_applicativi.token_policy = ?");
                    }
                }
                if (joinConnettore) {
                    DBUtils.setFiltriConnettoreApplicativo(sqlQueryObject2, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                }
                if (filtroModI) {
                    DBUtils.setFiltriModIApplicativi(sqlQueryObject2, this.driver.tipoDB, filtroModISicurezzaMessaggioEnabled, filtroModIKeystorePath, filtroModIKeystoreSubject, filtroModIKeystoreIssuer, filtroModISicurezzaTokenEnabled, filtroModITokenPolicy, filtroModITokenClientId, filtroModIAudience, checkCredenzialiBase);
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaApplicativo(sqlQueryObject2, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject2.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            } else {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("servizi_applicativi");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (idSoggetto != null) {
                    sqlQueryObject2.addWhereCondition("id_soggetto = ?");
                }
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject2.addFromTable("soggetti");
                    sqlQueryObject2.addWhereCondition("id_soggetto = soggetti.id");
                    sqlQueryObject2.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (tipologiaFruizione != null) {
                    sqlQueryObject2.addWhereCondition(true, new String[]{"tipologia_fruizione is not null", "tipologia_fruizione<>?"});
                } else if (tipologiaErogazione != null) {
                    sqlQueryObject2.addWhereCondition(true, new String[]{"tipologia_erogazione is not null", "tipologia_erogazione<>?"});
                }
                if (filterTipoServizioApplicativo != null && !"".equals(filterTipoServizioApplicativo)) {
                    if ("clientORserver".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{"servizi_applicativi.tipo =?", "servizi_applicativi.tipo=?"});
                    } else if ("client".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{"servizi_applicativi.tipo = ?", "servizi_applicativi.as_client = ?"});
                    } else {
                        sqlQueryObject2.addWhereCondition("servizi_applicativi.tipo = ?");
                    }
                }
                if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                    if (CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{"servizi_applicativi.tipoauth = ?", "servizi_applicativi.tipoauth = ? AND servizi_applicativi.token_policy is not null AND servizi_applicativi.utente is not null"});
                    } else {
                        sqlQueryObject2.addWhereCondition("servizi_applicativi.tipoauth = ?");
                    }
                    if (filterCredenziale != null && !"".equals(filterCredenziale)) {
                        if (CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject2.addWhereCondition(false, new String[]{sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.cn_subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true))});
                        } else if (CostantiConfigurazione.CREDENZIALE_BASIC.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject2.addWhereLikeCondition("servizi_applicativi.utente", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true));
                        }
                    }
                    if (filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer) && CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject2.addWhereCondition(false, new String[]{sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.cn_issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject2.getWhereLikeCondition("servizi_applicativi.issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true))});
                    }
                    if (filterCredenzialeTokenPolicy != null && !"".equals(filterCredenzialeTokenPolicy)) {
                        sqlQueryObject2.addWhereCondition("servizi_applicativi.token_policy = ?");
                    }
                }
                if (joinConnettore) {
                    DBUtils.setFiltriConnettoreApplicativo(sqlQueryObject2, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                }
                if (filtroModI) {
                    DBUtils.setFiltriModIApplicativi(sqlQueryObject2, this.driver.tipoDB, filtroModISicurezzaMessaggioEnabled, filtroModIKeystorePath, filtroModIKeystoreSubject, filtroModIKeystoreIssuer, filtroModISicurezzaTokenEnabled, filtroModITokenPolicy, filtroModITokenClientId, filtroModIAudience, checkCredenzialiBase);
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaApplicativo(sqlQueryObject2, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (idSoggetto != null) {
                stmt.setLong(index++, idSoggetto);
            }
            if (tipologiaFruizione != null) {
                stmt.setString(index++, tipologiaFruizione.getValue());
            } else if (tipologiaErogazione != null) {
                stmt.setString(index++, tipologiaErogazione.getValue());
            }
            if (filterTipoServizioApplicativo != null && !"".equals(filterTipoServizioApplicativo)) {
                if ("clientORserver".equals(filterTipoServizioApplicativo)) {
                    stmt.setString(index++, "server");
                    stmt.setString(index++, "client");
                } else {
                    stmt.setString(index++, filterTipoServizioApplicativo);
                    if ("client".equals(filterTipoServizioApplicativo)) {
                        stmt.setInt(index++, 1);
                    }
                }
            }
            if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                stmt.setString(index++, filterTipoCredenziali);
                if (CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                    stmt.setString(index++, CostantiConfigurazione.CREDENZIALE_SSL.toString());
                }
                if (filterCredenzialeTokenPolicy != null && !"".equals(filterCredenzialeTokenPolicy)) {
                    stmt.setString(index++, filterCredenzialeTokenPolicy);
                }
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("servizi_applicativi.id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("id_soggetto");
                if (idSoggetto != null) {
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                }
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject.addSelectField("nome_soggetto");
                    sqlQueryObject.addSelectField("tipo_soggetto");
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                    sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (tipologiaFruizione != null) {
                    sqlQueryObject.addWhereCondition(true, new String[]{"tipologia_fruizione is not null", "tipologia_fruizione<>?"});
                } else if (tipologiaErogazione != null) {
                    sqlQueryObject.addWhereCondition(true, new String[]{"tipologia_erogazione is not null", "tipologia_erogazione<>?"});
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject.addOrderBy("nome_soggetto");
                    sqlQueryObject.addOrderBy("tipo_soggetto");
                }
                if (filterTipoServizioApplicativo != null && !"".equals(filterTipoServizioApplicativo)) {
                    if ("clientORserver".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipo =?", "servizi_applicativi.tipo=?"});
                    } else if ("client".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipo = ?", "servizi_applicativi.as_client = ?"});
                    } else {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.tipo = ?");
                    }
                }
                if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                    if (CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipoauth = ?", "servizi_applicativi.tipoauth = ? AND servizi_applicativi.token_policy is not null AND servizi_applicativi.utente is not null"});
                    } else {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.tipoauth = ?");
                    }
                    if (filterCredenziale != null && !"".equals(filterCredenziale)) {
                        if (CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("servizi_applicativi.cn_subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("servizi_applicativi.subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true))});
                        } else if (CostantiConfigurazione.CREDENZIALE_BASIC.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereLikeCondition("servizi_applicativi.utente", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true));
                        }
                    }
                    if (filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer) && CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("servizi_applicativi.cn_issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("servizi_applicativi.issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true))});
                    }
                    if (filterCredenzialeTokenPolicy != null && !"".equals(filterCredenzialeTokenPolicy)) {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.token_policy = ?");
                    }
                }
                if (joinConnettore) {
                    DBUtils.setFiltriConnettoreApplicativo(sqlQueryObject, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                }
                if (filtroModI) {
                    DBUtils.setFiltriModIApplicativi(sqlQueryObject, this.driver.tipoDB, filtroModISicurezzaMessaggioEnabled, filtroModIKeystorePath, filtroModIKeystoreSubject, filtroModIKeystoreIssuer, filtroModISicurezzaTokenEnabled, filtroModITokenPolicy, filtroModITokenClientId, filtroModIAudience, checkCredenzialiBase);
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaApplicativo(sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("servizi_applicativi.id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("id_soggetto");
                if (idSoggetto != null) {
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                }
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject.addSelectField("nome_soggetto");
                    sqlQueryObject.addSelectField("tipo_soggetto");
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                    sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (tipologiaFruizione != null) {
                    sqlQueryObject.addWhereCondition(true, new String[]{"tipologia_fruizione is not null", "tipologia_fruizione<>?"});
                } else if (tipologiaErogazione != null) {
                    sqlQueryObject.addWhereCondition(true, new String[]{"tipologia_erogazione is not null", "tipologia_erogazione<>?"});
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                    sqlQueryObject.addOrderBy("nome_soggetto");
                    sqlQueryObject.addOrderBy("tipo_soggetto");
                }
                if (filterTipoServizioApplicativo != null && !"".equals(filterTipoServizioApplicativo)) {
                    if ("clientORserver".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipo =?", "servizi_applicativi.tipo=?"});
                    } else if ("client".equals(filterTipoServizioApplicativo)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipo = ?", "servizi_applicativi.as_client = ?"});
                    } else {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.tipo = ?");
                    }
                }
                if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                    if (CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipoauth = ?", "servizi_applicativi.tipoauth = ? AND servizi_applicativi.token_policy is not null AND servizi_applicativi.utente is not null"});
                    } else {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.tipoauth = ?");
                    }
                    if (filterCredenziale != null && !"".equals(filterCredenziale)) {
                        if (CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("servizi_applicativi.cn_subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("servizi_applicativi.subject", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true))});
                        } else if (CostantiConfigurazione.CREDENZIALE_BASIC.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString().equals(filterTipoCredenziali) || CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                            sqlQueryObject.addWhereLikeCondition("servizi_applicativi.utente", filterCredenziale, LikeConfig.contains((boolean)true, (boolean)true));
                        }
                    }
                    if (filterCredenzialeIssuer != null && !"".equals(filterCredenzialeIssuer) && CostantiConfigurazione.CREDENZIALE_SSL.toString().equals(filterTipoCredenziali)) {
                        sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("servizi_applicativi.cn_issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("servizi_applicativi.issuer", filterCredenzialeIssuer, LikeConfig.contains((boolean)true, (boolean)true))});
                    }
                    if (filterCredenzialeTokenPolicy != null && !"".equals(filterCredenzialeTokenPolicy)) {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.token_policy = ?");
                    }
                }
                if (joinConnettore) {
                    DBUtils.setFiltriConnettoreApplicativo(sqlQueryObject, this.driver.tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug);
                }
                if (filtroModI) {
                    DBUtils.setFiltriModIApplicativi(sqlQueryObject, this.driver.tipoDB, filtroModISicurezzaMessaggioEnabled, filtroModIKeystorePath, filtroModIKeystoreSubject, filtroModIKeystoreIssuer, filtroModISicurezzaTokenEnabled, filtroModITokenPolicy, filtroModITokenClientId, filtroModIAudience, checkCredenzialiBase);
                }
                if (filtroProprieta) {
                    DBUtils.setFiltriProprietaApplicativo(sqlQueryObject, this.driver.tipoDB, filtroProprietaNome, filtroProprietaValore);
                }
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (idSoggetto != null) {
                stmt.setLong(index++, idSoggetto);
            }
            if (tipologiaFruizione != null) {
                stmt.setString(index++, tipologiaFruizione.getValue());
            } else if (tipologiaErogazione != null) {
                stmt.setString(index++, tipologiaErogazione.getValue());
            }
            if (filterTipoServizioApplicativo != null && !"".equals(filterTipoServizioApplicativo)) {
                if ("clientORserver".equals(filterTipoServizioApplicativo)) {
                    stmt.setString(index++, "server");
                    stmt.setString(index++, "client");
                } else {
                    stmt.setString(index++, filterTipoServizioApplicativo);
                    if ("client".equals(filterTipoServizioApplicativo)) {
                        stmt.setInt(index++, 1);
                    }
                }
            }
            if (filterTipoCredenziali != null && !"".equals(filterTipoCredenziali)) {
                stmt.setString(index++, filterTipoCredenziali);
                if (CostantiConfigurazione.CREDENZIALE_TOKEN.toString().equals(filterTipoCredenziali)) {
                    stmt.setString(index++, CostantiConfigurazione.CREDENZIALE_SSL.toString());
                }
                if (filterCredenzialeTokenPolicy != null && !"".equals(filterCredenzialeTokenPolicy)) {
                    stmt.setString(index++, filterCredenzialeTokenPolicy);
                }
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ServizioApplicativo sa = this.serviziApplicativiDriver.getServizioApplicativo(risultato.getLong("id"));
                silList.add(sa);
            }
            arrayList = silList;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(this.getMessageError(nomeMetodo, qe), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<String> servizioApplicativoRuoliList(long idSA, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "servizioApplicativoRuoliList";
        int idLista = Liste.SERVIZIO_APPLICATIVO_RUOLI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(this.getMessageDatasourceError(nomeMetodo, e), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(PREFIX_ATOMICA + this.driver.atomica);
        ArrayList<String> listIdRuoli = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("sa_ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_ruoli.id_servizio_applicativo");
                sqlQueryObject.addWhereLikeCondition("sa_ruoli.ruolo", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("sa_ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_ruoli.id_servizio_applicativo");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSA);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("sa_ruoli");
                sqlQueryObject.addSelectField("sa_ruoli.ruolo");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_ruoli.id_servizio_applicativo");
                sqlQueryObject.addWhereLikeCondition("sa_ruoli.ruolo", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("sa_ruoli.ruolo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("sa_ruoli");
                sqlQueryObject.addSelectField("sa_ruoli.ruolo");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_ruoli.id_servizio_applicativo");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("sa_ruoli.ruolo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSA);
            risultato = stmt.executeQuery();
            listIdRuoli = new ArrayList<String>();
            while (risultato.next()) {
                listIdRuoli.add(risultato.getString(1));
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(this.getMessageError(nomeMetodo, qe), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return listIdRuoli;
    }

    protected List<Proprieta> serviziApplicativiProprietaList(int idSA, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "serviziApplicativiProprietaList";
        int idLista = Liste.SERVIZI_APPLICATIVI_PROP;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(this.getMessageDatasourceError(nomeMetodo, e), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(PREFIX_ATOMICA + this.driver.atomica);
        ArrayList<Proprieta> lista = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("sa_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_properties.id_servizio_applicativo");
                sqlQueryObject.addWhereLikeCondition("sa_properties.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("sa_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_properties.id_servizio_applicativo");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSA);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("sa_properties");
                sqlQueryObject.addSelectField("sa_properties.nome");
                sqlQueryObject.addSelectField("sa_properties.valore");
                sqlQueryObject.addSelectField("sa_properties.enc_value");
                sqlQueryObject.addSelectField("sa_properties.id");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_properties.id_servizio_applicativo");
                sqlQueryObject.addWhereLikeCondition("sa_properties.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("sa_properties.nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("sa_properties");
                sqlQueryObject.addSelectField("sa_properties.nome");
                sqlQueryObject.addSelectField("sa_properties.valore");
                sqlQueryObject.addSelectField("sa_properties.enc_value");
                sqlQueryObject.addSelectField("sa_properties.id");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_properties.id_servizio_applicativo");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("sa_properties.nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSA);
            risultato = stmt.executeQuery();
            lista = new ArrayList<Proprieta>();
            while (risultato.next()) {
                Proprieta proprieta = new Proprieta();
                proprieta.setId(risultato.getLong("id"));
                proprieta.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((String)encValue)) {
                    proprieta.setValore(encValue);
                } else {
                    proprieta.setValore(plainValue);
                }
                lista.add(proprieta);
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(this.getMessageError(nomeMetodo, qe), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return lista;
    }

    protected int countTipologieServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(null, null, false, null, false, filters, false, null, null);
    }

    protected int countTipologieServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(proprietario, null, false, null, false, filters, false, null, null);
    }

    protected int countTipologieFruizioneServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(null, null, false, null, true, filters, false, null, null);
    }

    protected int countTipologieFruizioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(null, null, false, null, true, filters, checkAssociazionePorta, null, null);
    }

    protected int countTipologieFruizioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(null, null, false, null, true, filters, checkAssociazionePorta, isBound, null);
    }

    protected int countTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(null, null, false, fruizione, true, filters, false, null, null);
    }

    protected int countTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(null, null, false, fruizione, true, filters, checkAssociazionePorta, null, null);
    }

    protected int countTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(null, null, false, fruizione, true, filters, checkAssociazionePorta, isBound, null);
    }

    protected int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(proprietario, null, false, null, true, filters, false, null, null);
    }

    protected int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(proprietario, null, false, null, true, filters, checkAssociazionePorta, null, null);
    }

    protected int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(proprietario, null, false, null, true, filters, checkAssociazionePorta, isBound, null);
    }

    protected int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(proprietario, null, false, fruizione, true, filters, false, null, null);
    }

    protected int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(proprietario, null, false, fruizione, true, filters, checkAssociazionePorta, null, null);
    }

    protected int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(proprietario, null, false, fruizione, true, filters, checkAssociazionePorta, isBound, null);
    }

    protected int countTipologieErogazioneServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(null, null, true, null, false, filters, false, null, null);
    }

    protected int countTipologieErogazioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(null, null, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    protected int countTipologieErogazioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(null, null, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    protected int countTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(null, erogazione, true, null, false, filters, false, null, null);
    }

    protected int countTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(null, erogazione, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    protected int countTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(null, erogazione, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    protected int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(proprietario, erogazione, true, null, false, filters, false, null, null);
    }

    protected int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(proprietario, erogazione, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    protected int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(proprietario, erogazione, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    protected int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(proprietario, null, true, null, false, filters, false, null, null);
    }

    protected int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(proprietario, null, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    protected int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngineCount(proprietario, null, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    private int serviziApplicativiListEngineCount(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, boolean searchSoloErogazione, RicercaTipologiaFruizione fruizione, boolean serchSoloFruizione, ISearch filters, boolean checkAssociazionePorta, Boolean fruizioneIsBound, Boolean erogazioneIsBound) throws DriverConfigurazioneException {
        int n;
        String search;
        String nomeMetodo = "serviziApplicativiCount";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        Long idProprietario = null;
        int idLista = Liste.SERVIZIO_APPLICATIVO;
        String string = search = "undefined".equals(filters.getSearchString(idLista)) ? "" : filters.getSearchString(idLista);
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(this.getMessageDatasourceError(nomeMetodo, e), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(PREFIX_ATOMICA + this.driver.atomica);
        try {
            if (proprietario != null && ((idProprietario = Long.valueOf(DBUtils.getIdSoggetto(proprietario.getNome(), proprietario.getTipo(), con, this.driver.tipoDB))) == null || idProprietario < 0L)) {
                throw new DriverConfigurazioneException(this.getMessageProprietarioNonEsiste(nomeMetodo, proprietario));
            }
            ISQLQueryObject sqlQueryObject = this.getServiziApplicativiSearchFiltratiTipologia(proprietario, erogazione, searchSoloErogazione, fruizione, serchSoloFruizione, checkAssociazionePorta, search, true, fruizioneIsBound, erogazioneIsBound);
            String queryString = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("QueryCount=[" + queryString + "]");
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (proprietario != null) {
                stmt.setLong(index++, idProprietario);
            }
            if (serchSoloFruizione) {
                if (fruizione == null) {
                    stmt.setString(index++, TipologiaFruizione.DISABILITATO.toString());
                } else if (!RicercaTipologiaFruizione.ALL.toString().equals(fruizione.toString())) {
                    stmt.setString(index++, fruizione.toString());
                }
            } else if (searchSoloErogazione) {
                if (erogazione == null) {
                    stmt.setString(index++, TipologiaErogazione.DISABILITATO.toString());
                } else if (!RicercaTipologiaErogazione.ALL.toString().equals(erogazione.toString())) {
                    stmt.setString(index++, erogazione.toString());
                }
            }
            if (fruizioneIsBound != null) {
                stmt.setString(index++, TipoAutenticazione.DISABILITATO.getValue());
            }
            if (erogazioneIsBound != null) {
                stmt.setString(index++, TipiConnettore.DISABILITATO.getNome());
                stmt.setString(index++, TipiConnettore.HTTP.getNome());
                stmt.setString(index++, TipiConnettore.HTTP.getNome());
            }
            risultato = stmt.executeQuery();
            int count = -1;
            if (risultato.next()) {
                count = risultato.getInt("count");
            }
            risultato.close();
            stmt.close();
            n = count;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(this.getMessageError(nomeMetodo, qe), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return n;
    }

    protected List<TipologiaServizioApplicativo> getTipologieServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(null, null, false, null, false, filters, false, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(proprietario, null, false, null, false, filters, false, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(null, null, false, null, true, filters, false, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(null, null, false, null, true, filters, checkAssociazionePorta, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(null, null, false, null, true, filters, checkAssociazionePorta, isBound, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(null, null, false, fruizione, true, filters, false, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(null, null, false, fruizione, true, filters, checkAssociazionePorta, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(null, null, false, fruizione, true, filters, checkAssociazionePorta, isBound, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(proprietario, null, false, null, true, filters, false, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(proprietario, null, false, null, true, filters, checkAssociazionePorta, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(proprietario, null, false, null, true, filters, checkAssociazionePorta, isBound, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(proprietario, null, false, fruizione, true, filters, false, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(proprietario, null, false, fruizione, true, filters, checkAssociazionePorta, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(proprietario, null, false, fruizione, true, filters, checkAssociazionePorta, isBound, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(null, null, true, null, false, filters, false, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(null, null, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(null, null, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    protected List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(null, erogazione, true, null, false, filters, false, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(null, erogazione, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(null, erogazione, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    protected List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(proprietario, erogazione, true, null, false, filters, false, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(proprietario, erogazione, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(proprietario, erogazione, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    protected List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(proprietario, null, true, null, false, filters, false, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(proprietario, null, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    protected List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiListEngine(proprietario, null, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    private List<TipologiaServizioApplicativo> serviziApplicativiListEngine(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, boolean searchSoloErogazione, RicercaTipologiaFruizione fruizione, boolean serchSoloFruizione, ISearch filters, boolean checkAssociazionePorta, Boolean fruizioneIsBound, Boolean erogazioneIsBound) throws DriverConfigurazioneException {
        ArrayList<TipologiaServizioApplicativo> arrayList;
        String nomeMetodo = "serviziApplicativiList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        Long idProprietario = null;
        int idLista = Liste.SERVIZIO_APPLICATIVO;
        int limit = filters.getPageSize(idLista);
        int offset = filters.getIndexIniziale(idLista);
        String search = "undefined".equals(filters.getSearchString(idLista)) ? "" : filters.getSearchString(idLista);
        ArrayList<TipologiaServizioApplicativo> lista = new ArrayList<TipologiaServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(this.getMessageDatasourceError(nomeMetodo, e), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(PREFIX_ATOMICA + this.driver.atomica);
        try {
            if (proprietario != null && ((idProprietario = Long.valueOf(DBUtils.getIdSoggetto(proprietario.getNome(), proprietario.getTipo(), con, this.driver.tipoDB))) == null || idProprietario < 0L)) {
                throw new DriverConfigurazioneException(this.getMessageProprietarioNonEsiste(nomeMetodo, proprietario));
            }
            filters.setNumEntries(idLista, this.serviziApplicativiListEngineCount(proprietario, erogazione, searchSoloErogazione, fruizione, serchSoloFruizione, filters, checkAssociazionePorta, fruizioneIsBound, erogazioneIsBound));
            ISQLQueryObject sqlQueryObject = this.getServiziApplicativiSearchFiltratiTipologia(proprietario, erogazione, searchSoloErogazione, fruizione, serchSoloFruizione, checkAssociazionePorta, search, false, fruizioneIsBound, erogazioneIsBound);
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setOffset(offset);
            sqlQueryObject.setLimit(limit);
            String queryString = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("Query=[" + queryString + "]");
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (proprietario != null) {
                stmt.setLong(index++, idProprietario);
            }
            if (serchSoloFruizione) {
                if (fruizione == null) {
                    stmt.setString(index++, TipologiaFruizione.DISABILITATO.toString());
                } else if (!RicercaTipologiaFruizione.ALL.toString().equals(fruizione.toString())) {
                    stmt.setString(index++, fruizione.toString());
                }
            } else if (searchSoloErogazione) {
                if (erogazione == null) {
                    stmt.setString(index++, TipologiaErogazione.DISABILITATO.toString());
                } else if (!RicercaTipologiaErogazione.ALL.toString().equals(erogazione.toString())) {
                    stmt.setString(index++, erogazione.toString());
                }
            }
            if (fruizioneIsBound != null) {
                stmt.setString(index++, TipoAutenticazione.DISABILITATO.getValue());
            }
            if (erogazioneIsBound != null) {
                stmt.setString(index++, TipiConnettore.DISABILITATO.getNome());
                stmt.setString(index++, TipiConnettore.HTTP.getNome());
                stmt.setString(index++, TipiConnettore.HTTP.getNome());
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String tipologiaErogazione;
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                if (proprietario != null) {
                    idSA.setIdSoggettoProprietario(proprietario);
                } else {
                    long idProprietarioLetto = risultato.getLong("id_soggetto");
                    Soggetto s = this.soggettiDriver.getSoggetto(idProprietarioLetto);
                    idSA.setIdSoggettoProprietario(new IDSoggetto(s.getTipo(), s.getNome()));
                }
                idSA.setNome(risultato.getString("nome"));
                TipologiaServizioApplicativo tipologia = new TipologiaServizioApplicativo();
                tipologia.setIdServizioApplicativo(idSA);
                String tipologiaFruizione = risultato.getString("tipologia_fruizione");
                if (tipologiaFruizione != null && !"".equals(tipologiaFruizione)) {
                    tipologia.setTipologiaFruizione(TipologiaFruizione.toEnumConstant(tipologiaFruizione));
                }
                if ((tipologiaErogazione = risultato.getString("tipologia_erogazione")) != null && !"".equals(tipologiaErogazione)) {
                    tipologia.setTipologiaErogazione(TipologiaErogazione.toEnumConstant(tipologiaErogazione));
                }
                lista.add(tipologia);
            }
            risultato.close();
            stmt.close();
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(this.getMessageError(nomeMetodo, qe), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    private ISQLQueryObject getServiziApplicativiSearchFiltratiTipologia(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, boolean searchSoloErogazione, RicercaTipologiaFruizione fruizione, boolean serchSoloFruizione, boolean checkAssociazionePorta, String search, boolean count, Boolean fruizioneIsBound, Boolean erogazioneIsBound) throws DriverConfigurazioneException {
        try {
            ISQLQueryObject sqlQueryObjectIn;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            if (count) {
                sqlQueryObject.addSelectCountField("*", "count");
            } else {
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("tipologia_fruizione");
                sqlQueryObject.addSelectField("tipologia_erogazione");
            }
            if (proprietario != null) {
                sqlQueryObject.addWhereCondition("id_soggetto=?");
            }
            if (!"".equals(search)) {
                sqlQueryObject.addWhereLikeCondition("nome", search, false, true, true);
            }
            if (serchSoloFruizione) {
                if (fruizione == null) {
                    sqlQueryObject.addWhereCondition(true, new String[]{"tipologia_fruizione is not null", "tipologia_fruizione <> ?"});
                } else if (RicercaTipologiaFruizione.DISABILITATO.toString().equals(fruizione.toString())) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"tipologia_fruizione is null", "tipologia_fruizione = ?"});
                } else if (!RicercaTipologiaFruizione.ALL.toString().equals(fruizione.toString())) {
                    sqlQueryObject.addWhereCondition("tipologia_fruizione = ?");
                }
                if (checkAssociazionePorta) {
                    sqlQueryObjectIn = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    ISQLQueryObject sqlQueryObjectTrasportoIn = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectTrasportoIn.addFromTable("porte_delegate_sa");
                    sqlQueryObjectTrasportoIn.addSelectField("id_servizio_applicativo");
                    sqlQueryObjectTrasportoIn.addWhereCondition("id_servizio_applicativo=servizi_applicativi.id");
                    sqlQueryObjectIn.addWhereExistsCondition(false, sqlQueryObjectTrasportoIn);
                    ISQLQueryObject sqlQueryObjectTokenIn = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectTokenIn.addFromTable("pd_token_sa");
                    sqlQueryObjectTokenIn.addSelectField("id_servizio_applicativo");
                    sqlQueryObjectTokenIn.addWhereCondition("id_servizio_applicativo=servizi_applicativi.id");
                    sqlQueryObjectIn.addWhereExistsCondition(false, sqlQueryObjectTokenIn);
                    sqlQueryObjectIn.setANDLogicOperator(false);
                    sqlQueryObjectIn.addWhereCondition(sqlQueryObjectIn.createSQLConditions());
                }
            } else if (searchSoloErogazione) {
                if (erogazione == null) {
                    sqlQueryObject.addWhereCondition(true, new String[]{"tipologia_erogazione is not null", "tipologia_erogazione <> ?"});
                } else if (RicercaTipologiaErogazione.DISABILITATO.toString().equals(erogazione.toString())) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"tipologia_erogazione is null", "tipologia_erogazione = ?"});
                } else if (!RicercaTipologiaErogazione.ALL.toString().equals(erogazione.toString())) {
                    sqlQueryObject.addWhereCondition("tipologia_erogazione = ?");
                }
                if (checkAssociazionePorta) {
                    sqlQueryObjectIn = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectIn.addFromTable("porte_applicative_sa");
                    sqlQueryObjectIn.addSelectField("id_servizio_applicativo");
                    sqlQueryObjectIn.addWhereCondition("id_servizio_applicativo=servizi_applicativi.id");
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectIn);
                }
            }
            if (fruizioneIsBound != null) {
                if (fruizioneIsBound.booleanValue()) {
                    sqlQueryObject.addWhereIsNotNullCondition("tipoauth");
                    sqlQueryObject.addWhereCondition("tipoauth<>?");
                } else {
                    sqlQueryObject.addWhereCondition(false, new String[]{"tipoauth is null", "tipoauth=?"});
                }
            }
            if (erogazioneIsBound != null) {
                ISQLQueryObject sqlQueryObjectConnettore = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectConnettore.setANDLogicOperator(true);
                sqlQueryObjectConnettore.addFromTable("connettori");
                sqlQueryObjectConnettore.addSelectField("id");
                sqlQueryObjectConnettore.addWhereCondition("id_connettore_inv=connettori.id");
                ISQLQueryObject sqlQueryObjectNullCondition = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectNullCondition.addWhereIsNotNullCondition("url");
                ISQLQueryObject sqlQueryObjectEmptyCondition = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectEmptyCondition.addWhereIsNotEmptyCondition("url");
                sqlQueryObjectConnettore.addWhereCondition(false, new String[]{"endpointtype<>? AND endpointtype<>?", "endpointtype=? AND " + sqlQueryObjectNullCondition.createSQLConditions() + " AND " + sqlQueryObjectEmptyCondition.createSQLConditions()});
                sqlQueryObject.addWhereExistsCondition(erogazioneIsBound == false, sqlQueryObjectConnettore);
            }
            sqlQueryObject.setANDLogicOperator(true);
            return sqlQueryObject;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
    }

    protected List<IDServizioApplicativo> serviziApplicativiList(ISearch filters, IDSoggetto proprietario, TipologiaErogazione ... erogazione) throws DriverConfigurazioneException {
        ArrayList<IDServizioApplicativo> arrayList;
        String nomeMetodo = "serviziApplicativiList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        long idProprietario = -1L;
        int idLista = Liste.SERVIZIO_APPLICATIVO;
        int limit = filters.getPageSize(idLista);
        int offset = filters.getIndexIniziale(idLista);
        String search = "undefined".equals(filters.getSearchString(idLista)) ? "" : filters.getSearchString(idLista);
        ArrayList<IDServizioApplicativo> lista = new ArrayList<IDServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(this.getMessageDatasourceError(nomeMetodo, e), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug(PREFIX_ATOMICA + this.driver.atomica);
        try {
            int i;
            idProprietario = DBUtils.getIdSoggetto(proprietario.getNome(), proprietario.getTipo(), con, this.driver.tipoDB);
            if (idProprietario < 0L) {
                throw new DriverConfigurazioneException(this.getMessageProprietarioNonEsiste(nomeMetodo, proprietario));
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectCountField("*", "count");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            if (!"".equals(search)) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            String[] conditions = new String[erogazione.length];
            for (int i2 = 0; i2 < erogazione.length; ++i2) {
                conditions[i2] = "tipologia_erogazione = ?";
            }
            sqlQueryObject.addWhereCondition(false, conditions);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idProprietario);
            int baseIdx = 1;
            for (i = 0; i < erogazione.length; ++i) {
                stmt.setString(++baseIdx, erogazione[i].toString());
            }
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                filters.setNumEntries(idLista, risultato.getInt("count"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addSelectField("tipologia_fruizione");
            sqlQueryObject.addSelectField("tipologia_erogazione");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            if (!"".equals(search)) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.addWhereCondition(false, conditions);
            sqlQueryObject.setANDLogicOperator(true);
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setOffset(offset);
            sqlQueryObject.setLimit(limit);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idProprietario);
            baseIdx = 1;
            for (i = 0; i < erogazione.length; ++i) {
                stmt.setString(++baseIdx, erogazione[i].toString());
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(proprietario);
                idSA.setNome(risultato.getString("nome"));
                lista.add(idSA);
            }
            risultato.close();
            stmt.close();
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(this.getMessageError(nomeMetodo, qe), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }
}

