/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.test;

import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.sql.AbstractSQLFieldConverter;
import org.openspcoop2.generic_project.expression.impl.test.beans.Book;
import org.openspcoop2.utils.TipiDatabase;

public class BookSQLFieldConverter
extends AbstractSQLFieldConverter {
    private TipiDatabase db = null;

    public BookSQLFieldConverter(TipiDatabase db) {
        this.db = db;
    }

    @Override
    public IModel<?> getRootModel() throws ExpressionException {
        return Book.model();
    }

    @Override
    public TipiDatabase getDatabaseType() throws ExpressionException {
        return this.db;
    }

    @Override
    public String toColumn(IField field, boolean returnAlias, boolean appendTablePrefix) throws ExpressionException {
        if (field.equals(Book.model().AUTHOR)) {
            if (appendTablePrefix) {
                return this.toAliasTable(field) + ".author";
            }
            return "author";
        }
        if (field.equals(Book.model().TITLE)) {
            if (appendTablePrefix) {
                return this.toAliasTable(field) + ".title";
            }
            return "title";
        }
        if (field.equals(Book.model().ENUM_STRING)) {
            if (appendTablePrefix) {
                return this.toAliasTable(field) + ".enum_string";
            }
            return "enum_string";
        }
        if (field.equals(Book.model().ENUM_DOUBLE)) {
            if (appendTablePrefix) {
                return this.toAliasTable(field) + ".enum_double";
            }
            return "enum_double";
        }
        if (field.equals(Book.model().ENUM_WRAPPER_PRIMITIVE_INT)) {
            if (appendTablePrefix) {
                return this.toAliasTable(field) + ".enum_wrapper_primitive_int";
            }
            return "enum_wrapper_primitive_int";
        }
        if (field.equals(Book.model().VERSION.DATE)) {
            if (appendTablePrefix) {
                return this.toAliasTable(field) + ".date";
            }
            return "date";
        }
        if (field.equals(Book.model().VERSION.NUMBER)) {
            if (appendTablePrefix) {
                return this.toAliasTable(field) + ".number";
            }
            return "number";
        }
        if (field.equals(Book.model().REISSUE.DATE)) {
            if (appendTablePrefix) {
                return this.toAliasTable(field) + ".date";
            }
            return "date";
        }
        if (field.equals(Book.model().REISSUE.NUMBER)) {
            if (appendTablePrefix) {
                return this.toAliasTable(field) + ".number";
            }
            return "number";
        }
        throw new ExpressionException("Field [" + field.toString() + "] not supported");
    }

    @Override
    public String toTable(IField field, boolean returnAlias) throws ExpressionException {
        if (field.equals(Book.model().AUTHOR)) {
            if (!returnAlias) {
                return "book b";
            }
            return "b";
        }
        if (field.equals(Book.model().TITLE)) {
            if (!returnAlias) {
                return "book b";
            }
            return "b";
        }
        if (field.equals(Book.model().ENUM_STRING)) {
            if (!returnAlias) {
                return "book b";
            }
            return "b";
        }
        if (field.equals(Book.model().ENUM_DOUBLE)) {
            if (!returnAlias) {
                return "book b";
            }
            return "b";
        }
        if (field.equals(Book.model().ENUM_WRAPPER_PRIMITIVE_INT)) {
            if (!returnAlias) {
                return "book b";
            }
            return "b";
        }
        if (field.equals(Book.model().VERSION.DATE)) {
            if (!returnAlias) {
                return "version v";
            }
            return "v";
        }
        if (field.equals(Book.model().VERSION.NUMBER)) {
            if (!returnAlias) {
                return "version v";
            }
            return "v";
        }
        if (field.equals(Book.model().REISSUE.DATE)) {
            if (!returnAlias) {
                return "reissue r";
            }
            return "r";
        }
        if (field.equals(Book.model().REISSUE.NUMBER)) {
            if (!returnAlias) {
                return "reissue r";
            }
            return "r";
        }
        throw new ExpressionException("Field [" + field.toString() + "] not supported");
    }

    @Override
    public String toTable(IModel<?> model, boolean returnAlias) throws ExpressionException {
        if (model.equals(Book.model())) {
            if (!returnAlias) {
                return "book b";
            }
            return "b";
        }
        if (model.equals(Book.model().VERSION)) {
            if (!returnAlias) {
                return "version v";
            }
            return "v";
        }
        if (model.equals(Book.model().REISSUE)) {
            if (!returnAlias) {
                return "reissue r";
            }
            return "r";
        }
        return "book b";
    }
}

