/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.dao.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.dao.xml.XMLLoggerProperties;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.serializer.AbstractDeserializerBase;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.xml.ValidatoreXSD;
import org.slf4j.Logger;

public abstract class AbstractXMLServiceManager<XML> {
    private AbstractDeserializerBase deserializer;
    private Class<XML> cXmlRoot;
    protected String xmlPath;
    protected XML rootXml;
    private ValidatoreXSD xsdValidator = null;
    private long lastModified = 0L;
    private Logger log = null;
    private static final int timeoutRefresh = 30;

    private void parsingXML() throws ServiceException {
        FileInputStream fXML = null;
        try {
            if (this.xmlPath.startsWith("http://") || this.xmlPath.startsWith("file://")) {
                this.xsdValidator.valida(this.xmlPath);
            } else {
                fXML = new FileInputStream(this.xmlPath);
                this.xsdValidator.valida((InputStream)fXML);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Xsd validation failure: " + e.getMessage(), e);
        }
        finally {
            if (fXML != null) {
                try {
                    fXML.close();
                }
                catch (Exception exception) {}
            }
        }
        InputStream iStream = null;
        HttpURLConnection httpConn = null;
        if (this.xmlPath.startsWith("http://") || this.xmlPath.startsWith("file://")) {
            try {
                URL url = new URL(this.xmlPath);
                URLConnection connection = url.openConnection();
                httpConn = (HttpURLConnection)connection;
                httpConn.setRequestMethod("GET");
                httpConn.setDoOutput(true);
                httpConn.setDoInput(true);
                iStream = httpConn.getInputStream();
            }
            catch (Exception e) {
                try {
                    if (httpConn != null) {
                        httpConn.disconnect();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ServiceException("Creating InputStream (HTTP) failure: " + e.getMessage(), e);
            }
            this.lastModified = System.currentTimeMillis();
        } else {
            try {
                iStream = new FileInputStream(this.xmlPath);
            }
            catch (FileNotFoundException e) {
                throw new ServiceException("Creating InputStream (FILE) failure" + e.getMessage(), e);
            }
            try {
                this.lastModified = new File(this.xmlPath).lastModified();
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new ServiceException("Reading xml [" + this.xmlPath + "] failure: " + e.getMessage(), e);
            }
        }
        try {
            this.rootXml = this.deserializer.xmlToObj(iStream, this.cXmlRoot);
        }
        catch (Exception e) {
            try {
                if (iStream != null) {
                    iStream.close();
                }
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ServiceException("Unmarshall document xml failure: " + e.getMessage(), e);
        }
        try {
            if (iStream != null) {
                iStream.close();
            }
            if (httpConn != null) {
                httpConn.disconnect();
            }
        }
        catch (Exception e) {
            throw new ServiceException("Close InputStream failure: " + e.getMessage(), e);
        }
    }

    protected AbstractXMLServiceManager(Class<XML> cXmlRoot, AbstractDeserializerBase deserializer, String xsdPath, File xmlPath) throws ServiceException {
        this(cXmlRoot, deserializer, xsdPath, xmlPath, null);
    }

    protected AbstractXMLServiceManager(Class<XML> cXmlRoot, AbstractDeserializerBase deserializer, String xsdPath, File xmlPath, Logger alog) throws ServiceException {
        this(cXmlRoot, deserializer, xsdPath, xmlPath.getAbsolutePath(), alog);
    }

    protected AbstractXMLServiceManager(Class<XML> cXmlRoot, AbstractDeserializerBase deserializer, String xsdPath, String xmlPath) throws ServiceException {
        this(cXmlRoot, deserializer, xsdPath, xmlPath, null);
    }

    protected AbstractXMLServiceManager(Class<XML> cXmlRoot, AbstractDeserializerBase deserializer, String xsdPath, String xmlPath, Logger alog) throws ServiceException {
        this.log = alog == null ? LoggerWrapperFactory.getLogger(AbstractXMLServiceManager.class) : alog;
        if (xmlPath == null) {
            this.log.error("New Instance failure: url/xmlPath is null");
            throw new ServiceException("New Instance failure: url/xmlPath is null");
        }
        this.xmlPath = xmlPath;
        if (xsdPath == null) {
            this.log.error("New Instance failure: xsdPath is null");
            throw new ServiceException("New Instance failure: xsdPath is null");
        }
        InputStream is = null;
        try {
            File f = new File(xsdPath);
            if (f.exists()) {
                is = new FileInputStream(f);
            } else {
                is = cXmlRoot.getResourceAsStream(xsdPath);
                if (is == null) {
                    is = cXmlRoot.getResourceAsStream("/" + xsdPath);
                }
            }
            if (is == null) {
                throw new Exception("Creating InputStream from xsdPath[" + xsdPath + "] failure");
            }
            this.xsdValidator = new ValidatoreXSD(null, is);
        }
        catch (Exception e) {
            this.log.error("Init xsd schema failure: " + e.getMessage(), (Throwable)e);
            throw new ServiceException("Init xsd schema failure: " + e.getMessage(), e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        this.cXmlRoot = cXmlRoot;
        this.deserializer = deserializer;
        this.parsingXML();
    }

    public void refreshXML() throws ServiceException {
        this.refreshXML_engine(false);
    }

    public void refreshXML(boolean forcedWithoutCheckModified) throws ServiceException {
        this.refreshXML_engine(forcedWithoutCheckModified);
    }

    private synchronized void refreshXML_engine(boolean forcedWithoutCheckModified) throws ServiceException {
        File fTest = null;
        boolean refresh = forcedWithoutCheckModified;
        if (!forcedWithoutCheckModified) {
            if (this.xmlPath.startsWith("http://") || this.xmlPath.startsWith("file://")) {
                long now = System.currentTimeMillis();
                if (now - this.lastModified > 30000L) {
                    refresh = true;
                }
            } else {
                fTest = new File(this.xmlPath);
                if (this.lastModified != fTest.lastModified()) {
                    refresh = true;
                }
            }
        }
        if (refresh) {
            try {
                this.parsingXML();
            }
            catch (Exception e) {
                this.log.error("Refresh failure: " + e.getMessage(), (Throwable)e);
                throw new ServiceException("Refresh failure: " + e.getMessage(), e);
            }
            if (!this.xmlPath.startsWith("http://") && !this.xmlPath.startsWith("file://")) {
                this.log.warn("Reloaded context.");
            }
        }
        if (this.rootXml == null) {
            this.log.error("Refresh failure: rootXml is null after the refresh");
            throw new ServiceException("Refresh failure: rootXml is null after the refresh");
        }
    }

    public void checkRemoteXML() throws ServiceException {
        if (this.xmlPath.startsWith("http://")) {
            throw new ServiceException("You can not use the CRUD service with a remote XML");
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public XML getRootXml() {
        return this.rootXml;
    }

    public static void configureDefaultLog4jProperties(IProjectInfo project) throws ServiceException {
        XMLLoggerProperties loggerProperties = new XMLLoggerProperties(project);
        loggerProperties.configureLog4j();
    }

    public static void configureLog4jProperties(File log4jProperties) throws ServiceException {
        XMLLoggerProperties loggerProperties = new XMLLoggerProperties(null, log4jProperties);
        loggerProperties.configureLog4j();
    }
}

