/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;

public class UnionExpression {
    private IExpression expression;
    private Map<String, Object> returnFieldMap = new HashMap<String, Object>();
    private List<String> keys = new ArrayList<String>();

    public UnionExpression(IExpression expression) {
        this.expression = expression;
    }

    public UnionExpression(IPaginatedExpression paginatedExpression) {
        this.expression = paginatedExpression;
    }

    public void addSelectField(IField field, String alias) throws ExpressionException {
        if (this.returnFieldMap.containsKey(alias)) {
            throw new ExpressionException("Alias [" + alias + "] already used");
        }
        this.returnFieldMap.put(alias, field);
        this.keys.add(alias);
    }

    public void addSelectFunctionField(FunctionField functionField) throws ExpressionException {
        String alias = functionField.getAlias();
        if (this.returnFieldMap.containsKey(alias)) {
            throw new ExpressionException("Alias [" + alias + "] already used");
        }
        this.returnFieldMap.put(alias, functionField);
        this.keys.add(alias);
    }

    public IExpression getExpression() {
        return this.expression;
    }

    public List<String> getReturnFieldAliases() {
        return this.keys;
    }

    public Object getReturnField(String alias) {
        return this.returnFieldMap.get(alias);
    }
}

