/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.wssecurity;

import java.util.Hashtable;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.ws.axis.security.WSDoAllSender;
import org.openspcoop.wssecurity.WSSBaseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSSender {
    private String msgErrore;
    private String codiceErrore;
    private WSSBaseUtils baseUtilsWSS;

    public WSSSender(Hashtable<?, ?> wssProperties, WSSBaseUtils baseWSS) {
        this.baseUtilsWSS = baseWSS;
        this.baseUtilsWSS.setMessageContext(wssProperties);
    }

    public boolean process(Message axisMessage) {
        try {
            if (this.baseUtilsWSS.getMessageContext() != null) {
                this.baseUtilsWSS.getMessageContext().setCurrentMessage(axisMessage);
                WSDoAllSender sender = new WSDoAllSender();
                sender.invoke(this.baseUtilsWSS.getMessageContext());
            }
        }
        catch (AxisFault af) {
            this.msgErrore = "Generatosi errore durante il processamento WS-Security(Sender) [code: " + af.getFaultCode() + "]\n" + af.getFaultString();
            this.codiceErrore = "EGOV_IT_200";
            return false;
        }
        catch (Exception e) {
            this.msgErrore = "Generatosi errore durante il processamento WS-Security(Sender): " + e.getMessage();
            this.codiceErrore = "EGOV_IT_200";
            return false;
        }
        return true;
    }

    public String getMsgErrore() {
        return this.msgErrore;
    }

    public String getCodiceErrore() {
        return this.codiceErrore;
    }
}

