/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.wssecurity;

import java.security.Principal;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.ws.axis.security.WSDoAllReceiver;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.handler.WSHandlerResult;
import org.openspcoop.egov.Busta;
import org.openspcoop.wssecurity.Authorization;
import org.openspcoop.wssecurity.WSDoAllReceiverNoActionOrderCheck;
import org.openspcoop.wssecurity.WSSBaseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSReceiver {
    private String msgErrore;
    private String codiceErrore;
    private WSSBaseUtils baseUtilsWSS;
    private String subject;

    public WSSReceiver(Hashtable<?, ?> wssProperties, WSSBaseUtils baseWSS) {
        this.baseUtilsWSS = baseWSS;
        this.baseUtilsWSS.setMessageContext(wssProperties);
    }

    public boolean process(Message axisMessage, Busta busta) {
        block11: {
            try {
                if (this.baseUtilsWSS.getMessageContext() == null) break block11;
                this.baseUtilsWSS.getMessageContext().setCurrentMessage(axisMessage);
                String authClass = (String)this.baseUtilsWSS.getMessageContext().getProperty("authorizationClass");
                String actor = (String)this.baseUtilsWSS.getMessageContext().getProperty("actor");
                String mustUnderstand = (String)this.baseUtilsWSS.getMessageContext().getProperty("mustUnderstand");
                String actionOrderCheck = (String)this.baseUtilsWSS.getMessageContext().getProperty("actionOrderCheck");
                WSDoAllReceiverNoActionOrderCheck recever = null;
                recever = actionOrderCheck != null && actionOrderCheck.equalsIgnoreCase("true") ? new WSDoAllReceiver() : new WSDoAllReceiverNoActionOrderCheck();
                if (actor != null) {
                    recever.setOption("actor", actor);
                }
                recever.invoke(this.baseUtilsWSS.getMessageContext());
                try {
                    this.subject = this.getPrincipal(actor);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (authClass != null) {
                    try {
                        Class<?> cl = Class.forName(authClass);
                        Authorization auth = (Authorization)cl.newInstance();
                        boolean status = auth.authorize(this.subject, busta);
                        if (!status) {
                            this.msgErrore = auth.getMessaggioErrore() != null ? auth.getMessaggioErrore() : "Mittente della busta [" + busta.getTipoMittente() + busta.getMittente() + "] (subject:" + this.subject + ") non autorizzato ad invocare il servizio [" + busta.getServizio() + "] erogato dal soggetto [" + busta.getTipoDestinatario() + busta.getDestinatario() + "]";
                            this.codiceErrore = "EGOV_IT_201";
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new AxisFault("Errore di Processamento durante l'autorizzazione: " + e.getMessage());
                    }
                }
                SOAPEnvelope envelope = axisMessage.getSOAPEnvelope();
                boolean mustUnderstandValue = Boolean.parseBoolean(mustUnderstand);
                String actorDaPulire = actor;
                if ("".equals(actor)) {
                    actorDaPulire = null;
                }
                this.clean(envelope, actorDaPulire, mustUnderstandValue);
            }
            catch (AxisFault af) {
                this.msgErrore = "Generatosi errore durante il processamento WS-Security(Receiver) [code: " + af.getFaultCode() + "]\n" + af.getFaultString();
                this.codiceErrore = af.getFaultString() != null && af.getFaultString().contains("The signature or decryption was invalid") ? "EGOV_IT_202" : "EGOV_IT_200";
                return false;
            }
            catch (Exception e) {
                this.msgErrore = "Generatosi errore durante il processamento WS-Security(Receiver): " + e.getMessage();
                this.codiceErrore = "EGOV_IT_200";
                return false;
            }
        }
        return true;
    }

    public String getMsgErrore() {
        return this.msgErrore;
    }

    public String getCodiceErrore() {
        return this.codiceErrore;
    }

    public String getActor() {
        return this.baseUtilsWSS.getActor();
    }

    public void clean(SOAPEnvelope envelope, String actor, boolean mustUnderstand) throws AxisFault {
        try {
            SOAPHeader header = (SOAPHeader)envelope.getHeader();
            Iterator it = header.getChildElements();
            SOAPHeaderElement elementWSS = null;
            int countWSSHeader = 0;
            while (it.hasNext()) {
                SOAPHeaderElement elementInVerifica = (SOAPHeaderElement)it.next();
                if (!"Security".equals(elementInVerifica.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(elementInVerifica.getNamespaceURI())) continue;
                ++countWSSHeader;
                if (actor == null) {
                    if (elementInVerifica.getActor() != null || mustUnderstand != elementInVerifica.getMustUnderstand()) continue;
                    elementWSS = elementInVerifica;
                    continue;
                }
                if (!actor.equals(elementInVerifica.getActor()) || mustUnderstand != elementInVerifica.getMustUnderstand()) continue;
                elementWSS = elementInVerifica;
            }
            if (elementWSS == null) {
                throw new AxisFault("cleanWSS: header WSS gestito non trovato.");
            }
            header.removeChild(elementWSS);
            if (countWSSHeader == 1) {
                SOAPBody body = (SOAPBody)envelope.getBody();
                body.removeAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                body.removeNamespaceDeclaration("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AxisFault("Errore di Processamento: " + e.getMessage());
        }
    }

    public String getPrincipal(String actor) {
        MessageContext msgContext = this.baseUtilsWSS.getMessageContext();
        String principal = null;
        Vector results = (Vector)msgContext.getProperty("RECV_RESULTS");
        for (int i = 0; results != null && i < results.size(); ++i) {
            int actionGet;
            WSSecurityEngineResult eResult;
            int j;
            Vector hResults;
            WSHandlerResult hResult = (WSHandlerResult)results.get(i);
            if (actor != null) {
                if (hResult.getActor().compareTo(actor) != 0) continue;
                hResults = hResult.getResults();
                for (j = 0; j < hResults.size(); ++j) {
                    eResult = (WSSecurityEngineResult)hResults.get(j);
                    actionGet = (Integer)eResult.get((Object)"action");
                    if (actionGet != 2 && actionGet != 1) continue;
                    principal = ((Principal)eResult.get((Object)"principal")).getName();
                }
                continue;
            }
            hResults = hResult.getResults();
            for (j = 0; j < hResults.size(); ++j) {
                eResult = (WSSecurityEngineResult)hResults.get(j);
                actionGet = (Integer)eResult.get((Object)"action");
                if (actionGet != 2 && actionGet != 1) continue;
                principal = ((Principal)eResult.get((Object)"principal")).getName();
            }
        }
        return principal;
    }

    public String getSubject() {
        return this.subject;
    }
}

