/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.wssecurity;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.server.AxisServer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSBaseUtils {
    private MessageContext messageContext;
    private String actor = null;
    private String actorDefault = null;
    private boolean useActorDefaultIfNotDefined = true;
    public static final String WSS_HEADER_ELEMENT = "Security";
    public static final String WSS_HEADER_ELEMENT_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";

    public WSSBaseUtils(AxisClient engine, boolean useActorDefaultIfNotDefined, String actorDefault) {
        this.messageContext = new MessageContext((AxisEngine)engine);
        this.messageContext.setProperty("disablePrettyXML", (Object)true);
        this.useActorDefaultIfNotDefined = useActorDefaultIfNotDefined;
        this.actorDefault = actorDefault;
    }

    public WSSBaseUtils(AxisServer engine, boolean useActorDefaultIfNotDefined, String actorDefault) {
        this.messageContext = new MessageContext((AxisEngine)engine);
        this.messageContext.setProperty("disablePrettyXML", (Object)true);
        this.useActorDefaultIfNotDefined = useActorDefaultIfNotDefined;
        this.actorDefault = actorDefault;
    }

    public void setMessageContext(Hashtable<?, ?> wssProperties) {
        boolean actor = false;
        boolean mustUnderstandTrue = false;
        if (wssProperties != null && wssProperties.size() > 0) {
            Enumeration<?> e = wssProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)wssProperties.get(key);
                if (!"encryptionUser".equals(key) || "useReqSigCert".equals(value)) {
                    // empty if block
                }
                this.messageContext.setProperty(key, (Object)value);
                if ("actor".equals(key)) {
                    this.actor = value;
                }
                if ("mustUnderstand".equals(key)) {
                    if (!"true".equals(value)) continue;
                    mustUnderstandTrue = true;
                    continue;
                }
                if (!"actor".equals(key)) continue;
                actor = true;
            }
        }
        if (mustUnderstandTrue && !actor && this.useActorDefaultIfNotDefined) {
            if (this.actorDefault != null) {
                this.messageContext.setProperty("actor", (Object)this.actorDefault);
            } else {
                this.messageContext.setProperty("actor", (Object)"openspcoop");
            }
        }
    }

    protected MessageContext getMessageContext() {
        return this.messageContext;
    }

    public String getActor() {
        return this.actor;
    }

    public static boolean existsHeaderWSS(SOAPMessage msg, String actor) {
        return WSSBaseUtils.existsHeaderWSS(msg, actor, null);
    }

    public static boolean existsHeaderWSS(SOAPMessage msg, String actor, Logger log) {
        try {
            if (msg == null) {
                return false;
            }
            SOAPHeader header = msg.getSOAPHeader();
            if (header == null || !header.hasChildNodes()) {
                return false;
            }
            Iterator it = header.examineAllHeaderElements();
            while (it.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                if (!WSS_HEADER_ELEMENT.equals(headerElement.getLocalName()) || !WSS_HEADER_ELEMENT_NAMESPACE.equals(headerElement.getNamespaceURI())) continue;
                if (actor == null) {
                    return headerElement.getActor() == null;
                }
                return actor.equals(headerElement.getActor());
            }
            return false;
        }
        catch (Exception e) {
            if (log != null) {
                log.error((Object)("existsHeaderWSS error con actor[" + actor + "]"), (Throwable)e);
            }
            return false;
        }
    }

    public boolean isUseActorDefaultIfNotDefined() {
        return this.useActorDefaultIfNotDefined;
    }

    public void setUseActorDefaultIfNotDefined(boolean useActorDefaultIfNotDefined) {
        this.useActorDefaultIfNotDefined = useActorDefaultIfNotDefined;
    }
}

