/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.wssecurity;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.ws.axis.security.WSDoAllReceiver;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.WSSecurityUtil;
import org.openspcoop.utils.date.DateManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDoAllReceiverNoActionOrderCheck
extends WSDoAllReceiver {
    private static final long serialVersionUID = 1L;
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");

    public void invoke(MessageContext msgContext) throws AxisFault {
        boolean doDebug = WSDoAllReceiver.log.isDebugEnabled();
        if (doDebug) {
            try {
                WSDoAllReceiver.log.debug((Object)("WSDoAllReceiverNoActionOrderCheck: enter invoke() with msg type: " + msgContext.getCurrentMessage().getMessageType()));
            }
            catch (Exception e) {
                WSDoAllReceiver.log.debug((Object)"Errore WSDoAllReceiverNoActionOrderCheck", (Throwable)e);
            }
        }
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = DateManager.getTimeMillis();
        }
        RequestData reqData = new RequestData();
        try {
            Timestamp timestamp;
            X509Certificate returnCert;
            reqData.setMsgContext((Object)msgContext);
            Vector actions = new Vector();
            String action = null;
            action = (String)this.getOption("action");
            if (action == null) {
                action = (String)msgContext.getProperty("action");
            }
            if (action == null) {
                throw new AxisFault("WSDoAllReceiverNoActionOrderCheck: No action defined");
            }
            int doAction = WSSecurityUtil.decodeAction((String)action, actions);
            String actor = (String)this.getOption("actor");
            Message sm = msgContext.getCurrentMessage();
            Document doc = null;
            if (sm == null) {
                return;
            }
            try {
                doc = sm.getSOAPEnvelope().getAsDocument();
                if (doDebug) {
                    WSDoAllReceiver.log.debug((Object)"Received SOAP request: ");
                    WSDoAllReceiver.log.debug((Object)XMLUtils.PrettyDocumentToString((Document)doc));
                }
            }
            catch (Exception ex) {
                throw new AxisFault("WSDoAllReceiverNoActionOrderCheck: cannot convert into document", (Throwable)ex);
            }
            String msgType = sm.getMessageType();
            if (msgType != null && msgType.equals("response")) {
                SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
                if (WSSecurityUtil.findElement((Node)doc.getDocumentElement(), (String)"Fault", (String)soapConstants.getEnvelopeURI()) != null) {
                    return;
                }
            }
            CallbackHandler cbHandler = null;
            if ((doAction & 5) != 0) {
                cbHandler = this.getPasswordCB(reqData);
            }
            this.doReceiverAction(doAction, reqData);
            Vector wsResult = null;
            if (tlog.isDebugEnabled()) {
                t1 = DateManager.getTimeMillis();
            }
            try {
                wsResult = WSHandler.secEngine.processSecurityHeader(doc, actor, cbHandler, reqData.getSigCrypto(), reqData.getDecCrypto());
            }
            catch (WSSecurityException ex) {
                ex.printStackTrace();
                throw new AxisFault("WSDoAllReceiverNoActionOrderCheck: security processing failed", (Throwable)ex);
            }
            if (tlog.isDebugEnabled()) {
                t2 = DateManager.getTimeMillis();
            }
            if (wsResult == null) {
                if (doAction == 0) {
                    return;
                }
                throw new AxisFault("WSDoAllReceiverNoActionOrderCheck: Request does not contain required Security header");
            }
            if (reqData.getWssConfig().isEnableSignatureConfirmation() && msgContext.getPastPivot()) {
                this.checkSignatureConfirmation(reqData, wsResult);
            }
            ArrayList<QName> processedHeaders = new ArrayList<QName>();
            for (SOAPHeaderElement tempHeader : sm.getSOAPEnvelope().getHeaders()) {
                if (!tempHeader.isProcessed()) continue;
                processedHeaders.add(tempHeader.getQName());
            }
            SOAPPart sPart = (SOAPPart)sm.getSOAPPart();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            org.apache.xml.security.utils.XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
            sPart.setCurrentMessage((Object)os.toByteArray(), 4);
            if (doDebug) {
                WSDoAllReceiver.log.debug((Object)"Processed received SOAP request");
                WSDoAllReceiver.log.debug((Object)XMLUtils.PrettyDocumentToString((Document)doc));
            }
            if (tlog.isDebugEnabled()) {
                t3 = DateManager.getTimeMillis();
            }
            for (QName qname : processedHeaders) {
                Enumeration headersByName = sm.getSOAPEnvelope().getHeadersByName(qname.getNamespaceURI(), qname.getLocalPart());
                while (headersByName.hasMoreElements()) {
                    SOAPHeaderElement tempHeader = (SOAPHeaderElement)headersByName.nextElement();
                    tempHeader.setProcessed(true);
                }
            }
            SOAPHeader sHeader = null;
            try {
                sHeader = sm.getSOAPEnvelope().getHeader();
            }
            catch (Exception ex) {
                throw new AxisFault("WSDoAllReceiverNoActionOrderCheck: cannot get SOAP header after security processing", (Throwable)ex);
            }
            Iterator headers = sHeader.examineHeaderElements(actor);
            SOAPHeaderElement headerElement = null;
            while (headers.hasNext()) {
                SOAPHeaderElement hE = (SOAPHeaderElement)headers.next();
                if (!hE.getLocalName().equals("Security") || !hE.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) continue;
                headerElement = hE;
                break;
            }
            ((SOAPHeaderElement)headerElement).setProcessed(true);
            WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult((Vector)wsResult, (int)2);
            if (actionResult != null && (returnCert = (X509Certificate)actionResult.get((Object)"x509-certificate")) != null && !this.verifyTrust(returnCert, reqData)) {
                throw new AxisFault("WSDoAllReceiverNoActionOrderCheck: The certificate used for the signature is not trusted");
            }
            actionResult = WSSecurityUtil.fetchActionResult((Vector)wsResult, (int)32);
            if (actionResult != null && (timestamp = (Timestamp)actionResult.get((Object)"timestamp")) != null && !this.verifyTimestamp(timestamp, this.decodeTimeToLive(reqData))) {
                throw new AxisFault("WSDoAllReceiverNoActionOrderCheck: The timestamp could not be validated");
            }
            Vector<WSHandlerResult> results = null;
            results = (Vector<WSHandlerResult>)msgContext.getProperty("RECV_RESULTS");
            if (results == null) {
                results = new Vector<WSHandlerResult>();
                msgContext.setProperty("RECV_RESULTS", results);
            }
            WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
            results.add(0, rResult);
            if (tlog.isDebugEnabled()) {
                t4 = DateManager.getTimeMillis();
                tlog.debug((Object)("Receive request: total= " + (t4 - t0) + " request preparation= " + (t1 - t0) + " request processing= " + (t2 - t1) + " request to Axis= " + (t3 - t2) + " header, cert verify, timestamp= " + (t4 - t3) + "\n"));
            }
            if (doDebug) {
                WSDoAllReceiver.log.debug((Object)"WSDoAllReceiverNoActionOrderCheck: exit invoke()");
            }
        }
        catch (WSSecurityException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }
}

