/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.registry;

import java.util.Date;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.IMonitoraggioRisorsa;
import org.openspcoop.dao.config.AccessoRegistro;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.Azione;
import org.openspcoop.dao.registry.Connettore;
import org.openspcoop.dao.registry.Fruitore;
import org.openspcoop.dao.registry.Operation;
import org.openspcoop.dao.registry.PortType;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.ServizioSpcoopAzione;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziAzioneNotFound;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziPortTypeNotFound;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.WSDLAccordoServizio;
import org.openspcoop.egov.RisultatoValidazione;
import org.openspcoop.egov.ServizioEGov;
import org.openspcoop.registry.RegistroServizi;
import org.openspcoop.utils.date.DateManager;

public class RegistroServiziReader {
    private static RegistroServiziReader registroServiziReader;
    private static boolean initialize;
    private RegistroServizi registroServizi;
    private Logger log = null;

    public static void resetCache() throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.resetCache();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Reset della cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void abilitaCache() throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.abilitaCache();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Abilitazione cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void abilitaCache(long dimensioneCache, boolean algoritmoCacheLRU, long itemIdleTime, long itemLifeSecond) throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.abilitaCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Abilitazione cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void disabilitaCache() throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.disabilitaCache();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Disabilitazione cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean initialize(AccessoRegistro accessoRegistro, Logger aLog, Logger aLogconsole, boolean raggiungibilitaTotale, boolean readObjectStatoBozza) {
        try {
            registroServiziReader = new RegistroServiziReader(accessoRegistro, aLog, aLogconsole, raggiungibilitaTotale, readObjectStatoBozza);
            return initialize;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInitialize() {
        return initialize;
    }

    public static RegistroServiziReader getInstance() {
        return registroServiziReader;
    }

    public RegistroServiziReader(AccessoRegistro accessoRegistro, Logger aLog, Logger aLogconsole, boolean raggiungibilitaTotale, boolean readObjectStatoBozza) throws DriverRegistroServiziException {
        try {
            this.log = aLog != null ? aLog : Logger.getLogger((String)"Registro dei Servizi di OpenSPCoop");
            this.registroServizi = new RegistroServizi(accessoRegistro, this.log, aLogconsole, raggiungibilitaTotale, readObjectStatoBozza);
            initialize = true;
        }
        catch (Exception e) {
            initialize = false;
        }
    }

    public void isAlive(boolean controlloTotale) throws DriverException {
        if (controlloTotale) {
            Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
            while (en.hasMoreElements()) {
                String nomeRegInLista = en.nextElement();
                try {
                    IMonitoraggioRisorsa monitorDriver = (IMonitoraggioRisorsa)this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
                    monitorDriver.isAlive();
                }
                catch (Exception e) {
                    throw new DriverException("[Registro " + nomeRegInLista + "] " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            boolean registroRaggiungibile = false;
            StringBuffer eccezioni = new StringBuffer();
            Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
            while (en.hasMoreElements()) {
                String nomeRegInLista = en.nextElement();
                try {
                    IMonitoraggioRisorsa monitorDriver = (IMonitoraggioRisorsa)this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
                    monitorDriver.isAlive();
                    registroRaggiungibile = true;
                    break;
                }
                catch (Exception e) {
                    this.log.debug((Object)("Registro non accessibile [Registro " + nomeRegInLista + "]"), (Throwable)e);
                    eccezioni.append("\n[Registro " + nomeRegInLista + "] " + e.getMessage());
                }
            }
            if (!registroRaggiungibile) {
                throw new DriverException(eccezioni.toString());
            }
        }
    }

    public String getProfiloGestioneFruizioneServizio(IDServizio idServizio, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        SoggettoSpcoop soggettoErogatore;
        String profilo = null;
        ServizioSpcoop servizio = null;
        try {
            servizio = this.registroServizi.getServizio(nomeRegistro, idServizio);
        }
        catch (DriverRegistroServiziNotFound e) {
            // empty catch block
        }
        if (servizio == null) {
            try {
                servizio = this.registroServizi.getServizioCorrelato(nomeRegistro, idServizio);
            }
            catch (DriverRegistroServiziNotFound e) {
                // empty catch block
            }
        }
        if (servizio != null) {
            profilo = "eGov1.1";
            if (servizio.getProfilo() != null) {
                if ("eGov1.1-lineeGuida1.1".equals(servizio.getProfilo())) {
                    profilo = servizio.getProfilo();
                }
            } else {
                soggettoErogatore = this.registroServizi.getSoggetto(nomeRegistro, idServizio.getSoggettoErogatore());
                if (soggettoErogatore == null) {
                    throw new DriverRegistroServiziNotFound("getProfiloGestioneFruizioneServizio, soggettoErogatore [" + idServizio.getSoggettoErogatore() + "] non definito (o non registrato)");
                }
                if (soggettoErogatore.getProfilo() != null && "eGov1.1-lineeGuida1.1".equals(soggettoErogatore.getProfilo())) {
                    profilo = soggettoErogatore.getProfilo();
                }
            }
        } else {
            soggettoErogatore = this.registroServizi.getSoggetto(nomeRegistro, idServizio.getSoggettoErogatore());
            if (soggettoErogatore == null) {
                throw new DriverRegistroServiziNotFound("getProfiloGestioneFruizioneServizio, soggettoErogatore [" + idServizio.getSoggettoErogatore() + "] non definito (o non registrato)");
            }
            if (soggettoErogatore.getProfilo() != null && "eGov1.1-lineeGuida1.1".equals(soggettoErogatore.getProfilo())) {
                profilo = soggettoErogatore.getProfilo();
            }
        }
        return profilo;
    }

    public String getProfiloGestioneErogazioneServizio(IDSoggetto idFruitore, IDServizio idServizio, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String profilo = null;
        ServizioSpcoop servizio = null;
        try {
            servizio = this.registroServizi.getServizio(nomeRegistro, idServizio);
        }
        catch (DriverRegistroServiziNotFound e) {
            // empty catch block
        }
        if (servizio == null) {
            try {
                servizio = this.registroServizi.getServizioCorrelato(nomeRegistro, idServizio);
            }
            catch (DriverRegistroServiziNotFound e) {
                // empty catch block
            }
        }
        if (servizio != null) {
            Fruitore fruitore = null;
            if (idFruitore == null || idFruitore.getTipo() == null || idFruitore.getNome() == null) {
                throw new DriverRegistroServiziException("getProfiloGestioneErogazioneServizio, soggetto fruitore non definito");
            }
            for (int i = 0; i < servizio.sizeFruitoreList(); ++i) {
                Fruitore tmp = servizio.getFruitore(i);
                if (!idFruitore.getTipo().equals(tmp.getTipo()) || !idFruitore.getNome().equals(tmp.getNome())) continue;
                fruitore = tmp;
                break;
            }
            profilo = "eGov1.1";
            if (fruitore != null && fruitore.getProfilo() != null) {
                if ("eGov1.1-lineeGuida1.1".equals(fruitore.getProfilo())) {
                    profilo = fruitore.getProfilo();
                }
            } else {
                SoggettoSpcoop soggettoFruitore = this.registroServizi.getSoggetto(nomeRegistro, idFruitore);
                if (soggettoFruitore == null) {
                    throw new DriverRegistroServiziNotFound("getProfiloGestioneErogazioneServizio, soggettoFruitore [" + idFruitore + "] non definito (o non registrato)");
                }
                if (soggettoFruitore.getProfilo() != null && "eGov1.1-lineeGuida1.1".equals(soggettoFruitore.getProfilo())) {
                    profilo = soggettoFruitore.getProfilo();
                }
            }
        } else {
            SoggettoSpcoop soggettoFruitore = this.registroServizi.getSoggetto(nomeRegistro, idFruitore);
            if (soggettoFruitore == null) {
                throw new DriverRegistroServiziNotFound("getProfiloGestioneErogazioneServizio, soggettoFruitore [" + idFruitore + "] non definito (o non registrato)");
            }
            if (soggettoFruitore.getProfilo() != null && "eGov1.1-lineeGuida1.1".equals(soggettoFruitore.getProfilo())) {
                profilo = soggettoFruitore.getProfilo();
            }
        }
        return profilo;
    }

    public String getProfiloGestioneSoggetto(IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String profilo = "eGov1.1";
        SoggettoSpcoop soggetto = this.registroServizi.getSoggetto(nomeRegistro, idSoggetto);
        if (idSoggetto == null) {
            throw new DriverRegistroServiziNotFound("getProfiloGestioneSoggetto, Soggetto [" + idSoggetto + "] non definito (o non registrato)");
        }
        if (soggetto.getProfilo() != null && "eGov1.1-lineeGuida1.1".equals(soggetto.getProfilo())) {
            profilo = soggetto.getProfilo();
        }
        return profilo;
    }

    public ServizioEGov getInfoServizio(IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound {
        return this.getInfoServizio(false, false, idSoggetto, idService, nomeRegistro);
    }

    public ServizioEGov getInfoServizioCorrelato(IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound {
        return this.getInfoServizio(true, false, idSoggetto, idService, nomeRegistro);
    }

    public ServizioEGov getInfoServizioAzioneCorrelata(IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound {
        return this.getInfoServizio(false, true, idSoggetto, idService, nomeRegistro);
    }

    private ServizioEGov getInfoServizio(boolean servizioCorrelato, boolean azioneCorrelata, IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound {
        long now;
        Date nowDate;
        ServizioEGov infoServizio = new ServizioEGov();
        ServizioSpcoop servizio = null;
        servizio = servizioCorrelato ? this.registroServizi.getServizioCorrelato(nomeRegistro, idService) : this.registroServizi.getServizio(nomeRegistro, idService);
        if (servizio == null) {
            throw new DriverRegistroServiziNotFound("getInfoServizio, servizio non definito");
        }
        String azione = idService.getAzione();
        if (azioneCorrelata && azione == null) {
            throw new DriverRegistroServiziException("getInfoServizio, azione e' obbligatoria in questa modalita' di ricerca");
        }
        String uriAccordo = servizio.getAccordoServizio();
        if (uriAccordo == null) {
            throw new DriverRegistroServiziException("URIAccordo del servizio is null");
        }
        IDAccordo idAccordo = IDAccordo.getIDAccordoFromUri((String)uriAccordo);
        AccordoServizio as = this.registroServizi.getAccordoServizio(nomeRegistro, idAccordo);
        if (as == null) {
            throw new DriverRegistroServiziNotFound("getInfoServizio, accordo di servizio [" + uriAccordo + "] non definito (o non registrato)");
        }
        PortType pt = null;
        if (servizio.getPortType() != null) {
            for (int i = 0; i < as.sizePortTypeList(); ++i) {
                if (!servizio.getPortType().equals(as.getPortType(i).getNome())) continue;
                pt = as.getPortType(i);
            }
            if (pt == null) {
                throw new DriverRegistroServiziPortTypeNotFound("Port-Type [" + servizio.getPortType() + "] associato al servizio non definito nell'accordo di servizio " + uriAccordo);
            }
        }
        Azione az = null;
        Operation ptAz = null;
        if (azione == null) {
            if (pt != null) {
                throw new DriverRegistroServiziAzioneNotFound("invocazione senza la definizione di una azione non permessa per il port-type " + pt.getNome() + " dell'accordo di servizio " + uriAccordo);
            }
            if (!as.getUtilizzoSenzaAzione()) {
                throw new DriverRegistroServiziAzioneNotFound("invocazione senza la definizione di una azione non permessa per l'accordo di servizio " + uriAccordo);
            }
        } else {
            int i;
            boolean find = false;
            if (pt != null) {
                for (i = 0; i < pt.sizeAzioneList(); ++i) {
                    if (!azione.equals(pt.getAzione(i).getNome())) continue;
                    ptAz = pt.getAzione(i);
                    find = true;
                    break;
                }
                if (!find) {
                    throw new DriverRegistroServiziAzioneNotFound("azione non trovata nel port-type " + pt.getNome() + " dell'accordo di servizio " + uriAccordo);
                }
            } else {
                for (i = 0; i < as.sizeAzioneList(); ++i) {
                    if (!azione.equals(as.getAzione(i).getNome())) continue;
                    az = as.getAzione(i);
                    find = true;
                    break;
                }
                if (!find) {
                    throw new DriverRegistroServiziAzioneNotFound("azione non trovata nell'accordo di servizio " + uriAccordo);
                }
            }
        }
        infoServizio.setIDServizio(idService);
        if (as.getProfiloCollaborazione() == null) {
            infoServizio.setProfiloDiCollaborazione("EGOV_IT_MessaggioSingoloOneWay");
        } else if (as.getProfiloCollaborazione().equalsIgnoreCase("oneway")) {
            infoServizio.setProfiloDiCollaborazione("EGOV_IT_MessaggioSingoloOneWay");
        } else if (as.getProfiloCollaborazione().equalsIgnoreCase("sincrono")) {
            infoServizio.setProfiloDiCollaborazione("EGOV_IT_ServizioSincrono");
        } else if (as.getProfiloCollaborazione().equalsIgnoreCase("asincronoSimmetrico")) {
            infoServizio.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoSimmetrico");
        } else if (as.getProfiloCollaborazione().equalsIgnoreCase("asincronoAsimmetrico")) {
            infoServizio.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoAsimmetrico");
        } else {
            infoServizio.setProfiloDiCollaborazione("EGOV_IT_MessaggioSingoloOneWay");
        }
        if (as.getIdCollaborazione() == null) {
            infoServizio.setCollaborazione(false);
        } else if (as.getIdCollaborazione().equalsIgnoreCase("disabilitato")) {
            infoServizio.setCollaborazione(false);
        } else if (as.getIdCollaborazione().equalsIgnoreCase("abilitato")) {
            infoServizio.setCollaborazione(true);
        } else {
            infoServizio.setCollaborazione(false);
        }
        if (as.getConsegnaInOrdine() == null) {
            infoServizio.setOrdineConsegna(false);
        } else if (as.getConsegnaInOrdine().equalsIgnoreCase("disabilitato")) {
            infoServizio.setOrdineConsegna(false);
        } else if (as.getConsegnaInOrdine().equalsIgnoreCase("abilitato")) {
            infoServizio.setOrdineConsegna(true);
        } else {
            infoServizio.setOrdineConsegna(false);
        }
        if (as.getConfermaRicezione() == null) {
            infoServizio.setConfermaRicezione(false);
        } else if (as.getConfermaRicezione().equalsIgnoreCase("disabilitato")) {
            infoServizio.setConfermaRicezione(false);
        } else if (as.getConfermaRicezione().equalsIgnoreCase("abilitato")) {
            infoServizio.setConfermaRicezione(true);
        } else {
            infoServizio.setConfermaRicezione(false);
        }
        if (as.getFiltroDuplicati() == null) {
            infoServizio.setInoltro("EGOV_IT_PIUDIUNAVOLTA");
        } else if (as.getFiltroDuplicati().equalsIgnoreCase("disabilitato")) {
            infoServizio.setInoltro("EGOV_IT_PIUDIUNAVOLTA");
        } else if (as.getFiltroDuplicati().equalsIgnoreCase("abilitato")) {
            infoServizio.setInoltro("EGOV_IT_ALPIUUNAVOLTA");
        } else {
            infoServizio.setInoltro("EGOV_IT_PIUDIUNAVOLTA");
        }
        if (as.getScadenza() != null) {
            try {
                long minuti = Long.parseLong(as.getScadenza());
                nowDate = DateManager.getDate();
                now = nowDate.getTime();
                nowDate.setTime(now += minuti * 60L * 1000L);
                infoServizio.setScadenza(nowDate);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (pt != null) {
            if (pt.getProfiloCollaborazione() != null) {
                if (pt.getProfiloCollaborazione().equalsIgnoreCase("oneway")) {
                    infoServizio.setProfiloDiCollaborazione("EGOV_IT_MessaggioSingoloOneWay");
                } else if (pt.getProfiloCollaborazione().equalsIgnoreCase("sincrono")) {
                    infoServizio.setProfiloDiCollaborazione("EGOV_IT_ServizioSincrono");
                } else if (pt.getProfiloCollaborazione().equalsIgnoreCase("asincronoSimmetrico")) {
                    infoServizio.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoSimmetrico");
                } else if (pt.getProfiloCollaborazione().equalsIgnoreCase("asincronoAsimmetrico")) {
                    infoServizio.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoAsimmetrico");
                }
            }
            if (pt.getIdCollaborazione() != null) {
                if (pt.getIdCollaborazione().equalsIgnoreCase("disabilitato")) {
                    infoServizio.setCollaborazione(false);
                } else if (pt.getIdCollaborazione().equalsIgnoreCase("abilitato")) {
                    infoServizio.setCollaborazione(true);
                }
            }
            if (pt.getConsegnaInOrdine() != null) {
                if (pt.getConsegnaInOrdine().equalsIgnoreCase("disabilitato")) {
                    infoServizio.setOrdineConsegna(false);
                } else if (pt.getConsegnaInOrdine().equalsIgnoreCase("abilitato")) {
                    infoServizio.setOrdineConsegna(true);
                }
            }
            if (pt.getConfermaRicezione() != null) {
                if (pt.getConfermaRicezione().equalsIgnoreCase("disabilitato")) {
                    infoServizio.setConfermaRicezione(false);
                } else if (pt.getConfermaRicezione().equalsIgnoreCase("abilitato")) {
                    infoServizio.setConfermaRicezione(true);
                }
            }
            if (pt.getFiltroDuplicati() != null) {
                if (pt.getFiltroDuplicati().equalsIgnoreCase("disabilitato")) {
                    infoServizio.setInoltro("EGOV_IT_PIUDIUNAVOLTA");
                } else if (pt.getFiltroDuplicati().equalsIgnoreCase("abilitato")) {
                    infoServizio.setInoltro("EGOV_IT_ALPIUUNAVOLTA");
                }
            }
            if (pt.getScadenza() != null) {
                try {
                    long minuti = Long.parseLong(pt.getScadenza());
                    nowDate = DateManager.getDate();
                    now = nowDate.getTime();
                    nowDate.setTime(now += minuti * 60L * 1000L);
                    infoServizio.setScadenza(nowDate);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (az != null || ptAz != null) {
            String profilo = null;
            profilo = az != null ? az.getProfiloCollaborazione() : ptAz.getProfiloCollaborazione();
            if (profilo != null) {
                if (profilo.equalsIgnoreCase("oneway")) {
                    infoServizio.setProfiloDiCollaborazione("EGOV_IT_MessaggioSingoloOneWay");
                } else if (profilo.equalsIgnoreCase("sincrono")) {
                    infoServizio.setProfiloDiCollaborazione("EGOV_IT_ServizioSincrono");
                } else if (profilo.equalsIgnoreCase("asincronoSimmetrico")) {
                    infoServizio.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoSimmetrico");
                } else if (profilo.equalsIgnoreCase("asincronoAsimmetrico")) {
                    infoServizio.setProfiloDiCollaborazione("EGOV_IT_ServizioAsincronoAsimmetrico");
                }
            }
            String idCollaborazione = null;
            idCollaborazione = az != null ? az.getIdCollaborazione() : ptAz.getIdCollaborazione();
            if (idCollaborazione != null) {
                if (idCollaborazione.equalsIgnoreCase("disabilitato")) {
                    infoServizio.setCollaborazione(false);
                } else if (idCollaborazione.equalsIgnoreCase("abilitato")) {
                    infoServizio.setCollaborazione(true);
                }
            }
            String consegnaInOrdine = null;
            consegnaInOrdine = az != null ? az.getConsegnaInOrdine() : ptAz.getConsegnaInOrdine();
            if (consegnaInOrdine != null) {
                if (consegnaInOrdine.equalsIgnoreCase("disabilitato")) {
                    infoServizio.setOrdineConsegna(false);
                } else if (consegnaInOrdine.equalsIgnoreCase("abilitato")) {
                    infoServizio.setOrdineConsegna(true);
                }
            }
            String confermaRicezione = null;
            confermaRicezione = az != null ? az.getConfermaRicezione() : ptAz.getConfermaRicezione();
            if (confermaRicezione != null) {
                if (confermaRicezione.equalsIgnoreCase("disabilitato")) {
                    infoServizio.setConfermaRicezione(false);
                } else if (confermaRicezione.equalsIgnoreCase("abilitato")) {
                    infoServizio.setConfermaRicezione(true);
                }
            }
            String filtroDuplicati = null;
            filtroDuplicati = az != null ? az.getFiltroDuplicati() : ptAz.getFiltroDuplicati();
            if (filtroDuplicati != null) {
                if (filtroDuplicati.equalsIgnoreCase("disabilitato")) {
                    infoServizio.setInoltro("EGOV_IT_PIUDIUNAVOLTA");
                } else if (filtroDuplicati.equalsIgnoreCase("abilitato")) {
                    infoServizio.setInoltro("EGOV_IT_ALPIUUNAVOLTA");
                }
            }
            String scadenza = null;
            scadenza = az != null ? az.getScadenza() : ptAz.getScadenza();
            if (scadenza != null) {
                try {
                    long minuti = Long.parseLong(scadenza);
                    Date nowDate2 = DateManager.getDate();
                    long now2 = nowDate2.getTime();
                    nowDate2.setTime(now2 += minuti * 60L * 1000L);
                    infoServizio.setScadenza(nowDate2);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (servizio.getIdCollaborazione() != null) {
            if (servizio.getIdCollaborazione().equalsIgnoreCase("disabilitato")) {
                infoServizio.setCollaborazione(false);
            } else if (servizio.getIdCollaborazione().equalsIgnoreCase("abilitato")) {
                infoServizio.setCollaborazione(true);
            }
        }
        if (servizio.getConsegnaInOrdine() != null) {
            if (servizio.getConsegnaInOrdine().equalsIgnoreCase("disabilitato")) {
                infoServizio.setOrdineConsegna(false);
            } else if (servizio.getConsegnaInOrdine().equalsIgnoreCase("abilitato")) {
                infoServizio.setOrdineConsegna(true);
            }
        }
        if (servizio.getConfermaRicezione() != null) {
            if (servizio.getConfermaRicezione().equalsIgnoreCase("disabilitato")) {
                infoServizio.setConfermaRicezione(false);
            } else if (servizio.getConfermaRicezione().equalsIgnoreCase("abilitato")) {
                infoServizio.setConfermaRicezione(true);
            }
        }
        if (servizio.getFiltroDuplicati() != null) {
            if (servizio.getFiltroDuplicati().equalsIgnoreCase("disabilitato")) {
                infoServizio.setInoltro("EGOV_IT_PIUDIUNAVOLTA");
            } else if (servizio.getFiltroDuplicati().equalsIgnoreCase("abilitato")) {
                infoServizio.setInoltro("EGOV_IT_ALPIUUNAVOLTA");
            }
        }
        if (servizio.getScadenza() != null) {
            try {
                long minuti = Long.parseLong(servizio.getScadenza());
                nowDate = DateManager.getDate();
                long now3 = nowDate.getTime();
                nowDate.setTime(now3 += minuti * 60L * 1000L);
                infoServizio.setScadenza(nowDate);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String nomeFruitore = idSoggetto.getNome();
        String tipoFruitore = idSoggetto.getTipo();
        Fruitore fruitore = null;
        for (int i = 0; i < servizio.sizeFruitoreList(); ++i) {
            Fruitore f = servizio.getFruitore(i);
            if (f.getTipo() == null || f.getNome() == null || !f.getTipo().equals(tipoFruitore) || !f.getNome().equals(nomeFruitore)) continue;
            fruitore = f;
            break;
        }
        if (fruitore != null) {
            if (fruitore.getIdCollaborazione() != null) {
                if (fruitore.getIdCollaborazione().equalsIgnoreCase("disabilitato")) {
                    infoServizio.setCollaborazione(false);
                } else if (fruitore.getIdCollaborazione().equalsIgnoreCase("abilitato")) {
                    infoServizio.setCollaborazione(true);
                }
            }
            if (fruitore.getConsegnaInOrdine() != null) {
                if (fruitore.getConsegnaInOrdine().equalsIgnoreCase("disabilitato")) {
                    infoServizio.setOrdineConsegna(false);
                } else if (fruitore.getConsegnaInOrdine().equalsIgnoreCase("abilitato")) {
                    infoServizio.setOrdineConsegna(true);
                }
            }
            if (fruitore.getConfermaRicezione() != null) {
                if (fruitore.getConfermaRicezione().equalsIgnoreCase("disabilitato")) {
                    infoServizio.setConfermaRicezione(false);
                } else if (fruitore.getConfermaRicezione().equalsIgnoreCase("abilitato")) {
                    infoServizio.setConfermaRicezione(true);
                }
            }
            if (fruitore.getFiltroDuplicati() != null) {
                if (fruitore.getFiltroDuplicati().equalsIgnoreCase("disabilitato")) {
                    infoServizio.setInoltro("EGOV_IT_PIUDIUNAVOLTA");
                } else if (fruitore.getFiltroDuplicati().equalsIgnoreCase("abilitato")) {
                    infoServizio.setInoltro("EGOV_IT_ALPIUUNAVOLTA");
                }
            }
            if (fruitore.getScadenza() != null) {
                try {
                    long minuti = Long.parseLong(fruitore.getScadenza());
                    Date nowDate3 = DateManager.getDate();
                    long now4 = nowDate3.getTime();
                    nowDate3.setTime(now4 += minuti * 60L * 1000L);
                    infoServizio.setScadenza(nowDate3);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (!servizioCorrelato && "EGOV_IT_ServizioAsincronoSimmetrico".equals(infoServizio.getProfiloDiCollaborazione())) {
            ServizioSpcoop servizioC = null;
            try {
                servizioC = this.registroServizi.getServizioCorrelato(nomeRegistro, idSoggetto, idAccordo);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("getInfoServizio, servizio correlato da associare al servizio asincrono simmetrico non trovato: " + e.getMessage());
            }
            if (servizioC == null) {
                throw new DriverRegistroServiziException("getInfoServizio, servizio correlato da associare al servizio asincrono simmetrico non trovato");
            }
            if (servizioC.getNome() == null || servizioC.getTipo() == null) {
                throw new DriverRegistroServiziException("getInfoServizio, servizio correlato al servizio asincrono simmetrico non configurato correttamente (tipo e/o nome is null?)");
            }
            infoServizio.setServizioCorrelato(servizioC.getNome());
            infoServizio.setTipoServizioCorrelato(servizioC.getTipo());
        }
        if (!servizioCorrelato && azioneCorrelata && "EGOV_IT_ServizioAsincronoAsimmetrico".equals(infoServizio.getProfiloDiCollaborazione())) {
            String azionePT = null;
            String correlazione = null;
            if (ptAz != null) {
                azionePT = ptAz.getNome();
                correlazione = ptAz.getCorrelata();
            } else {
                azionePT = az.getNome();
                correlazione = az.getCorrelata();
            }
            if (correlazione == null) {
                throw new DriverRegistroServiziNotFound("getInfoServizio, l'azione [" + azionePT + "] invocata con il servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non e' correlata ad un'altra azione dell'accordo");
            }
            boolean find = false;
            if (pt != null) {
                for (int i = 0; i < pt.sizeAzioneList(); ++i) {
                    if (!correlazione.equals(pt.getAzione(i).getNome())) continue;
                    find = true;
                    break;
                }
            } else {
                for (int i = 0; i < as.sizeAzioneList(); ++i) {
                    if (!correlazione.equals(as.getAzione(i).getNome())) continue;
                    find = true;
                    break;
                }
            }
            if (!find) {
                if (pt != null) {
                    throw new DriverRegistroServiziNotFound("getInfoServizio, l'operation [" + correlazione + "] definita come correlata nell'operation [" + azionePT + "] non esiste ( port type[" + pt.getNome() + "], servizio[" + idService.getTipoServizio() + idService.getServizio() + "] accordo di servizio[" + uriAccordo + "]");
                }
                throw new DriverRegistroServiziNotFound("getInfoServizio, l'azione [" + correlazione + "] definita come correlata nell'azione [" + azionePT + "] non esiste ( servizio[" + idService.getTipoServizio() + idService.getServizio() + "] accordo di servizio[" + uriAccordo + "]");
            }
        }
        return infoServizio;
    }

    public WSDLAccordoServizio getWsdlAccordoServizio(IDServizio idService, boolean readWSDLAccordoServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getWsdlAccordoServizio(null, idService, readWSDLAccordoServizio);
    }

    public boolean isFruitoreServizioAutorizzato(String pdd, String servizioApplicativo, IDSoggetto soggetto, IDServizio servizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            ServizioSpcoop servizioSPCoop = null;
            try {
                servizioSPCoop = this.registroServizi.getServizio(null, servizio);
            }
            catch (DriverRegistroServiziNotFound e) {
                // empty catch block
            }
            if (servizioSPCoop == null) {
                try {
                    servizioSPCoop = this.registroServizi.getServizioCorrelato(null, servizio);
                }
                catch (DriverRegistroServiziNotFound e) {
                    // empty catch block
                }
            }
            if (servizioSPCoop == null) {
                throw new DriverRegistroServiziNotFound("isFruitoreServizioAutorizzato, servizio [" + servizio.toString() + "] non trovato nel registro dei servizi");
            }
            for (int i = 0; i < servizioSPCoop.sizeFruitoreList(); ++i) {
                Fruitore fruitore = servizioSPCoop.getFruitore(i);
                if (!fruitore.getTipo().equals(soggetto.getTipo()) || !fruitore.getNome().equals(soggetto.getNome())) continue;
                if (fruitore.getClientAuth() == null) {
                    SoggettoSpcoop fruitoreSoggetto = this.registroServizi.getSoggetto(null, soggetto);
                    if (fruitoreSoggetto.getPortaDominio() != null) {
                        PortaDominio portaDominio = this.registroServizi.getPortaDominio(null, fruitoreSoggetto.getPortaDominio());
                        String authMode = portaDominio.getClientAuth();
                        if (authMode == null) {
                            authMode = "disabilitato";
                        }
                        if ("abilitato".equals(authMode)) {
                            if (pdd == null) {
                                this.log.error((Object)("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") fallita: subject della porta di dominio che ha inviato la busta, non presente"));
                                return false;
                            }
                            if (!pdd.equals(portaDominio.getSubject())) {
                                this.log.error((Object)("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") fallita: subject del mittente della busta [" + pdd + "] diverso da quello registrato per la porta di dominio " + portaDominio.getNome() + " associatagli [" + portaDominio.getSubject() + "]"));
                                return false;
                            }
                            this.log.debug((Object)("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") effettuata: subject corrispondono"));
                            return true;
                        }
                        if ("disabilitato".equals(authMode)) {
                            this.log.debug((Object)("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") effettuata: client-auth disabilitato nella porta di dominio " + portaDominio.getNome()));
                            return true;
                        }
                        throw new Exception("Valore di client-auth presente nella porta di dominio " + portaDominio.getNome() + " non valido: " + authMode);
                    }
                    this.log.debug((Object)("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") effettuata: client-auth non presente ne nella definizione del fruitore ne nel soggetto"));
                    return true;
                }
                if ("disabilitato".equals(fruitore.getClientAuth())) {
                    this.log.debug((Object)("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") effettuata: client-auth disabilitato nella fruizione"));
                    return true;
                }
                if ("abilitato".equals(fruitore.getClientAuth())) {
                    SoggettoSpcoop fruitoreSoggetto = this.registroServizi.getSoggetto(null, soggetto);
                    PortaDominio portaDominio = this.registroServizi.getPortaDominio(null, fruitoreSoggetto.getPortaDominio());
                    if (pdd == null) {
                        this.log.error((Object)("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") fallita (FR): subject della porta di dominio che ha inviato la busta, non presente"));
                        return false;
                    }
                    if (!pdd.equals(portaDominio.getSubject())) {
                        this.log.error((Object)("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") fallita (FR): subject del mittente della busta [" + pdd + "] diverso da quello registrato per la porta di dominio " + portaDominio.getNome() + " associatagli [" + portaDominio.getSubject() + "]"));
                        return false;
                    }
                    this.log.debug((Object)("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") effettuata (FR): subject corrispondono"));
                    return true;
                }
                throw new Exception("Valore di client-auth presente nel fruitore " + soggetto.toString() + " non valido: " + fruitore.getClientAuth());
            }
            return false;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante il controllo della fruizione di un servizio: " + e.getMessage(), (Throwable)e);
        }
    }

    private org.openspcoop.dao.config.Connettore getConnettore(IDSoggetto idSoggetto, String nomeConnettore, String nomeRegistro) {
        org.openspcoop.dao.registry.RegistroServizi[] registri = this.registroServizi.getRegistriServiziXML();
        if (registri != null) {
            for (int l = 0; l < registri.length; ++l) {
                for (int i = 0; i < registri[l].sizeConnettoreList(); ++i) {
                    if (!nomeConnettore.equals(registri[l].getConnettore(i).getNome())) continue;
                    Connettore conn = registri[l].getConnettore(i);
                    if (conn != null && !"none".equals(conn.getTipo())) {
                        return conn.mappingIntoConnettoreConfigurazione();
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private org.openspcoop.dao.config.Connettore getConnettore(IDServizio idService, String nomeConnettore, String nomeRegistro) {
        org.openspcoop.dao.registry.RegistroServizi[] registri = this.registroServizi.getRegistriServiziXML();
        if (registri != null) {
            for (int l = 0; l < registri.length; ++l) {
                for (int i = 0; i < registri[l].sizeConnettoreList(); ++i) {
                    if (!nomeConnettore.equals(registri[l].getConnettore(i).getNome())) continue;
                    Connettore conn = registri[l].getConnettore(i);
                    if (conn != null && !"none".equals(conn.getTipo())) {
                        return conn.mappingIntoConnettoreConfigurazione();
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public org.openspcoop.dao.config.Connettore getConnettore(IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        SoggettoSpcoop soggettoErogatore;
        int i;
        if (idService == null) {
            throw new DriverRegistroServiziException("getConnettore error: Servizio non definito");
        }
        ServizioSpcoop servizio = null;
        try {
            servizio = this.registroServizi.getServizio(nomeRegistro, idService);
        }
        catch (DriverRegistroServiziNotFound e) {
            // empty catch block
        }
        if (servizio == null) {
            try {
                servizio = this.registroServizi.getServizioCorrelato(nomeRegistro, idService);
            }
            catch (DriverRegistroServiziNotFound e) {
                // empty catch block
            }
        }
        if (servizio == null) {
            throw new DriverRegistroServiziNotFound("getConnettore, Servizio [" + idService.getTipoServizio() + idService.getServizio() + " erogato da " + idService.getSoggettoErogatore().getTipo() + idService.getSoggettoErogatore().getNome() + "] non definito nel registro");
        }
        org.openspcoop.dao.config.Connettore connector = null;
        String azione = idService.getAzione();
        String nomeFruitore = idSoggetto.getNome();
        String tipoFruitore = idSoggetto.getTipo();
        if (azione != null) {
            for (i = 0; i < servizio.sizeAzioneList(); ++i) {
                if (!azione.equals(servizio.getAzione(i).getNome())) continue;
                ServizioSpcoopAzione azSPC = servizio.getAzione(i);
                for (int j = 0; j < azSPC.sizeFruitoreList(); ++j) {
                    if (azSPC.getFruitore(i).getTipo() == null || azSPC.getFruitore(i).getNome() == null || !azSPC.getFruitore(i).getTipo().equals(tipoFruitore) || !azSPC.getFruitore(i).getNome().equals(nomeFruitore)) continue;
                    if (azSPC.getFruitore(i).getConnettore() == null) break;
                    if (azSPC.getFruitore(i).getConnettore().getTipo() != null) {
                        connector = azSPC.getFruitore(i).getConnettore().mappingIntoConnettoreConfigurazione();
                        break;
                    }
                    connector = this.getConnettore(idService, azSPC.getFruitore(i).getConnettore().getNome(), nomeRegistro);
                    break;
                }
                if (connector != null && !"disabilitato".equals(connector.getTipo()) || azSPC.getConnettore() == null) break;
                if (azSPC.getConnettore().getTipo() != null) {
                    connector = azSPC.getConnettore().mappingIntoConnettoreConfigurazione();
                    break;
                }
                connector = this.getConnettore(idService, connector.getNome(), nomeRegistro);
                break;
            }
        }
        if (connector == null || "disabilitato".equals(connector.getTipo())) {
            for (i = 0; i < servizio.sizeFruitoreList(); ++i) {
                Fruitore f = servizio.getFruitore(i);
                if (f.getTipo() == null || f.getNome() == null || !f.getTipo().equals(tipoFruitore) || !f.getNome().equals(nomeFruitore)) continue;
                if (f.getConnettore() == null) break;
                if (f.getConnettore().getTipo() != null) {
                    connector = f.getConnettore().mappingIntoConnettoreConfigurazione();
                    break;
                }
                connector = this.getConnettore(idService, connector.getNome(), nomeRegistro);
                break;
            }
        }
        if ((connector == null || "disabilitato".equals(connector.getTipo())) && servizio.getConnettore() != null) {
            connector = servizio.getConnettore().getTipo() != null ? servizio.getConnettore().mappingIntoConnettoreConfigurazione() : this.getConnettore(idService, connector.getNome(), nomeRegistro);
        }
        if ((connector == null || "disabilitato".equals(connector.getTipo())) && (soggettoErogatore = this.registroServizi.getSoggetto(nomeRegistro, idService.getSoggettoErogatore())).getConnettore() != null) {
            connector = soggettoErogatore.getConnettore().getTipo() != null ? soggettoErogatore.getConnettore().mappingIntoConnettoreConfigurazione() : this.getConnettore(idService, soggettoErogatore.getConnettore().getNome(), nomeRegistro);
        }
        if (connector == null || "disabilitato".equals(connector.getTipo())) {
            throw new DriverRegistroServiziNotFound("Connettore non trovato per il Servizio [" + idService.toString() + "]");
        }
        connector.setNomeDestinatarioTrasmissioneBusta(idService.getSoggettoErogatore().getNome());
        connector.setTipoDestinatarioTrasmissioneBusta(idService.getSoggettoErogatore().getTipo());
        return connector;
    }

    public org.openspcoop.dao.config.Connettore getConnettore(IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("getConnettore error: Soggetto destinatario non definito");
        }
        org.openspcoop.dao.config.Connettore connector = null;
        SoggettoSpcoop soggetto = this.registroServizi.getSoggetto(nomeRegistro, idSoggetto);
        if (soggetto.getConnettore() != null) {
            connector = soggetto.getConnettore().getTipo() != null ? soggetto.getConnettore().mappingIntoConnettoreConfigurazione() : this.getConnettore(idSoggetto, soggetto.getConnettore().getNome(), nomeRegistro);
        }
        if (connector == null || "disabilitato".equals(connector.getTipo())) {
            throw new DriverRegistroServiziNotFound("Connettore non trovato per il Soggetto [" + idSoggetto.toString() + "]");
        }
        connector.setNomeDestinatarioTrasmissioneBusta(idSoggetto.getNome());
        connector.setTipoDestinatarioTrasmissioneBusta(idSoggetto.getTipo());
        return connector;
    }

    public String getDominio(IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("getDominio error: soggetto non definito");
        }
        SoggettoSpcoop soggetto = this.registroServizi.getSoggetto(nomeRegistro, idSoggetto);
        if (soggetto == null) {
            throw new DriverRegistroServiziNotFound("getDominio, soggetto non definito nel registro");
        }
        if (soggetto.getIdentificativoPorta() != null) {
            return soggetto.getIdentificativoPorta();
        }
        return soggetto.getNome() + "SPCoopIT";
    }

    public String getImplementazionePdD(IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("getImplementazionePdD error: soggetto non definito");
        }
        SoggettoSpcoop soggetto = null;
        try {
            soggetto = this.registroServizi.getSoggetto(nomeRegistro, idSoggetto);
            if (soggetto == null) {
                throw new DriverRegistroServiziNotFound("Soggetto non esistente (null)");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            this.log.debug((Object)("getImplementazionePdD, soggetto [" + idSoggetto.toString() + "] non trovato: " + e.getMessage()));
            return "standard";
        }
        catch (DriverRegistroServiziException ex) {
            this.log.error((Object)("getImplementazionePdD, soggetto [" + idSoggetto.toString() + "] ricerca con errore: " + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Object)("getImplementazionePdD, soggetto [" + idSoggetto.toString() + "] ricerca con errore generale: " + ex.getMessage()), (Throwable)ex);
            throw new DriverRegistroServiziException("getImplementazionePdD, soggetto [" + idSoggetto.toString() + "] ricerca con errore generale: " + ex.getMessage(), (Throwable)ex);
        }
        if (soggetto.getPortaDominio() != null) {
            PortaDominio pdd = null;
            try {
                pdd = this.registroServizi.getPortaDominio(nomeRegistro, soggetto.getPortaDominio());
                if (pdd == null) {
                    throw new DriverRegistroServiziNotFound("PdD non esistente (null)");
                }
            }
            catch (DriverRegistroServiziNotFound e) {
                this.log.debug((Object)("getImplementazionePdD, porta di domino [" + soggetto.getPortaDominio() + "] associata al soggetto [" + idSoggetto.toString() + "] non trovata: " + e.getMessage()));
                return "standard";
            }
            catch (DriverRegistroServiziException ex) {
                this.log.error((Object)("getImplementazionePdD, porta di domino [" + soggetto.getPortaDominio() + "] associata al soggetto [" + idSoggetto.toString() + "]  ricerca con errore: " + ex.getMessage()), (Throwable)ex);
                throw ex;
            }
            catch (Exception ex) {
                this.log.error((Object)("getImplementazionePdD, porta di domino [" + soggetto.getPortaDominio() + "] associata al soggetto [" + idSoggetto.toString() + "]  ricerca con errore generale: " + ex.getMessage()), (Throwable)ex);
                throw new DriverRegistroServiziException("getImplementazionePdD, porta di domino [" + soggetto.getPortaDominio() + "] associata al soggetto [" + idSoggetto.toString() + "]  ricerca con errore generale: " + ex.getMessage(), (Throwable)ex);
            }
            if (pdd.getImplementazione() != null) {
                return pdd.getImplementazione();
            }
            return "standard";
        }
        return "standard";
    }

    public RisultatoValidazione validaServizio(IDSoggetto soggettoFruitore, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziPortTypeNotFound {
        int i;
        RisultatoValidazione risultato = new RisultatoValidazione();
        if (idService == null) {
            risultato.setServizioRegistrato(false);
            return risultato;
        }
        boolean correlato = false;
        ServizioSpcoop servizio = null;
        try {
            servizio = this.registroServizi.getServizio(nomeRegistro, idService);
        }
        catch (DriverRegistroServiziNotFound e) {
            // empty catch block
        }
        if (servizio == null) {
            try {
                servizio = this.registroServizi.getServizioCorrelato(nomeRegistro, idService);
            }
            catch (DriverRegistroServiziNotFound e) {
                // empty catch block
            }
            if (servizio == null) {
                risultato.setServizioRegistrato(false);
                return risultato;
            }
            correlato = true;
        }
        risultato.setIsServizioCorrelato(correlato);
        String uriAccordo = servizio.getAccordoServizio();
        IDAccordo idAccordo = IDAccordo.getIDAccordoFromUri((String)uriAccordo);
        AccordoServizio as = null;
        try {
            as = this.registroServizi.getAccordoServizio(nomeRegistro, idAccordo);
        }
        catch (DriverRegistroServiziNotFound e) {
            // empty catch block
        }
        if (as == null) {
            risultato.setServizioRegistrato(false);
            return risultato;
        }
        PortType pt = null;
        if (servizio.getPortType() != null) {
            for (i = 0; i < as.sizePortTypeList(); ++i) {
                if (!servizio.getPortType().equals(as.getPortType(i).getNome())) continue;
                pt = as.getPortType(i);
            }
            if (pt == null) {
                throw new DriverRegistroServiziPortTypeNotFound("Port-Type [" + servizio.getPortType() + "] associato al servizio non definito nell'accordo di servizio " + uriAccordo);
            }
        }
        if (pt != null) {
            risultato.setAccessoSenzaAzione(false);
        } else {
            risultato.setAccessoSenzaAzione(as.getUtilizzoSenzaAzione());
        }
        if (!correlato && soggettoFruitore != null) {
            String profiloCollaborazione = as.getProfiloCollaborazione();
            if (idService.getAzione() != null) {
                int k;
                if (pt != null) {
                    if (pt.getProfiloCollaborazione() != null) {
                        profiloCollaborazione = pt.getProfiloCollaborazione();
                    }
                    for (k = 0; k < pt.sizeAzioneList(); ++k) {
                        if (!idService.getAzione().equals(pt.getAzione(k).getNome())) continue;
                        if (pt.getAzione(k).getProfiloCollaborazione() == null) break;
                        profiloCollaborazione = pt.getAzione(k).getProfiloCollaborazione();
                        break;
                    }
                } else {
                    for (k = 0; k < as.sizeAzioneList(); ++k) {
                        if (!idService.getAzione().equals(as.getAzione(k).getNome())) continue;
                        if (as.getAzione(k).getProfiloCollaborazione() == null) break;
                        profiloCollaborazione = as.getAzione(k).getProfiloCollaborazione();
                        break;
                    }
                }
            }
            if ("asincronoSimmetrico".equals(profiloCollaborazione)) {
                ServizioSpcoop servizioC = null;
                try {
                    servizioC = this.registroServizi.getServizioCorrelato(nomeRegistro, soggettoFruitore, idAccordo);
                }
                catch (DriverRegistroServiziNotFound e) {
                    // empty catch block
                }
                if (servizioC != null && servizioC.getNome() != null && servizioC.getTipo() != null) {
                    risultato.setTipoServizioCorrelato(servizioC.getTipo());
                    risultato.setServizioCorrelato(servizioC.getNome());
                }
            } else if ("asincronoAsimmetrico".equals(profiloCollaborazione)) {
                String azioneRichiesta = idService.getAzione();
                String azioneCorrelata = null;
                if (azioneRichiesta != null) {
                    int i2;
                    if (pt != null) {
                        for (i2 = 0; i2 < pt.sizeAzioneList(); ++i2) {
                            if (!azioneRichiesta.equals(pt.getAzione(i2).getCorrelata())) continue;
                            azioneCorrelata = pt.getAzione(i2).getCorrelata();
                            break;
                        }
                    } else {
                        for (i2 = 0; i2 < as.sizeAzioneList(); ++i2) {
                            if (!azioneRichiesta.equals(as.getAzione(i2).getCorrelata())) continue;
                            azioneCorrelata = as.getAzione(i2).getCorrelata();
                            break;
                        }
                    }
                }
                if (azioneCorrelata != null) {
                    risultato.setTipoServizioCorrelato(idService.getTipoServizio());
                    risultato.setServizioCorrelato(idService.getServizio());
                    risultato.setAzioneCorrelata(azioneCorrelata);
                } else {
                    ServizioSpcoop servizioC = null;
                    try {
                        servizioC = this.registroServizi.getServizioCorrelato(nomeRegistro, idService.getSoggettoErogatore(), idAccordo);
                    }
                    catch (DriverRegistroServiziNotFound e) {
                        // empty catch block
                    }
                    if (servizioC != null && servizioC.getNome() != null && servizioC.getTipo() != null) {
                        risultato.setTipoServizioCorrelato(servizioC.getTipo());
                        risultato.setServizioCorrelato(servizioC.getNome());
                    }
                }
            }
        }
        if (pt != null) {
            for (i = 0; i < pt.sizeAzioneList(); ++i) {
                risultato.addAzione(pt.getAzione(i).getNome());
            }
        } else {
            for (i = 0; i < as.sizeAzioneList(); ++i) {
                risultato.addAzione(as.getAzione(i).getNome());
            }
        }
        risultato.setServizioRegistrato(true);
        return risultato;
    }

    static {
        initialize = false;
    }
}

