/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.message.Detail;
import org.apache.axis.message.InputStreamBody;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.soap.MessageFactoryImpl;
import org.apache.axis.utils.XMLUtils;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.Imbustamento;
import org.openspcoop.egov.ProprietaErroreApplicativo;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLBuilder {
    private Logger log = null;

    public XMLBuilder() {
        this(Configurazione.getLibraryLog());
    }

    public XMLBuilder(Logger aLog) {
        this.log = aLog != null ? aLog : Logger.getLogger((String)"XMLBuilder");
    }

    public SOAPElement buildElement_Diagnostico(String idPorta, String idFunzione, int livello, String text, Date gdo) throws EGovException {
        try {
            PrefixedQName name = new PrefixedQName("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "MessaggioDiagnostico", "eGov_IT_Diag");
            MessageElement diagnostico = new MessageElement((Name)name);
            diagnostico.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            diagnostico.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            MessageElement GDO = (MessageElement)diagnostico.addChildElement("OraRegistrazione");
            Date gdoD = new Date(gdo.getTime());
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
            GDO.setObjectValue((Object)dateformat.format(gdoD).replace('_', 'T'));
            MessageElement IdentificativoPorta = (MessageElement)diagnostico.addChildElement("IdentificativoPorta");
            IdentificativoPorta.setValue(idPorta);
            MessageElement IdentificativoFunzione = (MessageElement)diagnostico.addChildElement("IdentificativoFunzione");
            IdentificativoFunzione.setValue(idFunzione);
            MessageElement livelloSev = (MessageElement)diagnostico.addChildElement("LivelloDiSeverita");
            String liv = "" + livello;
            String livDefault = "0";
            if (livello < 10) {
                livelloSev.setValue(liv);
            } else {
                livelloSev.setValue(livDefault);
            }
            MessageElement Testo = (MessageElement)diagnostico.addChildElement("TestoDiagnostico");
            Testo.setValue(text);
            return diagnostico;
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildElement_Diagnostico error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildElement_Diagnostico error: " + e.getMessage(), e);
        }
    }

    public SOAPElement buildElement_Diagnostico(String idPorta, String idFunzione, int livello, String text) throws EGovException {
        try {
            PrefixedQName name = new PrefixedQName("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "MessaggioDiagnostico", "eGov_IT_Diag");
            MessageElement diagnostico = new MessageElement((Name)name);
            diagnostico.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            diagnostico.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            MessageElement GDO = (MessageElement)diagnostico.addChildElement("OraRegistrazione");
            GDO.setObjectValue((Object)Imbustamento.getDate_eGovFormat());
            MessageElement IdentificativoPorta = (MessageElement)diagnostico.addChildElement("IdentificativoPorta");
            IdentificativoPorta.setValue(idPorta);
            MessageElement IdentificativoFunzione = (MessageElement)diagnostico.addChildElement("IdentificativoFunzione");
            IdentificativoFunzione.setValue(idFunzione);
            MessageElement livelloSev = (MessageElement)diagnostico.addChildElement("LivelloDiSeverita");
            String liv = "" + livello;
            String livDefault = "0";
            if (livello < 10) {
                livelloSev.setValue(liv);
            } else {
                livelloSev.setValue(livDefault);
            }
            MessageElement Testo = (MessageElement)diagnostico.addChildElement("TestoDiagnostico");
            Testo.setValue(text);
            return diagnostico;
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildElement_Diagnostico error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildElement_Diagnostico error: " + e.getMessage(), e);
        }
    }

    public byte[] buildBytes_Diagnostico(String idPorta, String idFunzione, int livello, String text) throws EGovException {
        try {
            MessageElement diagnostico = (MessageElement)this.buildElement_Diagnostico(idPorta, idFunzione, livello, text);
            if (diagnostico == null) {
                throw new EGovException("XMLBuilder.buildBytes_Diagnostico fallito");
            }
            return Utilities.getAsString((MessageElement)diagnostico).getBytes();
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildBytes_Diagnostico error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildBytes_Diagnostico error: " + e.getMessage(), e);
        }
    }

    public String buildString_Diagnostico(String idPorta, String idFunzione, int livello, String text) throws EGovException {
        try {
            MessageElement diagnostico = (MessageElement)this.buildElement_Diagnostico(idPorta, idFunzione, livello, text);
            if (diagnostico == null) {
                throw new EGovException("XMLBuilder.buildString_Diagnostico fallito");
            }
            return Utilities.getAsString((MessageElement)diagnostico);
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildString_Diagnostico error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildString_Diagnostico error: " + e.getMessage(), e);
        }
    }

    public SOAPElement buildElement_TracciamentoApplicativo(SOAPHeader header, javax.xml.soap.SOAPBody body, String idPorta, String tipoMsg, String idEGov) throws EGovException {
        try {
            Iterator it;
            PrefixedQName name = new PrefixedQName("http://www.cnipa.it/schemas/2003/eGovIT/Tracciamento1_0/", "traccia", "eGov_IT_Trac");
            MessageElement traccia = new MessageElement((Name)name);
            traccia.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            traccia.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            MessageElement GDO = (MessageElement)traccia.addChildElement("GDO");
            GDO.setObjectValue((Object)Imbustamento.getDate_eGovFormat());
            MessageElement IdentificativoPorta = (MessageElement)traccia.addChildElement("IdentificativoPorta");
            IdentificativoPorta.setValue(idPorta);
            MessageElement TipoMessaggio = (MessageElement)traccia.addChildElement("TipoMessaggio");
            TipoMessaggio.setValue(tipoMsg);
            MessageElement identificatoreMessaggio = (MessageElement)traccia.addChildElement("IdentificatoreMessaggio");
            identificatoreMessaggio.setValue(idEGov);
            MessageElement messaggioApplicativo = (MessageElement)traccia.addChildElement("MessaggioApplicativo");
            if (header != null) {
                MessageElement headerApplicativo = (MessageElement)messaggioApplicativo.addChildElement("Header");
                it = header.getChildElements();
                while (it.hasNext()) {
                    MessageElement headerElement = (MessageElement)it.next();
                    headerApplicativo.addChildElement((SOAPElement)headerElement);
                }
            }
            if (body != null) {
                MessageElement bodyApplicativo = (MessageElement)messaggioApplicativo.addChildElement("Body");
                it = body.getChildElements();
                while (it.hasNext()) {
                    MessageElement bodyElement = (MessageElement)it.next();
                    bodyApplicativo.addChildElement((SOAPElement)bodyElement);
                }
            }
            return traccia;
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildElement_TracciamentoApplicativo error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildElement_TracciamentoApplicativo error: " + e.getMessage(), e);
        }
    }

    public byte[] buildBytes_TracciamentoApplicativo(SOAPHeader header, javax.xml.soap.SOAPBody body, String idPorta, String tipoMsg, String idEGov) throws EGovException {
        try {
            MessageElement tracciamentoApplicativo = (MessageElement)this.buildElement_TracciamentoApplicativo(header, body, idPorta, tipoMsg, idEGov);
            if (tracciamentoApplicativo == null) {
                throw new EGovException("XMLBuilder.buildBytes_TracciamentoApplicativo fallito");
            }
            return Utilities.getAsString((MessageElement)tracciamentoApplicativo).getBytes();
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildBytes_TracciamentoApplicativo error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildBytes_TracciamentoApplicativo error: " + e.getMessage(), e);
        }
    }

    public String buildString_TracciamentoApplicativo(SOAPHeader header, javax.xml.soap.SOAPBody body, String idPorta, String tipoMsg, String idEGov) throws EGovException {
        try {
            MessageElement tracciamentoApplicativo = (MessageElement)this.buildElement_TracciamentoApplicativo(header, body, idPorta, tipoMsg, idEGov);
            if (tracciamentoApplicativo == null) {
                throw new EGovException("XMLBuilder.buildString_TracciamentoApplicativo fallito");
            }
            return Utilities.getAsString((MessageElement)tracciamentoApplicativo);
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildString_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildString_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public SOAPElement buildElement_Tracciamento(Busta busta, String idPorta, String tipoMsg, Date gdo) throws EGovException {
        try {
            PrefixedQName name = new PrefixedQName("http://www.cnipa.it/schemas/2003/eGovIT/Tracciamento1_0/", "traccia", "eGov_IT_Trac");
            MessageElement traccia = new MessageElement((Name)name);
            traccia.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            traccia.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            MessageElement GDO = (MessageElement)traccia.addChildElement("GDO");
            Date gdoD = new Date(gdo.getTime());
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
            GDO.setObjectValue((Object)dateformat.format(gdoD).replace('_', 'T'));
            MessageElement IdentificativoPorta = (MessageElement)traccia.addChildElement("IdentificativoPorta");
            IdentificativoPorta.setValue(idPorta);
            MessageElement TipoMessaggio = (MessageElement)traccia.addChildElement("TipoMessaggio");
            TipoMessaggio.setValue(tipoMsg);
            MessageElement hdrEGov = null;
            Imbustamento imbustamento = new Imbustamento(this.log);
            hdrEGov = (MessageElement)imbustamento.build_eGovHeader(busta);
            if (hdrEGov == null) {
                throw new EGovException("XMLBuilder.buildElement_Tracciamento fallito");
            }
            traccia.addChildElement((SOAPElement)hdrEGov);
            return traccia;
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildElement_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildElement_Tracciamento error: " + e.getMessage(), e);
        }
    }

    private SOAPElement buildElement_Tracciamento(Busta busta, byte[] bustaInByte, String idPorta, String tipoMsg) throws EGovException {
        try {
            PrefixedQName name = new PrefixedQName("http://www.cnipa.it/schemas/2003/eGovIT/Tracciamento1_0/", "traccia", "eGov_IT_Trac");
            MessageElement traccia = new MessageElement((Name)name);
            traccia.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            traccia.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            MessageElement GDO = (MessageElement)traccia.addChildElement("GDO");
            GDO.setObjectValue((Object)Imbustamento.getDate_eGovFormat());
            MessageElement IdentificativoPorta = (MessageElement)traccia.addChildElement("IdentificativoPorta");
            IdentificativoPorta.setValue(idPorta);
            MessageElement TipoMessaggio = (MessageElement)traccia.addChildElement("TipoMessaggio");
            TipoMessaggio.setValue(tipoMsg);
            MessageElement hdrEGov = null;
            if (busta != null) {
                Imbustamento imbustamento = new Imbustamento(this.log);
                hdrEGov = (MessageElement)imbustamento.build_eGovHeader(busta);
            } else {
                ByteArrayInputStream inputBusta = new ByteArrayInputStream(bustaInByte);
                Document document = XMLUtils.newDocument((InputStream)inputBusta);
                hdrEGov = new MessageElement(document.getDocumentElement());
            }
            if (hdrEGov == null) {
                throw new EGovException("XMLBuilder.buildElement_Tracciamento fallito");
            }
            traccia.addChildElement((SOAPElement)hdrEGov);
            return traccia;
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildElement_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildElement_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public SOAPElement buildElement_Tracciamento(Busta busta, String idPorta, String tipoMsg) throws EGovException {
        return this.buildElement_Tracciamento(busta, null, idPorta, tipoMsg);
    }

    public SOAPElement buildElement_Tracciamento(byte[] bustaInByte, String idPorta, String tipoMsg) throws EGovException {
        return this.buildElement_Tracciamento(null, bustaInByte, idPorta, tipoMsg);
    }

    public SOAPElement buildElement_Tracciamento(SOAPHeaderElement busta, String idPorta, String tipoMsg) throws EGovException {
        byte[] bustaInByte = null;
        try {
            bustaInByte = SoapUtils.msgElementoToByte((MessageElement)((MessageElement)busta));
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildElement_Tracciamento (SOAPHeaderElement) error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildElement_Tracciamento (SOAPHeaderElement) error: " + e.getMessage(), e);
        }
        return this.buildElement_Tracciamento(null, bustaInByte, idPorta, tipoMsg);
    }

    public byte[] buildBytes_Tracciamento(Busta busta, String idPorta, String tipoMsg) throws EGovException {
        try {
            MessageElement tracciamento = (MessageElement)this.buildElement_Tracciamento(busta, idPorta, tipoMsg);
            if (tracciamento == null) {
                throw new EGovException("XMLBuilder.buildBytes_Tracciamento fallito");
            }
            return Utilities.getAsString((MessageElement)tracciamento).getBytes();
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildBytes_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildBytes_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public byte[] buildBytes_Tracciamento(byte[] bustaInByte, String idPorta, String tipoMsg) throws EGovException {
        try {
            MessageElement tracciamento = (MessageElement)this.buildElement_Tracciamento(bustaInByte, idPorta, tipoMsg);
            if (tracciamento == null) {
                throw new EGovException("XMLBuilder.buildBytes_Tracciamento fallito");
            }
            return Utilities.getAsString((MessageElement)tracciamento).getBytes();
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildBytes_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildBytes_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public byte[] buildBytes_Tracciamento(SOAPHeaderElement busta, String idPorta, String tipoMsg) throws EGovException {
        try {
            MessageElement tracciamento = (MessageElement)this.buildElement_Tracciamento(busta, idPorta, tipoMsg);
            if (tracciamento == null) {
                throw new EGovException("XMLBuilder.buildBytes_Tracciamento fallito");
            }
            return Utilities.getAsString((MessageElement)tracciamento).getBytes();
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildBytes_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildBytes_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public String buildString_Tracciamento(Busta busta, String idPorta, String tipoMsg) throws EGovException {
        try {
            MessageElement tracciamento = (MessageElement)this.buildElement_Tracciamento(busta, idPorta, tipoMsg);
            if (tracciamento == null) {
                throw new EGovException("XMLBuilder.buildString_Tracciamento fallito");
            }
            return Utilities.getAsString((MessageElement)tracciamento);
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildString_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildString_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public String buildString_Tracciamento(byte[] bustaInByte, String idPorta, String tipoMsg) throws EGovException {
        try {
            MessageElement tracciamento = (MessageElement)this.buildElement_Tracciamento(bustaInByte, idPorta, tipoMsg);
            if (tracciamento == null) {
                throw new EGovException("XMLBuilder.buildString_Tracciamento fallito");
            }
            return Utilities.getAsString((MessageElement)tracciamento);
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildString_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildString_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public String buildString_Tracciamento(SOAPHeaderElement busta, String idPorta, String tipoMsg) throws EGovException {
        try {
            MessageElement tracciamento = (MessageElement)this.buildElement_Tracciamento(busta, idPorta, tipoMsg);
            if (tracciamento == null) {
                throw new EGovException("XMLBuilder.buildString_Tracciamento fallito");
            }
            return Utilities.getAsString((MessageElement)tracciamento);
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildString_Tracciamento error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildString_Tracciamento error: " + e.getMessage(), e);
        }
    }

    public SOAPElement buildElement_Eccezione(String idPorta, String idFunzione, String codiceEccezione, String descrizioneEccezione, String tipoEccezione) throws EGovException {
        try {
            PrefixedQName name = new PrefixedQName("http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/", "MessaggioDiErroreApplicativo", "eGov_IT_Ecc");
            MessageElement eccezione = new MessageElement((Name)name);
            eccezione.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            eccezione.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            MessageElement oraRec = (MessageElement)eccezione.addChildElement("OraRegistrazione");
            oraRec.setObjectValue((Object)Imbustamento.getDate_eGovFormat());
            MessageElement IdentificativoPorta = (MessageElement)eccezione.addChildElement("IdentificativoPorta");
            IdentificativoPorta.setObjectValue((Object)idPorta);
            MessageElement IdentificativoFunzione = (MessageElement)eccezione.addChildElement("IdentificativoFunzione");
            IdentificativoFunzione.setValue(idFunzione);
            MessageElement EccNode = (MessageElement)eccezione.addChildElement("Eccezione");
            String tipo = "EccezioneProcessamento";
            if (tipoEccezione.equals("EccezioneBusta")) {
                tipo = "EccezioneBusta";
            }
            MessageElement EccNodeInterno = (MessageElement)EccNode.addChildElement(tipo);
            EccNodeInterno.setAttribute("codiceEccezione", codiceEccezione);
            EccNodeInterno.setAttribute("descrizioneEccezione", descrizioneEccezione);
            return eccezione;
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildElement_Eccezione error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildElement_Eccezione error: " + e.getMessage(), e);
        }
    }

    public SOAPElement buildElement_Eccezione(String idPorta, String idFunzione, Eccezione ecc) throws EGovException {
        return this.buildElement_Eccezione(idPorta, idFunzione, ecc.getCodiceEccezione(), ecc.getContestoCodifica(), "EccezioneBusta");
    }

    public byte[] buildBytes_Eccezione(String idPorta, String idFunzione, Eccezione ecc) throws EGovException {
        return this.buildBytes_Eccezione(idPorta, idFunzione, ecc.getCodiceEccezione(), ecc.getPosizione(), "EccezioneBusta");
    }

    public byte[] buildBytes_Eccezione(String idPorta, String idFunzione, String codiceEccezione, String descrizioneEccezione, String tipoEccezione) throws EGovException {
        try {
            MessageElement eccezione = (MessageElement)this.buildElement_Eccezione(idPorta, idFunzione, codiceEccezione, descrizioneEccezione, tipoEccezione);
            if (eccezione == null) {
                throw new EGovException("XMLBuilder.buildBytes_Eccezione fallito");
            }
            return Utilities.getAsString((MessageElement)eccezione).getBytes();
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildBytes_Eccezione error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildBytes_Eccezione error: " + e.getMessage(), e);
        }
    }

    public String buildString_Eccezione(String idPorta, String idFunzione, Eccezione ecc) throws EGovException {
        return this.buildString_Eccezione(idPorta, idFunzione, ecc.getCodiceEccezione(), ecc.getPosizione(), "EccezioneBusta");
    }

    public String buildString_Eccezione(String idPorta, String idFunzione, String codiceEccezione, String descrizioneEccezione, String tipoEccezione) throws EGovException {
        try {
            MessageElement eccezione = (MessageElement)this.buildElement_Eccezione(idPorta, idFunzione, codiceEccezione, descrizioneEccezione, tipoEccezione);
            if (eccezione == null) {
                throw new EGovException("XMLBuilder.buildBytes_Eccezione fallito");
            }
            return Utilities.getAsString((MessageElement)eccezione);
        }
        catch (Exception e) {
            this.log.error((Object)("XMLBuilder.buildString_Eccezione error: " + e.getMessage()), (Throwable)e);
            throw new EGovException("XMLBuilder.buildString_Eccezione error: " + e.getMessage(), e);
        }
    }

    public void insertErroreApplicativoProcessamentoIntoSOAPFault(ProprietaErroreApplicativo proprieta, String codErrore, String msgErrore, Message msg) throws EGovException {
        this.insertErroreApplicativoIntoSOAPFault(proprieta, codErrore, msgErrore, null, null, msg);
    }

    public void insertErroreApplicativoEccezioneIntoSOAPFault(ProprietaErroreApplicativo proprieta, Eccezione eccezione, IDSoggetto soggettoProduttoreEccezione, Message msg) throws EGovException {
        this.insertErroreApplicativoIntoSOAPFault(proprieta, null, null, eccezione, soggettoProduttoreEccezione, msg);
    }

    private void insertErroreApplicativoIntoSOAPFault(ProprietaErroreApplicativo proprieta, String codErrore, String msgErrore, Eccezione eccezione, IDSoggetto soggettoProduttoreEccezione, Message msg) throws EGovException {
        try {
            MessageElement erroreApplicativo = null;
            if (eccezione != null) {
                if (eccezione.getPosizione() != null) {
                    String msgPortaDiDominioNonDisponibile = "Porta di Dominio del soggetto @NOMEPDD@ non disponibile".replace("@NOMEPDD@", soggettoProduttoreEccezione.getTipo() + soggettoProduttoreEccezione.getNome());
                    if (eccezione.getPosizione().indexOf(msgPortaDiDominioNonDisponibile) == -1) {
                        eccezione.setPosizione(soggettoProduttoreEccezione.toString() + " ha rilevato le seguenti eccezioni:\n" + eccezione.getPosizione());
                    }
                }
                erroreApplicativo = (MessageElement)this.buildElement_Eccezione(proprieta.getDominio(), proprieta.getIdModulo(), eccezione);
            } else {
                String msgErroreTrasformato = proprieta.transformFaultMsg(codErrore, msgErrore);
                String codiceErroreTrasformato = proprieta.transformFaultCode(codErrore);
                erroreApplicativo = (MessageElement)this.buildElement_Eccezione(proprieta.getDominio(), proprieta.getIdModulo(), codiceErroreTrasformato, msgErroreTrasformato, "EccezioneProcessamento");
            }
            this.insertErroreApplicativoIntoSOAPFault(erroreApplicativo, msg);
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la costruzione del messaggio di errore", (Throwable)e);
            throw new EGovException("Errore durante la costruzione del messaggio di errore", e);
        }
    }

    public void insertRoutingErrorIntoSOAPFault(IDSoggetto identitaRouter, Message msg) throws EGovException {
        try {
            PrefixedQName name = new PrefixedQName("http://www.openspcoop.org/routing", "routing", "Routing");
            MessageElement eccezione = new MessageElement((Name)name);
            eccezione.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            eccezione.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            MessageElement esito = (MessageElement)eccezione.addChildElement("Esito");
            esito.setObjectValue((Object)"KO");
            MessageElement IdentificativoPorta = (MessageElement)eccezione.addChildElement("IdentificativoRouter");
            IdentificativoPorta.setObjectValue((Object)identitaRouter.toString());
            this.insertErroreApplicativoIntoSOAPFault(eccezione, msg);
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la costruzione del messaggio di errore", (Throwable)e);
            throw new EGovException("Errore durante la costruzione del messaggio di errore", e);
        }
    }

    private void insertErroreApplicativoIntoSOAPFault(MessageElement erroreApplicativo, Message msg) throws EGovException {
        try {
            if (msg == null) {
                throw new EGovException("Messaggio non presente");
            }
            SOAPBody soapBody = (SOAPBody)msg.getSOAPBody();
            if (soapBody == null) {
                throw new EGovException("SOAPBody non presente");
            }
            SOAPFault faultOriginale = null;
            if (!soapBody.hasFault()) {
                throw new EGovException("SOAPFault non presente");
            }
            faultOriginale = (SOAPFault)soapBody.getFault();
            if (faultOriginale == null) {
                throw new EGovException("SOAPFault is null");
            }
            byte[] bin = SoapUtils.msgElementoToByte((MessageElement)erroreApplicativo);
            Document de = XMLUtils.newDocument((InputStream)new ByteArrayInputStream(bin));
            MessageElement mSenzaXSITypes = new MessageElement(de.getDocumentElement());
            Detail d = (Detail)faultOriginale.getDetail();
            if (d == null) {
                d = (Detail)faultOriginale.addDetail();
                d = (Detail)faultOriginale.getDetail();
            }
            d.addChild(mSenzaXSITypes);
            msg.saveChanges();
            msg.getSOAPBody().removeChild((Node)msg.getSOAPBody().getFault());
            msg.saveChanges();
            SOAPFault faultPulito = (SOAPFault)msg.getSOAPBody().addFault();
            faultPulito.setFaultActor(faultOriginale.getFaultActor());
            faultPulito.setFaultCode(faultOriginale.getFaultCode());
            faultPulito.setFaultString(faultOriginale.getFaultString());
            Detail dDelete = (Detail)faultPulito.addDetail();
            dDelete = (Detail)faultPulito.getDetail();
            Iterator elemChilds = faultOriginale.getDetail().getChildElements();
            while (elemChilds.hasNext()) {
                MessageElement mChild = (MessageElement)elemChilds.next();
                if ("hostname".equals(mChild.getLocalName()) || "stackTrace".equals(mChild.getLocalName())) continue;
                dDelete.addChildElement((SOAPElement)mChild);
            }
            msg.saveChanges();
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la costruzione del messaggio di errore", (Throwable)e);
            throw new EGovException("Errore durante la costruzione del messaggio di errore", e);
        }
    }

    public Message msgErroreApplicativo_Processamento(ProprietaErroreApplicativo proprieta, String codErrore, String msgErrore) {
        try {
            String msgErroreTrasformato = proprieta.transformFaultMsg(codErrore, msgErrore);
            String codiceErroreTrasformato = proprieta.transformFaultCode(codErrore);
            byte[] byteRispostaApplicativa = this.buildBytes_Eccezione(proprieta.getDominio(), proprieta.getIdModulo(), codiceErroreTrasformato, msgErroreTrasformato, "EccezioneProcessamento");
            return this.msgErroreApplicativo(byteRispostaApplicativa, proprieta, codiceErroreTrasformato, msgErroreTrasformato);
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la costruzione del messaggio di errore processamento", (Throwable)e);
            return new Message((Object)new AxisFault("ErroreDiProcessamento"));
        }
    }

    public Message msgErroreApplicativo_Eccezione(ProprietaErroreApplicativo proprieta, Eccezione eccezione, IDSoggetto soggettoProduttoreEccezione) {
        try {
            if (eccezione.getPosizione() != null) {
                String msgPortaDiDominioNonDisponibile = "Porta di Dominio del soggetto @NOMEPDD@ non disponibile".replace("@NOMEPDD@", soggettoProduttoreEccezione.getTipo() + soggettoProduttoreEccezione.getNome());
                if (eccezione.getPosizione().indexOf(msgPortaDiDominioNonDisponibile) == -1) {
                    eccezione.setPosizione(soggettoProduttoreEccezione.toString() + " ha rilevato le seguenti eccezioni:\n" + eccezione.getPosizione());
                }
            }
            byte[] byteRispostaApplicativa = this.buildBytes_Eccezione(proprieta.getDominio(), proprieta.getIdModulo(), eccezione);
            return this.msgErroreApplicativo(byteRispostaApplicativa, proprieta, eccezione.getCodiceEccezione(), eccezione.getPosizione());
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante la costruzione del messaggio di errore busta", (Throwable)e);
            return new Message((Object)new AxisFault("ErroreDiProcessamento"));
        }
    }

    private Message msgErroreApplicativo(byte[] byteRispostaApplicativa, ProprietaErroreApplicativo proprieta, String faultCode, String msgErrore) {
        ByteArrayInputStream inputBody = null;
        try {
            MessageFactoryImpl mf = new MessageFactoryImpl();
            Message responseAxisMessageError = (Message)mf.createMessage();
            SOAPBody soapBody = (SOAPBody)responseAxisMessageError.getSOAPBody();
            if (proprieta.isFaultAsXML()) {
                inputBody = new ByteArrayInputStream(byteRispostaApplicativa);
                InputStreamBody isBody = new InputStreamBody((InputStream)inputBody);
                soapBody.addChildElement((SOAPElement)isBody);
                inputBody.close();
            } else {
                soapBody.addFault();
                javax.xml.soap.SOAPFault fault = soapBody.getFault();
                fault.setFaultCode(faultCode);
                fault.setFaultActor(proprieta.getFaultActor());
                if (proprieta.isInsertAsDetails()) {
                    fault.setFaultString(msgErrore);
                    Document de = XMLUtils.newDocument((InputStream)new ByteArrayInputStream(byteRispostaApplicativa));
                    MessageElement mSenzaXSITypes = new MessageElement(de.getDocumentElement());
                    Detail d = (Detail)fault.getDetail();
                    if (d == null) {
                        d = (Detail)fault.addDetail();
                        d = (Detail)fault.getDetail();
                    }
                    d.addChild(mSenzaXSITypes);
                } else {
                    fault.setFaultString(new String(byteRispostaApplicativa));
                }
            }
            return responseAxisMessageError;
        }
        catch (Exception e) {
            try {
                inputBody.close();
            }
            catch (Exception eis) {
                // empty catch block
            }
            return new Message((Object)new AxisFault("ErroreProcessamento"));
        }
    }
}

