/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StatefulMessage;
import org.openspcoop.dao.state.StatelessMessage;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.ConsegnaInOrdine;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.ProfiloDiCollaborazione;
import org.openspcoop.egov.ProprietaValidazione;
import org.openspcoop.egov.Riscontro;
import org.openspcoop.egov.RisultatoValidazione;
import org.openspcoop.egov.ServizioEGov;
import org.openspcoop.egov.Trasmissione;
import org.openspcoop.registry.RegistroServiziReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidazioneSemantica {
    private IState state;
    public static final String RICHIESTA = "Richiesta";
    public static final String RISPOSTA = "Risposta";
    public static final String RICEVUTA_RICHIESTA = "RicevutaRichiesta";
    public static final String RICEVUTA_RISPOSTA = "RicevutaRisposta";
    public static final String BUSTA_DI_SERVIZIO = "BustaDiServizio";
    private Vector<Eccezione> erroriValidazione;
    private Vector<Eccezione> erroriProcessamento;
    private Busta busta;
    private String servizioCorrelato;
    private String tipoServizioCorrelato;
    private String azioneCorrelata;
    private RegistroServiziReader registroServiziReader;
    private ServizioEGov infoServizio = null;
    private Logger log = null;

    public ValidazioneSemantica(Busta aBusta, IState state) {
        this(aBusta, state, Configurazione.getLibraryLog());
    }

    public ValidazioneSemantica(Busta aBusta, IState state, Logger alog) {
        this.busta = aBusta;
        this.state = state;
        this.registroServiziReader = RegistroServiziReader.getInstance();
        this.log = alog != null ? alog : Logger.getLogger((String)"ValidazioneSemantica");
    }

    public Vector<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public Vector<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public void valida(ProprietaValidazione tipoValidazione, String tipoBusta, String profiloGestione) {
        try {
            int i;
            Eccezione ecc;
            Eccezione ecc2;
            this.erroriValidazione = new Vector();
            this.erroriProcessamento = new Vector();
            if (!RegistroServiziReader.isInitialize() || this.registroServiziReader == null) {
                this.log.error((Object)"Registro dei Servizi non inizializzato.");
                Eccezione ecc3 = new Eccezione();
                ecc3.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
                ecc3.setCodiceEccezione("EGOV_IT_300");
                ecc3.setRilevanza("GRAVE");
                ecc3.setPosizione("Registro dei Servizi non disponibile");
                this.erroriProcessamento.add(ecc3);
                return;
            }
            IDSoggetto soggMitt = new IDSoggetto(this.busta.getTipoMittente(), this.busta.getMittente());
            String dominioMittente = null;
            boolean mittenteSconosciuto = false;
            try {
                dominioMittente = this.registroServiziReader.getDominio(soggMitt, null);
                if (dominioMittente == null) {
                    throw new Exception("Dominio non definito");
                }
            }
            catch (DriverRegistroServiziNotFound es) {
                ecc2 = new Eccezione();
                ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc2.setCodiceEccezione("EGOV_IT_101");
                ecc2.setRilevanza("GRAVE");
                ecc2.setPosizione("Mittente/IdentificativoParte");
                this.log.debug((Object)("Identificazione mittente fallita:" + es.getMessage()));
                this.erroriValidazione.add(ecc2);
                mittenteSconosciuto = true;
            }
            catch (Exception es) {
                ecc2 = new Eccezione();
                ecc2.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
                ecc2.setCodiceEccezione("EGOV_IT_300");
                ecc2.setRilevanza("GRAVE");
                ecc2.setPosizione("Identificazione mittente non riuscita: errore di processamento");
                this.log.error((Object)"Identificazione mittente non riuscita", (Throwable)es);
                this.erroriProcessamento.add(ecc2);
                mittenteSconosciuto = true;
            }
            IDSoggetto soggDest = new IDSoggetto(this.busta.getTipoDestinatario(), this.busta.getDestinatario());
            String dominioDestinatario = null;
            boolean destinatarioSconosciuto = false;
            try {
                dominioDestinatario = this.registroServiziReader.getDominio(soggDest, null);
                if (dominioDestinatario == null) {
                    throw new Exception("Dominio non definito");
                }
            }
            catch (DriverRegistroServiziNotFound es) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_102");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Destinatario/IdentificativoParte");
                this.log.debug((Object)("Identificazione destinatario fallita: " + es.getMessage()));
                this.erroriValidazione.add(ecc);
                destinatarioSconosciuto = true;
            }
            catch (Exception es) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_300");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Identificazione destinatario non riuscita: errore di processamento");
                this.log.error((Object)"Identificazione destinatario non riuscita", (Throwable)es);
                this.erroriProcessamento.add(ecc);
                destinatarioSconosciuto = true;
            }
            RisultatoValidazione risultatoValidazioneServizio = null;
            if (!BUSTA_DI_SERVIZIO.equals(tipoBusta)) {
                risultatoValidazioneServizio = this.riconoscimentoServizioAzione(tipoBusta, mittenteSconosciuto, destinatarioSconosciuto);
            }
            if (!BUSTA_DI_SERVIZIO.equals(tipoBusta) && !RICHIESTA.equals(tipoBusta)) {
                this.validazioneCorrelazione(tipoBusta);
            }
            boolean servizioBustaValido = false;
            if (!(BUSTA_DI_SERVIZIO.equals(tipoBusta) || destinatarioSconosciuto || mittenteSconosciuto)) {
                if (risultatoValidazioneServizio != null && risultatoValidazioneServizio.getServizioRegistrato()) {
                    if (this.busta.getAzione() == null && risultatoValidazioneServizio.getAccessoSenzaAzione()) {
                        servizioBustaValido = true;
                    } else if (this.busta.getAzione() != null && risultatoValidazioneServizio.getAzioni() != null) {
                        for (int j = 0; j < risultatoValidazioneServizio.sizeAzioni(); ++j) {
                            if (!this.busta.getAzione().equals(risultatoValidazioneServizio.getAzioni()[j])) continue;
                            servizioBustaValido = true;
                            break;
                        }
                    }
                }
                if (servizioBustaValido) {
                    IDSoggetto idSoggettoFruitore = new IDSoggetto();
                    IDSoggetto idSoggettoErogatore = new IDSoggetto();
                    this.impostaFruitoreErogatoreRealiServizio(idSoggettoFruitore, idSoggettoErogatore, tipoBusta);
                    IDServizio idServizio = new IDServizio(idSoggettoErogatore, this.busta.getTipoServizio(), this.busta.getServizio(), this.busta.getAzione());
                    try {
                        this.infoServizio = this.registroServiziReader.getInfoServizio(idSoggettoFruitore, idServizio, null);
                    }
                    catch (DriverRegistroServiziNotFound dnot) {
                        // empty catch block
                    }
                    if (this.infoServizio == null) {
                        try {
                            this.infoServizio = this.registroServiziReader.getInfoServizioCorrelato(soggMitt, idServizio, null);
                        }
                        catch (DriverRegistroServiziNotFound dnot) {
                            // empty catch block
                        }
                    }
                    if (this.infoServizio == null) {
                        Eccezione ecc4 = new Eccezione();
                        ecc4.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                        ecc4.setCodiceEccezione("EGOV_IT_300");
                        ecc4.setRilevanza("GRAVE");
                        ecc4.setPosizione("Raccolta informazioni servizio: servizio sconosciuto");
                        this.erroriValidazione.add(ecc4);
                        servizioBustaValido = false;
                    }
                }
            }
            if (servizioBustaValido && tipoValidazione.isValidazioneProfiloCollaborazione() && RICHIESTA.equals(tipoBusta)) {
                this.riconoscimentoProfiloCollaborazione(tipoBusta);
            }
            if (!mittenteSconosciuto && !this.validazioneID(this.busta.getID(), this.busta.getMittente(), dominioMittente)) {
                Eccezione ecc5 = new Eccezione();
                ecc5.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc5.setCodiceEccezione("EGOV_IT_110");
                ecc5.setRilevanza("GRAVE");
                ecc5.setPosizione("Messaggio/Identificatore");
                this.erroriValidazione.add(ecc5);
            }
            if (this.busta.getRiferimentoMessaggio() != null) {
                boolean validazioneIDRiferimentoMessaggio = true;
                if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(this.busta.getProfiloDiCollaborazione()) && RISPOSTA.equals(tipoBusta)) {
                    if (!mittenteSconosciuto) {
                        validazioneIDRiferimentoMessaggio = this.validazioneID(this.busta.getRiferimentoMessaggio(), this.busta.getMittente(), dominioMittente);
                    }
                } else if (!destinatarioSconosciuto) {
                    validazioneIDRiferimentoMessaggio = this.validazioneID(this.busta.getRiferimentoMessaggio(), this.busta.getDestinatario(), dominioDestinatario);
                }
                if (!validazioneIDRiferimentoMessaggio) {
                    Eccezione ecc6 = new Eccezione();
                    ecc6.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc6.setCodiceEccezione("EGOV_IT_111");
                    ecc6.setRilevanza("GRAVE");
                    ecc6.setPosizione("Messaggio/RiferimentoMessaggio");
                    this.erroriValidazione.add(ecc6);
                } else {
                    this.validazioneRiferimentoMessaggio(tipoBusta);
                }
            }
            if (!BUSTA_DI_SERVIZIO.equals(tipoBusta)) {
                this.riconoscimentoCollaborazione(tipoBusta, dominioMittente, dominioDestinatario);
            }
            if (!"eGov1.1-lineeGuida1.1".equals(profiloGestione) && this.busta.getSequenza() != -1L) {
                if (this.busta.getCollaborazione() == null || this.busta.getInoltro() == null) {
                    Eccezione ecc7 = new Eccezione();
                    ecc7.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc7.setCodiceEccezione("EGOV_IT_114");
                    ecc7.setRilevanza("GRAVE");
                    if (this.busta.getCollaborazione() == null && this.busta.getInoltro() == null) {
                        ecc7.setPosizione("Sequenza non gestibile, elementi Collaborazione e ProfiloTrasmissione non presenti");
                    } else if (this.busta.getCollaborazione() == null) {
                        ecc7.setPosizione("Sequenza non gestibile, elemento Collaborazione non presente");
                    } else {
                        ecc7.setPosizione("Sequenza non gestibile, elemento ProfiloTrasmissione non presente");
                    }
                    this.erroriValidazione.add(ecc7);
                } else if (!"EGOV_IT_ALPIUUNAVOLTA".equals(this.busta.getInoltro()) || !this.busta.getConfermaRicezione()) {
                    Eccezione ecc8 = new Eccezione();
                    ecc8.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc8.setCodiceEccezione("EGOV_IT_402");
                    ecc8.setRilevanza("GRAVE");
                    if (!"EGOV_IT_ALPIUUNAVOLTA".equals(this.busta.getInoltro()) && !this.busta.getConfermaRicezione()) {
                        ecc8.setPosizione("Sequenza non gestibile, attributi dell'elemento ProfiloTrasmissione non validi con la sequenza");
                    } else if (!this.busta.getConfermaRicezione()) {
                        ecc8.setPosizione("Sequenza non gestibile, attributo confermaRicezione dell'elemento ProfiloTrasmissione non valido con la sequenza");
                    } else {
                        ecc8.setPosizione("Sequenza non gestibile, attributo inoltro dell'elemento ProfiloTrasmissione non valido con la sequenza");
                    }
                    this.erroriValidazione.add(ecc8);
                }
            }
            for (i = 0; i < this.busta.sizeListaRiscontri(); ++i) {
                Riscontro r = this.busta.getRiscontro(i);
                if (this.validazioneID(r.getID())) continue;
                Eccezione ecc9 = new Eccezione();
                ecc9.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc9.setCodiceEccezione("EGOV_IT_115");
                ecc9.setRilevanza("GRAVE");
                ecc9.setPosizione("ListaRiscontri/Riscontro/Identificatore");
                this.erroriValidazione.add(ecc9);
            }
            for (i = 0; i < this.busta.sizeListaTrasmissioni(); ++i) {
                Eccezione ecc10;
                Eccezione ecc11;
                Trasmissione t = this.busta.getTrasmissione(i);
                IDSoggetto soggOrig = new IDSoggetto(t.getTipoOrigine(), t.getOrigine());
                String dominioOrig = null;
                try {
                    dominioOrig = this.registroServiziReader.getDominio(soggOrig, null);
                    if (dominioOrig == null) {
                        throw new Exception("Dominio non definito");
                    }
                }
                catch (DriverRegistroServiziNotFound es) {
                    ecc11 = new Eccezione();
                    ecc11.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc11.setCodiceEccezione("EGOV_IT_116");
                    ecc11.setRilevanza("GRAVE");
                    ecc11.setPosizione("ListaTrasmissioni/Trasmissione/Origine/IdentificativoParte");
                    this.log.debug((Object)("Identificazione origine trasmissione fallita:" + es.getMessage()));
                    this.erroriValidazione.add(ecc11);
                }
                catch (Exception es) {
                    ecc11 = new Eccezione();
                    ecc11.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
                    ecc11.setCodiceEccezione("EGOV_IT_300");
                    ecc11.setRilevanza("GRAVE");
                    ecc11.setPosizione("Identificazione origine della trasmissione non riuscita: errore di processamento");
                    this.log.error((Object)"Identificazione origine trasmissione non riuscita", (Throwable)es);
                    this.erroriProcessamento.add(ecc11);
                }
                IDSoggetto soggDestTr = new IDSoggetto(t.getTipoDestinazione(), t.getDestinazione());
                String dominioDestinatarioTr = null;
                try {
                    dominioDestinatarioTr = this.registroServiziReader.getDominio(soggDestTr, null);
                    if (dominioDestinatarioTr != null) continue;
                    throw new Exception("Dominio non definito");
                }
                catch (DriverRegistroServiziNotFound es) {
                    ecc10 = new Eccezione();
                    ecc10.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc10.setCodiceEccezione("EGOV_IT_116");
                    ecc10.setRilevanza("GRAVE");
                    ecc10.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione/IdentificativoParte");
                    this.log.debug((Object)("Identificazione destinazione trasmissione fallita:" + es.getMessage()));
                    this.erroriValidazione.add(ecc10);
                    continue;
                }
                catch (Exception es) {
                    ecc10 = new Eccezione();
                    ecc10.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
                    ecc10.setCodiceEccezione("EGOV_IT_300");
                    ecc10.setRilevanza("GRAVE");
                    ecc10.setPosizione("Identificazione destinazione della trasmissione non riuscita: errore di processamento");
                    this.log.error((Object)"Identificazione destinazione trasmissione non riuscita", (Throwable)es);
                    this.erroriProcessamento.add(ecc10);
                }
            }
            if ("eGov1.1-lineeGuida1.1".equals(profiloGestione)) {
                this.validazioneLineeGuida11();
            }
        }
        catch (Exception e) {
            this.log.error((Object)"ValidazioneSemantica: riscontrato errore durante la validazione", (Throwable)e);
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_300");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Errore di processamento durante la validazione semantica.");
            this.erroriProcessamento.add(ecc);
        }
    }

    public static String riconoscimentoProfiloGestitoServizioErogato(Busta busta, String tipoBusta) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDSoggetto idSoggettoFruitoreProfiloGestito = null;
        if (busta.getTipoServizio() != null && busta.getServizio() != null) {
            IDServizio idServizioProfiloGestito = new IDServizio();
            idServizioProfiloGestito.setTipoServizio(busta.getTipoServizio());
            idServizioProfiloGestito.setServizio(busta.getServizio());
            idServizioProfiloGestito.setAzione(busta.getAzione());
            if ("EGOV_IT_ServizioSincrono".equals(busta.getProfiloDiCollaborazione()) && RISPOSTA.equals(tipoBusta)) {
                idServizioProfiloGestito.setSoggettoErogatore(busta.getTipoMittente(), busta.getMittente());
                idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
            } else if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(busta.getProfiloDiCollaborazione()) && !RICHIESTA.equals(tipoBusta)) {
                if (RICEVUTA_RICHIESTA.equals(tipoBusta)) {
                    idServizioProfiloGestito.setSoggettoErogatore(busta.getTipoMittente(), busta.getMittente());
                    idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                } else if (RISPOSTA.equals(tipoBusta)) {
                    idServizioProfiloGestito.setSoggettoErogatore(busta.getTipoDestinatario(), busta.getDestinatario());
                    idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                } else {
                    idServizioProfiloGestito.setSoggettoErogatore(busta.getTipoMittente(), busta.getMittente());
                    idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                }
            } else if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(busta.getProfiloDiCollaborazione()) && (RICEVUTA_RICHIESTA.equals(tipoBusta) || RICEVUTA_RISPOSTA.equals(tipoBusta))) {
                idServizioProfiloGestito.setSoggettoErogatore(busta.getTipoMittente(), busta.getMittente());
                idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
            } else {
                idServizioProfiloGestito.setSoggettoErogatore(busta.getTipoDestinatario(), busta.getDestinatario());
                idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
            }
            return RegistroServiziReader.getInstance().getProfiloGestioneErogazioneServizio(idSoggettoFruitoreProfiloGestito, idServizioProfiloGestito, null);
        }
        idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
        return RegistroServiziReader.getInstance().getProfiloGestioneSoggetto(idSoggettoFruitoreProfiloGestito, null);
    }

    public static String getTipoBustaDaValidare(Busta busta, boolean validazioneRispostaHttpReply, IState state, Logger log) throws EGovException {
        String tipo = BUSTA_DI_SERVIZIO;
        if (busta.getProfiloDiCollaborazione() == null || busta.getServizio() == null || busta.getTipoServizio() == null) {
            tipo = BUSTA_DI_SERVIZIO;
        } else if (busta.getProfiloDiCollaborazione().equals("EGOV_IT_MessaggioSingoloOneWay") && busta.getRiferimentoMessaggio() != null) {
            tipo = BUSTA_DI_SERVIZIO;
        } else if (busta.getProfiloDiCollaborazione().equals("EGOV_IT_MessaggioSingoloOneWay")) {
            tipo = RICHIESTA;
        } else if (busta.getProfiloDiCollaborazione().equals("EGOV_IT_ServizioSincrono")) {
            tipo = busta.getRiferimentoMessaggio() == null ? RICHIESTA : RISPOSTA;
        } else if (busta.getProfiloDiCollaborazione().equals("EGOV_IT_ServizioAsincronoSimmetrico") || busta.getProfiloDiCollaborazione().equals("EGOV_IT_ServizioAsincronoAsimmetrico")) {
            ProfiloDiCollaborazione profilo;
            tipo = busta.getRiferimentoMessaggio() == null && busta.getCollaborazione() == null ? RICHIESTA : ((profilo = new ProfiloDiCollaborazione(state, log)).asincrono_isRicevutaRichiesta(busta.getRiferimentoMessaggio()) ? RICEVUTA_RICHIESTA : (profilo.asincrono_isRicevutaRisposta(busta.getRiferimentoMessaggio()) ? RICEVUTA_RISPOSTA : (!validazioneRispostaHttpReply && profilo.asincrono_isRisposta(busta) ? RISPOSTA : RICHIESTA)));
        }
        return tipo;
    }

    private void impostaFruitoreErogatoreRealiServizio(IDSoggetto fruitore, IDSoggetto erogatore, String tipoBusta) {
        if (RICHIESTA.equals(tipoBusta) || RISPOSTA.equals(tipoBusta) && "EGOV_IT_ServizioAsincronoSimmetrico".equals(this.busta.getProfiloDiCollaborazione()) || RISPOSTA.equals(tipoBusta) && "EGOV_IT_ServizioAsincronoAsimmetrico".equals(this.busta.getProfiloDiCollaborazione())) {
            if (erogatore != null) {
                erogatore.setTipo(this.busta.getTipoDestinatario());
                erogatore.setNome(this.busta.getDestinatario());
            }
            if (fruitore != null) {
                fruitore.setTipo(this.busta.getTipoMittente());
                fruitore.setNome(this.busta.getMittente());
            }
        } else if (RISPOSTA.equals(tipoBusta) || RICEVUTA_RICHIESTA.equals(tipoBusta) || RICEVUTA_RISPOSTA.equals(tipoBusta)) {
            if (erogatore != null) {
                erogatore.setTipo(this.busta.getTipoMittente());
                erogatore.setNome(this.busta.getMittente());
            }
            if (fruitore != null) {
                fruitore.setTipo(this.busta.getTipoDestinatario());
                fruitore.setNome(this.busta.getDestinatario());
            }
        }
    }

    private RisultatoValidazione riconoscimentoServizioAzione(String tipoBusta, boolean mittenteSconosciuto, boolean destinatarioSconosciuto) throws EGovException, DriverRegistroServiziException {
        Eccezione ecc;
        Eccezione ecc2;
        if (mittenteSconosciuto) {
            return null;
        }
        if (destinatarioSconosciuto) {
            return null;
        }
        IDSoggetto idSoggettoErogatore = new IDSoggetto();
        IDSoggetto idSoggettoFruitore = null;
        if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(this.busta.getProfiloDiCollaborazione()) && RICHIESTA.equals(tipoBusta)) {
            idSoggettoFruitore = new IDSoggetto();
        } else if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(this.busta.getProfiloDiCollaborazione())) {
            idSoggettoFruitore = new IDSoggetto();
        }
        this.impostaFruitoreErogatoreRealiServizio(idSoggettoFruitore, idSoggettoErogatore, tipoBusta);
        RisultatoValidazione validazione = null;
        if (this.busta.getServizio() != null && this.busta.getTipoServizio() != null) {
            IDServizio idService = new IDServizio(idSoggettoErogatore, this.busta.getTipoServizio(), this.busta.getServizio(), this.busta.getAzione());
            try {
                validazione = this.registroServiziReader.validaServizio(idSoggettoFruitore, idService, null);
            }
            catch (Exception e) {
                this.log.error((Object)"Errore durante l'accesso al registro per la validazione del servizio e dell'azione", (Throwable)e);
                ecc2 = new Eccezione();
                ecc2.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
                ecc2.setCodiceEccezione("EGOV_IT_300");
                ecc2.setRilevanza("GRAVE");
                ecc2.setPosizione("Riconoscimento Servizio/Azione: errore di processamento");
                this.erroriProcessamento.add(ecc2);
            }
            if (!validazione.getServizioRegistrato()) {
                Eccezione ecc3 = new Eccezione();
                ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc3.setCodiceEccezione("EGOV_IT_105");
                ecc3.setRilevanza("GRAVE");
                ecc3.setPosizione("Servizio");
                this.erroriValidazione.add(ecc3);
                return validazione;
            }
            this.servizioCorrelato = validazione.getServizioCorrelato();
            this.tipoServizioCorrelato = validazione.getTipoServizioCorrelato();
            this.azioneCorrelata = validazione.getAzioneCorrelata();
        }
        if (this.busta.getServizio() != null && this.busta.getTipoServizio() != null) {
            if (this.busta.getAzione() == null) {
                if (!validazione.getAccessoSenzaAzione()) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_106");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("Azione");
                    this.erroriValidazione.add(ecc);
                    return validazione;
                }
            } else {
                String[] azioni = validazione.getAzioni();
                boolean azioneTrovata = false;
                if (azioni != null) {
                    for (int i = 0; i < azioni.length; ++i) {
                        if (!this.busta.getAzione().equals(azioni[i])) continue;
                        azioneTrovata = true;
                        break;
                    }
                }
                if (!azioneTrovata) {
                    ecc2 = new Eccezione();
                    ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc2.setCodiceEccezione("EGOV_IT_106");
                    ecc2.setRilevanza("GRAVE");
                    ecc2.setPosizione("Azione");
                    this.erroriValidazione.add(ecc2);
                    return validazione;
                }
            }
        }
        if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(this.busta.getProfiloDiCollaborazione()) && RICHIESTA.equals(tipoBusta)) {
            if (this.busta.getServizioCorrelato() != null && !this.busta.getServizioCorrelato().equals(validazione.getServizioCorrelato())) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_103");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("ProfiloCollaborazione/servizioCorrelato diverso da quello atteso (richiesta asincrona simmetrica)");
                this.erroriValidazione.add(ecc);
                return validazione;
            }
            if (this.busta.getTipoServizioCorrelato() != null && !this.busta.getTipoServizioCorrelato().equals(validazione.getTipoServizioCorrelato())) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_103");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("ProfiloCollaborazione/tipo diverso da quello atteso (richiesta asincrona simmetrica)");
                this.erroriValidazione.add(ecc);
                return validazione;
            }
        }
        if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(this.busta.getProfiloDiCollaborazione()) && RICEVUTA_RICHIESTA.equals(tipoBusta)) {
            if (this.busta.getServizioCorrelato() != null && !this.busta.getServizioCorrelato().equals(validazione.getServizioCorrelato())) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_103");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("ProfiloCollaborazione/servizioCorrelato diverso da quello atteso (ricevuta della richiesta asincrona simmetrica)");
                this.erroriValidazione.add(ecc);
                return validazione;
            }
            if (this.busta.getTipoServizioCorrelato() != null && !this.busta.getTipoServizioCorrelato().equals(validazione.getTipoServizioCorrelato())) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_103");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("ProfiloCollaborazione/tipo diverso da quello atteso (ricevuta della richiesta asincrona simmetrica)");
                this.erroriValidazione.add(ecc);
                return validazione;
            }
        }
        return validazione;
    }

    private void validazioneCorrelazione(String tipoBusta) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            ProfiloDiCollaborazione profiloDiCollaborazione = new ProfiloDiCollaborazione(stateful, this.log);
            Eccezione ecc = null;
            if ("EGOV_IT_ServizioSincrono".equals(this.busta.getProfiloDiCollaborazione())) {
                ecc = profiloDiCollaborazione.sincrono_validazioneCorrelazione(this.busta);
            } else if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(this.busta.getProfiloDiCollaborazione())) {
                if (RICEVUTA_RICHIESTA.equals(tipoBusta)) {
                    ecc = profiloDiCollaborazione.asincronoSimmetrico_validazioneCorrelazione_ricevutaRichiesta(this.busta);
                } else if (RISPOSTA.equals(tipoBusta)) {
                    ecc = profiloDiCollaborazione.asincronoSimmetrico_validazioneCorrelazione_risposta(this.busta);
                } else if (RICEVUTA_RISPOSTA.equals(tipoBusta)) {
                    ecc = profiloDiCollaborazione.asincronoSimmetrico_validazioneCorrelazione_ricevutaRisposta(this.busta);
                }
            } else if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(this.busta.getProfiloDiCollaborazione())) {
                if (RICEVUTA_RICHIESTA.equals(tipoBusta)) {
                    ecc = profiloDiCollaborazione.asincronoAsimmetrico_validazioneCorrelazione_ricevutaRichiesta(this.busta);
                } else if (RISPOSTA.equals(tipoBusta)) {
                    ecc = profiloDiCollaborazione.asincronoAsimmetrico_validazioneCorrelazione_richiestaStato(this.busta);
                } else if (RICEVUTA_RISPOSTA.equals(tipoBusta)) {
                    ecc = profiloDiCollaborazione.asincronoAsimmetrico_validazioneCorrelazione_ricevutaRichiestaStato(this.busta);
                }
            }
            if (ecc != null) {
                this.erroriValidazione.add(ecc);
                return;
            }
        } else if (this.state instanceof StatelessMessage) {
            StatelessMessage stateless;
            Busta bustaCorrelata;
            if ("EGOV_IT_ServizioSincrono".equals(this.busta.getProfiloDiCollaborazione()) && (bustaCorrelata = (stateless = (StatelessMessage)this.state).getBustaCorrelata()) != null) {
                Eccezione eccValidazione = new Eccezione();
                eccValidazione.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                eccValidazione.setRilevanza("GRAVE");
                if (!this.busta.getTipoDestinatario().equals(bustaCorrelata.getTipoMittente())) {
                    eccValidazione.setCodiceEccezione("EGOV_IT_101");
                    eccValidazione.setPosizione("Tipo del mittente diverso da quello atteso nella gestione del profilo di collaborazione Sincrono");
                    this.erroriValidazione.add(eccValidazione);
                    return;
                }
                if (!this.busta.getDestinatario().equals(bustaCorrelata.getMittente())) {
                    eccValidazione.setCodiceEccezione("EGOV_IT_101");
                    eccValidazione.setPosizione("Mittente diverso da quello atteso nella gestione del profilo di collaborazione Sincrono");
                    this.erroriValidazione.add(eccValidazione);
                    return;
                }
                if (!this.busta.getTipoMittente().equals(bustaCorrelata.getTipoDestinatario())) {
                    eccValidazione.setCodiceEccezione("EGOV_IT_102");
                    eccValidazione.setPosizione("Tipo del destinatario diverso da quello atteso nella gestione del profilo di collaborazione Sincrono");
                    this.erroriValidazione.add(eccValidazione);
                    return;
                }
                if (!this.busta.getMittente().equals(bustaCorrelata.getDestinatario())) {
                    eccValidazione.setCodiceEccezione("EGOV_IT_102");
                    eccValidazione.setPosizione("Destinatario diverso da quello atteso nella gestione del profilo di collaborazione Sincrono");
                    this.erroriValidazione.add(eccValidazione);
                    return;
                }
                if (this.busta.getServizio() != null && bustaCorrelata.getTipoServizio() != null) {
                    if (!this.busta.getTipoServizio().equals(bustaCorrelata.getTipoServizio())) {
                        eccValidazione.setCodiceEccezione("EGOV_IT_105");
                        eccValidazione.setPosizione("Tipo di servizio diverso da quello atteso nella gestione del profilo di collaborazione Sincrono");
                        this.erroriValidazione.add(eccValidazione);
                        return;
                    }
                    if (!this.busta.getServizio().equals(bustaCorrelata.getServizio())) {
                        eccValidazione.setCodiceEccezione("EGOV_IT_105");
                        eccValidazione.setPosizione("Servizio diverso da quello atteso nella gestione del profilo di collaborazione Sincrono");
                        this.erroriValidazione.add(eccValidazione);
                        return;
                    }
                    if (this.busta.getAzione() != null && !this.busta.getAzione().equals(bustaCorrelata.getAzione())) {
                        eccValidazione.setCodiceEccezione("EGOV_IT_106");
                        eccValidazione.setPosizione("Azione diversa da quella attesa con il profilo di collaborazione Sincrono");
                        this.erroriValidazione.add(eccValidazione);
                        return;
                    }
                }
            }
        } else {
            throw new EGovException("Metodo invocato con IState non valido");
        }
    }

    private void riconoscimentoProfiloCollaborazione(String tipoBusta) {
        try {
            if (!this.infoServizio.getProfiloDiCollaborazione().equals(this.busta.getProfiloDiCollaborazione())) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_103");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("ProfiloCollaborazione diverso da quanto specificato nel registro");
                this.erroriValidazione.add(ecc);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Errore durante l'accesso al registro per la validazione del profilo di collaborazione", (Throwable)e);
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_300");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Riconoscimento Profilo di Collaborazione: errore di processamento");
            this.erroriProcessamento.add(ecc);
        }
    }

    public boolean validazioneID(String id) {
        return this.validazioneID(id, null, null);
    }

    public boolean validazioneID(String id, String codAmm, String codDominio) {
        try {
            Integer test;
            int j;
            String[] split = id.split("_");
            if (split == null) {
                return false;
            }
            if (split.length != 5) {
                return false;
            }
            if (codAmm != null) {
                if (!split[0].equals(codAmm)) {
                    return false;
                }
                byte[] checkID = split[0].getBytes();
                for (j = 0; j < checkID.length; ++j) {
                    if (Character.isLetterOrDigit((char)checkID[j])) continue;
                    return false;
                }
            }
            if (codDominio != null) {
                if (!split[1].equalsIgnoreCase(codDominio)) {
                    return false;
                }
                byte[] checkPDD = split[1].getBytes();
                for (j = 0; j < checkPDD.length; ++j) {
                    if (Character.isLetterOrDigit((char)checkPDD[j])) continue;
                    return false;
                }
            }
            if (split[2].length() != 7) {
                return false;
            }
            try {
                Integer test2 = new Integer(split[2]);
                test2.intValue();
            }
            catch (Exception e) {
                return false;
            }
            String[] date = split[3].split("-");
            if (date == null) {
                return false;
            }
            if (date.length != 3) {
                return false;
            }
            if (date[0].length() != 4) {
                return false;
            }
            try {
                Integer test3 = new Integer(date[0]);
                if (test3 > 2100) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            if (date[1].length() != 2) {
                return false;
            }
            if (date[2].length() != 2) {
                return false;
            }
            try {
                Integer mese = new Integer(date[1]);
                if (mese > 12 || mese < 0) {
                    return false;
                }
                Integer giorno = new Integer(date[2]);
                if (giorno < 0) {
                    return false;
                }
                if (giorno > 29 && mese == 2) {
                    return false;
                }
                if (giorno > 30 && (mese == 4 || mese == 6 || mese == 9 || mese == 11)) {
                    return false;
                }
                if (giorno > 31) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            String[] ora = split[4].split(":");
            if (ora == null) {
                return false;
            }
            if (ora.length != 2) {
                return false;
            }
            if (ora[0].length() != 2) {
                return false;
            }
            try {
                test = new Integer(ora[0]);
                if (test > 23 || test < 0) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            if (ora[1].length() != 2) {
                return false;
            }
            try {
                test = new Integer(ora[1]);
                if (test > 59 || test < 0) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        catch (Exception error) {
            return false;
        }
    }

    private void validazioneRiferimentoMessaggio(String tipoBusta) throws EGovException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            ProfiloDiCollaborazione profiloDiCollaborazione = new ProfiloDiCollaborazione(stateful, this.log);
            boolean error = false;
            if ("EGOV_IT_ServizioSincrono".equals(this.busta.getProfiloDiCollaborazione())) {
                if (!profiloDiCollaborazione.sincrono_validazioneRiferimentoMessaggio(this.busta.getRiferimentoMessaggio())) {
                    error = true;
                }
            } else if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(this.busta.getProfiloDiCollaborazione())) {
                if (!profiloDiCollaborazione.asincronoSimmetrico_validazioneRiferimentoMessaggio(this.busta.getRiferimentoMessaggio())) {
                    error = true;
                }
            } else if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(this.busta.getProfiloDiCollaborazione())) {
                if (RISPOSTA.equals(tipoBusta)) {
                    if (!profiloDiCollaborazione.asincronoAsimmetrico_validazioneRiferimentoMessaggio_richiestaStato(this.busta.getRiferimentoMessaggio())) {
                        error = true;
                    }
                } else if (!profiloDiCollaborazione.asincronoAsimmetrico_validazioneRiferimentoMessaggio_ricevuta(this.busta.getRiferimentoMessaggio())) {
                    error = true;
                }
            }
            if (error) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_111");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Messaggio/RiferimentoMessaggio");
                this.erroriValidazione.add(ecc);
            }
        } else if (this.state instanceof StatelessMessage) {
            StatelessMessage stateless;
            Busta bustaCorrelata;
            if ("EGOV_IT_ServizioSincrono".equals(this.busta.getProfiloDiCollaborazione()) && (bustaCorrelata = (stateless = (StatelessMessage)this.state).getBustaCorrelata()) != null && this.busta.getRiferimentoMessaggio() != null && !this.busta.getRiferimentoMessaggio().equals(bustaCorrelata.getID())) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_111");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Messaggio/RiferimentoMessaggio");
                this.erroriValidazione.add(ecc);
            }
        } else {
            throw new EGovException("Metodo invocato con IState non valido");
        }
    }

    private boolean riconoscimentoCollaborazione(String tipoBusta, String dominioMittente, String dominioDestinatario) throws EGovException {
        if (this.busta.getCollaborazione() != null && !this.validazioneID(this.busta.getCollaborazione(), this.busta.getMittente(), dominioMittente) && !this.validazioneID(this.busta.getCollaborazione(), this.busta.getDestinatario(), dominioDestinatario)) {
            Eccezione ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_104");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("Collaborazione");
            this.erroriValidazione.add(ecc);
            return false;
        }
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            if (this.busta.getCollaborazione() != null) {
                ProfiloDiCollaborazione profiloDiCollaborazione = new ProfiloDiCollaborazione(stateful, this.log);
                boolean error = false;
                if (!"EGOV_IT_MessaggioSingoloOneWay".equals(this.busta.getProfiloDiCollaborazione())) {
                    if (!tipoBusta.equals(RICHIESTA)) {
                        if ("EGOV_IT_ServizioSincrono".equals(this.busta.getProfiloDiCollaborazione())) {
                            if (RISPOSTA.equals(tipoBusta) && !profiloDiCollaborazione.sincrono_validazioneCollaborazione(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                error = true;
                            }
                        } else if ("EGOV_IT_ServizioAsincronoSimmetrico".equals(this.busta.getProfiloDiCollaborazione())) {
                            if (RISPOSTA.equals(tipoBusta)) {
                                if (!profiloDiCollaborazione.asincronoSimmetrico_validazioneCollaborazione_risposta(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                    error = true;
                                }
                            } else if ((RICEVUTA_RICHIESTA.equals(tipoBusta) || RICEVUTA_RISPOSTA.equals(tipoBusta)) && !profiloDiCollaborazione.asincronoSimmetrico_validazioneCollaborazione_ricevuta(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                error = true;
                            }
                        } else if ("EGOV_IT_ServizioAsincronoAsimmetrico".equals(this.busta.getProfiloDiCollaborazione())) {
                            if (RISPOSTA.equals(tipoBusta)) {
                                if (!profiloDiCollaborazione.asincronoAsimmetrico_validazioneCollaborazione_richiestaStato(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                    error = true;
                                }
                            } else if ((RICEVUTA_RICHIESTA.equals(tipoBusta) || RICEVUTA_RISPOSTA.equals(tipoBusta)) && !profiloDiCollaborazione.asincronoAsimmetrico_validazioneCollaborazione_ricevuta(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                error = true;
                            }
                        }
                    }
                } else {
                    ConsegnaInOrdine consegna = new ConsegnaInOrdine(stateful, this.log);
                    Eccezione ecc = consegna.validazioneDatiConsegnaInOrdine(this.busta);
                    if (ecc != null) {
                        this.erroriValidazione.add(ecc);
                        return false;
                    }
                }
                if (error) {
                    Eccezione ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_104");
                    ecc.setRilevanza("GRAVE");
                    ecc.setPosizione("Collaborazione valore diverso da quello atteso");
                    this.erroriValidazione.add(ecc);
                    return false;
                }
            }
            return true;
        }
        if (this.state instanceof StatelessMessage) {
            ConsegnaInOrdine consegna;
            Eccezione ecc;
            StatelessMessage stateless = (StatelessMessage)this.state;
            if ("EGOV_IT_MessaggioSingoloOneWay".equals(this.busta.getProfiloDiCollaborazione()) && (ecc = (consegna = new ConsegnaInOrdine(stateless, this.log)).validazioneDatiConsegnaInOrdine(this.busta)) != null) {
                this.erroriValidazione.add(ecc);
                return false;
            }
            return true;
        }
        throw new EGovException("Metodo invocato con IState non valido");
    }

    private void validazioneLineeGuida11() {
        Eccezione ecc;
        Trasmissione tr;
        int i;
        Eccezione ecc2;
        if (!"SPC".equals(this.busta.getTipoMittente())) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_101");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("Mittente/IdentificativoParte/tipo");
            this.erroriValidazione.add(ecc2);
        }
        if (!"SPC".equals(this.busta.getTipoDestinatario())) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_102");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("Destinatario/IdentificativoParte/tipo");
            this.erroriValidazione.add(ecc2);
        }
        if (this.busta.getTipoServizio() == null) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_105");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("Servizio/tipo");
            this.erroriValidazione.add(ecc2);
        }
        if (this.busta.getServizio() == null) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_105");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("Servizio");
            this.erroriValidazione.add(ecc2);
        }
        if (!"SPC".equals(this.busta.getTipoServizio())) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_105");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("Servizio/tipo");
            this.erroriValidazione.add(ecc2);
        }
        if (this.busta.getAzione() == null) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_106");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("Azione");
            this.erroriValidazione.add(ecc2);
        }
        if (this.busta.getProfiloDiCollaborazione() == null) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_103");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("ProfiloCollaborazione");
            this.erroriValidazione.add(ecc2);
        }
        if (("EGOV_IT_ServizioAsincronoAsimmetrico".equals(this.busta.getProfiloDiCollaborazione()) || "EGOV_IT_ServizioAsincronoSimmetrico".equals(this.busta.getProfiloDiCollaborazione())) && this.busta.getCollaborazione() == null) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_104");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("Collaborazione");
            this.erroriValidazione.add(ecc2);
        }
        if (!"EGOV_IT_SPC".equals(this.busta.getTipoOraRegistrazione())) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_108");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("Messaggio/OraRegistrazione/tempo");
            this.erroriValidazione.add(ecc2);
        }
        if (this.busta.getConfermaRicezione()) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_113");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("ProfiloTrasmissione/confermaRicezione");
            this.erroriValidazione.add(ecc2);
        }
        if ("EGOV_IT_PIUDIUNAVOLTA".equals(this.busta.getInoltro())) {
            ecc2 = new Eccezione();
            ecc2.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc2.setCodiceEccezione("EGOV_IT_113");
            ecc2.setRilevanza("GRAVE");
            ecc2.setPosizione("ProfiloTrasmissione/inoltro");
            this.erroriValidazione.add(ecc2);
        }
        for (i = 0; i < this.busta.sizeListaTrasmissioni(); ++i) {
            tr = this.busta.getTrasmissione(i);
            if (!"SPC".equals(tr.getTipoOrigine())) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_116");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("ListaTrasmissioni/Trasmissione/Origine/IdentificativoParte/tipo");
                this.erroriValidazione.add(ecc);
            }
            if (!"SPC".equals(tr.getTipoDestinazione())) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_116");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione/IdentificativoParte/tipo");
                this.erroriValidazione.add(ecc);
            }
            if ("EGOV_IT_SPC".equals(tr.getTempo())) continue;
            ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_116");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("ListaTrasmissioni/Trasmissione/OraRegistrazione/tempo");
            this.erroriValidazione.add(ecc);
        }
        for (i = 0; i < this.busta.sizeListaRiscontri(); ++i) {
            Riscontro r = this.busta.getRiscontro(i);
            if ("EGOV_IT_SPC".equals(r.getTipoOraRegistrazione())) continue;
            ecc = new Eccezione();
            ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
            ecc.setCodiceEccezione("EGOV_IT_115");
            ecc.setRilevanza("GRAVE");
            ecc.setPosizione("ListaRiscontri/Riscontro/OraRegistrazione/tempo");
            this.erroriValidazione.add(ecc);
        }
        if (this.erroriValidazione.size() == 0) {
            if (this.busta.getIndirizzoTelematicoMittente() != null) {
                Eccezione ecc3 = new Eccezione();
                ecc3.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc3.setCodiceEccezione("EGOV_IT_101");
                ecc3.setRilevanza("INFO");
                ecc3.setPosizione("Mittente/IdentificativoParte/indirizzoTelematico");
                this.erroriValidazione.add(ecc3);
            }
            if (this.busta.getIndirizzoTelematicoDestinatario() != null) {
                Eccezione ecc4 = new Eccezione();
                ecc4.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc4.setCodiceEccezione("EGOV_IT_102");
                ecc4.setRilevanza("INFO");
                ecc4.setPosizione("Destinatario/IdentificativoParte/indirizzoTelematico");
                this.erroriValidazione.add(ecc4);
            }
            if (this.busta.getTipoServizioCorrelato() != null) {
                Eccezione ecc5 = new Eccezione();
                ecc5.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc5.setCodiceEccezione("EGOV_IT_103");
                ecc5.setRilevanza("INFO");
                ecc5.setPosizione("ProfiloCollaborazione/tipo");
                this.erroriValidazione.add(ecc5);
            }
            if (this.busta.getServizioCorrelato() != null) {
                Eccezione ecc6 = new Eccezione();
                ecc6.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc6.setCodiceEccezione("EGOV_IT_103");
                ecc6.setRilevanza("INFO");
                ecc6.setPosizione("ProfiloCollaborazione/servizioCorrelato");
                this.erroriValidazione.add(ecc6);
            }
            if (!"EGOV_IT_ServizioAsincronoAsimmetrico".equals(this.busta.getProfiloDiCollaborazione()) && !"EGOV_IT_ServizioAsincronoSimmetrico".equals(this.busta.getProfiloDiCollaborazione()) && this.busta.getCollaborazione() != null) {
                Eccezione ecc7 = new Eccezione();
                ecc7.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc7.setCodiceEccezione("EGOV_IT_104");
                ecc7.setRilevanza("INFO");
                ecc7.setPosizione("Collaborazione");
                this.erroriValidazione.add(ecc7);
            }
            if (this.busta.getSequenza() != -1L) {
                Eccezione ecc8 = new Eccezione();
                ecc8.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc8.setCodiceEccezione("EGOV_IT_401");
                ecc8.setRilevanza("INFO");
                ecc8.setPosizione("Sequenza");
                this.erroriValidazione.add(ecc8);
            }
            for (int i2 = 0; i2 < this.busta.sizeListaTrasmissioni(); ++i2) {
                tr = this.busta.getTrasmissione(i2);
                if (tr.getIndirizzoTelematicoOrigine() != null) {
                    ecc = new Eccezione();
                    ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                    ecc.setCodiceEccezione("EGOV_IT_116");
                    ecc.setRilevanza("INFO");
                    ecc.setPosizione("ListaTrasmissioni/Trasmissione/Origine/IdentificativoParte/indirizzoTelematico");
                    this.erroriValidazione.add(ecc);
                }
                if (tr.getIndirizzoTelematicoDestinazione() == null) continue;
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_116");
                ecc.setRilevanza("INFO");
                ecc.setPosizione("ListaTrasmissioni/Trasmissione/Destinazione/IdentificativoParte/indirizzoTelematico");
                this.erroriValidazione.add(ecc);
            }
            if (this.busta.sizeListaRiscontri() > 0) {
                Eccezione ecc9 = new Eccezione();
                ecc9.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc9.setCodiceEccezione("EGOV_IT_115");
                ecc9.setRilevanza("INFO");
                ecc9.setPosizione("ListaRiscontri");
                this.erroriValidazione.add(ecc9);
            }
        }
    }

    public String getServizioCorrelato() {
        return this.servizioCorrelato;
    }

    public String getTipoServizioCorrelato() {
        return this.tipoServizioCorrelato;
    }

    public ServizioEGov getInfoServizio() {
        return this.infoServizio;
    }

    public String getAzioneCorrelata() {
        return this.azioneCorrelata;
    }

    public void setAzioneCorrelata(String azioneCorrelata) {
        this.azioneCorrelata = azioneCorrelata;
    }
}

