/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.utils.ValidatoreXSD;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidazioneConSchemaSPCoop {
    private Logger log = null;
    private static ValidatoreXSD validatoreBustaSPCoop = null;
    private Vector<Eccezione> erroriValidazione;
    private Vector<Eccezione> erroriProcessamento;
    private javax.xml.soap.SOAPHeaderElement busta;
    private SOAPBody manifest;
    private boolean isSPCoopErrore = false;

    public ValidazioneConSchemaSPCoop(javax.xml.soap.SOAPHeaderElement header, SOAPBody manifest, boolean isSPCoopErrore) {
        this(header, manifest, isSPCoopErrore, Configurazione.getLibraryLog());
    }

    public ValidazioneConSchemaSPCoop(javax.xml.soap.SOAPHeaderElement header, SOAPBody manifest, boolean isSPCoopErrore, Logger aLog) {
        this.busta = header;
        this.manifest = manifest;
        this.log = aLog != null ? aLog : Logger.getLogger((String)"ValidazioneConSchemaSPCoop");
        this.isSPCoopErrore = isSPCoopErrore;
    }

    public Vector<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public Vector<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public static synchronized boolean initializeSchema(Logger log) {
        if (validatoreBustaSPCoop != null) {
            return true;
        }
        if (log == null) {
            log = Logger.getLogger((String)"ValidazioneConSchemaSPCoop");
        }
        try {
            log.info((Object)"Inizializzazione dello schema di OpenSPCoop (possono essere necessari alcuni minuti...)");
            validatoreBustaSPCoop = new ValidatoreXSD(ValidazioneConSchemaSPCoop.class.getResourceAsStream("/Busta.xsd"));
            log.info((Object)"Inizializzazione dello schema di OpenSPCoop terminata.");
            return true;
        }
        catch (Exception e) {
            log.info((Object)("Riscontrato errore durante l'inizializzazione dello schema di OpenSPCoop: " + e.getMessage()));
            validatoreBustaSPCoop = null;
            return false;
        }
    }

    public void valida() throws Exception {
        Eccezione ecc;
        block30: {
            this.erroriValidazione = new Vector();
            this.erroriProcessamento = new Vector();
            if (validatoreBustaSPCoop == null) {
                ValidazioneConSchemaSPCoop.initializeSchema(this.log);
            }
            try {
                SOAPHeaderElement header = (SOAPHeaderElement)this.busta;
                if (!this.isSPCoopErrore) {
                    MessageElement elemInterno;
                    Iterator it = header.getAllAttributes();
                    Vector<Name> attr = new Vector<Name>();
                    Vector<String> attrValue = new Vector<String>();
                    while (it.hasNext()) {
                        Name n = (Name)it.next();
                        attrValue.add(header.getAttributeValue(n));
                        attr.add(n);
                        header.removeAttribute(n);
                    }
                    Iterator itChilds = header.getChildElements();
                    Vector<Name> attrIntestazioneMessaggio = new Vector<Name>();
                    Vector<String> attrValueIntestazioneMessaggio = new Vector<String>();
                    Vector<Name> attrListeTrasmissioni = new Vector<Name>();
                    Vector<String> attrValueListeTrasmissioni = new Vector<String>();
                    Vector<Name> attrListeEccezioni = new Vector<Name>();
                    Vector<String> attrValueListeEccezioni = new Vector<String>();
                    Vector<Name> attrListeRiscontri = new Vector<Name>();
                    Vector<String> attrValueListeRiscontri = new Vector<String>();
                    while (itChilds.hasNext()) {
                        elemInterno = (MessageElement)itChilds.next();
                        Iterator itAttrElemInterno = elemInterno.getAllAttributes();
                        while (itAttrElemInterno.hasNext()) {
                            Name n = (Name)itAttrElemInterno.next();
                            if ("IntestazioneMessaggio".equals(elemInterno.getLocalName())) {
                                attrValueIntestazioneMessaggio.add(elemInterno.getAttributeValue(n));
                                attrIntestazioneMessaggio.add(n);
                            } else if ("ListaTrasmissioni".equals(elemInterno.getLocalName())) {
                                attrValueListeTrasmissioni.add(elemInterno.getAttributeValue(n));
                                attrListeTrasmissioni.add(n);
                            } else if ("ListaEccezioni".equals(elemInterno.getLocalName())) {
                                attrValueListeEccezioni.add(elemInterno.getAttributeValue(n));
                                attrListeEccezioni.add(n);
                            } else if ("ListaRiscontri".equals(elemInterno.getLocalName())) {
                                attrValueListeRiscontri.add(elemInterno.getAttributeValue(n));
                                attrListeRiscontri.add(n);
                            }
                            elemInterno.removeAttribute(n);
                        }
                    }
                    validatoreBustaSPCoop.valida((Node)header.getAsDocument());
                    while (attr.size() != 0) {
                        Name n = (Name)attr.remove(0);
                        header.addAttribute(n, (String)attrValue.remove(0));
                    }
                    itChilds = header.getChildElements();
                    while (itChilds.hasNext()) {
                        Name n;
                        elemInterno = (MessageElement)itChilds.next();
                        if ("IntestazioneMessaggio".equals(elemInterno.getLocalName())) {
                            while (attrIntestazioneMessaggio.size() != 0) {
                                n = (Name)attrIntestazioneMessaggio.remove(0);
                                elemInterno.addAttribute(n, (String)attrValueIntestazioneMessaggio.remove(0));
                            }
                            continue;
                        }
                        if ("ListaTrasmissioni".equals(elemInterno.getLocalName())) {
                            while (attrListeTrasmissioni.size() != 0) {
                                n = (Name)attrListeTrasmissioni.remove(0);
                                elemInterno.addAttribute(n, (String)attrValueListeTrasmissioni.remove(0));
                            }
                            continue;
                        }
                        if ("ListaEccezioni".equals(elemInterno.getLocalName())) {
                            while (attrListeEccezioni.size() != 0) {
                                n = (Name)attrListeEccezioni.remove(0);
                                elemInterno.addAttribute(n, (String)attrValueListeEccezioni.remove(0));
                            }
                            continue;
                        }
                        if (!"ListaRiscontri".equals(elemInterno.getLocalName())) continue;
                        while (attrListeRiscontri.size() != 0) {
                            n = (Name)attrListeRiscontri.remove(0);
                            elemInterno.addAttribute(n, (String)attrValueListeRiscontri.remove(0));
                        }
                    }
                    break block30;
                }
                Iterator itChilds = header.getChildElements();
                MessageElement listaEccezioni = null;
                while (itChilds.hasNext()) {
                    MessageElement elemInterno = (MessageElement)itChilds.next();
                    if (!"ListaEccezioni".equals(elemInterno.getLocalName())) continue;
                    listaEccezioni = elemInterno;
                    break;
                }
                if (listaEccezioni == null) {
                    throw new SAXException("ListaEccezioni non presente in un messaggio SPCoopErrore");
                }
                validatoreBustaSPCoop.valida((Node)listaEccezioni.getAsDocument());
            }
            catch (SAXException e) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_002");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione(e.getMessage());
                this.erroriValidazione.add(ecc);
            }
            catch (Exception e) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_300");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Validazione con schema xsd dell'header egov non riuscita: errore di processamento");
                this.log.error((Object)"Validazione con schema xsd dell'header egov non riuscita non riuscita", (Throwable)e);
                this.erroriProcessamento.add(ecc);
            }
        }
        if (this.manifest != null) {
            try {
                validatoreBustaSPCoop.valida((Node)((MessageElement)this.manifest.getFirstChild()).getAsDocument());
            }
            catch (SAXException e) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_003");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("ManifestAttachments: " + e.getMessage());
                this.erroriValidazione.add(ecc);
            }
            catch (Exception e) {
                ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreProcessamentoMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_300");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione("Validazione con schema xsd del manifest degli attachments non riuscita: errore di processamento");
                this.log.error((Object)"Validazione con schema xsd del manifest degli attachments non riuscita", (Throwable)e);
                this.erroriProcessamento.add(ecc);
            }
        }
    }
}

