/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.Message;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.message.InputStreamBody;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBody;
import org.apache.log4j.Logger;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.ProprietaManifestAttachments;
import org.openspcoop.egov.ValidazioneSintattica;
import org.w3c.dom.Node;

public class Sbustamento {
    private Logger log = null;

    public Sbustamento() {
        this(Configurazione.getLibraryLog());
    }

    public Sbustamento(Logger aLog) {
        this.log = aLog != null ? aLog : Logger.getLogger((String)"Sbustamento");
    }

    public SOAPHeaderElement sbustamentoEGov(Message msg, boolean gestioneManifest, ProprietaManifestAttachments proprietaManifestAttachments) throws EGovException {
        ValidazioneSintattica validator = null;
        SOAPHeader headerSOAP = null;
        SOAPHeaderElement header = null;
        try {
            validator = new ValidazioneSintattica(msg, this.log, proprietaManifestAttachments.isReadQualifiedAttribute());
            headerSOAP = msg.getSOAPHeader();
            header = validator.getHeaderEGov(headerSOAP);
            if (header == null) {
                throw new Exception("Header eGov non presente");
            }
            headerSOAP.removeChild((Node)header);
            if (gestioneManifest && msg.countAttachments() > 0) {
                this.remove_eGovManifest(msg, proprietaManifestAttachments);
            }
            SOAPHeaderElement sOAPHeaderElement = header;
            return sOAPHeaderElement;
        }
        catch (Exception e) {
            this.log.error((Object)("SbustamentoEGov non riuscito: " + e.getMessage()), (Throwable)e);
            throw new EGovException("SbustamentoEGov non riuscito: " + e.getMessage(), e);
        }
        finally {
            if (validator != null) {
                validator.setHeaderSOAP(null);
            }
        }
    }

    public Message remove_eGovManifest(Message msg, ProprietaManifestAttachments proprietaManifestAttachments) throws EGovException {
        try {
            SOAPBody body = (SOAPBody)msg.getSOAPBody();
            MessageElement descrizione = (MessageElement)body.getFirstChild();
            Iterator it = descrizione.getChildElements();
            String idMsg = null;
            while (it.hasNext()) {
                MessageElement descrizioneMessaggio = (MessageElement)it.next();
                MessageElement riferimento = (MessageElement)descrizioneMessaggio.getFirstChild();
                if (riferimento.getAttribute("role").equalsIgnoreCase(proprietaManifestAttachments.getRoleRichiesta())) {
                    idMsg = riferimento.getAttribute("href");
                    break;
                }
                if (!riferimento.getAttribute("role").equalsIgnoreCase(proprietaManifestAttachments.getRoleRisposta())) continue;
                idMsg = riferimento.getAttribute("href");
                break;
            }
            if (idMsg == null) {
                throw new Exception("DescrizioneMessaggio con ruolo " + proprietaManifestAttachments.getRoleRichiesta() + " o " + proprietaManifestAttachments.getRoleRisposta() + " non trovato.");
            }
            if (idMsg.startsWith("cid:")) {
                idMsg = idMsg.substring("cid:".length());
            }
            AttachmentPart ap = (AttachmentPart)msg.getAttachmentsImpl().removeAttachmentPart(idMsg);
            DataHandler dh = ap.getDataHandler();
            msg.getSOAPBody().removeContents();
            InputStream inputDH = dh.getInputStream();
            byte[] bytePotenzialiXML = new byte[5];
            int readByte = inputDH.read(bytePotenzialiXML);
            boolean xmlContentPresente = false;
            if (readByte == 5 && (char)bytePotenzialiXML[0] == '<' && (char)bytePotenzialiXML[1] == '?' && (char)bytePotenzialiXML[2] == 'x' && (char)bytePotenzialiXML[3] == 'm' && (char)bytePotenzialiXML[4] == 'l') {
                readByte = inputDH.read();
                while ((char)readByte != '>' && readByte != -1) {
                    readByte = inputDH.read();
                }
                if ((char)readByte == '>') {
                    xmlContentPresente = true;
                }
            }
            InputStreamBody isBody = null;
            isBody = !xmlContentPresente ? new InputStreamBody(dh.getInputStream()) : new InputStreamBody(inputDH);
            msg.getSOAPBody().addChildElement((SOAPElement)isBody);
            return msg;
        }
        catch (Exception e) {
            this.log.error((Object)("Rimozione Manifest degli Attachments non riuscita: " + e.getMessage()), (Throwable)e);
            throw new EGovException("Rimozione Manifest degli Attachments non riuscita: " + e.getMessage(), e);
        }
    }

    @Deprecated
    public byte[] removeSPCoop(byte[] header) throws EGovException {
        ByteArrayOutputStream reqByteSbustata = null;
        try {
            int indexOfEGov;
            String headerSTR = new String(header);
            int endIntestazione = 0;
            int start = 0;
            while ((indexOfEGov = headerSTR.indexOf("http://www.cnipa.it/eGov_it/portadominio", start)) != -1) {
                StringBuffer rovesciata = new StringBuffer();
                for (int i = indexOfEGov - 1; i > 0; --i) {
                    rovesciata.append((char)header[i]);
                    if ((char)header[i] != '<') continue;
                    start = i;
                    break;
                }
                StringBuffer rigaCompleta = new StringBuffer();
                rovesciata.reverse();
                rigaCompleta.append(rovesciata.toString());
                rigaCompleta.append("http://www.cnipa.it/eGov_it/portadominio");
                for (int i = indexOfEGov + "http://www.cnipa.it/eGov_it/portadominio".length(); i < header.length; ++i) {
                    rigaCompleta.append((char)header[i]);
                    if ((char)header[i] == '>') break;
                }
                if (rigaCompleta.toString().indexOf("Intestazione") != -1) {
                    endIntestazione = start - 1 + rigaCompleta.length();
                    break;
                }
                start = start - 1 + rigaCompleta.length();
            }
            if (start == 0) {
                return null;
            }
            int end = headerSTR.indexOf("Intestazione>", endIntestazione) + "Intestazione>".length();
            if (end == -1) {
                return null;
            }
            if (end <= start) {
                return null;
            }
            reqByteSbustata = new ByteArrayOutputStream();
            for (int i = 0; i < start; ++i) {
                reqByteSbustata.write(header[i]);
            }
            boolean eraserSpaziDopoEGov = false;
            for (int i = end; i < header.length; ++i) {
                if (!eraserSpaziDopoEGov && (char)header[i] == '<') {
                    eraserSpaziDopoEGov = true;
                    reqByteSbustata.write(header[i]);
                    continue;
                }
                if (!eraserSpaziDopoEGov) continue;
                reqByteSbustata.write(header[i]);
            }
            byte[] bustaSenzaEGov = reqByteSbustata.toByteArray();
            reqByteSbustata.close();
            return bustaSenzaEGov;
        }
        catch (Exception e) {
            try {
                reqByteSbustata.close();
            }
            catch (Exception eis) {
                // empty catch block
            }
            this.log.error((Object)("RimozioneHeaderSPCoop non riuscita: " + e.getMessage()), (Throwable)e);
            throw new EGovException("RimozioneHeaderSPCoop non riuscita: " + e.getMessage(), e);
        }
    }
}

