/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.egov;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.MessageFactoryImpl;
import org.apache.axis.utils.XMLUtils;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.state.IState;
import org.openspcoop.dao.state.StateMessage;
import org.openspcoop.egov.Busta;
import org.openspcoop.egov.Configurazione;
import org.openspcoop.egov.EGovException;
import org.openspcoop.egov.Eccezione;
import org.openspcoop.egov.ProprietaManifestAttachments;
import org.openspcoop.egov.Riscontro;
import org.openspcoop.egov.Trasmissione;
import org.openspcoop.egov.ValidazioneSintattica;
import org.openspcoop.utils.SoapUtils;
import org.openspcoop.utils.date.DateManager;
import org.openspcoop.wssecurity.WSSBaseUtils;
import org.openspcoop.wssecurity.WSSSender;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Imbustamento {
    private Logger log = null;
    private static int serialCounter = 0;
    private static int maxSeriale = 0;
    private static int prefixLenght = 0;

    public Imbustamento() {
        this(Configurazione.getLibraryLog());
    }

    public Imbustamento(Logger aLog) {
        this.log = aLog != null ? aLog : Logger.getLogger((String)"Imbustamento");
    }

    public static synchronized int getSerialCounter() {
        if (maxSeriale == 0) {
            if (Configurazione.getPrefixSeriale() == -1) {
                maxSeriale = 9999999;
                prefixLenght = 0;
            } else if (Configurazione.getPrefixSeriale() < 10) {
                maxSeriale = 999999;
                prefixLenght = 1;
            } else {
                maxSeriale = 99999;
                prefixLenght = 2;
            }
        }
        if (serialCounter + 1 > maxSeriale) {
            serialCounter = 0;
        }
        return ++serialCounter;
    }

    public String buildID_eGov(IState state, String idPD, String codAmm) throws EGovException {
        return this.buildID_eGov_engine(state, idPD, codAmm, Configurazione.getAttesaAttiva(), Configurazione.getCheckInterval());
    }

    public String buildID_eGov(IState state, String idPD, String codAmm, long attesaAttiva, int checkInterval) throws EGovException {
        return this.buildID_eGov_engine(state, idPD, codAmm, attesaAttiva, checkInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildID_eGov_engine(IState state, String idPD, String codAmm, long attesaAttiva, int checkInterval) throws EGovException {
        if (state == null) {
            throw new EGovException("Stato is null");
        }
        Connection conDB = null;
        boolean connessioneNegoziataDatasource = false;
        if (!"static".equals(Configurazione.getTipoSeriale())) {
            if (((StateMessage)state).getConnectionDB() == null) {
                try {
                    conDB = Configurazione.getConnectionPdD();
                    if (conDB == null) {
                        throw new Exception("Connessione non disponibile");
                    }
                    connessioneNegoziataDatasource = true;
                }
                catch (Exception e) {
                    throw new EGovException("Negoziamento connessione a database per costruzione id egov non riuscito: " + e.getMessage());
                }
            } else {
                conDB = ((StateMessage)state).getConnectionDB();
            }
        }
        try {
            int i;
            int padding;
            String c;
            long counter = -1L;
            int oldTransactionIsolation = -1;
            if (idPD == null || codAmm == null) {
                this.log.error((Object)("Creazione ID eGov non riuscita: alcuni parametri di creazione null idPD[" + idPD + "] codAmm[" + codAmm + "]"));
                throw new EGovException("Creazione ID eGov non riuscita: alcuni parametri di creazione null idPD[" + idPD + "] codAmm[" + codAmm + "]");
            }
            StringBuffer bf = new StringBuffer();
            bf.append(codAmm);
            bf.append('_');
            bf.append(idPD);
            bf.append('_');
            if (!"mysql".equals(Configurazione.getTipoSeriale())) {
                if ("static".equals(Configurazione.getTipoSeriale())) {
                    if (Configurazione.getPrefixSeriale() != -1) {
                        bf.append(Configurazione.getPrefixSeriale());
                    }
                    c = Long.toString(Imbustamento.getSerialCounter());
                    padding = 7 - prefixLenght - c.length();
                    for (i = 0; i < padding; ++i) {
                        bf.append('0');
                    }
                    bf.append(c);
                } else {
                    try {
                        oldTransactionIsolation = conDB.getTransactionIsolation();
                        conDB.setAutoCommit(false);
                        conDB.setTransactionIsolation(8);
                    }
                    catch (Exception er) {
                        this.log.error((Object)("Creazione ID eGov non riuscita (impostazione transazione): " + er.getMessage()), (Throwable)er);
                        throw new EGovException("Creazione ID eGov non riuscita (impostazione transazione): " + er.getMessage(), er);
                    }
                    boolean idBuildOK = false;
                    long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
                    while (!idBuildOK && DateManager.getTimeMillis() < scadenzaWhile) {
                        counter = -1L;
                        Statement pstmt = null;
                        Statement pstmtInsert = null;
                        ResultSet rs = null;
                        try {
                            StringBuffer queryInsert;
                            StringBuffer query = new StringBuffer();
                            query.append("SELECT COUNTER FROM ");
                            query.append("ID_EGOV");
                            query.append(" FOR UPDATE");
                            pstmt = conDB.prepareStatement(query.toString());
                            rs = pstmt.executeQuery();
                            if (rs == null) {
                                pstmt.close();
                                this.log.error((Object)"Creazione ID eGov non riuscita: ResultSet is null?");
                                throw new EGovException("Creazione ID eGov non riuscita: ResultSet is null?");
                            }
                            boolean exist = rs.next();
                            if (exist) {
                                counter = rs.getLong("COUNTER");
                                if (counter + 1L > 9999999L) {
                                    counter = 0L;
                                }
                                ++counter;
                            }
                            rs.close();
                            pstmt.close();
                            if (!exist) {
                                counter = 1L;
                                queryInsert = new StringBuffer();
                                queryInsert.append("INSERT INTO  ");
                                queryInsert.append("ID_EGOV");
                                queryInsert.append(" VALUES ( ? )");
                                pstmtInsert = conDB.prepareStatement(queryInsert.toString());
                                pstmtInsert.setLong(1, 1L);
                                pstmtInsert.execute();
                                pstmtInsert.close();
                            } else {
                                queryInsert = new StringBuffer();
                                queryInsert.append("UPDATE ");
                                queryInsert.append("ID_EGOV");
                                queryInsert.append(" SET COUNTER = ? ");
                                pstmtInsert = conDB.prepareStatement(queryInsert.toString());
                                pstmtInsert.setLong(1, counter);
                                pstmtInsert.execute();
                                pstmtInsert.close();
                            }
                            conDB.commit();
                            idBuildOK = true;
                        }
                        catch (Exception e) {
                            try {
                                if (pstmt != null) {
                                    pstmt.close();
                                }
                            }
                            catch (Exception er) {
                                // empty catch block
                            }
                            try {
                                if (pstmtInsert != null) {
                                    pstmtInsert.close();
                                }
                            }
                            catch (Exception er) {
                                // empty catch block
                            }
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            catch (Exception er) {
                                // empty catch block
                            }
                            try {
                                conDB.rollback();
                            }
                            catch (Exception er) {
                                // empty catch block
                            }
                        }
                        if (idBuildOK) continue;
                        try {
                            Thread.sleep(new Random().nextInt(checkInterval));
                        }
                        catch (Exception eRandom) {}
                    }
                    if (!idBuildOK) {
                        throw new EGovException("Creazione ID eGov non riuscita: l'accesso serializable non ha permesso la creazione del numero sequenziale");
                    }
                }
            }
            if (!"static".equals(Configurazione.getTipoSeriale())) {
                try {
                    conDB.setAutoCommit(true);
                    conDB.setTransactionIsolation(oldTransactionIsolation);
                }
                catch (Exception er) {
                    System.out.println("ERROR UNSET:" + er.getMessage());
                    this.log.error((Object)("Creazione ID eGov non riuscita (ripristino transazione): " + er.getMessage()));
                    throw new EGovException("Creazione ID eGov non riuscita (ripristino transazione): " + er.getMessage());
                }
                c = Long.toString(counter);
                padding = 7 - c.length();
                for (i = 0; i < padding; ++i) {
                    bf.append('0');
                }
                bf.append(c);
            }
            bf.append('_');
            Date now = DateManager.getDate();
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm");
            bf.append(dateformat.format(now));
            String string = bf.toString();
            return string;
        }
        finally {
            if (connessioneNegoziataDatasource) {
                try {
                    Configurazione.releaseConnectionPdD(conDB);
                }
                catch (Exception e) {
                    this.log.error((Object)"Rilascio connessione per creazione id egov non riuscito", (Throwable)e);
                }
            } else if (!"static".equals(Configurazione.getTipoSeriale())) {
                ((StateMessage)state).setConnectionDB(conDB);
            }
        }
    }

    public static String getDate_eGovFormat() {
        Date now = DateManager.getDate();
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
        return dateformat.format(now).replace('_', 'T');
    }

    @Deprecated
    public static Date getDateObject_eGovFormat() {
        return DateManager.getDate();
    }

    public SOAPElement build_eGovHeader(Busta eGov) throws EGovException {
        try {
            PrefixedQName name = new PrefixedQName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "Intestazione", "eGov_IT");
            SOAPHeaderElement eGovHeader = new SOAPHeaderElement((Name)name);
            eGovHeader.setActor("http://www.cnipa.it/eGov_it/portadominio");
            eGovHeader.setMustUnderstand(true);
            eGovHeader.addNamespaceDeclaration("SOAP_ENV", "http://schemas.xmlsoap.org/soap/envelope/");
            MessageElement eGovIntestazioneMsg = (MessageElement)eGovHeader.addChildElement("IntestazioneMessaggio");
            MessageElement eGovMitt = (MessageElement)eGovIntestazioneMsg.addChildElement("Mittente");
            MessageElement eGovIDParteMitt = (MessageElement)eGovMitt.addChildElement("IdentificativoParte");
            if (eGov.getMittente() != null) {
                eGovIDParteMitt.setValue(eGov.getMittente());
            }
            if (eGov.getTipoMittente() != null) {
                eGovIDParteMitt.setAttribute("tipo", eGov.getTipoMittente());
            }
            if (eGov.getIndirizzoTelematicoMittente() != null) {
                eGovIDParteMitt.setAttribute("indirizzoTelematico", eGov.getIndirizzoTelematicoMittente());
            }
            MessageElement eGovDest = (MessageElement)eGovIntestazioneMsg.addChildElement("Destinatario");
            MessageElement eGovIDParteDest = (MessageElement)eGovDest.addChildElement("IdentificativoParte");
            if (eGov.getDestinatario() != null) {
                eGovIDParteDest.setValue(eGov.getDestinatario());
            }
            if (eGov.getTipoDestinatario() != null) {
                eGovIDParteDest.setAttribute("tipo", eGov.getTipoDestinatario());
            }
            if (eGov.getIndirizzoTelematicoDestinatario() != null) {
                eGovIDParteDest.setAttribute("indirizzoTelematico", eGov.getIndirizzoTelematicoDestinatario());
            }
            if (eGov.getProfiloDiCollaborazione() != null) {
                MessageElement eGovProfCollaborazione = (MessageElement)eGovIntestazioneMsg.addChildElement("ProfiloCollaborazione");
                eGovProfCollaborazione.setValue(eGov.getProfiloDiCollaborazione());
                if (eGov.getServizioCorrelato() != null) {
                    eGovProfCollaborazione.setAttribute("servizioCorrelato", eGov.getServizioCorrelato());
                }
                if (eGov.getTipoServizioCorrelato() != null) {
                    eGovProfCollaborazione.setAttribute("tipo", eGov.getTipoServizioCorrelato());
                }
            }
            if (eGov.getCollaborazione() != null) {
                MessageElement eGovCollaborazione = (MessageElement)eGovIntestazioneMsg.addChildElement("Collaborazione");
                eGovCollaborazione.setValue(eGov.getCollaborazione());
            }
            if (eGov.getServizio() != null) {
                MessageElement eGovServizio = (MessageElement)eGovIntestazioneMsg.addChildElement("Servizio");
                eGovServizio.setValue(eGov.getServizio());
                if (eGov.getTipoServizio() != null) {
                    eGovServizio.setAttribute("tipo", eGov.getTipoServizio());
                }
            }
            if (eGov.getAzione() != null) {
                MessageElement eGovAzione = (MessageElement)eGovIntestazioneMsg.addChildElement("Azione");
                eGovAzione.setValue(eGov.getAzione());
            }
            MessageElement eGovMessaggio = (MessageElement)eGovIntestazioneMsg.addChildElement("Messaggio");
            MessageElement eGovIDMsg = (MessageElement)eGovMessaggio.addChildElement("Identificatore");
            if (eGov.getID() != null) {
                eGovIDMsg.setValue(eGov.getID());
            }
            MessageElement eGovOraRegistrazione = (MessageElement)eGovMessaggio.addChildElement("OraRegistrazione");
            if (eGov.getOraRegistrazione() != null) {
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
                String oraS = dateformat.format(eGov.getOraRegistrazione()).replace('_', 'T');
                eGovOraRegistrazione.setObjectValue((Object)oraS);
            }
            if (eGov.getTipoOraRegistrazione() != null) {
                eGovOraRegistrazione.setAttribute("tempo", eGov.getTipoOraRegistrazione());
            } else {
                eGovOraRegistrazione.setAttribute("tempo", "EGOV_IT_SPC");
            }
            if (eGov.getRiferimentoMessaggio() != null) {
                MessageElement eGovRifMsg = (MessageElement)eGovMessaggio.addChildElement("RiferimentoMessaggio");
                eGovRifMsg.setValue(eGov.getRiferimentoMessaggio());
            }
            if (eGov.getScadenza() != null) {
                MessageElement eGovScadenza = (MessageElement)eGovMessaggio.addChildElement("Scadenza");
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
                String oraS = dateformat.format(eGov.getScadenza()).replace('_', 'T');
                eGovScadenza.setObjectValue((Object)oraS);
            }
            MessageElement eGovProfTrasmissione = (MessageElement)eGovIntestazioneMsg.addChildElement("ProfiloTrasmissione");
            if (eGov.getInoltro() != null) {
                eGovProfTrasmissione.setAttribute("inoltro", eGov.getInoltro());
            }
            String crValue = "false";
            if (eGov.getConfermaRicezione()) {
                crValue = "true";
            }
            eGovProfTrasmissione.setAttribute("confermaRicezione", crValue);
            if (eGov.getSequenza() != -1L) {
                MessageElement eGovSequenza = (MessageElement)eGovIntestazioneMsg.addChildElement("Sequenza");
                StringBuffer bf = new StringBuffer();
                String sequenza = Long.toString(eGov.getSequenza());
                int padding = 7 - sequenza.length();
                for (int i = 0; i < padding; ++i) {
                    bf.append('0');
                }
                bf.append(sequenza);
                eGovSequenza.setAttribute("numeroProgressivo", bf.toString());
            }
            if (eGov.sizeListaRiscontri() > 0) {
                MessageElement eGovListaRiscontri = (MessageElement)eGovHeader.addChildElement("ListaRiscontri");
                for (int i = 0; i < eGov.sizeListaRiscontri(); ++i) {
                    Riscontro ris = eGov.getRiscontro(i);
                    MessageElement Riscontro2 = (MessageElement)eGovListaRiscontri.addChildElement("Riscontro");
                    if (ris.getID() != null) {
                        MessageElement id = (MessageElement)Riscontro2.addChildElement("Identificatore");
                        id.setValue(ris.getID());
                    }
                    if (ris.getOraRegistrazione() == null) continue;
                    MessageElement ora = (MessageElement)Riscontro2.addChildElement("OraRegistrazione");
                    SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
                    String oraR = dateformat.format(ris.getOraRegistrazione()).replace('_', 'T');
                    ora.setObjectValue((Object)oraR);
                    if (ris.getTipoOraRegistrazione() != null) {
                        ora.setAttribute("tempo", ris.getTipoOraRegistrazione());
                        continue;
                    }
                    ora.setAttribute("tempo", "EGOV_IT_SPC");
                }
            }
            if (eGov.sizeListaTrasmissioni() > 0) {
                boolean addFirstElement = false;
                MessageElement eGovListaTrasmissioni = null;
                for (int i = 0; i < eGov.sizeListaTrasmissioni(); ++i) {
                    Trasmissione tr = eGov.getTrasmissione(i);
                    if (tr.getOrigine() == null || tr.getTipoOrigine() == null || tr.getDestinazione() == null || tr.getTipoDestinazione() == null || tr.getOraRegistrazione() == null || tr.getTempo() == null) continue;
                    if (!addFirstElement) {
                        eGovListaTrasmissioni = (MessageElement)eGovHeader.addChildElement("ListaTrasmissioni");
                        addFirstElement = true;
                    }
                    MessageElement Trasmissione2 = (MessageElement)eGovListaTrasmissioni.addChildElement("Trasmissione");
                    MessageElement orig = (MessageElement)Trasmissione2.addChildElement("Origine");
                    MessageElement IDParteOrigine = (MessageElement)orig.addChildElement("IdentificativoParte");
                    IDParteOrigine.setValue(tr.getOrigine());
                    IDParteOrigine.setAttribute("tipo", tr.getTipoOrigine());
                    if (tr.getIndirizzoTelematicoOrigine() != null) {
                        IDParteOrigine.setAttribute("indirizzoTelematico", tr.getIndirizzoTelematicoOrigine());
                    }
                    MessageElement dest = (MessageElement)Trasmissione2.addChildElement("Destinazione");
                    MessageElement IDParteDest = (MessageElement)dest.addChildElement("IdentificativoParte");
                    IDParteDest.setValue(tr.getDestinazione());
                    IDParteDest.setAttribute("tipo", tr.getTipoDestinazione());
                    if (tr.getIndirizzoTelematicoDestinazione() != null) {
                        IDParteDest.setAttribute("indirizzoTelematico", tr.getIndirizzoTelematicoDestinazione());
                    }
                    MessageElement ora = (MessageElement)Trasmissione2.addChildElement("OraRegistrazione");
                    SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
                    String oraR = dateformat.format(tr.getOraRegistrazione()).replace('_', 'T');
                    ora.setObjectValue((Object)oraR);
                    ora.setAttribute("tempo", tr.getTempo());
                }
            }
            if (eGov.sizeListaEccezioni() > 0) {
                MessageElement eGovListaEccezioni = (MessageElement)eGovHeader.addChildElement("ListaEccezioni");
                for (int i = 0; i < eGov.sizeListaEccezioni(); ++i) {
                    Eccezione ecc = eGov.getEccezione(i);
                    MessageElement eccezione = (MessageElement)eGovListaEccezioni.addChildElement("Eccezione");
                    if (ecc.getContestoCodifica() != null) {
                        eccezione.setAttribute("contestoCodifica", ecc.getContestoCodifica());
                    }
                    if (ecc.getCodiceEccezione() != null) {
                        eccezione.setAttribute("codiceEccezione", ecc.getCodiceEccezione());
                    }
                    if (ecc.getRilevanza() != null) {
                        eccezione.setAttribute("rilevanza", ecc.getRilevanza());
                    }
                    if (ecc.getPosizione() == null) continue;
                    eccezione.setAttribute("posizione", ecc.getPosizione());
                }
            }
            return eGovHeader;
        }
        catch (Exception e) {
            this.log.error((Object)("Creazione busta eGov non riuscita: " + e.getMessage()), (Throwable)e);
            throw new EGovException("Creazione busta eGov non riuscita: " + e.getMessage(), e);
        }
    }

    public Message build_eGovManifest(Message msg, boolean isRichiesta, boolean scartaBody, boolean onlyRefreshIdManifestAttachments, ProprietaManifestAttachments proprietaManifestAttachments) throws EGovException {
        try {
            if (!onlyRefreshIdManifestAttachments) {
                PrefixedQName name = new PrefixedQName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "Descrizione", "eGov_IT");
                MessageElement descrizione = new MessageElement((Name)name);
                Iterator iter = msg.getAttachmentsImpl().getAttachments().iterator();
                int attach = 1;
                while (iter.hasNext()) {
                    org.apache.axis.attachments.AttachmentPart p = (org.apache.axis.attachments.AttachmentPart)iter.next();
                    String contentID = p.getContentId();
                    String contentLocation = p.getContentLocation();
                    String contentType = p.getContentType();
                    MessageElement descrizioneMessaggio = (MessageElement)descrizione.addChildElement("DescrizioneMessaggio");
                    MessageElement riferimento = (MessageElement)descrizioneMessaggio.addChildElement("Riferimento");
                    if (contentID != null) {
                        riferimento.setAttribute("href", "cid:" + contentID);
                    } else {
                        riferimento.setAttribute("href", contentLocation);
                    }
                    if (attach == 1 && scartaBody) {
                        if (isRichiesta) {
                            riferimento.setAttribute("role", proprietaManifestAttachments.getRoleRichiesta());
                        } else {
                            riferimento.setAttribute("role", proprietaManifestAttachments.getRoleRisposta());
                        }
                    } else {
                        riferimento.setAttribute("role", proprietaManifestAttachments.getRoleAllegato());
                    }
                    riferimento.setAttribute("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "id", "attachment" + attach);
                    MessageElement schema = (MessageElement)riferimento.addChildElement("Schema");
                    schema.setAttribute("posizione", contentType);
                    MessageElement titolo = (MessageElement)riferimento.addChildElement("Titolo");
                    titolo.setAttribute("Lingua", "it");
                    if (attach == 1 && scartaBody) {
                        if (isRichiesta) {
                            titolo.setValue(proprietaManifestAttachments.getRoleRichiesta());
                        } else {
                            titolo.setValue(proprietaManifestAttachments.getRoleRisposta());
                        }
                    } else {
                        titolo.setValue("attachment" + attach);
                    }
                    ++attach;
                }
                if (!scartaBody) {
                    byte[] body = SoapUtils.sbustamentoSOAPEnvelope((SOAPEnvelope)msg.getSOAPEnvelope());
                    org.apache.axis.attachments.AttachmentPart ap = (org.apache.axis.attachments.AttachmentPart)msg.createAttachmentPart();
                    ByteArrayInputStream isContent = new ByteArrayInputStream(body);
                    ap.setContent((Object)isContent, "text/xml");
                    msg.addAttachmentPart((AttachmentPart)ap);
                    isContent.close();
                    MessageElement descrizioneMessaggio = (MessageElement)descrizione.addChildElement("DescrizioneMessaggio");
                    MessageElement riferimento = (MessageElement)descrizioneMessaggio.addChildElement("Riferimento");
                    riferimento.setAttribute("href", "cid:" + ap.getContentId());
                    if (isRichiesta) {
                        riferimento.setAttribute("role", proprietaManifestAttachments.getRoleRichiesta());
                    } else {
                        riferimento.setAttribute("role", proprietaManifestAttachments.getRoleRisposta());
                    }
                    riferimento.setAttribute("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "id", "attachment" + attach);
                    MessageElement schema = (MessageElement)riferimento.addChildElement("Schema");
                    schema.setAttribute("posizione", ap.getContentType());
                    MessageElement titolo = (MessageElement)riferimento.addChildElement("Titolo");
                    titolo.setAttribute("Lingua", "it");
                    if (isRichiesta) {
                        titolo.setValue(proprietaManifestAttachments.getRoleRichiesta());
                    } else {
                        titolo.setValue(proprietaManifestAttachments.getRoleRisposta());
                    }
                }
                msg.getSOAPBody().removeContents();
                byte[] manifest = SoapUtils.msgElementoToByte((MessageElement)descrizione);
                ByteArrayInputStream inputManifest = new ByteArrayInputStream(manifest);
                Document document = XMLUtils.newDocument((InputStream)inputManifest);
                MessageElement manifestTypeErase = new MessageElement(document.getDocumentElement());
                msg.getSOAPBody().addChildElement((SOAPElement)manifestTypeErase);
                inputManifest.close();
            }
            return msg;
        }
        catch (Exception e) {
            this.log.error((Object)("Creazione Manifest degli attachments non riuscita: " + e.getMessage()), (Throwable)e);
            throw new EGovException("Creazione Manifest degli attachments non riuscita: " + e.getMessage(), e);
        }
    }

    public void imbustamentoEGov(Message msg, Busta busta, ProprietaManifestAttachments proprietaManifestAttachments) throws EGovException {
        this.imbustamentoEGov(msg, busta, false, false, false, false, proprietaManifestAttachments);
    }

    public void imbustamentoEGov(Message msg, Busta busta, boolean gestioneManifest, boolean isRichiesta, boolean scartaBody, boolean onlyRefreshIdManifestAttachments, ProprietaManifestAttachments proprietaManifestAttachments) throws EGovException {
        try {
            SOAPHeaderElement headerEGovElement = (SOAPHeaderElement)this.build_eGovHeader(busta);
            this.imbustamentoEGov(msg, headerEGovElement, gestioneManifest, isRichiesta, scartaBody, onlyRefreshIdManifestAttachments, proprietaManifestAttachments);
        }
        catch (Exception e) {
            this.log.error((Object)("ImbustamentoEGov non riuscito: " + e.getMessage()), (Throwable)e);
            throw new EGovException("ImbustamentoEGov non riuscito: " + e.getMessage(), e);
        }
    }

    public void imbustamentoEGov(Message msg, SOAPHeaderElement headerEGovElement, boolean gestioneManifest, boolean isRichiesta, boolean scartaBody, boolean onlyRefreshIdManifestAttachments, ProprietaManifestAttachments proprietaManifestAttachments) throws EGovException {
        try {
            byte[] headerEGov = SoapUtils.msgElementoToByte((MessageElement)headerEGovElement);
            ByteArrayInputStream inputBusta = new ByteArrayInputStream(headerEGov);
            Document document = XMLUtils.newDocument((InputStream)inputBusta);
            SOAPHeaderElement hdrEGov = new SOAPHeaderElement(document.getDocumentElement());
            SOAPHeader hdr = (SOAPHeader)msg.getSOAPHeader();
            if (hdr == null) {
                hdr = (SOAPHeader)msg.getSOAPEnvelope().addHeader();
            }
            hdr.addChildElement((SOAPElement)hdrEGov);
            if (msg.countAttachments() > 0 && gestioneManifest) {
                this.build_eGovManifest(msg, isRichiesta, scartaBody, onlyRefreshIdManifestAttachments, proprietaManifestAttachments);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("ImbustamentoEGov non riuscito: " + e.getMessage()), (Throwable)e);
            throw new EGovException("ImbustamentoEGov non riuscito: " + e.getMessage(), e);
        }
    }

    public void build_trasmissione(Trasmissione trasmissione, MessageElement listaTrasmissioni) throws EGovException {
        try {
            MessageElement trasmissioneNode = (MessageElement)listaTrasmissioni.addChildElement("Trasmissione");
            MessageElement orig = (MessageElement)trasmissioneNode.addChildElement("Origine");
            MessageElement IDParteOrigine = (MessageElement)orig.addChildElement("IdentificativoParte");
            IDParteOrigine.setValue(trasmissione.getOrigine());
            IDParteOrigine.setAttribute("tipo", trasmissione.getTipoOrigine());
            if (trasmissione.getIndirizzoTelematicoOrigine() != null) {
                IDParteOrigine.setAttribute("indirizzoTelematico", trasmissione.getIndirizzoTelematicoOrigine());
            }
            MessageElement dest = (MessageElement)trasmissioneNode.addChildElement("Destinazione");
            MessageElement IDParteDest = (MessageElement)dest.addChildElement("IdentificativoParte");
            IDParteDest.setValue(trasmissione.getDestinazione());
            IDParteDest.setAttribute("tipo", trasmissione.getTipoDestinazione());
            if (trasmissione.getIndirizzoTelematicoDestinazione() != null) {
                IDParteDest.setAttribute("indirizzoTelematico", trasmissione.getIndirizzoTelematicoDestinazione());
            }
            MessageElement ora = (MessageElement)trasmissioneNode.addChildElement("OraRegistrazione");
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
            String oraR = dateformat.format(trasmissione.getOraRegistrazione()).replace('_', 'T');
            ora.setValue(oraR);
            ora.setAttribute("tempo", trasmissione.getTempo());
        }
        catch (Exception e) {
            this.log.error((Object)("Creazione trasmissione non riuscita: " + e.getMessage()), (Throwable)e);
            throw new EGovException("Creazione trasmissione non riuscita: " + e.getMessage(), e);
        }
    }

    public void addTrasmissione(Message message, Trasmissione trasmissione, boolean readQualifiedAttribute, boolean isListaTrasmissioniEnabled) throws EGovException {
        try {
            ValidazioneSintattica validatore = new ValidazioneSintattica(message, readQualifiedAttribute);
            SOAPHeaderElement eGovHeaderOLD = (SOAPHeaderElement)validatore.getHeaderEGov();
            if (eGovHeaderOLD == null) {
                throw new EGovException("Header eGov non esistente");
            }
            PrefixedQName name = new PrefixedQName(eGovHeaderOLD.getNamespaceURI(), eGovHeaderOLD.getLocalName(), eGovHeaderOLD.getPrefix());
            SOAPHeaderElement eGovHeaderNEW = new SOAPHeaderElement((Name)name);
            eGovHeaderNEW.setActor(eGovHeaderOLD.getActor());
            eGovHeaderNEW.setMustUnderstand(eGovHeaderOLD.getMustUnderstand());
            Iterator namespaces = eGovHeaderOLD.getNamespacePrefixes();
            while (namespaces.hasNext()) {
                String mNamespace = (String)namespaces.next();
                eGovHeaderNEW.addNamespaceDeclaration(mNamespace, eGovHeaderOLD.getNamespaceURI(mNamespace));
            }
            Iterator attributes = eGovHeaderOLD.getAllAttributes();
            while (attributes.hasNext()) {
                Name mAttribute = (Name)attributes.next();
                eGovHeaderNEW.addAttribute(mAttribute, eGovHeaderOLD.getAttributeValue(mAttribute));
            }
            Iterator child = eGovHeaderOLD.getChildElements();
            while (child.hasNext()) {
                MessageElement mChild = (MessageElement)child.next();
                eGovHeaderNEW.addChild(mChild);
            }
            child = eGovHeaderNEW.getChildElements();
            MessageElement listaTrasmissioni = null;
            while (child.hasNext()) {
                MessageElement mChild = (MessageElement)child.next();
                if (!"ListaTrasmissioni".equals(mChild.getLocalName())) continue;
                listaTrasmissioni = mChild;
                break;
            }
            if (isListaTrasmissioniEnabled) {
                if (listaTrasmissioni == null) {
                    listaTrasmissioni = (MessageElement)eGovHeaderNEW.addChildElement("ListaTrasmissioni");
                }
                this.build_trasmissione(trasmissione, listaTrasmissioni);
            }
            message.getSOAPHeader().removeChild((Node)eGovHeaderOLD);
            this.imbustamentoEGov(message, eGovHeaderNEW, false, false, false, false, null);
        }
        catch (Exception e) {
            this.log.error((Object)("addTrasmissione non riuscita: " + e.getMessage()), (Throwable)e);
            throw new EGovException("addTrasmissione non riuscita: " + e.getMessage(), e);
        }
    }

    public void addTrasmissione(Message message, Trasmissione trasmissione, boolean readQualifiedAttribute) throws EGovException {
        try {
            ValidazioneSintattica validatore = new ValidazioneSintattica(message, readQualifiedAttribute);
            SOAPHeaderElement eGovHeaderOLD = (SOAPHeaderElement)validatore.getHeaderEGov();
            if (eGovHeaderOLD == null) {
                throw new EGovException("Header eGov non esistente");
            }
            PrefixedQName name = new PrefixedQName(eGovHeaderOLD.getNamespaceURI(), eGovHeaderOLD.getLocalName(), eGovHeaderOLD.getPrefix());
            SOAPHeaderElement eGovHeaderNEW = new SOAPHeaderElement((Name)name);
            eGovHeaderNEW.setActor(eGovHeaderOLD.getActor());
            eGovHeaderNEW.setMustUnderstand(eGovHeaderOLD.getMustUnderstand());
            Iterator namespaces = eGovHeaderOLD.getNamespacePrefixes();
            while (namespaces.hasNext()) {
                String mNamespace = (String)namespaces.next();
                eGovHeaderNEW.addNamespaceDeclaration(mNamespace, eGovHeaderOLD.getNamespaceURI(mNamespace));
            }
            Iterator attributes = eGovHeaderOLD.getAllAttributes();
            while (attributes.hasNext()) {
                Name mAttribute = (Name)attributes.next();
                eGovHeaderNEW.addAttribute(mAttribute, eGovHeaderOLD.getAttributeValue(mAttribute));
            }
            Iterator child = eGovHeaderOLD.getChildElements();
            while (child.hasNext()) {
                MessageElement mChild = (MessageElement)child.next();
                eGovHeaderNEW.addChild(mChild);
            }
            child = eGovHeaderNEW.getChildElements();
            MessageElement listaTrasmissioni = null;
            while (child.hasNext()) {
                MessageElement mChild = (MessageElement)child.next();
                if (!"ListaTrasmissioni".equals(mChild.getLocalName())) continue;
                listaTrasmissioni = mChild;
                break;
            }
            if (listaTrasmissioni == null) {
                listaTrasmissioni = (MessageElement)eGovHeaderNEW.addChildElement("ListaTrasmissioni");
            }
            this.build_trasmissione(trasmissione, listaTrasmissioni);
            message.getSOAPHeader().removeChild((Node)eGovHeaderOLD);
            this.imbustamentoEGov(message, eGovHeaderNEW, false, false, false, false, null);
        }
        catch (Exception e) {
            this.log.error((Object)("addTrasmissione non riuscita: " + e.getMessage()), (Throwable)e);
            throw new EGovException("addTrasmissione non riuscita: " + e.getMessage(), e);
        }
    }

    public Busta buildSPCoopErrore_Validazione(Vector<Eccezione> eccezioni, Busta busta, String id_eGov, String tipoTempo) {
        return this.buildSPCoopErrore(eccezioni, busta, id_eGov, tipoTempo);
    }

    public Busta buildSPCoopErrore_Processamento(Vector<Eccezione> eccezioni, Busta busta, String id_eGov, String tipoTempo) {
        return this.buildSPCoopErrore(eccezioni, busta, id_eGov, tipoTempo);
    }

    public Busta buildSPCoopErrore_Processamento(Eccezione ecc, Busta busta, String id_eGov, String tipoTempo) {
        Vector<Eccezione> eccs = new Vector<Eccezione>();
        eccs.add(ecc);
        return this.buildSPCoopErrore(eccs, busta, id_eGov, tipoTempo);
    }

    private Busta buildSPCoopErrore(Vector<Eccezione> eccezioni, Busta busta, String id_eGov, String tipoTempo) {
        String tipoDest = busta.getTipoMittente();
        String dest = busta.getMittente();
        String indTdest = busta.getIndirizzoTelematicoMittente();
        busta.setTipoMittente("SPC");
        busta.setMittente(busta.getDestinatario());
        busta.setIndirizzoTelematicoMittente(busta.getIndirizzoTelematicoDestinatario());
        busta.setTipoDestinatario("SPC");
        busta.setDestinatario(dest);
        busta.setIndirizzoTelematicoDestinatario(indTdest);
        busta.setTipoServizio("SPC");
        busta.setRiferimentoMessaggio(busta.getID());
        busta.setID(id_eGov);
        busta.setOraRegistrazione(DateManager.getDate());
        busta.setTipoOraRegistrazione(tipoTempo);
        while (busta.sizeListaTrasmissioni() != 0) {
            busta.removeTrasmissione(0);
        }
        while (busta.sizeListaEccezioni() != 0) {
            busta.removeEccezione(0);
        }
        while (busta.sizeListaRiscontri() != 0) {
            busta.removeRiscontro(0);
        }
        while (eccezioni.size() > 0) {
            Eccezione e = eccezioni.remove(0);
            busta.addEccezione(e);
        }
        return busta;
    }

    public Message buildAxisMsgSPCoopErrore_Validazione() {
        return this.buildAxisMsgSPCoopErrore(true, null, null);
    }

    public Message buildAxisMsgSPCoopErrore_Processamento(String detailSoggetto, String detailText) {
        return this.buildAxisMsgSPCoopErrore(false, detailSoggetto, detailText);
    }

    public Message buildAxisMsgSPCoopErrore(boolean erroreValidazione, String detailSoggetto, String detailText) {
        try {
            MessageFactoryImpl mf = new MessageFactoryImpl();
            Message msg = (Message)mf.createMessage();
            SOAPEnvelope env = msg.getSOAPEnvelope();
            env.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            SOAPBody bdy = env.getBody();
            bdy.addFault();
            SOAPFault fault = bdy.getFault();
            if (erroreValidazione) {
                fault.setFaultString("EGOV_IT_001 - Formato Busta non corretto");
                fault.setFaultCode("soap:Client");
            } else {
                fault.setFaultString("EGOV_IT_300 - Errore nel processamento del messaggio SPCoop");
                fault.setFaultCode("soap:Server");
            }
            if (!erroreValidazione && detailText != null && detailSoggetto != null) {
                String t = detailText;
                String[] testText = detailText.split(" ");
                if (testText.length > 1) {
                    t = testText[0];
                }
                fault.addDetail();
                Detail d = fault.getDetail();
                Name name = env.createName(t, detailSoggetto, "http://www.openspcoop.org");
                d.addDetailEntry(name);
            }
            return msg;
        }
        catch (Exception e) {
            this.log.error((Object)("Build msgSPCoopErrore non riuscito: " + e.getMessage()));
            return new Message((Object)new AxisFault("ErroreProcessamento"));
        }
    }

    public Message msgErroreProcessamentoSPCoop(IState state, IDSoggetto identitaPdD, String modulo, Busta busta, Vector<Eccezione> errori, Hashtable<?, ?> wssPropertiesResponse, WSSBaseUtils baseWSS, long attesaAttiva, int checkInterval, String profiloGestione, String tipoTempo, boolean generazioneListaTrasmissioni) {
        return this.msgErroreProcessamentoSPCoop(state, identitaPdD, modulo, busta, null, null, errori, wssPropertiesResponse, baseWSS, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni);
    }

    public Message msgErroreProcessamentoSPCoop(IState state, IDSoggetto identitaPdD, String modulo, Busta busta, String msgErrore, String codErrore, Hashtable<?, ?> wssPropertiesResponse, WSSBaseUtils baseWSS, long attesaAttiva, int checkInterval, String profiloGestione, String tipoTempo, boolean generazioneListaTrasmissioni) {
        return this.msgErroreProcessamentoSPCoop(state, identitaPdD, modulo, busta, msgErrore, codErrore, null, wssPropertiesResponse, baseWSS, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni);
    }

    public Message msgErroreProcessamentoSPCoop(IState state, IDSoggetto identitaPdD, String modulo, Busta busta, String msgErrore, String codErrore, Vector<Eccezione> errori, Hashtable<?, ?> wssPropertiesResponse, WSSBaseUtils baseWSS, long attesaAttiva, int checkInterval, String profiloGestione, String tipoTempo, boolean generazioneListaTrasmissioni) {
        try {
            WSSSender wssSender;
            ArrayList<Trasmissione> listaTrasmissioniBustaRichiesta = new ArrayList<Trasmissione>();
            for (int i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                listaTrasmissioniBustaRichiesta.add(busta.getTrasmissione(i));
            }
            String id_eGovErrore = this.buildID_eGov(state, identitaPdD.getCodicePorta(), identitaPdD.getNome(), attesaAttiva, checkInterval);
            if (errori == null) {
                errori = new Vector();
            }
            if (msgErrore != null && codErrore != null) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica(modulo + "_" + "ErroreProcessamentoMessaggioSPCoop");
                ecc.setCodiceEccezione("EGOV_IT_300");
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione(msgErrore);
                errori.add(ecc);
            }
            busta = this.buildSPCoopErrore_Processamento(errori, busta, id_eGovErrore, tipoTempo);
            Message responseAxisMessage = this.buildAxisMsgSPCoopErrore_Processamento(modulo, codErrore);
            if (generazioneListaTrasmissioni) {
                Trasmissione tras = new Trasmissione();
                tras.setOrigine(identitaPdD.getNome());
                tras.setTipoOrigine(identitaPdD.getTipo());
                for (int i = 0; i < listaTrasmissioniBustaRichiesta.size(); ++i) {
                    if (!identitaPdD.getTipo().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoDestinazione()) || !identitaPdD.getNome().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getDestinazione())) continue;
                    tras.setDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getOrigine());
                    tras.setTipoDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoOrigine());
                }
                tras.setOraRegistrazione(busta.getOraRegistrazione());
                tras.setTempo(busta.getTipoOraRegistrazione());
                busta.addTrasmissione(tras);
            }
            SOAPHeaderElement headerEGovElement = (SOAPHeaderElement)this.build_eGovHeader(busta);
            byte[] headerEGov = SoapUtils.msgElementoToByte((MessageElement)headerEGovElement);
            ByteArrayInputStream inputBusta = new ByteArrayInputStream(headerEGov);
            Document document = XMLUtils.newDocument((InputStream)inputBusta);
            SOAPHeaderElement hdrEGov = new SOAPHeaderElement(document.getDocumentElement());
            javax.xml.soap.SOAPHeader hdr = responseAxisMessage.getSOAPHeader();
            if (hdr == null) {
                hdr = responseAxisMessage.getSOAPEnvelope().addHeader();
            }
            hdr.addChildElement((SOAPElement)hdrEGov);
            if (wssPropertiesResponse != null && wssPropertiesResponse.size() > 0 && !(wssSender = new WSSSender(wssPropertiesResponse, baseWSS)).process(responseAxisMessage)) {
                return this.msgErroreValidazioneSPCoop(state, identitaPdD, modulo, busta, wssSender.getMsgErrore(), wssSender.getCodiceErrore(), null, null, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni);
            }
            return responseAxisMessage;
        }
        catch (Exception e) {
            this.log.error((Object)("Build msgSPCoopErroreProcessamento non riuscito: " + e.getMessage()));
            return new Message((Object)new AxisFault("ErroreProcessamento"));
        }
    }

    public Message msgErroreValidazioneSPCoop(IState state, IDSoggetto identitaPdD, String modulo, Busta busta, Vector<Eccezione> errori, Hashtable<?, ?> wssPropertiesResponse, WSSBaseUtils baseWSS, long attesaAttiva, int checkInterval, String profiloGestione, String tipoTempo, boolean generazioneListaTrasmissioni) {
        return this.msgErroreValidazioneSPCoop(state, identitaPdD, modulo, busta, null, null, errori, wssPropertiesResponse, baseWSS, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni);
    }

    public Message msgErroreValidazioneSPCoop(IState state, IDSoggetto identitaPdD, String modulo, Busta busta, String msgErrore, String codErrore, Hashtable<?, ?> wssPropertiesResponse, WSSBaseUtils baseWSS, long attesaAttiva, int checkInterval, String profiloGestione, String tipoTempo, boolean generazioneListaTrasmissioni) {
        return this.msgErroreValidazioneSPCoop(state, identitaPdD, modulo, busta, msgErrore, codErrore, null, wssPropertiesResponse, baseWSS, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni);
    }

    public Message msgErroreValidazioneSPCoop(IState state, IDSoggetto identitaPdD, String modulo, Busta busta, String msgErrore, String codErrore, Vector<Eccezione> errori, Hashtable<?, ?> wssPropertiesResponse, WSSBaseUtils baseWSS, long attesaAttiva, int checkInterval, String profiloGestione, String tipoTempo, boolean generazioneListaTrasmissioni) {
        try {
            WSSSender wssSender;
            ArrayList<Trasmissione> listaTrasmissioniBustaRichiesta = new ArrayList<Trasmissione>();
            for (int i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                listaTrasmissioniBustaRichiesta.add(busta.getTrasmissione(i));
            }
            String id_eGovErrore = this.buildID_eGov(state, identitaPdD.getCodicePorta(), identitaPdD.getNome(), attesaAttiva, checkInterval);
            if (errori == null) {
                errori = new Vector();
            }
            if (msgErrore != null && codErrore != null) {
                Eccezione ecc = new Eccezione();
                ecc.setContestoCodifica("ErroreIntestazioneMessaggioSPCoop");
                ecc.setCodiceEccezione(codErrore);
                ecc.setRilevanza("GRAVE");
                ecc.setPosizione(msgErrore);
                errori.add(ecc);
            }
            busta = this.buildSPCoopErrore_Validazione(errori, busta, id_eGovErrore, tipoTempo);
            Message responseAxisMessage = this.buildAxisMsgSPCoopErrore_Validazione();
            if (generazioneListaTrasmissioni) {
                Trasmissione tras = new Trasmissione();
                tras.setOrigine(identitaPdD.getNome());
                tras.setTipoOrigine(identitaPdD.getTipo());
                for (int i = 0; i < listaTrasmissioniBustaRichiesta.size(); ++i) {
                    if (!identitaPdD.getTipo().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoDestinazione()) || !identitaPdD.getNome().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getDestinazione())) continue;
                    tras.setDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getOrigine());
                    tras.setTipoDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoOrigine());
                }
                tras.setOraRegistrazione(busta.getOraRegistrazione());
                tras.setTempo(busta.getTipoOraRegistrazione());
                busta.addTrasmissione(tras);
            }
            SOAPHeaderElement headerEGovElement = (SOAPHeaderElement)this.build_eGovHeader(busta);
            byte[] headerEGov = SoapUtils.msgElementoToByte((MessageElement)headerEGovElement);
            ByteArrayInputStream inputBusta = new ByteArrayInputStream(headerEGov);
            Document document = XMLUtils.newDocument((InputStream)inputBusta);
            SOAPHeaderElement hdrEGov = new SOAPHeaderElement(document.getDocumentElement());
            javax.xml.soap.SOAPHeader hdr = responseAxisMessage.getSOAPHeader();
            if (hdr == null) {
                hdr = responseAxisMessage.getSOAPEnvelope().addHeader();
            }
            hdr.addChildElement((SOAPElement)hdrEGov);
            if (wssPropertiesResponse != null && wssPropertiesResponse.size() > 0 && !(wssSender = new WSSSender(wssPropertiesResponse, baseWSS)).process(responseAxisMessage)) {
                return this.msgErroreValidazioneSPCoop(state, identitaPdD, modulo, busta, wssSender.getMsgErrore(), wssSender.getCodiceErrore(), null, null, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni);
            }
            return responseAxisMessage;
        }
        catch (Exception e) {
            this.log.error((Object)("Build msgSPCoopErroreValidazione non riuscito: " + e.getMessage()));
            return new Message((Object)new AxisFault("ErroreProcessamento"));
        }
    }

    @Deprecated
    public String eraserType(String patch) throws EGovException {
        try {
            StringBuffer soapEnvelopePatch = new StringBuffer();
            int start = patch.indexOf("<eGov_IT:Intestazione");
            int end = patch.indexOf("</eGov_IT:Intestazione>") + "</eGov_IT:Intestazione>".length();
            soapEnvelopePatch.append(patch.substring(0, start));
            String header = patch.substring(start, end);
            header = header.replaceAll("xsi:type", "");
            header = header.replaceAll("=\"xsd", "");
            header = header.replaceAll(":string\"", "");
            header = header.replaceAll(":dateTime\"", "");
            soapEnvelopePatch.append(header);
            soapEnvelopePatch.append(patch.substring(end));
            return soapEnvelopePatch.toString();
        }
        catch (Exception e) {
            this.log.error((Object)("ImbustamentoEGov.eraserType_byte non riuscito: " + e.getMessage()), (Throwable)e);
            throw new EGovException("ImbustamentoEGov.eraserType_byte non riuscito: " + e.getMessage(), e);
        }
    }

    @Deprecated
    public byte[] eraserType(byte[] xml) throws EGovException {
        ByteArrayOutputStream cleanEGov = null;
        try {
            int i;
            String header = new String(xml);
            int start = header.indexOf("<eGov_IT:Intestazione");
            int end = header.indexOf("</eGov_IT:Intestazione>") + "</eGov_IT:Intestazione>".length();
            if (start == -1) {
                return null;
            }
            if (end == -1) {
                return null;
            }
            if (end <= start) {
                return null;
            }
            String eraserString = " xsi:type=\"xsd:string\"";
            String eraserDate = " xsi:type=\"xsd:dateTime\"";
            cleanEGov = new ByteArrayOutputStream();
            for (i = 0; i < start; ++i) {
                cleanEGov.write(xml[i]);
            }
            i = start;
            while (i < end) {
                if (xml[i] == 32) {
                    int k;
                    StringBuffer test;
                    if (i + eraserDate.length() < end) {
                        test = new StringBuffer();
                        for (k = 0; k < eraserDate.length(); ++k) {
                            test.append((char)xml[i + k]);
                        }
                        if (test.toString().equals(eraserDate)) {
                            i += eraserDate.length();
                            continue;
                        }
                    }
                    if (i + eraserString.length() < end) {
                        test = new StringBuffer();
                        for (k = 0; k < eraserString.length(); ++k) {
                            test.append((char)xml[i + k]);
                        }
                        if (test.toString().equals(eraserString)) {
                            i += eraserString.length();
                            continue;
                        }
                    }
                    cleanEGov.write(xml[i]);
                    ++i;
                    continue;
                }
                cleanEGov.write(xml[i]);
                ++i;
            }
            for (i = end; i < xml.length; ++i) {
                cleanEGov.write(xml[i]);
            }
            byte[] cleanBytes = cleanEGov.toByteArray();
            cleanEGov.close();
            return cleanBytes;
        }
        catch (Exception e) {
            try {
                if (cleanEGov != null) {
                    cleanEGov.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            this.log.error((Object)("ImbustamentoEGov.eraserType_byte non riuscito: " + e.getMessage()), (Throwable)e);
            throw new EGovException("ImbustamentoEGov.eraserType_byte non riuscito: " + e.getMessage(), e);
        }
    }
}

