/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerGestorePuliziaMessaggiAnomaliLib;
import org.openspcoop2.protocol.sdk.state.IState;

public class TimerGestorePuliziaMessaggiAnomaliThread
extends Thread {
    private long timeout = 10L;
    private OpenSPCoop2Properties propertiesReader;
    private MsgDiagnostico msgDiag;
    private Logger logTimer = null;
    private boolean logQuery = false;
    private int limit = 50;
    private boolean orderByQuery = false;
    private boolean stop = false;

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public TimerGestorePuliziaMessaggiAnomaliThread() throws TimerException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoop2Startup.initialize && secondi < attesa; ++secondi) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (secondi >= 90) {
            throw new TimerException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.logTimer = OpenSPCoop2Logger.getLoggerOpenSPCoopTimers();
        try {
            this.msgDiag = new MsgDiagnostico("GestoreConsistenzaDatabase", new IState[0]);
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggiInconsistenti.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI_INCONSISTENTI@", "GestoreConsistenzaDatabase");
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico";
            this.logTimer.error((Object)msgErrore, (Throwable)e);
            throw new TimerException(msgErrore, e);
        }
        this.msgDiag.logPersonalizzato("avvioInCorso");
        this.logTimer.info((Object)this.msgDiag.getMessaggio_replaceKeywords("avvioInCorso"));
        try {
            this.propertiesReader = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            String msgErrore = "Riscontrato errore durante l'inizializzazione del Reader delle Properties di OpenSPCoop: " + e.getMessage();
            this.logTimer.error((Object)msgErrore, (Throwable)e);
            throw new TimerException(msgErrore, e);
        }
        this.timeout = this.propertiesReader.getRepositoryIntervalloEliminazioneMessaggi();
        String s = "secondi";
        if (this.timeout == 1L) {
            s = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + s);
        this.logQuery = this.propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitatoLog();
        this.orderByQuery = this.propertiesReader.isTimerGestorePuliziaMessaggiAnomaliAbilitatoOrderBy();
        this.limit = this.propertiesReader.getTimerGestorePuliziaMessaggiAnomaliLimit();
        if (this.limit <= 0) {
            this.limit = 50;
        }
        this.msgDiag.addKeyword("@LIMIT@", this.limit + "");
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        this.logTimer.info((Object)this.msgDiag.getMessaggio_replaceKeywords("avvioEffettuato"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block6: while (!this.stop) {
            try {
                TimerGestorePuliziaMessaggiAnomaliLib gestoreMessaggiLib = new TimerGestorePuliziaMessaggiAnomaliLib(this.msgDiag, this.logTimer, this.propertiesReader, this.logQuery, this.limit, this.orderByQuery);
                gestoreMessaggiLib.check();
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "TimerGestorePuliziaMessaggiAnomaliLib.check()");
                this.logTimer.error((Object)("Errore generale: " + e.getMessage()), (Throwable)e);
            }
            if (this.stop) continue;
            int i = 0;
            while ((long)i < this.timeout) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.stop) continue block6;
                ++i;
            }
        }
    }
}

