/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerGestoreMessaggiLib;
import org.openspcoop2.protocol.sdk.state.IState;

public class TimerGestoreMessaggiThread
extends Thread {
    private long timeout = 10L;
    private long scadenzaMessaggio = 7200L;
    private long scadenzaCorrelazioneApplicativa = 7200L;
    private OpenSPCoop2Properties propertiesReader;
    private MsgDiagnostico msgDiag;
    private Logger logTimer = null;
    private boolean logQuery = false;
    private int limit = 50;
    private boolean orderByQuery = false;
    private boolean filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione = true;
    private boolean filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata = false;
    private boolean stop = false;

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public TimerGestoreMessaggiThread() throws TimerException {
        int secondi;
        int attesa = 90;
        for (secondi = 0; !OpenSPCoop2Startup.initialize && secondi < attesa; ++secondi) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (secondi >= 90) {
            throw new TimerException("Riscontrata inizializzazione OpenSPCoop non effettuata");
        }
        this.logTimer = OpenSPCoop2Logger.getLoggerOpenSPCoopTimers();
        try {
            this.msgDiag = new MsgDiagnostico("GestoreMessaggi", new IState[0]);
            this.msgDiag.setPrefixMsgPersonalizzati("timerGestoreMessaggi.");
            this.msgDiag.addKeyword("@ID_TIMER_GESTORE_MESSAGGI@", "GestoreMessaggi");
        }
        catch (Exception e) {
            String msgErrore = "Riscontrato Errore durante l'inizializzazione del MsgDiagnostico";
            this.logTimer.error((Object)msgErrore, (Throwable)e);
            throw new TimerException(msgErrore, e);
        }
        this.msgDiag.logPersonalizzato("avvioInCorso");
        this.logTimer.info((Object)this.msgDiag.getMessaggio_replaceKeywords("avvioInCorso"));
        try {
            this.propertiesReader = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "InizializzazioneTimer");
            String msgErrore = "Riscontrato errore durante l'inizializzazione del Reader delle Properties di OpenSPCoop: " + e.getMessage();
            this.logTimer.error((Object)msgErrore, (Throwable)e);
            throw new TimerException(msgErrore, e);
        }
        this.timeout = this.propertiesReader.getRepositoryIntervalloEliminazioneMessaggi();
        String s = "secondi";
        if (this.timeout == 1L) {
            s = "secondo";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + s);
        this.scadenzaMessaggio = this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi();
        s = "minuti";
        if (this.scadenzaMessaggio == 1L) {
            s = "minuto";
        }
        this.msgDiag.addKeyword("@SCADENZA_MESSAGGIO@", this.scadenzaMessaggio + " " + s);
        this.logQuery = this.propertiesReader.isTimerGestoreMessaggiAbilitatoLog();
        this.orderByQuery = this.propertiesReader.isTimerGestoreMessaggiAbilitatoOrderBy();
        this.limit = this.propertiesReader.getTimerGestoreMessaggiLimit();
        if (this.limit <= 0) {
            this.limit = 50;
        }
        this.msgDiag.addKeyword("@LIMIT@", this.limit + "");
        this.scadenzaCorrelazioneApplicativa = this.propertiesReader.getRepositoryIntervalloScadenzaCorrelazioneApplicativa();
        this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione = this.propertiesReader.isRepositoryScadenzaCorrelazioneApplicativaFiltraRispettoOraRegistrazione();
        this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata = this.propertiesReader.isRepositoryScadenzaCorrelazioneApplicativaFiltraRispettoOraRegistrazione_EscludiConScadenzaImpostata();
        this.msgDiag.logPersonalizzato("avvioEffettuato");
        this.logTimer.info((Object)this.msgDiag.getMessaggio_replaceKeywords("avvioEffettuato"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block6: while (!this.stop) {
            try {
                TimerGestoreMessaggiLib gestoreMessaggiLib = new TimerGestoreMessaggiLib(this.msgDiag, this.logTimer, this.propertiesReader, this.scadenzaMessaggio, this.logQuery, this.limit, this.orderByQuery, this.scadenzaCorrelazioneApplicativa, this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione, this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata);
                gestoreMessaggiLib.check();
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "TimerGestoreMessaggiLib.check()");
                this.logTimer.error((Object)("Errore generale: " + e.getMessage()), (Throwable)e);
            }
            if (this.stop) continue;
            int i = 0;
            while ((long)i < this.timeout) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.stop) continue block6;
                ++i;
            }
        }
    }
}

