/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.GestoreCorrelazioneApplicativa;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.JMSReceiver;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop2.protocol.engine.driver.RollbackRepositoryBuste;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.date.DateManager;

public class TimerGestoreMessaggiLib {
    private MsgDiagnostico msgDiag = null;
    private Logger logTimer = null;
    private OpenSPCoop2Properties propertiesReader = null;
    private long scadenzaMessaggio = -1L;
    private boolean logQuery = false;
    private int limit = 50;
    private boolean orderByQuery;
    private long scadenzaCorrelazioneApplicativa;
    private boolean filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione;
    private boolean filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata;

    public TimerGestoreMessaggiLib(MsgDiagnostico msgDiag, Logger log, OpenSPCoop2Properties p, long scadenzaMessaggio, boolean logQuery, int limit, boolean orderByQuery, long scadenzaCorrelazioneApplicativa, boolean filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione, boolean filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata) {
        this.msgDiag = msgDiag;
        this.logTimer = log;
        this.propertiesReader = p;
        this.scadenzaMessaggio = scadenzaMessaggio;
        this.logQuery = logQuery;
        this.limit = limit;
        this.orderByQuery = orderByQuery;
        this.scadenzaCorrelazioneApplicativa = scadenzaCorrelazioneApplicativa;
        this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione = filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione;
        this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata = filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws TimerException {
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logTimer.error((Object)"[GestoreMessaggi] Rilevato sistema in shutdown");
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            String msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logTimer.error((Object)msgErrore);
            throw new TimerException(msgErrore);
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.logTimer.error((Object)("[GestoreMessaggi] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logTimer.error((Object)("[GestoreMessaggi] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        this.msgDiag.logPersonalizzato("controlloInCorso");
        this.logTimer.info((Object)this.msgDiag.getMessaggio_replaceKeywords("controlloInCorso"));
        long startControlloRepositoryMessaggi = DateManager.getTimeMillis();
        GestoreMessaggi gestoreMsg = null;
        RollbackRepositoryBuste rollbackMessaggio = null;
        RollbackRepositoryBuste rollbackRepository = null;
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        try {
            openspcoopstate.initResource(this.propertiesReader.getIdentitaPortaDefault(null), "GestoreMessaggi", null);
            JMSReceiver receiverJMS = null;
            if ("jms".equals(this.propertiesReader.getNodeReceiver())) {
                receiverJMS = new JMSReceiver(this.propertiesReader.getIdentitaPortaDefault(null), "ForcedDeleteMessage", this.propertiesReader.singleConnection_NodeReceiver(), this.logTimer, null);
            }
            GestoreMessaggi gestoreMsgSearch = new GestoreMessaggi(openspcoopstate, true, this.logTimer, this.msgDiag, null);
            long timeoutRicezioneContenutiApplicativiNonGestiti = this.propertiesReader.getNodeReceiverTimeoutRicezioneContenutiApplicativi() * 3L;
            long timeoutRicezioneBusteNonGestiti = this.propertiesReader.getNodeReceiverTimeoutRicezioneBuste() * 3L;
            boolean trovatiMessaggi = true;
            while (trovatiMessaggi) {
                String strMessageSelector;
                String rifMsg;
                trovatiMessaggi = false;
                String causaMessaggiINBOXDaEliminareNonScaduti = "Eliminazione messaggi INBOX marcati logicamente da eliminare";
                Vector<String> idMsgInutiliINBOX = null;
                try {
                    GestoreMessaggi.acquireLock(this.msgDiag, causaMessaggiINBOXDaEliminareNonScaduti, this.propertiesReader.getMsgGiaInProcessamento_AttesaAttiva(), this.propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                    idMsgInutiliINBOX = gestoreMsgSearch.readMessaggiInutiliIntoInbox("GestoreMessaggi", this.limit, this.logQuery, this.orderByQuery);
                    if (idMsgInutiliINBOX.size() > 0) {
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Trovati " + idMsgInutiliINBOX.size() + " messaggi (cancellazione logica) da eliminare nel repository (INBOX) ..."));
                        }
                        trovatiMessaggi = true;
                        this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiCompletati");
                        this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                        for (int i = 0; i < idMsgInutiliINBOX.size(); ++i) {
                            String idMsgDaEliminare = idMsgInutiliINBOX.get(i);
                            this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                            try {
                                gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "INBOX", this.msgDiag, null);
                                gestoreMsg.deleteMessageWithoutLock();
                                this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                if (!this.logQuery) continue;
                                this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                continue;
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioInbox(" + idMsgDaEliminare + ")");
                                this.logTimer.error((Object)("ErroreEliminazioneMessaggioInbox(" + idMsgDaEliminare + "): " + e.getMessage()), (Throwable)e);
                            }
                        }
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Eliminati " + idMsgInutiliINBOX.size() + " messaggi (cancellazione logica) nel repository (INBOX)"));
                        }
                    } else if (this.logQuery) {
                        this.logTimer.info((Object)"Non sono stati trovati messaggi (cancellazione logica) da eliminare nel repository (INBOX)");
                    }
                }
                finally {
                    try {
                        GestoreMessaggi.releaseLock(this.msgDiag, causaMessaggiINBOXDaEliminareNonScaduti);
                    }
                    catch (Exception e) {}
                }
                String causaMessaggiOUTBOXDaEliminareNonScaduti = "Eliminazione messaggi OUTBOX marcati logicamente da eliminare";
                Vector<String> idMsgInutiliOUTBOX = null;
                try {
                    GestoreMessaggi.acquireLock(this.msgDiag, causaMessaggiOUTBOXDaEliminareNonScaduti, this.propertiesReader.getMsgGiaInProcessamento_AttesaAttiva(), this.propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                    idMsgInutiliOUTBOX = gestoreMsgSearch.readMessaggiInutiliIntoOutbox("GestoreMessaggi", this.limit, this.logQuery, this.orderByQuery);
                    if (idMsgInutiliOUTBOX.size() > 0) {
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Trovati " + idMsgInutiliOUTBOX.size() + " messaggi (cancellazione logica) da eliminare nel repository (OUTBOX) ..."));
                        }
                        trovatiMessaggi = true;
                        this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiCompletati");
                        this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                        for (int i = 0; i < idMsgInutiliOUTBOX.size(); ++i) {
                            String idMsgDaEliminare = idMsgInutiliOUTBOX.get(i);
                            this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                            try {
                                gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "OUTBOX", this.msgDiag, null);
                                gestoreMsg.deleteMessageWithoutLock();
                                this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                if (!this.logQuery) continue;
                                this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                continue;
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioOutbox(" + idMsgDaEliminare + ")");
                                this.logTimer.error((Object)("ErroreEliminazioneMessaggioOutbox(" + idMsgDaEliminare + "): " + e.getMessage()), (Throwable)e);
                            }
                        }
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Eliminati " + idMsgInutiliOUTBOX.size() + " messaggi (cancellazione logica) nel repository (OUTBOX)"));
                        }
                    } else if (this.logQuery) {
                        this.logTimer.info((Object)"Non sono stati trovati messaggi (cancellazione logica) da eliminare nel repository (OUTBOX)");
                    }
                }
                finally {
                    try {
                        GestoreMessaggi.releaseLock(this.msgDiag, causaMessaggiOUTBOXDaEliminareNonScaduti);
                    }
                    catch (Exception e) {}
                }
                String causaMessaggiINBOXScaduti = "Eliminazione messaggi INBOX scaduti";
                Vector<String> idMsgScadutiINBOX = null;
                try {
                    GestoreMessaggi.acquireLock(this.msgDiag, causaMessaggiINBOXScaduti, this.propertiesReader.getMsgGiaInProcessamento_AttesaAttiva(), this.propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                    idMsgScadutiINBOX = gestoreMsgSearch.readMessaggiScadutiIntoInbox(this.scadenzaMessaggio, this.limit, this.logQuery, this.orderByQuery);
                    if (idMsgScadutiINBOX.size() > 0) {
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Trovati " + idMsgScadutiINBOX.size() + " messaggi (scaduti) da eliminare nel repository (INBOX) ..."));
                        }
                        trovatiMessaggi = true;
                        this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiScaduti");
                        this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                        for (int i = 0; i < idMsgScadutiINBOX.size(); ++i) {
                            String idMsgDaEliminare = idMsgScadutiINBOX.get(i);
                            this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                            try {
                                String strMessageSelector2;
                                gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "INBOX", this.msgDiag, null);
                                rollbackMessaggio = new RollbackRepositoryBuste(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                                rollbackMessaggio.rollbackBustaIntoInBox();
                                String rifMsg2 = gestoreMsg.getRiferimentoMessaggio();
                                if (rifMsg2 == null) {
                                    if (receiverJMS != null && receiverJMS.clean("RicezioneBuste", strMessageSelector2 = "ID = '" + idMsgDaEliminare + "'")) {
                                        this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneBuste");
                                        this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "false");
                                        this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                                    }
                                } else {
                                    rollbackRepository = new RollbackRepositoryBuste(rifMsg2, openspcoopstate.getStatoRichiesta(), true);
                                    rollbackRepository.rollbackBustaIntoOutBox(false);
                                    if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector2 = "ID = '" + rifMsg2 + "'")) {
                                        this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneContenutiApplicativi");
                                        this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "true");
                                        this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                                    }
                                }
                                ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                                gestoreMsg.deleteMessageWithoutLock();
                                this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                if (!this.logQuery) continue;
                                this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                continue;
                            }
                            catch (Exception e) {
                                ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                                this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioScadutoInbox(" + idMsgDaEliminare + ")");
                                this.logTimer.error((Object)("ErroreEliminazioneMessaggioScadutoInbox(" + idMsgDaEliminare + "): " + e.getMessage()), (Throwable)e);
                            }
                        }
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Eliminati " + idMsgScadutiINBOX.size() + " messaggi (scaduti) nel repository (INBOX)"));
                        }
                    } else if (this.logQuery) {
                        this.logTimer.info((Object)"Non sono stati trovati messaggi (scaduti) da eliminare nel repository (INBOX)");
                    }
                }
                finally {
                    try {
                        GestoreMessaggi.releaseLock(this.msgDiag, causaMessaggiINBOXScaduti);
                    }
                    catch (Exception e) {}
                }
                String causaMessaggiOUTBOXScaduti = "Eliminazione messaggi OUTBOX scaduti";
                Vector<String> idMsgScadutiOUTBOX = null;
                try {
                    GestoreMessaggi.acquireLock(this.msgDiag, causaMessaggiOUTBOXScaduti, this.propertiesReader.getMsgGiaInProcessamento_AttesaAttiva(), this.propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                    idMsgScadutiOUTBOX = gestoreMsgSearch.readMessaggiScadutiIntoOutbox(this.scadenzaMessaggio, this.limit, this.logQuery, this.orderByQuery);
                    if (idMsgScadutiOUTBOX.size() > 0) {
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Trovati " + idMsgScadutiOUTBOX.size() + " messaggi (scaduti) da eliminare nel repository (OUTBOX) ..."));
                        }
                        trovatiMessaggi = true;
                        this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiScaduti");
                        this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                        for (int i = 0; i < idMsgScadutiOUTBOX.size(); ++i) {
                            String idMsgDaEliminare = idMsgScadutiOUTBOX.get(i);
                            this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                            try {
                                String strMessageSelector3;
                                gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "OUTBOX", this.msgDiag, null);
                                rollbackMessaggio = new RollbackRepositoryBuste(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                                rollbackMessaggio.rollbackBustaIntoOutBox();
                                String rifMsg3 = gestoreMsg.getRiferimentoMessaggio();
                                if (rifMsg3 == null) {
                                    if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector3 = "ID = '" + idMsgDaEliminare + "'")) {
                                        this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneContenutiApplicativi");
                                        this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "false");
                                        this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                                    }
                                } else {
                                    rollbackRepository = new RollbackRepositoryBuste(rifMsg3, openspcoopstate.getStatoRichiesta(), true);
                                    rollbackRepository.rollbackBustaIntoInBox(false);
                                    if (receiverJMS != null && receiverJMS.clean("RicezioneBuste", strMessageSelector3 = "ID = '" + rifMsg3 + "'")) {
                                        this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneBuste");
                                        this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "true");
                                        this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                                    }
                                }
                                ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                                gestoreMsg.deleteMessageWithoutLock();
                                this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                if (!this.logQuery) continue;
                                this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                continue;
                            }
                            catch (Exception e) {
                                ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                                this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioScadutoOutbox(" + idMsgDaEliminare + ")");
                                this.logTimer.error((Object)("ErroreEliminazioneMessaggioScadutoOutbox(" + idMsgDaEliminare + "): " + e.getMessage()), (Throwable)e);
                            }
                        }
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Eliminati " + idMsgScadutiOUTBOX.size() + " messaggi (scaduti) nel repository (OUTBOX)"));
                        }
                    } else if (this.logQuery) {
                        this.logTimer.info((Object)"Non sono stati trovati messaggi (scaduti) da eliminare nel repository (OUTBOX)");
                    }
                }
                finally {
                    try {
                        GestoreMessaggi.releaseLock(this.msgDiag, causaMessaggiOUTBOXScaduti);
                    }
                    catch (Exception e) {}
                }
                String causaMessaggiINBOXNonGestitiRicezioneContenutiApplicativi = "Eliminazione messaggi INBOX non gestiti dal servizio RicezioneContenutiApplicativi";
                Vector<String> idMsgServizioRicezioneContenutiApplicativiNonGestiti = null;
                try {
                    GestoreMessaggi.acquireLock(this.msgDiag, causaMessaggiINBOXNonGestitiRicezioneContenutiApplicativi, this.propertiesReader.getMsgGiaInProcessamento_AttesaAttiva(), this.propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                    idMsgServizioRicezioneContenutiApplicativiNonGestiti = gestoreMsgSearch.readMsgForRicezioneContenutiApplicativiNonGestiti(timeoutRicezioneContenutiApplicativiNonGestiti, this.limit, this.logQuery, this.orderByQuery);
                    if (idMsgServizioRicezioneContenutiApplicativiNonGestiti.size() > 0) {
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Trovati " + idMsgServizioRicezioneContenutiApplicativiNonGestiti.size() + " messaggi (non gestiti da 'RicezioneContenutiApplicativi') da eliminare nel repository (INBOX) ..."));
                        }
                        trovatiMessaggi = true;
                        this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiNonGestitiRicezioneContenutiApplicativi");
                        this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                        for (int i = 0; i < idMsgServizioRicezioneContenutiApplicativiNonGestiti.size(); ++i) {
                            String idMsgDaEliminare = idMsgServizioRicezioneContenutiApplicativiNonGestiti.get(i);
                            String idBustaDaEliminare = idMsgDaEliminare.split("@")[0];
                            String servizioApplicativoDaEliminare = idMsgDaEliminare.split("@")[1];
                            this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idBustaDaEliminare);
                            try {
                                gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idBustaDaEliminare, "INBOX", this.msgDiag, null);
                                if (receiverJMS != null && (rifMsg = gestoreMsg.getRiferimentoMessaggio()) != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + rifMsg + "'")) {
                                    this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneContenutiApplicativi");
                                    this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "true");
                                    this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                                }
                                gestoreMsg.eliminaDestinatarioMessaggio(servizioApplicativoDaEliminare, gestoreMsg.getRiferimentoMessaggio());
                                if (!gestoreMsg.existsServiziApplicativiDestinatariMessaggio()) {
                                    rollbackMessaggio = new RollbackRepositoryBuste(idBustaDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                                    rollbackMessaggio.rollbackBustaIntoInBox();
                                    ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                                }
                                this.msgDiag.logPersonalizzato("eliminazioneDestinatarioMessaggio");
                                if (!this.logQuery) continue;
                                this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("eliminazioneDestinatarioMessaggio"));
                                continue;
                            }
                            catch (Exception e) {
                                if (rollbackMessaggio != null) {
                                    ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                                    rollbackMessaggio = null;
                                }
                                this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioRicezioneContenutiApplicativiNonGestiti(" + idMsgDaEliminare + ")");
                                this.logTimer.error((Object)("ErroreEliminazioneMessaggioRicezioneContenutiApplicativiNonGestiti(" + idMsgDaEliminare + "): " + e.getMessage()), (Throwable)e);
                            }
                        }
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Eliminati " + idMsgServizioRicezioneContenutiApplicativiNonGestiti.size() + " messaggi (non gestiti da 'RicezioneContenutiApplicativi') nel repository (INBOX)"));
                        }
                    } else if (this.logQuery) {
                        this.logTimer.info((Object)"Non sono stati trovati messaggi (non gestiti da 'RicezioneContenutiApplicativi') da eliminare nel repository (INBOX)");
                    }
                }
                finally {
                    try {
                        GestoreMessaggi.releaseLock(this.msgDiag, causaMessaggiINBOXNonGestitiRicezioneContenutiApplicativi);
                    }
                    catch (Exception e) {}
                }
                String causaMessaggiOUTBOXNonGestitiRicezioneBuste = "Eliminazione messaggi OUTBOX non gestiti dal servizio RicezioneBuste";
                Vector<String> idMsgServizioRicezioneBusteNonGestiti = null;
                try {
                    GestoreMessaggi.acquireLock(this.msgDiag, causaMessaggiOUTBOXNonGestitiRicezioneBuste, this.propertiesReader.getMsgGiaInProcessamento_AttesaAttiva(), this.propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                    idMsgServizioRicezioneBusteNonGestiti = gestoreMsgSearch.readMsgForRicezioneBusteNonGestiti(timeoutRicezioneBusteNonGestiti, this.limit, this.logQuery, this.orderByQuery);
                    if (idMsgServizioRicezioneBusteNonGestiti.size() > 0) {
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Trovati " + idMsgServizioRicezioneBusteNonGestiti.size() + " messaggi (non gestiti da 'RicezioneBuste') da eliminare nel repository (OUTBOX) ..."));
                        }
                        trovatiMessaggi = true;
                        this.msgDiag.addKeyword("@TIPO_RICERCA@", "MessaggiNonGestitiRicezioneBuste");
                        this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "OUTBOX");
                        for (int i = 0; i < idMsgServizioRicezioneBusteNonGestiti.size(); ++i) {
                            String idMsgDaEliminare = idMsgServizioRicezioneBusteNonGestiti.get(i);
                            this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", idMsgDaEliminare);
                            try {
                                gestoreMsg = new GestoreMessaggi(openspcoopstate, true, idMsgDaEliminare, "OUTBOX", this.msgDiag, null);
                                rollbackMessaggio = new RollbackRepositoryBuste(idMsgDaEliminare, openspcoopstate.getStatoRichiesta(), true);
                                rollbackMessaggio.rollbackBustaIntoOutBox();
                                ((StateMessage)openspcoopstate.getStatoRichiesta()).executePreparedStatement();
                                if (receiverJMS != null && (rifMsg = gestoreMsg.getRiferimentoMessaggio()) != null && receiverJMS.clean("RicezioneBuste", strMessageSelector = "ID = '" + rifMsg + "'")) {
                                    this.msgDiag.addKeyword("@CODA_JMS_RICEZIONE@", "RicezioneBuste");
                                    this.msgDiag.addKeyword("@RICERCA_TRAMITE_RIFERIMENTO@", "false");
                                    this.msgDiag.logPersonalizzato("messaggioNonConsumato.codaJMS");
                                }
                                gestoreMsg.deleteMessageWithoutLock();
                                this.msgDiag.logPersonalizzato("eliminazioneMessaggio");
                                if (!this.logQuery) continue;
                                this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("eliminazioneMessaggio"));
                                continue;
                            }
                            catch (Exception e) {
                                if (rollbackMessaggio != null) {
                                    ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                                    rollbackMessaggio = null;
                                }
                                this.msgDiag.logErroreGenerico(e, "EliminazioneMessaggioRicezioneBusteNonGestiti(" + idMsgDaEliminare + ")");
                                this.logTimer.error((Object)("ErroreEliminazioneMessaggioRicezioneBusteNonGestiti(" + idMsgDaEliminare + "): " + e.getMessage()), (Throwable)e);
                            }
                        }
                        if (this.logQuery) {
                            this.logTimer.info((Object)("Eliminati " + idMsgServizioRicezioneBusteNonGestiti.size() + " messaggi (non gestiti da 'RicezioneBuste') nel repository (OUTBOX)"));
                        }
                    } else if (this.logQuery) {
                        this.logTimer.info((Object)"Non sono stati trovati messaggi (non gestiti da 'RicezioneBuste') da eliminare nel repository (OUTBOX)");
                    }
                }
                finally {
                    try {
                        GestoreMessaggi.releaseLock(this.msgDiag, causaMessaggiOUTBOXNonGestitiRicezioneBuste);
                    }
                    catch (Exception e) {}
                }
                if (!trovatiMessaggi) continue;
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_COMPLETATI_INBOX@", idMsgInutiliINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_COMPLETATI_OUTBOX@", idMsgInutiliOUTBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_SCADUTI_INBOX@", idMsgScadutiINBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_SCADUTI_OUTBOX@", idMsgScadutiOUTBOX.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_NON_GESTITI_RICEZIONE_CONTENUTI_APPLICATIVI@", idMsgServizioRicezioneContenutiApplicativiNonGestiti.size() + "");
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_NON_GESTITI_RICEZIONE_BUSTE@", idMsgServizioRicezioneBusteNonGestiti.size() + "");
                this.msgDiag.logPersonalizzato("ricercaMessaggiDaEliminare");
            }
            GestoreCorrelazioneApplicativa gestoreCorrelazioneApplicativa = new GestoreCorrelazioneApplicativa(openspcoopstate.getStatoRichiesta(), this.logTimer, null);
            Vector<Long> correlazioniScadute = gestoreCorrelazioneApplicativa.getCorrelazioniScadute(this.limit, this.logQuery, this.orderByQuery);
            this.msgDiag.addKeyword("@TIPO_RICERCA@", "CorrelazioniApplicative");
            if (this.logQuery && correlazioniScadute.size() <= 0) {
                this.logTimer.info((Object)"Non sono state trovate correlazioni applicative (scadute) da eliminare");
            }
            while (correlazioniScadute.size() > 0) {
                if (this.logQuery) {
                    this.logTimer.info((Object)("Trovate " + correlazioniScadute.size() + " correlazioni applicative (scadute) da eliminare ..."));
                }
                this.msgDiag.addKeyword("@NUMERO_CORRELAZIONI_APPLICATIVE@", correlazioniScadute.size() + "");
                this.msgDiag.logPersonalizzato("ricercaCorrelazioniApplicativeScadute");
                int size = correlazioniScadute.size();
                while (correlazioniScadute.size() > 0) {
                    Long idCorrelazioneScaduta = correlazioniScadute.remove(0);
                    String idCorrelato = null;
                    String idApplicativo = null;
                    try {
                        String[] id = gestoreCorrelazioneApplicativa.getIDMappingCorrelazioneApplicativa(idCorrelazioneScaduta);
                        this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", id[0]);
                        this.msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", id[1]);
                        gestoreCorrelazioneApplicativa.deleteCorrelazioneApplicativa(idCorrelazioneScaduta);
                        this.msgDiag.logPersonalizzato("eliminazioneCorrelazioneApplicativaScaduta");
                        if (!this.logQuery) continue;
                        this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("eliminazioneCorrelazioneApplicativaScaduta"));
                    }
                    catch (Exception e) {
                        this.msgDiag.logErroreGenerico(e, "EliminazioneCorrelazioni(id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + ")");
                        this.logTimer.error((Object)("ErroreEliminazioneCorrelazioni(id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + "): " + e.getMessage()), (Throwable)e);
                    }
                }
                if (this.logQuery) {
                    this.logTimer.info((Object)("Eliminate " + size + " correlazioni applicative (scadute)"));
                }
                correlazioniScadute = gestoreCorrelazioneApplicativa.getCorrelazioniScadute(this.limit, this.logQuery, this.orderByQuery);
            }
            if (this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione) {
                Vector<Long> correlazioniScaduteRispettoOraRegistrazione = gestoreCorrelazioneApplicativa.getCorrelazioniScaduteRispettoOraRegistrazione(this.limit, this.scadenzaCorrelazioneApplicativa, this.logQuery, this.orderByQuery, this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata);
                if (this.logQuery && correlazioniScaduteRispettoOraRegistrazione.size() <= 0) {
                    this.logTimer.info((Object)"Non sono state trovate correlazioni applicative (scadute rispetto ora registrazione) da eliminare");
                }
                while (correlazioniScaduteRispettoOraRegistrazione.size() > 0) {
                    if (this.logQuery) {
                        this.logTimer.info((Object)("Trovate " + correlazioniScaduteRispettoOraRegistrazione.size() + " correlazioni applicative (scadute rispetto ora registrazione) da eliminare ..."));
                    }
                    this.msgDiag.addKeyword("@NUMERO_CORRELAZIONI_APPLICATIVE@", correlazioniScaduteRispettoOraRegistrazione.size() + "");
                    this.msgDiag.logPersonalizzato("ricercaCorrelazioniApplicativeScaduteRispettoOraRegistrazione");
                    int size = correlazioniScaduteRispettoOraRegistrazione.size();
                    while (correlazioniScaduteRispettoOraRegistrazione.size() > 0) {
                        Long idCorrelazioneScaduta = correlazioniScaduteRispettoOraRegistrazione.remove(0);
                        String idCorrelato = null;
                        String idApplicativo = null;
                        try {
                            String[] id = gestoreCorrelazioneApplicativa.getIDMappingCorrelazioneApplicativa(idCorrelazioneScaduta);
                            this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_ELIMINARE@", id[0]);
                            this.msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", id[1]);
                            gestoreCorrelazioneApplicativa.deleteCorrelazioneApplicativa(idCorrelazioneScaduta);
                            this.msgDiag.logPersonalizzato("eliminazioneCorrelazioneApplicativaScaduta");
                            if (!this.logQuery) continue;
                            this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("eliminazioneCorrelazioneApplicativaScaduta"));
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "EliminazioneCorrelazioniRispettoOraRegistrazione(id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + ")");
                            this.logTimer.error((Object)("ErroreEliminazioneCorrelazioniRispettoOraRegistrazione(id_applicativo:" + idApplicativo + ",id_busta:" + idCorrelato + "): " + e.getMessage()), (Throwable)e);
                        }
                    }
                    if (this.logQuery) {
                        this.logTimer.info((Object)("Eliminate " + size + " correlazioni applicative (scadute rispetto ora registrazione)"));
                    }
                    correlazioniScaduteRispettoOraRegistrazione = gestoreCorrelazioneApplicativa.getCorrelazioniScaduteRispettoOraRegistrazione(this.limit, this.scadenzaCorrelazioneApplicativa, this.logQuery, this.orderByQuery, this.filtraCorrelazioniApplicativeScaduteRispettoOraRegistrazione_escludiCorrelazioniConScadenzaImpostata);
                }
            }
            if (this.propertiesReader.isTimerGestoreMessaggiVerificaConnessioniAttive()) {
                this.logTimer.info((Object)"Verifico connessioni attive...");
                Enumeration<String> identificatoriConnettoriPD = RepositoryConnettori.getIdentificatoriConnettori_pd();
                if (this.logQuery && (identificatoriConnettoriPD == null || !identificatoriConnettoriPD.hasMoreElements())) {
                    this.logTimer.info((Object)"Non sono state trovate connessioni attive sulle PorteDelegate");
                }
                if (identificatoriConnettoriPD != null) {
                    boolean verificaEffettuata = false;
                    if (this.logQuery && identificatoriConnettoriPD.hasMoreElements()) {
                        this.logTimer.info((Object)"Sono state trovate connessioni attive sulle PorteDelegate, verifica in corso ...");
                    }
                    while (identificatoriConnettoriPD.hasMoreElements()) {
                        String msgErrore;
                        verificaEffettuata = true;
                        String identificatoreConnessione = identificatoriConnettoriPD.nextElement();
                        String tipoConnettore = null;
                        IConnettore connettore = null;
                        try {
                            connettore = RepositoryConnettori.getConnettorePD(identificatoreConnessione);
                            if (connettore != null) {
                                tipoConnettore = connettore.getClass().getSimpleName();
                            }
                            int millisecondiScadenza = this.propertiesReader.getConnectionLife_inoltroBuste();
                            Date now = DateManager.getDate();
                            Date scadenza = new Date(now.getTime() - (long)millisecondiScadenza);
                            String tipoConnessione = "tipo:" + tipoConnettore + " porta:delegata id_busta:" + identificatoreConnessione;
                            this.logTimer.debug((Object)"--------------------------------------");
                            this.logTimer.debug((Object)tipoConnessione);
                            this.logTimer.debug((Object)("SCADENZA [" + scadenza.toString() + "]   CONNETTORE [" + connettore.getCreationDate().toString() + "]"));
                            if (connettore.getCreationDate().before(scadenza)) {
                                this.logTimer.info((Object)"SCADUTO");
                                this.msgDiag.addKeyword("@TIPO_CONNESSIONE@", tipoConnessione);
                                this.msgDiag.addKeyword("@DATA_CREAZIONE_CONNESSIONE@", connettore.getCreationDate().toString());
                                this.msgDiag.logPersonalizzato("connessioneScaduta.EliminazioneInCorso");
                                connettore = RepositoryConnettori.removeConnettorePD(identificatoreConnessione);
                                if (connettore != null) {
                                    connettore.disconnect();
                                }
                                this.msgDiag.logPersonalizzato("connessioneScaduta.EliminazioneEffettuata");
                            } else {
                                this.logTimer.debug((Object)"NON SCADUTO");
                            }
                            this.logTimer.debug((Object)"--------------------------------------");
                        }
                        catch (Exception e) {
                            if (tipoConnettore != null) {
                                msgErrore = "EliminazioneConnessione(tipo:" + tipoConnettore + " porta:delegata id_busta:" + identificatoreConnessione + ")";
                                this.msgDiag.logErroreGenerico(e, msgErrore);
                                this.logTimer.error((Object)("Errore" + msgErrore + ": " + e.getMessage()), (Throwable)e);
                                continue;
                            }
                            msgErrore = "EliminazioneConnessione(porta:delegata id_busta:" + identificatoreConnessione + ")";
                            this.msgDiag.logErroreGenerico(e, msgErrore);
                            this.logTimer.error((Object)("Errore" + msgErrore + ": " + e.getMessage()), (Throwable)e);
                        }
                        catch (Throwable e) {
                            if (tipoConnettore != null) {
                                msgErrore = "EliminazioneConnessione(tipo:" + tipoConnettore + " porta:delegata id_busta:" + identificatoreConnessione + ")";
                                this.msgDiag.logErroreGenerico(e, msgErrore);
                                this.logTimer.error((Object)("Errore" + msgErrore + ": " + e.getMessage()), e);
                                continue;
                            }
                            msgErrore = "EliminazioneConnessione(porta:delegata id_busta:" + identificatoreConnessione + ")";
                            this.msgDiag.logErroreGenerico(e, msgErrore);
                            this.logTimer.error((Object)("Errore" + msgErrore + ": " + e.getMessage()), e);
                        }
                    }
                    if (this.logQuery && verificaEffettuata) {
                        this.logTimer.info((Object)"Terminata verifica connessioni attive sulle PorteDelegate");
                    }
                }
                Enumeration<String> identificatoriConnettoriPA = RepositoryConnettori.getIdentificatoriConnettori_pa();
                if (this.logQuery && (identificatoriConnettoriPA == null || !identificatoriConnettoriPA.hasMoreElements())) {
                    this.logTimer.info((Object)"Non sono state trovate connessioni attive sulle PorteApplicative");
                }
                if (identificatoriConnettoriPA != null) {
                    boolean verificaEffettuata = false;
                    if (this.logQuery && identificatoriConnettoriPD.hasMoreElements()) {
                        this.logTimer.info((Object)"Sono state trovate connessioni attive sulle PorteApplicative, verifica in corso ...");
                    }
                    while (identificatoriConnettoriPA.hasMoreElements()) {
                        String msgErrore;
                        String identificatoreConnessione = identificatoriConnettoriPA.nextElement();
                        String tipoConnettore = null;
                        IConnettore connettore = null;
                        try {
                            connettore = RepositoryConnettori.getConnettorePA(identificatoreConnessione);
                            if (connettore != null) {
                                tipoConnettore = connettore.getClass().getSimpleName();
                            }
                            int millisecondiScadenza = this.propertiesReader.getConnectionLife_inoltroBuste();
                            Date now = DateManager.getDate();
                            Date scadenza = new Date(now.getTime() - (long)millisecondiScadenza);
                            String tipoConnessione = "tipo:" + tipoConnettore + " porta:applicativa id_busta:" + identificatoreConnessione;
                            this.logTimer.debug((Object)"--------------------------------------");
                            this.logTimer.debug((Object)tipoConnessione);
                            this.logTimer.debug((Object)("SCADENZA [" + scadenza.toString() + "]   CONNETTORE [" + connettore.getCreationDate().toString() + "]"));
                            if (connettore.getCreationDate().before(scadenza)) {
                                this.logTimer.info((Object)"SCADUTO");
                                this.msgDiag.addKeyword("@TIPO_CONNESSIONE@", tipoConnessione);
                                this.msgDiag.addKeyword("@DATA_CREAZIONE_CONNESSIONE@", connettore.getCreationDate().toString());
                                this.msgDiag.logPersonalizzato("connessioneScaduta.EliminazioneInCorso");
                                connettore = RepositoryConnettori.removeConnettorePA(identificatoreConnessione);
                                if (connettore != null) {
                                    connettore.disconnect();
                                }
                                this.msgDiag.logPersonalizzato("connessioneScaduta.EliminazioneEffettuata");
                            } else {
                                this.logTimer.debug((Object)"NON SCADUTO");
                            }
                            this.logTimer.debug((Object)"--------------------------------------");
                        }
                        catch (Exception e) {
                            if (tipoConnettore != null) {
                                msgErrore = "EliminazioneConnessione(tipo:" + tipoConnettore + " porta:applicativa id_busta:" + identificatoreConnessione + ")";
                                this.msgDiag.logErroreGenerico(e, msgErrore);
                                this.logTimer.error((Object)("Errore" + msgErrore + ": " + e.getMessage()), (Throwable)e);
                                continue;
                            }
                            msgErrore = "EliminazioneConnessione(porta:applicativa id_busta:" + identificatoreConnessione + ")";
                            this.msgDiag.logErroreGenerico(e, msgErrore);
                            this.logTimer.error((Object)("Errore" + msgErrore + ": " + e.getMessage()), (Throwable)e);
                        }
                        catch (Throwable e) {
                            if (tipoConnettore != null) {
                                msgErrore = "EliminazioneConnessione(tipo:" + tipoConnettore + " porta:applicativa id_busta:" + identificatoreConnessione + ")";
                                this.msgDiag.logErroreGenerico(e, msgErrore);
                                this.logTimer.error((Object)("Errore" + msgErrore + ": " + e.getMessage()), e);
                                continue;
                            }
                            msgErrore = "EliminazioneConnessione(porta:applicativa id_busta:" + identificatoreConnessione + ")";
                            this.msgDiag.logErroreGenerico(e, msgErrore);
                            this.logTimer.error((Object)("Errore" + msgErrore + ": " + e.getMessage()), e);
                        }
                    }
                    if (this.logQuery && verificaEffettuata) {
                        this.logTimer.info((Object)"Terminata verifica connessioni attive sulle PorteApplicative");
                    }
                }
            } else {
                this.logTimer.warn((Object)"Non verifico connessioni attive");
            }
            long endControlloRepositoryMessaggi = DateManager.getTimeMillis();
            this.logTimer.info((Object)("Controllo Repository Messaggi terminata in " + (endControlloRepositoryMessaggi - startControlloRepositoryMessaggi) / 1000L + " secondi"));
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneMessaggi");
            this.logTimer.error((Object)("Riscontrato errore durante la gestione del repository dei messaggi: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (openspcoopstate != null) {
                openspcoopstate.releaseResource();
            }
        }
    }
}

