/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.EJBUtilsException;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.mdb.InoltroBusteMessage;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.driver.BustaNonRiscontrata;
import org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.driver.Riscontri;
import org.openspcoop2.protocol.engine.driver.RollbackRepositoryBuste;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.Loader;

public class TimerGestoreBusteNonRiscontrateLib {
    private MsgDiagnostico msgDiag = null;
    private Logger logTimer = null;
    private OpenSPCoop2Properties propertiesReader = null;
    private boolean logQuery = false;
    private int limit = 50;
    private long timeout = 10L;
    private ConfigurazionePdDManager configurazionePdDReader;
    private RegistroServiziManager registroServiziReader;
    private static String tipoNodeSender = null;
    private ProtocolFactoryManager protocolFactoryManager = null;

    public TimerGestoreBusteNonRiscontrateLib(MsgDiagnostico msgDiag, Logger log, OpenSPCoop2Properties p, boolean logQuery, int limit, long timeout, ConfigurazionePdDManager configurazionePdDReader, RegistroServiziManager registroServiziReader) throws TimerException {
        this.msgDiag = msgDiag;
        this.logTimer = log;
        this.propertiesReader = p;
        this.logQuery = logQuery;
        this.limit = limit;
        this.timeout = timeout;
        this.configurazionePdDReader = configurazionePdDReader;
        this.registroServiziReader = registroServiziReader;
        try {
            this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
        }
        catch (Exception e) {
            throw new TimerException("Riscontrato errore durante l'inizializzazione del ProtocolFactoryManager: " + e.getMessage(), e);
        }
        if (tipoNodeSender == null) {
            try {
                tipoNodeSender = this.propertiesReader.getNodeSender();
            }
            catch (Exception e) {
                throw new TimerException("Riscontrato errore durante l'inizializzazione del Thread GestoreBusteNonRiscontrate (NodeSender): " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws TimerException {
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logTimer.error((Object)"[GestoreBusteNonRiscontrate] Rilevato sistema in shutdown");
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            String msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logTimer.error((Object)msgErrore);
            throw new TimerException(msgErrore);
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.logTimer.error((Object)("[GestoreBusteNonRiscontrate] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logTimer.error((Object)("[GestoreBusteNonRiscontrate] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        if (this.configurazionePdDReader.getTimeoutRiscontro() < 1L) {
            String msgErrore = "Riscontrato errore durante la lettura del timeout per le buste non riscontrate (<=0 ??)";
            this.msgDiag.logErroreGenerico(msgErrore, "getTimeoutRiscontro()");
            this.logTimer.error((Object)msgErrore);
            return;
        }
        this.timeout = this.configurazionePdDReader.getTimeoutRiscontro();
        String minuti = "minuti";
        if (this.timeout == 1L) {
            minuti = "minuto";
        }
        this.msgDiag.addKeyword("@TIMEOUT@", this.timeout + " " + minuti);
        this.msgDiag.addKeyword("@LIMIT@", this.limit + "");
        this.msgDiag.logPersonalizzato("controlloInCorso");
        this.logTimer.info((Object)this.msgDiag.getMessaggio_replaceKeywords("controlloInCorso"));
        long startControlloBusteNonRiscontrate = DateManager.getTimeMillis();
        GestoreMessaggi gestoreMsg = null;
        GestoreMessaggi messaggioDaInviare = null;
        RepositoryBuste repositoryBuste = null;
        Riscontri gestoreRiscontri = null;
        RollbackRepositoryBuste rollbackRepositoryBuste = null;
        OpenSPCoopStateful openspcoopState = new OpenSPCoopStateful();
        try {
            openspcoopState.initResource(this.propertiesReader.getIdentitaPortaDefault(null), "GestoreBusteNonRiscontrate", null);
            Riscontri rBuste = new Riscontri(openspcoopState.getStatoRichiesta(), this.logTimer);
            int offsetRiscontri = 0;
            Vector busteOneWayToSend = rBuste.getBustePerUlterioreInoltro(this.timeout, this.limit, offsetRiscontri, this.logQuery);
            if (this.logQuery && busteOneWayToSend != null && busteOneWayToSend.size() <= 0) {
                this.logTimer.info((Object)"Non sono state trovate buste con profilo oneway non riscontrate da rispedire");
            }
            while (busteOneWayToSend != null && busteOneWayToSend.size() > 0) {
                if (this.logQuery) {
                    this.logTimer.info((Object)("Trovate " + busteOneWayToSend.size() + " buste con profilo oneway non riscontrate da rispedire ..."));
                }
                for (int i = 0; i < busteOneWayToSend.size(); ++i) {
                    Busta bustaToSend;
                    String idBustaDaRispedire;
                    block75: {
                        ServizioApplicativo sa;
                        IDPortaDelegata idPD;
                        RichiestaDelegata richiestaDelegata;
                        ProprietaErroreApplicativo erroreAppl;
                        IDServizio servizioBusta;
                        IProtocolFactory protocolFactory;
                        PdDContext pddContext;
                        block76: {
                            BustaNonRiscontrata bustaNonRiscontrata = (BustaNonRiscontrata)busteOneWayToSend.get(i);
                            idBustaDaRispedire = bustaNonRiscontrata.getIdentificativo();
                            this.msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idBustaDaRispedire);
                            this.msgDiag.addKeyword("@PROFILO_COLLABORAZIONE@", bustaNonRiscontrata.getProfiloCollaborazione().name());
                            this.msgDiag.logPersonalizzato("bustaNonRiscontrata");
                            if (this.logQuery) {
                                this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("bustaNonRiscontrata"));
                            }
                            if (!(messaggioDaInviare = new GestoreMessaggi(openspcoopState, true, idBustaDaRispedire, "OUTBOX", this.logTimer, this.msgDiag, null)).existsMessage_noCache()) {
                                this.msgDiag.logPersonalizzato("bustaNonRiscontrata.messaggioNonEsistente");
                                this.logTimer.error((Object)this.msgDiag.getMessaggio_replaceKeywords("bustaNonRiscontrata.messaggioNonEsistente"));
                                try {
                                    repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), true, null);
                                    repositoryBuste.eliminaUtilizzoPdDFromOutBox(idBustaDaRispedire);
                                    gestoreRiscontri = new Riscontri(openspcoopState.getStatoRichiesta(), null);
                                    gestoreRiscontri.validazioneRiscontroRicevuto(idBustaDaRispedire);
                                    ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneBustaNonRiscontrataNonEsistente(" + idBustaDaRispedire + ")");
                                    this.logTimer.error((Object)("ErroreEliminazioneBustaNonRiscontrataNonEsistente(" + idBustaDaRispedire + "): " + e.getMessage()), (Throwable)e);
                                }
                                continue;
                            }
                            pddContext = messaggioDaInviare.getPdDContext();
                            protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
                            repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), this.logTimer, true, protocolFactory);
                            bustaToSend = repositoryBuste.getBustaFromOutBox(idBustaDaRispedire);
                            this.msgDiag.addKeywords(bustaToSend, true);
                            Date scadenza = bustaToSend.getScadenza();
                            Timestamp now = DateManager.getTimestamp();
                            if (scadenza.before(now)) {
                                this.msgDiag.logPersonalizzato("bustaNonRiscontrataScaduta");
                                if (this.logQuery) {
                                    this.logTimer.info((Object)this.msgDiag.getMessaggio_replaceKeywords("bustaNonRiscontrataScaduta"));
                                }
                                try {
                                    repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), true, protocolFactory);
                                    repositoryBuste.eliminaUtilizzoPdDFromOutBox(bustaToSend.getID());
                                    ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                                    gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag, pddContext);
                                    gestoreMsg.validateAndDeleteMsgOneWayRiscontrato();
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneBustaNonRiscontrataScaduta(" + bustaToSend.getID() + ")");
                                    this.logTimer.error((Object)("ErroreEliminazioneBustaNonRiscontrataScaduta(" + bustaToSend.getID() + "): " + e.getMessage()), (Throwable)e);
                                }
                                break block75;
                            }
                            IDSoggetto soggettoBustaNonRiscontrata = new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente());
                            IDSoggetto identitaPdD = null;
                            String dominioRD = null;
                            try {
                                dominioRD = this.configurazionePdDReader.getIdentificativoPorta(soggettoBustaNonRiscontrata, protocolFactory);
                                if (dominioRD == null) {
                                    throw new Exception("Dominio is null");
                                }
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "BustaNonRiscontrata getDominio(" + soggettoBustaNonRiscontrata + ")");
                            }
                            identitaPdD = dominioRD == null ? this.propertiesReader.getIdentitaPortaDefault(null) : new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente(), dominioRD);
                            servizioBusta = new IDServizio(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario(), bustaToSend.getTipoServizio(), bustaToSend.getServizio(), bustaToSend.getAzione());
                            repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), true, protocolFactory);
                            Integrazione infoIntegrazione = repositoryBuste.getInfoIntegrazioneFromOutBox(bustaToSend.getID());
                            erroreAppl = this.propertiesReader.getProprietaGestioneErrorePD(protocolFactory.createProtocolManager());
                            erroreAppl.setDominio(identitaPdD.getCodicePorta());
                            richiestaDelegata = new RichiestaDelegata(soggettoBustaNonRiscontrata, infoIntegrazione.getLocationPD(), infoIntegrazione.getServizioApplicativo(), servizioBusta, infoIntegrazione.getIdModuloInAttesa(), erroreAppl, identitaPdD);
                            richiestaDelegata.setScenario(infoIntegrazione.getScenario());
                            richiestaDelegata.setUtilizzoConsegnaAsincrona(true);
                            richiestaDelegata.setIdCollaborazione(bustaToSend.getCollaborazione());
                            richiestaDelegata.setProfiloCollaborazione(bustaToSend.getProfiloDiCollaborazione(), bustaToSend.getProfiloDiCollaborazioneValue());
                            try {
                                richiestaDelegata.setIdCorrelazioneApplicativa(messaggioDaInviare.getIDCorrelazioneApplicativa());
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            idPD = richiestaDelegata.getIdPortaDelegata();
                            idPD.setSoggettoFruitore(soggettoBustaNonRiscontrata);
                            sa = null;
                            String servizioApplicativo = richiestaDelegata.getServizioApplicativo();
                            try {
                                if (servizioApplicativo != null) {
                                    this.configurazionePdDReader.getServizioApplicativo(idPD, servizioApplicativo);
                                }
                            }
                            catch (Exception e) {
                                if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(servizioApplicativo)) break block76;
                                throw e;
                            }
                        }
                        String implementazioneMittente = this.registroServiziReader.getImplementazionePdD(new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente()), null);
                        String implementazioneDestinatario = this.registroServiziReader.getImplementazionePdD(new IDSoggetto(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario()), null);
                        this.configurazionePdDReader.aggiornaProprietaGestioneErrorePD(erroreAppl, sa);
                        String profiloGestione = this.registroServiziReader.getProfiloGestioneFruizioneServizio(servizioBusta, null);
                        richiestaDelegata.setProfiloGestione(profiloGestione);
                        PortaDelegata pd = this.configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                        boolean oneWayStateless = this.configurazionePdDReader.isModalitaStateless(pd, bustaToSend.getProfiloDiCollaborazione());
                        boolean oneWayVersione11 = this.propertiesReader.isGestioneOnewayStateful_1_1() && !oneWayStateless;
                        InoltroBusteMessage inoltroMSG = new InoltroBusteMessage();
                        inoltroMSG.setRichiestaDelegata(richiestaDelegata);
                        inoltroMSG.setBusta(bustaToSend);
                        inoltroMSG.setOneWayVersione11(oneWayVersione11);
                        if (oneWayVersione11) {
                            OpenSPCoopStateless stateless = new OpenSPCoopStateless();
                            StatelessMessage statelessMessage = new StatelessMessage();
                            statelessMessage.setBusta(bustaToSend);
                            stateless.setStatoRichiesta((IState)statelessMessage);
                            inoltroMSG.setOpenspcoopstate(stateless);
                        }
                        inoltroMSG.setImplementazionePdDSoggettoMittente(implementazioneMittente);
                        inoltroMSG.setImplementazionePdDSoggettoDestinatario(implementazioneDestinatario);
                        inoltroMSG.setPddContext(pddContext);
                        gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag, pddContext);
                        if ("db".equals(tipoNodeSender)) {
                            gestoreMsg.ripristinaMessaggio();
                            break block75;
                        }
                        try {
                            String classTypeNodeSender = null;
                            INodeSender nodeSender = null;
                            try {
                                classTypeNodeSender = ClassNameProperties.getInstance().getNodeSender(tipoNodeSender);
                                nodeSender = (INodeSender)Loader.getInstance().newInstance(classTypeNodeSender);
                                AbstractCore.init(nodeSender, pddContext, protocolFactory, new Object[0]);
                            }
                            catch (Exception e) {
                                throw new EJBUtilsException("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage(), e);
                            }
                            nodeSender.send(inoltroMSG, "InoltroBuste", this.msgDiag, this.propertiesReader.getIdentitaPortaDefault(null), "GestoreBusteNonRiscontrate", bustaToSend.getID(), gestoreMsg);
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(InoltroBuste)");
                            this.logTimer.error((Object)"Spedizione->InoltroBuste non riuscita", (Throwable)e);
                            if (openspcoopState != null) {
                                openspcoopState.releaseResource();
                            }
                            return;
                        }
                    }
                    try {
                        if (!this.logQuery) continue;
                        this.logTimer.debug((Object)("Gestita/Reinviata busta OneWay non riscontrata con ID [" + bustaToSend.getID() + "]"));
                        continue;
                    }
                    catch (Exception e) {
                        String msgErrore = "RespedizioneBustaNonRiscontrata ErroreGenerale(" + idBustaDaRispedire + ")";
                        this.msgDiag.logErroreGenerico(e, msgErrore);
                        this.logTimer.error((Object)(msgErrore + ": " + e.getMessage()), (Throwable)e);
                    }
                }
                if (this.logQuery) {
                    this.logTimer.info((Object)("Gestite " + busteOneWayToSend.size() + " buste con profilo oneway non riscontrate da rispedire"));
                }
                busteOneWayToSend = rBuste.getBustePerUlterioreInoltro(this.timeout, this.limit, offsetRiscontri += busteOneWayToSend.size(), this.logQuery);
            }
            ProfiloDiCollaborazione pBuste = new ProfiloDiCollaborazione(openspcoopState.getStatoRichiesta(), this.logTimer, null);
            int offsetBusteAsincrone = 0;
            Vector busteAsincroneToSend = pBuste.asincrono_getBusteAsincronePerUlterioreInoltro(this.timeout, this.limit, offsetBusteAsincrone, this.logQuery);
            if (this.logQuery && busteAsincroneToSend != null && busteAsincroneToSend.size() <= 0) {
                this.logTimer.info((Object)"Non sono state trovate buste con profilo asincrono non riscontrate da rispedire");
            }
            while (busteAsincroneToSend != null && busteAsincroneToSend.size() > 0) {
                if (this.logQuery) {
                    this.logTimer.info((Object)("Trovate " + busteAsincroneToSend.size() + " buste con profilo asincrono non riscontrate da rispedire ..."));
                }
                for (int i = 0; i < busteAsincroneToSend.size(); ++i) {
                    Busta bustaToSend;
                    String idBustaDaRispedire;
                    block77: {
                        ServizioApplicativo sa;
                        RichiestaDelegata richiestaDelegata;
                        ProprietaErroreApplicativo erroreAppl;
                        IProtocolFactory protocolFactory;
                        PdDContext pddContext;
                        block78: {
                            BustaNonRiscontrata bustaNonRiscontrata = (BustaNonRiscontrata)busteAsincroneToSend.get(i);
                            idBustaDaRispedire = bustaNonRiscontrata.getIdentificativo();
                            this.msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idBustaDaRispedire);
                            this.msgDiag.addKeyword("@PROFILO_COLLABORAZIONE@", bustaNonRiscontrata.getProfiloCollaborazione().name());
                            this.msgDiag.logPersonalizzato("ricevutaAsincronaNonRicevuta");
                            if (this.logQuery) {
                                this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("ricevutaAsincronaNonRicevuta"));
                            }
                            if (!(messaggioDaInviare = new GestoreMessaggi(openspcoopState, true, idBustaDaRispedire, "OUTBOX", this.logTimer, this.msgDiag, null)).existsMessage_noCache()) {
                                this.msgDiag.logPersonalizzato("ricevutaAsincronaNonRicevuta.messaggioNonEsistente");
                                this.logTimer.error((Object)this.msgDiag.getMessaggio_replaceKeywords("ricevutaAsincronaNonRicevuta.messaggioNonEsistente"));
                                try {
                                    repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), true, null);
                                    repositoryBuste.eliminaUtilizzoPdDFromOutBox(idBustaDaRispedire);
                                    rollbackRepositoryBuste = new RollbackRepositoryBuste(idBustaDaRispedire, openspcoopState.getStatoRichiesta(), true);
                                    rollbackRepositoryBuste.rollbackBustaIntoOutBox();
                                    ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneBustaAsincronaNonEsistente(" + idBustaDaRispedire + ")");
                                    this.logTimer.error((Object)("ErroreEliminazioneBustaAsincronaNonEsistente(" + idBustaDaRispedire + "): " + e.getMessage()), (Throwable)e);
                                }
                                continue;
                            }
                            pddContext = messaggioDaInviare.getPdDContext();
                            protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
                            repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), this.logTimer, true, protocolFactory);
                            bustaToSend = repositoryBuste.getBustaFromOutBox(idBustaDaRispedire);
                            this.msgDiag.addKeywords(bustaToSend, true);
                            Date scadenza = bustaToSend.getScadenza();
                            Timestamp now = DateManager.getTimestamp();
                            if (scadenza.before(now)) {
                                this.msgDiag.logPersonalizzato("ricevutaAsincronaNonRicevuta.bustaScaduta");
                                if (this.logQuery) {
                                    this.logTimer.info((Object)this.msgDiag.getMessaggio_replaceKeywords("ricevutaAsincronaNonRicevuta.bustaScaduta"));
                                }
                                try {
                                    rollbackRepositoryBuste = new RollbackRepositoryBuste(bustaToSend.getID(), openspcoopState.getStatoRichiesta(), true);
                                    rollbackRepositoryBuste.rollbackBustaIntoOutBox();
                                    ((StateMessage)openspcoopState.getStatoRichiesta()).executePreparedStatement();
                                    gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag, pddContext);
                                    gestoreMsg.logicDeleteMessage();
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "EliminazioneBustaAsincronaScaduta(" + bustaToSend.getID() + ")");
                                    this.logTimer.error((Object)("ErroreEliminazioneBustaAsincronaScaduta(" + bustaToSend.getID() + "): " + e.getMessage()), (Throwable)e);
                                }
                                break block77;
                            }
                            IDSoggetto soggettoBustaNonRiscontrata = new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente());
                            IDSoggetto identitaPdD = null;
                            String dominioRD = null;
                            try {
                                dominioRD = this.configurazionePdDReader.getIdentificativoPorta(soggettoBustaNonRiscontrata, protocolFactory);
                                if (dominioRD == null) {
                                    throw new Exception("Dominio is null");
                                }
                            }
                            catch (Exception e) {
                                this.msgDiag.logErroreGenerico(e, "BustaAsincrona getDominio(" + soggettoBustaNonRiscontrata + ")");
                                this.logTimer.error((Object)("ErroreBustaAsincrona getDominio(" + soggettoBustaNonRiscontrata + "): " + e.getMessage()), (Throwable)e);
                            }
                            identitaPdD = dominioRD == null ? this.propertiesReader.getIdentitaPortaDefault(null) : new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente(), dominioRD);
                            IDServizio servizioBusta = new IDServizio(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario(), bustaToSend.getTipoServizio(), bustaToSend.getServizio(), bustaToSend.getAzione());
                            repositoryBuste = new RepositoryBuste(openspcoopState.getStatoRichiesta(), true, protocolFactory);
                            Integrazione infoIntegrazione = repositoryBuste.getInfoIntegrazioneFromOutBox(bustaToSend.getID());
                            erroreAppl = this.propertiesReader.getProprietaGestioneErrorePD(protocolFactory.createProtocolManager());
                            erroreAppl.setDominio(identitaPdD.getCodicePorta());
                            richiestaDelegata = new RichiestaDelegata(soggettoBustaNonRiscontrata, infoIntegrazione.getLocationPD(), infoIntegrazione.getServizioApplicativo(), servizioBusta, infoIntegrazione.getIdModuloInAttesa(), erroreAppl, identitaPdD);
                            richiestaDelegata.setScenario(infoIntegrazione.getScenario());
                            if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaToSend.getProfiloDiCollaborazione()) && bustaToSend.getRiferimentoMessaggio() == null) {
                                richiestaDelegata.setUtilizzoConsegnaAsincrona(false);
                            } else {
                                richiestaDelegata.setUtilizzoConsegnaAsincrona(true);
                            }
                            richiestaDelegata.setRicevutaAsincrona(false);
                            IDPortaDelegata idPD = richiestaDelegata.getIdPortaDelegata();
                            idPD.setSoggettoFruitore(soggettoBustaNonRiscontrata);
                            sa = null;
                            String servizioApplicativo = richiestaDelegata.getServizioApplicativo();
                            try {
                                if (servizioApplicativo != null) {
                                    this.configurazionePdDReader.getServizioApplicativo(idPD, servizioApplicativo);
                                }
                            }
                            catch (Exception e) {
                                if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(servizioApplicativo)) break block78;
                                throw e;
                            }
                        }
                        this.configurazionePdDReader.aggiornaProprietaGestioneErrorePD(erroreAppl, sa);
                        InoltroBusteMessage inoltroMSG = new InoltroBusteMessage();
                        inoltroMSG.setRichiestaDelegata(richiestaDelegata);
                        inoltroMSG.setBusta(bustaToSend);
                        gestoreMsg = new GestoreMessaggi(openspcoopState, true, bustaToSend.getID(), "OUTBOX", this.msgDiag, pddContext);
                        inoltroMSG.setPddContext(pddContext);
                        if ("db".equals(tipoNodeSender)) {
                            gestoreMsg.ripristinaMessaggio();
                            break block77;
                        }
                        try {
                            String classTypeNodeSender = null;
                            INodeSender nodeSender = null;
                            try {
                                classTypeNodeSender = ClassNameProperties.getInstance().getNodeSender(tipoNodeSender);
                                nodeSender = (INodeSender)Loader.getInstance().newInstance(classTypeNodeSender);
                                AbstractCore.init(nodeSender, pddContext, protocolFactory, new Object[0]);
                            }
                            catch (Exception e) {
                                throw new EJBUtilsException("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage(), e);
                            }
                            nodeSender.send(inoltroMSG, "InoltroBuste", this.msgDiag, this.propertiesReader.getIdentitaPortaDefault(null), "GestoreBusteNonRiscontrate", bustaToSend.getID(), gestoreMsg);
                        }
                        catch (Exception e) {
                            this.msgDiag.logErroreGenerico(e, "Asincrono GenericLib.nodeSender.send(InoltroBuste)");
                            this.logTimer.error((Object)"Spedizione->InoltroBuste non riuscita", (Throwable)e);
                            if (openspcoopState != null) {
                                openspcoopState.releaseResource();
                            }
                            return;
                        }
                    }
                    try {
                        if (!this.logQuery) continue;
                        this.logTimer.info((Object)("Gestita/Reinviata busta asincrona, la cui ricevuta non e' pervenuta, con ID [" + bustaToSend.getID() + "]"));
                        continue;
                    }
                    catch (Exception e) {
                        String msgErrore = "RespedizioneBustaAsincrona ErroreGenerale(" + idBustaDaRispedire + ")";
                        this.msgDiag.logErroreGenerico(e, msgErrore);
                        this.logTimer.error((Object)(msgErrore + ": " + e.getMessage()), (Throwable)e);
                    }
                }
                if (this.logQuery) {
                    this.logTimer.info((Object)("Gestite " + busteAsincroneToSend.size() + " buste con profilo asincrono non riscontrate da rispedire"));
                }
                busteAsincroneToSend = pBuste.asincrono_getBusteAsincronePerUlterioreInoltro(this.timeout, this.limit, offsetBusteAsincrone += busteAsincroneToSend.size(), this.logQuery);
            }
            long endControlloBusteNonRiscontrate = DateManager.getTimeMillis();
            this.logTimer.info((Object)("Controllo Buste in attesa di riscontro terminata in " + (endControlloBusteNonRiscontrate - startControlloBusteNonRiscontrate) / 1000L + " secondi"));
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneBusteNonRiscontrate");
            this.logTimer.error((Object)("Riscontrato errore durante la gestione delle buste non riscontrate: " + e.getMessage()), (Throwable)e);
            return;
        }
        finally {
            if (openspcoopState != null) {
                openspcoopState.releaseResource();
            }
        }
    }
}

