/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.timers;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDPortaApplicativaByNome;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaApplicativa;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.MessaggioServizioApplicativo;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardToConfiguration;
import org.openspcoop2.pdd.core.behaviour.StatoFunzionalita;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativiMessage;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerException;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.utils.date.DateManager;

public class TimerConsegnaContenutiApplicativi {
    private MsgDiagnostico msgDiag = null;
    private Logger logTimer = null;
    private OpenSPCoop2Properties propertiesReader = null;
    private boolean logQuery = false;
    private int limit = 50;
    private boolean orderByQuery;
    private long timeout;
    private RegistroServiziManager registroServiziReader;
    private ConfigurazionePdDManager configurazionePdDReader;

    public TimerConsegnaContenutiApplicativi(MsgDiagnostico msgDiag, Logger log, OpenSPCoop2Properties p, boolean logQuery, int limit, boolean orderByQuery, ConfigurazionePdDManager configurazionePdDReader, RegistroServiziManager registroServiziReader, long timeout) {
        this.msgDiag = msgDiag;
        this.logTimer = log;
        this.propertiesReader = p;
        this.logQuery = logQuery;
        this.limit = limit;
        this.orderByQuery = orderByQuery;
        this.timeout = timeout;
        this.configurazionePdDReader = configurazionePdDReader;
        this.registroServiziReader = registroServiziReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws TimerException {
        if (OpenSPCoop2Startup.contextDestroyed) {
            this.logTimer.error((Object)"[TimerConsegnaContenutiApplicativi] Rilevato sistema in shutdown");
            return;
        }
        if (!OpenSPCoop2Startup.initialize) {
            this.msgDiag.logFatalError("inizializzazione di OpenSPCoop non effettuata", "Check Inizializzazione");
            String msgErrore = "Riscontrato errore: inizializzazione del Timer o di OpenSPCoop non effettuata";
            this.logTimer.error((Object)msgErrore);
            throw new TimerException(msgErrore);
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            this.logTimer.error((Object)("[TimerConsegnaContenutiApplicativi] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            return;
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            this.logTimer.error((Object)("[TimerConsegnaContenutiApplicativi] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            return;
        }
        this.msgDiag.logPersonalizzato("controlloInCorso");
        this.logTimer.info((Object)this.msgDiag.getMessaggio_replaceKeywords("controlloInCorso"));
        long startControlloRepositoryMessaggi = DateManager.getTimeMillis();
        OpenSPCoopStateful openspcoopstateGestore = new OpenSPCoopStateful();
        try {
            openspcoopstateGestore.initResource(this.propertiesReader.getIdentitaPortaDefault(null), "TimerConsegnaContenutiApplicativi", null);
            GestoreMessaggi gestoreMsgSearch = new GestoreMessaggi(openspcoopstateGestore, true, this.logTimer, this.msgDiag, null);
            RepositoryBuste repositoryBuste = new RepositoryBuste(openspcoopstateGestore.getStatoRichiesta(), true, null);
            boolean trovatiMessaggi = true;
            Date now = DateManager.getDate();
            while (trovatiMessaggi) {
                Vector<MessaggioServizioApplicativo> msgDaRiconsegnareINBOX;
                block47: {
                    trovatiMessaggi = false;
                    String causaMessaggiINBOXDaRiconsegnare = "Messaggi da riconsegnare verso il modulo ConsegnaContenutiApplicativi";
                    msgDaRiconsegnareINBOX = null;
                    try {
                        GestoreMessaggi.acquireLock(this.msgDiag, causaMessaggiINBOXDaRiconsegnare, this.propertiesReader.getMsgGiaInProcessamento_AttesaAttiva(), this.propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                        msgDaRiconsegnareINBOX = gestoreMsgSearch.readMessaggiDaRiconsegnareIntoBox(this.limit, this.logQuery, this.orderByQuery, now);
                        if (msgDaRiconsegnareINBOX.size() > 0) {
                            if (this.logQuery) {
                                this.logTimer.info((Object)("Trovati " + msgDaRiconsegnareINBOX.size() + " messaggi da inoltrare al modulo ConsegnaContenutiApplicativi (INBOX) ..."));
                            }
                            trovatiMessaggi = true;
                            this.msgDiag.addKeyword("@TIPO_MESSAGGIO@", "INBOX");
                            for (int i = 0; i < msgDaRiconsegnareINBOX.size(); ++i) {
                                MessaggioServizioApplicativo msgServizioApplicativo = msgDaRiconsegnareINBOX.get(i);
                                String servizioApplicativo = msgServizioApplicativo.getServizioApplicativo();
                                String idMsgDaInoltrare = msgServizioApplicativo.getIdMessaggio();
                                this.msgDiag.addKeyword("@ID_MESSAGGIO_DA_INOLTRARE@", idMsgDaInoltrare);
                                this.msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizioApplicativo);
                                GestoreMessaggi messaggioDaInviare = null;
                                OpenSPCoopState openspcoopstateMesssaggio = null;
                                try {
                                    Busta bustaToSend = repositoryBuste.getBustaFromInBox(idMsgDaInoltrare);
                                    this.msgDiag.addKeywords(bustaToSend, true);
                                    IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(bustaToSend.getProtocollo());
                                    String implementazioneMittente = this.registroServiziReader.getImplementazionePdD(new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente()), null);
                                    String implementazioneDestinatario = this.registroServiziReader.getImplementazionePdD(new IDSoggetto(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario()), null);
                                    messaggioDaInviare = new GestoreMessaggi(openspcoopstateGestore, true, idMsgDaInoltrare, "INBOX", this.logTimer, this.msgDiag, null);
                                    PdDContext pddContext = messaggioDaInviare.getPdDContext();
                                    IDSoggetto soggettoFruitore = new IDSoggetto(bustaToSend.getTipoMittente(), bustaToSend.getMittente());
                                    IDServizio servizioBusta = new IDServizio(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario(), bustaToSend.getTipoServizio(), bustaToSend.getServizio(), bustaToSend.getAzione());
                                    IDSoggetto identitaPdD = null;
                                    String dominioRD = null;
                                    try {
                                        dominioRD = this.configurazionePdDReader.getIdentificativoPorta(servizioBusta.getSoggettoErogatore(), protocolFactory);
                                        if (dominioRD == null) {
                                            throw new Exception("Dominio is null");
                                        }
                                    }
                                    catch (Exception e) {
                                        this.msgDiag.logErroreGenerico(e, "BustaNonRiscontrata getDominio(" + servizioBusta.getSoggettoErogatore() + ")");
                                    }
                                    identitaPdD = dominioRD == null ? this.propertiesReader.getIdentitaPortaDefault(null) : new IDSoggetto(bustaToSend.getTipoDestinatario(), bustaToSend.getDestinatario(), dominioRD);
                                    IDPortaApplicativaByNome idPAbyNome = new IDPortaApplicativaByNome();
                                    idPAbyNome.setNome(msgServizioApplicativo.getNomePorta());
                                    idPAbyNome.setSoggetto(servizioBusta.getSoggettoErogatore());
                                    RichiestaApplicativa richiestaApplicativa = new RichiestaApplicativa(soggettoFruitore, servizioBusta, identitaPdD, idPAbyNome);
                                    richiestaApplicativa.setServizioApplicativo(servizioApplicativo);
                                    ConsegnaContenutiApplicativiMessage consegnaMSG = new ConsegnaContenutiApplicativiMessage();
                                    consegnaMSG.setBusta(bustaToSend);
                                    consegnaMSG.setOneWayVersione11(false);
                                    consegnaMSG.setStateless(true);
                                    consegnaMSG.setImplementazionePdDSoggettoMittente(implementazioneMittente);
                                    consegnaMSG.setImplementazionePdDSoggettoDestinatario(implementazioneDestinatario);
                                    consegnaMSG.setPddContext(pddContext);
                                    consegnaMSG.setIdMessaggioPreBehaviour(bustaToSend.getRiferimentoMessaggio());
                                    BehaviourForwardToConfiguration behaviourForwardToConfiguration = new BehaviourForwardToConfiguration();
                                    if (msgServizioApplicativo.isSbustamentoSoap()) {
                                        behaviourForwardToConfiguration.setSbustamentoSoap(StatoFunzionalita.ABILITATA);
                                    } else {
                                        behaviourForwardToConfiguration.setSbustamentoSoap(StatoFunzionalita.DISABILITATA);
                                    }
                                    if (msgServizioApplicativo.isSbustamentoInformazioniProtocollo()) {
                                        behaviourForwardToConfiguration.setSbustamentoInformazioniProtocollo(StatoFunzionalita.ABILITATA);
                                    } else {
                                        behaviourForwardToConfiguration.setSbustamentoInformazioniProtocollo(StatoFunzionalita.DISABILITATA);
                                    }
                                    consegnaMSG.setBehaviourForwardToConfiguration(behaviourForwardToConfiguration);
                                    consegnaMSG.setRichiestaApplicativa(richiestaApplicativa);
                                    ConsegnaContenutiApplicativi lib = new ConsegnaContenutiApplicativi(OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
                                    openspcoopstateMesssaggio = new OpenSPCoopStateful();
                                    openspcoopstateMesssaggio.setMessageLib(consegnaMSG);
                                    EsitoLib result = lib.onMessage(openspcoopstateMesssaggio);
                                    if (this.logQuery) {
                                        this.logTimer.debug((Object)("Invocato ConsegnaContenutiApplicativi per [" + bustaToSend.getID() + "] con esito: " + result.getStatoInvocazione()), (Throwable)result.getErroreNonGestito());
                                    }
                                    if (3 == result.getStatoInvocazione()) {
                                        if (!result.isDataRispedizioneAggiornata()) {
                                            messaggioDaInviare.aggiornaDataRispedizione(new Timestamp(DateManager.getTimeMillis() + this.timeout * 1000L), servizioApplicativo);
                                        }
                                        if (result.isErroreProcessamentoMessaggioAggiornato()) continue;
                                        if (result.getErroreNonGestito() != null) {
                                            messaggioDaInviare.aggiornaErroreProcessamentoMessaggio("[TimerConsegnaContenutiApplicativi] " + result.getErroreNonGestito().getMessage(), servizioApplicativo);
                                            continue;
                                        }
                                        if (result.getMotivazioneErroreNonGestito() != null) {
                                            messaggioDaInviare.aggiornaErroreProcessamentoMessaggio("[TimerConsegnaContenutiApplicativi] " + result.getMotivazioneErroreNonGestito(), servizioApplicativo);
                                            continue;
                                        }
                                        messaggioDaInviare.aggiornaErroreProcessamentoMessaggio("[TimerConsegnaContenutiApplicativi] Invocato ConsegnaContenutiApplicativi per [" + bustaToSend.getID() + "] con esito: " + result.getStatoInvocazione(), servizioApplicativo);
                                        continue;
                                    }
                                    this.msgDiag.logPersonalizzato("inoltroMessaggio");
                                    if (!this.logQuery) continue;
                                    this.logTimer.debug((Object)this.msgDiag.getMessaggio_replaceKeywords("inoltroMessaggio"));
                                    continue;
                                }
                                catch (Exception e) {
                                    this.msgDiag.logErroreGenerico(e, "InoltroMessaggioInbox(" + idMsgDaInoltrare + ")");
                                    this.logTimer.error((Object)("ErroreInoltroMessaggioInbox(" + idMsgDaInoltrare + "): " + e.getMessage()), (Throwable)e);
                                    messaggioDaInviare.aggiornaDataRispedizione(new Timestamp(DateManager.getTimeMillis() + this.timeout * 1000L), servizioApplicativo);
                                    messaggioDaInviare.aggiornaErroreProcessamentoMessaggio("[TimerConsegnaContenutiApplicativi] " + e.getMessage(), servizioApplicativo);
                                    continue;
                                }
                                finally {
                                    try {
                                        if (openspcoopstateMesssaggio != null && !openspcoopstateMesssaggio.resourceReleased()) {
                                            openspcoopstateMesssaggio.releaseResource();
                                        }
                                    }
                                    catch (Exception e) {}
                                }
                            }
                            if (this.logQuery) {
                                this.logTimer.info((Object)("Inoltrati " + msgDaRiconsegnareINBOX.size() + " messaggi letti dal repository (INBOX)"));
                            }
                            break block47;
                        }
                        if (this.logQuery) {
                            this.logTimer.info((Object)"Non sono stati trovati messaggi da re-inoltrare verso il modulo ConsegnaContenutiApplicativi nel repository (INBOX)");
                        }
                    }
                    finally {
                        try {
                            GestoreMessaggi.releaseLock(this.msgDiag, causaMessaggiINBOXDaRiconsegnare);
                        }
                        catch (Exception e) {}
                    }
                }
                if (!trovatiMessaggi) continue;
                this.msgDiag.addKeyword("@NUMERO_MESSAGGI_INOLTRATI@", msgDaRiconsegnareINBOX.size() + "");
                this.msgDiag.logPersonalizzato("ricercaMessaggiDaInoltrare");
            }
            long endControlloRepositoryMessaggi = DateManager.getTimeMillis();
            this.logTimer.info((Object)("Controllo Repository Messaggi (Riconsegna verso ConsegnaContenutiApplicativi) terminata in " + (endControlloRepositoryMessaggi - startControlloRepositoryMessaggi) / 1000L + " secondi"));
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestioneMessaggiRiconsegnaConsegnaContenutiApplicativi");
            this.logTimer.error((Object)("Riscontrato errore durante la gestione del repository dei messaggi (Riconsegna verso ConsegnaContenutiApplicativi): " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (openspcoopstateGestore != null) {
                openspcoopstateGestore.releaseResource();
            }
        }
    }
}

