/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.skeleton;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPFault;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.message.SoapUtilsBuildParameter;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.autenticazione.GestoreCredenzialiConfigurationException;
import org.openspcoop2.pdd.core.autenticazione.IAutenticazione;
import org.openspcoop2.pdd.core.autenticazione.IGestoreCredenzialiIM;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.IntegrationManagerRequestContext;
import org.openspcoop2.pdd.core.handlers.IntegrationManagerResponseContext;
import org.openspcoop2.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop2.pdd.core.handlers.PreInRequestContext;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativi;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativiContext;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.services.ServletUtils;
import org.openspcoop2.pdd.services.skeleton.IntegrationManagerException;
import org.openspcoop2.pdd.services.skeleton.IntegrationManagerMessage;
import org.openspcoop2.pdd.services.skeleton.IntegrationManagerMessageBoxInterface;
import org.openspcoop2.pdd.services.skeleton.IntegrationManagerPDInterface;
import org.openspcoop2.pdd.services.skeleton.Operazione;
import org.openspcoop2.pdd.services.skeleton.ProtocolHeaderInfo;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop2.pdd.timers.TimerThreshold;
import org.openspcoop2.protocol.engine.LetturaParametriBusta;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.IBustaBuilder;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.Esito;
import org.openspcoop2.protocol.sdk.constants.EsitoIM;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.IUniqueIdentifier;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.resources.TransportRequestContext;

public abstract class IntegrationManager
implements IntegrationManagerMessageBoxInterface,
IntegrationManagerPDInterface {
    public static String ID_MODULO = IDService.INTEGRATION_MANAGER_SOAP.getValue();
    private OpenSPCoop2Properties propertiesReader;
    private ClassNameProperties className;
    private boolean inizializzato = false;
    private static Boolean staticInitialized = false;
    public static Boolean isActiveIMService = true;
    private String[] tipiGestoriCredenziali = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (!this.inizializzato) {
            this.propertiesReader = OpenSPCoop2Properties.getInstance();
            this.className = ClassNameProperties.getInstance();
            this.inizializzato = true;
            Boolean bl = staticInitialized;
            synchronized (bl) {
                if (!staticInitialized.booleanValue()) {
                    staticInitialized = true;
                    isActiveIMService = ConfigurazionePdDManager.getInstance().isIMServiceActive();
                }
            }
        }
    }

    protected abstract HttpServletRequest getHttpServletRequest() throws IntegrationManagerException;

    protected abstract HttpServletResponse getHttpServletResponse() throws IntegrationManagerException;

    private IProtocolFactory getProtocolFactory(Logger log) throws IntegrationManagerException {
        try {
            String protocolName = (String)this.getHttpServletRequest().getAttribute("PROTOCOLLO");
            return ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolName);
        }
        catch (Exception e) {
            log.error((Object)("Errore durante il recupero della ProtocolFactory: " + e.getMessage()), (Throwable)e);
            throw new IntegrationManagerException(null, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
        }
    }

    private void checkIMAuthorization(Logger log) throws IntegrationManagerException {
        try {
            Object o = this.getHttpServletRequest().getAttribute("INTEGRATION_MANAGER_ENGINE_DIRECT_INVOCATION");
            if (o == null || !(o instanceof Boolean)) {
                throw new Exception("Invocazione del Servizio non autorizzata");
            }
            Boolean b = (Boolean)o;
            if (!b.booleanValue()) {
                throw new Exception("Invocazione del Servizio non autorizzata");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IntegrationManagerException(null, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
        }
    }

    private InfoConnettoreIngresso buildInfoConnettoreIngresso(HttpServletRequest req, Credenziali credenziali, URLProtocolContext urlProtocolContext) {
        InfoConnettoreIngresso connettoreIngresso = new InfoConnettoreIngresso();
        connettoreIngresso.setCredenziali(credenziali);
        connettoreIngresso.setFromLocation(ServletUtils.getLocation(req, credenziali));
        connettoreIngresso.setUrlProtocolContext(urlProtocolContext);
        return connettoreIngresso;
    }

    private IntegrationManagerRequestContext buildIMRequestContext(Timestamp dataRichiestaOperazione, Operazione tipoOperazione, PdDContext pddContext, Logger logCore, IProtocolFactory protocolFactory) throws IntegrationManagerException, ProtocolException, UtilsException {
        IntegrationManagerRequestContext imRequestContext = new IntegrationManagerRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
        Credenziali credenziali = null;
        HttpServletRequest req = this.getHttpServletRequest();
        URLProtocolContext urlProtocolContext = ServletUtils.getParametriInvocazionePorta(req, logCore);
        try {
            credenziali = ServletUtils.getCredenziali(req, logCore);
            if (credenziali == null) {
                credenziali = new Credenziali();
            }
        }
        catch (Exception e) {
            credenziali = new Credenziali();
        }
        imRequestContext.setConnettore(this.buildInfoConnettoreIngresso(req, credenziali, urlProtocolContext));
        return imRequestContext;
    }

    private synchronized void initializeGestoreCredenziali(IProtocolFactory protocolFactory, MsgDiagnostico msgDiag) throws IntegrationManagerException {
        if (this.tipiGestoriCredenziali == null) {
            Loader loader = Loader.getInstance();
            this.tipiGestoriCredenziali = this.propertiesReader.getTipoGestoreCredenzialiIM();
            if (this.tipiGestoriCredenziali != null) {
                for (int i = 0; i < this.tipiGestoriCredenziali.length; ++i) {
                    String classType = this.className.getGestoreCredenzialiIM(this.tipiGestoriCredenziali[i]);
                    try {
                        IGestoreCredenzialiIM gestore = (IGestoreCredenzialiIM)loader.newInstance(classType);
                        gestore.toString();
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "InizializzazioneGestoreCredenziali(" + this.tipiGestoriCredenziali[i] + ")");
                        throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_548_GESTORE_CREDENZIALI_NON_FUNZIONANTE));
                    }
                }
            }
        }
    }

    private void gestioneCredenziali(IProtocolFactory protocolFactory, MsgDiagnostico msgDiag, InfoConnettoreIngresso infoConnettoreIngresso, PdDContext pddContext) throws IntegrationManagerException {
        if (this.tipiGestoriCredenziali == null) {
            this.initializeGestoreCredenziali(protocolFactory, msgDiag);
        }
        if (this.tipiGestoriCredenziali != null) {
            msgDiag.mediumDebug("Gestione personalizzata delle credenziali...");
            Loader loader = Loader.getInstance();
            for (int i = 0; i < this.tipiGestoriCredenziali.length; ++i) {
                try {
                    String classType = null;
                    IGestoreCredenzialiIM gestore = null;
                    try {
                        classType = this.className.getGestoreCredenzialiIM(this.tipiGestoriCredenziali[i]);
                        gestore = (IGestoreCredenzialiIM)loader.newInstance(classType);
                        AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "InizializzazioneGestoreCredenziali(" + this.tipiGestoriCredenziali[i] + ")");
                        throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_548_GESTORE_CREDENZIALI_NON_FUNZIONANTE));
                    }
                    if (gestore != null) {
                        Credenziali credenzialiRitornate = gestore.elaborazioneCredenziali(infoConnettoreIngresso);
                        if (credenzialiRitornate == null) {
                            throw new Exception("Credenziali non ritornate");
                        }
                        if (!infoConnettoreIngresso.getCredenziali().equals(credenzialiRitornate)) {
                            String nuoveCredenziali = credenzialiRitornate.toString();
                            nuoveCredenziali = nuoveCredenziali.substring(0, nuoveCredenziali.length() - 1);
                            msgDiag.addKeyword("@NUOVE_CREDENZIALI@", nuoveCredenziali);
                            String identita = gestore.getIdentitaGestoreCredenziali();
                            if (identita == null) {
                                identita = "Gestore delle credenziali di tipo " + this.tipiGestoriCredenziali[i];
                            }
                            msgDiag.addKeyword("@IDENTITA_GESTORE_CREDENZIALI@", identita);
                            msgDiag.logPersonalizzato("gestoreCredenziali.nuoveCredenziali");
                            infoConnettoreIngresso.setCredenziali(credenzialiRitornate);
                        }
                        continue;
                    }
                    throw new Exception("non inizializzato");
                }
                catch (Exception e) {
                    OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Errore durante l'identificazione delle credenziali [" + this.tipiGestoriCredenziali[i] + "]: " + e.getMessage()), (Throwable)e);
                    msgDiag.addKeyword("@TIPO_GESTORE_CREDENZIALI@", this.tipiGestoriCredenziali[i]);
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    msgDiag.logPersonalizzato("gestoreCredenziali.errore");
                    ErroreIntegrazione errore = null;
                    errore = e instanceof GestoreCredenzialiConfigurationException ? ErroriIntegrazione.ERRORE_431_GESTORE_CREDENZIALI_ERROR.getErrore431_ErroreGestoreCredenziali(this.tipiGestoriCredenziali[i], e) : ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_548_GESTORE_CREDENZIALI_NON_FUNZIONANTE);
                    throw new IntegrationManagerException(protocolFactory, errore);
                }
            }
        }
    }

    private String autenticazione(IProtocolFactory protocolFactory, MsgDiagnostico msgDiag, InfoConnettoreIngresso infoConnettoreIngresso, ConfigurazionePdDManager configPdDManager, PdDContext pddContext) throws IntegrationManagerException {
        Credenziali credenziali = infoConnettoreIngresso.getCredenziali();
        String credenzialiFornite = "";
        if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
            credenzialiFornite = "(";
            if (credenziali.getUsername() != null) {
                credenzialiFornite = credenziali.getPassword() == null || "".equals(credenziali.getPassword()) ? credenzialiFornite + " Basic Username: " + credenziali.getUsername() + "  Basic Password: non definita" : credenzialiFornite + " Basic Username: " + credenziali.getUsername() + " ";
            }
            if (credenziali.getSubject() != null) {
                credenzialiFornite = credenzialiFornite + " SSL Subject: " + credenziali.getSubject() + " ";
            }
            credenzialiFornite = credenzialiFornite + ") ";
        }
        msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
        String servizio_applicativo = null;
        String[] tipoAutenticazione = configPdDManager.getIntegrationManagerAuthentication();
        if (tipoAutenticazione == null || tipoAutenticazione.length < 1) {
            msgDiag.logPersonalizzato("autenticazioneNonImpostata");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_519_INTEGRATION_MANAGER_CONFIGURATION_ERROR));
        }
        for (int i = 0; i < tipoAutenticazione.length; ++i) {
            if (!CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.toString().equalsIgnoreCase(tipoAutenticazione[i])) continue;
            msgDiag.logPersonalizzato("autenticazioneNonImpostata");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_519_INTEGRATION_MANAGER_CONFIGURATION_ERROR));
        }
        Loader loader = Loader.getInstance();
        StringBuffer errori = new StringBuffer();
        for (int i = 0; i < tipoAutenticazione.length; ++i) {
            String authClass = this.className.getAutenticazione(tipoAutenticazione[i]);
            IAutenticazione auth = null;
            try {
                auth = (IAutenticazione)loader.newInstance(authClass);
                AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Autenticazione(" + tipoAutenticazione + ") Class.forName(" + authClass + ")");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_503_AUTENTICAZIONE));
            }
            if (!auth.process(infoConnettoreIngresso, null)) {
                if (errori.length() > 0) {
                    errori.append("\n");
                }
                try {
                    errori.append("(Autenticazione " + tipoAutenticazione[i] + ") " + auth.getErrore().getDescrizione(protocolFactory));
                    continue;
                }
                catch (Exception e) {
                    OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Errore durante la comprensione dell'errore: " + e.getMessage()), (Throwable)e);
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_519_INTEGRATION_MANAGER_CONFIGURATION_ERROR));
                }
            }
            servizio_applicativo = auth.getServizioApplicativo();
            break;
        }
        if (servizio_applicativo == null) {
            if (errori.length() > 0) {
                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", errori.toString());
                msgDiag.logPersonalizzato("servizioApplicativo.identificazioneTramiteCredenziali");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallita(errori.toString()));
            }
            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "servizio applicativo non autenticato");
            msgDiag.logPersonalizzato("servizioApplicativo.identificazioneTramiteCredenziali");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_503_AUTENTICAZIONE));
        }
        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizio_applicativo);
        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_EROGATORE@", servizio_applicativo);
        msgDiag.setServizioApplicativo(servizio_applicativo);
        return servizio_applicativo;
    }

    private void verificaRisorseSistema(IProtocolFactory protocolFactory, Logger logCore, String tipoOperazione) throws IntegrationManagerException {
        if (!OpenSPCoop2Startup.initialize) {
            logCore.error((Object)("[" + ID_MODULO + "][" + tipoOperazione + "] Inizializzazione di OpenSPCoop non correttamente effettuata"));
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA));
        }
        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
            logCore.error((Object)("[" + ID_MODULO + "][" + tipoOperazione + "] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_532_RISORSE_NON_DISPONIBILI));
        }
        if (!TimerThreshold.freeSpace) {
            logCore.error((Object)("[" + ID_MODULO + "][" + tipoOperazione + "] Non sono disponibili abbastanza risorse per la gestione della richiesta"));
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_533_RISORSE_DISPONIBILI_LIVELLO_CRITICO));
        }
        if (!Tracciamento.tracciamentoDisponibile) {
            logCore.error((Object)("[" + ID_MODULO + "][" + tipoOperazione + "] Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage()), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_545_TRACCIATURA_NON_FUNZIONANTE));
        }
        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
            logCore.error((Object)("[" + ID_MODULO + "][" + tipoOperazione + "] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_546_DIAGNOSTICA_NON_FUNZIONANTE));
        }
        if (!Dump.sistemaDumpDisponibile) {
            logCore.error((Object)("[" + ID_MODULO + "][" + tipoOperazione + "] Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage()), (Throwable)Dump.motivoMalfunzionamentoDump);
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_547_DUMP_CONTENUTI_APPLICATIVI_NON_FUNZIONANTE));
        }
        try {
            ConfigurazionePdDManager.getInstance().verificaConsistenzaConfigurazione();
        }
        catch (Exception e) {
            logCore.error((Object)("[" + ID_MODULO + "][" + tipoOperazione + "] Riscontrato errore durante la verifica della consistenza della configurazione PdD"), (Throwable)e);
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
        }
        if (!isActiveIMService.booleanValue()) {
            logCore.error((Object)("[" + ID_MODULO + "][" + tipoOperazione + "] Servizio IntegrationManager disabilitato"));
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_552_IM_SERVICE_NOT_ACTIVE));
        }
    }

    private IUniqueIdentifier getUniqueIdentifier(IProtocolFactory protocolFactory, MsgDiagnostico msgDiag, String tipoOperazione) throws IntegrationManagerException {
        try {
            return UniqueIdentifierManager.newUniqueIdentifier();
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "getAllMessagesId(" + tipoOperazione + ").getUniqueIdentifier()");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
        }
    }

    private MsgDiagnostico getMsgDiagnostico() {
        MsgDiagnostico msgDiag = new MsgDiagnostico(ID_MODULO, new IState[0]);
        msgDiag.setPrefixMsgPersonalizzati("integrationManager.");
        return msgDiag;
    }

    private List<String> getAllMessagesId_engine(Operazione tipoOperazione, String tipoServizio, String servizio, String azione, int counter, int offset) throws IntegrationManagerException {
        Timestamp dataRichiestaOperazione = DateManager.getTimestamp();
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        this.checkIMAuthorization(logCore);
        IProtocolFactory protocolFactory = this.getProtocolFactory(logCore);
        this.verificaRisorseSistema(protocolFactory, logCore, tipoOperazione.toString());
        MsgDiagnostico msgDiag = this.getMsgDiagnostico();
        msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione.toString());
        String servizio_applicativo = null;
        OpenSPCoopStateful stato = null;
        PdDContext pddContext = new PdDContext();
        String idTransazione = this.getUniqueIdentifier(protocolFactory, msgDiag, tipoOperazione.toString()).getAsString();
        pddContext.addObject("ID", idTransazione);
        pddContext.addObject("PROTOCOLLO", protocolFactory.getProtocol());
        IDServizio idServizio = new IDServizio();
        idServizio.setTipoServizio(tipoServizio);
        idServizio.setServizio(servizio);
        idServizio.setAzione(azione);
        pddContext.addObject("SERVIZIO", idServizio);
        msgDiag.setPddContext(pddContext, protocolFactory);
        IntegrationManagerRequestContext imRequestContext = null;
        try {
            imRequestContext = this.buildIMRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
            GestoreHandlers.integrationManagerRequest(imRequestContext, msgDiag, logCore);
        }
        catch (Exception e) {
            if (e instanceof HandlerException) {
                msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
            } else {
                msgDiag.logErroreGenerico(e, "IntegrationManagerRequestHandler");
            }
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
        }
        IntegrationManagerResponseContext imResponseContext = new IntegrationManagerResponseContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
        try {
            stato = new OpenSPCoopStateful();
            stato.initResource(this.propertiesReader.getIdentitaPortaDefault(protocolFactory.getProtocol()), ID_MODULO, idTransazione);
            ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance(stato.getStatoRichiesta(), stato.getStatoRisposta());
            msgDiag.updateState(stato.getStatoRichiesta(), stato.getStatoRisposta());
            this.gestioneCredenziali(protocolFactory, msgDiag, imRequestContext.getConnettore(), pddContext);
            servizio_applicativo = this.autenticazione(protocolFactory, msgDiag, imRequestContext.getConnettore(), configPdDManager, pddContext);
            imResponseContext.setNomeServizioApplicativo(servizio_applicativo);
            String tipoServizioLog = "";
            String servizioLog = "";
            String azioneLog = "";
            String counterLog = "";
            if (tipoServizio != null) {
                tipoServizioLog = " tipoServizio[" + tipoServizio + "]";
            }
            if (servizio != null) {
                servizioLog = " servizio[" + servizio + "]";
            }
            if (azione != null) {
                azioneLog = " azione[" + azione + "]";
            }
            if (counter >= 0) {
                counterLog = " counter[" + counter + "]";
            }
            String param = "ServizioApplicativo[" + servizio_applicativo + "]" + tipoServizioLog + servizioLog + azioneLog + counterLog;
            msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
            msgDiag.logPersonalizzato("logInvocazioneOperazione");
            Vector<String> ids = null;
            GestoreMessaggi gestoreMessaggi = new GestoreMessaggi(stato, true, msgDiag, pddContext);
            ids = counter < 0 && offset < 0 ? gestoreMessaggi.getIDMessaggi_ServizioApplicativo(servizio_applicativo, tipoServizio, servizio, azione) : (offset < 0 ? gestoreMessaggi.getIDMessaggi_ServizioApplicativo(servizio_applicativo, tipoServizio, servizio, azione, counter) : gestoreMessaggi.getIDMessaggi_ServizioApplicativo(servizio_applicativo, tipoServizio, servizio, azione, counter, offset));
            if (ids.size() == 0) {
                msgDiag.logPersonalizzato("messaggiNonPresenti");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_406_INTEGRATION_MANAGER_MESSAGGI_FOR_SIL_NON_TROVATI.getErroreIntegrazione(), servizio_applicativo);
            }
            ArrayList<String> listResponse = new ArrayList<String>();
            if (ids != null && ids.size() > 0) {
                listResponse.addAll(ids);
            }
            imResponseContext.setEsito(EsitoIM.OK);
            ArrayList<String> arrayList = listResponse;
            return arrayList;
        }
        catch (Exception e) {
            imResponseContext.setEsito(EsitoIM.ERRORE_GENERICO);
            if (e instanceof IntegrationManagerException) {
                IntegrationManagerException exc = (IntegrationManagerException)e;
                if (CodiceErroreIntegrazione.CODICE_402_AUTENTICAZIONE_FALLITA.equals(exc.getCodiceErroreIntegrazione()) || CodiceErroreIntegrazione.CODICE_431_GESTORE_CREDENZIALI_ERROR.equals(exc.getCodiceErroreIntegrazione())) {
                    imResponseContext.setEsito(EsitoIM.AUTENTICAZIONE_FALLITA);
                } else if (CodiceErroreIntegrazione.CODICE_406_INTEGRATION_MANAGER_MESSAGGI_FOR_SIL_NON_TROVATI.equals(exc.getCodiceErroreIntegrazione())) {
                    imResponseContext.setEsito(EsitoIM.MESSAGGI_NON_PRESENTI);
                }
            }
            if (e instanceof IntegrationManagerException) {
                throw (IntegrationManagerException)e;
            }
            msgDiag.logErroreGenerico(e, "getAllMessagesId(" + tipoOperazione + ")");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), servizio_applicativo);
        }
        finally {
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception eClose) {}
            imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
            try {
                GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag, logCore);
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                }
                msgDiag.logErroreGenerico(e, "IntegrationManagerResponseHandler");
            }
        }
    }

    @Override
    public List<String> getAllMessagesId() throws IntegrationManagerException {
        this.init();
        return this.getAllMessagesId_engine(Operazione.getAllMessagesId, null, null, null, -1, -1);
    }

    @Override
    public List<String> getAllMessagesIdByService(String tipoServizio, String servizio, String azione) throws IntegrationManagerException {
        this.init();
        return this.getAllMessagesId_engine(Operazione.getAllMessagesIdByService, tipoServizio, servizio, azione, -1, -1);
    }

    @Override
    @Deprecated
    public List<String> getNextMessagesId(int counter) throws IntegrationManagerException {
        this.init();
        return this.getAllMessagesId_engine(Operazione.getNextMessagesId, null, null, null, counter, -1);
    }

    @Override
    @Deprecated
    public List<String> getNextMessagesIdByService(int counter, String tipoServizio, String servizio, String azione) throws IntegrationManagerException {
        this.init();
        return this.getAllMessagesId_engine(Operazione.getNextMessagesIdByService, tipoServizio, servizio, azione, counter, -1);
    }

    @Override
    public List<String> getMessagesIdArray(int offset, int counter) throws IntegrationManagerException {
        this.init();
        return this.getAllMessagesId_engine(Operazione.getMessagesIdArray, null, null, null, counter, offset);
    }

    @Override
    public List<String> getMessagesIdArrayByService(int offset, int counter, String tipoServizio, String servizio, String azione) throws IntegrationManagerException {
        this.init();
        return this.getAllMessagesId_engine(Operazione.getMessagesIdArrayByService, tipoServizio, servizio, azione, counter, offset);
    }

    private IntegrationManagerMessage getMessage_engine(Operazione tipoOperazione, String idMessaggio, boolean isRiferimentoMessaggio) throws IntegrationManagerException {
        Timestamp dataRichiestaOperazione = DateManager.getTimestamp();
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        this.checkIMAuthorization(logCore);
        IProtocolFactory protocolFactory = this.getProtocolFactory(logCore);
        this.verificaRisorseSistema(protocolFactory, logCore, tipoOperazione.toString());
        MsgDiagnostico msgDiag = this.getMsgDiagnostico();
        msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione.toString());
        if (isRiferimentoMessaggio) {
            msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RICHIESTA@", idMessaggio);
            msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RISPOSTA@", idMessaggio);
        } else {
            msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idMessaggio);
            msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", idMessaggio);
        }
        String servizio_applicativo = null;
        OpenSPCoopStateful stato = null;
        PdDContext pddContext = new PdDContext();
        String idTransazione = this.getUniqueIdentifier(protocolFactory, msgDiag, tipoOperazione.toString()).getAsString();
        pddContext.addObject("ID", idTransazione);
        pddContext.addObject("ID_MESSAGGIO", idMessaggio);
        pddContext.addObject("PROTOCOLLO", protocolFactory.getProtocol());
        msgDiag.setPddContext(pddContext, protocolFactory);
        IntegrationManagerRequestContext imRequestContext = null;
        try {
            imRequestContext = this.buildIMRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
            imRequestContext.setIdMessaggio(idMessaggio);
            GestoreHandlers.integrationManagerRequest(imRequestContext, msgDiag, logCore);
        }
        catch (Exception e) {
            if (e instanceof HandlerException) {
                msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
            } else {
                msgDiag.logErroreGenerico(e, "IntegrationManagerRequestHandler");
            }
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
        }
        IntegrationManagerResponseContext imResponseContext = new IntegrationManagerResponseContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
        imResponseContext.setIdMessaggio(idMessaggio);
        try {
            Busta busta;
            IDServizio idServizio;
            IDSoggetto fruitore;
            ProtocolHeaderInfo protocolHeaderInfo;
            String idMessaggioRichiesto;
            GestoreMessaggi gestoreMessaggi;
            block49: {
                stato = new OpenSPCoopStateful();
                stato.initResource(this.propertiesReader.getIdentitaPortaDefault(protocolFactory.getProtocol()), ID_MODULO, idTransazione);
                ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance(stato.getStatoRichiesta(), stato.getStatoRisposta());
                msgDiag.updateState(stato.getStatoRichiesta(), stato.getStatoRisposta());
                this.gestioneCredenziali(protocolFactory, msgDiag, imRequestContext.getConnettore(), pddContext);
                servizio_applicativo = this.autenticazione(protocolFactory, msgDiag, imRequestContext.getConnettore(), configPdDManager, pddContext);
                imResponseContext.setNomeServizioApplicativo(servizio_applicativo);
                String param = "ServizioApplicativo[" + servizio_applicativo + "] ID[" + idMessaggio + "]";
                msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
                msgDiag.logPersonalizzato("logInvocazioneOperazione");
                gestoreMessaggi = new GestoreMessaggi(stato, true, idMessaggio, "INBOX", msgDiag, pddContext);
                if (!gestoreMessaggi.existsMessageForSIL(servizio_applicativo, isRiferimentoMessaggio)) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessaggio);
                    msgDiag.logPersonalizzato("messaggioNonTrovato");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_407_INTEGRATION_MANAGER_MSG_RICHIESTO_NON_TROVATO.getErroreIntegrazione(), servizio_applicativo);
                }
                boolean authorized = gestoreMessaggi.checkAutorizzazione(servizio_applicativo, isRiferimentoMessaggio);
                if (!authorized) {
                    msgDiag.logPersonalizzato("servizioApplicativo.nonAutorizzato");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA.getErrore404_AutorizzazioneFallita(servizio_applicativo), servizio_applicativo);
                }
                idMessaggioRichiesto = idMessaggio;
                try {
                    if (isRiferimentoMessaggio) {
                        idMessaggioRichiesto = gestoreMessaggi.mapRiferimentoIntoIDBusta();
                    }
                }
                catch (Exception e) {
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    msgDiag.logPersonalizzato("mappingRifMsgToId.nonRiuscito");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), servizio_applicativo);
                }
                RepositoryBuste repository = new RepositoryBuste(stato.getStatoRichiesta(), true, protocolFactory);
                protocolHeaderInfo = null;
                fruitore = null;
                idServizio = null;
                busta = null;
                try {
                    LetturaParametriBusta parametri = new LetturaParametriBusta();
                    parametri.setMittente(true);
                    parametri.setDestinatario(true);
                    parametri.setRiferimentoMessaggio(true);
                    parametri.setServizio(true);
                    parametri.setAzione(true);
                    parametri.setCollaborazione(true);
                    busta = repository.getSomeValuesFromInBox(idMessaggioRichiesto, parametri);
                    if (busta != null) {
                        protocolHeaderInfo = new ProtocolHeaderInfo();
                        protocolHeaderInfo.setID(idMessaggioRichiesto);
                        protocolHeaderInfo.setRiferimentoMessaggio(busta.getRiferimentoMessaggio());
                        protocolHeaderInfo.setTipoMittente(busta.getTipoMittente());
                        protocolHeaderInfo.setMittente(busta.getMittente());
                        protocolHeaderInfo.setTipoDestinatario(busta.getTipoDestinatario());
                        protocolHeaderInfo.setDestinatario(busta.getDestinatario());
                        protocolHeaderInfo.setTipoServizio(busta.getTipoServizio());
                        protocolHeaderInfo.setServizio(busta.getServizio());
                        protocolHeaderInfo.setAzione(busta.getAzione());
                        protocolHeaderInfo.setIdCollaborazione(busta.getCollaborazione());
                        busta.setID(idMessaggioRichiesto);
                        msgDiag.addKeywords(busta, true);
                        fruitore = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                        idServizio = new IDServizio(busta.getTipoDestinatario(), busta.getDestinatario(), busta.getTipoServizio(), busta.getServizio());
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "ReadInformazioniProtocollo(" + tipoOperazione + "," + idMessaggioRichiesto + ")");
                    if (e.getMessage() != null && e.getMessage().indexOf("Busta non trovata") >= 0) break block49;
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), servizio_applicativo);
                }
            }
            boolean sbustamento_soap = gestoreMessaggi.sbustamentoSOAP(servizio_applicativo, isRiferimentoMessaggio);
            boolean sbustamento_informazioni_protocollo = gestoreMessaggi.sbustamentoInformazioniProtocollo(servizio_applicativo, isRiferimentoMessaggio);
            OpenSPCoop2Message consegnaMessage = null;
            try {
                consegnaMessage = gestoreMessaggi.getMessage(isRiferimentoMessaggio);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "gestoreMessaggi.getMessage(" + isRiferimentoMessaggio + "," + tipoOperazione + ")");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), servizio_applicativo);
            }
            boolean isRichiesta = true;
            try {
                GestoreMessaggi gestoreMessaggiComprensione = new GestoreMessaggi(stato, true, idMessaggioRichiesto, "INBOX", msgDiag, pddContext);
                isRichiesta = gestoreMessaggiComprensione.getRiferimentoMessaggio() == null;
            }
            catch (Exception e) {
                logCore.error((Object)("Comprensione tipo messaggio non riuscita: " + e.getMessage()), (Throwable)e);
            }
            if (sbustamento_informazioni_protocollo) {
                try {
                    IBustaBuilder bustaBuilder = protocolFactory.createBustaBuilder();
                    ProprietaManifestAttachments proprietaManifest = this.propertiesReader.getProprietaManifestAttachments("standard");
                    proprietaManifest.setGestioneManifest(false);
                    bustaBuilder.sbustamento(stato.getStatoRichiesta(), consegnaMessage, busta, isRichiesta, proprietaManifest);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "gestoreMessaggi.getMessage(" + isRiferimentoMessaggio + "," + tipoOperazione + ")");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), servizio_applicativo);
                }
            }
            if (ConfigurazionePdDManager.getInstance(stato.getStatoRichiesta(), stato.getStatoRisposta()).dumpMessaggi()) {
                msgDiag.mediumDebug("Dump applicativo messaggio ritornato...");
                Dump dumpApplicativo = new Dump(this.propertiesReader.getIdentitaPortaDefault(protocolFactory.getProtocol()), ID_MODULO, idMessaggio, fruitore, idServizio, TipoPdD.INTEGRATION_MANAGER, pddContext, stato.getStatoRichiesta(), stato.getStatoRisposta());
                dumpApplicativo.dumpIntegrationManagerGetMessage(consegnaMessage);
            }
            IntegrationManagerMessage msgReturn = null;
            try {
                if (!sbustamento_soap) {
                    msgReturn = new IntegrationManagerMessage(consegnaMessage, false, protocolHeaderInfo);
                } else {
                    byte[] sbustato = SoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)consegnaMessage);
                    msgReturn = new IntegrationManagerMessage(sbustato, false, protocolHeaderInfo);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "buildMsgReturn(" + idMessaggio + "," + tipoOperazione + ")");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_523_CREAZIONE_PROTOCOL_MESSAGE), servizio_applicativo);
            }
            imResponseContext.setEsito(EsitoIM.OK);
            imResponseContext.setDimensioneMessaggioBytes(new Long(msgReturn.getMessage().length));
            IntegrationManagerMessage integrationManagerMessage = msgReturn;
            return integrationManagerMessage;
        }
        catch (Exception e) {
            imResponseContext.setEsito(EsitoIM.ERRORE_GENERICO);
            if (e instanceof IntegrationManagerException) {
                IntegrationManagerException exc = (IntegrationManagerException)e;
                if (CodiceErroreIntegrazione.CODICE_402_AUTENTICAZIONE_FALLITA.equals(exc.getCodiceErroreIntegrazione()) || CodiceErroreIntegrazione.CODICE_431_GESTORE_CREDENZIALI_ERROR.equals(exc.getCodiceErroreIntegrazione())) {
                    imResponseContext.setEsito(EsitoIM.AUTENTICAZIONE_FALLITA);
                } else if (CodiceErroreIntegrazione.CODICE_407_INTEGRATION_MANAGER_MSG_RICHIESTO_NON_TROVATO.equals(exc.getCodiceErroreIntegrazione())) {
                    imResponseContext.setEsito(EsitoIM.MESSAGGIO_NON_TROVATO);
                } else if (CodiceErroreIntegrazione.CODICE_404_AUTORIZZAZIONE_FALLITA.equals(exc.getCodiceErroreIntegrazione())) {
                    imResponseContext.setEsito(EsitoIM.AUTORIZZAZIONE_FALLITA);
                }
            }
            if (e instanceof IntegrationManagerException) {
                throw (IntegrationManagerException)e;
            }
            msgDiag.logErroreGenerico(e, "getMessage(" + tipoOperazione + ")");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), servizio_applicativo);
        }
        finally {
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception eClose) {}
            imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
            try {
                GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag, logCore);
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                }
                msgDiag.logErroreGenerico(e, "IntegrationManagerResponseHandler");
            }
        }
    }

    @Override
    public IntegrationManagerMessage getMessage(String idMessaggio) throws IntegrationManagerException {
        this.init();
        return this.getMessage_engine(Operazione.getMessage, idMessaggio, false);
    }

    @Override
    public IntegrationManagerMessage getMessageByReference(String riferimentoMsg) throws IntegrationManagerException {
        this.init();
        return this.getMessage_engine(Operazione.getMessageByReference, riferimentoMsg, true);
    }

    private void deleteMessage_engine(Operazione tipoOperazione, String idMessaggio, boolean isRiferimentoMessaggio) throws IntegrationManagerException {
        Timestamp dataRichiestaOperazione = DateManager.getTimestamp();
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        this.checkIMAuthorization(logCore);
        IProtocolFactory protocolFactory = this.getProtocolFactory(logCore);
        this.verificaRisorseSistema(protocolFactory, logCore, tipoOperazione.toString());
        MsgDiagnostico msgDiag = this.getMsgDiagnostico();
        msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione.toString());
        if (isRiferimentoMessaggio) {
            msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RICHIESTA@", idMessaggio);
            msgDiag.addKeyword("@RIFERIMENTO_MESSAGGIO_RISPOSTA@", idMessaggio);
        } else {
            msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idMessaggio);
            msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", idMessaggio);
        }
        GestoreMessaggi gestoreMessaggi = null;
        String servizio_applicativo = null;
        OpenSPCoopStateful stato = null;
        PdDContext pddContext = new PdDContext();
        String idTransazione = this.getUniqueIdentifier(protocolFactory, msgDiag, tipoOperazione.toString()).getAsString();
        pddContext.addObject("ID", idTransazione);
        pddContext.addObject("ID_MESSAGGIO", idMessaggio);
        pddContext.addObject("PROTOCOLLO", protocolFactory.getProtocol());
        msgDiag.setPddContext(pddContext, protocolFactory);
        IntegrationManagerRequestContext imRequestContext = null;
        try {
            imRequestContext = this.buildIMRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
            imRequestContext.setIdMessaggio(idMessaggio);
            GestoreHandlers.integrationManagerRequest(imRequestContext, msgDiag, logCore);
        }
        catch (Exception e) {
            if (e instanceof HandlerException) {
                msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
            } else {
                msgDiag.logErroreGenerico(e, "IntegrationManagerRequestHandler");
            }
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
        }
        IntegrationManagerResponseContext imResponseContext = new IntegrationManagerResponseContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
        imResponseContext.setIdMessaggio(idMessaggio);
        try {
            stato = new OpenSPCoopStateful();
            stato.initResource(this.propertiesReader.getIdentitaPortaDefault(protocolFactory.getProtocol()), ID_MODULO, idTransazione);
            ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance(stato.getStatoRichiesta(), stato.getStatoRisposta());
            msgDiag.updateState(stato.getStatoRichiesta(), stato.getStatoRisposta());
            this.gestioneCredenziali(protocolFactory, msgDiag, imRequestContext.getConnettore(), pddContext);
            servizio_applicativo = this.autenticazione(protocolFactory, msgDiag, imRequestContext.getConnettore(), configPdDManager, pddContext);
            imResponseContext.setNomeServizioApplicativo(servizio_applicativo);
            String param = "ServizioApplicativo[" + servizio_applicativo + "] ID[" + idMessaggio + "]";
            msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
            msgDiag.logPersonalizzato("logInvocazioneOperazione");
            gestoreMessaggi = new GestoreMessaggi(stato, true, idMessaggio, "INBOX", msgDiag, pddContext);
            if (!gestoreMessaggi.existsMessageForSIL(servizio_applicativo, isRiferimentoMessaggio)) {
                msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessaggio);
                msgDiag.logPersonalizzato("messaggioNonTrovato");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_407_INTEGRATION_MANAGER_MSG_RICHIESTO_NON_TROVATO.getErroreIntegrazione(), servizio_applicativo);
            }
            boolean authorized = gestoreMessaggi.checkAutorizzazione(servizio_applicativo, isRiferimentoMessaggio);
            if (!authorized) {
                msgDiag.logPersonalizzato("servizioApplicativo.nonAutorizzato");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA.getErrore404_AutorizzazioneFallita(servizio_applicativo), servizio_applicativo);
            }
            String idMessaggioRichiesto = idMessaggio;
            try {
                if (isRiferimentoMessaggio) {
                    idMessaggioRichiesto = gestoreMessaggi.mapRiferimentoIntoIDBusta();
                }
            }
            catch (Exception e) {
                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                msgDiag.logPersonalizzato("mappingRifMsgToId.nonRiuscito");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), servizio_applicativo);
            }
            try {
                GestoreMessaggi gestoreEliminazione = new GestoreMessaggi(stato, true, idMessaggioRichiesto, "INBOX", msgDiag, pddContext);
                gestoreEliminazione.eliminaDestinatarioMessaggio(servizio_applicativo, gestoreEliminazione.getRiferimentoMessaggio());
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "gestoreMessaggi.eliminaDestinatarioMessaggio(" + tipoOperazione + "," + servizio_applicativo + "," + idMessaggio + ")");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_522_DELETE_MSG_FROM_INTEGRATION_MANAGER), servizio_applicativo);
            }
            imResponseContext.setEsito(EsitoIM.OK);
        }
        catch (Exception e) {
            imResponseContext.setEsito(EsitoIM.ERRORE_GENERICO);
            if (e instanceof IntegrationManagerException) {
                IntegrationManagerException exc = (IntegrationManagerException)e;
                if (CodiceErroreIntegrazione.CODICE_402_AUTENTICAZIONE_FALLITA.equals(exc.getCodiceErroreIntegrazione()) || CodiceErroreIntegrazione.CODICE_431_GESTORE_CREDENZIALI_ERROR.equals(exc.getCodiceErroreIntegrazione())) {
                    imResponseContext.setEsito(EsitoIM.AUTENTICAZIONE_FALLITA);
                } else if (CodiceErroreIntegrazione.CODICE_407_INTEGRATION_MANAGER_MSG_RICHIESTO_NON_TROVATO.equals(exc.getCodiceErroreIntegrazione())) {
                    imResponseContext.setEsito(EsitoIM.MESSAGGIO_NON_TROVATO);
                } else if (CodiceErroreIntegrazione.CODICE_404_AUTORIZZAZIONE_FALLITA.equals(exc.getCodiceErroreIntegrazione())) {
                    imResponseContext.setEsito(EsitoIM.AUTORIZZAZIONE_FALLITA);
                }
            }
            if (e instanceof IntegrationManagerException) {
                throw (IntegrationManagerException)e;
            }
            msgDiag.logErroreGenerico(e, "deleteMessage(" + tipoOperazione + ")");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), servizio_applicativo);
        }
        finally {
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception eClose) {}
            imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
            try {
                GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag, logCore);
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                }
                msgDiag.logErroreGenerico(e, "IntegrationManagerResponseHandler");
            }
        }
    }

    @Override
    public void deleteMessage(String idMessaggio) throws IntegrationManagerException {
        this.init();
        this.deleteMessage_engine(Operazione.deleteMessage, idMessaggio, false);
    }

    @Override
    public void deleteMessageByReference(String riferimentoMsg) throws IntegrationManagerException {
        this.init();
        this.deleteMessage_engine(Operazione.deleteMessageByReference, riferimentoMsg, true);
    }

    @Override
    public void deleteAllMessages() throws IntegrationManagerException {
        this.init();
        Operazione tipoOperazione = Operazione.deleteAllMessages;
        Timestamp dataRichiestaOperazione = DateManager.getTimestamp();
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        this.checkIMAuthorization(logCore);
        IProtocolFactory protocolFactory = this.getProtocolFactory(logCore);
        this.verificaRisorseSistema(protocolFactory, logCore, tipoOperazione.toString());
        MsgDiagnostico msgDiag = this.getMsgDiagnostico();
        msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione.toString());
        String servizio_applicativo = null;
        OpenSPCoopStateful stato = null;
        PdDContext pddContext = new PdDContext();
        String idTransazione = this.getUniqueIdentifier(protocolFactory, msgDiag, tipoOperazione.toString()).getAsString();
        pddContext.addObject("ID", idTransazione);
        pddContext.addObject("PROTOCOLLO", protocolFactory.getProtocol());
        msgDiag.setPddContext(pddContext, protocolFactory);
        IntegrationManagerRequestContext imRequestContext = null;
        try {
            imRequestContext = this.buildIMRequestContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
            GestoreHandlers.integrationManagerRequest(imRequestContext, msgDiag, logCore);
        }
        catch (Exception e) {
            if (e instanceof HandlerException) {
                msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
            } else {
                msgDiag.logErroreGenerico(e, "IntegrationManagerRequestHandler");
            }
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
        }
        IntegrationManagerResponseContext imResponseContext = new IntegrationManagerResponseContext(dataRichiestaOperazione, tipoOperazione, pddContext, logCore, protocolFactory);
        try {
            stato = new OpenSPCoopStateful();
            stato.initResource(this.propertiesReader.getIdentitaPortaDefault(protocolFactory.getProtocol()), ID_MODULO, idTransazione);
            ConfigurazionePdDManager configPdDManager = ConfigurazionePdDManager.getInstance(stato.getStatoRichiesta(), stato.getStatoRisposta());
            msgDiag.updateState(stato.getStatoRichiesta(), stato.getStatoRisposta());
            this.gestioneCredenziali(protocolFactory, msgDiag, imRequestContext.getConnettore(), pddContext);
            servizio_applicativo = this.autenticazione(protocolFactory, msgDiag, imRequestContext.getConnettore(), configPdDManager, pddContext);
            imResponseContext.setNomeServizioApplicativo(servizio_applicativo);
            String param = "ServizioApplicativo[" + servizio_applicativo + "]";
            msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
            msgDiag.logPersonalizzato("logInvocazioneOperazione");
            GestoreMessaggi gestoreSearchID = new GestoreMessaggi(stato, true, msgDiag, pddContext);
            Vector<String> ids = gestoreSearchID.getIDMessaggi_ServizioApplicativo(servizio_applicativo);
            if (ids.size() == 0) {
                msgDiag.logPersonalizzato("messaggiNonPresenti");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_406_INTEGRATION_MANAGER_MESSAGGI_FOR_SIL_NON_TROVATI.getErroreIntegrazione(), servizio_applicativo);
            }
            for (int i = 0; i < ids.size(); ++i) {
                String idMessaggio = ids.get(i);
                GestoreMessaggi gestoreMessaggi = new GestoreMessaggi(stato, true, idMessaggio, "INBOX", msgDiag, pddContext);
                if (!gestoreMessaggi.existsMessageForSIL(servizio_applicativo)) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessaggio);
                    msgDiag.logPersonalizzato("messaggioNonTrovato");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER), servizio_applicativo);
                }
                boolean authorized = gestoreMessaggi.checkAutorizzazione(servizio_applicativo);
                if (authorized) continue;
                msgDiag.logPersonalizzato("servizioApplicativo.nonAutorizzato");
                throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA.getErrore404_AutorizzazioneFallita(servizio_applicativo), servizio_applicativo);
            }
            while (ids.size() > 0) {
                String idMessaggio = ids.remove(0);
                try {
                    GestoreMessaggi gestoreEliminazione = new GestoreMessaggi(stato, true, idMessaggio, "INBOX", msgDiag, pddContext);
                    gestoreEliminazione.eliminaDestinatarioMessaggio(servizio_applicativo, gestoreEliminazione.getRiferimentoMessaggio());
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "gestoreMessaggi.eliminaDestinatarioMessaggio(" + tipoOperazione + "," + servizio_applicativo + "," + idMessaggio + ")");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_522_DELETE_MSG_FROM_INTEGRATION_MANAGER), servizio_applicativo);
                }
            }
            imResponseContext.setEsito(EsitoIM.OK);
        }
        catch (Exception e) {
            imResponseContext.setEsito(EsitoIM.ERRORE_GENERICO);
            if (e instanceof IntegrationManagerException) {
                IntegrationManagerException exc = (IntegrationManagerException)e;
                if (CodiceErroreIntegrazione.CODICE_402_AUTENTICAZIONE_FALLITA.equals(exc.getCodiceErroreIntegrazione()) || CodiceErroreIntegrazione.CODICE_431_GESTORE_CREDENZIALI_ERROR.equals(exc.getCodiceErroreIntegrazione())) {
                    imResponseContext.setEsito(EsitoIM.AUTENTICAZIONE_FALLITA);
                } else if (CodiceErroreIntegrazione.CODICE_406_INTEGRATION_MANAGER_MESSAGGI_FOR_SIL_NON_TROVATI.equals(exc.getCodiceErroreIntegrazione())) {
                    imResponseContext.setEsito(EsitoIM.MESSAGGI_NON_PRESENTI);
                } else if (CodiceErroreIntegrazione.CODICE_404_AUTORIZZAZIONE_FALLITA.equals(exc.getCodiceErroreIntegrazione())) {
                    imResponseContext.setEsito(EsitoIM.AUTORIZZAZIONE_FALLITA);
                }
            }
            if (e instanceof IntegrationManagerException) {
                throw (IntegrationManagerException)e;
            }
            msgDiag.logErroreGenerico(e, "deleteAllMessages(" + tipoOperazione + ")");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), servizio_applicativo);
        }
        finally {
            try {
                if (stato != null) {
                    stato.releaseResource();
                }
            }
            catch (Exception eClose) {}
            imResponseContext.setDataCompletamentoOperazione(DateManager.getDate());
            try {
                GestoreHandlers.integrationManagerResponse(imResponseContext, msgDiag, logCore);
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    msgDiag.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                }
                msgDiag.logErroreGenerico(e, "IntegrationManagerResponseHandler");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IntegrationManagerMessage invocaPortaDelegata_engine(String tipoOperazione, String portaDelegata, IntegrationManagerMessage msg, String idInvocazionePerRiferimento) throws IntegrationManagerException {
        IntegrationManagerMessage integrationManagerMessage;
        Timestamp dataIngressoMessaggio = DateManager.getTimestamp();
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        this.checkIMAuthorization(logCore);
        IProtocolFactory protocolFactory = this.getProtocolFactory(logCore);
        this.verificaRisorseSistema(protocolFactory, logCore, tipoOperazione);
        MsgDiagnostico msgDiag = this.getMsgDiagnostico();
        msgDiag.addKeyword("@TIPO_OPERAZIONE_IM@", tipoOperazione);
        OpenSPCoopState stato = null;
        RicezioneContenutiApplicativiContext context = null;
        try {
            context = new RicezioneContenutiApplicativiContext(IDService.PORTA_DELEGATA_INTEGRATION_MANAGER, dataIngressoMessaggio, this.propertiesReader.getIdentitaPortaDefault(protocolFactory.getProtocol()));
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "invocaPortaDelegata_engine(" + tipoOperazione + ").newRicezioneContenutiApplicativiContext()");
            throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
        }
        PdDContext pddContext = new PdDContext();
        String idTransazione = PdDContext.getValue("ID", context.getPddContext());
        pddContext.addObject("ID", idTransazione);
        pddContext.addObject("TIPO_OPERAZIONE_IM", tipoOperazione.toString());
        pddContext.addObject("ID_MESSAGGIO", idInvocazionePerRiferimento);
        pddContext.addObject("PORTA_DELEGATA", portaDelegata);
        pddContext.addObject("PROTOCOLLO", protocolFactory.getProtocol());
        Esito esito = null;
        String errore = null;
        OpenSPCoop2Message msgRequest = null;
        OpenSPCoop2Message msgResponse = null;
        IntegrationManagerMessage msgReturn = null;
        String descrizioneSoapFault = "";
        try {
            PreInRequestContext preInRequestContext = new PreInRequestContext(pddContext);
            preInRequestContext.setTipoPorta(TipoPdD.DELEGATA);
            Hashtable<String, Object> transportContext = new Hashtable<String, Object>();
            transportContext.put("SERVLET_REQUEST", this.getHttpServletRequest());
            transportContext.put("SERVLET_RESPONSE", this.getHttpServletResponse());
            preInRequestContext.setTransportContext(transportContext);
            preInRequestContext.setLogCore(logCore);
            GestoreHandlers.preInRequest(preInRequestContext, msgDiag, logCore);
            pddContext.addAll(preInRequestContext.getPddContext(), false);
            NotifierInputStreamParams notifierInputStreamParams = preInRequestContext.getNotifierInputStreamParams();
            context.setNotifierInputStreamParams(notifierInputStreamParams);
            if ("invocaPortaDelegata".equals(tipoOperazione)) {
                if (msg == null || msg.getMessage() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.contenutoApplicativoNonPresente");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER));
                }
            } else if ("invocaPortaDelegataPerRiferimento".equals(tipoOperazione)) {
                if (idInvocazionePerRiferimento == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegataPerRiferimento.riferimentoMessaggioNonPresente");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER));
                }
            } else if ("sendRispostaAsincronaSimmetrica".equals(tipoOperazione)) {
                if (msg == null || msg.getMessage() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.contenutoApplicativoNonPresente");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER));
                }
                if (msg.getProtocolHeaderInfo() == null || msg.getProtocolHeaderInfo().getRiferimentoMessaggio() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.profiloAsincrono.riferimentoMessaggioNonPresente");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER));
                }
            } else {
                if (!"sendRichiestaStatoAsincronaAsimmetrica".equals(tipoOperazione)) {
                    throw new Exception("Tipo operazione [" + tipoOperazione + "] non gestita");
                }
                if (msg == null || msg.getMessage() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.contenutoApplicativoNonPresente");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER));
                }
                if (msg.getProtocolHeaderInfo() == null || msg.getProtocolHeaderInfo().getRiferimentoMessaggio() == null) {
                    msgDiag.logPersonalizzato("invocazionePortaDelegata.profiloAsincrono.riferimentoMessaggioNonPresente");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER));
                }
            }
            HttpServletRequest req = this.getHttpServletRequest();
            Credenziali credenziali = ServletUtils.getCredenziali(req, logCore);
            String credenzialiFornite = "";
            if (credenziali != null) {
                if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
                    credenzialiFornite = "(";
                    if (credenziali.getUsername() != null) {
                        credenzialiFornite = credenzialiFornite + " Basic Username: " + credenziali.getUsername() + " ";
                    }
                    if (credenziali.getSubject() != null) {
                        credenzialiFornite = credenzialiFornite + " SSL Subject: " + credenziali.getSubject() + " ";
                    }
                    credenzialiFornite = credenzialiFornite + ") ";
                }
                msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
            }
            String invPerRiferimento = "";
            if (idInvocazionePerRiferimento != null) {
                invPerRiferimento = " idInvocazionePerRiferimento[" + idInvocazionePerRiferimento + "]";
            }
            String riferimentoMessaggio = "";
            if (msg.getProtocolHeaderInfo() != null && msg.getProtocolHeaderInfo().getRiferimentoMessaggio() != null) {
                riferimentoMessaggio = " riferimentoMessaggio[" + msg.getProtocolHeaderInfo().getRiferimentoMessaggio() + "]";
            }
            String param = "PD[" + portaDelegata + "]" + credenzialiFornite + invPerRiferimento + riferimentoMessaggio;
            msgDiag.addKeyword("@PARAMETRI_OPERAZIONE_IM@", param);
            msgDiag.logPersonalizzato("logInvocazioneOperazione");
            Properties headerTrasporto = null;
            if (this.propertiesReader.integrationManager_readInformazioniTrasporto()) {
                headerTrasporto = new Properties();
                Enumeration enTrasporto = req.getHeaderNames();
                while (enTrasporto.hasMoreElements()) {
                    String nomeProperty = (String)enTrasporto.nextElement();
                    headerTrasporto.setProperty(nomeProperty, req.getHeader(nomeProperty));
                }
            }
            URLProtocolContext urlProtocolContext = new URLProtocolContext();
            urlProtocolContext.setFunctionParameters(portaDelegata);
            urlProtocolContext.setRequestURI(portaDelegata);
            urlProtocolContext.setFunction("IntegrationManager");
            urlProtocolContext.setProtocol(protocolFactory.getProtocol());
            if (this.propertiesReader.integrationManager_readInformazioniTrasporto()) {
                urlProtocolContext.setParametersTrasporto(headerTrasporto);
            }
            if (idInvocazionePerRiferimento != null) {
                stato = new OpenSPCoopStateful();
                stato.initResource(this.propertiesReader.getIdentitaPortaDefault(protocolFactory.getProtocol()), ID_MODULO, idTransazione);
                msgDiag.updateState(stato.getStatoRichiesta(), stato.getStatoRisposta());
                try {
                    GestoreMessaggi gestoreMessaggio = new GestoreMessaggi(stato, true, idInvocazionePerRiferimento, "INBOX", msgDiag, pddContext);
                    msgRequest = gestoreMessaggio.getMessage();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "gestoreMessaggio.getMessagePerRiferimento(" + idInvocazionePerRiferimento + ")");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_520_READ_MSG_FROM_INTEGRATION_MANAGER));
                }
                stato.releaseResource();
                stato = null;
            } else {
                try {
                    msgRequest = SoapUtils.build((SoapUtilsBuildParameter)new SoapUtilsBuildParameter(msg.getMessage(), msg.getImbustamento(), this.propertiesReader.isDeleteInstructionTargetMachineXml(), this.propertiesReader.isFileCacheEnable(), this.propertiesReader.getAttachmentRepoDir(), this.propertiesReader.getFileThreshold()), (NotifierInputStreamParams)notifierInputStreamParams);
                    msgRequest.setTransportRequestContext((TransportRequestContext)urlProtocolContext);
                }
                catch (Exception e) {
                    if (ConfigurazionePdDManager.getInstance().dumpMessaggi()) {
                        Dump dumpApplicativo = new Dump(this.propertiesReader.getIdentitaPortaDefault(protocolFactory.getProtocol()), ID_MODULO, TipoPdD.DELEGATA, pddContext, null, null);
                        dumpApplicativo.dumpRichiestaIngresso(msg.getMessage(), this.buildInfoConnettoreIngresso(req, credenziali, urlProtocolContext));
                    }
                    if (!msg.getImbustamento()) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        msgDiag.logPersonalizzato("buildMsg.nonRiuscito");
                        throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_421_MSG_SOAP_NON_COSTRUIBILE_TRAMITE_RICHIESTA_APPLICATIVA.getErrore421_MessaggioSOAPNonGenerabile(e.getMessage()));
                    }
                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                    msgDiag.logPersonalizzato("buildMsg.imbustamentoSOAP.nonRiuscito");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_422_IMBUSTAMENTO_SOAP_NON_RIUSCITO_RICHIESTA_APPLICATIVA.getErrore422_MessaggioSOAPNonGenerabileTramiteImbustamentoSOAP(e.getMessage()));
                }
            }
            HeaderIntegrazione headerIntegrazioneRichiesta = new HeaderIntegrazione();
            ProtocolHeaderInfo protocolHeaderInfo = msg.getProtocolHeaderInfo();
            if (protocolHeaderInfo != null) {
                if (protocolHeaderInfo.getTipoMittente() != null && !"".equals(protocolHeaderInfo.getTipoMittente())) {
                    headerIntegrazioneRichiesta.getBusta().setTipoMittente(protocolHeaderInfo.getTipoMittente());
                }
                if (protocolHeaderInfo.getMittente() != null && !"".equals(protocolHeaderInfo.getMittente())) {
                    headerIntegrazioneRichiesta.getBusta().setMittente(protocolHeaderInfo.getMittente());
                }
                if (protocolHeaderInfo.getTipoDestinatario() != null && !"".equals(protocolHeaderInfo.getTipoDestinatario())) {
                    headerIntegrazioneRichiesta.getBusta().setTipoDestinatario(protocolHeaderInfo.getTipoDestinatario());
                }
                if (protocolHeaderInfo.getDestinatario() != null && !"".equals(protocolHeaderInfo.getDestinatario())) {
                    headerIntegrazioneRichiesta.getBusta().setDestinatario(protocolHeaderInfo.getDestinatario());
                }
                if (protocolHeaderInfo.getTipoServizio() != null && !"".equals(protocolHeaderInfo.getTipoServizio())) {
                    headerIntegrazioneRichiesta.getBusta().setTipoServizio(protocolHeaderInfo.getTipoServizio());
                }
                if (protocolHeaderInfo.getServizio() != null && !"".equals(protocolHeaderInfo.getServizio())) {
                    headerIntegrazioneRichiesta.getBusta().setServizio(protocolHeaderInfo.getServizio());
                }
                if (protocolHeaderInfo.getAzione() != null && !"".equals(protocolHeaderInfo.getAzione())) {
                    headerIntegrazioneRichiesta.getBusta().setAzione(protocolHeaderInfo.getAzione());
                }
                if (protocolHeaderInfo.getID() != null && !"".equals(protocolHeaderInfo.getID())) {
                    headerIntegrazioneRichiesta.getBusta().setID(protocolHeaderInfo.getID());
                }
                if (protocolHeaderInfo.getIdCollaborazione() != null && !"".equals(protocolHeaderInfo.getIdCollaborazione())) {
                    headerIntegrazioneRichiesta.getBusta().setIdCollaborazione(protocolHeaderInfo.getIdCollaborazione());
                }
                if (protocolHeaderInfo.getRiferimentoMessaggio() != null && !"".equals(protocolHeaderInfo.getRiferimentoMessaggio())) {
                    headerIntegrazioneRichiesta.getBusta().setRiferimentoMessaggio(protocolHeaderInfo.getRiferimentoMessaggio());
                }
            }
            if (msg.getIdApplicativo() != null && !"".equals(msg.getIdApplicativo())) {
                headerIntegrazioneRichiesta.setIdApplicativo(msg.getIdApplicativo());
            }
            if (msg.getServizioApplicativo() != null && !"".equals(msg.getServizioApplicativo())) {
                headerIntegrazioneRichiesta.setServizioApplicativo(msg.getServizioApplicativo());
            }
            context.setTipoPorta(TipoPdD.DELEGATA);
            context.setCredenziali(credenziali);
            context.setIdModulo("RicezioneContenutiApplicativi" + ID_MODULO);
            context.setGestioneRisposta(true);
            context.setInvocazionePDPerRiferimento(idInvocazionePerRiferimento != null);
            context.setIdInvocazionePDPerRiferimento(idInvocazionePerRiferimento);
            context.setMessageRequest(msgRequest);
            context.setUrlProtocolContext(urlProtocolContext);
            context.setHeaderIntegrazioneRichiesta(headerIntegrazioneRichiesta);
            context.getPddContext().addObject("PROTOCOLLO", protocolFactory.getProtocol());
            context.getPddContext().addObject("SOAP_VERSION", SOAPVersion.SOAP11);
            context.setFromLocation(ServletUtils.getLocation(req, credenziali));
            RicezioneContenutiApplicativi gestoreRichiesta = new RicezioneContenutiApplicativi(context);
            gestoreRichiesta.process(req);
            msgResponse = context.getMessageResponse();
            msgDiag = context.getMsgDiagnostico();
            Properties headerIntegrazioneRisposta = context.getHeaderIntegrazioneRisposta();
            ProtocolHeaderInfo protocolHeaderInfoResponse = null;
            if (headerIntegrazioneRisposta != null) {
                Properties keyValue = this.propertiesReader.getKeyValue_HeaderIntegrazioneTrasporto();
                protocolHeaderInfoResponse = new ProtocolHeaderInfo();
                protocolHeaderInfoResponse.setID(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("identificativo")));
                protocolHeaderInfoResponse.setRiferimentoMessaggio(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("riferimentoMessaggio")));
                protocolHeaderInfoResponse.setIdCollaborazione(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("idCollaborazione")));
                protocolHeaderInfoResponse.setMittente(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("mittente")));
                protocolHeaderInfoResponse.setTipoMittente(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("tipoMittente")));
                protocolHeaderInfoResponse.setDestinatario(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("destinatario")));
                protocolHeaderInfoResponse.setTipoDestinatario(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("tipoDestinatario")));
                protocolHeaderInfoResponse.setServizio(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("servizio")));
                protocolHeaderInfoResponse.setTipoServizio(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("tipoServizio")));
                protocolHeaderInfoResponse.setAzione(headerIntegrazioneRisposta.getProperty(keyValue.getProperty("azione")));
            }
            if (msgResponse != null) {
                esito = protocolFactory.createEsitoBuilder().getEsito(msgResponse, context.getProprietaErroreAppl());
                if (msgResponse.getSOAPBody().hasFault()) {
                    descrizioneSoapFault = " (" + SoapUtils.toString((SOAPFault)msgResponse.getSOAPBody().getFault(), (boolean)false) + ")";
                    IntegrationManagerException exc = null;
                    try {
                        SOAPFault fault = msgResponse.getSOAPBody().getFault();
                        if (fault.getFaultActor() != null && fault.getFaultActor().equals(context.getProprietaErroreAppl().getFaultActor())) {
                            String prefix = "OPENSPCOOP2_ORG_";
                            if (context.getProprietaErroreAppl().getFaultPrefixCode() != null) {
                                prefix = context.getProprietaErroreAppl().getFaultPrefixCode();
                            }
                            if ((exc = this.propertiesReader.isErroreApplicativoIntoDetails() ? ServicesUtils.mapXMLIntoProtocolException(protocolFactory, fault.getDetail().getFirstChild(), prefix) : ServicesUtils.mapXMLIntoProtocolException(protocolFactory, fault.getFaultString(), prefix)) == null) {
                                throw new Exception("Costruzione Eccezione fallita: null");
                            }
                        }
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "buildProtocolException(" + tipoOperazione + ")");
                        throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_524_CREAZIONE_PROTOCOL_EXCEPTION));
                    }
                    if (exc != null) {
                        throw exc;
                    }
                }
                try {
                    msgReturn = new IntegrationManagerMessage(msgResponse, false);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "buildMessage_response(" + tipoOperazione + ")");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_523_CREAZIONE_PROTOCOL_MESSAGE));
                }
                msgDiag.addKeyword("@SOAP_FAULT@", descrizioneSoapFault);
                msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "integrationManager.consegnaRispostaApplicativaEffettuata");
            } else {
                msgReturn = new IntegrationManagerMessage();
                esito = Esito.OK;
                msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "integrationManager.consegnaRispostaApplicativaVuota");
            }
            msgReturn.setProtocolHeaderInfo(protocolHeaderInfoResponse);
            integrationManagerMessage = msgReturn;
        }
        catch (Exception e) {
            try {
                errore = e.getMessage();
                msgDiag.addKeyword("@SOAP_FAULT@", descrizioneSoapFault);
                if (!(e instanceof IntegrationManagerException)) {
                    msgDiag.logErroreGenerico(e, "invocaPortaDelegata(" + tipoOperazione + ")");
                    esito = Esito.ERRORE_PROCESSAMENTO_PDD_5XX;
                    msgDiag.addKeyword("@ERRORE_CONSEGNA@", errore);
                    msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "integrationManager.consegnaRispostaApplicativaFallita");
                    throw new IntegrationManagerException(protocolFactory, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
                }
                if (esito == null) {
                    esito = Esito.ERRORE_PROCESSAMENTO_PDD_5XX;
                }
                IntegrationManagerException eSPC = (IntegrationManagerException)e;
                if (descrizioneSoapFault != null && !"".equals(descrizioneSoapFault)) {
                    msgDiag.addKeyword("@ERRORE_CONSEGNA@", "ProtocolException/" + eSPC.getCodiceEccezione());
                } else {
                    msgDiag.addKeyword("@ERRORE_CONSEGNA@", "ProtocolException/" + eSPC.getCodiceEccezione() + " " + eSPC.getDescrizioneEccezione());
                }
                msgDiag.logPersonalizzato("ricezioneContenutiApplicativi.", "integrationManager.consegnaRispostaApplicativaFallita");
                throw eSPC;
            }
            catch (Throwable throwable) {
                try {
                    if (stato != null) {
                        stato.releaseResource();
                    }
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                String location2 = "...";
                try {
                    IConnettore c = null;
                    if (context != null && context.getIdMessage() != null) {
                        c = RepositoryConnettori.removeConnettorePD(context.getIdMessage());
                    }
                    if (c != null) {
                        location2 = c.getLocation();
                        c.disconnect();
                    }
                }
                catch (Exception e2) {
                    msgDiag.logDisconnectError(e2, location2);
                }
                PostOutResponseContext postOutResponseContext2 = new PostOutResponseContext(logCore, protocolFactory);
                try {
                    postOutResponseContext2.setPddContext(pddContext);
                    postOutResponseContext2.setDataElaborazioneMessaggio(DateManager.getDate());
                    postOutResponseContext2.setEsito(esito);
                    postOutResponseContext2.setMessaggio(msgResponse);
                    if (msgRequest != null) {
                        postOutResponseContext2.setInputRequestMessageSize(msgRequest.getIncomingMessageContentLength());
                        postOutResponseContext2.setOutputRequestMessageSize(msgRequest.getOutgoingMessageContentLength());
                    } else if (msg != null && msg.getMessage() != null) {
                        postOutResponseContext2.setInputRequestMessageSize(new Long(msg.getMessage().length));
                    }
                    if (msgResponse != null) {
                        postOutResponseContext2.setInputResponseMessageSize(msgResponse.getIncomingMessageContentLength());
                        if (msgReturn != null && msgReturn.getMessage() != null) {
                            postOutResponseContext2.setOutputResponseMessageSize(new Long(msgReturn.getMessage().length));
                        }
                    }
                    if (errore != null) {
                        postOutResponseContext2.setReturnCode(500);
                    } else {
                        postOutResponseContext2.setReturnCode(200);
                    }
                    if (context != null) {
                        if (context.getTipoPorta() != null) {
                            postOutResponseContext2.setTipoPorta(context.getTipoPorta());
                        } else {
                            postOutResponseContext2.setTipoPorta(TipoPdD.DELEGATA);
                        }
                        postOutResponseContext2.setProtocollo(context.getProtocol());
                        postOutResponseContext2.setIntegrazione(context.getIntegrazione());
                    } else {
                        postOutResponseContext2.setTipoPorta(TipoPdD.DELEGATA);
                    }
                }
                catch (Exception e3) {
                    msgDiag.logErroreGenerico(e3, "postOutResponse, preparazione contesto");
                }
                GestoreHandlers.postOutResponse(postOutResponseContext2, msgDiag, logCore);
                throw throwable;
            }
        }
        try {
            if (stato != null) {
                stato.releaseResource();
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        String location = "...";
        try {
            IConnettore c = null;
            if (context != null && context.getIdMessage() != null) {
                c = RepositoryConnettori.removeConnettorePD(context.getIdMessage());
            }
            if (c != null) {
                location = c.getLocation();
                c.disconnect();
            }
        }
        catch (Exception e) {
            msgDiag.logDisconnectError(e, location);
        }
        PostOutResponseContext postOutResponseContext = new PostOutResponseContext(logCore, protocolFactory);
        try {
            postOutResponseContext.setPddContext(pddContext);
            postOutResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
            postOutResponseContext.setEsito(esito);
            postOutResponseContext.setMessaggio(msgResponse);
            if (msgRequest != null) {
                postOutResponseContext.setInputRequestMessageSize(msgRequest.getIncomingMessageContentLength());
                postOutResponseContext.setOutputRequestMessageSize(msgRequest.getOutgoingMessageContentLength());
            } else if (msg != null && msg.getMessage() != null) {
                postOutResponseContext.setInputRequestMessageSize(new Long(msg.getMessage().length));
            }
            if (msgResponse != null) {
                postOutResponseContext.setInputResponseMessageSize(msgResponse.getIncomingMessageContentLength());
                if (msgReturn != null && msgReturn.getMessage() != null) {
                    postOutResponseContext.setOutputResponseMessageSize(new Long(msgReturn.getMessage().length));
                }
            }
            if (errore != null) {
                postOutResponseContext.setReturnCode(500);
            } else {
                postOutResponseContext.setReturnCode(200);
            }
            if (context != null) {
                if (context.getTipoPorta() != null) {
                    postOutResponseContext.setTipoPorta(context.getTipoPorta());
                } else {
                    postOutResponseContext.setTipoPorta(TipoPdD.DELEGATA);
                }
                postOutResponseContext.setProtocollo(context.getProtocol());
                postOutResponseContext.setIntegrazione(context.getIntegrazione());
            } else {
                postOutResponseContext.setTipoPorta(TipoPdD.DELEGATA);
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "postOutResponse, preparazione contesto");
        }
        GestoreHandlers.postOutResponse(postOutResponseContext, msgDiag, logCore);
        return integrationManagerMessage;
    }

    @Override
    public IntegrationManagerMessage invocaPortaDelegata(String portaDelegata, IntegrationManagerMessage msg) throws IntegrationManagerException {
        this.init();
        String tipoOperazione = "invocaPortaDelegata";
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, null);
    }

    @Override
    public IntegrationManagerMessage invocaPortaDelegataPerRiferimento(String portaDelegata, IntegrationManagerMessage msg, String riferimentoMessaggio) throws IntegrationManagerException {
        this.init();
        String tipoOperazione = "invocaPortaDelegataPerRiferimento";
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, riferimentoMessaggio);
    }

    @Override
    public IntegrationManagerMessage sendRispostaAsincronaSimmetrica(String portaDelegata, IntegrationManagerMessage msg) throws IntegrationManagerException {
        this.init();
        String tipoOperazione = "sendRispostaAsincronaSimmetrica";
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, null);
    }

    @Override
    public IntegrationManagerMessage sendRichiestaStatoAsincronaAsimmetrica(String portaDelegata, IntegrationManagerMessage msg) throws IntegrationManagerException {
        this.init();
        String tipoOperazione = "sendRichiestaStatoAsincronaAsimmetrica";
        return this.invocaPortaDelegata_engine(tipoOperazione, portaDelegata, msg, null);
    }
}

