/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openspcoop2.core.api.constants.MethodType;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativiHTTPtoSOAP;
import org.openspcoop2.pdd.services.connector.ConnectorUtils;
import org.openspcoop2.pdd.services.connector.HttpServletConnectorInMessage;
import org.openspcoop2.pdd.services.connector.HttpServletConnectorOutMessage;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.sdk.IProtocolFactory;

public class RicezioneContenutiApplicativiHTTPtoSOAPConnector
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final IDService ID_SERVICE = IDService.PORTA_DELEGATA_XML_TO_SOAP;
    public static final String ID_MODULO = ID_SERVICE.getValue();

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RicezioneContenutiApplicativiHTTPtoSOAP httpToSoapConnector = new RicezioneContenutiApplicativiHTTPtoSOAP();
        HttpServletConnectorInMessage httpIn = null;
        try {
            httpIn = new HttpServletConnectorInMessage(req, ID_SERVICE, ID_MODULO);
        }
        catch (Exception e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("HttpServletConnectorInMessage init error: " + e.getMessage()), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        IProtocolFactory protocolFactory = null;
        try {
            protocolFactory = httpIn.getProtocolFactory();
        }
        catch (Throwable e) {
            // empty catch block
        }
        HttpServletConnectorOutMessage httpOut = null;
        try {
            httpOut = new HttpServletConnectorOutMessage(protocolFactory, res);
        }
        catch (Exception e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("HttpServletConnectorOutMessage init error: " + e.getMessage()), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        try {
            httpToSoapConnector.process(httpIn, httpOut);
        }
        catch (Exception e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("SoapConnector.process error: " + e.getMessage()), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    public void engine(HttpServletRequest req, HttpServletResponse res, MethodType method) throws ServletException, IOException {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        boolean errore404 = false;
        if (op2Properties != null && !op2Properties.isGenerazioneErroreHttpMethodUnsupportedPortaDelegataImbustamentoSOAPEnabled()) {
            errore404 = true;
        }
        if (errore404) {
            res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeHttpMethodNotSupported(ID_SERVICE, method)));
        } else {
            res.setStatus(500);
            ConnectorUtils.generateErrorMessage(ID_SERVICE, method, req, res, ConnectorUtils.getMessageHttpMethodNotSupported(method), false, true);
            try {
                res.getOutputStream().flush();
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                res.getOutputStream().close();
            }
            catch (Exception eClose) {
                // empty catch block
            }
        }
    }
}

