/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openspcoop2.core.api.constants.MethodType;
import org.openspcoop2.message.XMLUtils;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.RicezioneBusteSOAP;
import org.openspcoop2.pdd.services.connector.ConnectorUtils;
import org.openspcoop2.pdd.services.connector.HttpServletConnectorInMessage;
import org.openspcoop2.pdd.services.connector.HttpServletConnectorOutMessage;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.w3c.dom.Document;

public class RicezioneBusteSOAPConnector
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final IDService ID_SERVICE = IDService.PORTA_APPLICATIVA_SOAP;
    public static final String ID_MODULO = ID_SERVICE.getValue();

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RicezioneBusteSOAP soapConnector = new RicezioneBusteSOAP();
        HttpServletConnectorInMessage httpIn = null;
        try {
            httpIn = new HttpServletConnectorInMessage(req, ID_SERVICE, ID_MODULO);
        }
        catch (Exception e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("HttpServletConnectorInMessage init error: " + e.getMessage()), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        IProtocolFactory protocolFactory = null;
        try {
            protocolFactory = httpIn.getProtocolFactory();
        }
        catch (Throwable e) {
            // empty catch block
        }
        HttpServletConnectorOutMessage httpOut = null;
        try {
            httpOut = new HttpServletConnectorOutMessage(protocolFactory, res);
        }
        catch (Exception e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("HttpServletConnectorOutMessage init error: " + e.getMessage()), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        try {
            soapConnector.process(httpIn, httpOut);
        }
        catch (Exception e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("SoapConnector.process error: " + e.getMessage()), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engine(HttpServletRequest req, HttpServletResponse res, MethodType method) throws ServletException, IOException {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        String versione = "Porta di Dominio OpenSPCoop2/tags_2.1.1";
        if (op2Properties != null) {
            versione = "Porta di Dominio " + op2Properties.getPddDetailsForServices();
        }
        if (MethodType.GET.equals(method)) {
            Enumeration parameters = req.getParameterNames();
            while (parameters.hasMoreElements()) {
                String key = (String)parameters.nextElement();
                String value = req.getParameter(key);
                if (!"wsdl".equalsIgnoreCase(key) || value != null && !"".equals(value)) continue;
                InputStream is = null;
                try {
                    is = RicezioneBusteSOAPConnector.class.getResourceAsStream("/PA.wsdl");
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    if (is != null) {
                        int letti = 0;
                        byte[] buffer = new byte[65536];
                        while ((letti = is.read(buffer)) != -1) {
                            bout.write(buffer, 0, letti);
                        }
                        bout.flush();
                        bout.close();
                    }
                    if (op2Properties != null && op2Properties.isGenerazioneWsdlPortaApplicativaEnabled()) {
                        if (bout.size() <= 0) {
                            throw new Exception("WSDL Not Found");
                        }
                        byte[] b = bout.toByteArray();
                        XMLUtils xmlUtils = XMLUtils.getInstance();
                        Document d = xmlUtils.newDocument(b);
                        d.getFirstChild().appendChild(d.createComment(versione));
                        xmlUtils.writeTo(d, (OutputStream)res.getOutputStream());
                    } else {
                        res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeWsdlUnsupported(ID_SERVICE)));
                    }
                }
                catch (Exception e) {
                    res.setStatus(500);
                    ConnectorUtils.generateErrorMessage(ID_SERVICE, method, req, res, "Generazione WSDL non riuscita", false, true);
                    OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)"Generazione WSDL PA non riuscita", (Throwable)e);
                }
                finally {
                    try {
                        res.getOutputStream().flush();
                    }
                    catch (Exception eClose) {}
                    try {
                        res.getOutputStream().close();
                    }
                    catch (Exception eClose) {}
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception eClose) {}
                }
                return;
            }
        }
        boolean errore404 = false;
        if (op2Properties != null && !op2Properties.isGenerazioneErroreHttpMethodUnsupportedPortaApplicativaEnabled()) {
            errore404 = true;
        }
        if (errore404) {
            res.sendError(404, ConnectorUtils.generateError404Message(ConnectorUtils.getFullCodeHttpMethodNotSupported(ID_SERVICE, method)));
        } else {
            res.setStatus(500);
            ConnectorUtils.generateErrorMessage(ID_SERVICE, method, req, res, ConnectorUtils.getMessageHttpMethodNotSupported(method), false, true);
            try {
                res.getOutputStream().flush();
            }
            catch (Exception eClose) {
                // empty catch block
            }
            try {
                res.getOutputStream().close();
            }
            catch (Exception eClose) {
                // empty catch block
            }
        }
    }
}

