/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services.connector;

import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.ConnectorOutMessage;
import org.openspcoop2.protocol.sdk.IProtocolFactory;

public class HttpServletConnectorOutMessage
implements ConnectorOutMessage {
    protected HttpServletResponse res;
    protected OutputStream out;
    protected IProtocolFactory protocolFactory;
    private int status = -1;

    public HttpServletConnectorOutMessage(IProtocolFactory protocolFactory, HttpServletResponse res) throws ConnectorException {
        try {
            this.res = res;
            this.out = this.res.getOutputStream();
            this.protocolFactory = protocolFactory;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void sendResponse(OpenSPCoop2Message msg, boolean consume) throws ConnectorException {
        try {
            if (msg != null && msg.getSOAPBody() != null && msg.getSOAPBody().hasFault()) {
                msg.saveChanges();
            }
            msg.writeTo(this.out, consume);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void sendResponse(byte[] message) throws ConnectorException {
        try {
            this.out.write(message);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void setHeader(String key, String value) throws ConnectorException {
        try {
            this.res.setHeader(key, value);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void setContentLength(int length) throws ConnectorException {
        try {
            this.res.setContentLength(length);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void setContentType(String type) throws ConnectorException {
        try {
            this.res.setContentType(type);
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public void setStatus(int status) throws ConnectorException {
        try {
            this.res.setStatus(status);
            this.status = status;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    @Override
    public int getResponseStatus() throws ConnectorException {
        return this.status;
    }

    @Override
    public void flush(boolean throwException) throws ConnectorException {
        block10: {
            try {
                block9: {
                    if (this.res != null) {
                        try {
                            this.res.flushBuffer();
                        }
                        catch (Exception e) {
                            if (!throwException) break block9;
                            throw e;
                        }
                    }
                }
                if (this.out == null) break block10;
                try {
                    this.out.flush();
                }
                catch (Exception e) {
                    if (throwException) {
                        throw e;
                    }
                }
            }
            catch (ConnectorException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void close(boolean throwException) throws ConnectorException {
        block6: {
            try {
                if (this.out == null) break block6;
                try {
                    this.out.close();
                    this.out = null;
                }
                catch (Exception e) {
                    if (throwException) {
                        throw e;
                    }
                }
            }
            catch (ConnectorException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
    }
}

