/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services;

import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.internet.ContentType;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.log4j.Logger;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageException;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.services.connector.ConnectorInMessage;
import org.openspcoop2.pdd.services.connector.ConnectorOutMessage;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.utils.Identity;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;

public class ServletUtils {
    public static boolean isContentTypeSupported(SOAPVersion soapVersion, IProtocolFactory protocolFactory) throws ProtocolException {
        if (soapVersion == null) {
            return false;
        }
        if (soapVersion.equals((Object)SOAPVersion.SOAP11) && protocolFactory.createProtocolConfiguration().isSupportoSOAP11()) {
            return true;
        }
        return soapVersion.equals((Object)SOAPVersion.SOAP12) && protocolFactory.createProtocolConfiguration().isSupportoSOAP12();
    }

    public static SOAPVersion getVersioneSoap(Logger log, String cType) {
        return SOAPVersion.getVersioneSoap((Logger)log, (String)cType, (boolean)true);
    }

    public static String readContentTypeFromHeader(HttpServletRequest req) throws Exception {
        return ServletUtils.readContentTypeFromHeader(req, true);
    }

    public static String readContentTypeFromHeader(HttpServletRequest req, boolean returnMsgErroreIfNotFound) throws Exception {
        Enumeration enTrasporto = req.getHeaderNames();
        while (enTrasporto.hasMoreElements()) {
            String nomeProperty = (String)enTrasporto.nextElement();
            if (!"Content-Type".equalsIgnoreCase(nomeProperty)) continue;
            String ct = req.getHeader(nomeProperty);
            if (ct == null) {
                if (returnMsgErroreIfNotFound) {
                    return "Non valorizzato (null)";
                }
                return null;
            }
            return ct;
        }
        if (returnMsgErroreIfNotFound) {
            return "Non presente";
        }
        return null;
    }

    public static Credenziali getCredenziali(HttpServletRequest req, Logger log) throws Exception {
        OpenSPCoop2Properties prop = OpenSPCoop2Properties.getInstance();
        boolean printCert = false;
        if (prop != null && prop.isPrintInfoCertificate()) {
            printCert = true;
        }
        Identity identity = null;
        identity = printCert ? new Identity(req, log) : new Identity(req);
        Credenziali credenziali = new Credenziali();
        credenziali.setUsername(identity.getUsername());
        credenziali.setPassword(identity.getPassword());
        credenziali.setSubject(identity.getSubject());
        credenziali.setCertificati(identity.getCerts());
        return credenziali;
    }

    public static String getLocation(HttpServletRequest req, Credenziali credenziali) {
        String protocollo = "http";
        if (credenziali.getSubject() != null) {
            protocollo = "https";
        }
        String ip = req.getRemoteAddr();
        String port = "" + req.getRemotePort();
        String user = "";
        if (credenziali.getUsername() != null || credenziali.getSubject() != null) {
            user = ":";
            user = credenziali.getSubject() != null ? user + credenziali.getSubject() : user + credenziali.getUsername();
        }
        return protocollo + ":" + ip + ":" + port + user;
    }

    public static String getSoapAction(HttpServletRequest req, SOAPVersion soapVersion, String contentType) throws Exception {
        if (SOAPVersion.SOAP11.equals((Object)soapVersion)) {
            Enumeration enTrasporto = req.getHeaderNames();
            while (enTrasporto.hasMoreElements()) {
                String nomeProperty = (String)enTrasporto.nextElement();
                if (!"SOAPAction".equalsIgnoreCase(nomeProperty)) continue;
                String soapAction = req.getHeader(nomeProperty);
                if (soapAction == null) {
                    throw new Exception("Header http 'SOAPAction' non valorizzato (null)");
                }
                if ((soapAction = soapAction.trim()).startsWith("\"") && !soapAction.endsWith("\"")) {
                    throw new Exception("Header http 'SOAPAction' non valorizzato correttamente (action quotata? Non \u00e8 stato trovato il carattere di chiusura \" ma \u00e8 presente quello di apertura)");
                }
                if (soapAction.endsWith("\"") && !soapAction.startsWith("\"")) {
                    throw new Exception("Header http 'SOAPAction' non valorizzato correttamente (action quotata? Non \u00e8 stato trovato il carattere di apertura \" ma \u00e8 presente quello di chiusura)");
                }
                return soapAction;
            }
            throw new Exception("Header http 'SOAPAction' non presente");
        }
        ContentType ct = new ContentType(contentType);
        if (ct.getParameterList() != null && ct.getParameterList().size() > 0) {
            Enumeration names = ct.getParameterList().getNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!"action".equals(name)) continue;
                return ct.getParameterList().get(name);
            }
        }
        return null;
    }

    public static void checkSoapActionQuotedString(String soapAction, SOAPVersion soapVersion) throws Exception {
        if (!(!SOAPVersion.SOAP11.equals((Object)soapVersion) || soapAction.startsWith("\"") && soapAction.endsWith("\""))) {
            throw new Exception("Header http 'SOAPAction' valorizzato tramite una stringa non quotata (WSI-BP-1.1 R1109)");
        }
    }

    public static URLProtocolContext getParametriInvocazionePorta(HttpServletRequest req, Logger logCore) throws ProtocolException, UtilsException {
        return new URLProtocolContext(req, logCore);
    }

    public static String checkMustUnderstand(SOAPMessage message, IProtocolFactory protocolFactory) throws OpenSPCoop2MessageException {
        SOAPEnvelope envelope = null;
        SOAPHeader header = null;
        try {
            envelope = message.getSOAPPart().getEnvelope();
            header = envelope.getHeader();
            if (header == null) {
                String string = null;
                return string;
            }
            OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
            if (openspcoopProperties != null) {
                if (openspcoopProperties.isBypassFilterMustUnderstandEnabledForAllHeaders()) {
                    String string = null;
                    return string;
                }
                Properties filtri = openspcoopProperties.getBypassFilterMustUnderstandProperties(protocolFactory.getProtocol());
                if (filtri != null && filtri.size() > 0) {
                    String string = ServletUtils.checkMustUnderstandHeaderElement(header, filtri);
                    return string;
                }
            }
        }
        catch (Exception ex) {
            if (Utilities.existsInnerException((Throwable)ex, (String)"com.ctc.wstx.exc.WstxUnexpectedCharException") || Utilities.existsInnerException((Throwable)ex, (String)"com.ctc.wstx.exc.WstxParsingException")) {
                throw new OpenSPCoop2MessageException((Throwable)ex);
            }
            throw new OpenSPCoop2MessageException("BypassMustUnderstand, errore durante il set processed degli header con mustUnderstand='1' e actor non presente: ", (Throwable)ex);
        }
        finally {
            header = null;
            envelope = null;
        }
        return null;
    }

    public static String checkSOAPEnvelopeNamespace(SOAPMessage message, SOAPVersion versioneSoap) throws OpenSPCoop2MessageException {
        SOAPEnvelope envelope = null;
        try {
            envelope = message.getSOAPPart().getEnvelope();
            if (versioneSoap.equals((Object)SOAPVersion.SOAP11) && "http://schemas.xmlsoap.org/soap/envelope/".equals(envelope.getNamespaceURI())) {
                String string = null;
                return string;
            }
            if (versioneSoap.equals((Object)SOAPVersion.SOAP12) && "http://www.w3.org/2003/05/soap-envelope".equals(envelope.getNamespaceURI())) {
                String string = null;
                return string;
            }
            String string = envelope.getNamespaceURI();
            return string;
        }
        catch (Exception ex) {
            throw new OpenSPCoop2MessageException("CheckSoapEnvelopeNamespace, errore durante il controllo del namespace del soap envelope: ", (Throwable)ex);
        }
        finally {
            envelope = null;
        }
    }

    public static String checkMustUnderstandHeaderElement(SOAPHeader header, Properties filtri) throws UtilsException {
        String error = null;
        try {
            Iterator headers = header.getChildElements();
            while (headers.hasNext()) {
                SOAPHeaderElement elementHeader;
                Object element = headers.next();
                if (!(element instanceof SOAPHeaderElement) || (elementHeader = (SOAPHeaderElement)element).getActor() != null || !elementHeader.getMustUnderstand()) continue;
                boolean checked = false;
                Enumeration<Object> en = filtri.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    if (!key.equals(elementHeader.getLocalName()) || !filtri.get(key).equals(elementHeader.getNamespaceURI())) continue;
                    checked = true;
                    break;
                }
                if (checked) continue;
                if (error == null) {
                    error = "{" + elementHeader.getNamespaceURI() + "}" + elementHeader.getLocalName();
                    continue;
                }
                error = error + ", {" + elementHeader.getNamespaceURI() + "}" + elementHeader.getLocalName();
            }
        }
        catch (Exception e) {
            if (Utilities.existsInnerException((Throwable)e, (String)"com.ctc.wstx.exc.WstxUnexpectedCharException")) {
                throw new UtilsException((Throwable)e);
            }
            throw new UtilsException("Utilities.bypassMustUnderstandHeaderElement Riscontrato errore durante l'applicazione del bypassFilter: " + e.getMessage(), (Throwable)e);
        }
        return error;
    }

    public static boolean verificaRispostaRelazioneCodiceTrasporto202(IProtocolFactory protocolFactory, OpenSPCoop2Properties openSPCoopProperties, OpenSPCoop2Message responseMessage, boolean gestioneLatoPortaDelegata) throws Exception {
        if (responseMessage == null) {
            return false;
        }
        IProtocolManager protocolManager = protocolFactory.createProtocolManager();
        boolean rispostaPresente = true;
        if (protocolManager.isHttpEmptyResponseOneWay()) {
            SOAPBody b = responseMessage.getSOAPBody();
            SOAPBody body = null;
            if (b != null) {
                body = b;
            }
            SOAPHeader h = null;
            SOAPHeader header = null;
            if (b == null || body == null || body.getFirstChild() == null) {
                h = responseMessage.getSOAPHeader();
                if (h != null) {
                    header = h;
                }
                if (h == null || header == null || header.getFirstChild() == null) {
                    rispostaPresente = false;
                } else if (gestioneLatoPortaDelegata && !protocolManager.isHttpOneWay_PD_HTTPEmptyResponse()) {
                    rispostaPresente = false;
                }
            }
            body = null;
            b = null;
            header = null;
            h = null;
        }
        return rispostaPresente;
    }

    public static void setTransferLength(TransferLengthModes transferLengthMode, ConnectorInMessage connectorInMessage, ConnectorOutMessage connectorOutMessage, OpenSPCoop2Message message) throws Exception {
        String requestProtocoll = connectorInMessage.getProtocol();
        if (requestProtocoll != null && requestProtocoll.endsWith("1.1")) {
            if (TransferLengthModes.TRANSFER_ENCODING_CHUNKED.equals(transferLengthMode)) {
                connectorOutMessage.setHeader("Transfer-Encoding", "chunked");
            } else if (TransferLengthModes.CONTENT_LENGTH.equals(transferLengthMode) && message != null) {
                message.writeTo((OutputStream)new NullOutputStream(), false);
                connectorOutMessage.setContentLength((int)message.getOutgoingMessageContentLength());
            }
        }
    }

    public static void setTransferLength(TransferLengthModes transferLengthMode, ConnectorInMessage connectorInMessage, ConnectorOutMessage connectorOutMessage, Long length) throws Exception {
        String requestProtocoll = connectorInMessage.getProtocol();
        if (requestProtocoll != null && requestProtocoll.endsWith("1.1")) {
            if (TransferLengthModes.TRANSFER_ENCODING_CHUNKED.equals(transferLengthMode)) {
                connectorOutMessage.setHeader("Transfer-Encoding", "chunked");
            } else if (TransferLengthModes.CONTENT_LENGTH.equals(transferLengthMode) && length != null) {
                connectorOutMessage.setContentLength(length.intValue());
            }
        }
    }
}

