/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services;

import com.ctc.wstx.exc.WstxException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.log4j.Logger;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop2.pdd.core.handlers.BaseContext;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop2.pdd.core.handlers.PreInRequestContext;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativi;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativiContext;
import org.openspcoop2.pdd.services.ServletUtils;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.ConnectorInMessage;
import org.openspcoop2.pdd.services.connector.ConnectorOutMessage;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.engine.builder.ErroreApplicativoBuilder;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.Esito;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.resources.TransportRequestContext;

public class RicezioneContenutiApplicativiSOAP {
    public static OpenSPCoop2MessageFactory factory = OpenSPCoop2MessageFactory.getMessageFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ConnectorInMessage req, ConnectorOutMessage res) throws ConnectorException {
        Exception erroreConsegnaRisposta;
        int statoServletResponse;
        Esito esito;
        SOAPBody body;
        OpenSPCoop2Message responseMessageError;
        OpenSPCoop2Message requestMessage;
        RicezioneContenutiApplicativiContext context;
        BaseContext postOutResponseContext;
        OpenSPCoop2Message responseMessage;
        MsgDiagnostico msgDiag;
        Logger logCore;
        block119: {
            OpenSPCoop2Properties openSPCoopProperties;
            String idModulo = req.getIdModulo();
            IDService idModuloAsService = req.getIdModuloAsIDService();
            Timestamp dataIngressoMessaggio = DateManager.getTimestamp();
            logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (logCore == null) {
                logCore = Logger.getLogger((String)idModulo);
            }
            if ((openSPCoopProperties = OpenSPCoop2Properties.getInstance()) == null) {
                logCore.error((Object)"Inizializzazione di OpenSPCoop non correttamente effettuata: OpenSPCoopProperties");
                try {
                    OpenSPCoop2Message msg = OpenSPCoop2MessageFactory.getMessageFactory().createFaultMessage(SOAPVersion.SOAP11, "ErroreInizializzazioneOpenSPCoopProperties");
                    res.setStatus(500);
                    res.sendResponse(msg, true);
                    res.flush(false);
                    res.close(false);
                    return;
                }
                catch (Exception e) {
                    logCore.error((Object)"Errore generazione SOAPFault", (Throwable)e);
                    throw new ConnectorException("Inizializzazione di OpenSPCoop non correttamente effettuata: OpenSPCoopProperties");
                }
            }
            msgDiag = new MsgDiagnostico(idModulo, new IState[0]);
            msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
            Object oPddContextFromServlet = null;
            try {
                oPddContextFromServlet = req.getAttribute("OPENSPCOOP2_CONTEXT_HEADER_HTTP");
            }
            catch (Exception e) {
                logCore.error((Object)("req.getAttribute(OPENSPCOOP2_CONTEXT_HEADER_HTTP) error: " + e.getMessage()), (Throwable)e);
            }
            PdDContext pddContextFromServlet = null;
            if (oPddContextFromServlet != null) {
                pddContextFromServlet = (PdDContext)oPddContextFromServlet;
            }
            IProtocolFactory protocolFactory = null;
            ErroreApplicativoBuilder erroreApplicativoBuilder = null;
            responseMessage = null;
            ProprietaErroreApplicativo proprietaErroreAppl = null;
            postOutResponseContext = null;
            context = null;
            PdDContext pddContext = null;
            requestMessage = null;
            SOAPVersion versioneSoap = SOAPVersion.SOAP11;
            String protocol = null;
            try {
                protocolFactory = req.getProtocolFactory();
                protocol = protocolFactory.getProtocol();
                proprietaErroreAppl = openSPCoopProperties.getProprietaGestioneErrorePD(protocolFactory.createProtocolManager());
                proprietaErroreAppl.setDominio(openSPCoopProperties.getIdentificativoPortaDefault(protocol));
                proprietaErroreAppl.setIdModulo(idModulo);
                context = new RicezioneContenutiApplicativiContext(idModuloAsService, dataIngressoMessaggio, openSPCoopProperties.getIdentitaPortaDefault(protocol));
                context.setTipoPorta(TipoPdD.DELEGATA);
                context.setIdModulo(idModulo);
                context.getPddContext().addObject("PROTOCOLLO", protocolFactory.getProtocol());
                msgDiag.setPddContext(context.getPddContext(), protocolFactory);
                pddContext = context.getPddContext();
                PreInRequestContext preInRequestContext = new PreInRequestContext(pddContext);
                if (pddContextFromServlet != null) {
                    preInRequestContext.getPddContext().addAll(pddContextFromServlet, true);
                }
                preInRequestContext.setTipoPorta(TipoPdD.DELEGATA);
                Hashtable<String, Object> transportContext = new Hashtable<String, Object>();
                transportContext.put("SERVLET_REQUEST", req);
                transportContext.put("SERVLET_RESPONSE", res);
                preInRequestContext.setTransportContext(transportContext);
                preInRequestContext.setLogCore(logCore);
                GestoreHandlers.preInRequest(preInRequestContext, msgDiag, logCore);
                pddContext.addAll(preInRequestContext.getPddContext(), false);
                NotifierInputStreamParams notifierInputStreamParams = preInRequestContext.getNotifierInputStreamParams();
                context.setNotifierInputStreamParams(notifierInputStreamParams);
                postOutResponseContext = new PostOutResponseContext(logCore, protocolFactory);
                postOutResponseContext.setTipoPorta(TipoPdD.DELEGATA);
                postOutResponseContext.setPddContext(pddContext);
                String contentTypeReq = req.getContentType();
                versioneSoap = ServletUtils.getVersioneSoap(logCore, contentTypeReq);
                boolean contentTypeSupportato = ServletUtils.isContentTypeSupported(versioneSoap, protocolFactory);
                if (versioneSoap == null) {
                    versioneSoap = protocolFactory.createProtocolConfiguration().isSupportoSOAP11() ? SOAPVersion.SOAP11 : SOAPVersion.SOAP12;
                }
                erroreApplicativoBuilder = new ErroreApplicativoBuilder(logCore, protocolFactory, openSPCoopProperties.getIdentitaPortaDefault(protocol), null, null, proprietaErroreAppl.getIdModulo(), proprietaErroreAppl, versioneSoap, TipoPdD.DELEGATA, null);
                pddContext.addObject("SOAP_VERSION", versioneSoap);
                msgDiag.addKeyword("@SOAP_VERSION@", versioneSoap.getSoapVersionAsString());
                msgDiag.addKeyword("@SOAP_NAMESPACE_ATTESO@", versioneSoap.getSoapEnvelopeNS());
                msgDiag.addKeyword("@CONTENT_TYPES_ATTESI@", SOAPVersion.getKnownContentTypesAsString((boolean)protocolFactory.createProtocolConfiguration().isSupportoSOAP11(), (boolean)protocolFactory.createProtocolConfiguration().isSupportoSOAP12()));
                String[] supportedContentTypes = SOAPVersion.getKnownContentTypes((boolean)protocolFactory.createProtocolConfiguration().isSupportoSOAP11(), (boolean)protocolFactory.createProtocolConfiguration().isSupportoSOAP12());
                msgDiag.addKeyword("@HEADER_HTTP@", contentTypeReq);
                if (!openSPCoopProperties.isControlloContentTypeAbilitatoRicezioneContenutiApplicativi() && !contentTypeSupportato) {
                    if ("Non presente".equals(contentTypeReq)) {
                        msgDiag.logPersonalizzato("contentType.notDefined");
                    } else {
                        msgDiag.logPersonalizzato("contentType.unsupported");
                    }
                    contentTypeReq = SOAPVersion.SOAP11.getContentTypeForMessageWithoutAttachments();
                    logCore.warn((Object)("Content-Type non supportato, viene utilizzato forzatamente il tipo: " + contentTypeReq));
                    contentTypeSupportato = true;
                }
                if (!contentTypeSupportato) {
                    if ("Non presente".equals(contentTypeReq)) {
                        msgDiag.logPersonalizzato("contentType.notDefined");
                        responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_433_CONTENT_TYPE_NON_PRESENTE.getErrore433_ContentTypeNonPresente(versioneSoap, supportedContentTypes), null);
                    } else {
                        msgDiag.logPersonalizzato("contentType.unsupported");
                        responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_429_CONTENT_TYPE_NON_SUPPORTATO.getErrore429_ContentTypeNonSupportato(versioneSoap, req.getContentType(), supportedContentTypes), null);
                    }
                } else {
                    String soapAction = req.getSOAPAction(versioneSoap, contentTypeReq);
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativiDirect - Pre costruzione richiesta");
                    requestMessage = req.getRequest(notifierInputStreamParams, contentTypeReq);
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativiDirect - Post costruzione richiesta");
                    String mustUnderstandError = ServletUtils.checkMustUnderstand((SOAPMessage)requestMessage, protocolFactory);
                    String soapEnvelopeNamespaceVersionMismatch = ServletUtils.checkSOAPEnvelopeNamespace((SOAPMessage)requestMessage, versioneSoap);
                    URLProtocolContext urlProtocolContext = req.getURLProtocolContext();
                    requestMessage.setTransportRequestContext((TransportRequestContext)urlProtocolContext);
                    Credenziali credenziali = req.getCredenziali();
                    context.setFromLocation(req.getLocation(credenziali));
                    if (soapAction != null) {
                        if (openSPCoopProperties.checkSoapActionQuotedString_ricezioneContenutiApplicativi()) {
                            ServletUtils.checkSoapActionQuotedString(soapAction, versioneSoap);
                        }
                        context.setSoapAction(soapAction);
                        requestMessage.setProperty("SOAPAction", (Object)soapAction);
                        requestMessage.getMimeHeaders().addHeader("SOAPAction", soapAction);
                    }
                    context.setCredenziali(credenziali);
                    context.setGestioneRisposta(true);
                    context.setInvocazionePDPerRiferimento(false);
                    context.setMessageRequest(requestMessage);
                    context.setUrlProtocolContext(urlProtocolContext);
                    context.setMsgDiagnostico(msgDiag);
                    if (mustUnderstandError == null && soapEnvelopeNamespaceVersionMismatch == null) {
                        RicezioneContenutiApplicativi gestoreRichiesta = new RicezioneContenutiApplicativi(context);
                        gestoreRichiesta.process(req);
                        responseMessage = context.getMessageResponse();
                    } else if (mustUnderstandError != null) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", mustUnderstandError);
                        msgDiag.logPersonalizzato("mustUnderstand.unknown");
                        responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_427_MUSTUNDERSTAND_ERROR.getErrore427_MustUnderstandHeaders(mustUnderstandError), null);
                    } else {
                        msgDiag.addKeyword("@SOAP_NAMESPACE@", soapEnvelopeNamespaceVersionMismatch);
                        msgDiag.logPersonalizzato("soapEnvelopeNamespace.versionMismatch");
                        responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_430_SOAP_ENVELOPE_NAMESPACE_ERROR.getErrore430_SoapNamespaceNonSupportato(versioneSoap, soapEnvelopeNamespaceVersionMismatch), null);
                    }
                }
            }
            catch (ProtocolException e) {
                try {
                    protocolFactory = ProtocolFactoryManager.getInstance().getDefaultProtocolFactory();
                    proprietaErroreAppl = openSPCoopProperties.getProprietaGestioneErrorePD(protocolFactory.createProtocolManager());
                    proprietaErroreAppl.setDominio(openSPCoopProperties.getIdentificativoPortaDefault(protocol));
                    proprietaErroreAppl.setIdModulo(idModulo);
                    erroreApplicativoBuilder = new ErroreApplicativoBuilder(logCore, protocolFactory, openSPCoopProperties.getIdentitaPortaDefault(protocol), null, null, idModulo, proprietaErroreAppl, versioneSoap, TipoPdD.DELEGATA, null);
                    context = RicezioneContenutiApplicativiContext.newRicezioneContenutiApplicativiContext(idModuloAsService, dataIngressoMessaggio, openSPCoopProperties.getIdentitaPortaDefault(protocol));
                    context.setTipoPorta(TipoPdD.DELEGATA);
                    context.setIdModulo(idModulo);
                    context.getPddContext().addObject("PROTOCOLLO", protocolFactory.getProtocol());
                    pddContext = context.getPddContext();
                    if (postOutResponseContext != null) {
                        postOutResponseContext.setPddContext(pddContext);
                    }
                    msgDiag.setPddContext(pddContext, protocolFactory);
                    msgDiag.logErroreGenerico((Exception)((Object)e), "MessaggioRichiestaMalformato");
                    responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_426_SERVLET_ERROR.getErrore426_ServletError(true, (Exception)((Object)e)), (Exception)((Object)e));
                }
                catch (ProtocolException ep) {
                    throw new ConnectorException(ep.getMessage(), ep);
                }
            }
            catch (Exception e) {
                if (context == null) {
                    context = RicezioneContenutiApplicativiContext.newRicezioneContenutiApplicativiContext(idModuloAsService, dataIngressoMessaggio, openSPCoopProperties.getIdentitaPortaDefault(protocol));
                    context.setTipoPorta(TipoPdD.DELEGATA);
                    context.setIdModulo(idModulo);
                    context.getPddContext().addObject("PROTOCOLLO", protocolFactory.getProtocol());
                    pddContext = context.getPddContext();
                    postOutResponseContext.setPddContext(pddContext);
                    msgDiag.setPddContext(pddContext, protocolFactory);
                }
                logCore.error((Object)"ErroreGenerale", (Throwable)e);
                msgDiag.logErroreGenerico(e, "Generale(richiesta)");
                String msgErrore = e.getMessage();
                if (msgErrore == null) {
                    msgErrore = e.toString();
                }
                if (msgErrore.equals("Transport level information does not match with SOAP Message namespace URI") || msgErrore.equals("I dati ricevuti non rappresentano un messaggio SOAP 1.1 valido: ")) {
                    msgDiag.addKeyword("@SOAP_NAMESPACE@", "Impossibile recuperare il valore del namespace");
                    msgDiag.logPersonalizzato("soapEnvelopeNamespace.versionMismatch");
                    responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_430_SOAP_ENVELOPE_NAMESPACE_ERROR.getErrore430_SoapNamespaceNonSupportato(versioneSoap, "Impossibile recuperare il valore del namespace"), e);
                } else {
                    responseMessage = e instanceof WstxException || e.getCause() instanceof WstxException ? erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_432_MESSAGGIO_XML_MALFORMATO.getErrore432_MessaggioRichiestaMalformato(true, e), e) : erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_426_SERVLET_ERROR.getErrore426_ServletError(true, e), e);
                }
            }
            finally {
                if (requestMessage != null) {
                    String msgErrore;
                    if (requestMessage.getParsingError() != null) {
                        msgErrore = requestMessage.getParsingError().getMessage();
                        if (msgErrore == null) {
                            msgErrore = requestMessage.getParsingError().toString();
                        }
                        msgDiag.logErroreGenerico(requestMessage.getParsingError(), "MessaggioRichiestaMalformato");
                        responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_432_MESSAGGIO_XML_MALFORMATO.getErrore432_MessaggioRichiestaMalformato(true, requestMessage.getParsingError()), requestMessage.getParsingError());
                    } else if (responseMessage != null && responseMessage.getParsingError() != null) {
                        msgErrore = responseMessage.getParsingError().getMessage();
                        if (msgErrore == null) {
                            msgErrore = responseMessage.getParsingError().toString();
                        }
                        msgDiag.logErroreGenerico(responseMessage.getParsingError(), "MessaggioRispostaMalformato");
                        responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_432_MESSAGGIO_XML_MALFORMATO.getErrore432_MessaggioRichiestaMalformato(false, responseMessage.getParsingError()), responseMessage.getParsingError());
                    }
                }
                try {
                    req.close();
                }
                catch (Exception e) {
                    logCore.error((Object)("Request.close() error: " + e.getMessage()), (Throwable)e);
                }
            }
            if (context.getMsgDiagnostico() != null) {
                msgDiag = context.getMsgDiagnostico();
            }
            if (context.getHeaderIntegrazioneRisposta() != null) {
                Enumeration<Object> en = context.getHeaderIntegrazioneRisposta().keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    String value = null;
                    try {
                        value = context.getHeaderIntegrazioneRisposta().getProperty(key);
                        res.setHeader(key, value);
                    }
                    catch (Exception e) {
                        logCore.error((Object)("Request.setHeader(" + key + "," + value + ") error: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            if (context != null && context.getProtocol() != null) {
                erroreApplicativoBuilder.setMittente(context.getProtocol().getFruitore());
                IDServizio idServizio = new IDServizio();
                idServizio.setSoggettoErogatore(context.getProtocol().getErogatore());
                idServizio.setTipoServizio(context.getProtocol().getTipoServizio());
                idServizio.setServizio(context.getProtocol().getServizio());
                idServizio.setAzione(context.getProtocol().getAzione());
                erroreApplicativoBuilder.setServizio(idServizio);
                erroreApplicativoBuilder.setDominio(context.getIdentitaPdD());
                erroreApplicativoBuilder.setProprietaErroreApplicato(context.getProprietaErroreAppl());
            }
            if (context != null && context.getIntegrazione() != null) {
                erroreApplicativoBuilder.setServizioApplicativo(context.getIntegrazione().getServizioApplicativoFruitore());
            }
            responseMessageError = null;
            body = null;
            esito = null;
            String descrizioneSoapFault = "";
            statoServletResponse = 200;
            erroreConsegnaRisposta = null;
            boolean httpEmptyResponse = false;
            try {
                if (responseMessage != null) {
                    if (responseMessage.getForcedResponseCode() != null) {
                        try {
                            statoServletResponse = Integer.parseInt(responseMessage.getForcedResponseCode());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ServletUtils.setTransferLength(openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi(), req, res, responseMessage);
                    responseMessage.updateContentType();
                    String contentTypeRisposta = responseMessage.getContentType();
                    if (contentTypeRisposta == null) {
                        throw new Exception("Risposta senza Content-type");
                    }
                    res.setContentType(contentTypeRisposta);
                    body = responseMessage.getSOAPBody();
                    esito = protocolFactory.createEsitoBuilder().getEsito(responseMessage, context.getProprietaErroreAppl());
                    if (body != null && body.hasFault()) {
                        statoServletResponse = 500;
                        descrizioneSoapFault = " (" + SoapUtils.toString((SOAPFault)body.getFault(), (boolean)false) + ")";
                    }
                    res.setStatus(statoServletResponse);
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativiDirect - Pre scrittura risposta");
                    if (TransferLengthModes.CONTENT_LENGTH.equals(openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi())) {
                        res.sendResponse(responseMessage, false);
                    } else {
                        res.sendResponse(responseMessage, true);
                    }
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativiDirect - Post scrittura risposta");
                    break block119;
                }
                statoServletResponse = protocolFactory.createProtocolManager().getHttpReturnCodeEmptyResponseOneWay();
                res.setStatus(statoServletResponse);
                httpEmptyResponse = true;
                esito = Esito.OK;
            }
            catch (Exception e) {
                logCore.error((Object)"ErroreGenerale", (Throwable)e);
                erroreConsegnaRisposta = e;
                try {
                    if (responseMessage.getParsingError() != null) {
                        String msgErrore = responseMessage.getParsingError().getMessage();
                        if (msgErrore == null) {
                            msgErrore = responseMessage.getParsingError().toString();
                        }
                        msgDiag.logErroreGenerico(responseMessage.getParsingError(), "MessaggioRispostaMalformato");
                        responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_432_MESSAGGIO_XML_MALFORMATO.getErrore432_MessaggioRichiestaMalformato(false, responseMessage.getParsingError()), e);
                    } else {
                        responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_426_SERVLET_ERROR.getErrore426_ServletError(false, e), responseMessage.getParsingError());
                    }
                    ServletUtils.setTransferLength(openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi(), req, res, responseMessageError);
                    String contentTypeRisposta = responseMessage.getContentType();
                    if (contentTypeRisposta == null) {
                        throw new Exception("Risposta errore senza Content-type");
                    }
                    res.setContentType(contentTypeRisposta);
                    body = responseMessageError.getSOAPBody();
                    esito = protocolFactory.createEsitoBuilder().getEsito(responseMessageError, context.getProprietaErroreAppl());
                    if (body != null && body.hasFault()) {
                        statoServletResponse = 500;
                        res.setStatus(500);
                        descrizioneSoapFault = " (" + SoapUtils.toString((SOAPFault)body.getFault(), (boolean)false) + ")";
                    }
                    if (TransferLengthModes.CONTENT_LENGTH.equals(openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi())) {
                        res.sendResponse(responseMessage, false);
                        break block119;
                    }
                    res.sendResponse(responseMessage, true);
                }
                catch (Exception error) {
                    logCore.error((Object)"Generazione di un risposta errore non riuscita", (Throwable)error);
                    statoServletResponse = 500;
                    try {
                        res.setStatus(500);
                    }
                    catch (Exception eStatus) {
                        logCore.error((Object)("Response.setStatus(500) error: " + eStatus.getMessage()), (Throwable)eStatus);
                    }
                    try {
                        OpenSPCoop2Message m = OpenSPCoop2MessageFactory.getMessageFactory().createFaultMessage(versioneSoap, (Throwable)error);
                        res.sendResponse(m, true);
                    }
                    catch (Exception eError) {
                        try {
                            res.sendResponse(error.toString().getBytes());
                        }
                        catch (Exception erroreStreamChiuso) {
                            // empty catch block
                        }
                    }
                    esito = Esito.ERRORE_PROCESSAMENTO_PDD_5XX;
                }
            }
            finally {
                statoServletResponse = res.getResponseStatus();
                msgDiag.addKeyword("@CODICE_CONSEGNA@", "" + statoServletResponse);
                msgDiag.addKeyword("@SOAP_FAULT@", descrizioneSoapFault);
                try {
                    res.flush(true);
                    res.close(true);
                    if (erroreConsegnaRisposta != null) {
                        msgDiag.addKeyword("@ERRORE_CONSEGNA@", erroreConsegnaRisposta.toString());
                        msgDiag.logPersonalizzato("consegnaRispostaApplicativaFallita");
                    } else if (httpEmptyResponse) {
                        msgDiag.logPersonalizzato("consegnaRispostaApplicativaVuota");
                    } else if (statoServletResponse == 500) {
                        msgDiag.logPersonalizzato("consegnaRispostaApplicativaKoEffettuata");
                    } else {
                        msgDiag.logPersonalizzato("consegnaRispostaApplicativaOkEffettuata");
                    }
                }
                catch (Exception e) {
                    logCore.error((Object)"Chiusura stream non riuscita", (Throwable)e);
                    msgDiag.addKeyword("@ERRORE_CONSEGNA@", e.toString());
                    msgDiag.logPersonalizzato("consegnaRispostaApplicativaFallita");
                    erroreConsegnaRisposta = e;
                }
            }
        }
        String location = "...";
        try {
            IConnettore c = null;
            if (context.getIdMessage() != null) {
                c = RepositoryConnettori.removeConnettorePD(context.getIdMessage());
            }
            if (c != null) {
                location = c.getLocation();
                c.disconnect();
            }
        }
        catch (Exception e) {
            msgDiag.logDisconnectError(e, location);
        }
        if (postOutResponseContext != null) {
            try {
                postOutResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
                ((PostOutResponseContext)postOutResponseContext).setEsito(esito);
                ((PostOutResponseContext)postOutResponseContext).setReturnCode(statoServletResponse);
                ((OutResponseContext)postOutResponseContext).setPropertiesRispostaTrasporto(context.getHeaderIntegrazioneRisposta());
                ((OutResponseContext)postOutResponseContext).setProtocollo(context.getProtocol());
                ((OutResponseContext)postOutResponseContext).setIntegrazione(context.getIntegrazione());
                if (context.getTipoPorta() != null) {
                    postOutResponseContext.setTipoPorta(context.getTipoPorta());
                }
                if (requestMessage != null) {
                    ((PostOutResponseContext)postOutResponseContext).setInputRequestMessageSize(requestMessage.getIncomingMessageContentLength());
                    ((PostOutResponseContext)postOutResponseContext).setOutputRequestMessageSize(requestMessage.getOutgoingMessageContentLength());
                } else {
                    ((PostOutResponseContext)postOutResponseContext).setInputRequestMessageSize((long)req.getContentLength() + 0L);
                }
                if (erroreConsegnaRisposta != null) {
                    if (responseMessageError != null) {
                        ((PostOutResponseContext)postOutResponseContext).setInputResponseMessageSize(responseMessageError.getIncomingMessageContentLength());
                        ((PostOutResponseContext)postOutResponseContext).setOutputResponseMessageSize(responseMessageError.getOutgoingMessageContentLength());
                        postOutResponseContext.setMessaggio(responseMessageError);
                    } else if (responseMessage != null) {
                        ((PostOutResponseContext)postOutResponseContext).setInputResponseMessageSize(responseMessage.getIncomingMessageContentLength());
                        ((PostOutResponseContext)postOutResponseContext).setOutputResponseMessageSize(responseMessage.getOutgoingMessageContentLength());
                        postOutResponseContext.setMessaggio(responseMessage);
                    }
                    ((PostOutResponseContext)postOutResponseContext).setErroreConsegna(erroreConsegnaRisposta.toString());
                } else if (responseMessage != null) {
                    ((PostOutResponseContext)postOutResponseContext).setInputResponseMessageSize(responseMessage.getIncomingMessageContentLength());
                    ((PostOutResponseContext)postOutResponseContext).setOutputResponseMessageSize(responseMessage.getOutgoingMessageContentLength());
                    postOutResponseContext.setMessaggio(responseMessage);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "postOutResponse, preparazione contesto");
            }
            GestoreHandlers.postOutResponse((PostOutResponseContext)postOutResponseContext, msgDiag, logCore);
        }
        try {
            if (requestMessage != null && requestMessage.getNotifierInputStream() != null) {
                requestMessage.getNotifierInputStream().close();
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "Rilascio risorse NotifierInputStream richiesta");
        }
        try {
            if (responseMessage != null && responseMessage.getNotifierInputStream() != null) {
                responseMessage.getNotifierInputStream().close();
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "Rilascio risorse NotifierInputStream risposta");
        }
        requestMessage = null;
        body = null;
        responseMessage = null;
        responseMessageError = null;
    }
}

