/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services;

import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import org.apache.log4j.Logger;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.message.MailcapActivationReader;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.message.XMLUtils;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.core.connettori.RepositoryConnettori;
import org.openspcoop2.pdd.core.handlers.BaseContext;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop2.pdd.core.handlers.PreInRequestContext;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativi;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativiContext;
import org.openspcoop2.pdd.services.ServletUtils;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.ConnectorInMessage;
import org.openspcoop2.pdd.services.connector.ConnectorOutMessage;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.engine.builder.ErroreApplicativoBuilder;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.Esito;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.resources.TransportRequestContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RicezioneContenutiApplicativiHTTPtoSOAP {
    public static OpenSPCoop2MessageFactory factory = OpenSPCoop2MessageFactory.getMessageFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ConnectorInMessage req, ConnectorOutMessage res) throws ConnectorException {
        long lengthOutResponse;
        Exception erroreConsegnaRisposta;
        int statoServletResponse;
        Esito esito;
        SOAPBody body;
        byte[] inputBody;
        OpenSPCoop2Message responseMessage;
        OpenSPCoop2Message requestMessage;
        RicezioneContenutiApplicativiContext context;
        BaseContext postOutResponseContext;
        MsgDiagnostico msgDiag;
        Logger logCore;
        block111: {
            OpenSPCoop2Properties openSPCoopProperties;
            String idModulo = req.getIdModulo();
            IDService idModuloAsService = req.getIdModuloAsIDService();
            Timestamp dataIngressoMessaggio = DateManager.getTimestamp();
            logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (logCore == null) {
                logCore = Logger.getLogger((String)idModulo);
            }
            if ((openSPCoopProperties = OpenSPCoop2Properties.getInstance()) == null) {
                logCore.error((Object)"Inizializzazione di OpenSPCoop non correttamente effettuata: OpenSPCoopProperties");
                try {
                    OpenSPCoop2Message msg = OpenSPCoop2MessageFactory.getMessageFactory().createFaultMessage(SOAPVersion.SOAP11, "ErroreInizializzazioneOpenSPCoopProperties");
                    res.setStatus(500);
                    res.sendResponse(SoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)msg));
                    res.flush(false);
                    res.close(false);
                    return;
                }
                catch (Exception e) {
                    logCore.error((Object)"Errore generazione SOAPFault", (Throwable)e);
                    throw new ConnectorException("Inizializzazione di OpenSPCoop non correttamente effettuata: OpenSPCoopProperties");
                }
            }
            msgDiag = new MsgDiagnostico(idModulo, new IState[0]);
            msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
            Object oPddContextFromServlet = null;
            try {
                oPddContextFromServlet = req.getAttribute("OPENSPCOOP2_CONTEXT_HEADER_HTTP");
            }
            catch (Exception e) {
                logCore.error((Object)("req.getAttribute(OPENSPCOOP2_CONTEXT_HEADER_HTTP) error: " + e.getMessage()), (Throwable)e);
            }
            PdDContext pddContextFromServlet = null;
            if (oPddContextFromServlet != null) {
                pddContextFromServlet = (PdDContext)oPddContextFromServlet;
            }
            ErroreApplicativoBuilder erroreApplicativoBuilder = null;
            ProprietaErroreApplicativo proprietaErroreAppl = null;
            postOutResponseContext = null;
            context = null;
            PdDContext pddContext = null;
            String errorImbustamentoSoapNonRiuscito = null;
            requestMessage = null;
            responseMessage = null;
            IProtocolFactory protocolFactory = null;
            SOAPVersion versioneSoap = SOAPVersion.SOAP11;
            String protocol = null;
            inputBody = null;
            try {
                protocolFactory = req.getProtocolFactory();
                protocol = protocolFactory.getProtocol();
                if (!ServletUtils.isContentTypeSupported(versioneSoap, protocolFactory)) {
                    versioneSoap = SOAPVersion.SOAP12;
                }
                proprietaErroreAppl = openSPCoopProperties.getProprietaGestioneErrorePD(protocolFactory.createProtocolManager());
                proprietaErroreAppl.setDominio(openSPCoopProperties.getIdentificativoPortaDefault(protocol));
                proprietaErroreAppl.setIdModulo(idModulo);
                proprietaErroreAppl.setFaultAsXML(true);
                erroreApplicativoBuilder = new ErroreApplicativoBuilder(logCore, protocolFactory, openSPCoopProperties.getIdentitaPortaDefault(protocol), null, null, proprietaErroreAppl.getIdModulo(), proprietaErroreAppl, versioneSoap, TipoPdD.DELEGATA, null);
                context = new RicezioneContenutiApplicativiContext(idModuloAsService, dataIngressoMessaggio, openSPCoopProperties.getIdentitaPortaDefault(protocol));
                context.setTipoPorta(TipoPdD.DELEGATA);
                context.setForceFaultAsXML(true);
                context.setIdModulo(idModulo);
                msgDiag.setPddContext(context.getPddContext(), protocolFactory);
                pddContext = context.getPddContext();
                PreInRequestContext preInRequestContext = new PreInRequestContext(pddContext);
                if (pddContextFromServlet != null) {
                    preInRequestContext.getPddContext().addAll(pddContextFromServlet, true);
                }
                preInRequestContext.setTipoPorta(TipoPdD.DELEGATA);
                Hashtable<String, Object> transportContext = new Hashtable<String, Object>();
                transportContext.put("SERVLET_REQUEST", req);
                transportContext.put("SERVLET_RESPONSE", res);
                preInRequestContext.setTransportContext(transportContext);
                preInRequestContext.setLogCore(logCore);
                GestoreHandlers.preInRequest(preInRequestContext, msgDiag, logCore);
                pddContext.addAll(preInRequestContext.getPddContext(), false);
                NotifierInputStreamParams notifierInputStreamParams = preInRequestContext.getNotifierInputStreamParams();
                context.setNotifierInputStreamParams(notifierInputStreamParams);
                postOutResponseContext = new PostOutResponseContext(logCore, protocolFactory);
                postOutResponseContext.setTipoPorta(TipoPdD.DELEGATA);
                postOutResponseContext.setPddContext(pddContext);
                context.getPddContext().addObject("PROTOCOLLO", protocolFactory.getProtocol());
                context.getPddContext().addObject("SOAP_VERSION", SOAPVersion.SOAP11);
                String soapAction = null;
                try {
                    soapAction = req.getSOAPAction(versioneSoap, "application/xml");
                }
                catch (Exception e) {
                    // empty catch block
                }
                boolean imbustamentoConAttachment = false;
                String tipoAttachment = "application/openspcoop2";
                String imb = req.getHeader(openSPCoopProperties.getTunnelSOAPKeyWord_headerTrasporto());
                if (imb != null && "true".equals(imb.trim())) {
                    imbustamentoConAttachment = true;
                    String mime = req.getHeader(openSPCoopProperties.getTunnelSOAPKeyWordMimeType_headerTrasporto());
                    if (mime != null) {
                        tipoAttachment = mime.trim();
                    }
                }
                if (imb == null && req.getParameter(openSPCoopProperties.getTunnelSOAPKeyWord_urlBased()) != null && "true".equalsIgnoreCase(req.getParameter(openSPCoopProperties.getTunnelSOAPKeyWord_urlBased()))) {
                    imbustamentoConAttachment = true;
                    if (req.getParameter(openSPCoopProperties.getTunnelSOAPKeyWordMimeType_urlBased()) != null) {
                        tipoAttachment = req.getParameter(openSPCoopProperties.getTunnelSOAPKeyWordMimeType_urlBased());
                    }
                }
                if (imb == null && transportContext.get(openSPCoopProperties.getTunnelSOAPKeyWord_urlBased()) != null && "true".equalsIgnoreCase((String)transportContext.get(openSPCoopProperties.getTunnelSOAPKeyWord_urlBased()))) {
                    imbustamentoConAttachment = true;
                    if (transportContext.get(openSPCoopProperties.getTunnelSOAPKeyWordMimeType_urlBased()) != null) {
                        tipoAttachment = (String)transportContext.get(openSPCoopProperties.getTunnelSOAPKeyWordMimeType_urlBased());
                    }
                }
                String tipoLetturaRisposta = null;
                try {
                    inputBody = req.getRequest();
                    if (inputBody == null || inputBody.length <= 0) {
                        throw new Exception("Ricevuto nessun contenuto da imbustare");
                    }
                    req.close();
                    if (imbustamentoConAttachment) {
                        tipoLetturaRisposta = "Costruzione messaggio SOAP per Tunnel con mimeType " + tipoAttachment;
                        requestMessage = SoapUtils.imbustamentoMessaggioConAttachment((SOAPVersion)SOAPVersion.SOAP11, (byte[])inputBody, (String)tipoAttachment, (boolean)MailcapActivationReader.existsDataContentHandler((String)tipoAttachment), (String)req.getContentType(), (String)openSPCoopProperties.getHeaderSoapActorIntegrazione());
                    } else {
                        tipoLetturaRisposta = "Imbustamento messaggio in un messaggio SOAP";
                        requestMessage = SoapUtils.imbustamentoMessaggio((NotifierInputStreamParams)notifierInputStreamParams, (byte[])inputBody, (boolean)openSPCoopProperties.isDeleteInstructionTargetMachineXml(), (boolean)openSPCoopProperties.isFileCacheEnable(), (String)openSPCoopProperties.getAttachmentRepoDir(), (String)openSPCoopProperties.getFileThreshold());
                    }
                }
                catch (Exception e) {
                    logCore.error((Object)(tipoLetturaRisposta + " con errore: " + e.getMessage()), (Throwable)e);
                    requestMessage = null;
                    errorImbustamentoSoapNonRiuscito = tipoLetturaRisposta + " con errore: " + e.getMessage();
                }
                if (requestMessage == null) {
                    throw new Exception("ImbustamentoSOAP non riuscito");
                }
                if (soapAction != null) {
                    if (openSPCoopProperties.checkSoapActionQuotedString_ricezioneContenutiApplicativi()) {
                        ServletUtils.checkSoapActionQuotedString(soapAction, versioneSoap);
                    }
                    context.setSoapAction(soapAction);
                    requestMessage.setProperty("SOAPAction", (Object)soapAction);
                    requestMessage.getMimeHeaders().addHeader("SOAPAction", soapAction);
                }
                URLProtocolContext urlProtocolContext = req.getURLProtocolContext();
                requestMessage.setTransportRequestContext((TransportRequestContext)urlProtocolContext);
                Credenziali credenziali = req.getCredenziali();
                context.setFromLocation(req.getLocation(credenziali));
                context.setCredenziali(credenziali);
                context.setGestioneRisposta(true);
                context.setInvocazionePDPerRiferimento(false);
                context.setMessageRequest(requestMessage);
                context.setUrlProtocolContext(urlProtocolContext);
                context.setMsgDiagnostico(msgDiag);
                RicezioneContenutiApplicativi gestoreRichiesta = new RicezioneContenutiApplicativi(context);
                gestoreRichiesta.process(req);
                responseMessage = context.getMessageResponse();
            }
            catch (ProtocolException e) {
                try {
                    protocolFactory = ProtocolFactoryManager.getInstance().getDefaultProtocolFactory();
                    proprietaErroreAppl = openSPCoopProperties.getProprietaGestioneErrorePD(protocolFactory.createProtocolManager());
                    proprietaErroreAppl.setDominio(openSPCoopProperties.getIdentificativoPortaDefault(protocol));
                    proprietaErroreAppl.setIdModulo(idModulo);
                    proprietaErroreAppl.setFaultAsXML(true);
                    erroreApplicativoBuilder = new ErroreApplicativoBuilder(logCore, protocolFactory, openSPCoopProperties.getIdentitaPortaDefault(protocol), null, null, idModulo, proprietaErroreAppl, versioneSoap, TipoPdD.DELEGATA, null);
                    context = RicezioneContenutiApplicativiContext.newRicezioneContenutiApplicativiContext(idModuloAsService, dataIngressoMessaggio, openSPCoopProperties.getIdentitaPortaDefault(protocol));
                    context.setTipoPorta(TipoPdD.DELEGATA);
                    context.setIdModulo(idModulo);
                    context.getPddContext().addObject("PROTOCOLLO", protocolFactory.getProtocol());
                    pddContext = context.getPddContext();
                    if (postOutResponseContext != null) {
                        postOutResponseContext.setPddContext(pddContext);
                    }
                    msgDiag.setPddContext(pddContext, ProtocolFactoryManager.getInstance().getDefaultProtocolFactory());
                    msgDiag.logErroreGenerico((Exception)((Object)e), "MessaggioRichiestaMalformato");
                    responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_426_SERVLET_ERROR.getErrore426_ServletError(true, (Exception)((Object)e)), (Exception)((Object)e));
                }
                catch (ProtocolException ep) {
                    throw new ConnectorException(ep.getMessage(), ep);
                }
            }
            catch (Exception e) {
                if (context == null) {
                    context = RicezioneContenutiApplicativiContext.newRicezioneContenutiApplicativiContext(idModuloAsService, dataIngressoMessaggio, openSPCoopProperties.getIdentitaPortaDefault(protocol));
                    context.setTipoPorta(TipoPdD.DELEGATA);
                    context.setForceFaultAsXML(true);
                    context.setIdModulo(idModulo);
                    context.getPddContext().addObject("PROTOCOLLO", protocolFactory.getProtocol());
                    pddContext = context.getPddContext();
                    msgDiag.setPddContext(pddContext, protocolFactory);
                    postOutResponseContext.setPddContext(pddContext);
                }
                logCore.error((Object)"ImbustamentoSoap non riuscito", (Throwable)e);
                Exception eParsing = null;
                if (requestMessage != null && (eParsing = requestMessage.getParsingError()) == null && responseMessage != null) {
                    eParsing = responseMessage.getParsingError();
                }
                if (errorImbustamentoSoapNonRiuscito != null) {
                    logCore.error((Object)"ImbustamentoSOAP", (Throwable)e);
                    msgDiag.logErroreGenerico(errorImbustamentoSoapNonRiuscito + "  " + e.getMessage(), "ImbustamentoSOAP");
                    responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_422_IMBUSTAMENTO_SOAP_NON_RIUSCITO_RICHIESTA_APPLICATIVA.getErrore422_MessaggioSOAPNonGenerabileTramiteImbustamentoSOAP(errorImbustamentoSoapNonRiuscito), eParsing);
                } else {
                    logCore.error((Object)"ErroreGenerale", (Throwable)e);
                    msgDiag.logErroreGenerico(e, "Generale(richiesta)");
                    responseMessage = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), eParsing);
                }
            }
            finally {
                try {
                    req.close();
                }
                catch (Exception e) {
                    logCore.error((Object)("Request.close() error: " + e.getMessage()), (Throwable)e);
                }
            }
            if (context.getMsgDiagnostico() != null) {
                msgDiag = context.getMsgDiagnostico();
            }
            if (context.getHeaderIntegrazioneRisposta() != null) {
                Enumeration<Object> en = context.getHeaderIntegrazioneRisposta().keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    String value = null;
                    try {
                        value = context.getHeaderIntegrazioneRisposta().getProperty(key);
                        res.setHeader(key, value);
                    }
                    catch (Exception e) {
                        logCore.error((Object)("Request.setHeader(" + key + "," + value + ") error: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            if (context != null && context.getProtocol() != null) {
                erroreApplicativoBuilder.setMittente(context.getProtocol().getFruitore());
                IDServizio idServizio = new IDServizio();
                idServizio.setSoggettoErogatore(context.getProtocol().getErogatore());
                idServizio.setTipoServizio(context.getProtocol().getTipoServizio());
                idServizio.setServizio(context.getProtocol().getServizio());
                idServizio.setAzione(context.getProtocol().getAzione());
                erroreApplicativoBuilder.setServizio(idServizio);
                erroreApplicativoBuilder.setDominio(context.getIdentitaPdD());
                erroreApplicativoBuilder.setProprietaErroreApplicato(context.getProprietaErroreAppl());
            }
            if (context != null && context.getIntegrazione() != null) {
                erroreApplicativoBuilder.setServizioApplicativo(context.getIntegrazione().getServizioApplicativoFruitore());
            }
            body = null;
            esito = null;
            String descrizioneSoapFault = "";
            statoServletResponse = 200;
            erroreConsegnaRisposta = null;
            boolean httpEmptyResponse = false;
            lengthOutResponse = -1L;
            try {
                if (responseMessage != null) {
                    boolean forced = false;
                    if (responseMessage.getForcedResponseCode() != null) {
                        try {
                            statoServletResponse = Integer.parseInt(responseMessage.getForcedResponseCode());
                            forced = true;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    String contentTypeRisposta = null;
                    byte[] risposta = null;
                    body = responseMessage.getSOAPBody();
                    esito = protocolFactory.createEsitoBuilder().getEsito(responseMessage, context.getProprietaErroreAppl());
                    if (body != null && body.hasFault()) {
                        statoServletResponse = 500;
                        String msgError = SoapUtils.toString((SOAPFault)body.getFault(), (boolean)false);
                        XMLUtils xmlUtils = XMLUtils.getInstance();
                        risposta = xmlUtils.toByteArray((Element)body.getFault(), true);
                        contentTypeRisposta = responseMessage.getContentType();
                        descrizioneSoapFault = " (" + msgError + ")";
                    } else {
                        risposta = SoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)responseMessage);
                        if (risposta == null || risposta.length <= 0) {
                            risposta = null;
                            if (!forced) {
                                statoServletResponse = 202;
                            }
                        } else {
                            SOAPElement child = SoapUtils.getNotEmptyFirstChildSOAPElement((SOAPElement)body);
                            if (child != null && protocolFactory.createErroreApplicativoBuilder().isErroreApplicativo((Node)child)) {
                                statoServletResponse = 500;
                            }
                            contentTypeRisposta = SoapUtils.isTunnelOpenSPCoopSoap((SOAPBody)body) ? SoapUtils.getContentTypeTunnelOpenSPCoopSoap((SOAPBody)responseMessage.getSOAPBody()) : responseMessage.getContentType();
                        }
                    }
                    if (risposta != null) {
                        lengthOutResponse = risposta.length;
                        ServletUtils.setTransferLength(openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi(), req, res, new Long(risposta.length));
                    }
                    res.setStatus(statoServletResponse);
                    if (contentTypeRisposta != null) {
                        res.setContentType(contentTypeRisposta);
                    }
                    if (risposta != null) {
                        res.sendResponse(risposta);
                    }
                    break block111;
                }
                statoServletResponse = protocolFactory.createProtocolManager().getHttpReturnCodeEmptyResponseOneWay();
                res.setStatus(statoServletResponse);
                httpEmptyResponse = true;
                esito = Esito.OK;
            }
            catch (Exception e) {
                logCore.error((Object)"ErroreGenerale", (Throwable)e);
                erroreConsegnaRisposta = e;
                esito = Esito.ERRORE_PROCESSAMENTO_PDD_5XX;
                try {
                    proprietaErroreAppl.setDominio(openSPCoopProperties.getIdentificativoPortaDefault(protocol));
                    proprietaErroreAppl.setIdModulo(idModulo);
                    byte[] rispostaErrore = erroreApplicativoBuilder.toByteArray(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
                    lengthOutResponse = rispostaErrore.length;
                    ServletUtils.setTransferLength(openSPCoopProperties.getTransferLengthModes_ricezioneContenutiApplicativi(), req, res, new Long(rispostaErrore.length));
                    res.setStatus(200);
                    res.setContentType("text/xml");
                    res.sendResponse(rispostaErrore);
                }
                catch (Exception error) {
                    logCore.error((Object)"Generazione di un risposta errore non riuscita", (Throwable)error);
                    statoServletResponse = 500;
                    try {
                        res.setStatus(500);
                    }
                    catch (Exception eStatus) {
                        logCore.error((Object)("Response.setStatus(500) error: " + eStatus.getMessage()), (Throwable)eStatus);
                    }
                    byte[] ris = error.toString().getBytes();
                    try {
                        res.sendResponse(ris);
                    }
                    catch (Exception erroreStreamChiuso) {
                        // empty catch block
                    }
                    lengthOutResponse = ris.length;
                }
            }
            finally {
                statoServletResponse = res.getResponseStatus();
                msgDiag.addKeyword("@CODICE_CONSEGNA@", "" + statoServletResponse);
                msgDiag.addKeyword("@SOAP_FAULT@", descrizioneSoapFault);
                try {
                    res.flush(true);
                    res.close(true);
                    if (erroreConsegnaRisposta != null) {
                        msgDiag.addKeyword("@ERRORE_CONSEGNA@", erroreConsegnaRisposta.toString());
                        msgDiag.logPersonalizzato("consegnaRispostaApplicativaFallita");
                    } else if (httpEmptyResponse) {
                        msgDiag.logPersonalizzato("consegnaRispostaApplicativaVuota");
                    } else if (statoServletResponse == 500) {
                        msgDiag.logPersonalizzato("consegnaRispostaApplicativaKoEffettuata");
                    } else {
                        msgDiag.logPersonalizzato("consegnaRispostaApplicativaOkEffettuata");
                    }
                }
                catch (Exception e) {
                    logCore.error((Object)"Chiusura stream non riuscita", (Throwable)e);
                    msgDiag.addKeyword("@ERRORE_CONSEGNA@", e.toString());
                    msgDiag.logPersonalizzato("consegnaRispostaApplicativaFallita");
                    erroreConsegnaRisposta = e;
                }
            }
        }
        String location = "...";
        try {
            IConnettore c = null;
            if (context.getIdMessage() != null) {
                c = RepositoryConnettori.removeConnettorePD(context.getIdMessage());
            }
            if (c != null) {
                location = c.getLocation();
                c.disconnect();
            }
        }
        catch (Exception e) {
            msgDiag.logDisconnectError(e, location);
        }
        if (postOutResponseContext != null) {
            try {
                postOutResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
                if (erroreConsegnaRisposta == null) {
                    ((PostOutResponseContext)postOutResponseContext).setEsito(esito);
                } else {
                    ((PostOutResponseContext)postOutResponseContext).setEsito(Esito.ERRORE_PROCESSAMENTO_PDD_5XX);
                }
                ((PostOutResponseContext)postOutResponseContext).setReturnCode(statoServletResponse);
                ((OutResponseContext)postOutResponseContext).setPropertiesRispostaTrasporto(context.getHeaderIntegrazioneRisposta());
                ((OutResponseContext)postOutResponseContext).setProtocollo(context.getProtocol());
                ((OutResponseContext)postOutResponseContext).setIntegrazione(context.getIntegrazione());
                if (context.getTipoPorta() != null) {
                    postOutResponseContext.setTipoPorta(context.getTipoPorta());
                }
                if (inputBody != null) {
                    ((PostOutResponseContext)postOutResponseContext).setInputRequestMessageSize(new Long(inputBody.length));
                }
                if (requestMessage != null) {
                    ((PostOutResponseContext)postOutResponseContext).setOutputRequestMessageSize(requestMessage.getOutgoingMessageContentLength());
                } else {
                    ((PostOutResponseContext)postOutResponseContext).setInputRequestMessageSize((long)req.getContentLength() + 0L);
                }
                if (erroreConsegnaRisposta == null && responseMessage != null) {
                    ((PostOutResponseContext)postOutResponseContext).setInputResponseMessageSize(responseMessage.getIncomingMessageContentLength());
                    ((PostOutResponseContext)postOutResponseContext).setOutputResponseMessageSize(lengthOutResponse);
                    postOutResponseContext.setMessaggio(responseMessage);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "postOutResponse, preparazione contesto");
            }
            GestoreHandlers.postOutResponse((PostOutResponseContext)postOutResponseContext, msgDiag, logCore);
        }
        try {
            if (requestMessage != null && requestMessage.getNotifierInputStream() != null) {
                requestMessage.getNotifierInputStream().close();
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "Rilascio risorse NotifierInputStream richiesta");
        }
        try {
            if (responseMessage != null && responseMessage.getNotifierInputStream() != null) {
                responseMessage.getNotifierInputStream().close();
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "Rilascio risorse NotifierInputStream risposta");
        }
        requestMessage = null;
        body = null;
        responseMessage = null;
    }
}

