/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.xml.soap.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.TipoFiltroAbilitazioneServizi;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziAzioneNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziCorrelatoNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziPortTypeNotFound;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.PDIdentificazioneDinamica;
import org.openspcoop2.pdd.config.PDIdentificazioneDinamicaException;
import org.openspcoop2.pdd.config.RichiestaApplicativa;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.GestoreCorrelazioneApplicativa;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.GestoreMessaggiException;
import org.openspcoop2.pdd.core.IdentificazionePortaDelegata;
import org.openspcoop2.pdd.core.IntegrationContext;
import org.openspcoop2.pdd.core.LocalForwardEngine;
import org.openspcoop2.pdd.core.LocalForwardParameter;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.ProtocolContext;
import org.openspcoop2.pdd.core.StatoServiziPdD;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativi;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativiException;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.autenticazione.GestoreCredenzialiConfigurationException;
import org.openspcoop2.pdd.core.autenticazione.IAutenticazione;
import org.openspcoop2.pdd.core.autenticazione.IGestoreCredenziali;
import org.openspcoop2.pdd.core.autorizzazione.IAutorizzazione;
import org.openspcoop2.pdd.core.autorizzazione.IAutorizzazioneContenuto;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InRequestContext;
import org.openspcoop2.pdd.core.handlers.InRequestProtocolContext;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePD;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePDSoap;
import org.openspcoop2.pdd.core.integrazione.InRequestPDMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePDMessage;
import org.openspcoop2.pdd.core.node.INodeReceiver;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.node.NodeTimeoutException;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.ImbustamentoMessage;
import org.openspcoop2.pdd.mdb.InoltroBuste;
import org.openspcoop2.pdd.mdb.SbustamentoRisposte;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativiContext;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativiGestioneRisposta;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativiMessage;
import org.openspcoop2.pdd.services.ServletUtils;
import org.openspcoop2.pdd.services.connector.ConnectorInMessage;
import org.openspcoop2.pdd.services.skeleton.IntegrationManager;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop2.pdd.timers.TimerThreshold;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.ErroreApplicativoBuilder;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.validator.ValidazioneSintattica;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.StatoFunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.Loader;

public class RicezioneContenutiApplicativi {
    public static final String ID_MODULO = "RicezioneContenutiApplicativi";
    public static boolean initializeService = false;
    public static Boolean isActivePDService = true;
    public static List<TipoFiltroAbilitazioneServizi> listaAbilitazioniPDService = null;
    public static List<TipoFiltroAbilitazioneServizi> listaDisabilitazioniPDService = null;
    private static String[] defaultGestoriIntegrazionePD = null;
    private static Hashtable<String, String[]> defaultPerProtocolloGestoreIntegrazionePD = null;
    private static String[] tipiGestoriCredenziali = null;
    private RicezioneContenutiApplicativiContext msgContext;
    boolean responseAsByte = false;
    private OpenSPCoop2MessageFactory fac = OpenSPCoop2MessageFactory.getMessageFactory();

    protected static synchronized void initializeService(ConfigurazionePdDManager configReader, ClassNameProperties className, OpenSPCoop2Properties propertiesReader, Logger logCore) throws Exception {
        if (initializeService) {
            return;
        }
        Loader loader = Loader.getInstance();
        isActivePDService = configReader.isPDServiceActive();
        listaAbilitazioniPDService = configReader.getFiltriAbilitazionePDService();
        listaDisabilitazioniPDService = configReader.getFiltriDisabilitazionePDService();
        String classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
        try {
            INodeSender nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
            nodeSender.toString();
            logCore.info((Object)("Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
        String classType = className.getNodeReceiver(propertiesReader.getNodeReceiver());
        try {
            INodeReceiver nodeReceiver = (INodeReceiver)loader.newInstance(classType);
            nodeReceiver.toString();
            logCore.info((Object)("Inizializzazione gestore NodeReceiver di tipo " + classType + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
        }
        defaultGestoriIntegrazionePD = propertiesReader.getTipoIntegrazionePD();
        for (int i = 0; i < defaultGestoriIntegrazionePD.length; ++i) {
            classType = className.getIntegrazionePortaDelegata(defaultGestoriIntegrazionePD[i]);
            try {
                IGestoreIntegrazionePD gestore = (IGestoreIntegrazionePD)loader.newInstance(classType);
                gestore.toString();
                logCore.info((Object)("Inizializzazione gestore integrazione servizioApplicativo->PdD di tipo " + defaultGestoriIntegrazionePD[i] + " effettuata."));
                continue;
            }
            catch (Exception e) {
                throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + defaultGestoriIntegrazionePD[i] + "]: " + e.getMessage());
            }
        }
        defaultPerProtocolloGestoreIntegrazionePD = new Hashtable();
        Enumeration enumProtocols = ProtocolFactoryManager.getInstance().getProtocolNames();
        while (enumProtocols.hasMoreElements()) {
            String protocol = (String)enumProtocols.nextElement();
            String[] tipiIntegrazionePD = propertiesReader.getTipoIntegrazionePD(protocol);
            if (tipiIntegrazionePD == null || tipiIntegrazionePD.length <= 0) continue;
            Vector<String> tipiIntegrazionePerProtocollo = new Vector<String>();
            for (int i = 0; i < tipiIntegrazionePD.length; ++i) {
                classType = className.getIntegrazionePortaDelegata(tipiIntegrazionePD[i]);
                try {
                    IGestoreIntegrazionePD test = (IGestoreIntegrazionePD)loader.newInstance(classType);
                    test.toString();
                    tipiIntegrazionePerProtocollo.add(tipiIntegrazionePD[i]);
                    logCore.info((Object)("Inizializzazione gestore per lettura integrazione PD di tipo " + tipiIntegrazionePD[i] + " effettuata."));
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + tipiIntegrazionePD[i] + "]: " + e.getMessage());
                }
            }
            if (tipiIntegrazionePerProtocollo.size() <= 0) continue;
            defaultPerProtocolloGestoreIntegrazionePD.put(protocol, tipiIntegrazionePerProtocollo.toArray(new String[1]));
        }
        tipiGestoriCredenziali = propertiesReader.getTipoGestoreCredenzialiPD();
        if (tipiGestoriCredenziali != null) {
            for (int i = 0; i < tipiGestoriCredenziali.length; ++i) {
                classType = className.getGestoreCredenziali(tipiGestoriCredenziali[i]);
                try {
                    IGestoreCredenziali gestore = (IGestoreCredenziali)loader.newInstance(classType);
                    gestore.toString();
                    logCore.info((Object)("Inizializzazione gestore credenziali di tipo " + tipiGestoriCredenziali[i] + " effettuata."));
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione delle credenziali di tipo [" + tipiGestoriCredenziali[i] + "]: " + e.getMessage());
                }
            }
        }
        initializeService = true;
    }

    public RicezioneContenutiApplicativi(RicezioneContenutiApplicativiContext context) {
        this.msgContext = context;
    }

    public void process(Object ... params) {
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        MsgDiagnostico msgDiag = this.msgContext.getMsgDiagnostico();
        OpenSPCoop2Message requestMessage = this.msgContext.getMessageRequest();
        if (requestMessage == null) {
            try {
                requestMessage = this.msgContext.getMessageRequestFromByte();
                this.responseAsByte = true;
            }
            catch (Exception e) {
                this.setSOAPFault(logCore, msgDiag, e, "LetturaMessaggioRichiesta");
                return;
            }
        }
        IProtocolFactory protocolFactory = null;
        try {
            protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject("PROTOCOLLO"));
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "ProtocolFactoryInstance");
            return;
        }
        InRequestContext inRequestContext = new InRequestContext(logCore, protocolFactory);
        inRequestContext.setTipoPorta(TipoPdD.DELEGATA);
        InfoConnettoreIngresso connettore = new InfoConnettoreIngresso();
        connettore.setCredenziali(this.msgContext.getCredenziali());
        if (this.msgContext.getUrlProtocolContext() != null) {
            connettore.setUrlProtocolContext(this.msgContext.getUrlProtocolContext());
        }
        connettore.setSoapAction(this.msgContext.getSoapAction());
        connettore.setFromLocation(this.msgContext.getFromLocation());
        inRequestContext.setConnettore(connettore);
        inRequestContext.setDataElaborazioneMessaggio(this.msgContext.getDataIngressoRichiesta());
        inRequestContext.setPddContext(this.msgContext.getPddContext());
        inRequestContext.setMessaggio(requestMessage);
        try {
            GestoreHandlers.inRequest(inRequestContext, msgDiag, logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFault(logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "InvocazioneInRequestHandler");
            return;
        }
        try {
            this.process_engine(inRequestContext, params);
        }
        catch (TracciamentoException e) {
            this.setSOAPFault(logCore, msgDiag, (Exception)((Object)e), "TracciamentoNonRiuscito");
            return;
        }
        catch (ProtocolException e) {
            this.setSOAPFault(logCore, msgDiag, (Exception)((Object)e), "InstanziazioneProtocolFactoryNonRiuscita");
            return;
        }
        OutResponseContext outResponseContext = new OutResponseContext(logCore, protocolFactory);
        outResponseContext.setTipoPorta(this.msgContext.getTipoPorta());
        outResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
        outResponseContext.setPddContext(inRequestContext.getPddContext());
        outResponseContext.setProtocollo(this.msgContext.getProtocol());
        outResponseContext.setIntegrazione(this.msgContext.getIntegrazione());
        outResponseContext.setPropertiesRispostaTrasporto(this.msgContext.getHeaderIntegrazioneRisposta());
        OpenSPCoop2Message msgResponse = this.msgContext.getMessageResponse();
        outResponseContext.setMessaggio(msgResponse);
        try {
            GestoreHandlers.outResponse(outResponseContext, msgDiag, logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFault(logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "InvocazioneOutResponseHandler");
            return;
        }
        OpenSPCoop2Message msgRisposta = null;
        try {
            msgRisposta = outResponseContext.getMessaggio();
            boolean rispostaPresente = true;
            OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
            if (properties != null) {
                rispostaPresente = ServletUtils.verificaRispostaRelazioneCodiceTrasporto202(protocolFactory, OpenSPCoop2Properties.getInstance(), msgRisposta, true);
            }
            if (rispostaPresente) {
                if (this.responseAsByte) {
                    this.msgContext.setMessageResponseAsByte(msgRisposta);
                } else {
                    this.msgContext.setMessageResponse(msgRisposta);
                }
            } else {
                this.msgContext.setMessageResponse(null);
                msgRisposta = null;
            }
        }
        catch (Exception e) {
            this.setSOAPFault(logCore, msgDiag, e, "FineGestioneRicezioneContenutiApplicativi");
            return;
        }
        if (Dump.sistemaDumpDisponibile) {
            try {
                ConfigurazionePdDManager configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                if (configurazionePdDReader.dumpMessaggi() && msgRisposta != null) {
                    ProtocolContext protocolContext = this.msgContext.getProtocol();
                    Dump dumpApplicativo = null;
                    dumpApplicativo = protocolContext != null ? new Dump(protocolContext.getDominio(), this.msgContext.getIdModulo(), protocolContext.getIdRichiesta(), protocolContext.getFruitore(), new IDServizio(protocolContext.getErogatore(), protocolContext.getTipoServizio(), protocolContext.getServizio(), protocolContext.getAzione()), this.msgContext.getTipoPorta(), this.msgContext.getPddContext(), null, null) : new Dump(null, this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), this.msgContext.getPddContext(), null, null);
                    dumpApplicativo.dumpRispostaUscita(msgRisposta, inRequestContext.getConnettore(), outResponseContext.getPropertiesRispostaTrasporto());
                }
            }
            catch (TracciamentoException e) {
                this.setSOAPFault(logCore, msgDiag, (Exception)((Object)e), "TracciamentoNonRiuscito");
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void setSOAPFault(Logger logCore, MsgDiagnostico msgDiag, Exception e, String posizione) {
        if (msgDiag != null) {
            msgDiag.logErroreGenerico(e, posizione);
        } else {
            logCore.error((Object)(posizione + ": " + e.getMessage()), (Throwable)e);
        }
        if (this.msgContext.isGestioneRisposta()) {
            String posizioneFault = posizione + ": " + e.getMessage();
            OpenSPCoop2Message messageFault = this.fac.createFaultMessage(this.msgContext.getMessageRequest().getVersioneSoap(), posizioneFault);
            if (this.responseAsByte) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    messageFault.writeTo((OutputStream)out, false);
                }
                catch (Exception eWriteTo) {
                    msgDiag.logErroreGenerico(e, "GenerazioneFaultAsBytes");
                }
                this.msgContext.setMessageRequestAsByte(out.toByteArray());
            } else {
                this.msgContext.setMessageResponse(messageFault);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void process_engine(InRequestContext inRequestContext, Object ... params) throws TracciamentoException, ProtocolException {
        block388: {
            block387: {
                block386: {
                    block383: {
                        block382: {
                            requestMessage = inRequestContext.getMessaggio();
                            versioneSoap = requestMessage.getVersioneSoap();
                            logCore = inRequestContext.getLogCore();
                            dataIngressoMessaggio = new Timestamp(this.msgContext.getDataIngressoRichiesta().getTime());
                            idTransazione = PdDContext.getValue("ID", inRequestContext.getPddContext());
                            urlProtocolContext = this.msgContext.getUrlProtocolContext();
                            credenziali = this.msgContext.getCredenziali();
                            className = ClassNameProperties.getInstance();
                            propertiesReader = OpenSPCoop2Properties.getInstance();
                            if (propertiesReader == null) {
                                logCore.error((Object)"Inizializzazione di OpenSPCoop non correttamente effettuata: OpenSPCoopProperties");
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(this.fac.createFaultMessage(versioneSoap, "ErroreInizializzazioneOpenSPCoop"));
                                }
                                return;
                            }
                            configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                            registroServiziReader = RegistroServiziManager.getInstance();
                            protocol = (String)this.msgContext.getPddContext().getObject("PROTOCOLLO");
                            identitaPdD = propertiesReader.getIdentitaPortaDefault(protocol);
                            protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
                            pddContext = inRequestContext.getPddContext();
                            traduttore = protocolFactory.createTraduttore();
                            protocolManager = protocolFactory.createProtocolManager();
                            proprietaErroreAppl = propertiesReader.getProprietaGestioneErrorePD(protocolManager);
                            proprietaErroreAppl.setDominio(identitaPdD.getCodicePorta());
                            proprietaErroreAppl.setIdModulo(this.msgContext.getIdModulo());
                            if (this.msgContext.isForceFaultAsXML()) {
                                proprietaErroreAppl.setFaultAsXML(true);
                            }
                            this.msgContext.setProprietaErroreAppl(proprietaErroreAppl);
                            erroreApplicativoBuilder = new ErroreApplicativoBuilder(logCore, protocolFactory, identitaPdD, null, null, this.msgContext.getIdModulo(), proprietaErroreAppl, versioneSoap, this.msgContext.getTipoPorta(), null);
                            imbustamentoMSG = new ImbustamentoMessage();
                            this.msgContext.setProtocol(new ProtocolContext());
                            this.msgContext.getProtocol().setDominio(this.msgContext.getIdentitaPdD());
                            this.msgContext.setIntegrazione(new IntegrationContext());
                            if (!OpenSPCoop2Startup.initialize) {
                                logCore.error((Object)"[RicezioneContenutiApplicativi]  Inizializzazione di OpenSPCoop non correttamente effettuata");
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), null));
                                }
                                return;
                            }
                            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                                logCore.error((Object)("[RicezioneContenutiApplicativi]  Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_532_RISORSE_NON_DISPONIBILI), null));
                                }
                                return;
                            }
                            if (!TimerThreshold.freeSpace) {
                                logCore.error((Object)"[RicezioneContenutiApplicativi]  Non sono disponibili abbastanza risorse per la gestione della richiesta");
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_533_RISORSE_DISPONIBILI_LIVELLO_CRITICO), null));
                                }
                                return;
                            }
                            if (!Tracciamento.tracciamentoDisponibile) {
                                logCore.error((Object)("[RicezioneContenutiApplicativi]  Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage()), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_545_TRACCIATURA_NON_FUNZIONANTE), null));
                                }
                                return;
                            }
                            if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                                logCore.error((Object)("[RicezioneContenutiApplicativi]  Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_546_DIAGNOSTICA_NON_FUNZIONANTE), null));
                                }
                                return;
                            }
                            if (!Dump.sistemaDumpDisponibile) {
                                logCore.error((Object)("[RicezioneContenutiApplicativi]  Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage()), (Throwable)Dump.motivoMalfunzionamentoDump);
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_547_DUMP_CONTENUTI_APPLICATIVI_NON_FUNZIONANTE), null));
                                }
                                return;
                            }
                            try {
                                configurazionePdDReader.verificaConsistenzaConfigurazione();
                            }
                            catch (Exception e) {
                                logCore.error((Object)"[RicezioneContenutiApplicativi]  Riscontrato errore durante la verifica della consistenza della configurazione PdD", (Throwable)e);
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), null));
                                }
                                return;
                            }
                            try {
                                registroServiziReader.verificaConsistenzaRegistroServizi();
                            }
                            catch (Exception e) {
                                logCore.error((Object)"[RicezioneContenutiApplicativi]  Riscontrato errore durante la verifica del registro dei servizi", (Throwable)e);
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_534_REGISTRO_DEI_SERVIZI_NON_DISPONIBILE), null));
                                }
                                return;
                            }
                            msgDiag = new MsgDiagnostico(identitaPdD, this.msgContext.getIdModulo(), new IState[0]);
                            this.msgContext.setMsgDiagnostico(msgDiag);
                            msgDiag.setPddContext(inRequestContext.getPddContext(), protocolFactory);
                            msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
                            msgDiag.setDelegata(true);
                            msgDiag.setPorta(urlProtocolContext.getFunctionParameters() + "_urlInvocazione(" + urlProtocolContext.getUrlInvocazione_formBased() + ")");
                            this.setCredenziali(credenziali, msgDiag);
                            try {
                                if (!RicezioneContenutiApplicativi.initializeService) {
                                    msgDiag.mediumDebug("Inizializzazione risorse statiche...");
                                    RicezioneContenutiApplicativi.initializeService(configurazionePdDReader, className, propertiesReader, logCore);
                                }
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "InizializzazioneRisorseServizioRicezioneContenutiApplicativi");
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_501_PDD_NON_INIZIALIZZATA), e));
                                }
                                return;
                            }
                            loader = Loader.getInstance();
                            connectorInMessage = null;
                            if (params != null) {
                                for (i = 0; i < params.length; ++i) {
                                    if (params[i] == null || !(params[i] instanceof ConnectorInMessage)) continue;
                                    connectorInMessage = (ConnectorInMessage)params[i];
                                    break;
                                }
                            }
                            openspcoopstate = null;
                            msgDiag.mediumDebug("Inizializzazione connessione al database...");
                            try {
                                openspcoopstate = new OpenSPCoopStateful();
                                openspcoopstate.initResource(identitaPdD, this.msgContext.getIdModulo(), idTransazione);
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "openspcoopstate.initResource()");
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), e));
                                }
                                return;
                            }
                            registroServiziReader.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
                            configurazionePdDReader.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
                            msgDiag.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
                            if (configurazionePdDReader.dumpMessaggi()) {
                                dumpApplicativo = new Dump(identitaPdD, this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), inRequestContext.getPddContext(), openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
                                dumpApplicativo.dumpRichiestaIngresso(requestMessage, inRequestContext.getConnettore());
                            }
                            Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Identificazione porta delegata e soggetto fruitore...");
                            msgDiag.mediumDebug("Identificazione porta delegata e soggetto fruitore...");
                            identificazione = new IdentificazionePortaDelegata(urlProtocolContext, protocolFactory);
                            if (!identificazione.process(openspcoopstate.getStatoRichiesta())) {
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", identificazione.getErroreIntegrazione().getDescrizione(protocolFactory));
                                msgDiag.logPersonalizzato("portaDelegataNonEsistente");
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(identificazione.getErroreIntegrazione(), null));
                                }
                                return;
                            }
                            soggettoFruitore = identificazione.getSoggetto();
                            pd = identificazione.getPd();
                            requestMessage.addContextProperty("API_PORTA", (Object)pd.getNome());
                            identitaPdD = soggettoFruitore;
                            this.msgContext.getProtocol().setDominio(identitaPdD);
                            this.msgContext.setIdentitaPdD(identitaPdD);
                            idPD = new IDPortaDelegata();
                            idPD.setLocationPD(identificazione.getNomePDIndivituata());
                            idPD.setSoggettoFruitore(soggettoFruitore);
                            msgDiag.setDominio(identitaPdD);
                            msgDiag.setFruitore(soggettoFruitore);
                            msgDiag.addKeyword("@PORTA_DELEGATA@", identificazione.getNomePDIndivituata());
                            msgDiag.addKeywords(soggettoFruitore);
                            proprietaErroreAppl.setDominio(identitaPdD.getCodicePorta());
                            erroreApplicativoBuilder.setDominio(identitaPdD);
                            erroreApplicativoBuilder.setMittente(soggettoFruitore);
                            erroreApplicativoBuilder.setProprietaErroreApplicato(proprietaErroreAppl);
                            this.msgContext.setProprietaErroreAppl(proprietaErroreAppl);
                            Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Lettura header di integrazione...");
                            msgDiag.mediumDebug("Lettura header di integrazione...");
                            headerIntegrazioneRichiesta = null;
                            headerIntegrazioneRichiesta = this.msgContext.getHeaderIntegrazioneRichiesta() != null ? this.msgContext.getHeaderIntegrazioneRichiesta() : new HeaderIntegrazione();
                            headerIntegrazioneRisposta = null;
                            tipiIntegrazionePD = null;
                            try {
                                tipiIntegrazionePD = configurazionePdDReader.getTipiIntegrazione(pd);
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "getTipiIntegrazione(pd)");
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e));
                                }
                                return;
                            }
                            if (tipiIntegrazionePD == null) {
                                tipiIntegrazionePD = RicezioneContenutiApplicativi.defaultPerProtocolloGestoreIntegrazionePD.containsKey(protocolFactory.getProtocol()) != false ? RicezioneContenutiApplicativi.defaultPerProtocolloGestoreIntegrazionePD.get(protocolFactory.getProtocol()) : RicezioneContenutiApplicativi.defaultGestoriIntegrazionePD;
                            }
                            inRequestPDMessage = new InRequestPDMessage();
                            inRequestPDMessage.setBustaRichiesta(null);
                            inRequestPDMessage.setMessage(requestMessage);
                            inRequestPDMessage.setUrlProtocolContext(this.msgContext.getUrlProtocolContext());
                            inRequestPDMessage.setPortaDelegata(pd);
                            inRequestPDMessage.setSoggettoPropeprietarioPortaDelegata(soggettoFruitore);
                            for (i = 0; i < tipiIntegrazionePD.length; ++i) {
                                try {
                                    classType = null;
                                    gestore = null;
                                    try {
                                        classType = className.getIntegrazionePortaDelegata(tipiIntegrazionePD[i]);
                                        gestore = (IGestoreIntegrazionePD)loader.newInstance(classType);
                                        AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                                    }
                                    catch (Exception e) {
                                        throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + tipiIntegrazionePD[i] + "]: " + e.getMessage());
                                    }
                                    if (gestore != null) {
                                        gestore.readInRequestHeader(headerIntegrazioneRichiesta, inRequestPDMessage);
                                        continue;
                                    }
                                    msgDiag.logErroreGenerico("Lettura Gestore header di integrazione [" + tipiIntegrazionePD[i] + "]  non riuscita: non inizializzato", "gestoriIntegrazionePD.get(" + tipiIntegrazionePD[i] + ")");
                                    continue;
                                }
                                catch (Exception e) {
                                    logCore.debug((Object)("Errore durante la lettura dell'header di integrazione [" + tipiIntegrazionePD[i] + "]: " + e.getMessage()), (Throwable)e);
                                    msgDiag.addKeyword("@TIPO_HEADER_INTEGRAZIONE@", tipiIntegrazionePD[i]);
                                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.toString());
                                    msgDiag.logPersonalizzato("headerIntegrazione.letturaFallita");
                                }
                            }
                            Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Autenticazione del servizio applicativo...");
                            if (RicezioneContenutiApplicativi.tipiGestoriCredenziali != null) {
                                msgDiag.mediumDebug("Gestione personalizzata delle credenziali...");
                                for (i = 0; i < RicezioneContenutiApplicativi.tipiGestoriCredenziali.length; ++i) {
                                    try {
                                        gestore = null;
                                        classType = null;
                                        try {
                                            classType = className.getGestoreCredenziali(RicezioneContenutiApplicativi.tipiGestoriCredenziali[i]);
                                            gestore = (IGestoreCredenziali)loader.newInstance(classType);
                                            AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                                        }
                                        catch (Exception e) {
                                            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione delle credenziali di tipo [" + RicezioneContenutiApplicativi.tipiGestoriCredenziali[i] + "]: " + e.getMessage());
                                        }
                                        if (gestore != null) {
                                            credenzialiRitornate = gestore.elaborazioneCredenziali(inRequestContext.getConnettore(), requestMessage);
                                            if (credenzialiRitornate == null) {
                                                throw new Exception("Credenziali non ritornate");
                                            }
                                            if (!inRequestContext.getConnettore().getCredenziali().equals(credenzialiRitornate)) {
                                                nuoveCredenziali = credenzialiRitornate.toString();
                                                nuoveCredenziali = nuoveCredenziali.substring(0, nuoveCredenziali.length() - 1);
                                                msgDiag.addKeyword("@NUOVE_CREDENZIALI@", nuoveCredenziali);
                                                identita = gestore.getIdentitaGestoreCredenziali();
                                                if (identita == null) {
                                                    identita = "Gestore delle credenziali di tipo " + RicezioneContenutiApplicativi.tipiGestoriCredenziali[i];
                                                }
                                                msgDiag.addKeyword("@IDENTITA_GESTORE_CREDENZIALI@", identita);
                                                msgDiag.logPersonalizzato("gestoreCredenziali.nuoveCredenziali");
                                                inRequestContext.getConnettore().setCredenziali(credenzialiRitornate);
                                                credenziali = credenzialiRitornate;
                                                this.setCredenziali(credenziali, msgDiag);
                                            }
                                            continue;
                                        }
                                        throw new Exception("non inizializzato");
                                    }
                                    catch (Exception e) {
                                        logCore.error((Object)("Errore durante l'identificazione delle credenziali [" + RicezioneContenutiApplicativi.tipiGestoriCredenziali[i] + "]: " + e.getMessage()), (Throwable)e);
                                        msgDiag.addKeyword("@TIPO_GESTORE_CREDENZIALI@", RicezioneContenutiApplicativi.tipiGestoriCredenziali[i]);
                                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                                        msgDiag.logPersonalizzato("gestoreCredenziali.errore");
                                        errore = null;
                                        errore = e instanceof GestoreCredenzialiConfigurationException != false ? ErroriIntegrazione.ERRORE_431_GESTORE_CREDENZIALI_ERROR.getErrore431_ErroreGestoreCredenziali(RicezioneContenutiApplicativi.tipiGestoriCredenziali[i], e) : ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_548_GESTORE_CREDENZIALI_NON_FUNZIONANTE);
                                        openspcoopstate.releaseResource();
                                        if (this.msgContext.isGestioneRisposta()) {
                                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(errore, e));
                                        }
                                        return;
                                    }
                                }
                            }
                            msgDiag.mediumDebug("Autenticazione del servizio applicativo...");
                            tipoAutenticazione = identificazione.getTipoAutenticazione();
                            this.msgContext.getIntegrazione().setTipoAutenticazione(tipoAutenticazione);
                            servizioApplicativo = "Anonimo";
                            if (CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.toString().equalsIgnoreCase(tipoAutenticazione)) {
                                if (headerIntegrazioneRichiesta.getServizioApplicativo() != null) {
                                    servizioApplicativo = headerIntegrazioneRichiesta.getServizioApplicativo();
                                    existsServizioApplicativo = false;
                                    try {
                                        existsServizioApplicativo = configurazionePdDReader.existsServizioApplicativo(idPD, servizioApplicativo);
                                    }
                                    catch (Exception e) {
                                        msgDiag.logErroreGenerico(e, "existsServizioApplicativo(idPD," + servizioApplicativo + ")");
                                        openspcoopstate.releaseResource();
                                        if (this.msgContext.isGestioneRisposta()) {
                                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e));
                                        }
                                        return;
                                    }
                                    if (!existsServizioApplicativo) {
                                        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativo);
                                        msgDiag.logPersonalizzato("servizioApplicativoFruitore.identificazioneTramiteInfoIntegrazioneNonRiuscita");
                                        openspcoopstate.releaseResource();
                                        if (this.msgContext.isGestioneRisposta()) {
                                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_402_AUTENTICAZIONE_FALLITA.getErrore402_AutenticazioneFallita("L'identit\u00e0 del servizio applicativo fornita [" + servizioApplicativo + "] non esiste nella configurazione della Porta di Dominio"), null));
                                        }
                                        return;
                                    }
                                }
                            } else {
                                authClass = className.getAutenticazione(tipoAutenticazione);
                                auth = null;
                                try {
                                    auth = (IAutenticazione)loader.newInstance(authClass);
                                    AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
                                }
                                catch (Exception e) {
                                    msgDiag.logErroreGenerico(e, "Autenticazione(" + tipoAutenticazione + ") Class.forName(" + authClass + ")");
                                    openspcoopstate.releaseResource();
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_503_AUTENTICAZIONE), e));
                                    }
                                    return;
                                }
                                if (!auth.process(inRequestContext.getConnettore(), idPD, openspcoopstate.getStatoRichiesta())) {
                                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", auth.getErrore().getDescrizione(protocolFactory));
                                    if (credenziali.getUsername() != null && credenziali.getUsername() != null && credenziali.getPassword() != null && !"".equals(credenziali.getPassword())) {
                                        credenzialiFornite = "(";
                                        credenzialiFornite = credenzialiFornite + " Basic Username: [" + credenziali.getUsername() + "]  Basic Password: [" + credenziali.getPassword() + "]";
                                        credenzialiFornite = credenzialiFornite + ") ";
                                        msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
                                    }
                                    msgDiag.logPersonalizzato("servizioApplicativoFruitore.identificazioneTramiteCredenziali");
                                    openspcoopstate.releaseResource();
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(auth.getErrore(), auth.getException()));
                                    }
                                    return;
                                }
                                servizioApplicativo = auth.getServizioApplicativo();
                            }
                            msgDiag.setPorta(idPD.getLocationPD());
                            msgDiag.setServizioApplicativo(servizioApplicativo);
                            msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativo);
                            if (!"Anonimo".equals(servizioApplicativo)) {
                                this.msgContext.getIntegrazione().setServizioApplicativoFruitore(servizioApplicativo);
                            }
                            erroreApplicativoBuilder.setServizioApplicativo(servizioApplicativo);
                            msgDiag.mediumDebug("Get servizio applicativo...");
                            sa = null;
                            try {
                                sa = configurazionePdDReader.getServizioApplicativo(idPD, servizioApplicativo);
                            }
                            catch (Exception e) {
                                if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(servizioApplicativo)) break block382;
                                msgDiag.logErroreGenerico(e, "getServizioApplicativo(idPD," + servizioApplicativo + ")");
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e));
                                }
                                return;
                            }
                        }
                        msgDiag.mediumDebug("Aggiornamento gestione errore del servizio applicativo...");
                        try {
                            configurazionePdDReader.aggiornaProprietaGestioneErrorePD(proprietaErroreAppl, sa);
                            if (this.msgContext.isForceFaultAsXML()) {
                                proprietaErroreAppl.setFaultAsXML(true);
                            }
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "aggiornaProprietaGestioneErrorePD(proprietaErroreAppl," + servizioApplicativo + ")");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e));
                            }
                            return;
                        }
                        this.msgContext.setProprietaErroreAppl(proprietaErroreAppl);
                        Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Lettura servizio associato alla PD invocata...");
                        msgDiag.mediumDebug("Lettura servizio associato alla PD invocata...");
                        idModuloInAttesa = null;
                        if (this.msgContext.isGestioneRisposta()) {
                            idModuloInAttesa = this.msgContext.getIdModulo();
                        }
                        richiestaDelegata = new RichiestaDelegata(soggettoFruitore, idPD.getLocationPD(), servizioApplicativo, idModuloInAttesa, proprietaErroreAppl, identitaPdD);
                        try {
                            if (configurazionePdDReader.identificazioneContentBased(pd)) {
                                soapEnvelopeRequest = requestMessage.getSOAPPart().getEnvelope();
                                richiestaDelegata.setIdServizio(configurazionePdDReader.getIDServizio(pd, urlProtocolContext, requestMessage, soapEnvelopeRequest, headerIntegrazioneRichiesta, this.msgContext.getIdModulo().endsWith(IntegrationManager.ID_MODULO), this.msgContext.getSoapAction(), protocolFactory));
                            } else {
                                richiestaDelegata.setIdServizio(configurazionePdDReader.getIDServizio(pd, urlProtocolContext, requestMessage, null, headerIntegrazioneRichiesta, this.msgContext.getIdModulo().endsWith(IntegrationManager.ID_MODULO), this.msgContext.getSoapAction(), protocolFactory));
                            }
                            if (richiestaDelegata.getIdServizio() == null) {
                                throw new PDIdentificazioneDinamicaException(PDIdentificazioneDinamica.SERVIZIO, "Identificazione Servizio non riuscita");
                            }
                            if (richiestaDelegata.getIdServizio().getSoggettoErogatore() == null || richiestaDelegata.getIdServizio().getSoggettoErogatore().getNome() == null || richiestaDelegata.getIdServizio().getSoggettoErogatore().getTipo() == null) {
                                throw new PDIdentificazioneDinamicaException(PDIdentificazioneDinamica.SOGGETTO_EROGATORE, "Identificazione SoggettoErogatore non riuscita");
                            }
                            if (richiestaDelegata.getIdServizio().getTipoServizio() == null || richiestaDelegata.getIdServizio().getServizio() == null) {
                                throw new PDIdentificazioneDinamicaException(PDIdentificazioneDinamica.SERVIZIO, "Identificazione Servizio (tipo/nome) non riuscita");
                            }
                            headerIntegrazioneRisposta = new HeaderIntegrazione();
                            headerIntegrazioneRisposta.getBusta().setTipoMittente(soggettoFruitore.getTipo());
                            headerIntegrazioneRisposta.getBusta().setMittente(soggettoFruitore.getNome());
                            headerIntegrazioneRisposta.getBusta().setTipoDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getTipo());
                            headerIntegrazioneRisposta.getBusta().setDestinatario(richiestaDelegata.getIdServizio().getSoggettoErogatore().getNome());
                            headerIntegrazioneRisposta.getBusta().setTipoServizio(richiestaDelegata.getIdServizio().getTipoServizio());
                            headerIntegrazioneRisposta.getBusta().setServizio(richiestaDelegata.getIdServizio().getServizio());
                            headerIntegrazioneRisposta.getBusta().setAzione(richiestaDelegata.getIdServizio().getAzione());
                            if (headerIntegrazioneRichiesta.getBusta() != null && headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                                headerIntegrazioneRisposta.getBusta().setRiferimentoMessaggio(headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio());
                            }
                        }
                        catch (PDIdentificazioneDinamicaException e) {
                            if (e.getPosizione() != null) {
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "[" + e.getPosizione().name() + "] " + e.getMessage());
                            } else {
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                            }
                            msgDiag.logPersonalizzato("identificazioneDinamicaServizioNonRiuscita");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_403_PD_PATTERN_NON_VALIDO.getErrore403_IdentificazioneDinamicaPortaDelgata(e.getPosizione().name()), (Exception)e));
                            }
                            return;
                        }
                        catch (Exception e) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                            msgDiag.logPersonalizzato("identificazioneDinamicaServizioNonRiuscita");
                            logCore.error((Object)msgDiag.getMessaggio_replaceKeywords("identificazioneDinamicaServizioNonRiuscita"), (Throwable)e);
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e));
                            }
                            return;
                        }
                        msgDiag.setServizio(richiestaDelegata.getIdServizio());
                        msgDiag.addKeywords(richiestaDelegata.getIdServizio());
                        erroreApplicativoBuilder.setServizio(richiestaDelegata.getIdServizio());
                        msgDiag.mediumDebug("Verifica canale utilizzato...");
                        tipiSoggettiSupportatiCanale = protocolFactory.createProtocolConfiguration().getTipiSoggetti();
                        tipiServiziSupportatiCanale = protocolFactory.createProtocolConfiguration().getTipiServizi();
                        if (!tipiSoggettiSupportatiCanale.contains(soggettoFruitore.getTipo())) {
                            msgDiag.logPersonalizzato("protocolli.tipoSoggetto.fruitore.unsupported");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_436_TIPO_SOGGETTO_FRUITORE_NOT_SUPPORTED_BY_PROTOCOL.getErrore436_TipoSoggettoFruitoreNotSupportedByProtocol(soggettoFruitore, protocolFactory), null));
                            }
                            return;
                        }
                        if (!tipiSoggettiSupportatiCanale.contains(richiestaDelegata.getIdServizio().getSoggettoErogatore().getTipo())) {
                            msgDiag.logPersonalizzato("protocolli.tipoSoggetto.erogatore.unsupported");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_437_TIPO_SOGGETTO_EROGATORE_NOT_SUPPORTED_BY_PROTOCOL.getErrore437_TipoSoggettoErogatoreNotSupportedByProtocol(richiestaDelegata.getIdServizio().getSoggettoErogatore(), protocolFactory), null));
                            }
                            return;
                        }
                        if (!tipiServiziSupportatiCanale.contains(richiestaDelegata.getIdServizio().getTipoServizio())) {
                            msgDiag.logPersonalizzato("protocolli.tipoServizio.unsupported");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_438_TIPO_SERVIZIO_NOT_SUPPORTED_BY_PROTOCOL.getErrore438_TipoServizioNotSupportedByProtocol(richiestaDelegata.getIdServizio(), protocolFactory), null));
                            }
                            return;
                        }
                        if (!StatoServiziPdD.isEnabled(RicezioneContenutiApplicativi.isActivePDService, RicezioneContenutiApplicativi.listaAbilitazioniPDService, RicezioneContenutiApplicativi.listaDisabilitazioniPDService, soggettoFruitore, richiestaDelegata.getIdServizio())) {
                            logCore.error((Object)"[RicezioneContenutiApplicativi]  Servizio di ricezione contenuti applicativi disabilitato");
                            msgDiag.logErroreGenerico("Servizio di ricezione contenuti applicativi disabilitato", "PD");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_550_PD_SERVICE_NOT_ACTIVE), null));
                            }
                            return;
                        }
                        Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Inizializzazione connessione al database...");
                        idMessageRequest = null;
                        msgDiag.mediumDebug("Gestione correlazione applicativa...");
                        correlazionePD = null;
                        try {
                            correlazionePD = configurazionePdDReader.getCorrelazioneApplicativa(pd);
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "getCorrelazioneApplicativa(pd)");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e));
                            }
                            return;
                        }
                        correlazioneApplicativa = new GestoreCorrelazioneApplicativa(openspcoopstate.getStatoRichiesta(), logCore, richiestaDelegata.getSoggettoFruitore(), richiestaDelegata.getIdServizio(), servizioApplicativo, protocolFactory);
                        correlazioneEsistente = false;
                        idCorrelazioneApplicativa = null;
                        if (correlazionePD != null) {
                            try {
                                soapEnvelopeRequest = requestMessage.getSOAPPart().getEnvelope();
                                correlazioneEsistente = correlazioneApplicativa.verificaCorrelazione(correlazionePD, urlProtocolContext, soapEnvelopeRequest, headerIntegrazioneRichiesta, this.msgContext.getIdModulo().endsWith(IntegrationManager.ID_MODULO));
                                idCorrelazioneApplicativa = correlazioneApplicativa.getIdCorrelazione();
                                if (correlazioneEsistente) {
                                    idMessageRequest = correlazioneApplicativa.getIdBustaCorrelato();
                                    msgDiag.setIdMessaggioRichiesta(idMessageRequest);
                                    msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", idCorrelazioneApplicativa);
                                    msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idMessageRequest);
                                    msgDiag.logPersonalizzato("correlazioneApplicativaEsistente");
                                }
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "CorrelazioneApplicativa");
                                logCore.error((Object)("Riscontrato errore durante il controllo di correlazione applicativa: " + e.getMessage()), (Throwable)e);
                                errore = null;
                                if (correlazioneApplicativa != null) {
                                    errore = correlazioneApplicativa.getErrore();
                                }
                                if (errore == null) {
                                    errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_529_CORRELAZIONE_APPLICATIVA_RICHIESTA_NON_RIUSCITA);
                                }
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(errore, e));
                                }
                                return;
                            }
                        }
                        if (!correlazioneEsistente) {
                            msgDiag.mediumDebug("Costruzione identificativo...");
                            try {
                                imbustatore = new Imbustamento(protocolFactory);
                                idMessageRequest = imbustatore.buildID(openspcoopstate.getStatoRichiesta(), identitaPdD, (String)this.msgContext.getPddContext().getObject("ID"), propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), Boolean.TRUE);
                                if (idMessageRequest == null) {
                                    throw new Exception("Identificativo non costruito.");
                                }
                                msgDiag.setIdMessaggioRichiesta(idMessageRequest);
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "imbustatore.buildID(idMessageRequest)");
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_507_COSTRUZIONE_IDENTIFICATIVO), e));
                                }
                                return;
                            }
                            msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idMessageRequest);
                            if (correlazionePD != null && idCorrelazioneApplicativa != null && correlazioneApplicativa.isRiusoIdentificativo()) {
                                msgDiag.mediumDebug("Applicazione correlazione applicativa...");
                                try {
                                    correlazioneApplicativa.applicaCorrelazione(correlazionePD, idCorrelazioneApplicativa, idMessageRequest);
                                    msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", idCorrelazioneApplicativa);
                                    msgDiag.logPersonalizzato("correlazioneApplicativaInstaurata");
                                }
                                catch (Exception e) {
                                    msgDiag.logErroreGenerico(e, "CreazioneCorrelazioneApplicativa");
                                    errore = null;
                                    if (correlazioneApplicativa != null) {
                                        errore = correlazioneApplicativa.getErrore();
                                    }
                                    if (errore == null) {
                                        errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_529_CORRELAZIONE_APPLICATIVA_RICHIESTA_NON_RIUSCITA);
                                    }
                                    openspcoopstate.releaseResource();
                                    if (this.msgContext.isGestioneRisposta()) {
                                        this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(errore, null));
                                    }
                                    return;
                                }
                            }
                        }
                        richiestaDelegata.setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
                        msgDiag.setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
                        this.msgContext.getIntegrazione().setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
                        this.msgContext.setIdMessage(idMessageRequest);
                        this.msgContext.getProtocol().setIdRichiesta(idMessageRequest);
                        Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Gestione header integrazione della risposta...");
                        msgDiag.mediumDebug("Gestione header integrazione della risposta...");
                        headerIntegrazioneRisposta.getBusta().setID(idMessageRequest);
                        containsHeaderIntegrazioneTrasporto = false;
                        for (String gestore : RicezioneContenutiApplicativi.defaultGestoriIntegrazionePD) {
                            if (!"trasporto".equals(gestore)) continue;
                            containsHeaderIntegrazioneTrasporto = true;
                        }
                        if (containsHeaderIntegrazioneTrasporto || this.msgContext.getIdModulo().startsWith("RicezioneContenutiApplicativi" + IntegrationManager.ID_MODULO)) {
                            try {
                                propertiesIntegrazioneRisposta = new Properties();
                                classType = null;
                                gestore = null;
                                try {
                                    classType = className.getIntegrazionePortaDelegata("trasporto");
                                    gestore = (IGestoreIntegrazionePD)loader.newInstance(classType);
                                    AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                                }
                                catch (Exception e) {
                                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + "trasporto" + "]: " + e.getMessage());
                                }
                                if (gestore != null) {
                                    outResponsePDMessage = new OutResponsePDMessage();
                                    outResponsePDMessage.setPortaDelegata(pd);
                                    outResponsePDMessage.setProprietaTrasporto(propertiesIntegrazioneRisposta);
                                    outResponsePDMessage.setServizio(richiestaDelegata.getIdServizio());
                                    outResponsePDMessage.setSoggettoMittente(soggettoFruitore);
                                    gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePDMessage);
                                    this.msgContext.setHeaderIntegrazioneRisposta(propertiesIntegrazioneRisposta);
                                }
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "setHeaderIntegrazioneRisposta");
                            }
                        }
                        msgDiag.logCorrelazione();
                        msgDiag.logCorrelazioneServizioApplicativo();
                        bustaBuilder = protocolFactory.createBustaBuilder();
                        idServizio = richiestaDelegata.getIdServizio();
                        this.msgContext.getProtocol().setFruitore(soggettoFruitore);
                        this.msgContext.getProtocol().setErogatore(idServizio.getSoggettoErogatore());
                        this.msgContext.getProtocol().setTipoServizio(idServizio.getTipoServizio());
                        this.msgContext.getProtocol().setServizio(idServizio.getServizio());
                        this.msgContext.getProtocol().setVersioneServizio(idServizio.getVersioneServizioAsInt());
                        this.msgContext.getProtocol().setAzione(idServizio.getAzione());
                        this.msgContext.getProtocol().setIdRichiesta(idMessageRequest);
                        Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Autorizzazione del servizio applicativo...");
                        msgDiag.mediumDebug("Autorizzazione del servizio applicativo...");
                        tipoAutorizzazione = identificazione.getTipoAutorizzazione();
                        this.msgContext.getIntegrazione().setTipoAutorizzazione(tipoAutorizzazione);
                        if (!"none".equalsIgnoreCase(tipoAutorizzazione)) {
                            errore = null;
                            eAutorizzazione = null;
                            try {
                                classType = null;
                                auth = null;
                                try {
                                    classType = className.getAutorizzazione(tipoAutorizzazione);
                                    auth = (IAutorizzazione)loader.newInstance(classType);
                                    AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
                                }
                                catch (Exception e) {
                                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'autorizzazione di tipo [" + tipoAutorizzazione + "]: " + e.getMessage());
                                }
                                if (auth != null) {
                                    esito = auth.process(inRequestContext.getConnettore(), servizioApplicativo, idPD, richiestaDelegata.getIdServizio(), pd, openspcoopstate.getStatoRichiesta());
                                    if (!esito.isServizioAutorizzato()) {
                                        errore = esito.getErroreIntegrazione();
                                        eAutorizzazione = esito.getEccezioneProcessamento();
                                    }
                                } else {
                                    errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento("gestore [" + tipoAutorizzazione + "] non inizializzato", CodiceErroreIntegrazione.CODICE_504_AUTORIZZAZIONE);
                                }
                            }
                            catch (Exception e) {
                                errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento("processo di autorizzazione [" + tipoAutorizzazione + "] fallito, " + e.getMessage(), CodiceErroreIntegrazione.CODICE_504_AUTORIZZAZIONE);
                                eAutorizzazione = e;
                                logCore.error((Object)("processo di autorizzazione [" + tipoAutorizzazione + "] fallito, " + e.getMessage()), (Throwable)e);
                            }
                            if (errore != null) {
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", errore.getDescrizione(protocolFactory));
                                msgDiag.logPersonalizzato("servizioApplicativoFruitore.nonAutorizzato");
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(errore, eAutorizzazione));
                                }
                                return;
                            }
                        }
                        infoSearch = idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " erogato dal Soggetto " + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome();
                        if (idServizio.getAzione() != null) {
                            infoSearch = infoSearch + " azione " + idServizio.getAzione();
                        }
                        msgDiag.addKeyword("@INFO_SERVIZIO_BUSTA@", infoSearch);
                        msgDiag.mediumDebug("Ricerca nome registro [" + infoSearch + "]...");
                        nomeRegistroForSearch = null;
                        try {
                            nomeRegistroForSearch = configurazionePdDReader.getRegistroForImbustamento(soggettoFruitore, idServizio, false);
                        }
                        catch (Exception e) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "connettore associato al servizio non trovato, " + e.getMessage());
                            msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_514_ROUTING_CONFIGURATION_ERROR), e));
                            }
                            return;
                        }
                        riferimentoServizioCorrelato = null;
                        if (headerIntegrazioneRichiesta.getBusta() != null && headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                            riferimentoServizioCorrelato = headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio();
                        }
                        if (riferimentoServizioCorrelato == null && propertiesReader.isIntegrazioneAsincroniConIdCollaborazioneEnabled() && headerIntegrazioneRichiesta.getBusta() != null && headerIntegrazioneRichiesta.getBusta().getIdCollaborazione() != null) {
                            infoServizioTmpVerificaCorrelato = null;
                            try {
                                infoServizioTmpVerificaCorrelato = registroServiziReader.getInfoServizioCorrelato(soggettoFruitore, idServizio, nomeRegistroForSearch);
                            }
                            catch (Exception e) {
                                logCore.debug((Object)("Verifica servizio [" + infoSearch + "] se e' correlato, fallita: " + e.getMessage()));
                                try {
                                    infoServizioTmpVerificaCorrelato = registroServiziReader.getInfoServizioAzioneCorrelata(soggettoFruitore, idServizio, nomeRegistroForSearch);
                                }
                                catch (Exception eCorrelato) {
                                    logCore.debug((Object)("Verifica servizio [" + infoSearch + "] se e' correlato rispetto all'azione, fallita: " + e.getMessage()));
                                }
                            }
                            if (infoServizioTmpVerificaCorrelato != null) {
                                riferimentoServizioCorrelato = headerIntegrazioneRichiesta.getBusta().getIdCollaborazione();
                            }
                        }
                        infoSearch = riferimentoServizioCorrelato != null ? "Servizio correlato " + infoSearch : "Servizio " + infoSearch;
                        infoSearch = "Ricerca nel registro dei servizi di: " + infoSearch;
                        if (riferimentoServizioCorrelato != null) {
                            infoSearch = infoSearch + " (idServizioCorrelato: " + riferimentoServizioCorrelato + ")";
                        }
                        msgDiag.addKeyword("@INFO_SERVIZIO_BUSTA@", infoSearch);
                        msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioInCorso");
                        isServizioCorrelato = false;
                        invocazioneAzioneErrata = null;
                        portTypeErrato = null;
                        ricercaConErrore = false;
                        servizioCorrelatoNonTrovato = false;
                        servizioNonTrovato = false;
                        infoServizio = null;
                        eServiceNotFound = null;
                        try {
                            if (riferimentoServizioCorrelato != null) {
                                erroreRicerca = null;
                                msgDiag.mediumDebug("Ricerca servizio correlato ...");
                                try {
                                    infoServizio = registroServiziReader.getInfoServizioCorrelato(soggettoFruitore, idServizio, nomeRegistroForSearch);
                                    isServizioCorrelato = true;
                                }
                                catch (DriverRegistroServiziAzioneNotFound e) {
                                    invocazioneAzioneErrata = e.getMessage();
                                    throw e;
                                }
                                catch (DriverRegistroServiziNotFound e) {
                                    erroreRicerca = "\nRicerca come servizio correlato-> " + e.getMessage();
                                }
                                if (infoServizio == null && idServizio.getAzione() != null) {
                                    msgDiag.mediumDebug("Ricerca servizio con azione correlata...");
                                    try {
                                        infoServizio = registroServiziReader.getInfoServizioAzioneCorrelata(soggettoFruitore, idServizio, nomeRegistroForSearch);
                                        isServizioCorrelato = true;
                                    }
                                    catch (DriverRegistroServiziAzioneNotFound e) {
                                        invocazioneAzioneErrata = e.getMessage();
                                        throw e;
                                    }
                                    catch (DriverRegistroServiziNotFound e) {
                                        erroreRicerca = erroreRicerca + "\nRicerca come servizio correlato -> " + e.getMessage();
                                    }
                                }
                                if (infoServizio == null && erroreRicerca == null) {
                                    throw new DriverRegistroServiziNotFound("Servizio Correlato non trovato ne tramite la normale ricerca, ne tramite la ricerca per azione correlata (solo se profilo e' asincrono asimmetrico)");
                                }
                                if (infoServizio == null) {
                                    throw new DriverRegistroServiziNotFound(erroreRicerca);
                                }
                                break block383;
                            }
                            erroreRicerca = null;
                            msgDiag.mediumDebug("Ricerca servizio ...");
                            try {
                                infoServizio = registroServiziReader.getInfoServizio(soggettoFruitore, idServizio, nomeRegistroForSearch, true);
                            }
                            catch (DriverRegistroServiziAzioneNotFound e) {
                                invocazioneAzioneErrata = e.getMessage();
                                throw e;
                            }
                            catch (DriverRegistroServiziNotFound e) {
                                erroreRicerca = "\nRicerca come servizio -> " + e.getMessage();
                            }
                            if (infoServizio == null) {
                                msgDiag.mediumDebug("Ricerca servizio correlato...");
                                try {
                                    infoServizio = registroServiziReader.getInfoServizioCorrelato(soggettoFruitore, idServizio, nomeRegistroForSearch);
                                    isServizioCorrelato = true;
                                }
                                catch (DriverRegistroServiziAzioneNotFound e) {
                                    invocazioneAzioneErrata = e.getMessage();
                                    throw e;
                                }
                                catch (DriverRegistroServiziNotFound e) {
                                    erroreRicerca = erroreRicerca + "\nRicerca come servizio correlato -> " + e.getMessage();
                                }
                            }
                            if (infoServizio == null && erroreRicerca == null) {
                                throw new DriverRegistroServiziNotFound("Servizio non trovato ne tramite la normale ricerca, ne tramite la ricerca per servizio correlato");
                            }
                            if (infoServizio == null) {
                                throw new DriverRegistroServiziNotFound(erroreRicerca);
                            }
                        }
                        catch (DriverRegistroServiziNotFound e) {
                            eServiceNotFound = e;
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                            msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                            servizioNonTrovato = true;
                        }
                        catch (DriverRegistroServiziAzioneNotFound e) {
                            eServiceNotFound = e;
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                            msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                        }
                        catch (DriverRegistroServiziPortTypeNotFound e) {
                            eServiceNotFound = e;
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "configurazione registro dei servizi errata, " + e.getMessage());
                            msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                            portTypeErrato = "Configurazione del registro dei Servizi errata: " + e.getMessage();
                        }
                        catch (DriverRegistroServiziCorrelatoNotFound e) {
                            eServiceNotFound = e;
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "correlazione asincrona non rilevata, " + e.getMessage());
                            msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                            servizioCorrelatoNonTrovato = true;
                        }
                        catch (Exception e) {
                            eServiceNotFound = e;
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "errore generale, " + e.getMessage());
                            msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                            logCore.error((Object)"Ricerca servizio fallita", (Throwable)e);
                            ricercaConErrore = true;
                        }
                    }
                    if (infoServizio == null) {
                        if (!(servizioNonTrovato || ricercaConErrore || servizioCorrelatoNonTrovato || invocazioneAzioneErrata != null)) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "servizio non esistente");
                            msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                            servizioNonTrovato = true;
                        }
                        erroreIntegrazione = null;
                        erroreIntegrazione = invocazioneAzioneErrata != null ? ErroriIntegrazione.ERRORE_423_SERVIZIO_CON_AZIONE_SCORRETTA.getErrore423_ServizioConAzioneScorretta("(azione:" + idServizio.getAzione() + ") " + invocazioneAzioneErrata) : (portTypeErrato != null ? ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(portTypeErrato, CodiceErroreIntegrazione.CODICE_540_REGISTRO_SERVIZI_MAL_CONFIGURATO) : (servizioNonTrovato != false ? ErroriIntegrazione.ERRORE_405_SERVIZIO_NON_TROVATO.getErroreIntegrazione() : (ricercaConErrore != false ? ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_534_REGISTRO_DEI_SERVIZI_NON_DISPONIBILE) : (servizioCorrelatoNonTrovato != false ? ErroriIntegrazione.ERRORE_408_SERVIZIO_CORRELATO_NON_TROVATO.getErroreIntegrazione() : ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_533_RISORSE_DISPONIBILI_LIVELLO_CRITICO)))));
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(erroreIntegrazione, (Exception)eServiceNotFound));
                        }
                        return;
                    }
                    infoServizio.setCorrelato(isServizioCorrelato);
                    this.msgContext.getProtocol().setProfiloCollaborazione(infoServizio.getProfiloDiCollaborazione(), null);
                    msgDiag.addKeyword("@PROFILO_COLLABORAZIONE@", traduttore.toString(infoServizio.getProfiloDiCollaborazione()));
                    if (infoServizio != null) {
                        this.msgContext.getProtocol().setIdAccordo(infoServizio.getIdAccordo());
                        richiestaDelegata.setIdAccordo(infoServizio.getIdAccordo());
                        try {
                            idServizio.setUriAccordo(IDAccordoFactory.getInstance().getUriFromIDAccordo(infoServizio.getIdAccordo()));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    bustaRichiesta = infoServizio.convertToBusta(protocol, soggettoFruitore);
                    inRequestPDMessage.setBustaRichiesta(bustaRichiesta);
                    try {
                        profiloGestione = registroServiziReader.getProfiloGestioneFruizioneServizio(idServizio, nomeRegistroForSearch);
                        richiestaDelegata.setProfiloGestione(profiloGestione);
                        msgDiag.mediumDebug("Profilo di gestione [RicezioneContenutiApplicativi] della busta: " + profiloGestione);
                    }
                    catch (Exception e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "analisi del profilo di gestione fallita, " + e.getMessage());
                        msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                        logCore.error((Object)"Comprensione Profilo Gestione fallita", (Throwable)e);
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e));
                        }
                        return;
                    }
                    try {
                        msgDiag.mediumDebug("Aggiornamento del messaggio");
                        requestMessage = protocolFactory.createProtocolManager().updateOpenSPCoop2MessageRequest(requestMessage.getVersioneSoap(), requestMessage, bustaRichiesta);
                    }
                    catch (Exception e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "Aggiornamento messaggio fallito, " + e.getMessage());
                        msgDiag.logErroreGenerico(e, "ProtocolManager.updateOpenSPCoop2Message");
                        logCore.error((Object)("ProtocolManager.updateOpenSPCoop2Message error: " + e.getMessage()), (Throwable)e);
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e));
                        }
                        return;
                    }
                    indirizzoFruitore = null;
                    indirizzoErogatore = null;
                    protocolConfiguration = protocolFactory.createProtocolConfiguration();
                    if (protocolConfiguration.isSupportoIndirizzoRisposta()) {
                        try {
                            connettoreFruitore = null;
                            try {
                                connettoreFruitore = registroServiziReader.getConnettore(soggettoFruitore, nomeRegistroForSearch);
                            }
                            catch (DriverRegistroServiziNotFound dNotFound) {
                                // empty catch block
                            }
                            if (connettoreFruitore != null && !CostantiConfigurazione.DISABILITATO.equals(connettoreFruitore.getTipo()) && connettoreFruitore.getProperties() != null && connettoreFruitore.getProperties().containsKey("location")) {
                                indirizzoFruitore = (String)connettoreFruitore.getProperties().get("location");
                            }
                            msgDiag.mediumDebug("Indirizzo Risposta del soggetto fruitore [" + soggettoFruitore + "]: " + indirizzoFruitore);
                            connettoreErogatore = null;
                            try {
                                connettoreErogatore = registroServiziReader.getConnettore(idServizio.getSoggettoErogatore(), nomeRegistroForSearch);
                            }
                            catch (DriverRegistroServiziNotFound dNotFound) {
                                // empty catch block
                            }
                            if (connettoreErogatore != null && !CostantiConfigurazione.DISABILITATO.equals(connettoreErogatore.getTipo()) && connettoreErogatore.getProperties() != null && connettoreErogatore.getProperties().containsKey("location")) {
                                indirizzoErogatore = (String)connettoreErogatore.getProperties().get("location");
                            }
                            msgDiag.mediumDebug("Indirizzo Risposta del soggetto erogatore [" + idServizio.getSoggettoErogatore() + "]: " + indirizzoErogatore);
                        }
                        catch (Exception e) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "recupero degli indirizzi di risposta per i soggetti fallita, " + e.getMessage());
                            msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioFallita");
                            logCore.error((Object)"Comprensione Indirizzo Risposta fallita", (Throwable)e);
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e));
                            }
                            return;
                        }
                        this.msgContext.getProtocol().setIndirizzoFruitore(indirizzoFruitore);
                        this.msgContext.getProtocol().setIndirizzoErogatore(indirizzoErogatore);
                    }
                    msgDiag.logPersonalizzato("imbustamentoBusta.", "registroServizi.ricercaServizioEffettuata");
                    try {
                        inRequestProtocolContext = new InRequestProtocolContext(inRequestContext);
                        if (inRequestProtocolContext.getConnettore() != null) {
                            inRequestProtocolContext.getConnettore().setCredenziali(credenziali);
                        }
                        inRequestProtocolContext.setProtocollo(this.msgContext.getProtocol());
                        inRequestProtocolContext.setIntegrazione(this.msgContext.getIntegrazione());
                        GestoreHandlers.inRequestProtocol(inRequestProtocolContext, msgDiag, logCore);
                    }
                    catch (Exception e) {
                        if (e instanceof HandlerException) {
                            he = (HandlerException)e;
                            msgDiag.logErroreGenerico(e, he.getIdentitaHandler());
                            logCore.error((Object)("Gestione InRequestProtocolHandler non riuscita (" + he.getIdentitaHandler() + "): " + he));
                        } else {
                            msgDiag.logErroreGenerico(e, "InvocazioneInRequestHandler");
                            logCore.error((Object)("Gestione InRequestProtocolHandler non riuscita: " + e));
                        }
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e));
                        }
                        return;
                    }
                    implementazionePdDMittente = null;
                    implementazionePdDDestinatario = null;
                    idPdDMittente = null;
                    idPdDDestinatario = null;
                    msgDiag.mediumDebug("Ricerca implementazione della porta di dominio dei soggetti...");
                    try {
                        implementazionePdDMittente = registroServiziReader.getImplementazionePdD(soggettoFruitore, null);
                        implementazionePdDDestinatario = registroServiziReader.getImplementazionePdD(idServizio.getSoggettoErogatore(), null);
                        idPdDMittente = registroServiziReader.getIdPortaDominio(soggettoFruitore, null);
                        idPdDDestinatario = registroServiziReader.getIdPortaDominio(idServizio.getSoggettoErogatore(), null);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "ricercaImplementazioniPdD");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_534_REGISTRO_DEI_SERVIZI_NON_DISPONIBILE), e));
                        }
                        return;
                    }
                    msgDiag.mediumDebug("ImplementazionePdD soggetto (" + soggettoFruitore.toString() + ") e' [" + implementazionePdDMittente + "], soggetto (" + idServizio.getSoggettoErogatore().toString() + ") e' [" + implementazionePdDDestinatario + "]");
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Controllo validazione xsd abilitata/disabilitata...");
                    msgDiag.mediumDebug("Controllo validazione xsd abilitata/disabilitata...");
                    validazioneContenutoApplicativoApplicativo = null;
                    try {
                        validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pd, implementazionePdDDestinatario);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "getTipoValidazioneContenutoApplicativo(pd," + implementazionePdDDestinatario + ")");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e));
                        }
                        return;
                    }
                    if (CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.equals(validazioneContenutoApplicativoApplicativo.getStato()) || CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                        binXSD = null;
                        try {
                            msgDiag.mediumDebug("Validatore contenuti applicativi della richiesta...");
                            xomReferences = null;
                            if (StatoFunzionalita.ABILITATO.equals(validazioneContenutoApplicativoApplicativo.getAcceptMtomMessage())) {
                                xomReferences = requestMessage.mtomFastUnpackagingForXSDConformance();
                            }
                            readWSDL = CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL.equals(validazioneContenutoApplicativoApplicativo.getTipo());
                            validatoreMessaggiApplicativi = new ValidatoreMessaggiApplicativi(registroServiziReader, richiestaDelegata.getIdServizio(), requestMessage.getVersioneSoap(), requestMessage.getSOAPPart().getEnvelope(), readWSDL);
                            if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL.equals(validazioneContenutoApplicativoApplicativo.getTipo()) || CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP.equals(validazioneContenutoApplicativoApplicativo.getTipo())) {
                                msgDiag.mediumDebug("Validazione wsdl della richiesta ...");
                                validatoreMessaggiApplicativi.validateWithWsdlLogicoImplementativo(true, this.msgContext.getSoapAction());
                            }
                            msgDiag.mediumDebug("Validazione xsd della richiesta (validazione)...");
                            validatoreMessaggiApplicativi.validateWithWsdlDefinitorio(true);
                            if (xomReferences != null && xomReferences.size() > 0) {
                                requestMessage.mtomRestoreAfterXSDConformance(xomReferences);
                            }
                        }
                        catch (ValidatoreMessaggiApplicativiException ex) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", ex.getMessage());
                            msgDiag.logPersonalizzato("validazioneContenutiApplicativiNonRiuscita");
                            if (!CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ex.getErrore(), (Exception)ex));
                                }
                                return;
                            }
                        }
                        catch (Exception ex) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", ex.getMessage());
                            msgDiag.logPersonalizzato("validazioneContenutiApplicativiNonRiuscita");
                            logCore.error((Object)"Riscontrato errore durante la validazione xsd della richiesta applicativa", (Throwable)ex);
                            if (!CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_WSDL_FALLITA), ex));
                                }
                                return;
                            }
                        }
                        finally {
                            if (binXSD != null) {
                                try {
                                    binXSD.close();
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Autorizzazione del servizio applicativo...");
                    msgDiag.mediumDebug("Autorizzazione del servizio applicativo...");
                    tipoAutorizzazioneContenuto = identificazione.getTipoAutorizzazioneContenuto();
                    if (!"none".equalsIgnoreCase(tipoAutorizzazioneContenuto)) {
                        errore = null;
                        eAutorizzazione = null;
                        try {
                            classType = null;
                            auth = null;
                            try {
                                classType = className.getAutorizzazioneContenuto(tipoAutorizzazioneContenuto);
                                auth = (IAutorizzazioneContenuto)loader.newInstance(classType);
                                AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
                            }
                            catch (Exception e) {
                                throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'autorizzazione contenuto di tipo [" + tipoAutorizzazioneContenuto + "]: " + e.getMessage());
                            }
                            if (auth != null) {
                                esito = auth.process(inRequestContext.getConnettore(), servizioApplicativo, idPD, richiestaDelegata.getIdServizio(), pd, requestMessage);
                                if (!esito.isServizioAutorizzato()) {
                                    errore = esito.getErroreIntegrazione();
                                    eAutorizzazione = esito.getEccezioneProcessamento();
                                }
                            } else {
                                errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento("gestore [" + tipoAutorizzazioneContenuto + "] non inizializzato", CodiceErroreIntegrazione.CODICE_542_AUTORIZZAZIONE_CONTENUTO);
                            }
                        }
                        catch (Exception e) {
                            msgErroreAutorizzazione = "processo di autorizzazione [" + tipoAutorizzazioneContenuto + "] fallito, " + e.getMessage();
                            errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(msgErroreAutorizzazione, CodiceErroreIntegrazione.CODICE_542_AUTORIZZAZIONE_CONTENUTO);
                            eAutorizzazione = e;
                            logCore.error((Object)msgErroreAutorizzazione, (Throwable)e);
                        }
                        if (errore != null) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", errore.getDescrizione(protocolFactory));
                            msgDiag.logPersonalizzato("servizioApplicativoFruitore.contenuto.nonAutorizzato");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(errore, eAutorizzazione));
                            }
                            return;
                        }
                    }
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Controllo tipo di invocazione (riferimento/normale)...");
                    msgDiag.mediumDebug("Controllo tipo di invocazione (riferimento/normale)...");
                    invocazionePDPerRiferimento = false;
                    try {
                        invocazionePDPerRiferimento = configurazionePdDReader.invocazionePortaDelegataPerRiferimento(sa);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "invocazionePortaDelegataPerRiferimento(sa)");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e));
                        }
                        return;
                    }
                    if (invocazionePDPerRiferimento) {
                        if (!this.msgContext.isInvocazionePDPerRiferimento()) {
                            msgDiag.logPersonalizzato("portaDelegataInvocabilePerRiferimento.riferimentoNonPresente");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_412_PD_INVOCABILE_SOLO_PER_RIFERIMENTO.getErroreIntegrazione(), null));
                            }
                            return;
                        }
                        gestoreMessaggio = new GestoreMessaggi(openspcoopstate, true, this.msgContext.getIdInvocazionePDPerRiferimento(), "INBOX", msgDiag, this.msgContext.getPddContext());
                        try {
                            sbustamento_informazioni_protocollo = gestoreMessaggio.sbustamentoInformazioniProtocollo(servizioApplicativo, false);
                            if (!sbustamento_informazioni_protocollo) ** GOTO lbl945
                            proprietaManifest = propertiesReader.getProprietaManifestAttachments("standard");
                            proprietaManifest.setGestioneManifest(false);
                            bustaBuilder.sbustamento(openspcoopstate.getStatoRichiesta(), requestMessage, bustaRichiesta, true, proprietaManifest);
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "invocazionePortaDelegataPerRiferimento.sbustamentoProtocolHeader()");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e));
                            }
                            return;
                        }
                    } else if (this.msgContext.isInvocazionePDPerRiferimento()) {
                        msgDiag.logPersonalizzato("portaDelegataInvocabileNormalmente.riferimentoPresente");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_413_PD_INVOCABILE_SOLO_SENZA_RIFERIMENTO.getErroreIntegrazione(), null));
                        }
                        return;
                    }
lbl945:
                    // 4 sources

                    msgDiag.logPersonalizzato("ricevutaRichiestaApplicativa");
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Controllo non esistenza di una busta ...");
                    msgDiag.mediumDebug("Controllo non esistenza di una busta ...");
                    validatoreSintattico = new ValidazioneSintattica(openspcoopstate.getStatoRichiesta(), requestMessage, protocolFactory);
                    esisteProtocolloMsgRichiesta = false;
                    try {
                        esisteProtocolloMsgRichiesta = validatoreSintattico.verifyProtocolPresence(this.msgContext.getTipoPorta(), infoServizio.getProfiloDiCollaborazione(), true);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "controlloEsistenzaBusta");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e));
                        }
                        return;
                    }
                    finally {
                        if (esisteProtocolloMsgRichiesta) {
                            msgDiag.logPersonalizzato("richiestaContenenteBusta");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_420_BUSTA_PRESENTE_RICHIESTA_APPLICATIVA.getErroreIntegrazione(), null));
                            }
                            return;
                        }
                        if (validatoreSintattico != null) {
                            validatoreSintattico.setHeaderSOAP(null);
                        }
                        validatoreSintattico = null;
                    }
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Update/Delete Header di integrazione se necessario");
                    for (i = 0; i < tipiIntegrazionePD.length; ++i) {
                        try {
                            classType = null;
                            gestore = null;
                            try {
                                classType = className.getIntegrazionePortaDelegata(tipiIntegrazionePD[i]);
                                gestore = (IGestoreIntegrazionePD)loader.newInstance(classType);
                                AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                            }
                            catch (Exception e) {
                                throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione (Update/Delete) di tipo [" + tipiIntegrazionePD[i] + "]: " + e.getMessage());
                            }
                            if (gestore == null || !(gestore instanceof IGestoreIntegrazionePDSoap)) continue;
                            if (propertiesReader.deleteHeaderIntegrazioneRequestPD()) {
                                ((IGestoreIntegrazionePDSoap)gestore).deleteInRequestHeader(inRequestPDMessage);
                                continue;
                            }
                            servizioApplicativoDaInserireHeader = null;
                            if (!"Anonimo".equals(servizioApplicativo)) {
                                servizioApplicativoDaInserireHeader = servizioApplicativo;
                            }
                            ((IGestoreIntegrazionePDSoap)gestore).updateInRequestHeader(inRequestPDMessage, idServizio, idMessageRequest, servizioApplicativoDaInserireHeader, idCorrelazioneApplicativa);
                            continue;
                        }
                        catch (Exception e) {
                            if (propertiesReader.deleteHeaderIntegrazioneRequestPD()) {
                                msgDiag.logErroreGenerico(e, "deleteHeaderIntegrazione(" + tipiIntegrazionePD[i] + ")");
                            } else {
                                msgDiag.logErroreGenerico(e, "updateHeaderIntegrazione(" + tipiIntegrazionePD[i] + ")");
                            }
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_541_GESTIONE_HEADER_INTEGRAZIONE), e));
                            }
                            return;
                        }
                    }
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Gestione Funzionalita' speciali per Attachments (Manifest)");
                    allegaBody = false;
                    scartaBody = false;
                    try {
                        allegaBody = configurazionePdDReader.isAllegaBody(pd);
                        scartaBody = configurazionePdDReader.isScartaBody(pd);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "configurazionePdDReader.isAllega/ScartaBody(pd)");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e));
                        }
                        return;
                    }
                    if (scartaBody) {
                        try {
                            if (requestMessage.countAttachments() <= 0) {
                                throw new Exception("La funzionalita' e' permessa solo per messaggi SOAP With Attachments");
                            }
                        }
                        catch (Exception e) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                            msgDiag.logPersonalizzato("funzionalitaScartaBodyNonEffettuabile");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_425_SCARTA_BODY.getErrore425_ScartaBody(e.getMessage()), e));
                            }
                            return;
                        }
                    }
                    if (allegaBody) {
                        try {
                            if (requestMessage.countAttachments() > 0) {
                                throw new Exception("La funzionalita' non e' permessa per messaggi SOAP With Attachments");
                            }
                            body = SoapUtils.sbustamentoSOAPEnvelope((SOAPEnvelope)requestMessage.getSOAPPart().getEnvelope());
                            ap = requestMessage.createAttachmentPart();
                            ap.setRawContentBytes(body, 0, body.length, "text/xml");
                            ap.setContentId(requestMessage.createContentID(propertiesReader.getHeaderSoapActorIntegrazione()));
                            requestMessage.addAttachmentPart(ap);
                            requestMessage.getSOAPPart().addMimeHeader("Content-Id", requestMessage.createContentID(propertiesReader.getHeaderSoapActorIntegrazione()));
                            requestMessage.getSOAPBody().removeContents();
                        }
                        catch (Exception e) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                            msgDiag.logPersonalizzato("funzionalitaAllegaBodyNonEffettuabile");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_424_ALLEGA_BODY.getErrore424_AllegaBody(e.getMessage()), e));
                            }
                            return;
                        }
                    }
                    oneWayStateless = false;
                    oneWayVersione11 = false;
                    sincronoStateless = false;
                    asincronoStateless = false;
                    portaStateless = false;
                    try {
                        if (!propertiesReader.isServerJ2EE()) {
                            oneWayStateless = true;
                            sincronoStateless = true;
                            asincronoStateless = true;
                        } else if (ProfiloDiCollaborazione.ONEWAY.equals(infoServizio.getProfiloDiCollaborazione())) {
                            oneWayStateless = configurazionePdDReader.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione());
                        } else if (ProfiloDiCollaborazione.SINCRONO.equals(infoServizio.getProfiloDiCollaborazione())) {
                            sincronoStateless = configurazionePdDReader.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione());
                        } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(infoServizio.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(infoServizio.getProfiloDiCollaborazione())) {
                            asincronoStateless = configurazionePdDReader.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione());
                        }
                        v0 = oneWayVersione11 = propertiesReader.isGestioneOnewayStateful_1_1() != false && ProfiloDiCollaborazione.ONEWAY.equals(infoServizio.getProfiloDiCollaborazione()) != false && oneWayStateless == false;
                        if (oneWayStateless || sincronoStateless || asincronoStateless || oneWayVersione11) {
                            openspcoopstate = OpenSPCoopState.toStateless((OpenSPCoopStateful)openspcoopstate, true);
                            portaStateless = true;
                            if (!oneWayVersione11) {
                                this.msgContext.getIntegrazione().setGestioneStateless(true);
                            } else {
                                this.msgContext.getIntegrazione().setGestioneStateless(false);
                            }
                        } else {
                            this.msgContext.getIntegrazione().setGestioneStateless(false);
                        }
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "GestioneStatelessStateful");
                        logCore.error((Object)("Analisi modalita di gestione STATEFUL/STATELESS non riuscita: " + e));
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e));
                        }
                        return;
                    }
                    localForward = false;
                    localForwardEngine = null;
                    localForwardParameter = null;
                    pa = null;
                    try {
                        localForward = configurazionePdDReader.isLocalForwardMode(pd);
                        if (localForward) {
                            erroreConfigurazione = null;
                            prefix = "( Servizio v" + idServizio.getVersioneServizio() + " " + idServizio.getTipoServizio() + "/" + idServizio.getServizio();
                            if (idServizio.getAzione() != null) {
                                prefix = prefix + " Azione " + idServizio.getAzione();
                            }
                            prefix = prefix + " Erogatore " + idServizio.getSoggettoErogatore().toString() + " ) ";
                            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(infoServizio.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(infoServizio.getProfiloDiCollaborazione())) {
                                erroreConfigurazione = "profilo di collaborazione " + infoServizio.getProfiloDiCollaborazione().getEngineValue() + " non supportato";
                            }
                            if (erroreConfigurazione == null && ProfiloDiCollaborazione.SINCRONO.equals(infoServizio.getProfiloDiCollaborazione()) && !sincronoStateless) {
                                erroreConfigurazione = "profilo di collaborazione " + infoServizio.getProfiloDiCollaborazione().getEngineValue() + " non supportato nella modalit\u00e0 stateful";
                            }
                            if (erroreConfigurazione == null && !configurazionePdDReader.existsSoggetto(idServizio.getSoggettoErogatore())) {
                                erroreConfigurazione = "il soggetto erogatore non risulta essere gestito localmente dalla Porta";
                            }
                            ra = null;
                            if (erroreConfigurazione == null && !configurazionePdDReader.existsPA(ra = new RichiestaApplicativa(soggettoFruitore, idServizio, identitaPdD, idPaByNome = configurazionePdDReader.convertTo_SafeMethod(idServizio, null)))) {
                                erroreConfigurazione = "non risulta esistere una porta applicativa associata al servizio richiesto";
                            }
                            if (erroreConfigurazione == null && (pa = configurazionePdDReader.getPortaApplicativa_SafeMethod(ra.getIdPAbyNome())).sizeServizioApplicativoList() <= 0) {
                                erroreConfigurazione = "non risultano registrati servizi applicativi erogatori associati alla porta applicativa (" + pa.getNome() + ") relativa al servizio richiesto";
                            }
                            if (erroreConfigurazione != null) {
                                erroreConfigurazione = prefix + erroreConfigurazione;
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", erroreConfigurazione);
                                msgDiag.logPersonalizzato("localForward.configError");
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_435_LOCAL_FORWARD_CONFIG_NON_VALIDA.getErrore435_LocalForwardConfigNonValida(erroreConfigurazione), null));
                                }
                                return;
                            }
                            localForwardParameter = new LocalForwardParameter();
                            localForwardParameter.setLog(logCore);
                            localForwardParameter.setConfigurazionePdDReader(configurazionePdDReader);
                            localForwardParameter.setIdCorrelazioneApplicativa(idCorrelazioneApplicativa);
                            localForwardParameter.setIdentitaPdD(identitaPdD);
                            localForwardParameter.setIdModulo(this.msgContext.getIdModulo());
                            localForwardParameter.setIdRequest(idMessageRequest);
                            localForwardParameter.setImplementazionePdDDestinatario(implementazionePdDDestinatario);
                            localForwardParameter.setImplementazionePdDMittente(implementazionePdDMittente);
                            localForwardParameter.setIdPdDMittente(idPdDMittente);
                            localForwardParameter.setIdPdDDestinatario(idPdDDestinatario);
                            localForwardParameter.setInfoServizio(infoServizio);
                            localForwardParameter.setMsgDiag(msgDiag);
                            localForwardParameter.setOpenspcoopstate(openspcoopstate);
                            localForwardParameter.setPddContext(inRequestContext.getPddContext());
                            localForwardParameter.setProtocolFactory(protocolFactory);
                            localForwardParameter.setRichiestaDelegata(richiestaDelegata);
                            localForwardParameter.setStateless(portaStateless);
                            localForwardParameter.setOneWayVersione11(oneWayVersione11);
                            localForwardEngine = new LocalForwardEngine(localForwardParameter);
                        }
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "GestioneLocalForward");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_554_LOCAL_FORWARD_ERROR), e));
                        }
                        return;
                    }
                    if (localForward) {
                        try {
                            if (!localForwardEngine.processRequest(requestMessage)) {
                                openspcoopstate.releaseResource();
                                if (this.msgContext.isGestioneRisposta()) {
                                    this.msgContext.setMessageResponse(localForwardEngine.getResponseMessageError());
                                }
                                return;
                            }
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "GestioneLocalForward.processRequest");
                            openspcoopstate.releaseResource();
                            if (this.msgContext.isGestioneRisposta()) {
                                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_555_LOCAL_FORWARD_PROCESS_REQUEST_ERROR), e));
                            }
                            return;
                        }
                    }
                    Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Controllo presenza del messaggio gia' in gestione...");
                    msgDiag.mediumDebug("Controllo presenza del messaggio gia' in gestione...");
                    msgRequest = null;
                    tipoMessaggio = "OUTBOX";
                    if (localForward) {
                        tipoMessaggio = "INBOX";
                    }
                    msgRequest = new GestoreMessaggi(openspcoopstate, true, idMessageRequest, tipoMessaggio, msgDiag, inRequestContext.getPddContext());
                    msgRequest.setOneWayVersione11(oneWayVersione11);
                    repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRichiesta(), true, protocolFactory);
                    try {
                        if (!msgRequest.existsMessage_noCache()) break block386;
                        proprietarioMessaggio = msgRequest.getProprietario(this.msgContext.getIdModulo());
                        if ("GestoreMessaggi".equals(proprietarioMessaggio)) {
                            msgDiag.logPersonalizzato("messaggioInGestione.marcatoDaEliminare");
                            msg = msgDiag.getMessaggio_replaceKeywords("messaggioInGestione.marcatoDaEliminare");
                            msgRequest.deleteMessageWithLock(msg, propertiesReader.getMsgGiaInProcessamento_AttesaAttiva(), propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                            break block386;
                        }
                        msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", proprietarioMessaggio);
                        msgDiag.logPersonalizzato("messaggioInGestione");
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_537_BUSTA_GIA_RICEVUTA.get537_BustaGiaRicevuta(idMessageRequest), null));
                        }
                        return;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "ControlloPresenzaMessaggioGiaInGestione");
                        logCore.error((Object)"Controllo/gestione presenza messaggio gia in gestione non riuscito", (Throwable)e);
                        openspcoopstate.releaseResource();
                        if (this.msgContext.isGestioneRisposta()) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_537_BUSTA_GIA_RICEVUTA), e));
                        }
                        return;
                    }
                }
                Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Registrazione messaggio di richiesta nel RepositoryMessaggi...");
                msgDiag.mediumDebug("Registrazione messaggio di richiesta nel RepositoryMessaggi...");
                moduleManager = protocolFactory.createProtocolVersionManager(richiestaDelegata.getProfiloGestione());
                richiestaAsincronaSimmetricaStateless = false;
                try {
                    if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(infoServizio.getProfiloDiCollaborazione()) && portaStateless) {
                        richiestaAsincronaSimmetricaStateless = StatoFunzionalitaProtocollo.ABILITATA.equals((Object)moduleManager.getCollaborazione(infoServizio.getProfiloDiCollaborazione())) ? (headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null ? false : headerIntegrazioneRichiesta.getBusta().getIdCollaborazione() == null) : headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() == null;
                    }
                    msgRequest.registraMessaggio(requestMessage, dataIngressoMessaggio, oneWayStateless != false || sincronoStateless != false || asincronoStateless != false, idCorrelazioneApplicativa);
                    if (localForward) {
                        msgRequest.aggiornaProprietarioMessaggio("ConsegnaContenutiApplicativi");
                    } else {
                        msgRequest.aggiornaProprietarioMessaggio("Imbustamento");
                    }
                    if (richiestaAsincronaSimmetricaStateless) {
                        msgRequest.registraInformazioniMessaggio_statelessEngine(dataIngressoMessaggio, "Imbustamento", idCorrelazioneApplicativa);
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "msgRequest.aggiornaProprietarioMessaggio");
                    msgRequest.deleteMessageFromFileSystem();
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        if (requestMessage.getParsingError() != null) {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_432_MESSAGGIO_XML_MALFORMATO.getErrore432_MessaggioRichiestaMalformato(true, requestMessage.getParsingError()), e));
                        } else {
                            this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_508_SAVE_REQUEST_MSG), e));
                        }
                    }
                    return;
                }
                msgDiag.mediumDebug("Registrazione busta di richiesta nel RepositoryBuste...");
                try {
                    if (portaStateless && !oneWayVersione11) break block387;
                    if (repositoryBuste.isRegistrata(idMessageRequest, tipoMessaggio)) {
                        try {
                            if (localForward) {
                                repositoryBuste.aggiornaBustaIntoInBox(idMessageRequest, soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                            } else {
                                repositoryBuste.aggiornaBustaIntoOutBox(idMessageRequest, soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                            }
                            repositoryBuste.impostaUtilizzoPdD(idMessageRequest, tipoMessaggio);
                        }
                        catch (Exception e) {
                            tipo = "OUTBOX";
                            if (localForward) {
                                tipo = "INBOX";
                            }
                            causa = "Aggiornamento dati busta con id [" + idMessageRequest + "] tipo[" + tipo + "] non riuscito: " + e.getMessage();
                            try {
                                GestoreMessaggi.acquireLock(msgDiag, causa, propertiesReader.getMsgGiaInProcessamento_AttesaAttiva(), propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                                if (repositoryBuste.isRegistrata(idMessageRequest, tipoMessaggio)) {
                                    if (localForward) {
                                        repositoryBuste.aggiornaBustaIntoInBox(idMessageRequest, soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                                    } else {
                                        repositoryBuste.aggiornaBustaIntoOutBox(idMessageRequest, soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                                    }
                                    repositoryBuste.impostaUtilizzoPdD(idMessageRequest, tipoMessaggio);
                                }
                                if (localForward) {
                                    repositoryBuste.registraBustaIntoInBox(idMessageRequest, soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                                }
                                repositoryBuste.registraBustaIntoOutBox(idMessageRequest, soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                            }
                            finally {
                                try {
                                    GestoreMessaggi.releaseLock(msgDiag, causa);
                                }
                                catch (Exception eUnlock) {}
                            }
                        }
                    } else if (localForward) {
                        repositoryBuste.registraBustaIntoInBox(idMessageRequest, soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                    } else {
                        repositoryBuste.registraBustaIntoOutBox(idMessageRequest, soggettoFruitore, richiestaDelegata.getIdServizio(), propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), infoServizio.getProfiloDiCollaborazione(), infoServizio.getConfermaRicezione(), infoServizio.getInoltro());
                    }
                    infoIntegrazione = new Integrazione();
                    infoIntegrazione.setIdModuloInAttesa(this.msgContext.getIdModulo());
                    infoIntegrazione.setLocationPD(richiestaDelegata.getLocationPD());
                    infoIntegrazione.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
                    repositoryBuste.aggiornaInfoIntegrazione(idMessageRequest, tipoMessaggio, infoIntegrazione);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "registrazioneAggiornamentoBusta");
                    msgRequest.deleteMessageFromFileSystem();
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), e));
                    }
                    return;
                }
            }
            Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Invio messaggio al modulo di Imbustamento...");
            nextModulo = "Imbustamento";
            if (localForward) {
                msgDiag.addKeyword("@PORTA_APPLICATIVA@", pa.getNome());
                if (idServizio.getAzione() == null) {
                    msgDiag.addKeyword("@AZIONE_BUSTA_RICHIESTA@", "non presente");
                }
                msgDiag.logPersonalizzato("localForward.logInfo");
                nextModulo = "ConsegnaContenutiApplicativi";
            } else {
                msgDiag.mediumDebug("Invio messaggio al modulo di Imbustamento...");
            }
            try {
                msgDiag.highDebug("Creazione ObjectMessage for send nell'infrastruttura.");
                msgJMS = null;
                if (localForward) {
                    localForwardParameter.setRepositoryBuste(repositoryBuste);
                    localForwardParameter.getMsgDiag().setDelegata(false);
                    localForwardParameter.getMsgDiag().logCorrelazione();
                    localForwardEngine.updateLocalForwardParameter(localForwardParameter);
                    localForwardEngine.sendRequest(msgRequest);
                    localForwardParameter.getMsgDiag().setDelegata(true);
                } else {
                    imbustamentoMSG.setRichiestaDelegata(richiestaDelegata);
                    imbustamentoMSG.setInfoServizio(infoServizio);
                    imbustamentoMSG.setOneWayVersione11(oneWayVersione11);
                    if (headerIntegrazioneRichiesta.getBusta() != null) {
                        riferimentoServizioCorrelato = moduleManager.getIdCorrelazioneAsincrona(headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio(), headerIntegrazioneRichiesta.getBusta().getIdCollaborazione());
                        if (riferimentoServizioCorrelato != null) {
                            imbustamentoMSG.setRiferimentoServizioCorrelato(riferimentoServizioCorrelato);
                        }
                        if (headerIntegrazioneRichiesta.getBusta().getIdCollaborazione() != null) {
                            imbustamentoMSG.setIdCollaborazione(headerIntegrazioneRichiesta.getBusta().getIdCollaborazione());
                        }
                    }
                    imbustamentoMSG.setImplementazionePdDSoggettoMittente(implementazionePdDMittente);
                    imbustamentoMSG.setImplementazionePdDSoggettoDestinatario(implementazionePdDDestinatario);
                    imbustamentoMSG.setIndirizzoSoggettoMittente(indirizzoFruitore);
                    imbustamentoMSG.setIndirizzoSoggettoDestinatario(indirizzoErogatore);
                    imbustamentoMSG.setPddContext(inRequestContext.getPddContext());
                    msgJMS = imbustamentoMSG;
                }
                if (portaStateless) break block388;
                logCore.debug((Object)("RicezioneContenutiApplicativi :eseguo send verso " + nextModulo + "..."));
                classTypeNodeSender = null;
                nodeSender = null;
                try {
                    classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
                    nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
                }
                nodeSender.send(msgJMS, nextModulo, msgDiag, identitaPdD, this.msgContext.getIdModulo(), idMessageRequest, msgRequest);
                logCore.debug((Object)("RicezioneContenutiApplicativi :send verso " + nextModulo + " effettuata"));
            }
            catch (Exception e) {
                logCore.error((Object)("Spedizione->" + nextModulo + " non riuscita"), (Throwable)e);
                msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(" + nextModulo + ")");
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND), e));
                }
                return;
            }
        }
        Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Commit delle operazioni per la gestione della richiesta...");
        msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta...");
        try {
            openspcoopstate.commit();
            logCore.debug((Object)"RicezioneContenutiApplicativi :RicezioneContenutiApplicativi commit eseguito");
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "openspcoopstate.commit");
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            if (this.msgContext.isGestioneRisposta()) {
                this.msgContext.setMessageResponse(erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_506_COMMIT_JDBC), e));
            }
            return;
        }
        if (!portaStateless) {
            if (msgRequest != null) {
                msgRequest.addMessaggiIntoCache_readFromTable("RicezioneContenutiApplicativi", "richiesta");
            }
            if (msgRequest != null) {
                msgRequest.addProprietariIntoCache_readFromTable("RicezioneContenutiApplicativi", "richiesta", null, false);
            }
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta effettuato, rilascio della connessione...");
            openspcoopstate.releaseResource();
        }
        parametriGestioneRisposta = new RicezioneContenutiApplicativiGestioneRisposta();
        parametriGestioneRisposta.setOpenspcoopstate(openspcoopstate);
        parametriGestioneRisposta.setRegistroServiziReader(registroServiziReader);
        parametriGestioneRisposta.setConfigurazionePdDReader(configurazionePdDReader);
        parametriGestioneRisposta.setMsgDiag(msgDiag);
        parametriGestioneRisposta.setLogCore(logCore);
        parametriGestioneRisposta.setPropertiesReader(propertiesReader);
        parametriGestioneRisposta.setXmlBuilder(erroreApplicativoBuilder);
        parametriGestioneRisposta.setIdentitaPdD(identitaPdD);
        parametriGestioneRisposta.setIdMessageRequest(idMessageRequest);
        parametriGestioneRisposta.setHeaderIntegrazioneRichiesta(headerIntegrazioneRichiesta);
        parametriGestioneRisposta.setHeaderIntegrazioneRisposta(headerIntegrazioneRisposta);
        parametriGestioneRisposta.setTipiIntegrazionePD(tipiIntegrazionePD);
        parametriGestioneRisposta.setProprietaErroreAppl(proprietaErroreAppl);
        parametriGestioneRisposta.setServizioApplicativo(servizioApplicativo);
        parametriGestioneRisposta.setMsgRequest(msgRequest);
        parametriGestioneRisposta.setRepositoryBuste(repositoryBuste);
        parametriGestioneRisposta.setPortaStateless(portaStateless);
        parametriGestioneRisposta.setOneWayVers11(oneWayVersione11);
        parametriGestioneRisposta.setRichiestaAsincronaSimmetricaStateless(richiestaAsincronaSimmetricaStateless);
        parametriGestioneRisposta.setPortaDelegata(pd);
        parametriGestioneRisposta.setSoggettoMittente(soggettoFruitore);
        parametriGestioneRisposta.setIdServizio(idServizio);
        parametriGestioneRisposta.setLocalForward(localForward);
        parametriGestioneRisposta.setPddContext(inRequestContext.getPddContext());
        parametriGestioneRisposta.setProtocolFactory(protocolFactory);
        parametriGestioneRisposta.setBustaRichiesta(bustaRichiesta);
        if (portaStateless) {
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
            result = this.comportamentoStateless(parametriGestioneRisposta, imbustamentoMSG);
            if (!result) {
                openspcoopstate.releaseResource();
                return;
            }
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
        }
        configurazionePdDReader.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
        registroServiziReader.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
        msgDiag.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
        Utilities.printFreeMemory((String)"RicezioneContenutiApplicativi - Gestione risposta...");
        msgDiag.mediumDebug("Gestione risposta...");
        if (!this.msgContext.isGestioneRisposta()) {
            if (portaStateless) {
                openspcoopstate.releaseResource();
            }
            return;
        }
        this.gestioneRisposta(parametriGestioneRisposta);
        msgDiag.mediumDebug("Lavoro Terminato.");
    }

    private void setCredenziali(Credenziali credenziali, MsgDiagnostico msgDiag) {
        if (credenziali != null) {
            if (credenziali.getUsername() != null) {
                msgDiag.setServizioApplicativo("username(" + credenziali.getUsername() + ")");
            } else if (credenziali.getSubject() != null) {
                msgDiag.setServizioApplicativo("subject(" + credenziali.getSubject() + ")");
            } else {
                msgDiag.setServizioApplicativo(null);
            }
        }
        String credenzialiFornite = "";
        if (credenziali != null) {
            credenzialiFornite = credenziali.toString();
        }
        msgDiag.addKeyword("@CREDENZIALI_SA_FRUITORE@", credenzialiFornite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean comportamentoStateless(RicezioneContenutiApplicativiGestioneRisposta parametriGestioneRisposta, ImbustamentoMessage imbustamentoMSG) {
        OpenSPCoopStateless openspcoopstate = (OpenSPCoopStateless)parametriGestioneRisposta.getOpenspcoopstate();
        ConfigurazionePdDManager configurazionePdDReader = parametriGestioneRisposta.getConfigurazionePdDReader();
        RegistroServiziManager registroServiziReader = parametriGestioneRisposta.getRegistroServiziReader();
        MsgDiagnostico msgDiag = parametriGestioneRisposta.getMsgDiag();
        Logger logCore = parametriGestioneRisposta.getLogCore();
        ErroreApplicativoBuilder xmlBuilder = parametriGestioneRisposta.getXmlBuilder();
        OpenSPCoop2Properties propertiesReader = parametriGestioneRisposta.getPropertiesReader();
        String idMessageRequest = parametriGestioneRisposta.getIdMessageRequest();
        GestoreMessaggi msgRequest = parametriGestioneRisposta.getMsgRequest();
        parametriGestioneRisposta.setPortaStateless(true);
        boolean rinegoziamentoConnessione = propertiesReader.isRinegoziamentoConnessione(this.msgContext.getProtocol().getProfiloCollaborazione()) && !parametriGestioneRisposta.isOneWayVers11();
        boolean localForward = parametriGestioneRisposta.isLocalForward();
        String idTransazione = PdDContext.getValue("ID", imbustamentoMSG.getPddContext());
        if (localForward) {
            if ("ConsegnaContenutiApplicativi".equals(openspcoopstate.getDestinatarioRequestMsgLib()) && openspcoopstate.getDestinatarioResponseMsgLib() == null) {
                EsitoLib esito;
                ConsegnaContenutiApplicativi consegnaContenutiLib = null;
                try {
                    consegnaContenutiLib = new ConsegnaContenutiApplicativi(logCore);
                    esito = consegnaContenutiLib.onMessage(openspcoopstate);
                    if (esito.getStatoInvocazione() == 3) {
                        if (esito.getErroreNonGestito() != null) {
                            throw esito.getErroreNonGestito();
                        }
                        throw new Exception("Errore non gestito");
                    }
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "Stateless.ConsegnaContenutiApplicativi");
                    logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                    msgRequest.deleteMessageFromFileSystem();
                    openspcoopstate.setUseConnection(true);
                    openspcoopstate.releaseResource();
                    if (this.msgContext.isGestioneRisposta()) {
                        this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
                    }
                    return false;
                }
                if (esito.getStatoInvocazione() != 1) {
                    openspcoopstate.setUseConnection(true);
                    this.gestioneRisposta(parametriGestioneRisposta);
                    return false;
                }
            }
        } else {
            EsitoLib esito;
            org.openspcoop2.pdd.mdb.Imbustamento imbustamentoLib = null;
            openspcoopstate.setMessageLib(imbustamentoMSG);
            openspcoopstate.setIDMessaggioSessione(idMessageRequest);
            try {
                imbustamentoLib = new org.openspcoop2.pdd.mdb.Imbustamento(logCore);
                esito = imbustamentoLib.onMessage(openspcoopstate);
                if (esito.getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new Exception("Errore non gestito");
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Stateless.Imbustamento");
                logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
                }
                return false;
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstate.setUseConnection(true);
                this.gestioneRisposta(parametriGestioneRisposta);
                return false;
            }
            if (openspcoopstate.getDestinatarioResponseMsgLib() != null && openspcoopstate.getDestinatarioResponseMsgLib().startsWith(ID_MODULO) && propertiesReader.isGestioneOnewayStateful_1_1()) {
                return true;
            }
            if (rinegoziamentoConnessione) {
                openspcoopstate.setUseConnection(true);
                try {
                    openspcoopstate.commit();
                }
                catch (Exception e) {
                    // empty catch block
                }
                openspcoopstate.releaseResource();
                openspcoopstate.setUseConnection(false);
            }
            InoltroBuste inoltroBusteLib = null;
            try {
                inoltroBusteLib = new InoltroBuste(logCore);
                esito = inoltroBusteLib.onMessage(openspcoopstate);
                if (esito.getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new Exception("Errore non gestito");
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Stateless.InoltroBuste");
                logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
                }
                return false;
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstate.setUseConnection(true);
                this.gestioneRisposta(parametriGestioneRisposta);
                return false;
            }
            if (openspcoopstate.getDestinatarioResponseMsgLib() != null && openspcoopstate.getDestinatarioResponseMsgLib().startsWith(ID_MODULO)) {
                return true;
            }
            SbustamentoRisposte sbustamentoRisposteLib = null;
            boolean erroreSbustamentoRisposta = false;
            try {
                sbustamentoRisposteLib = new SbustamentoRisposte(logCore);
                if (rinegoziamentoConnessione && openspcoopstate.resourceReleased()) {
                    openspcoopstate.setUseConnection(true);
                    openspcoopstate.initResource(parametriGestioneRisposta.getIdentitaPdD(), "SbustamentoRisposte", idTransazione);
                    openspcoopstate.setUseConnection(false);
                    registroServiziReader.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
                    configurazionePdDReader.updateState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
                    msgDiag.updateState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
                }
                if ((esito = sbustamentoRisposteLib.onMessage(openspcoopstate)).getStatoInvocazione() == 3) {
                    if (esito.getErroreNonGestito() != null) {
                        throw esito.getErroreNonGestito();
                    }
                    throw new Exception("Errore non gestito");
                }
            }
            catch (Exception e) {
                erroreSbustamentoRisposta = true;
                msgDiag.logErroreGenerico(e, "Stateless.SbustamentoRisposte");
                logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.setUseConnection(true);
                openspcoopstate.releaseResource();
                if (this.msgContext.isGestioneRisposta()) {
                    this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (rinegoziamentoConnessione && !erroreSbustamentoRisposta) {
                    openspcoopstate.setUseConnection(true);
                    try {
                        openspcoopstate.commit();
                    }
                    catch (Exception e) {}
                    openspcoopstate.releaseResource();
                    openspcoopstate.setUseConnection(false);
                }
            }
            if (esito.getStatoInvocazione() != 1) {
                openspcoopstate.setUseConnection(true);
                this.gestioneRisposta(parametriGestioneRisposta);
                return false;
            }
        }
        return true;
    }

    private void gestioneRisposta(RicezioneContenutiApplicativiGestioneRisposta parametriGestioneRisposta) {
        Busta bustaRisposta;
        SOAPVersion versioneSoap;
        String idCorrelazioneApplicativaRisposta;
        OpenSPCoop2Message responseMessage;
        String profiloCollaborazioneValue;
        ProfiloDiCollaborazione profiloCollaborazione;
        String idCollaborazioneResponse;
        String idMessageResponse;
        Loader loader;
        Busta bustaRichiesta;
        IProtocolFactory protocolFactory;
        String idTransazione;
        PdDContext pddContext;
        boolean richiestaAsincronaSimmetricaStateless;
        boolean oneWayVers11;
        boolean portaStateless;
        GestoreMessaggi msgRequest;
        String[] tipiIntegrazionePD;
        HeaderIntegrazione headerIntegrazioneRisposta;
        HeaderIntegrazione headerIntegrazioneRichiesta;
        String servizioApplicativo;
        String idMessageRequest;
        ErroreApplicativoBuilder xmlBuilder;
        OpenSPCoop2Properties propertiesReader;
        Logger logCore;
        MsgDiagnostico msgDiag;
        IOpenSPCoopState openspcoopstate;
        block60: {
            openspcoopstate = parametriGestioneRisposta.getOpenspcoopstate();
            msgDiag = parametriGestioneRisposta.getMsgDiag();
            logCore = parametriGestioneRisposta.getLogCore();
            propertiesReader = parametriGestioneRisposta.getPropertiesReader();
            xmlBuilder = parametriGestioneRisposta.getXmlBuilder();
            IDSoggetto identitaPdD = parametriGestioneRisposta.getIdentitaPdD();
            idMessageRequest = parametriGestioneRisposta.getIdMessageRequest();
            servizioApplicativo = parametriGestioneRisposta.getServizioApplicativo();
            headerIntegrazioneRichiesta = parametriGestioneRisposta.getHeaderIntegrazioneRichiesta();
            headerIntegrazioneRisposta = parametriGestioneRisposta.getHeaderIntegrazioneRisposta();
            tipiIntegrazionePD = parametriGestioneRisposta.getTipiIntegrazionePD();
            msgRequest = parametriGestioneRisposta.getMsgRequest();
            portaStateless = parametriGestioneRisposta.isPortaStateless();
            oneWayVers11 = parametriGestioneRisposta.isOneWayVers11();
            richiestaAsincronaSimmetricaStateless = parametriGestioneRisposta.isRichiestaAsincronaSimmetricaStateless();
            pddContext = parametriGestioneRisposta.getPddContext();
            idTransazione = PdDContext.getValue("ID", pddContext);
            protocolFactory = parametriGestioneRisposta.getProtocolFactory();
            bustaRichiesta = parametriGestioneRisposta.getBustaRichiesta();
            loader = Loader.getInstance();
            idMessageResponse = null;
            idCollaborazioneResponse = null;
            profiloCollaborazione = null;
            profiloCollaborazioneValue = null;
            responseMessage = null;
            idCorrelazioneApplicativaRisposta = null;
            versioneSoap = (SOAPVersion)this.msgContext.pddContext.getObject("SOAP_VERSION");
            try {
                if (portaStateless || oneWayVers11) {
                    RicezioneContenutiApplicativiMessage ricezioneContenutiApplicativiMSG = (RicezioneContenutiApplicativiMessage)((OpenSPCoopStateless)openspcoopstate).getMessageLib();
                    idMessageResponse = ricezioneContenutiApplicativiMSG.getIdBustaRisposta();
                    idCollaborazioneResponse = ricezioneContenutiApplicativiMSG.getIdCollaborazione();
                    profiloCollaborazione = ricezioneContenutiApplicativiMSG.getProfiloCollaborazione();
                    profiloCollaborazioneValue = ricezioneContenutiApplicativiMSG.getProfiloCollaborazioneValue();
                    responseMessage = ((OpenSPCoopStateless)openspcoopstate).getRispostaMsg();
                    if (responseMessage != null) {
                        versioneSoap = responseMessage.getVersioneSoap();
                    }
                    idCorrelazioneApplicativaRisposta = ((OpenSPCoopStateless)openspcoopstate).getIDCorrelazioneApplicativaRisposta();
                    if (!ProfiloDiCollaborazione.ONEWAY.equals(profiloCollaborazione)) {
                        this.msgContext.getProtocol().setIdRisposta(idMessageResponse);
                    }
                    this.msgContext.getProtocol().setCollaborazione(idCollaborazioneResponse);
                    msgDiag.setIdMessaggioRisposta(idMessageResponse);
                    msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", idMessageResponse);
                    break block60;
                }
                try {
                    responseMessage = SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap);
                    String classType = null;
                    INodeReceiver nodeReceiver = null;
                    try {
                        classType = ClassNameProperties.getInstance().getNodeReceiver(propertiesReader.getNodeReceiver());
                        nodeReceiver = (INodeReceiver)loader.newInstance(classType);
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
                    }
                    msgDiag.mediumDebug("Attesa/lettura risposta...");
                    RicezioneContenutiApplicativiMessage ricezioneContenutiApplicativiMSG = (RicezioneContenutiApplicativiMessage)nodeReceiver.receive(msgDiag, identitaPdD, this.msgContext.getIdModulo(), idMessageRequest, propertiesReader.getNodeReceiverTimeoutRicezioneContenutiApplicativi(), propertiesReader.getNodeReceiverCheckInterval());
                    idMessageResponse = ricezioneContenutiApplicativiMSG.getIdBustaRisposta();
                    idCollaborazioneResponse = ricezioneContenutiApplicativiMSG.getIdCollaborazione();
                    profiloCollaborazione = ricezioneContenutiApplicativiMSG.getProfiloCollaborazione();
                    profiloCollaborazioneValue = ricezioneContenutiApplicativiMSG.getProfiloCollaborazioneValue();
                    pddContext = ricezioneContenutiApplicativiMSG.getPddContext();
                    if (pddContext != null) {
                        Enumeration<String> enumPddContext = pddContext.keys();
                        while (enumPddContext.hasMoreElements()) {
                            String key = enumPddContext.nextElement();
                            this.msgContext.getPddContext().addObject(key, pddContext.getObject(key));
                        }
                    }
                    if (!ProfiloDiCollaborazione.ONEWAY.equals(profiloCollaborazione)) {
                        this.msgContext.getProtocol().setIdRisposta(idMessageResponse);
                    }
                    this.msgContext.getProtocol().setCollaborazione(idCollaborazioneResponse);
                }
                catch (Exception e) {
                    logCore.error((Object)("Gestione risposta (" + this.msgContext.getIdModulo() + ") con errore"), (Throwable)e);
                    msgDiag.logErroreGenerico(e, "GestioneRispostaErroreGenerale");
                    if (e instanceof NodeTimeoutException) {
                        try {
                            openspcoopstate.updateResource(idTransazione);
                        }
                        catch (Exception eDB) {
                            msgDiag.logErroreGenerico(e, "openspcoopstate.updateResource()");
                            this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), eDB));
                            return;
                        }
                        try {
                            msgDiag.logPersonalizzato("timeoutRicezioneRisposta");
                            msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                            openspcoopstate.commit();
                        }
                        catch (Exception eDel) {
                            msgDiag.logErroreGenerico(eDel, "EliminazioneMessaggioScadutoTimeoutRicezioneRisposta");
                        }
                        openspcoopstate.releaseResource();
                    }
                    this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_513_RECEIVE), e));
                    return;
                }
                msgDiag.setIdMessaggioRisposta(idMessageResponse);
                msgDiag.addKeyword("@ID_MESSAGGIO_RISPOSTA@", idMessageResponse);
                msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                try {
                    openspcoopstate.updateResource(idTransazione);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "openspcoopstate.updateResource()");
                    this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_505_GET_DB_CONNECTION), e));
                    return;
                }
                msgRequest.updateOpenSPCoopState(openspcoopstate);
                msgDiag.mediumDebug("Lettura messaggio di risposta...");
                GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idMessageResponse, "INBOX", msgDiag, this.msgContext.pddContext);
                try {
                    responseMessage = msgResponse.getMessage();
                    idCorrelazioneApplicativaRisposta = msgResponse.getIDCorrelazioneApplicativaRisposta();
                }
                catch (GestoreMessaggiException e) {
                    msgDiag.logErroreGenerico(e, "msgResponse.getMessage()");
                    openspcoopstate.releaseResource();
                    this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_511_READ_RESPONSE_MSG), (Exception)e));
                    return;
                }
            }
            catch (Exception e) {
                logCore.error((Object)"ErroreGenerale", (Throwable)e);
                msgDiag.logErroreGenerico(e, "ErroreGenerale");
                openspcoopstate.releaseResource();
                this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
            }
        }
        msgDiag.setIdCorrelazioneRisposta(idCorrelazioneApplicativaRisposta);
        if (this.msgContext.getProtocol() != null) {
            this.msgContext.getProtocol().setProfiloCollaborazione(profiloCollaborazione, profiloCollaborazioneValue);
        }
        if (this.msgContext.getIntegrazione() != null) {
            this.msgContext.getIntegrazione().setIdCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
        }
        msgDiag.mediumDebug("Gestione header di integrazione messaggio di risposta...");
        headerIntegrazioneRisposta.getBusta().setIdCollaborazione(idCollaborazioneResponse);
        headerIntegrazioneRisposta.getBusta().setProfiloDiCollaborazione(profiloCollaborazione);
        headerIntegrazioneRisposta.getBusta().setID(idMessageRequest);
        OutResponsePDMessage outResponsePDMessage = new OutResponsePDMessage();
        outResponsePDMessage.setBustaRichiesta(bustaRichiesta);
        Object bustaRispostaObject = pddContext.getObject("BustaProprietaHeaderIntegrazione");
        if (bustaRispostaObject != null && bustaRispostaObject instanceof Busta && (bustaRisposta = (Busta)bustaRispostaObject).sizeProperties() > 0) {
            String[] propertyNames = bustaRisposta.getPropertiesNames();
            for (int i = 0; i < propertyNames.length; ++i) {
                outResponsePDMessage.getBustaRichiesta().addProperty(propertyNames[i], bustaRisposta.getProperty(propertyNames[i]));
            }
        }
        outResponsePDMessage.setMessage(responseMessage);
        outResponsePDMessage.setPortaDelegata(parametriGestioneRisposta.getPortaDelegata());
        Properties propertiesIntegrazioneRisposta = new Properties();
        outResponsePDMessage.setProprietaTrasporto(propertiesIntegrazioneRisposta);
        outResponsePDMessage.setServizio(parametriGestioneRisposta.getIdServizio());
        outResponsePDMessage.setSoggettoMittente(parametriGestioneRisposta.getSoggettoMittente());
        if (this.msgContext.getIdModulo().startsWith(ID_MODULO + IntegrationManager.ID_MODULO)) {
            try {
                String classType = null;
                IGestoreIntegrazionePD gestore = null;
                try {
                    classType = ClassNameProperties.getInstance().getIntegrazionePortaDelegata("trasporto");
                    gestore = (IGestoreIntegrazionePD)loader.newInstance(classType);
                    AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo (Risposta IM) [" + "trasporto" + "]: " + e.getMessage());
                }
                if (gestore != null) {
                    gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePDMessage);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "setHeaderIntegrazioneRisposta");
            }
        }
        for (int i = 0; i < tipiIntegrazionePD.length; ++i) {
            try {
                String classType = null;
                IGestoreIntegrazionePD gestore = null;
                try {
                    classType = ClassNameProperties.getInstance().getIntegrazionePortaDelegata(tipiIntegrazionePD[i]);
                    gestore = (IGestoreIntegrazionePD)loader.newInstance(classType);
                    AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione (Risposta) di tipo [" + tipiIntegrazionePD[i] + "]: " + e.getMessage());
                }
                if (gestore != null) {
                    if (gestore instanceof IGestoreIntegrazionePDSoap) {
                        if (propertiesReader.processHeaderIntegrazionePDResponse(false)) {
                            if (!propertiesReader.deleteHeaderIntegrazioneResponsePD()) continue;
                            if (responseMessage == null) {
                                responseMessage = this.fac.createEmptySOAPMessage(versioneSoap);
                                outResponsePDMessage.setMessage(responseMessage);
                            }
                            gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePDMessage);
                            continue;
                        }
                        if (responseMessage == null) {
                            responseMessage = this.fac.createEmptySOAPMessage(versioneSoap);
                            outResponsePDMessage.setMessage(responseMessage);
                        }
                        gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePDMessage);
                        continue;
                    }
                    gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePDMessage);
                    continue;
                }
                msgDiag.logErroreGenerico("Creazione header di integrazione [" + tipiIntegrazionePD[i] + "] non riuscito, gestore non inzializzato", "setHeaderIntegrazioneRisposta");
                continue;
            }
            catch (Exception e) {
                logCore.error((Object)("Errore durante la creazione dell'header di integrazione [" + tipiIntegrazionePD[i] + "]: " + e.getMessage()), (Throwable)e);
                msgDiag.logErroreGenerico(e, "setHeaderIntegrazioneRisposta(" + tipiIntegrazionePD[i] + ")");
            }
        }
        this.msgContext.setHeaderIntegrazioneRisposta(propertiesIntegrazioneRisposta);
        if (!portaStateless) {
            this.eliminaSIL((OpenSPCoopStateful)openspcoopstate, msgDiag, idMessageRequest, idMessageResponse, servizioApplicativo);
        }
        if (portaStateless && !oneWayVers11) {
            msgDiag.mediumDebug("Aggiorno proprietario messaggio richiesta ...");
            try {
                if (richiestaAsincronaSimmetricaStateless) {
                    boolean resourceReleased = openspcoopstate.resourceReleased();
                    if (resourceReleased) {
                        ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                        openspcoopstate.updateResource(idTransazione);
                    }
                    GestoreMessaggi msgResponse = new GestoreMessaggi(openspcoopstate, false, idMessageResponse, "INBOX", msgDiag, this.msgContext.pddContext);
                    msgResponse.setReadyForDrop(true);
                    msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    msgResponse.setReadyForDrop(false);
                    msgRequest.updateOpenSPCoopState(openspcoopstate);
                    msgRequest.setReadyForDrop(true);
                    msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    msgRequest.setReadyForDrop(false);
                }
                openspcoopstate.commit();
            }
            catch (Exception e) {
                logCore.error((Object)"Errore durante l'aggiornamento del proprietario al GestoreMessaggi (Stateless)", (Throwable)e);
                msgDiag.logErroreGenerico(e, "openspcoopstate.commit(stateless risposta)");
                openspcoopstate.releaseResource();
                this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
            }
        }
        if (oneWayVers11) {
            msgDiag.mediumDebug("Commit della gestione oneWay stateful/stateless...");
            try {
                openspcoopstate.commit();
            }
            catch (Exception e) {
                logCore.error((Object)"Riscontrato errore durante il commit della gestione oneWay stateful/stateless", (Throwable)e);
                msgDiag.logErroreGenerico(e, "openspcoopstate.commit(oneway1.1 risposta)");
                openspcoopstate.releaseResource();
                this.msgContext.setMessageResponse(xmlBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e));
            }
        }
        msgDiag.mediumDebug("Rilascio connessione al database...");
        openspcoopstate.releaseResource();
        if (profiloCollaborazione != null) {
            if (profiloCollaborazione.equals(ProfiloDiCollaborazione.SINCRONO)) {
                msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "risposta sincrona");
                msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            } else if (profiloCollaborazione.equals(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO)) {
                if (headerIntegrazioneRichiesta != null && headerIntegrazioneRichiesta.getBusta() != null && headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona simmetrica");
                } else {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona simmetrica");
                }
                msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            } else if (profiloCollaborazione.equals(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO)) {
                if (headerIntegrazioneRichiesta != null && headerIntegrazioneRichiesta.getBusta() != null && headerIntegrazioneRichiesta.getBusta().getRiferimentoMessaggio() != null) {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una risposta asincrona asimmetrica");
                } else {
                    msgDiag.addKeyword("@TIPOLOGIA_RISPOSTA_APPLICATIVA@", "ricevuta di una richiesta asincrona asimmetrica");
                }
                msgDiag.logPersonalizzato("consegnaRispostaApplicativa");
            }
        }
        msgDiag.mediumDebug("Imposto risposta nel context...");
        this.msgContext.setMessageResponse(responseMessage);
    }

    private void eliminaSIL(OpenSPCoopStateful openspcoopstate, MsgDiagnostico msgDiag, String idMessageRequest, String idMessageResponse, String servizioApplicativo) {
        msgDiag.mediumDebug("Eliminazione SIL destinatario del messaggio nella tabelle MSG_SERVIZI_APPLICATIVI...");
        if (openspcoopstate.getConnectionDB() != null) {
            try {
                GestoreMessaggi gestoreEliminazioneDestinatario = new GestoreMessaggi(openspcoopstate, false, idMessageResponse, "INBOX", msgDiag, this.msgContext.pddContext);
                gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(servizioApplicativo, idMessageRequest);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(" + servizioApplicativo + ")");
            }
        } else {
            msgDiag.logErroreGenerico("Connessione non disponibile", "gestoreEliminazioneDestinatario.eliminaDestinatarioMessaggio(" + servizioApplicativo + ")");
        }
    }
}

