/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.services;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.TipoFiltroAbilitazioneServizi;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.eccezione.details.utils.XMLUtils;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaApplicativaByNome;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaApplicativa;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.EJBUtils;
import org.openspcoop2.pdd.core.GestoreCorrelazioneApplicativa;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.IntegrationContext;
import org.openspcoop2.pdd.core.MTOMProcessor;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.ProtocolContext;
import org.openspcoop2.pdd.core.StatoServiziPdD;
import org.openspcoop2.pdd.core.Utilities;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativi;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativiException;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.autenticazione.GestoreCredenzialiConfigurationException;
import org.openspcoop2.pdd.core.autenticazione.IGestoreCredenziali;
import org.openspcoop2.pdd.core.autorizzazione.GestoreAutorizzazioneBuste;
import org.openspcoop2.pdd.core.autorizzazione.IAutorizzazioneContenutoBuste;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InRequestContext;
import org.openspcoop2.pdd.core.handlers.InRequestProtocolContext;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazioneBusta;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePA;
import org.openspcoop2.pdd.core.integrazione.IGestoreIntegrazionePASoap;
import org.openspcoop2.pdd.core.integrazione.InRequestPAMessage;
import org.openspcoop2.pdd.core.integrazione.OutResponsePAMessage;
import org.openspcoop2.pdd.core.integrazione.UtilitiesIntegrazione;
import org.openspcoop2.pdd.core.node.INodeReceiver;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.node.NodeTimeoutException;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.ImbustamentoRisposte;
import org.openspcoop2.pdd.mdb.InoltroBuste;
import org.openspcoop2.pdd.mdb.InoltroBusteMessage;
import org.openspcoop2.pdd.mdb.InoltroRisposte;
import org.openspcoop2.pdd.mdb.Sbustamento;
import org.openspcoop2.pdd.mdb.SbustamentoMessage;
import org.openspcoop2.pdd.services.FlowProperties;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.services.RicezioneBusteContext;
import org.openspcoop2.pdd.services.RicezioneBusteMessage;
import org.openspcoop2.pdd.services.RicezioneBusteParametriGenerazioneBustaErrore;
import org.openspcoop2.pdd.services.RicezioneBusteParametriInvioBustaErrore;
import org.openspcoop2.pdd.services.ServletUtils;
import org.openspcoop2.pdd.services.connector.ConnectorInMessage;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop2.pdd.timers.TimerThreshold;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.mapping.InformazioniServizioURLMapping;
import org.openspcoop2.protocol.engine.validator.Validatore;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.SecurityInfo;
import org.openspcoop2.protocol.sdk.Servizio;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.constants.StatoFunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.constants.TipoTraccia;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.protocol.sdk.tracciamento.EsitoElaborazioneMessaggioTracciato;
import org.openspcoop2.protocol.sdk.tracciamento.TracciamentoException;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSemantica;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityContextParameters;
import org.openspcoop2.security.message.engine.MessageSecurityFactory;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.Loader;

public class RicezioneBuste {
    public static final String ID_MODULO = "RicezioneBuste";
    public static boolean initializeService = false;
    public static Boolean isActivePAService = true;
    public static List<TipoFiltroAbilitazioneServizi> listaAbilitazioniPAService = null;
    public static List<TipoFiltroAbilitazioneServizi> listaDisabilitazioniPAService = null;
    private static String[] defaultGestoriIntegrazionePA = null;
    private static Hashtable<String, String[]> defaultPerProtocolloGestoreIntegrazionePA = null;
    private OpenSPCoop2MessageFactory fac = OpenSPCoop2MessageFactory.getMessageFactory();
    private static String[] tipiGestoriCredenziali = null;
    private RicezioneBusteContext msgContext;
    boolean responseAsByte = false;

    protected static synchronized void initializeService(ConfigurazionePdDManager configReader, ClassNameProperties className, OpenSPCoop2Properties propertiesReader, Logger logCore) throws Exception {
        if (initializeService) {
            return;
        }
        Loader loader = Loader.getInstance();
        isActivePAService = configReader.isPAServiceActive();
        listaAbilitazioniPAService = configReader.getFiltriAbilitazionePAService();
        listaDisabilitazioniPAService = configReader.getFiltriDisabilitazionePAService();
        String classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
        try {
            INodeSender nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
            nodeSender.toString();
            logCore.info((Object)("Inizializzazione gestore NodeSender di tipo " + classTypeNodeSender + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
        }
        String classType = className.getNodeReceiver(propertiesReader.getNodeReceiver());
        try {
            INodeReceiver nodeReceiver = (INodeReceiver)loader.newInstance(classType);
            nodeReceiver.toString();
            logCore.info((Object)("Inizializzazione gestore NodeReceiver di tipo " + classType + " effettuata."));
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
        }
        if (propertiesReader.isAbilitataCacheAutorizzazioneBuste()) {
            GestoreAutorizzazioneBuste.initialize(propertiesReader.getTipoAutorizzazioneBuste(), propertiesReader.getDimensioneCacheAutorizzazioneBuste(), propertiesReader.getAlgoritmoCacheAutorizzazioneBuste(), propertiesReader.getItemIdleTimeCacheAutorizzazioneBuste(), propertiesReader.getItemLifeSecondCacheAutorizzazioneBuste(), logCore);
        } else {
            GestoreAutorizzazioneBuste.initialize(propertiesReader.getTipoAutorizzazioneBuste(), logCore);
        }
        String[] tipiIntegrazioneDefault = propertiesReader.getTipoIntegrazionePA();
        Vector<String> s = new Vector<String>();
        for (int i = 0; i < tipiIntegrazioneDefault.length; ++i) {
            classType = className.getIntegrazionePortaApplicativa(tipiIntegrazioneDefault[i]);
            try {
                IGestoreIntegrazionePA test = (IGestoreIntegrazionePA)loader.newInstance(classType);
                test.toString();
                s.add(tipiIntegrazioneDefault[i]);
                logCore.info((Object)("Inizializzazione gestore per lettura integrazione PA di tipo " + tipiIntegrazioneDefault[i] + " effettuata."));
                continue;
            }
            catch (Exception e) {
                throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + tipiIntegrazioneDefault[i] + "]: " + e.getMessage());
            }
        }
        if (s.size() > 0) {
            defaultGestoriIntegrazionePA = s.toArray(new String[1]);
        }
        defaultPerProtocolloGestoreIntegrazionePA = new Hashtable();
        Enumeration enumProtocols = ProtocolFactoryManager.getInstance().getProtocolNames();
        while (enumProtocols.hasMoreElements()) {
            String protocol = (String)enumProtocols.nextElement();
            String[] tipiIntegrazionePA = propertiesReader.getTipoIntegrazionePA(protocol);
            if (tipiIntegrazionePA == null || tipiIntegrazionePA.length <= 0) continue;
            Vector<String> tipiIntegrazionePerProtocollo = new Vector<String>();
            for (int i = 0; i < tipiIntegrazionePA.length; ++i) {
                classType = className.getIntegrazionePortaApplicativa(tipiIntegrazionePA[i]);
                try {
                    IGestoreIntegrazionePA test = (IGestoreIntegrazionePA)loader.newInstance(classType);
                    test.toString();
                    tipiIntegrazionePerProtocollo.add(tipiIntegrazionePA[i]);
                    logCore.info((Object)("Inizializzazione gestore per lettura integrazione PA di tipo " + tipiIntegrazionePA[i] + " effettuata."));
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + tipiIntegrazionePA[i] + "]: " + e.getMessage());
                }
            }
            if (tipiIntegrazionePerProtocollo.size() <= 0) continue;
            defaultPerProtocolloGestoreIntegrazionePA.put(protocol, tipiIntegrazionePerProtocollo.toArray(new String[1]));
        }
        tipiGestoriCredenziali = propertiesReader.getTipoGestoreCredenzialiPA();
        if (tipiGestoriCredenziali != null) {
            for (int i = 0; i < tipiGestoriCredenziali.length; ++i) {
                classType = className.getGestoreCredenziali(tipiGestoriCredenziali[i]);
                try {
                    IGestoreCredenziali gestore = (IGestoreCredenziali)loader.newInstance(classType);
                    gestore.toString();
                    logCore.info((Object)("Inizializzazione gestore credenziali di tipo " + tipiGestoriCredenziali[i] + " effettuata."));
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione delle credenziali di tipo [" + tipiGestoriCredenziali[i] + "]: " + e.getMessage());
                }
            }
        }
        initializeService = true;
    }

    public RicezioneBuste(RicezioneBusteContext context) {
        this.msgContext = context;
    }

    public void process(Object ... params) {
        Logger logCore = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (logCore == null) {
            logCore = Logger.getLogger((String)ID_MODULO);
        }
        MsgDiagnostico msgDiag = this.msgContext.getMsgDiagnostico();
        OpenSPCoop2Message requestMessage = this.msgContext.getMessageRequest();
        if (requestMessage == null) {
            try {
                requestMessage = this.msgContext.getMessageRequestFromByte();
                this.responseAsByte = true;
            }
            catch (Exception e) {
                this.setSOAPFault_processamento(logCore, msgDiag, e, "LetturaMessaggioRichiesta");
                return;
            }
        }
        IProtocolFactory protocolFactory = null;
        try {
            protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject("PROTOCOLLO"));
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "ProtocolFactoryInstance");
            return;
        }
        InRequestContext inRequestContext = new InRequestContext(logCore, protocolFactory);
        inRequestContext.setTipoPorta(TipoPdD.APPLICATIVA);
        InfoConnettoreIngresso connettore = new InfoConnettoreIngresso();
        connettore.setCredenziali(this.msgContext.getCredenziali());
        if (this.msgContext.getUrlProtocolContext() != null) {
            connettore.setUrlProtocolContext(this.msgContext.getUrlProtocolContext());
        }
        connettore.setSoapAction(this.msgContext.getSoapAction());
        connettore.setFromLocation(this.msgContext.getFromLocation());
        inRequestContext.setConnettore(connettore);
        inRequestContext.setDataElaborazioneMessaggio(this.msgContext.getDataIngressoRichiesta());
        inRequestContext.setPddContext(this.msgContext.getPddContext());
        inRequestContext.setMessaggio(requestMessage);
        try {
            GestoreHandlers.inRequest(inRequestContext, msgDiag, logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "InvocazioneInRequestHandler");
            return;
        }
        try {
            this.process_engine(inRequestContext, params);
        }
        catch (TracciamentoException tracciamentoException) {
            this.setSOAPFault_processamento(logCore, msgDiag, (Exception)((Object)tracciamentoException), "TracciamentoNonRiuscito");
            return;
        }
        catch (ProtocolException protocolException) {
            this.setSOAPFault_processamento(logCore, msgDiag, (Exception)((Object)protocolException), "ProtocolFactoryNonInstanziata");
            return;
        }
        OutResponseContext outResponseContext = new OutResponseContext(logCore, protocolFactory);
        outResponseContext.setTipoPorta(this.msgContext.getTipoPorta());
        outResponseContext.setDataElaborazioneMessaggio(DateManager.getDate());
        outResponseContext.setPddContext(inRequestContext.getPddContext());
        outResponseContext.setProtocollo(this.msgContext.getProtocol());
        outResponseContext.setIntegrazione(this.msgContext.getIntegrazione());
        outResponseContext.setPropertiesRispostaTrasporto(this.msgContext.getHeaderIntegrazioneRisposta());
        OpenSPCoop2Message msgResponse = this.msgContext.getMessageResponse();
        outResponseContext.setMessaggio(msgResponse);
        try {
            GestoreHandlers.outResponse(outResponseContext, msgDiag, logCore);
        }
        catch (HandlerException e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, e.getIdentitaHandler());
            return;
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "InvocazioneOutResponseHandler");
            return;
        }
        OpenSPCoop2Message msgRisposta = null;
        try {
            msgRisposta = outResponseContext.getMessaggio();
            boolean rispostaPresente = true;
            OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
            if (properties != null) {
                rispostaPresente = ServletUtils.verificaRispostaRelazioneCodiceTrasporto202(protocolFactory, OpenSPCoop2Properties.getInstance(), msgRisposta, true);
            }
            if (rispostaPresente) {
                if (this.responseAsByte) {
                    this.msgContext.setMessageResponseAsByte(msgRisposta);
                } else {
                    this.msgContext.setMessageResponse(msgRisposta);
                }
            } else {
                this.msgContext.setMessageResponse(null);
                msgRisposta = null;
            }
        }
        catch (Exception e) {
            this.setSOAPFault_processamento(logCore, msgDiag, e, "FineGestioneRicezioneBuste");
            return;
        }
        if (Dump.sistemaDumpDisponibile) {
            try {
                ConfigurazionePdDManager configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                if (configurazionePdDReader.dumpMessaggi() && msgRisposta != null) {
                    ProtocolContext protocolContext = this.msgContext.getProtocol();
                    Dump dumpApplicativo = null;
                    dumpApplicativo = protocolContext != null ? new Dump(protocolContext.getDominio(), this.msgContext.getIdModulo(), protocolContext.getIdRichiesta(), protocolContext.getFruitore(), new IDServizio(protocolContext.getErogatore(), protocolContext.getTipoServizio(), protocolContext.getServizio(), protocolContext.getAzione()), this.msgContext.getTipoPorta(), this.msgContext.getPddContext(), null, null) : new Dump(null, this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), this.msgContext.getPddContext(), null, null);
                    dumpApplicativo.dumpRispostaUscita(msgRisposta, inRequestContext.getConnettore(), outResponseContext.getPropertiesRispostaTrasporto());
                }
            }
            catch (TracciamentoException tracciamentoException) {
                this.setSOAPFault_processamento(logCore, msgDiag, (Exception)((Object)tracciamentoException), "TracciamentoNonRiuscito");
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void setSOAPFault_processamento(Logger logCore, MsgDiagnostico msgDiag, Exception e, String posizione) {
        this.setSOAPFault_engine(logCore, msgDiag, e, null, null, posizione, false);
    }

    private void setSOAPFault_processamento(String posizione) {
        this.setSOAPFault_engine(null, null, null, null, null, posizione, false);
    }

    private void setSOAPFault_intestazione(ErroreCooperazione erroreCooperazione) {
        this.setSOAPFault_engine(null, null, null, erroreCooperazione, null, null, true);
    }

    private void setSOAPFault_intestazione(ErroreIntegrazione erroreIntegrazione) {
        this.setSOAPFault_engine(null, null, null, null, erroreIntegrazione, null, true);
    }

    private void setSOAPFault_engine(Logger logCore, MsgDiagnostico msgDiag, Exception e, ErroreCooperazione erroreCooperazione, ErroreIntegrazione erroreIntegrazione, String posizioneErrore, boolean validazione) {
        boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1 = true;
        try {
            setSoapPrefixBackwardCompatibilityOpenSPCoop1 = OpenSPCoop2Properties.getInstance().isForceSoapPrefixCompatibilitaOpenSPCoopV1();
        }
        catch (Exception eReader) {
            // empty catch block
        }
        SOAPVersion versioneSoap = (SOAPVersion)this.msgContext.getPddContext().getObject("SOAP_VERSION");
        if (msgDiag != null) {
            msgDiag.logErroreGenerico(e, posizioneErrore);
        } else if (logCore != null) {
            logCore.error((Object)(posizioneErrore + e.getMessage()), (Throwable)e);
        }
        if (this.msgContext.isGestioneRisposta()) {
            OpenSPCoop2Message messageFault = null;
            try {
                IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject("PROTOCOLLO"));
                Imbustamento imbustamentoErroreBuilder = new Imbustamento(logCore, protocolFactory);
                messageFault = validazione ? (erroreCooperazione != null ? imbustamentoErroreBuilder.buildSoapFaultProtocollo_intestazione(this.msgContext.getIdentitaPdD(), this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), erroreCooperazione.getCodiceErrore(), erroreCooperazione.getDescrizione(protocolFactory), versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1) : imbustamentoErroreBuilder.buildSoapFaultProtocollo_intestazione(this.msgContext.getIdentitaPdD(), this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), erroreIntegrazione, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1)) : (e != null ? imbustamentoErroreBuilder.buildSoapFaultProtocollo_processamento(this.msgContext.getIdentitaPdD(), this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(posizioneErrore), e, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1) : imbustamentoErroreBuilder.buildSoapFaultProtocollo_processamento(this.msgContext.getIdentitaPdD(), this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(posizioneErrore), versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1));
            }
            catch (ProtocolException protocolException) {
                protocolException.printStackTrace();
            }
            if (this.responseAsByte) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    messageFault.writeTo((OutputStream)out, false);
                }
                catch (Exception eWriteTo) {
                    msgDiag.logErroreGenerico(e, "GenerazioneFaultAsBytes");
                }
                this.msgContext.setMessageRequestAsByte(out.toByteArray());
            }
            this.msgContext.setMessageResponse(messageFault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void process_engine(InRequestContext inRequestContext, Object ... params) throws TracciamentoException, ProtocolException {
        block589: {
            block588: {
                block587: {
                    block585: {
                        requestMessage = inRequestContext.getMessaggio();
                        logCore = inRequestContext.getLogCore();
                        dataIngressoMessaggio = new Timestamp(this.msgContext.getDataIngressoRichiesta().getTime());
                        idTransazione = PdDContext.getValue("ID", inRequestContext.getPddContext());
                        loader = Loader.getInstance();
                        if (!OpenSPCoop2Startup.initialize) {
                            logCore.error((Object)"[RicezioneBuste]  Inizializzazione di OpenSPCoop non correttamente effettuata");
                            this.setSOAPFault_processamento("ErroreInizializzazioneOpenSPCoop");
                            return;
                        }
                        if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                            logCore.error((Object)("[RicezioneBuste]  Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                            this.setSOAPFault_processamento("RisorseSistemaNonDisponibili");
                            return;
                        }
                        if (!TimerThreshold.freeSpace) {
                            logCore.error((Object)"[RicezioneBuste]  Non sono disponibili abbastanza risorse per la gestione della richiesta");
                            this.setSOAPFault_processamento("RisorseSistemaLivelloCritico");
                            return;
                        }
                        if (!Tracciamento.tracciamentoDisponibile) {
                            logCore.error((Object)("[RicezioneBuste]  Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage()), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                            this.setSOAPFault_processamento("TracciaturaNonDisponibile");
                            return;
                        }
                        if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                            logCore.error((Object)("[RicezioneBuste]  Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                            this.setSOAPFault_processamento("DiagnosticaNonDisponibile");
                            return;
                        }
                        if (!Dump.sistemaDumpDisponibile) {
                            logCore.error((Object)("[RicezioneBuste]  Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage()), (Throwable)Dump.motivoMalfunzionamentoDump);
                            this.setSOAPFault_processamento("SistemaDumpNonDisponibile");
                            return;
                        }
                        configurazionePdDReader = ConfigurazionePdDManager.getInstance();
                        try {
                            configurazionePdDReader.verificaConsistenzaConfigurazione();
                        }
                        catch (Exception e) {
                            logCore.error((Object)"[RicezioneBuste]  Riscontrato errore durante la verifica della consistenza della configurazione PdD");
                            this.setSOAPFault_processamento("RefreshConfigurazioneNonRiuscito");
                            return;
                        }
                        registroServiziReader = RegistroServiziManager.getInstance();
                        try {
                            registroServiziReader.verificaConsistenzaRegistroServizi();
                        }
                        catch (Exception e) {
                            logCore.error((Object)"[RicezioneBuste]  Riscontrato errore durante la verifica del registro dei servizi", (Throwable)e);
                            this.setSOAPFault_processamento("RefreshRegistroServiziNonRiuscito");
                            return;
                        }
                        credenziali = this.msgContext.getCredenziali();
                        propertiesReader = OpenSPCoop2Properties.getInstance();
                        className = ClassNameProperties.getInstance();
                        protocollo = (String)this.msgContext.getPddContext().getObject("PROTOCOLLO");
                        identitaPdD = propertiesReader.getIdentitaPortaDefault(protocollo);
                        connectorInMessage = null;
                        if (params != null) {
                            for (i = 0; i < params.length; ++i) {
                                if (params[i] == null || !(params[i] instanceof ConnectorInMessage)) continue;
                                connectorInMessage = (ConnectorInMessage)params[i];
                                break;
                            }
                        }
                        protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
                        pddContext = inRequestContext.getPddContext();
                        traduttore = protocolFactory.createTraduttore();
                        msgDiag = new MsgDiagnostico(identitaPdD, this.msgContext.getIdModulo(), new IState[0]);
                        this.msgContext.setMsgDiagnostico(msgDiag);
                        msgDiag.setPddContext(inRequestContext.getPddContext(), protocolFactory);
                        msgDiag.setPrefixMsgPersonalizzati("ricezioneBuste.");
                        if (inRequestContext.getConnettore() != null && inRequestContext.getConnettore().getUrlProtocolContext() != null) {
                            msgDiag.setPorta(inRequestContext.getConnettore().getUrlProtocolContext().getFunctionParameters() + "_urlInvocazione(" + inRequestContext.getConnettore().getUrlProtocolContext().getUrlInvocazione_formBased() + ")");
                        }
                        urlProtocolContext = this.msgContext.getUrlProtocolContext();
                        this.setCredenziali(credenziali, msgDiag);
                        imbustatore = new Imbustamento(protocolFactory);
                        try {
                            if (!RicezioneBuste.initializeService) {
                                msgDiag.mediumDebug("Inizializzazione risorse statiche...");
                                RicezioneBuste.initializeService(configurazionePdDReader, className, propertiesReader, logCore);
                            }
                        }
                        catch (Exception e) {
                            this.setSOAPFault_processamento(logCore, msgDiag, e, "InizializzazioneRisorseServizioRicezioneBuste");
                            return;
                        }
                        headerRisposta = new Properties();
                        utilitiesHttp = new UtilitiesIntegrazione();
                        try {
                            utilitiesHttp.setResponseTransportProperties(null, headerRisposta, null);
                        }
                        catch (Exception e) {
                            this.setSOAPFault_processamento(logCore, msgDiag, e, "InizializzazioneHeaderRisposta");
                            return;
                        }
                        this.msgContext.setHeaderIntegrazioneRisposta(headerRisposta);
                        openspcoopstate = null;
                        sbustamentoMSG = new SbustamentoMessage();
                        inoltroMSG = new InoltroBusteMessage();
                        this.msgContext.setProtocol(new ProtocolContext());
                        this.msgContext.getProtocol().setDominio(this.msgContext.getIdentitaPdD());
                        this.msgContext.setIntegrazione(new IntegrationContext());
                        msgDiag.mediumDebug("Richiesta connessione al database...");
                        try {
                            openspcoopstate = new OpenSPCoopStateful();
                            openspcoopstate.initResource(identitaPdD, this.msgContext.getIdModulo(), idTransazione);
                        }
                        catch (Exception e) {
                            this.setSOAPFault_processamento(logCore, msgDiag, e, "initDatabaseResource");
                            return;
                        }
                        registroServiziReader.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
                        configurazionePdDReader.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
                        msgDiag.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
                        servizioApplicativoFruitore = null;
                        correlazioneApplicativa = null;
                        if (!this.msgContext.isTracciamentoAbilitato()) {
                            servizioApplicativoFruitore = this.msgContext.getIdentitaServizioApplicativoFruitore();
                            this.msgContext.getIntegrazione().setServizioApplicativoFruitore(servizioApplicativoFruitore);
                            correlazioneApplicativa = this.msgContext.getIdCorrelazioneApplicativa();
                            msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativoFruitore);
                            msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", correlazioneApplicativa);
                        }
                        parametriGenerazioneBustaErrore = new RicezioneBusteParametriGenerazioneBustaErrore();
                        parametriGenerazioneBustaErrore.setOpenspcoop(openspcoopstate);
                        parametriGenerazioneBustaErrore.setIdentitaPdD(identitaPdD);
                        parametriGenerazioneBustaErrore.setMsgDiag(msgDiag);
                        parametriGenerazioneBustaErrore.setPropertiesReader(propertiesReader);
                        parametriGenerazioneBustaErrore.setLogCore(logCore);
                        parametriGenerazioneBustaErrore.setCorrelazioneApplicativa(correlazioneApplicativa);
                        parametriGenerazioneBustaErrore.setServizioApplicativoFruitore(servizioApplicativoFruitore);
                        parametriGenerazioneBustaErrore.setImplementazionePdDMittente("standard");
                        parametriGenerazioneBustaErrore.setImplementazionePdDDestinatario("standard");
                        parametriGenerazioneBustaErrore.setImbustatore(imbustatore);
                        parametriInvioBustaErrore = new RicezioneBusteParametriInvioBustaErrore();
                        parametriInvioBustaErrore.setOpenspcoop(openspcoopstate);
                        parametriInvioBustaErrore.setIdentitaPdD(identitaPdD);
                        parametriInvioBustaErrore.setMsgDiag(msgDiag);
                        parametriInvioBustaErrore.setPropertiesReader(propertiesReader);
                        parametriInvioBustaErrore.setLogCore(logCore);
                        parametriInvioBustaErrore.setCorrelazioneApplicativa(correlazioneApplicativa);
                        parametriInvioBustaErrore.setServizioApplicativoFruitore(servizioApplicativoFruitore);
                        parametriInvioBustaErrore.setImplementazionePdDMittente("standard");
                        parametriInvioBustaErrore.setImplementazionePdDDestinatario("standard");
                        parametriInvioBustaErrore.setNewConnectionForResponse(false);
                        parametriInvioBustaErrore.setUtilizzoIndirizzoTelematico(false);
                        parametriInvioBustaErrore.setFunctionAsRouter(false);
                        parametriInvioBustaErrore.setOnewayVersione11(false);
                        parametriInvioBustaErrore.setPddContext(inRequestContext.getPddContext());
                        if (configurazionePdDReader.dumpMessaggi()) {
                            dumpApplicativo = new Dump(identitaPdD, this.msgContext.getIdModulo(), this.msgContext.getTipoPorta(), inRequestContext.getPddContext(), openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
                            dumpApplicativo.dumpRichiestaIngresso(requestMessage, inRequestContext.getConnettore());
                        }
                        is = null;
                        pa = null;
                        idServizio = null;
                        bustaURLMapping = null;
                        try {
                            is = new InformazioniServizioURLMapping(requestMessage, protocolFactory, urlProtocolContext, registroServiziReader, logCore, this.msgContext.getIdModuloAsIDService());
                            logCore.debug((Object)("InformazioniServizioTramiteURLMapping: " + is.toString()));
                        }
                        catch (ProtocolException e) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                            msgDiag.logPersonalizzato("ricezioneBuste.", "identificazionePAErrore");
                            this.setSOAPFault_intestazione(ErroriIntegrazione.ERRORE_450_PA_INESISTENTE.getErroreIntegrazione());
                            openspcoopstate.releaseResource();
                            return;
                        }
                        try {
                            identity = null;
                            if (is.existsPABasedIdentificationMode()) {
                                block584: {
                                    nomePA = null;
                                    tipoProprietario = null;
                                    nomeProprietario = null;
                                    listaPA = null;
                                    try {
                                        nomePA = is.getPaInfo().getNomePA();
                                        tipoProprietario = is.getPaInfo().getTipoSoggetto();
                                        nomeProprietario = is.getPaInfo().getNomeSoggetto();
                                        if (is.getPaInfo().getAzione() != null) {
                                            try {
                                                listaPA = configurazionePdDReader.getPorteApplicative(nomePA + "/" + is.getPaInfo().getAzione(), tipoProprietario, nomeProprietario);
                                            }
                                            catch (DriverConfigurazioneNotFound dNotFoud) {
                                                // empty catch block
                                            }
                                        }
                                        if (listaPA == null) {
                                            listaPA = configurazionePdDReader.getPorteApplicative(nomePA, tipoProprietario, nomeProprietario);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (IDService.PORTA_APPLICATIVA_API.equals(this.msgContext.getIdModuloAsIDService()) && nomePA.contains("/")) {
                                            tmpNome = new String(nomePA);
                                            while (tmpNome.contains("/")) {
                                                indexCut = -1;
                                                for (i = tmpNome.length() - 1; i >= 0; --i) {
                                                    if (tmpNome.charAt(i) != '/') continue;
                                                    indexCut = i;
                                                    break;
                                                }
                                                tmpNome = tmpNome.substring(0, indexCut);
                                                try {
                                                    listaPA = configurazionePdDReader.getPorteApplicative(tmpNome, tipoProprietario, nomeProprietario);
                                                }
                                                catch (DriverConfigurazioneNotFound dNotFoud) {
                                                    // empty catch block
                                                }
                                                if (listaPA == null || listaPA.size() <= 0) continue;
                                                break;
                                            }
                                        }
                                        if (listaPA != null && listaPA.size() > 0) break block584;
                                        nomeError = nomePA;
                                        if (is.getPaInfo().getAzione() != null) {
                                            nomeError = nomeError + "[/" + is.getPaInfo().getAzione() + "]";
                                        }
                                        throw new ProtocolException("Impossibile trovare la Porta Applicativa ( " + nomeError + " ) nella configurazione: " + e.getMessage(), (Throwable)e);
                                    }
                                }
                                if (listaPA.size() > 1) {
                                    if (tipoProprietario == null) {
                                        tipoProprietario = "*";
                                    }
                                    if (nomeProprietario == null) {
                                        nomeProprietario = "*";
                                    }
                                    nomeError = nomePA;
                                    if (is.getPaInfo().getAzione() != null) {
                                        nomeError = nomeError + "[/" + is.getPaInfo().getAzione() + "]";
                                    }
                                    throw new ProtocolException("Identificate piu' di una Porta Applicativa con i seguenti filtri: nomePA( " + nomeError + " ) tipoSoggetto( " + tipoProprietario + " ) nomeSoggetto( " + nomeProprietario + " )");
                                }
                                pa = (PortaApplicativa)listaPA.get(0);
                            }
                            if (is.existsIdentityBasedIdentificationMode() && connectorInMessage != null) {
                                identity = connectorInMessage.getIdentity();
                            }
                            idSoggettoFruitore = new IDSoggetto();
                            idSoggettoErogatore = new IDSoggetto();
                            idServizio = new IDServizio();
                            idServizio.setSoggettoErogatore(idSoggettoErogatore);
                            is.refreshDati(idSoggettoFruitore, idServizio, this.msgContext.getSoapAction(), identity, pa);
                            if (idSoggettoFruitore.getTipo() == null && idSoggettoFruitore.getNome() == null) {
                                idSoggettoFruitore = null;
                            }
                            nomeRegistroForSearch = null;
                            if (idSoggettoFruitore != null && idSoggettoFruitore.getTipo() != null && idSoggettoFruitore.getNome() != null) {
                                try {
                                    idSoggettoFruitore.setCodicePorta(registroServiziReader.getDominio(idSoggettoFruitore, nomeRegistroForSearch, protocolFactory));
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if (idSoggettoErogatore.getTipo() != null && idSoggettoErogatore.getNome() != null) {
                                try {
                                    idSoggettoErogatore.setCodicePorta(registroServiziReader.getDominio(idSoggettoErogatore, nomeRegistroForSearch, protocolFactory));
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            infoServizio = null;
                            if (is.isStaticBasedIdentificationMode_InfoProtocol()) {
                                motivoErrore = null;
                                if (idServizio == null || idServizio.getServizio() == null) {
                                    motivoErrore = "servizio";
                                } else if (idServizio.getTipoServizio() == null) {
                                    motivoErrore = "tipoServizio";
                                } else if (idServizio.getSoggettoErogatore() == null || idServizio.getSoggettoErogatore().getNome() == null) {
                                    motivoErrore = "destinatario";
                                } else if (idServizio.getSoggettoErogatore().getTipo() == null) {
                                    motivoErrore = "tipoDestinatario";
                                }
                                if (motivoErrore != null) {
                                    throw new ProtocolException("L'utilizzo della modalita' 'static' per l'identificazione delle funzionalita' di protocollo richiede che i dati su servizio e destinatario (tipo e nome) vengano identificati tramite una modalita' differente da pluginBased");
                                }
                                infoServizio = registroServiziReader.getInfoServizio(idSoggettoFruitore, idServizio, nomeRegistroForSearch, true);
                            } else {
                                infoServizio = new Servizio();
                            }
                            id = null;
                            if (is.isStaticBasedIdentificationMode_IdProtocol()) {
                                motivoErrore = null;
                                if (idServizio.getSoggettoErogatore() == null || idServizio.getSoggettoErogatore().getNome() == null) {
                                    motivoErrore = "destinatario";
                                } else if (idServizio.getSoggettoErogatore().getTipo() == null) {
                                    motivoErrore = "tipoDestinatario";
                                }
                                if (motivoErrore != null) {
                                    throw new ProtocolException("L'utilizzo della modalita' 'static' per la generazione dell'id di protocollo richiede che i dati sul destinatario (tipo e nome) vengano identificati tramite una modalita' differente da pluginBased");
                                }
                                imbustamento = new Imbustamento(protocolFactory);
                                id = imbustamento.buildID(openspcoopstate.getStatoRichiesta(), idSoggettoErogatore, (String)this.msgContext.getPddContext().getObject("ID"), propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), Boolean.valueOf(true));
                            }
                            bustaURLMapping = new Busta(protocolFactory, infoServizio, idSoggettoFruitore, idSoggettoErogatore, id, is.isGenerateListaTrasmissione());
                            tipoOraRegistrazione = propertiesReader.getTipoTempoBusta(null);
                            bustaURLMapping.setTipoOraRegistrazione(tipoOraRegistrazione, traduttore.toString(tipoOraRegistrazione));
                            if (bustaURLMapping.sizeListaTrasmissioni() > 0) {
                                for (Trasmissione trasmissione : bustaURLMapping.getListaTrasmissioni()) {
                                    trasmissione.setTempo(tipoOraRegistrazione, traduttore.toString(tipoOraRegistrazione));
                                }
                            }
                        }
                        catch (Exception e) {
                            openspcoopstate.releaseResource();
                            this.setSOAPFault_processamento(logCore, msgDiag, e, "readProtocolInfo");
                            return;
                        }
                        if (pa != null) {
                            msgDiag.setPorta(pa.getNome());
                        }
                        msgDiag.mediumDebug("Validazione busta ricevuta in corso...");
                        properties = new ProprietaValidazione();
                        readQualifiedAttribute = propertiesReader.isReadQualifiedAttribute("standard");
                        validatore = new Validatore(requestMessage, properties, openspcoopstate.getStatoRichiesta(), readQualifiedAttribute, protocolFactory);
                        msgDiag.mediumDebug("Validazione sintattica busta richiesta...");
                        if (!validatore.validazioneSintattica(bustaURLMapping, Boolean.valueOf(true))) {
                            erroreIntestazione = null;
                            setDestinatarioDefault = true;
                            if (validatore.getBustaErroreHeaderIntestazione() != null) {
                                erroreIntestazione = validatore.getBustaErroreHeaderIntestazione();
                                if (erroreIntestazione.getID() != null) {
                                    msgDiag.setIdMessaggioRichiesta(erroreIntestazione.getID());
                                    this.msgContext.getProtocol().setIdRichiesta(erroreIntestazione.getID());
                                }
                                if (!(protocolManager = protocolFactory.createProtocolManager()).getKeywordMittenteSconosciuto().equals(erroreIntestazione.getDestinatario()) && !protocolManager.getKeywordTipoMittenteSconosciuto().equals(erroreIntestazione.getTipoDestinatario())) {
                                    try {
                                        dominioTmp = configurazionePdDReader.getIdentificativoPorta(new IDSoggetto(erroreIntestazione.getTipoDestinatario(), erroreIntestazione.getDestinatario()), protocolFactory);
                                        if (dominioTmp != null) {
                                            identitaPdD.setCodicePorta(dominioTmp);
                                            identitaPdD.setTipo(erroreIntestazione.getTipoDestinatario());
                                            identitaPdD.setNome(erroreIntestazione.getDestinatario());
                                            setDestinatarioDefault = false;
                                            parametriGenerazioneBustaErrore.setIdentitaPdD(identitaPdD);
                                            parametriInvioBustaErrore.setIdentitaPdD(identitaPdD);
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                if (erroreIntestazione.getMittente() != null && erroreIntestazione.getTipoMittente() != null) {
                                    try {
                                        dominio = registroServiziReader.getDominio(new IDSoggetto(erroreIntestazione.getTipoMittente(), erroreIntestazione.getMittente()), null, protocolFactory);
                                        if (dominio != null) {
                                            erroreIntestazione.setIdentificativoPortaMittente(dominio);
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                if (erroreIntestazione.getDestinatario() != null && erroreIntestazione.getTipoDestinatario() != null) {
                                    try {
                                        dominio = registroServiziReader.getDominio(new IDSoggetto(erroreIntestazione.getTipoDestinatario(), erroreIntestazione.getDestinatario()), null, protocolFactory);
                                        if (dominio != null) {
                                            erroreIntestazione.setIdentificativoPortaDestinatario(dominio);
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                            }
                            try {
                                if (erroreIntestazione != null) {
                                    msgDiag.addKeywords(erroreIntestazione, true);
                                    msgDiag.logPersonalizzato("ricezioneMessaggio");
                                }
                                if (this.msgContext.isTracciamentoAbilitato() && erroreIntestazione != null) {
                                    msgDiag.mediumDebug("Tracciamento busta di richiesta...");
                                    tracciamento = new Tracciamento(identitaPdD, this.msgContext.getIdModulo(), inRequestContext.getPddContext(), this.msgContext.getTipoPorta(), openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
                                    erroreIntestazione.setServizioApplicativoFruitore(servizioApplicativoFruitore);
                                    dettaglioErrore = null;
                                    if (erroreIntestazione != null) {
                                        msgDiag.addKeyword("@ECCEZIONI@", erroreIntestazione.toStringListaEccezioni(protocolFactory));
                                        msgDiag.addKeyword("@TIPO_VALIDAZIONE_BUSTA@", "sintattica");
                                        dettaglioErrore = msgDiag.getMessaggio_replaceKeywords("sbustamentoBusta.", "validazioneNonRiuscita");
                                    }
                                    esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore(dettaglioErrore);
                                    eccezioniRiscontrate = erroreIntestazione.cloneListaEccezioni();
                                    while (erroreIntestazione.sizeListaEccezioni() > 0) {
                                        erroreIntestazione.removeEccezione(0);
                                    }
                                    tracciamento.registraRichiesta(requestMessage, null, validatore.getHeaderProtocollo_senzaControlli(), erroreIntestazione, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                                    while (eccezioniRiscontrate.size() > 0) {
                                        erroreIntestazione.addEccezione((Eccezione)eccezioniRiscontrate.remove(0));
                                    }
                                }
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "TracciamentoBustaMalformata");
                                logCore.error((Object)"Riscontrato errore durante il tracciamento della busta malformata ricevuta", (Throwable)e);
                            }
                            if (erroreIntestazione != null) {
                                msgDiag.addKeyword("@ECCEZIONI@", erroreIntestazione.toStringListaEccezioni(protocolFactory));
                                msgDiag.addKeyword("@TIPO_VALIDAZIONE_BUSTA@", "sintattica");
                                msgDiag.logPersonalizzato("sbustamentoBusta.", "validazioneNonRiuscita");
                                if (this.msgContext.isGestioneRisposta()) {
                                    if (setDestinatarioDefault) {
                                        erroreIntestazione.setDestinatario(identitaPdD.getNome());
                                        erroreIntestazione.setTipoDestinatario(identitaPdD.getTipo());
                                        erroreIntestazione.setIdentificativoPortaDestinatario(identitaPdD.getCodicePorta());
                                    }
                                    tracciamento = new Tracciamento(identitaPdD, this.msgContext.getIdModulo(), inRequestContext.getPddContext(), this.msgContext.getTipoPorta(), openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
                                    parametriGenerazioneBustaErrore.setTracciamento(tracciamento);
                                    parametriGenerazioneBustaErrore.setBusta(erroreIntestazione);
                                    parametriGenerazioneBustaErrore.setError(erroreIntestazione.cloneListaEccezioni());
                                    errorOpenSPCoopMsg = this.generaBustaErroreValidazione(parametriGenerazioneBustaErrore);
                                    parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                    this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                }
                            } else {
                                try {
                                    msgDiag.addKeyword("@ECCEZIONI@", validatore.getErrore().getDescrizione(protocolFactory));
                                }
                                catch (Exception e) {
                                    logCore.error((Object)("getDescrizione Error:" + e.getMessage()), (Throwable)e);
                                }
                                msgDiag.addKeyword("@TIPO_VALIDAZIONE_BUSTA@", "sintattica");
                                msgDiag.logPersonalizzato("sbustamentoBusta.", "validazioneNonRiuscita");
                                this.setSOAPFault_intestazione(validatore.getErrore());
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                        soggettoFruitore = validatore.getSoggettoMittente();
                        idServizio = validatore.getIDServizio();
                        soapHeaderElement = validatore.getHeaderProtocollo();
                        msgDiag.setIdMessaggioRichiesta(validatore.getBusta().getID());
                        this.msgContext.setIdMessage(validatore.getBusta().getID());
                        msgDiag.setFruitore(soggettoFruitore);
                        msgDiag.setServizio(idServizio);
                        msgDiag.setDelegata(false);
                        msgDiag.addKeywords(validatore.getBusta(), true);
                        parametriGenerazioneBustaErrore.setMsgDiag(msgDiag);
                        parametriInvioBustaErrore.setMsgDiag(msgDiag);
                        functionAsRouter = false;
                        msgDiag.mediumDebug("Esamina modalita' di ricezione (PdD/Router)...");
                        existsSoggetto = false;
                        try {
                            existsSoggetto = configurazionePdDReader.existsSoggetto(idServizio.getSoggettoErogatore());
                        }
                        catch (Exception e) {
                            openspcoopstate.releaseResource();
                            this.setSOAPFault_processamento(logCore, msgDiag, e, "existsSoggetto(" + idServizio.getSoggettoErogatore().toString() + ")");
                            return;
                        }
                        if (!existsSoggetto) {
                            msgDiag.mediumDebug("Raccolta identita router...");
                            routerFunctionActive = false;
                            try {
                                routerFunctionActive = configurazionePdDReader.routerFunctionActive();
                            }
                            catch (Exception e) {
                                openspcoopstate.releaseResource();
                                this.setSOAPFault_processamento(logCore, msgDiag, e, "ErroreCheckFunzionalitaRouterAttiva");
                                return;
                            }
                            if (routerFunctionActive) {
                                functionAsRouter = true;
                                try {
                                    identitaPdD = configurazionePdDReader.getRouterIdentity(protocolFactory);
                                }
                                catch (Exception e) {
                                    openspcoopstate.releaseResource();
                                    this.setSOAPFault_processamento(logCore, msgDiag, e, "ErroreRiconoscimentoIdentitaRouter");
                                    return;
                                }
                            }
                        } else {
                            msgDiag.mediumDebug("Raccolta identita porta di dominio...");
                            dominio = null;
                            try {
                                dominio = configurazionePdDReader.getIdentificativoPorta(idServizio.getSoggettoErogatore(), protocolFactory);
                                if (dominio == null) {
                                    throw new Exception("Dominio is null");
                                }
                            }
                            catch (Exception e) {
                                openspcoopstate.releaseResource();
                                this.setSOAPFault_processamento(logCore, msgDiag, e, "ErroreRiconoscimentoIdentitaPdD");
                                return;
                            }
                            identitaPdD = new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), dominio);
                        }
                        if (functionAsRouter) {
                            this.msgContext.setTipoPorta(TipoPdD.ROUTER);
                        }
                        parametriGenerazioneBustaErrore.setIdentitaPdD(identitaPdD);
                        parametriInvioBustaErrore.setIdentitaPdD(identitaPdD);
                        parametriInvioBustaErrore.setFunctionAsRouter(functionAsRouter);
                        msgDiag.setDominio(identitaPdD);
                        parametriGenerazioneBustaErrore.setMsgDiag(msgDiag);
                        parametriInvioBustaErrore.setMsgDiag(msgDiag);
                        tracciamento = new Tracciamento(identitaPdD, this.msgContext.getIdModulo(), inRequestContext.getPddContext(), this.msgContext.getTipoPorta(), openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
                        parametriGenerazioneBustaErrore.setTracciamento(tracciamento);
                        bustaRichiesta = validatore.getBusta();
                        Utilities.refreshIdentificativiPorta(bustaRichiesta, propertiesReader.getIdentitaPortaDefault(protocollo), registroServiziReader, protocolFactory);
                        if (soggettoFruitore != null && soggettoFruitore.getCodicePorta() == null) {
                            soggettoFruitore.setCodicePorta(bustaRichiesta.getIdentificativoPortaMittente());
                        }
                        if (idServizio != null && idServizio.getSoggettoErogatore() != null && idServizio.getSoggettoErogatore().getCodicePorta() == null) {
                            idServizio.getSoggettoErogatore().setCodicePorta(bustaRichiesta.getIdentificativoPortaDestinatario());
                        }
                        if (servizioApplicativoFruitore != null) {
                            bustaRichiesta.setServizioApplicativoFruitore(servizioApplicativoFruitore);
                        }
                        idMessageRequest = bustaRichiesta.getID();
                        tipoPorta = TipoPdD.APPLICATIVA;
                        if (functionAsRouter) {
                            tipoPorta = TipoPdD.ROUTER;
                        }
                        this.msgContext.getProtocol().setDominio(identitaPdD);
                        this.msgContext.setIdentitaPdD(identitaPdD);
                        this.msgContext.setTipoPorta(tipoPorta);
                        this.msgContext.getProtocol().setFruitore(soggettoFruitore);
                        if (bustaRichiesta != null) {
                            this.msgContext.getProtocol().setIndirizzoFruitore(bustaRichiesta.getIndirizzoMittente());
                        }
                        this.msgContext.getProtocol().setErogatore(idServizio.getSoggettoErogatore());
                        if (bustaRichiesta != null) {
                            this.msgContext.getProtocol().setIndirizzoErogatore(bustaRichiesta.getIndirizzoDestinatario());
                        }
                        this.msgContext.getProtocol().setTipoServizio(idServizio.getTipoServizio());
                        this.msgContext.getProtocol().setServizio(idServizio.getServizio());
                        this.msgContext.getProtocol().setVersioneServizio(idServizio.getVersioneServizioAsInt());
                        this.msgContext.getProtocol().setAzione(idServizio.getAzione());
                        this.msgContext.getProtocol().setIdRichiesta(idMessageRequest);
                        this.msgContext.getProtocol().setProfiloCollaborazione(bustaRichiesta.getProfiloDiCollaborazione(), bustaRichiesta.getProfiloDiCollaborazioneValue());
                        this.msgContext.getProtocol().setCollaborazione(bustaRichiesta.getCollaborazione());
                        if (!StatoServiziPdD.isEnabled(RicezioneBuste.isActivePAService, RicezioneBuste.listaAbilitazioniPAService, RicezioneBuste.listaDisabilitazioniPAService, soggettoFruitore, idServizio)) {
                            logCore.error((Object)"[RicezioneBuste]  Servizio di ricezione buste disabilitato");
                            msgDiag.logErroreGenerico("Servizio di ricezione buste disabilitato", "PA");
                            if (this.msgContext.isTracciamentoAbilitato()) {
                                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)"[RicezioneBuste]  Servizio di ricezione buste disabilitato");
                                tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                            }
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento("[RicezioneBuste]  Servizio di ricezione buste disabilitato", CodiceErroreIntegrazione.CODICE_551_PA_SERVICE_NOT_ACTIVE));
                                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, null);
                                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                        try {
                            msgDiag.mediumDebug("Aggiornamento del messaggio");
                            requestMessage = protocolFactory.createProtocolManager().updateOpenSPCoop2MessageRequest(requestMessage.getVersioneSoap(), requestMessage, bustaRichiesta);
                        }
                        catch (Exception e) {
                            msgDiag.logPersonalizzato("ricezioneMessaggio");
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", "Aggiornamento messaggio fallito, " + e.getMessage());
                            msgDiag.logErroreGenerico(e, "ProtocolManager.updateOpenSPCoop2Message");
                            logCore.error((Object)("ProtocolManager.updateOpenSPCoop2Message error: " + e.getMessage()), (Throwable)e);
                            if (this.msgContext.isTracciamentoAbilitato()) {
                                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("ProtocolManager.updateOpenSPCoop2Message, non riuscito: " + e.getMessage()));
                                tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                            }
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO));
                                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                        messageSecurityContext = null;
                        flowPropertiesRequest = null;
                        flowPropertiesResponse = null;
                        newConnectionForResponse = false;
                        utilizzoIndirizzoTelematico = false;
                        ruoloBustaRicevuta = null;
                        if (!functionAsRouter) {
                            if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                                newConnectionForResponse = configurazionePdDReader.newConnectionForResponse();
                                utilizzoIndirizzoTelematico = configurazionePdDReader.isUtilizzoIndirizzoTelematico();
                                parametriInvioBustaErrore.setNewConnectionForResponse(newConnectionForResponse);
                                parametriInvioBustaErrore.setUtilizzoIndirizzoTelematico(utilizzoIndirizzoTelematico);
                            }
                            if (!validatore.isErroreProtocollo() && !validatore.isBustaDiServizio()) {
                                try {
                                    scadenzaControllo = DateManager.getTimeMillis() + propertiesReader.getTimeoutBustaRispostaAsincrona();
                                    checkIntervalControllo = propertiesReader.getCheckIntervalBustaRispostaAsincrona();
                                    attendiTerminazioneRichiesta = this.gestioneRispostaAsincrona_checkPresenzaRichiesta(scadenzaControllo, checkIntervalControllo, bustaRichiesta, openspcoopstate, msgDiag, newConnectionForResponse, inRequestContext.getPddContext());
                                    attendiTerminazioneRicevutaRichiesta = this.gestioneRispostaAsincrona_checkPresenzaRicevutaRichiesta(scadenzaControllo, checkIntervalControllo, bustaRichiesta, openspcoopstate, msgDiag, newConnectionForResponse, inRequestContext.getPddContext());
                                    msgErroreIntegrazione = null;
                                    motivoErrore = null;
                                    if (attendiTerminazioneRichiesta) {
                                        msgDiag.logPersonalizzato("attesaFineProcessamento.richiestaAsincrona.timeoutScaduto");
                                        msgErroreIntegrazione = ErroriIntegrazione.ERRORE_538_RICHIESTA_ASINCRONA_ANCORA_IN_PROCESSAMENTO.getErroreIntegrazione();
                                    } else if (attendiTerminazioneRicevutaRichiesta) {
                                        msgDiag.logPersonalizzato("attesaFineProcessamento.ricevutaRichiestaAsincrona.timeoutScaduto");
                                        msgErroreIntegrazione = ErroriIntegrazione.ERRORE_539_RICEVUTA_RICHIESTA_ASINCRONA_ANCORA_IN_PROCESSAMENTO.getErroreIntegrazione();
                                    }
                                    if (attendiTerminazioneRichiesta || attendiTerminazioneRicevutaRichiesta) {
                                        if (this.msgContext.isTracciamentoAbilitato()) {
                                            esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore(motivoErrore);
                                            tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                                        }
                                        if (this.msgContext.isGestioneRisposta()) {
                                            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                            parametriGenerazioneBustaErrore.setErroreIntegrazione(msgErroreIntegrazione);
                                            errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, null);
                                            parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                            this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                        }
                                        openspcoopstate.releaseResource();
                                        return;
                                    }
                                }
                                catch (Exception e) {
                                    msgDiag.logPersonalizzato("ricezioneMessaggio");
                                    msgDiag.logErroreGenerico(e, "checkPresenzaRichiestaRicevutaAsincronaAncoraInGestione");
                                    logCore.error((Object)"Controllo presenza richieste/ricevuteRichieste ancora in gestione correlate alla risposta/richiesta-stato asincrona simmetrica/asimmetrica arrivata, non riuscito", (Throwable)e);
                                    if (this.msgContext.isTracciamentoAbilitato()) {
                                        esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Controllo presenza richieste/ricevuteRichieste ancora in gestione correlate alla risposta/richiesta-stato asincrona simmetrica/asimmetrica arrivata, non riuscito: " + e.getMessage()));
                                        tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                                    }
                                    if (this.msgContext.isGestioneRisposta()) {
                                        parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                        parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                                        errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                        parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                        parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                        this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                    }
                                    openspcoopstate.releaseResource();
                                    return;
                                }
                            }
                            try {
                                ruoloBustaRicevuta = validatore.getRuoloBustaRicevuta(false);
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "validator.getRuoloBustaRicevuta(false)");
                            }
                        }
                        implementazionePdDMittente = null;
                        implementazionePdDDestinatario = null;
                        idPdDMittente = null;
                        idPdDDestinatario = null;
                        msgDiag.mediumDebug("Ricerca implementazione della porta di dominio dei soggetti...");
                        proprietaManifestAttachments = null;
                        validazioneIDBustaCompleta = true;
                        try {
                            implementazionePdDMittente = registroServiziReader.getImplementazionePdD(soggettoFruitore, null);
                            implementazionePdDDestinatario = registroServiziReader.getImplementazionePdD(idServizio.getSoggettoErogatore(), null);
                            idPdDMittente = registroServiziReader.getIdPortaDominio(soggettoFruitore, null);
                            idPdDDestinatario = registroServiziReader.getIdPortaDominio(idServizio.getSoggettoErogatore(), null);
                            parametriGenerazioneBustaErrore.setImplementazionePdDMittente(implementazionePdDMittente);
                            parametriGenerazioneBustaErrore.setImplementazionePdDDestinatario(implementazionePdDDestinatario);
                            parametriInvioBustaErrore.setImplementazionePdDMittente(implementazionePdDMittente);
                            parametriInvioBustaErrore.setImplementazionePdDDestinatario(implementazionePdDDestinatario);
                            properties.setValidazioneConSchema(configurazionePdDReader.isLivelloValidazioneRigido(implementazionePdDMittente));
                            properties.setValidazioneProfiloCollaborazione(configurazionePdDReader.isValidazioneProfiloCollaborazione(implementazionePdDMittente));
                            validatore.setProprietaValidazione(properties);
                            contextParameters = new MessageSecurityContextParameters();
                            contextParameters.setUseActorDefaultIfNotDefined(propertiesReader.isGenerazioneActorDefault(implementazionePdDMittente));
                            contextParameters.setActorDefault(propertiesReader.getActorDefault(implementazionePdDMittente));
                            contextParameters.setLog(logCore);
                            contextParameters.setFunctionAsClient(false);
                            contextParameters.setPrefixWsuId(propertiesReader.getPrefixWsuId());
                            contextParameters.setIdFruitore(soggettoFruitore);
                            contextParameters.setPddFruitore(idPdDMittente);
                            contextParameters.setIdServizio(idServizio);
                            contextParameters.setPddErogatore(idPdDDestinatario);
                            messageSecurityContext = new MessageSecurityFactory().getMessageSecurityContext(contextParameters);
                            parametriGenerazioneBustaErrore.setMessageSecurityContext(messageSecurityContext);
                            proprietaManifestAttachments = propertiesReader.getProprietaManifestAttachments(implementazionePdDMittente);
                            readQualifiedAttribute = propertiesReader.isReadQualifiedAttribute(implementazionePdDMittente);
                            validazioneIDBustaCompleta = propertiesReader.isValidazioneIDBustaCompleta(implementazionePdDMittente);
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "ricercaImplementazionePdDSoggettiBusta");
                            if (this.msgContext.isTracciamentoAbilitato()) {
                                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Errore durante la ricerca dell'implementazione della porta di dominio dei soggetti: " + e.getMessage()));
                                tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                            }
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                        msgDiag.mediumDebug("ImplementazionePdD soggetto (" + soggettoFruitore.toString() + ") e' [" + implementazionePdDMittente + "], soggetto (" + idServizio.getSoggettoErogatore().toString() + ") e' [" + implementazionePdDDestinatario + "]");
                        pd = null;
                        servizioApplicativoErogatoreAsincronoSimmetricoRisposta = null;
                        if (!functionAsRouter) {
                            msgDiag.mediumDebug("Lettura porta applicativa/delegata...");
                            try {
                                if ((ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) && !RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                                    msgDiag.highDebug("Lettura porta applicativa/delegata (Asincrono)...");
                                    profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta(), protocolFactory);
                                    if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                                        repository = new RepositoryBuste(openspcoopstate.getStatoRichiesta(), true, protocolFactory);
                                        integrazione = null;
                                        integrazione = bustaRichiesta.getRiferimentoMessaggio() != null ? repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio()) : repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getCollaborazione());
                                        servizioApplicativoErogatoreAsincronoSimmetricoRisposta = integrazione.getServizioApplicativo();
                                        idPD = new IDPortaDelegata();
                                        idPD.setLocationPD(integrazione.getLocationPD());
                                        idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                                        pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                                    } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                                        if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                            idServizioOriginale = null;
                                            idServizioOriginale = bustaRichiesta.getRiferimentoMessaggio() != null ? profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getRiferimentoMessaggio()) : profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getCollaborazione());
                                            idServizioOriginale.setSoggettoErogatore(idServizio.getSoggettoErogatore());
                                            if (pa == null && (idByNome = configurazionePdDReader.convertTo_SafeMethod(idServizioOriginale, this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                                                pa = configurazionePdDReader.getPortaApplicativa_SafeMethod(idByNome);
                                            }
                                        } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                            repository = new RepositoryBuste(openspcoopstate.getStatoRichiesta(), true, protocolFactory);
                                            integrazione = null;
                                            integrazione = bustaRichiesta.getRiferimentoMessaggio() != null ? repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio()) : repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getCollaborazione());
                                            idPD = new IDPortaDelegata();
                                            idPD.setLocationPD(integrazione.getLocationPD());
                                            idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                                            pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                                        }
                                    }
                                    ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                                } else {
                                    msgDiag.highDebug("Lettura porta applicativa/delegata (Normale)...");
                                    if (pa == null && (idByNome = configurazionePdDReader.convertTo_SafeMethod(idServizio, this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                                        pa = configurazionePdDReader.getPortaApplicativa_SafeMethod(idByNome);
                                    }
                                }
                                msgDiag.highDebug("Lettura porta applicativa/delegata (Set)...");
                                properties.setValidazioneManifestAttachments(configurazionePdDReader.isValidazioneManifestAttachments(implementazionePdDMittente) != false && configurazionePdDReader.isGestioneManifestAttachments(pa, protocolFactory) != false);
                                msgDiag.highDebug("Lettura porta applicativa/delegata terminato");
                            }
                            catch (Exception e) {
                                if (e instanceof DriverConfigurazioneNotFound) break block585;
                                msgDiag.logErroreGenerico(e, "letturaPorta");
                                if (this.msgContext.isTracciamentoAbilitato()) {
                                    esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Errore durante la lettura della porta applicativa/delegata: " + e.getMessage()));
                                    tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                                }
                                if (this.msgContext.isGestioneRisposta()) {
                                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                    parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                                    errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                    parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                    this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                }
                                openspcoopstate.releaseResource();
                                return;
                            }
                        }
                    }
                    idPAbyNome = null;
                    if (pa != null) {
                        idPAbyNome = new IDPortaApplicativaByNome();
                        idPAbyNome.setNome(pa.getNome());
                        idPAbyNome.setSoggetto(idServizio.getSoggettoErogatore());
                        msgDiag.setPorta(pa.getNome());
                        for (i = 0; i < pa.sizeServizioApplicativoList(); ++i) {
                            this.msgContext.getIntegrazione().addServizioApplicativoErogatore(pa.getServizioApplicativo(i).getNome());
                        }
                    } else if (servizioApplicativoErogatoreAsincronoSimmetricoRisposta != null) {
                        this.msgContext.getIntegrazione().addServizioApplicativoErogatore(servizioApplicativoErogatoreAsincronoSimmetricoRisposta);
                    }
                    msgDiag.highDebug("Lettura porta applicativa/delegata terminato impostazione context");
                    idModuloInAttesa = null;
                    if (this.msgContext.isGestioneRisposta()) {
                        idModuloInAttesa = this.msgContext.getIdModulo();
                    }
                    richiestaApplicativa = new RichiestaApplicativa(soggettoFruitore, idServizio, idModuloInAttesa, identitaPdD, idPAbyNome);
                    richiestaApplicativa.setFiltroProprietaPorteApplicative(this.msgContext.getProprietaFiltroPortaApplicativa());
                    try {
                        protocolConfiguration = protocolFactory.createProtocolConfiguration();
                        if (bustaRichiesta.getProfiloDiCollaborazione() != null && !ProfiloDiCollaborazione.UNKNOWN.equals(bustaRichiesta.getProfiloDiCollaborazione()) && !protocolConfiguration.isSupportato(bustaRichiesta.getProfiloDiCollaborazione())) {
                            throw new Exception("Profilo di Collaborazione [" + bustaRichiesta.getProfiloDiCollaborazione().getEngineValue() + "]");
                        }
                        if (bustaRichiesta.getScadenza() != null && !protocolConfiguration.isSupportato(FunzionalitaProtocollo.SCADENZA)) {
                            throw new Exception(FunzionalitaProtocollo.SCADENZA.getEngineValue());
                        }
                        if (configurazionePdDReader.isGestioneManifestAttachments(pa, protocolFactory) && !protocolConfiguration.isSupportato(FunzionalitaProtocollo.MANIFEST_ATTACHMENTS)) {
                            throw new Exception(FunzionalitaProtocollo.MANIFEST_ATTACHMENTS.getEngineValue());
                        }
                    }
                    catch (Exception e) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                        msgDiag.logPersonalizzato("sbustamentoBusta.", "protocolli.funzionalita.unsupported");
                        if (this.msgContext.isTracciamentoAbilitato()) {
                            esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)msgDiag.getMessaggio_replaceKeywords("protocolli.funzionalita.unsupported"));
                            tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                        }
                        if (this.msgContext.isGestioneRisposta()) {
                            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                            parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_439_FUNZIONALITA_NOT_SUPPORTED_BY_PROTOCOL.getErrore439_FunzionalitaNotSupportedByProtocol(e.getMessage(), protocolFactory));
                            errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                            parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                            this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                        }
                        openspcoopstate.releaseResource();
                        return;
                    }
                    tipiIntegrazionePA = null;
                    msgDiag.mediumDebug("Header integrazione...");
                    if (propertiesReader.processHeaderIntegrazionePARequest(functionAsRouter)) {
                        if (functionAsRouter) {
                            msgDiag.highDebug("Header integrazione (Default gestori integrazione Router)");
                            tipiIntegrazionePA = RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.containsKey(protocolFactory.getProtocol()) ? RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.get(protocolFactory.getProtocol()) : RicezioneBuste.defaultGestoriIntegrazionePA;
                        } else {
                            msgDiag.highDebug("Header integrazione (Gestori integrazione...)");
                            if (pa != null && this.msgContext.isTracciamentoAbilitato()) {
                                msgDiag.mediumDebug("Lettura header di integrazione...");
                                try {
                                    tipiIntegrazionePA = configurazionePdDReader.getTipiIntegrazione(pa);
                                }
                                catch (Exception e) {
                                    msgDiag.logErroreGenerico(e, "configurazionePdDReader.getTipiIntegrazione(pa)");
                                    if (this.msgContext.isTracciamentoAbilitato()) {
                                        esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Errore durante la lettura delle configurazioni dei tipi di integrazione con la  porta applicativa/delegata: " + e.getMessage()));
                                        tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                                    }
                                    if (this.msgContext.isGestioneRisposta()) {
                                        parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                        parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                                        errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                        parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                        parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                        this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                    }
                                    openspcoopstate.releaseResource();
                                    return;
                                }
                            }
                            msgDiag.highDebug("Header integrazione (Gestori integrazione terminato)");
                            if (tipiIntegrazionePA == null) {
                                tipiIntegrazionePA = RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.containsKey(protocolFactory.getProtocol()) != false ? RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.get(protocolFactory.getProtocol()) : RicezioneBuste.defaultGestoriIntegrazionePA;
                            }
                        }
                    }
                    headerIntegrazioneRichiesta = new HeaderIntegrazione();
                    inRequestPAMessage = null;
                    if (tipiIntegrazionePA != null) {
                        msgDiag.highDebug("Header integrazione (Impostazione ...)");
                        inRequestPAMessage = new InRequestPAMessage();
                        inRequestPAMessage.setBustaRichiesta(bustaRichiesta);
                        inRequestPAMessage.setMessage(requestMessage);
                        inRequestPAMessage.setUrlProtocolContext(this.msgContext.getUrlProtocolContext());
                        inRequestPAMessage.setPortaApplicativa(pa);
                        inRequestPAMessage.setServizio(idServizio);
                        inRequestPAMessage.setSoggettoMittente(soggettoFruitore);
                        for (i = 0; i < tipiIntegrazionePA.length; ++i) {
                            try {
                                classType = null;
                                gestore = null;
                                try {
                                    classType = className.getIntegrazionePortaApplicativa(tipiIntegrazionePA[i]);
                                    gestore = (IGestoreIntegrazionePA)loader.newInstance(classType);
                                    AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                                }
                                catch (Exception e) {
                                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + tipiIntegrazionePA[i] + "]: " + e.getMessage());
                                }
                                if (gestore == null) {
                                    msgDiag.logErroreGenerico("Gestore [" + tipiIntegrazionePA[i] + "], per la lettura dell'header di integrazione, non inizializzato", "gestoriIntegrazionePASoap.get(" + tipiIntegrazionePA[i] + ")");
                                    continue;
                                }
                                if (!(gestore instanceof IGestoreIntegrazionePASoap)) continue;
                                ((IGestoreIntegrazionePASoap)gestore).readInRequestHeader(headerIntegrazioneRichiesta, inRequestPAMessage);
                                continue;
                            }
                            catch (Exception e) {
                                msgDiag.addKeyword("@TIPO_HEADER_INTEGRAZIONE@", tipiIntegrazionePA[i]);
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.toString());
                                msgDiag.logPersonalizzato("headerIntegrazione.letturaFallita");
                            }
                        }
                        if (headerIntegrazioneRichiesta != null) {
                            msgDiag.highDebug("Header integrazione (set context...)");
                            servizioApplicativoFruitore = this.msgContext.getIdentitaServizioApplicativoFruitore() != null ? this.msgContext.getIdentitaServizioApplicativoFruitore() : headerIntegrazioneRichiesta.getServizioApplicativo();
                            parametriGenerazioneBustaErrore.setServizioApplicativoFruitore(servizioApplicativoFruitore);
                            parametriInvioBustaErrore.setServizioApplicativoFruitore(servizioApplicativoFruitore);
                            correlazioneApplicativa = this.msgContext.getIdCorrelazioneApplicativa() != null ? this.msgContext.getIdCorrelazioneApplicativa() : headerIntegrazioneRichiesta.getIdApplicativo();
                            parametriGenerazioneBustaErrore.setCorrelazioneApplicativa(correlazioneApplicativa);
                            parametriInvioBustaErrore.setCorrelazioneApplicativa(correlazioneApplicativa);
                            msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", servizioApplicativoFruitore);
                            msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", correlazioneApplicativa);
                            this.msgContext.getIntegrazione().setIdCorrelazioneApplicativa(correlazioneApplicativa);
                            this.msgContext.getIntegrazione().setServizioApplicativoFruitore(servizioApplicativoFruitore);
                            bustaRichiesta.setServizioApplicativoFruitore(servizioApplicativoFruitore);
                            msgDiag.highDebug("Header integrazione (set context ok)");
                        }
                    }
                    if (RicezioneBuste.tipiGestoriCredenziali != null) {
                        msgDiag.mediumDebug("Gestione personalizzata delle credenziali...");
                        for (i = 0; i < RicezioneBuste.tipiGestoriCredenziali.length; ++i) {
                            try {
                                gestore = null;
                                classType = null;
                                try {
                                    classType = className.getGestoreCredenziali(RicezioneBuste.tipiGestoriCredenziali[i]);
                                    gestore = (IGestoreCredenziali)loader.newInstance(classType);
                                    AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                                }
                                catch (Exception e) {
                                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione delle credenziali di tipo [" + RicezioneBuste.tipiGestoriCredenziali[i] + "]: " + e.getMessage());
                                }
                                if (gestore != null) {
                                    credenzialiRitornate = gestore.elaborazioneCredenziali(inRequestContext.getConnettore(), requestMessage);
                                    if (credenzialiRitornate == null) {
                                        throw new Exception("Credenziali non ritornate");
                                    }
                                    if (!inRequestContext.getConnettore().getCredenziali().equals(credenzialiRitornate)) {
                                        nuoveCredenziali = credenzialiRitornate.toString();
                                        nuoveCredenziali = nuoveCredenziali.substring(0, nuoveCredenziali.length() - 1);
                                        msgDiag.addKeyword("@NUOVE_CREDENZIALI@", nuoveCredenziali);
                                        identita = gestore.getIdentitaGestoreCredenziali();
                                        if (identita == null) {
                                            identita = "Gestore delle credenziali di tipo " + RicezioneBuste.tipiGestoriCredenziali[i];
                                        }
                                        msgDiag.addKeyword("@IDENTITA_GESTORE_CREDENZIALI@", identita);
                                        msgDiag.logPersonalizzato("gestoreCredenziali.nuoveCredenziali");
                                        inRequestContext.getConnettore().setCredenziali(credenzialiRitornate);
                                        credenziali = credenzialiRitornate;
                                        this.setCredenziali(credenziali, msgDiag);
                                    }
                                    continue;
                                }
                                throw new Exception("non inizializzato");
                            }
                            catch (Exception e) {
                                logCore.error((Object)("Errore durante l'identificazione delle credenziali [" + RicezioneBuste.tipiGestoriCredenziali[i] + "]: " + e.getMessage()), (Throwable)e);
                                msgDiag.addKeyword("@TIPO_GESTORE_CREDENZIALI@", RicezioneBuste.tipiGestoriCredenziali[i]);
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                                msgDiag.logPersonalizzato("gestoreCredenziali.errore");
                                msgErroreIntegrazione = null;
                                msgErroreIntegrazione = e instanceof GestoreCredenzialiConfigurationException != false ? ErroriIntegrazione.ERRORE_431_GESTORE_CREDENZIALI_ERROR.getErrore431_ErroreGestoreCredenziali(RicezioneBuste.tipiGestoriCredenziali[i], e) : ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_548_GESTORE_CREDENZIALI_NON_FUNZIONANTE);
                                if (this.msgContext.isTracciamentoAbilitato()) {
                                    esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)msgDiag.getMessaggio_replaceKeywords("gestoreCredenziali.errore"));
                                    tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                                }
                                if (this.msgContext.isGestioneRisposta()) {
                                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                    parametriGenerazioneBustaErrore.setErroreIntegrazione(msgErroreIntegrazione);
                                    errorMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                    parametriInvioBustaErrore.setOpenspcoopMsg(errorMsg);
                                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                    this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                }
                                openspcoopstate.releaseResource();
                                return;
                            }
                        }
                    }
                    oneWayStateless = false;
                    oneWayVersione11 = false;
                    sincronoStateless = false;
                    asincronoStateless = false;
                    portaStateless = false;
                    routingStateless = false;
                    try {
                        if (!functionAsRouter) {
                            if (!propertiesReader.isServerJ2EE()) {
                                oneWayStateless = true;
                                sincronoStateless = true;
                                asincronoStateless = true;
                            } else if (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                                oneWayStateless = configurazionePdDReader.isModalitaStateless(pa, bustaRichiesta.getProfiloDiCollaborazione());
                            } else if (ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                                sincronoStateless = configurazionePdDReader.isModalitaStateless(pa, bustaRichiesta.getProfiloDiCollaborazione());
                            } else if ((ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) && !RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString()) && !RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                asincronoStateless = ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) != false && pd != null ? configurazionePdDReader.isModalitaStateless(pd, bustaRichiesta.getProfiloDiCollaborazione()) : configurazionePdDReader.isModalitaStateless(pa, bustaRichiesta.getProfiloDiCollaborazione());
                            }
                            v0 = oneWayVersione11 = propertiesReader.isGestioneOnewayStateful_1_1() != false && ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) != false && oneWayStateless == false;
                            if (oneWayStateless || sincronoStateless || asincronoStateless || oneWayVersione11) {
                                portaStateless = true;
                                if (!oneWayVersione11) {
                                    this.msgContext.getIntegrazione().setGestioneStateless(true);
                                } else {
                                    this.msgContext.getIntegrazione().setGestioneStateless(false);
                                }
                            } else {
                                this.msgContext.getIntegrazione().setGestioneStateless(false);
                            }
                        } else {
                            routingStateless = CostantiConfigurazione.ABILITATO.equals(propertiesReader.getStatelessRouting());
                            this.msgContext.getIntegrazione().setGestioneStateless(routingStateless);
                        }
                        parametriInvioBustaErrore.setOnewayVersione11(oneWayVersione11);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "AnalisiModalitaGestioneStatefulStateless");
                        logCore.error((Object)("Analisi modalita di gestione STATEFUL/STATELESS non riuscita: " + e));
                        if (this.msgContext.isGestioneRisposta()) {
                            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                            parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                            errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                            parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                            this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                        }
                        openspcoopstate.releaseResource();
                        return;
                    }
                    if (!(ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || oneWayStateless || sincronoStateless || asincronoStateless || routingStateless)) {
                        newConnectionForResponse = configurazionePdDReader.newConnectionForResponse();
                    }
                    parametriInvioBustaErrore.setNewConnectionForResponse(newConnectionForResponse);
                    if (!(oneWayStateless || sincronoStateless || asincronoStateless || routingStateless)) {
                        utilizzoIndirizzoTelematico = configurazionePdDReader.isUtilizzoIndirizzoTelematico();
                    }
                    parametriInvioBustaErrore.setUtilizzoIndirizzoTelematico(utilizzoIndirizzoTelematico);
                    if (routingStateless) {
                        openspcoopstate.releaseResource();
                    }
                    infoIntegrazione = new Integrazione();
                    infoIntegrazione.setIdModuloInAttesa(this.msgContext.getIdModulo());
                    infoIntegrazione.setStateless(portaStateless);
                    parametriGenerazioneBustaErrore.setIntegrazione(infoIntegrazione);
                    try {
                        inRequestProtocolContext = new InRequestProtocolContext(inRequestContext);
                        if (inRequestProtocolContext.getConnettore() != null) {
                            inRequestProtocolContext.getConnettore().setCredenziali(credenziali);
                        }
                        inRequestProtocolContext.setProtocollo(this.msgContext.getProtocol());
                        inRequestProtocolContext.setIntegrazione(this.msgContext.getIntegrazione());
                        GestoreHandlers.inRequestProtocol(inRequestProtocolContext, msgDiag, logCore);
                    }
                    catch (Exception e) {
                        if (e instanceof HandlerException) {
                            he = (HandlerException)e;
                            msgDiag.logErroreGenerico(e, he.getIdentitaHandler());
                            logCore.error((Object)("Gestione InRequestProtocolHandler non riuscita (" + he.getIdentitaHandler() + "): " + he));
                        } else {
                            msgDiag.logErroreGenerico(e, "InvocazioneInRequestHandler");
                            logCore.error((Object)("Gestione InRequestProtocolHandler non riuscita: " + e));
                        }
                        if (this.msgContext.isGestioneRisposta()) {
                            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                            parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                            errorMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                            parametriInvioBustaErrore.setOpenspcoopMsg(errorMsg);
                            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                            this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                        }
                        openspcoopstate.releaseResource();
                        return;
                    }
                    if (!functionAsRouter) {
                        msgDiag.mediumDebug("Raccolta FlowParameter MTOM / Security proprieta...");
                        mtomProcessor = null;
                        try {
                            flowPropertiesRequest = this.getFlowPropertiesRequest(bustaRichiesta, configurazionePdDReader, (StateMessage)openspcoopstate.getStatoRichiesta(), msgDiag, logCore, propertiesReader, ruoloBustaRicevuta, implementazionePdDMittente, inRequestContext.getPddContext(), pa);
                            flowPropertiesResponse = this.getFlowPropertiesResponse(bustaRichiesta, configurazionePdDReader, (StateMessage)openspcoopstate.getStatoRichiesta(), msgDiag, logCore, propertiesReader, ruoloBustaRicevuta, implementazionePdDMittente, inRequestContext.getPddContext(), pa);
                            parametriGenerazioneBustaErrore.setFlowPropertiesResponse(flowPropertiesResponse);
                            if (flowPropertiesRequest != null && flowPropertiesRequest.messageSecurity != null && flowPropertiesRequest.messageSecurity.getFlowParameters() != null && flowPropertiesRequest.messageSecurity.getFlowParameters().size() > 0) {
                                messageSecurityContext.setIncomingProperties(flowPropertiesRequest.messageSecurity.getFlowParameters());
                            }
                            mtomProcessor = new MTOMProcessor(flowPropertiesRequest.mtom, flowPropertiesRequest.messageSecurity, tipoPorta);
                        }
                        catch (Exception e) {
                            msgDiag.logPersonalizzato("ricezioneMessaggio");
                            msgDiag.logErroreGenerico(e, "RaccoltaFlowParameter_MTOM_Security");
                            if (this.msgContext.isTracciamentoAbilitato()) {
                                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Riscontrato errore durante la lettura delle proprieta' di MTOM / SecurityMessage: " + e.getMessage()));
                                tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                            }
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                        msgDiag.mediumDebug("MTOM Processor [BeforeSecurity]...");
                        try {
                            mtomProcessor.mtomBeforeSecurity(requestMessage, flowPropertiesRequest.tipoMessaggio);
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "MTOMProcessor(BeforeSec-" + mtomProcessor.getMTOMProcessorType() + ")");
                            if (this.msgContext.isTracciamentoAbilitato()) {
                                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Riscontrato errore durante la gestione MTOM(BeforeSec-" + mtomProcessor.getMTOMProcessorType() + "): " + e.getMessage()));
                                tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                            }
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR));
                                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                        msgDiag.mediumDebug("Validazione semantica della busta di richiesta...");
                        if (!validatore.validazioneSemantica(messageSecurityContext, false, null, proprietaManifestAttachments, validazioneIDBustaCompleta)) {
                            msgDiag.logPersonalizzato("ricezioneMessaggio");
                            try {
                                msgDiag.addKeyword("@ECCEZIONI@", validatore.getErrore().getDescrizione(protocolFactory));
                            }
                            catch (Exception e) {
                                logCore.error((Object)("getDescrizione Error:" + e.getMessage()), (Throwable)e);
                            }
                            msgDiag.addKeyword("@TIPO_VALIDAZIONE_BUSTA@", "semantica");
                            msgDiag.logPersonalizzato("sbustamentoBusta.", "validazioneNonRiuscita");
                            if (this.msgContext.isTracciamentoAbilitato()) {
                                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)msgDiag.getMessaggio_replaceKeywords("sbustamentoBusta.", "validazioneNonRiuscita"));
                                tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                            }
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO));
                                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, validatore.getEccezioneProcessamentoValidazioneSemantica());
                                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                        msgDiag.mediumDebug("MTOM Processor [AfterSecurity]...");
                        try {
                            mtomProcessor.mtomAfterSecurity(requestMessage, flowPropertiesRequest.tipoMessaggio);
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "MTOMProcessor(AfterSec-" + mtomProcessor.getMTOMProcessorType() + ")");
                            if (this.msgContext.isTracciamentoAbilitato()) {
                                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Riscontrato errore durante la gestione MTOM(AfterSec-" + mtomProcessor.getMTOMProcessorType() + "): " + e.getMessage()));
                                tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                            }
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR));
                                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                    }
                    erroriValidazione = validatore.getEccezioniValidazione();
                    erroriProcessamento = validatore.getEccezioniProcessamento();
                    securityInfoRequest = validatore.getSecurityInfo();
                    isMessaggioErroreProtocollo = validatore.isErroreProtocollo();
                    if (isMessaggioErroreProtocollo) {
                        idServizio.setVersioneServizio(null);
                        idServizio.setServizio(null);
                        idServizio.setTipoServizio(null);
                        idServizio.setAzione(null);
                    }
                    bustaDiServizio = validatore.isBustaDiServizio();
                    if (validatore.getInfoServizio() != null) {
                        this.msgContext.getProtocol().setIdAccordo(validatore.getInfoServizio().getIdAccordo());
                        richiestaApplicativa.setIdAccordo(validatore.getInfoServizio().getIdAccordo());
                    }
                    if (!(functionAsRouter || isMessaggioErroreProtocollo || erroriProcessamento.size() != 0 || erroriValidazione.size() != 0 || bustaDiServizio || pa == null || pa.getCorrelazioneApplicativa() == null)) {
                        try {
                            soapEnvelopeRequest = requestMessage.getSOAPPart().getEnvelope();
                            gestoreCorrelazioneApplicativa = new GestoreCorrelazioneApplicativa(openspcoopstate.getStatoRichiesta(), logCore, soggettoFruitore, idServizio, servizioApplicativoFruitore, protocolFactory);
                            gestoreCorrelazioneApplicativa.verificaCorrelazione(pa.getCorrelazioneApplicativa(), null, soapEnvelopeRequest, headerIntegrazioneRichiesta, false);
                            if (gestoreCorrelazioneApplicativa.getIdCorrelazione() == null) ** GOTO lbl1044
                            correlazioneApplicativa = gestoreCorrelazioneApplicativa.getIdCorrelazione();
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "CorrelazioneApplicativa(" + bustaRichiesta.getID() + ")");
                            logCore.error((Object)("Riscontrato errore durante la correlazione applicativa [" + bustaRichiesta.getID() + "]"), (Throwable)e);
                            if (this.msgContext.isTracciamentoAbilitato()) {
                                esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Riscontrato errore durante la correlazione applicativa [" + bustaRichiesta.getID() + "]: " + e.getMessage()));
                                tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                            }
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_529_CORRELAZIONE_APPLICATIVA_RICHIESTA_NON_RIUSCITA));
                                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                    } else {
                        correlazioneApplicativa = null;
                    }
lbl1044:
                    // 3 sources

                    if (tipiIntegrazionePA != null) {
                        for (i = 0; i < tipiIntegrazionePA.length; ++i) {
                            try {
                                classType = null;
                                gestore = null;
                                try {
                                    classType = className.getIntegrazionePortaApplicativa(tipiIntegrazionePA[i]);
                                    gestore = (IGestoreIntegrazionePA)loader.newInstance(classType);
                                    AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                                }
                                catch (Exception e) {
                                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione (aggiornamento/eliminazione) dell'integrazione di tipo [" + tipiIntegrazionePA[i] + "]: " + e.getMessage());
                                }
                                if (!(gestore instanceof IGestoreIntegrazionePASoap)) continue;
                                if (propertiesReader.deleteHeaderIntegrazioneRequestPA()) {
                                    ((IGestoreIntegrazionePASoap)gestore).deleteInRequestHeader(inRequestPAMessage);
                                    continue;
                                }
                                ((IGestoreIntegrazionePASoap)gestore).updateInRequestHeader(inRequestPAMessage, idMessageRequest, servizioApplicativoFruitore, correlazioneApplicativa);
                                continue;
                            }
                            catch (Exception e) {
                                msgDiag.logErroreGenerico(e, "HeaderIntegrazione(" + tipiIntegrazionePA[i] + ")");
                                if (this.msgContext.isTracciamentoAbilitato()) {
                                    esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)("Riscontrato errore durante la gestione dell'Header di Integrazione(" + tipiIntegrazionePA[i] + "): " + e.getMessage()));
                                    tracciamento.registraRichiesta(requestMessage, null, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                                }
                                if (this.msgContext.isGestioneRisposta()) {
                                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                    parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_541_GESTIONE_HEADER_INTEGRAZIONE));
                                    errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                    parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                    this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                }
                                openspcoopstate.releaseResource();
                                return;
                            }
                        }
                    }
                    msgDiag.setIdCorrelazioneApplicativa(correlazioneApplicativa);
                    if (this.msgContext.getIntegrazione() != null) {
                        this.msgContext.getIntegrazione().setIdCorrelazioneApplicativa(correlazioneApplicativa);
                    }
                    parametriGenerazioneBustaErrore.setMsgDiag(msgDiag);
                    parametriInvioBustaErrore.setMsgDiag(msgDiag);
                    if (!isMessaggioErroreProtocollo && idServizio.getServizio() != null && idServizio.getTipoServizio() != null && idServizio.getVersioneServizio() != null) {
                        msgDiag.logCorrelazione();
                    }
                    dettaglioEccezione = null;
                    if (isMessaggioErroreProtocollo) {
                        if (validatore.isMessaggioErroreIntestazione()) {
                            msgDiag.addKeyword("@TIPO_ERRORE_BUSTA@", "Intestazione");
                        } else {
                            msgDiag.addKeyword("@TIPO_ERRORE_BUSTA@", "Processamento");
                        }
                        msgDiag.logPersonalizzato("ricezioneMessaggioErrore");
                        try {
                            dettaglioEccezione = XMLUtils.getDettaglioEccezione((Logger)logCore, (OpenSPCoop2Message)requestMessage);
                        }
                        catch (Exception e) {
                            logCore.error((Object)"Errore durante l'analisi del dettaglio dell'eccezione", (Throwable)e);
                        }
                    } else {
                        msgDiag.logPersonalizzato("ricezioneMessaggio");
                    }
                    versioneProtocollo = validatore.getProfiloGestione();
                    msgDiag.mediumDebug("Profilo di gestione [RicezioneBuste] della busta: " + versioneProtocollo);
                    richiestaApplicativa.setProfiloGestione(versioneProtocollo);
                    parametriGenerazioneBustaErrore.setProfiloGestione(versioneProtocollo);
                    moduleManager = protocolFactory.createProtocolVersionManager(versioneProtocollo);
                    if (!functionAsRouter && ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione()) && bustaRichiesta.getRiferimentoMessaggio() != null && !isMessaggioErroreProtocollo) {
                        ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                        erroriValidazione.add(ecc);
                    }
                    msgDiag.mediumDebug("Gestione errori...");
                    if (erroriProcessamento.size() > 0 || functionAsRouter && erroriValidazione.size() > 0) {
                        errore = new StringBuffer();
                        for (k = 0; k < erroriProcessamento.size(); ++k) {
                            erroreProcessamento = (Eccezione)erroriProcessamento.get(k);
                            try {
                                errore.append("Processamento[" + traduttore.toString(erroreProcessamento.getCodiceEccezione(), erroreProcessamento.getSubCodiceEccezione()) + "] " + ((Eccezione)erroriProcessamento.get(k)).getDescrizione(protocolFactory) + "\n");
                                continue;
                            }
                            catch (Exception e) {
                                logCore.error((Object)("getDescrizione Error:" + e.getMessage()), (Throwable)e);
                            }
                        }
                        for (k = 0; k < erroriValidazione.size(); ++k) {
                            erroreValidazione = (Eccezione)erroriValidazione.get(k);
                            try {
                                errore.append("Validazione[" + traduttore.toString(erroreValidazione.getCodiceEccezione(), erroreValidazione.getSubCodiceEccezione()) + "] " + ((Eccezione)erroriValidazione.get(k)).getDescrizione(protocolFactory) + "\n");
                                continue;
                            }
                            catch (Exception e) {
                                logCore.error((Object)("getDescrizione Error:" + e.getMessage()), (Throwable)e);
                            }
                        }
                        msgDiag.addKeyword("@ECCEZIONI@", errore.toString());
                        msgDiag.addKeyword("@NUMERO_ECCEZIONI@", erroriProcessamento.size() + erroriValidazione.size() + "");
                        msgDiag.logPersonalizzato("sbustamentoBusta.", "validazioneBusta.bustaNonCorretta");
                        if (this.msgContext.isTracciamentoAbilitato()) {
                            esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)msgDiag.getMessaggio_replaceKeywords("sbustamentoBusta.", "validazioneBusta.bustaNonCorretta"));
                            tracciamento.registraRichiesta(requestMessage, securityInfoRequest, soapHeaderElement, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                        }
                        if (this.msgContext.isGestioneRisposta()) {
                            errorOpenSPCoopMsg = null;
                            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                            if (erroriProcessamento.size() > 0) {
                                for (j = 0; j < erroriValidazione.size(); ++j) {
                                    erroriProcessamento.add(erroriValidazione.get(j));
                                }
                                parametriGenerazioneBustaErrore.setError(erroriProcessamento);
                                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, null);
                            } else {
                                parametriGenerazioneBustaErrore.setError(erroriValidazione);
                                errorOpenSPCoopMsg = this.generaBustaErroreValidazione(parametriGenerazioneBustaErrore);
                            }
                            parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                            this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                        }
                        openspcoopstate.releaseResource();
                        return;
                    }
                    headerProtocolloRichiesta = validatore.getHeaderProtocollo();
                    if (this.msgContext.isTracciamentoAbilitato()) {
                        msgDiag.mediumDebug("Tracciamento busta di richiesta...");
                        esitoTraccia = null;
                        if (erroriProcessamento.size() > 0 || erroriValidazione.size() > 0) {
                            dettaglioErrore = null;
                            eccBuffer = new StringBuffer();
                            for (k = 0; k < erroriProcessamento.size(); ++k) {
                                er = (Eccezione)erroriProcessamento.get(k);
                                if (k > 0) {
                                    eccBuffer.append(" ");
                                }
                                eccBuffer.append(er.toString(protocolFactory));
                                eccBuffer.append(";");
                            }
                            for (k = 0; k < erroriValidazione.size(); ++k) {
                                er = (Eccezione)erroriValidazione.get(k);
                                if (eccBuffer.length() > 0) {
                                    eccBuffer.append(" ");
                                }
                                eccBuffer.append(er.toString(protocolFactory));
                                eccBuffer.append(";");
                            }
                            msgDiag.addKeyword("@NUMERO_ECCEZIONI@", erroriProcessamento.size() + erroriValidazione.size() + "");
                            msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
                            dettaglioErrore = isMessaggioErroreProtocollo != false ? msgDiag.getMessaggio_replaceKeywords("sbustamentoBusta.", "validazioneBustaErrore.listaEccezioniMalformata") : msgDiag.getMessaggio_replaceKeywords("sbustamentoBusta.", "validazioneBusta.bustaNonCorretta");
                            esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneConErrore((String)dettaglioErrore);
                        } else {
                            esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioRicevuto();
                        }
                        tracciamento.registraRichiesta(requestMessage, securityInfoRequest, headerProtocolloRichiesta, bustaRichiesta, esitoTraccia, Tracciamento.createLocationString(true, this.msgContext.getFromLocation()), correlazioneApplicativa);
                    }
                    msgDiag.mediumDebug("Controllo mittente/destinatario/servizio (se sconosciuto, risposta immediata sulla connessione)...");
                    for (k = 0; k < erroriValidazione.size(); ++k) {
                        er = (Eccezione)erroriValidazione.get(k);
                        if (!CodiceErroreCooperazione.isEccezioneMittente((CodiceErroreCooperazione)er.getCodiceEccezione()) && !CodiceErroreCooperazione.isEccezioneDestinatario((CodiceErroreCooperazione)er.getCodiceEccezione()) && !CodiceErroreCooperazione.isEccezioneServizio((CodiceErroreCooperazione)er.getCodiceEccezione()) && !CodiceErroreCooperazione.isEccezioneIdentificativoMessaggio((CodiceErroreCooperazione)er.getCodiceEccezione()) || !functionAsRouter && moduleManager.isEccezioniLivelloInfoAbilitato() && LivelloRilevanza.INFO.equals(er.getRilevanza())) continue;
                        eccBuffer = new StringBuffer();
                        for (j = 0; j < erroriValidazione.size(); ++j) {
                            if (j > 0) {
                                eccBuffer.append("\n");
                            }
                            eccBuffer.append(((Eccezione)erroriValidazione.get(j)).toString(protocolFactory));
                        }
                        msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
                        msgDiag.addKeyword("@NUMERO_ECCEZIONI@", erroriValidazione.size() + "");
                        msgDiag.logPersonalizzato("sbustamentoBusta.", "validazioneBusta.bustaNonCorretta");
                        if (this.msgContext.isGestioneRisposta()) {
                            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                            errs = new Vector<Eccezione>();
                            for (add = 0; add < erroriValidazione.size(); ++add) {
                                errs.add((Eccezione)erroriValidazione.get(add));
                            }
                            parametriGenerazioneBustaErrore.setError(errs);
                            errorOpenSPCoopMsg = this.generaBustaErroreValidazione(parametriGenerazioneBustaErrore);
                            parametriInvioBustaErrore.setUtilizzoIndirizzoTelematico(false);
                            parametriInvioBustaErrore.setNewConnectionForResponse(false);
                            parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                            this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                        }
                        openspcoopstate.releaseResource();
                        return;
                    }
                    eccezioniValidazioni = false;
                    for (k = 0; k < erroriValidazione.size(); ++k) {
                        er = (Eccezione)erroriValidazione.get(k);
                        if (!functionAsRouter && moduleManager.isEccezioniLivelloInfoAbilitato() && LivelloRilevanza.INFO.equals(er.getRilevanza())) continue;
                        eccezioniValidazioni = true;
                        break;
                    }
                    tipoAutorizzazione = GestoreAutorizzazioneBuste.getTipoAutorizzazioneBuste();
                    this.msgContext.getIntegrazione().setTipoAutorizzazione(tipoAutorizzazione);
                    if (GestoreAutorizzazioneBuste.isAttivoAutorizzazioneBuste() && !isMessaggioErroreProtocollo && !bustaDiServizio && !eccezioniValidazioni) {
                        try {
                            msgDiag.mediumDebug("Autorizzazione Protocollo di tipo [" + propertiesReader.getTipoAutorizzazioneBuste() + "]...");
                            identitaMittente = null;
                            if (credenziali != null && !"".equals(credenziali.toString())) {
                                identitaMittente = credenziali.toString();
                            }
                            subjectMessageSecurity = null;
                            if (messageSecurityContext != null) {
                                subjectMessageSecurity = messageSecurityContext.getSubject();
                            }
                            idServizioPerAutorizzazione = this.getIdServizioPerAutorizzazione(idServizio, soggettoFruitore, functionAsRouter, bustaRichiesta, ruoloBustaRicevuta);
                            soggettoMittentePerAutorizzazione = this.getIDSoggettoMittentePerAutorizzazione(idServizio, soggettoFruitore, functionAsRouter, bustaRichiesta, ruoloBustaRicevuta);
                            tipoMessaggio = "messaggio";
                            if (ruoloBustaRicevuta != null && (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString()))) {
                                tipoMessaggio = "ricevuta asincrona";
                            }
                            msgDiag.addKeyword("@TIPO_AUTORIZZAZIONE_BUSTE@", propertiesReader.getTipoAutorizzazioneBuste());
                            msgDiag.addKeyword("@TIPO_MESSAGGIO_BUSTA@", tipoMessaggio);
                            msgDiag.addKeyword("@MITTENTE_E_SERVIZIO_DA_AUTORIZZARE@", "FR[" + soggettoMittentePerAutorizzazione.toString() + "]->ER[" + idServizioPerAutorizzazione.toString() + "]");
                            if (identitaMittente != null) {
                                msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", " inviato da un mittente [" + identitaMittente + "]");
                            } else {
                                msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", "");
                            }
                            if (servizioApplicativoFruitore != null) {
                                msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", " identitaServizioApplicativoFruitore [" + servizioApplicativoFruitore + "]");
                            } else {
                                msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", "");
                            }
                            if (subjectMessageSecurity != null) {
                                msgDiag.addKeyword("@SUBJECT_MESSAGE_SECURITY_MSG@", " subjectMessageSecurity [" + subjectMessageSecurity + "]");
                            } else {
                                msgDiag.addKeyword("@SUBJECT_MESSAGE_SECURITY_MSG@", "");
                            }
                            msgDiag.logPersonalizzato("autorizzazioneBusteInCorso");
                            esito = GestoreAutorizzazioneBuste.verificaAutorizzazioneBuste(inRequestContext.getConnettore(), credenziali, servizioApplicativoFruitore, subjectMessageSecurity, soggettoMittentePerAutorizzazione, idServizioPerAutorizzazione, openspcoopstate.getStatoRichiesta(), pddContext, protocolFactory);
                            if (!esito.isServizioAutorizzato()) {
                                try {
                                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", esito.getErroreCooperazione().getDescrizione(protocolFactory));
                                }
                                catch (Exception e) {
                                    logCore.error((Object)("getDescrizione Error:" + e.getMessage()), (Throwable)e);
                                }
                                msgDiag.addKeyword("@POSIZIONE_ERRORE@", traduttore.toString(esito.getErroreCooperazione().getCodiceErrore()));
                                msgDiag.logPersonalizzato("autorizzazioneBusteFallita");
                                if (this.msgContext.isGestioneRisposta()) {
                                    errorOpenSPCoopMsg = null;
                                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                    parametriGenerazioneBustaErrore.setErroreCooperazione(esito.getErroreCooperazione());
                                    if (CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA.equals(esito.getErroreCooperazione().getCodiceErrore()) || CodiceErroreCooperazione.SICUREZZA_FALSIFICAZIONE_MITTENTE.equals(esito.getErroreCooperazione().getCodiceErrore())) {
                                        errorOpenSPCoopMsg = this.generaBustaErroreValidazione(parametriGenerazioneBustaErrore);
                                    } else if (CodiceErroreCooperazione.SERVIZIO_SCONOSCIUTO.equals(esito.getErroreCooperazione().getCodiceErrore())) {
                                        parametriGenerazioneBustaErrore.setErroreCooperazione(ErroriCooperazione.SERVIZIO_SCONOSCIUTO.getErroreCooperazione());
                                        errorOpenSPCoopMsg = this.generaBustaErroreValidazione(parametriGenerazioneBustaErrore);
                                    } else {
                                        errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, esito.getEccezioneProcessamento());
                                    }
                                    parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                    this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                }
                                openspcoopstate.releaseResource();
                                return;
                            }
                            if (esito.getDetails() == null) {
                                msgDiag.addKeyword("@DETAILS@", "");
                            } else {
                                msgDiag.addKeyword("@DETAILS@", " (" + esito.getDetails() + ")");
                            }
                            msgDiag.logPersonalizzato("autorizzazioneBusteEffettuata");
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "AutorizzazioneMessaggio(" + bustaRichiesta.getID() + ")");
                            logCore.error((Object)("Riscontrato errore durante il processo di Autorizzazione per il messaggio con identificativo [" + bustaRichiesta.getID() + "]"), (Throwable)e);
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_504_AUTORIZZAZIONE));
                                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                    }
                    msgDiag.mediumDebug("Verifica canale utilizzato...");
                    tipiSoggettiSupportatiCanale = protocolFactory.createProtocolConfiguration().getTipiSoggetti();
                    tipiServiziSupportatiCanale = protocolFactory.createProtocolConfiguration().getTipiServizi();
                    erroreVerificaTipoByProtocol = null;
                    if (!tipiSoggettiSupportatiCanale.contains(soggettoFruitore.getTipo())) {
                        msgDiag.logPersonalizzato("protocolli.tipoSoggetto.fruitore.unsupported");
                        erroreVerificaTipoByProtocol = ErroriIntegrazione.ERRORE_436_TIPO_SOGGETTO_FRUITORE_NOT_SUPPORTED_BY_PROTOCOL.getErrore436_TipoSoggettoFruitoreNotSupportedByProtocol(soggettoFruitore, protocolFactory);
                    } else if (!tipiSoggettiSupportatiCanale.contains(idServizio.getSoggettoErogatore().getTipo())) {
                        msgDiag.logPersonalizzato("protocolli.tipoSoggetto.erogatore.unsupported");
                        erroreVerificaTipoByProtocol = ErroriIntegrazione.ERRORE_437_TIPO_SOGGETTO_EROGATORE_NOT_SUPPORTED_BY_PROTOCOL.getErrore437_TipoSoggettoErogatoreNotSupportedByProtocol(idServizio.getSoggettoErogatore(), protocolFactory);
                    } else if (!tipiServiziSupportatiCanale.contains(idServizio.getTipoServizio())) {
                        msgDiag.logPersonalizzato("protocolli.tipoServizio.unsupported");
                        ErroriIntegrazione.ERRORE_438_TIPO_SERVIZIO_NOT_SUPPORTED_BY_PROTOCOL.getErrore438_TipoServizioNotSupportedByProtocol(idServizio, protocolFactory);
                    }
                    if (erroreVerificaTipoByProtocol != null) {
                        if (this.msgContext.isGestioneRisposta()) {
                            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                            parametriGenerazioneBustaErrore.setErroreIntegrazione(erroreVerificaTipoByProtocol);
                            errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, null);
                            parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                            this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                        }
                        openspcoopstate.releaseResource();
                        return;
                    }
                    validazioneContenutoApplicativoApplicativo = null;
                    tipoAutorizzazionePerContenuto = null;
                    if (!(functionAsRouter || isMessaggioErroreProtocollo || erroriProcessamento.size() != 0 || erroriValidazione.size() != 0 || bustaDiServizio || pa == null)) {
                        msgDiag.mediumDebug("Controllo abilitazione validazione XSD della richiesta...");
                        isRicevutaAsincrona_modalitaAsincrona = false;
                        try {
                            if ((ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) && bustaRichiesta.getRiferimentoMessaggio() != null) {
                                msgDiag.mediumDebug("Controllo abilitazione validazione XSD della richiesta (check asincrono)...");
                                if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                                    if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                                        validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pa, implementazionePdDMittente);
                                        tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pa);
                                    } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                        validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pd, implementazionePdDMittente);
                                        tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pd);
                                    } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                        if (configurazionePdDReader.ricevutaAsincronaSimmetricaAbilitata(pd)) {
                                            isRicevutaAsincrona_modalitaAsincrona = true;
                                        } else {
                                            validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pd, implementazionePdDMittente);
                                            tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pd);
                                        }
                                    }
                                } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                                    if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                                        validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pa, implementazionePdDMittente);
                                        tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pa);
                                    } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                        validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pa, implementazionePdDMittente);
                                        tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pa);
                                    } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                        if (configurazionePdDReader.ricevutaAsincronaAsimmetricaAbilitata(pd)) {
                                            isRicevutaAsincrona_modalitaAsincrona = true;
                                        } else {
                                            validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pd, implementazionePdDMittente);
                                            tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pd);
                                        }
                                    }
                                }
                                ((StateMessage)openspcoopstate.getStatoRichiesta()).closePreparedStatement();
                            } else {
                                msgDiag.mediumDebug("Controllo abilitazione validazione dei contenuti applicativi della richiesta...");
                                validazioneContenutoApplicativoApplicativo = configurazionePdDReader.getTipoValidazioneContenutoApplicativo(pa, implementazionePdDMittente);
                                tipoAutorizzazionePerContenuto = configurazionePdDReader.getAutorizzazioneContenuto(pa);
                            }
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "getTipoValidazione/Autorizzazione ContenutoApplicativo");
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                        if (!isRicevutaAsincrona_modalitaAsincrona) {
                            binXSD = null;
                            try {
                                if (CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.equals(validazioneContenutoApplicativoApplicativo.getStato()) || CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                    msgDiag.mediumDebug("Validatore contenuti applicativi della richiesta...");
                                    xomReferences = null;
                                    if (StatoFunzionalita.ABILITATO.equals(validazioneContenutoApplicativoApplicativo.getAcceptMtomMessage())) {
                                        xomReferences = requestMessage.mtomFastUnpackagingForXSDConformance();
                                    }
                                    readWSDL = CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL.equals(validazioneContenutoApplicativoApplicativo.getTipo());
                                    validatoreMessaggiApplicativi = new ValidatoreMessaggiApplicativi(registroServiziReader, idServizio, requestMessage.getVersioneSoap(), requestMessage.getSOAPPart().getEnvelope(), readWSDL);
                                    if (CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL.equals(validazioneContenutoApplicativoApplicativo.getTipo()) || CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP.equals(validazioneContenutoApplicativoApplicativo.getTipo())) {
                                        msgDiag.mediumDebug("Validazione wsdl della richiesta ...");
                                        validatoreMessaggiApplicativi.validateWithWsdlLogicoImplementativo(true, this.msgContext.getSoapAction());
                                    }
                                    msgDiag.mediumDebug("Validazione xsd della richiesta (validazione)...");
                                    validatoreMessaggiApplicativi.validateWithWsdlDefinitorio(true);
                                    if (xomReferences != null && xomReferences.size() > 0) {
                                        requestMessage.mtomRestoreAfterXSDConformance(xomReferences);
                                    }
                                }
                            }
                            catch (ValidatoreMessaggiApplicativiException ex) {
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", ex.getMessage());
                                msgDiag.logPersonalizzato("validazioneContenutiApplicativiNonRiuscita");
                                if (!CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                    if (this.msgContext.isGestioneRisposta()) {
                                        parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                        parametriGenerazioneBustaErrore.setErroreIntegrazione(ex.getErrore());
                                        errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, ex);
                                        parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                        parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                        this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                    }
                                    openspcoopstate.releaseResource();
                                    return;
                                }
                            }
                            catch (Exception ex) {
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", ex.getMessage());
                                msgDiag.logPersonalizzato("validazioneContenutiApplicativiNonRiuscita");
                                logCore.error((Object)"Riscontrato errore durante la validazione dei contenuti applicativi (richiesta applicativa)", (Throwable)ex);
                                if (!CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals(validazioneContenutoApplicativoApplicativo.getStato())) {
                                    if (this.msgContext.isGestioneRisposta()) {
                                        parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                        parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_WSDL_FALLITA));
                                        errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, ex);
                                        parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                        parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                        this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                    }
                                    openspcoopstate.releaseResource();
                                    return;
                                }
                            }
                            finally {
                                if (binXSD != null) {
                                    try {
                                        binXSD.close();
                                    }
                                    catch (Exception e) {}
                                }
                            }
                        }
                        if (!"none".equalsIgnoreCase(tipoAutorizzazionePerContenuto)) {
                            try {
                                classType = null;
                                auth = null;
                                try {
                                    classType = className.getAutorizzazioneContenutoBuste(tipoAutorizzazionePerContenuto);
                                    auth = (IAutorizzazioneContenutoBuste)loader.newInstance(classType);
                                    AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
                                }
                                catch (Exception e) {
                                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'autorizzazione contenuto buste di tipo [" + tipoAutorizzazionePerContenuto + "]: " + e.getMessage());
                                }
                                if (auth != null) {
                                    identitaMittente = null;
                                    if (credenziali != null && !"".equals(credenziali.toString())) {
                                        identitaMittente = credenziali.toString();
                                    }
                                    subjectMessageSecurity = null;
                                    if (messageSecurityContext != null) {
                                        subjectMessageSecurity = messageSecurityContext.getSubject();
                                    }
                                    idServizioPerAutorizzazione = this.getIdServizioPerAutorizzazione(idServizio, soggettoFruitore, functionAsRouter, bustaRichiesta, ruoloBustaRicevuta);
                                    soggettoMittentePerAutorizzazione = this.getIDSoggettoMittentePerAutorizzazione(idServizio, soggettoFruitore, functionAsRouter, bustaRichiesta, ruoloBustaRicevuta);
                                    tipoMessaggio = "messaggio";
                                    if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                                        tipoMessaggio = "ricevuta asincrona";
                                    }
                                    msgDiag.addKeyword("@TIPO_AUTORIZZAZIONE_BUSTE@", "AutorizzazioneContenuto(" + tipoAutorizzazionePerContenuto + ")");
                                    msgDiag.addKeyword("@TIPO_MESSAGGIO_BUSTA@", tipoMessaggio);
                                    msgDiag.addKeyword("@MITTENTE_E_SERVIZIO_DA_AUTORIZZARE@", "FR[" + soggettoMittentePerAutorizzazione.toString() + "]->ER[" + idServizioPerAutorizzazione.toString() + "]");
                                    if (identitaMittente != null) {
                                        msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", " inviato da un mittente [" + identitaMittente + "]");
                                    } else {
                                        msgDiag.addKeyword("@CREDENZIALI_MITTENTE_MSG@", "");
                                    }
                                    if (servizioApplicativoFruitore != null) {
                                        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", " identitaServizioApplicativoFruitore [" + servizioApplicativoFruitore + "]");
                                    } else {
                                        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE_MSG@", "");
                                    }
                                    if (subjectMessageSecurity != null) {
                                        msgDiag.addKeyword("@SUBJECT_MESSAGE_SECURITY_MSG@", " subjectMessageSecurity [" + subjectMessageSecurity + "]");
                                    } else {
                                        msgDiag.addKeyword("@SUBJECT_MESSAGE_SECURITY_MSG@", "");
                                    }
                                    msgDiag.logPersonalizzato("autorizzazioneBusteInCorso");
                                    esito = auth.process(inRequestContext.getConnettore(), identitaMittente, servizioApplicativoFruitore, subjectMessageSecurity, soggettoMittentePerAutorizzazione, idServizioPerAutorizzazione, ruoloBustaRicevuta, requestMessage);
                                    if (!esito.isServizioAutorizzato()) {
                                        try {
                                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", esito.getErroreCooperazione().getDescrizione(protocolFactory));
                                        }
                                        catch (Exception e) {
                                            logCore.error((Object)("getDescrizione Error:" + e.getMessage()), (Throwable)e);
                                        }
                                        msgDiag.addKeyword("@POSIZIONE_ERRORE@", traduttore.toString(esito.getErroreCooperazione().getCodiceErrore()));
                                        msgDiag.logPersonalizzato("autorizzazioneBusteFallita");
                                        if (this.msgContext.isGestioneRisposta()) {
                                            errorMsg = null;
                                            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                            parametriGenerazioneBustaErrore.setErroreCooperazione(esito.getErroreCooperazione());
                                            errorMsg = CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA.equals(esito.getErroreCooperazione().getCodiceErrore()) != false || CodiceErroreCooperazione.SICUREZZA_FALSIFICAZIONE_MITTENTE.equals(esito.getErroreCooperazione().getCodiceErrore()) != false ? this.generaBustaErroreValidazione(parametriGenerazioneBustaErrore) : this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, esito.getEccezioneProcessamento());
                                            parametriInvioBustaErrore.setOpenspcoopMsg(errorMsg);
                                            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                            this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                        }
                                        openspcoopstate.releaseResource();
                                        return;
                                    }
                                    if (esito.getDetails() == null) {
                                        msgDiag.addKeyword("@DETAILS@", "");
                                    } else {
                                        msgDiag.addKeyword("@DETAILS@", " (" + esito.getDetails() + ")");
                                    }
                                } else {
                                    throw new Exception("gestore [" + tipoAutorizzazionePerContenuto + "] non inizializzato");
                                }
                                msgDiag.logPersonalizzato("autorizzazioneBusteEffettuata");
                            }
                            catch (Exception ex) {
                                msgDiag.logErroreGenerico(ex, "AutorizzazioneContenuto Messaggio(" + bustaRichiesta.getID() + ")");
                                logCore.error((Object)("Riscontrato errore durante il processo di Autorizzazione del Contenuto per il messaggio con identificativo [" + bustaRichiesta.getID() + "]"), (Throwable)ex);
                                if (this.msgContext.isGestioneRisposta()) {
                                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                    parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_542_AUTORIZZAZIONE_CONTENUTO));
                                    errorMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, ex);
                                    parametriInvioBustaErrore.setOpenspcoopMsg(errorMsg);
                                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                    this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                }
                                openspcoopstate.releaseResource();
                                return;
                            }
                        }
                    }
                    try {
                        if (oneWayStateless || sincronoStateless || asincronoStateless || oneWayVersione11 || routingStateless) {
                            openspcoopstate = OpenSPCoopState.toStateless((OpenSPCoopStateful)openspcoopstate, true);
                            parametriGenerazioneBustaErrore.setOpenspcoop(openspcoopstate);
                            parametriInvioBustaErrore.setOpenspcoop(openspcoopstate);
                        }
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "OpenSPCoopState.toStateless");
                        logCore.error((Object)("Creazione stato STATEFUL/STATELESS non riuscita: " + e));
                        if (this.msgContext.isGestioneRisposta()) {
                            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                            parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                            errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                            parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                            this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                        }
                        openspcoopstate.releaseResource();
                        return;
                    }
                    tipoMsg = "INBOX";
                    if (functionAsRouter) {
                        tipoMsg = "OUTBOX";
                    }
                    msgRequest = new GestoreMessaggi(openspcoopstate, true, idMessageRequest, tipoMsg, msgDiag, inRequestContext.getPddContext());
                    msgRequest.setOneWayVersione11(oneWayVersione11);
                    msgRequest.setRoutingStateless(routingStateless);
                    repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRichiesta(), true, protocolFactory);
                    msgDiag.mediumDebug("Controllo presenza del messaggio gia' in gestione...");
                    if (!functionAsRouter || !routingStateless) {
                        try {
                            if (!msgRequest.existsMessage_noCache()) break block587;
                            proprietarioMessaggio = msgRequest.getProprietario(this.msgContext.getIdModulo());
                            if ("GestoreMessaggi".equals(proprietarioMessaggio)) {
                                msgDiag.logPersonalizzato("messaggioInGestione.marcatoDaEliminare");
                                msg = msgDiag.getMessaggio_replaceKeywords("messaggioInGestione.marcatoDaEliminare");
                                msgRequest.deleteMessageWithLock(msg, propertiesReader.getMsgGiaInProcessamento_AttesaAttiva(), propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                                break block587;
                            }
                            v1 = rispostaModalitaSincrona = ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione()) != false || ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) != false && configurazionePdDReader.ricevutaAsincronaSimmetricaAbilitata(pa) != false || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) != false && configurazionePdDReader.ricevutaAsincronaAsimmetricaAbilitata(pa) != false;
                            if (rispostaModalitaSincrona) {
                                msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", proprietarioMessaggio);
                                msgDiag.logPersonalizzato("messaggioInGestione.gestioneSincrona");
                                if (this.msgContext.isGestioneRisposta()) {
                                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                    parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_537_BUSTA_GIA_RICEVUTA.get537_BustaGiaRicevuta(idMessageRequest));
                                    errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, null);
                                    parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                    this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                }
                                openspcoopstate.releaseResource();
                                return;
                            }
                            msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", proprietarioMessaggio);
                            msgDiag.logPersonalizzato("messaggioInGestione.gestioneAsincrona");
                            scadenzaWhile = DateManager.getTimeMillis() + propertiesReader.getMsgGiaInProcessamento_AttesaAttiva();
                            isErrore_MsgGiaRicevuto = true;
                            msgAttesaFineProcessamento = false;
                            millisecondiTrascorsi = 0;
                            while (DateManager.getTimeMillis() < scadenzaWhile) {
                                proprietarioMessaggio = msgRequest.getProprietario(this.msgContext.getIdModulo());
                                if (Inoltro.SENZA_DUPLICATI.equals(bustaRichiesta.getInoltro()) || this.msgContext.isForzaFiltroDuplicati_msgGiaInProcessamento()) {
                                    if ("ConsegnaContenutiApplicativi".equals(proprietarioMessaggio) || "GestoreMessaggi".equals(proprietarioMessaggio) || !msgRequest.existsMessage_noCache()) {
                                        if (this.msgContext.isGestioneRisposta()) {
                                            this.msgContext.setMessageResponse(this.generaRisposta_msgGiaRicevuto(this.msgContext.isForzaFiltroDuplicati_msgGiaInProcessamento() == false, bustaRichiesta, infoIntegrazione, msgDiag, openspcoopstate, logCore, configurazionePdDReader, propertiesReader, versioneProtocollo, ruoloBustaRicevuta, implementazionePdDMittente, protocolFactory));
                                        }
                                        openspcoopstate.releaseResource();
                                        return;
                                    }
                                    if (!msgAttesaFineProcessamento) {
                                        msgDiag.addKeyword("@TIMEOUT@", "" + propertiesReader.getMsgGiaInProcessamento_AttesaAttiva() / 1000L);
                                        msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiAbilitato");
                                        msgAttesaFineProcessamento = true;
                                    }
                                } else {
                                    if (!msgAttesaFineProcessamento) {
                                        msgDiag.addKeyword("@TIMEOUT@", "" + propertiesReader.getMsgGiaInProcessamento_AttesaAttiva() / 1000L);
                                        msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato");
                                        msgAttesaFineProcessamento = true;
                                    }
                                    if (!(existsMessage = msgRequest.existsMessage_noCache())) {
                                        msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.attesaTerminata");
                                        isErrore_MsgGiaRicevuto = false;
                                        break;
                                    }
                                    if ("GestoreMessaggi".equals(proprietarioMessaggio)) {
                                        msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.forzoEliminazione");
                                        msg = msgDiag.getMessaggio_replaceKeywords("messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.forzoEliminazione");
                                        msgRequest.deleteMessageWithLock(msg, propertiesReader.getMsgGiaInProcessamento_AttesaAttiva() - (long)millisecondiTrascorsi, propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                                        isErrore_MsgGiaRicevuto = false;
                                        break;
                                    }
                                }
                                try {
                                    Thread.sleep(propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                                }
                                catch (Exception eRandom) {
                                    // empty catch block
                                }
                                millisecondiTrascorsi += propertiesReader.getMsgGiaInProcessamento_CheckInterval();
                            }
                            if (isErrore_MsgGiaRicevuto) {
                                msgDiag.logPersonalizzato("messaggioInGestione.attesaFineProcessamento.timeoutScaduto");
                                if (this.msgContext.isGestioneRisposta()) {
                                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                    parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_537_BUSTA_GIA_RICEVUTA.get537_BustaGiaRicevuta(idMessageRequest));
                                    errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, null);
                                    parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                    this.sendRispostaBustaErrore(parametriInvioBustaErrore, false);
                                }
                                openspcoopstate.releaseResource();
                                return;
                            }
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "ControlloPresenzaMessaggioGiaInGestione");
                            logCore.error((Object)"Controllo/gestione presenza messaggio gia in gestione non riuscito", (Throwable)e);
                            if (this.msgContext.isGestioneRisposta()) {
                                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            }
                            openspcoopstate.releaseResource();
                            return;
                        }
                    }
                }
                msgDiag.mediumDebug("Registrazione messaggio di richiesta nel RepositoryMessaggi...");
                try {
                    msgRequest.registraMessaggio(requestMessage, dataIngressoMessaggio, oneWayStateless != false || sincronoStateless != false || asincronoStateless != false || routingStateless != false, correlazioneApplicativa);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "msgRequest.registraMessaggio");
                    if (this.msgContext.isGestioneRisposta()) {
                        parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                        if (requestMessage.getParsingError() == null) {
                            parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_508_SAVE_REQUEST_MSG));
                        } else {
                            parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_432_MESSAGGIO_XML_MALFORMATO.getErrore432_MessaggioRichiestaMalformato(true, requestMessage.getParsingError()));
                        }
                        errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                        parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                        this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                    }
                    msgRequest.deleteMessageFromFileSystem();
                    openspcoopstate.releaseResource();
                    return;
                }
                msgDiag.mediumDebug("Registrazione busta di richiesta nel RepositoryBuste...");
                try {
                    if (!(oneWayStateless || sincronoStateless || asincronoStateless || routingStateless)) {
                        if (repositoryBuste.isRegistrata(bustaRichiesta.getID(), tipoMsg)) {
                            try {
                                repositoryBuste.aggiornaBusta(bustaRichiesta, tipoMsg, propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), erroriValidazione);
                                repositoryBuste.impostaUtilizzoPdD(bustaRichiesta.getID(), tipoMsg);
                            }
                            catch (Exception e) {
                                causa = "Aggiornamento dati busta con id [" + bustaRichiesta.getID() + "] tipo[" + tipoMsg + "] non riuscito: " + e.getMessage();
                                try {
                                    GestoreMessaggi.acquireLock(msgDiag, causa, propertiesReader.getMsgGiaInProcessamento_AttesaAttiva(), propertiesReader.getMsgGiaInProcessamento_CheckInterval());
                                    if (repositoryBuste.isRegistrata(bustaRichiesta.getID(), tipoMsg)) {
                                        repositoryBuste.aggiornaBusta(bustaRichiesta, tipoMsg, propertiesReader.getRepositoryIntervalloScadenzaMessaggi(), erroriValidazione);
                                        repositoryBuste.impostaUtilizzoPdD(bustaRichiesta.getID(), tipoMsg);
                                    }
                                    repositoryBuste.registraBusta(bustaRichiesta, tipoMsg, erroriValidazione, propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                                }
                                finally {
                                    try {
                                        GestoreMessaggi.releaseLock(msgDiag, causa);
                                    }
                                    catch (Exception eUnlock) {}
                                }
                            }
                        } else {
                            repositoryBuste.registraBusta(bustaRichiesta, tipoMsg, erroriValidazione, propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                        }
                        repositoryBuste.aggiornaInfoIntegrazione(bustaRichiesta.getID(), tipoMsg, infoIntegrazione);
                        break block588;
                    }
                    ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(bustaRichiesta);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "repositoryBuste.registraBusta");
                    if (this.msgContext.isGestioneRisposta()) {
                        parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                        parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO));
                        errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                        parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                        this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                    }
                    msgRequest.deleteMessageFromFileSystem();
                    openspcoopstate.releaseResource();
                    return;
                }
            }
            try {
                if (functionAsRouter) {
                    msgDiag.mediumDebug("Invio messaggio al modulo di InoltroBuste (router)...");
                    msgRequest.aggiornaProprietarioMessaggio("InoltroBuste");
                    msgDiag.highDebug("Creazione ObjectMessage for send nell'infrastruttura.");
                    inoltroMSG.setBusta(bustaRichiesta);
                    rd = new RichiestaDelegata(soggettoFruitore);
                    rd.setDominio(identitaPdD);
                    rd.setIdModuloInAttesa(this.msgContext.getIdModulo());
                    rd.setIdServizio(idServizio);
                    rd.setIdCorrelazioneApplicativa(correlazioneApplicativa);
                    rd.setServizioApplicativo(servizioApplicativoFruitore);
                    inoltroMSG.setRichiestaDelegata(rd);
                    inoltroMSG.setImplementazionePdDSoggettoMittente(implementazionePdDMittente);
                    inoltroMSG.setImplementazionePdDSoggettoDestinatario(implementazionePdDDestinatario);
                    inoltroMSG.setPddContext(inRequestContext.getPddContext());
                    if (routingStateless) break block589;
                    classTypeNodeSender = null;
                    nodeSender = null;
                    try {
                        classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
                        nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
                        AbstractCore.init(nodeSender, pddContext, protocolFactory, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
                    }
                    nodeSender.send(inoltroMSG, "InoltroBuste", msgDiag, identitaPdD, this.msgContext.getIdModulo(), idMessageRequest, msgRequest);
                    break block589;
                }
                msgDiag.mediumDebug("Invio messaggio al modulo di Sbustamento...");
                msgRequest.aggiornaProprietarioMessaggio("Sbustamento");
                msgDiag.highDebug("Creazione ObjectMessage for send nell'infrastruttura.");
                richiestaApplicativa.setIdCorrelazioneApplicativa(correlazioneApplicativa);
                richiestaApplicativa.setIdentitaServizioApplicativoFruitore(servizioApplicativoFruitore);
                sbustamentoMSG.setRichiestaApplicativa(richiestaApplicativa);
                sbustamentoMSG.setBusta(bustaRichiesta);
                sbustamentoMSG.setErrors(erroriValidazione);
                sbustamentoMSG.setMessaggioErroreProtocollo(isMessaggioErroreProtocollo);
                sbustamentoMSG.setIsBustaDiServizio(bustaDiServizio);
                sbustamentoMSG.setServizioCorrelato(validatore.getServizioCorrelato());
                sbustamentoMSG.setTipoServizioCorrelato(validatore.getTipoServizioCorrelato());
                sbustamentoMSG.setRuoloBustaRicevuta(ruoloBustaRicevuta);
                sbustamentoMSG.setOneWayVersione11(oneWayVersione11);
                sbustamentoMSG.setStateless(oneWayStateless != false || sincronoStateless != false || asincronoStateless != false);
                sbustamentoMSG.setImplementazionePdDSoggettoMittente(implementazionePdDMittente);
                sbustamentoMSG.setImplementazionePdDSoggettoDestinatario(implementazionePdDDestinatario);
                sbustamentoMSG.setPddContext(inRequestContext.getPddContext());
                sbustamentoMSG.setDettaglioEccezione(dettaglioEccezione);
                if (validatore.getInfoServizio() != null) {
                    sbustamentoMSG.setFiltroDuplicatiRichiestoAccordo(Inoltro.SENZA_DUPLICATI.equals(validatore.getInfoServizio().getInoltro()));
                    if (StatoFunzionalitaProtocollo.REGISTRO.equals((Object)moduleManager.getConsegnaAffidabile(bustaRichiesta.getProfiloDiCollaborazione()))) {
                        sbustamentoMSG.setConfermaRicezioneRichiestoAccordo(validatore.getInfoServizio().getConfermaRicezione());
                    }
                    if (StatoFunzionalitaProtocollo.REGISTRO.equals((Object)moduleManager.getConsegnaInOrdine(bustaRichiesta.getProfiloDiCollaborazione()))) {
                        sbustamentoMSG.setConsegnaOrdineRichiestoAccordo(validatore.getInfoServizio().getOrdineConsegna());
                    }
                }
                if (portaStateless) break block589;
                logCore.debug((Object)"RicezioneBuste :eseguo send a sbustamento");
                classTypeNodeSender = null;
                nodeSender = null;
                try {
                    classTypeNodeSender = className.getNodeSender(propertiesReader.getNodeSender());
                    nodeSender = (INodeSender)loader.newInstance(classTypeNodeSender);
                    AbstractCore.init(nodeSender, pddContext, protocolFactory, new Object[0]);
                }
                catch (Exception e) {
                    throw new Exception("Riscontrato errore durante il caricamento della classe [" + classTypeNodeSender + "] da utilizzare per la spedizione nell'infrastruttura: " + e.getMessage());
                }
                nodeSender.send(sbustamentoMSG, "Sbustamento", msgDiag, identitaPdD, this.msgContext.getIdModulo(), idMessageRequest, msgRequest);
                logCore.debug((Object)"RicezioneBuste :send a sbustamento eseguita");
            }
            catch (Exception e) {
                if (functionAsRouter) {
                    logCore.error((Object)"Spedizione->InoltroBuste(router) non riuscita", (Throwable)e);
                    msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(InoltroBuste)");
                } else {
                    logCore.error((Object)"Spedizione->Sbustamento non riuscita", (Throwable)e);
                    msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(Sbustamento)");
                }
                if (this.msgContext.isGestioneRisposta()) {
                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND));
                    errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                    parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                    this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                }
                msgRequest.deleteMessageFromFileSystem();
                openspcoopstate.releaseResource();
                return;
            }
        }
        msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta...");
        try {
            openspcoopstate.commit();
            logCore.debug((Object)"RicezioneBuste :RicezioneBuste commit eseguito");
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "openspcoopstate.commit()");
            if (this.msgContext.isGestioneRisposta()) {
                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_506_COMMIT_JDBC));
                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
            }
            msgRequest.deleteMessageFromFileSystem();
            openspcoopstate.releaseResource();
            return;
        }
        if (validatore != null) {
            if (validatore.getValidatoreSintattico() != null) {
                validatore.getValidatoreSintattico().setHeaderSOAP(null);
            }
            validatore.setValidatoreSintattico(null);
        }
        validatore = null;
        if (!portaStateless && !routingStateless) {
            if (msgRequest != null) {
                msgRequest.addMessaggiIntoCache_readFromTable("RicezioneBuste", "richiesta");
            }
            if (msgRequest != null) {
                msgRequest.addProprietariIntoCache_readFromTable("RicezioneBuste", "richiesta", null, functionAsRouter);
            }
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta effettuato, rilascio della connessione...");
            openspcoopstate.releaseResource();
        }
        bustaRichiesta = bustaRichiesta.clone();
        if (routingStateless) {
            ((OpenSPCoopStateless)openspcoopstate).setMessageLib(inoltroMSG);
            ((OpenSPCoopStateless)openspcoopstate).setIDMessaggioSessione(idMessageRequest);
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
            lib = null;
            try {
                lib = new InoltroBuste(logCore);
                esito = lib.onMessage(openspcoopstate);
                if (esito.getStatoInvocazione() == 1 || esito.getStatoInvocazione() == 2) {
                    msgDiag.mediumDebug("Invocazione libreria InoltroBuste riuscito con esito: " + esito.getStatoInvocazione());
                } else if (esito.getStatoInvocazione() == 3) {
                    throw new Exception("Errore non gestito dalla libreria");
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "GestioneRoutingStateless");
                logCore.error((Object)("Errore Generale durante la gestione del routing stateless: " + e.getMessage()), (Throwable)e);
                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                openspcoopstate.releaseResource();
                return;
            }
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
        }
        if (portaStateless) {
            ((OpenSPCoopStateless)openspcoopstate).setMessageLib(sbustamentoMSG);
            ((OpenSPCoopStateless)openspcoopstate).setIDMessaggioSessione(idMessageRequest);
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
            esito = new EsitoLib();
            try {
                ((OpenSPCoopStateless)openspcoopstate).setDestinatarioResponseMsgLib("");
                while (!((OpenSPCoopStateless)openspcoopstate).getDestinatarioResponseMsgLib().startsWith("RicezioneBuste")) {
                    libreriaSbustamento = false;
                    if (((OpenSPCoopStateless)openspcoopstate).getDestinatarioRequestMsgLib().startsWith("Sbustamento")) {
                        libreriaSbustamento = true;
                    }
                    if (((OpenSPCoopStateless)openspcoopstate).getDestinatarioResponseMsgLib().startsWith("ImbustamentoRisposte") && propertiesReader.isRinegoziamentoConnessione(bustaRichiesta.getProfiloDiCollaborazione()) && (oneWayStateless || sincronoStateless || asincronoStateless) && openspcoopstate.resourceReleased()) {
                        ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                        ((OpenSPCoopStateless)openspcoopstate).initResource(identitaPdD, "ImbustamentoRisposte", idTransazione);
                        ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
                        registroServiziReader.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
                        configurazionePdDReader.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
                        tracciamento.updateState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
                        msgDiag.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
                    }
                    esito = this.chiamaLibreria((OpenSPCoopStateless)openspcoopstate, logCore);
                    if (oneWayVersione11 && newConnectionForResponse && esito.getStatoInvocazione() == 1 && libreriaSbustamento) {
                        ((OpenSPCoopStateless)openspcoopstate).setDestinatarioResponseMsgLib("RicezioneBuste");
                        ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                        openspcoopstate.commit();
                        ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
                    }
                    if (esito.getStatoInvocazione() == 2) {
                        if (oneWayVersione11 && newConnectionForResponse && libreriaSbustamento) {
                            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                            openspcoopstate.commit();
                            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
                        }
                        break;
                    }
                    if (esito.getStatoInvocazione() == 3) {
                        throw new Exception("Errore non gestito dalla libreria");
                    }
                    if (!libreriaSbustamento || !propertiesReader.isRinegoziamentoConnessione(bustaRichiesta.getProfiloDiCollaborazione()) || !oneWayStateless && !sincronoStateless && !asincronoStateless) continue;
                    ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                    openspcoopstate.commit();
                    openspcoopstate.releaseResource();
                    ((OpenSPCoopStateless)openspcoopstate).setUseConnection(false);
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "GestioneStateless");
                logCore.error((Object)("Errore Generale durante la gestione stateless: " + e.getMessage()), (Throwable)e);
                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                openspcoopstate.releaseResource();
                return;
            }
            ((OpenSPCoopStateless)openspcoopstate).setUseConnection(true);
        }
        configurazionePdDReader.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
        registroServiziReader.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
        tracciamento.updateState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
        msgDiag.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
        msgDiag.mediumDebug("Gestione risposta...");
        if (!this.msgContext.isGestioneRisposta()) {
            if (portaStateless) {
                openspcoopstate.releaseResource();
            }
            return;
        }
        versioneSoap = (SOAPVersion)this.msgContext.getPddContext().getObject("SOAP_VERSION");
        richiestaRispostaProtocollo = true;
        if (functionAsRouter) {
            if (!ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione()) && newConnectionForResponse) {
                this.msgContext.setMessageResponse(SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap));
                return;
            }
            richiestaRispostaProtocollo = false;
        } else {
            if (utilizzoIndirizzoTelematico && bustaRichiesta.getIndirizzoMittente() != null && moduleManager.isUtilizzoIndirizzoSoggettoPresenteBusta() && !oneWayStateless && !sincronoStateless && !asincronoStateless) {
                this.msgContext.setMessageResponse(SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap));
                if (portaStateless) {
                    openspcoopstate.releaseResource();
                }
                return;
            }
            if (!(ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || !newConnectionForResponse || oneWayStateless || sincronoStateless || asincronoStateless)) {
                this.msgContext.setMessageResponse(SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap));
                if (portaStateless) {
                    openspcoopstate.releaseResource();
                }
                return;
            }
            if (isMessaggioErroreProtocollo) {
                richiestaRispostaProtocollo = false;
            } else if (bustaDiServizio) {
                richiestaRispostaProtocollo = false;
            } else if (StatoFunzionalitaProtocollo.DISABILITATA.equals((Object)moduleManager.getConsegnaAffidabile(bustaRichiesta.getProfiloDiCollaborazione())) || !propertiesReader.isGestioneRiscontri(implementazionePdDMittente) || ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) && !bustaRichiesta.isConfermaRicezione()) {
                richiestaRispostaProtocollo = false;
            } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                richiestaRispostaProtocollo = false;
            }
        }
        msgResponse = null;
        responseMessage = SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap);
        bustaRisposta = null;
        idMessaggioSblocco = null;
        contenutoRispostaPresente = false;
        try {
            ricezioneBusteMSG = null;
            idCorrelazioneApplicativaRisposta = null;
            try {
                msgDiag.mediumDebug("Attesa/lettura risposta...");
                if (!portaStateless && !routingStateless) {
                    classType = null;
                    nodeReceiver = null;
                    try {
                        classType = className.getNodeReceiver(propertiesReader.getNodeReceiver());
                        nodeReceiver = (INodeReceiver)loader.newInstance(classType);
                        AbstractCore.init(nodeReceiver, pddContext, protocolFactory, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la ricezione dall'infrastruttura: " + e.getMessage());
                    }
                    ricezioneBusteMSG = (RicezioneBusteMessage)nodeReceiver.receive(msgDiag, identitaPdD, this.msgContext.getIdModulo(), idMessageRequest, propertiesReader.getNodeReceiverTimeoutRicezioneBuste(), propertiesReader.getNodeReceiverCheckInterval());
                    pddContext = ricezioneBusteMSG.getPddContext();
                    if (pddContext != null) {
                        enumPddContext = pddContext.keys();
                        while (enumPddContext.hasMoreElements()) {
                            key = enumPddContext.nextElement();
                            this.msgContext.getPddContext().addObject(key, pddContext.getObject(key));
                        }
                    }
                } else {
                    ricezioneBusteMSG = (RicezioneBusteMessage)openspcoopstate.getMessageLib();
                }
                v2 = contenutoRispostaPresente = ricezioneBusteMSG.getBustaRisposta() != null;
                if (richiestaRispostaProtocollo && !contenutoRispostaPresente) {
                    throw new Exception("Risposta attesa e non ritornata: ErroreInterno");
                }
                if (contenutoRispostaPresente) {
                    bustaRisposta = ricezioneBusteMSG.getBustaRisposta();
                    this.msgContext.getProtocol().setIdRisposta(bustaRisposta.getID());
                    this.msgContext.getProtocol().setCollaborazione(bustaRisposta.getCollaborazione());
                } else {
                    idMessaggioSblocco = ricezioneBusteMSG.getIdMessaggioSblocco();
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "GestioneRisposta(" + this.msgContext.getIdModulo() + ")");
                logCore.error((Object)("Gestione risposta (" + this.msgContext.getIdModulo() + ") con errore"), (Throwable)e);
                if (!portaStateless && !routingStateless) {
                    try {
                        msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                        openspcoopstate.updateResource(idTransazione);
                    }
                    catch (Exception eDB) {
                        this.setSOAPFault_processamento(logCore, msgDiag, eDB, "openspcoopstate.updateDatabaseResource");
                        return;
                    }
                }
                if (e instanceof NodeTimeoutException) {
                    try {
                        msgDiag.logPersonalizzato("timeoutRicezioneRisposta");
                        msgRequest.aggiornaProprietarioMessaggio("GestoreMessaggi");
                        openspcoopstate.commit();
                    }
                    catch (Exception eDel) {
                        msgDiag.logErroreGenerico(eDel.getMessage(), "EliminazioneMessaggioScadutoTimeoutRicezioneRisposta");
                    }
                }
                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_513_RECEIVE));
                errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                openspcoopstate.releaseResource();
                return;
            }
            if (contenutoRispostaPresente) {
                msgDiag.setIdMessaggioRisposta(bustaRisposta.getID());
                msgDiag.addKeywords(bustaRisposta, false);
            } else {
                msgDiag.setIdMessaggioRisposta(idMessaggioSblocco);
            }
            parametriGenerazioneBustaErrore.setMsgDiag(msgDiag);
            parametriInvioBustaErrore.setMsgDiag(msgDiag);
            if (!portaStateless && !routingStateless) {
                try {
                    msgDiag.mediumDebug("Richiesta connessione al database per la gestione della risposta...");
                    openspcoopstate.updateResource(idTransazione);
                }
                catch (Exception e) {
                    this.setSOAPFault_processamento(logCore, msgDiag, e, "openspcoopstate.updateDatabaseResource");
                    return;
                }
                msgResponse = contenutoRispostaPresente != false ? new GestoreMessaggi(openspcoopstate, false, bustaRisposta.getID(), "OUTBOX", msgDiag, inRequestContext.getPddContext()) : new GestoreMessaggi(openspcoopstate, false, idMessaggioSblocco, "OUTBOX", msgDiag, inRequestContext.getPddContext());
                if (contenutoRispostaPresente || functionAsRouter) {
                    msgDiag.mediumDebug("Lettura messaggio di risposta...");
                    try {
                        responseMessage = msgResponse.getMessage();
                        idCorrelazioneApplicativaRisposta = msgResponse.getIDCorrelazioneApplicativaRisposta();
                    }
                    catch (Exception e) {
                        if (functionAsRouter && !contenutoRispostaPresente) ** GOTO lbl2027
                        msgDiag.logErroreGenerico(e, "msgResponse.getMessage()");
                        parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                        parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_511_READ_RESPONSE_MSG));
                        errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                        parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                        this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                        openspcoopstate.releaseResource();
                        return;
                    }
                }
            } else {
                responseMessage = ((OpenSPCoopStateless)openspcoopstate).getRispostaMsg();
                idCorrelazioneApplicativaRisposta = ((OpenSPCoopStateless)openspcoopstate).getIDCorrelazioneApplicativaRisposta();
            }
lbl2027:
            // 4 sources

            parametriGenerazioneBustaErrore.setCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
            parametriInvioBustaErrore.setCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
            msgDiag.setIdCorrelazioneRisposta(idCorrelazioneApplicativaRisposta);
            if (this.msgContext.getIntegrazione() != null) {
                this.msgContext.getIntegrazione().setIdCorrelazioneApplicativaRisposta(idCorrelazioneApplicativaRisposta);
            }
            if (contenutoRispostaPresente) {
                tras = null;
                if (propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente)) {
                    msgDiag.mediumDebug("Impostazione trasmissione nella busta di risposta...");
                    tras = new Trasmissione();
                    tras.setOrigine(identitaPdD.getNome());
                    tras.setTipoOrigine(identitaPdD.getTipo());
                    tras.setIdentificativoPortaOrigine(identitaPdD.getCodicePorta());
                    for (i = 0; i < bustaRichiesta.sizeListaTrasmissioni(); ++i) {
                        if (!identitaPdD.getTipo().equals(bustaRichiesta.getTrasmissione(i).getTipoDestinazione()) || !identitaPdD.getNome().equals(bustaRichiesta.getTrasmissione(i).getDestinazione())) continue;
                        tras.setDestinazione(bustaRichiesta.getTrasmissione(i).getOrigine());
                        tras.setTipoDestinazione(bustaRichiesta.getTrasmissione(i).getTipoOrigine());
                    }
                    if (tras.getDestinazione() == null || tras.getTipoDestinazione() == null) {
                        tras.setDestinazione(bustaRisposta.getDestinatario());
                        tras.setTipoDestinazione(bustaRisposta.getTipoDestinatario());
                    }
                    try {
                        dominio = registroServiziReader.getDominio(new IDSoggetto(tras.getTipoDestinazione(), tras.getDestinazione()), null, protocolFactory);
                        tras.setIdentificativoPortaDestinazione(dominio);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    tras.setOraRegistrazione(bustaRisposta.getOraRegistrazione());
                    tras.setTempo(propertiesReader.getTipoTempoBusta(implementazionePdDMittente));
                    bustaRisposta.addTrasmissione(tras);
                }
                scartaBody = false;
                if (!functionAsRouter) {
                    allegaBody = configurazionePdDReader.isAllegaBody(pa);
                    scartaBody = allegaBody != false ? true : configurazionePdDReader.isScartaBody(pa);
                }
                if (!functionAsRouter && bustaRisposta.sizeListaEccezioni() == 0 && moduleManager.isIgnoraEccezioniLivelloNonGrave()) {
                    for (i = 0; i < erroriValidazione.size(); ++i) {
                        ec = (Eccezione)erroriValidazione.get(i);
                        if (!LivelloRilevanza.INFO.equals(ec.getRilevanza())) continue;
                        bustaRisposta.addEccezione(ec);
                    }
                }
                msgDiag.mediumDebug("Imbustamento della risposta...");
                headerBustaRisposta = null;
                try {
                    gestioneManifestRisposta = false;
                    gestioneManifestRisposta = functionAsRouter != false ? configurazionePdDReader.isGestioneManifestAttachments() : (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) != false && RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString()) != false && pd != null ? configurazionePdDReader.isGestioneManifestAttachments(pd, protocolFactory) : configurazionePdDReader.isGestioneManifestAttachments(pa, protocolFactory));
                    if (!(!functionAsRouter || identitaPdD.getTipo().equals(bustaRisposta.getTipoMittente()) && identitaPdD.getNome().equals(bustaRisposta.getMittente()))) {
                        if (propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente)) {
                            headerBustaRisposta = imbustatore.addTrasmissione(responseMessage, tras, readQualifiedAttribute);
                        } else {
                            v = new Validatore(responseMessage, openspcoopstate.getStatoRichiesta(), logCore, protocolFactory);
                            headerBustaRisposta = v.getHeaderProtocollo_senzaControlli();
                        }
                    } else {
                        headerBustaRisposta = imbustatore.imbustamento(openspcoopstate.getStatoRichiesta(), responseMessage, bustaRisposta, infoIntegrazione, gestioneManifestRisposta, false, scartaBody, proprietaManifestAttachments);
                    }
                }
                catch (Exception e) {
                    if (!(!functionAsRouter || identitaPdD.getTipo().equals(bustaRisposta.getTipoMittente()) && identitaPdD.getNome().equals(bustaRisposta.getMittente()))) {
                        msgDiag.logErroreGenerico(e, "imbustatore.addTrasmissione(risposta)");
                    } else {
                        msgDiag.logErroreGenerico(e, "imbustatore.imbustamento(risposta)");
                    }
                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_526_GESTIONE_IMBUSTAMENTO));
                    errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                    parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                    this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                    openspcoopstate.releaseResource();
                    return;
                }
                mtomProcessor = null;
                if (!functionAsRouter && flowPropertiesResponse != null) {
                    msgDiag.mediumDebug("init MTOM Processor ...");
                    mtomProcessor = new MTOMProcessor(flowPropertiesResponse.mtom, flowPropertiesResponse.messageSecurity, tipoPorta);
                }
                if (mtomProcessor != null) {
                    try {
                        msgDiag.mediumDebug("MTOM Processor [BeforeSecurity]...");
                        mtomProcessor.mtomBeforeSecurity(responseMessage, TipoTraccia.RISPOSTA);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "MTOMProcessor(BeforeSec-" + mtomProcessor.getMTOMProcessorType() + ")");
                        parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                        parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR));
                        errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                        parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                        this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                        openspcoopstate.releaseResource();
                        return;
                    }
                }
                if (!functionAsRouter) {
                    msgDiag.mediumDebug("Applicazione MessageSecurity alla risposta...");
                    if (flowPropertiesResponse != null && flowPropertiesResponse.messageSecurity != null && flowPropertiesResponse.messageSecurity.getFlowParameters().size() > 0) {
                        try {
                            messageSecurityContext.setOutgoingProperties(flowPropertiesResponse.messageSecurity.getFlowParameters());
                            if (!messageSecurityContext.processOutgoing(responseMessage)) {
                                msgDiag.logErroreGenerico(messageSecurityContext.getMsgErrore(), "Costruzione header MessageSecurity Risposta");
                                parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                                parametriGenerazioneBustaErrore.setErroreCooperazione(ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(messageSecurityContext.getMsgErrore(), messageSecurityContext.getCodiceErrore()));
                                errorOpenSPCoopMsg = this.generaBustaErroreValidazione(parametriGenerazioneBustaErrore);
                                parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                                parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                                this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                                openspcoopstate.releaseResource();
                                return;
                            }
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "MessageSecurityProcessOutgoing");
                            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                            parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                            errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                            parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                            this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            openspcoopstate.releaseResource();
                            return;
                        }
                    }
                }
                if (mtomProcessor != null) {
                    try {
                        msgDiag.mediumDebug("MTOM Processor [AfterSecurity]...");
                        mtomProcessor.mtomAfterSecurity(responseMessage, TipoTraccia.RISPOSTA);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "MTOMProcessor(AfterSec-" + mtomProcessor.getMTOMProcessorType() + ")");
                        parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                        parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_557_MTOM_PROCESSOR_ERROR));
                        errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                        parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                        parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                        this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                        openspcoopstate.releaseResource();
                        return;
                    }
                }
                msgDiag.mediumDebug("Tracciamento busta di risposta...");
                if (this.msgContext.isTracciamentoAbilitato()) {
                    esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioInviato();
                    securityInfoResponse = null;
                    if (!functionAsRouter && messageSecurityContext != null && messageSecurityContext.getDigestReader() != null) {
                        validazioneSemantica = protocolFactory.createValidazioneSemantica();
                        securityInfoResponse = validazioneSemantica.readSecurityInformation(messageSecurityContext.getDigestReader(), responseMessage);
                    }
                    tracciamento.registraRisposta(responseMessage, securityInfoResponse, headerBustaRisposta, bustaRisposta, esitoTraccia, Tracciamento.createLocationString(false, this.msgContext.getFromLocation()), correlazioneApplicativa, idCorrelazioneApplicativaRisposta);
                }
                validatoreErrori = protocolFactory.createValidatoreErrori();
                protocolManager = protocolFactory.createProtocolManager();
                pValidazioneErrori = new ProprietaValidazioneErrori();
                pValidazioneErrori.setIgnoraEccezioniNonGravi(protocolManager.isIgnoraEccezioniNonGravi());
                pValidazioneErrori.setVersioneProtocollo(versioneProtocollo);
                if (validatoreErrori.isBustaErrore(bustaRisposta, responseMessage, pValidazioneErrori)) {
                    msgDiag.logPersonalizzato("generazioneMessaggioErroreRisposta");
                } else {
                    msgDiag.logPersonalizzato("generazioneMessaggioRisposta");
                }
                msgDiag.mediumDebug("Eliminazione accesso da PdD...");
                repositoryBuste.eliminaUtilizzoPdDFromOutBox(bustaRisposta.getID());
            }
            if (pa != null) {
                msgDiag.mediumDebug("Gestione header di integrazione messaggio di risposta...");
                headerIntegrazioneRisposta = new HeaderIntegrazione();
                headerIntegrazioneRisposta.setBusta(new HeaderIntegrazioneBusta());
                headerIntegrazioneRisposta.getBusta().setTipoMittente(bustaRichiesta.getTipoMittente());
                headerIntegrazioneRisposta.getBusta().setMittente(bustaRichiesta.getMittente());
                headerIntegrazioneRisposta.getBusta().setTipoDestinatario(bustaRichiesta.getTipoDestinatario());
                headerIntegrazioneRisposta.getBusta().setDestinatario(bustaRichiesta.getDestinatario());
                headerIntegrazioneRisposta.getBusta().setTipoServizio(bustaRichiesta.getTipoServizio());
                headerIntegrazioneRisposta.getBusta().setServizio(bustaRichiesta.getServizio());
                headerIntegrazioneRisposta.getBusta().setAzione(bustaRichiesta.getAzione());
                headerIntegrazioneRisposta.getBusta().setIdCollaborazione(bustaRichiesta.getCollaborazione());
                headerIntegrazioneRisposta.getBusta().setID(bustaRichiesta.getID());
                headerIntegrazioneRisposta.getBusta().setProfiloDiCollaborazione(bustaRichiesta.getProfiloDiCollaborazione());
                headerIntegrazioneRisposta.setIdApplicativo(correlazioneApplicativa);
                tipiIntegrazionePA_response = null;
                msgDiag.mediumDebug("Header integrazione...");
                if (functionAsRouter) {
                    msgDiag.highDebug("Header integrazione (Default gestori integrazione Router)");
                    tipiIntegrazionePA_response = RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.containsKey(protocolFactory.getProtocol()) ? RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.get(protocolFactory.getProtocol()) : RicezioneBuste.defaultGestoriIntegrazionePA;
                } else {
                    msgDiag.highDebug("Header integrazione (Gestori integrazione...)");
                    if (pa != null && this.msgContext.isTracciamentoAbilitato()) {
                        msgDiag.mediumDebug("Lettura header di integrazione...");
                        try {
                            tipiIntegrazionePA_response = configurazionePdDReader.getTipiIntegrazione(pa);
                        }
                        catch (Exception e) {
                            msgDiag.logErroreGenerico(e, "configurazionePdDReader.getTipiIntegrazione(pa)");
                            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                            parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
                            errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                            parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                            this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                            openspcoopstate.releaseResource();
                            return;
                        }
                        msgDiag.highDebug("Header integrazione (Gestori integrazione terminato)");
                        if (tipiIntegrazionePA_response == null) {
                            tipiIntegrazionePA_response = RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.containsKey(protocolFactory.getProtocol()) != false ? RicezioneBuste.defaultPerProtocolloGestoreIntegrazionePA.get(protocolFactory.getProtocol()) : RicezioneBuste.defaultGestoriIntegrazionePA;
                        }
                    }
                }
                outResponsePAMessage = new OutResponsePAMessage();
                outResponsePAMessage.setBustaRichiesta(bustaRichiesta);
                outResponsePAMessage.setMessage(responseMessage);
                propertiesIntegrazioneRisposta = new Properties();
                outResponsePAMessage.setProprietaTrasporto(propertiesIntegrazioneRisposta);
                outResponsePAMessage.setPortaDelegata(pd);
                outResponsePAMessage.setPortaApplicativa(pa);
                outResponsePAMessage.setSoggettoMittente(soggettoFruitore);
                outResponsePAMessage.setServizio(idServizio);
                for (i = 0; i < tipiIntegrazionePA_response.length; ++i) {
                    try {
                        classType = null;
                        gestore = null;
                        try {
                            classType = className.getIntegrazionePortaApplicativa(tipiIntegrazionePA_response[i]);
                            gestore = (IGestoreIntegrazionePA)loader.newInstance(classType);
                            AbstractCore.init(gestore, pddContext, protocolFactory, new Object[0]);
                        }
                        catch (Exception e) {
                            throw new Exception("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per la gestione dell'integrazione di tipo [" + tipiIntegrazionePA_response[i] + "]: " + e.getMessage());
                        }
                        if (gestore != null) {
                            if (gestore instanceof IGestoreIntegrazionePASoap) {
                                if (!propertiesReader.deleteHeaderIntegrazioneResponsePA()) continue;
                                if (responseMessage == null) {
                                    responseMessage = this.fac.createEmptySOAPMessage(versioneSoap);
                                    outResponsePAMessage.setMessage(responseMessage);
                                }
                                gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePAMessage);
                                continue;
                            }
                            if (responseMessage == null) {
                                responseMessage = this.fac.createEmptySOAPMessage(versioneSoap);
                                outResponsePAMessage.setMessage(responseMessage);
                            }
                            gestore.setOutResponseHeader(headerIntegrazioneRisposta, outResponsePAMessage);
                            continue;
                        }
                        msgDiag.logErroreGenerico("Creazione header di integrazione [" + tipiIntegrazionePA_response[i] + "] non riuscito, gestore non inizializzato", "setHeaderIntegrazioneRisposta");
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.addKeyword("@TIPO_HEADER_INTEGRAZIONE@", tipiIntegrazionePA_response[i]);
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.toString());
                        msgDiag.logPersonalizzato("headerIntegrazione.letturaFallita");
                    }
                }
                this.msgContext.setHeaderIntegrazioneRisposta(propertiesIntegrazioneRisposta);
            }
            if (oneWayStateless || sincronoStateless || asincronoStateless) {
                msgDiag.mediumDebug("Aggiorno proprietario messaggio richiesta ...");
                try {
                    openspcoopstate.commit();
                }
                catch (Exception e) {
                    logCore.error((Object)"Riscontrato errore durante l'aggiornamento proprietario messaggio", (Throwable)e);
                    msgDiag.logErroreGenerico(e, "openspcoopstate.commit(stateless risposta)");
                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
                    errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                    parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                    this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                    openspcoopstate.releaseResource();
                    return;
                }
            }
            if (oneWayVersione11) {
                msgDiag.mediumDebug("Commit della gestione oneWay stateful/stateless ibrido ...");
                try {
                    openspcoopstate.commit();
                }
                catch (Exception e) {
                    logCore.error((Object)"Riscontrato errore durante il commit della gestione oneWay stateful/stateless ibrido", (Throwable)e);
                    msgDiag.logErroreGenerico(e, "openspcoopstate.commit(oneway1.1 risposta)");
                    parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
                    parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
                    errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
                    parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
                    parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
                    this.sendRispostaBustaErrore(parametriInvioBustaErrore);
                    openspcoopstate.releaseResource();
                    return;
                }
            }
            if (!portaStateless && !routingStateless) {
                msgDiag.mediumDebug("Aggiornamento proprietario messaggio...");
                msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                msgDiag.mediumDebug("Commit delle operazioni per la gestione della risposta...");
                openspcoopstate.commit();
                if (msgResponse != null) {
                    msgResponse.addMessaggiIntoCache_readFromTable("RicezioneBuste", "risposta");
                }
                if (msgResponse != null) {
                    msgResponse.addProprietariIntoCache_readFromTable("RicezioneBuste", "risposta", idMessageRequest, functionAsRouter);
                }
            }
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta effettuato, rilascio della connessione...");
            openspcoopstate.releaseResource();
            msgDiag.mediumDebug("Imposto risposta nel context...");
            this.msgContext.setMessageResponse(responseMessage);
            msgDiag.mediumDebug("Lavoro Terminato.");
        }
        catch (Exception e) {
            logCore.error((Object)"ErroreGenerale", (Throwable)e);
            msgDiag.logErroreGenerico(e, "Generale");
            parametriGenerazioneBustaErrore.setBusta(bustaRichiesta);
            parametriGenerazioneBustaErrore.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione());
            errorOpenSPCoopMsg = this.generaBustaErroreProcessamento(parametriGenerazioneBustaErrore, e);
            parametriInvioBustaErrore.setOpenspcoopMsg(errorOpenSPCoopMsg);
            parametriInvioBustaErrore.setBusta(parametriGenerazioneBustaErrore.getBusta());
            this.sendRispostaBustaErrore(parametriInvioBustaErrore);
            openspcoopstate.releaseResource();
            return;
        }
    }

    private void setCredenziali(Credenziali credenziali, MsgDiagnostico msgDiag) {
        String credenzialiFornite = "";
        if (credenziali != null) {
            credenzialiFornite = credenziali.toString();
        }
        msgDiag.addKeyword("@CREDENZIALI@", credenzialiFornite);
    }

    private OpenSPCoop2Message generaBustaErroreProcessamento(RicezioneBusteParametriGenerazioneBustaErrore parametriGenerazioneBustaErrore, Exception e) {
        parametriGenerazioneBustaErrore.setErroreProcessamento(true);
        parametriGenerazioneBustaErrore.setEccezioneProcessamento(e);
        return this.generaBustaErrore(parametriGenerazioneBustaErrore);
    }

    private OpenSPCoop2Message generaBustaErroreValidazione(RicezioneBusteParametriGenerazioneBustaErrore parametriGenerazioneBustaErrore) {
        parametriGenerazioneBustaErrore.setErroreProcessamento(false);
        return this.generaBustaErrore(parametriGenerazioneBustaErrore);
    }

    private OpenSPCoop2Message generaBustaErrore(RicezioneBusteParametriGenerazioneBustaErrore parametriGenerazioneBustaErrore) {
        String idTransazione = (String)this.msgContext.getPddContext().getObject("ID");
        SOAPVersion versioneSoap = (SOAPVersion)this.msgContext.getPddContext().getObject("SOAP_VERSION");
        try {
            OpenSPCoop2Message responseErrorMessage = null;
            ErroreCooperazione erroreCooperazione = parametriGenerazioneBustaErrore.getErroreCooperazione();
            ErroreIntegrazione erroreIntegrazione = parametriGenerazioneBustaErrore.getErroreIntegrazione();
            List<Eccezione> error = parametriGenerazioneBustaErrore.getError();
            Imbustamento imbustatore = parametriGenerazioneBustaErrore.getImbustatore();
            IDSoggetto identitaPdD = parametriGenerazioneBustaErrore.getIdentitaPdD();
            Hashtable<String, Object> securityPropertiesResponse = null;
            if (parametriGenerazioneBustaErrore.getFlowPropertiesResponse() != null && parametriGenerazioneBustaErrore.getFlowPropertiesResponse().messageSecurity != null) {
                securityPropertiesResponse = parametriGenerazioneBustaErrore.getFlowPropertiesResponse().messageSecurity.getFlowParameters();
            }
            MessageSecurityContext messageSecurityContext = parametriGenerazioneBustaErrore.getMessageSecurityContext();
            OpenSPCoop2Properties propertiesReader = parametriGenerazioneBustaErrore.getPropertiesReader();
            String profiloGestione = parametriGenerazioneBustaErrore.getProfiloGestione();
            String implementazionePdDMittente = parametriGenerazioneBustaErrore.getImplementazionePdDMittente();
            Tracciamento tracciamento = parametriGenerazioneBustaErrore.getTracciamento();
            MsgDiagnostico msgDiag = parametriGenerazioneBustaErrore.getMsgDiag();
            Integrazione integrazione = parametriGenerazioneBustaErrore.getIntegrazione();
            if (integrazione == null) {
                integrazione = new Integrazione();
                integrazione.setIdModuloInAttesa(this.msgContext.getIdModulo());
            }
            IOpenSPCoopState openspcoopState = parametriGenerazioneBustaErrore.getOpenspcoop();
            if (parametriGenerazioneBustaErrore.isErroreProcessamento()) {
                responseErrorMessage = erroreCooperazione != null ? imbustatore.msgErroreProtocollo_Processamento(openspcoopState.getStatoRichiesta(), identitaPdD, this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, erroreCooperazione, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), parametriGenerazioneBustaErrore.getEccezioneProcessamento(), versioneSoap, propertiesReader.isForceSoapPrefixCompatibilitaOpenSPCoopV1()) : (erroreIntegrazione != null ? imbustatore.msgErroreProtocollo_Processamento(openspcoopState.getStatoRichiesta(), identitaPdD, this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, erroreIntegrazione, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), parametriGenerazioneBustaErrore.getEccezioneProcessamento(), versioneSoap, propertiesReader.isForceSoapPrefixCompatibilitaOpenSPCoopV1()) : imbustatore.msgErroreProtocollo_Processamento(openspcoopState.getStatoRichiesta(), identitaPdD, this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, error, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), parametriGenerazioneBustaErrore.getEccezioneProcessamento(), versioneSoap, propertiesReader.isForceSoapPrefixCompatibilitaOpenSPCoopV1()));
            } else if (erroreCooperazione != null) {
                responseErrorMessage = imbustatore.msgErroreProtocollo_Validazione(openspcoopState.getStatoRichiesta(), identitaPdD, this.msgContext.getIdModulo(), parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, erroreCooperazione, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), versioneSoap, propertiesReader.isForceSoapPrefixCompatibilitaOpenSPCoopV1());
            } else {
                if (erroreIntegrazione != null) {
                    throw new Exception("Method 'generaBustaErroreValidazione' not supported for MessaggioErroreIntegrazione");
                }
                responseErrorMessage = imbustatore.msgErroreProtocollo_Validazione(openspcoopState.getStatoRichiesta(), identitaPdD, this.msgContext.getIdModulo(), parametriGenerazioneBustaErrore.getBusta(), integrazione, idTransazione, error, securityPropertiesResponse, messageSecurityContext, propertiesReader.getGestioneSerializableDB_AttesaAttiva(), propertiesReader.getGestioneSerializableDB_CheckInterval(), profiloGestione, propertiesReader.getTipoTempoBusta(implementazionePdDMittente), propertiesReader.isGenerazioneListaTrasmissioni(implementazionePdDMittente), versioneSoap, propertiesReader.isForceSoapPrefixCompatibilitaOpenSPCoopV1());
            }
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject("PROTOCOLLO"));
            if (this.msgContext.isTracciamentoAbilitato()) {
                EsitoElaborazioneMessaggioTracciato esitoTraccia = EsitoElaborazioneMessaggioTracciato.getEsitoElaborazioneMessaggioInviato();
                SecurityInfo securityInfoResponse = null;
                boolean functionAsRouter = false;
                if (functionAsRouter && messageSecurityContext != null && messageSecurityContext.getDigestReader() != null) {
                    IValidazioneSemantica validazioneSemantica = protocolFactory.createValidazioneSemantica();
                    securityInfoResponse = validazioneSemantica.readSecurityInformation(messageSecurityContext.getDigestReader(), responseErrorMessage);
                }
                Validatore v = new Validatore(responseErrorMessage, openspcoopState.getStatoRichiesta(), parametriGenerazioneBustaErrore.getLogCore(), protocolFactory);
                tracciamento.registraRisposta(responseErrorMessage, securityInfoResponse, v.getHeaderProtocollo_senzaControlli(), parametriGenerazioneBustaErrore.getBusta(), esitoTraccia, Tracciamento.createLocationString(false, this.msgContext.getFromLocation()), parametriGenerazioneBustaErrore.getCorrelazioneApplicativa(), parametriGenerazioneBustaErrore.getCorrelazioneApplicativaRisposta());
            }
            msgDiag.addKeywords(parametriGenerazioneBustaErrore.getBusta(), false);
            IProtocolManager protocolManager = protocolFactory.createProtocolManager();
            if (!protocolManager.getKeywordMittenteSconosciuto().equals(parametriGenerazioneBustaErrore.getBusta().getDestinatario()) && !protocolManager.getKeywordTipoMittenteSconosciuto().equals(parametriGenerazioneBustaErrore.getBusta().getTipoDestinatario())) {
                msgDiag.logPersonalizzato("generazioneMessaggioErroreRisposta");
            } else {
                msgDiag.logPersonalizzato("generazioneMessaggioErroreRisposta.destinatarioSconosciuto");
            }
            msgDiag.setIdMessaggioRisposta(parametriGenerazioneBustaErrore.getBusta().getID());
            this.msgContext.getProtocol().setIdRisposta(parametriGenerazioneBustaErrore.getBusta().getID());
            return responseErrorMessage;
        }
        catch (Exception e) {
            return this.fac.createFaultMessage(versioneSoap, "ErroreGenerazioneMessaggioRispostaErrore: " + e.getMessage());
        }
    }

    private void sendRispostaBustaErrore(RicezioneBusteParametriInvioBustaErrore parametriInvioBustaErrore) {
        this.sendRispostaBustaErrore(parametriInvioBustaErrore, true);
    }

    private void sendRispostaBustaErrore(RicezioneBusteParametriInvioBustaErrore parametriInvioBustaErrore, boolean eliminaMessaggioRicevuto) {
        GestoreMessaggi msgResponse = null;
        RepositoryBuste repositoryBuste = null;
        boolean httpReply = true;
        IOpenSPCoopState openspcoop = parametriInvioBustaErrore.getOpenspcoop();
        Busta bustaRisposta = parametriInvioBustaErrore.getBusta();
        MsgDiagnostico msgDiag = parametriInvioBustaErrore.getMsgDiag();
        Logger logCore = parametriInvioBustaErrore.getLogCore();
        PdDContext pddContext = parametriInvioBustaErrore.getPddContext();
        SOAPVersion versioneSoap = (SOAPVersion)this.msgContext.getPddContext().getObject("SOAP_VERSION");
        try {
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
            if (eliminaMessaggioRicevuto && parametriInvioBustaErrore.isOnewayVersione11()) {
                GestoreMessaggi msgRichiesta = new GestoreMessaggi(openspcoop, true, bustaRisposta.getRiferimentoMessaggio(), "INBOX", logCore, msgDiag, pddContext);
                msgRichiesta.setReadyForDrop(true);
                msgRichiesta.aggiornaProprietarioMessaggio("GestoreMessaggi");
                RepositoryBuste repositoryBustaRichiesta = new RepositoryBuste(openspcoop.getStatoRichiesta(), true, protocolFactory);
                repositoryBustaRichiesta.eliminaBustaStatelessFromInBox(bustaRisposta.getRiferimentoMessaggio());
            }
            if (parametriInvioBustaErrore.isNewConnectionForResponse()) {
                httpReply = false;
            }
            if (bustaRisposta.getIndirizzoDestinatario() != null && parametriInvioBustaErrore.isUtilizzoIndirizzoTelematico()) {
                httpReply = false;
            }
            if (!httpReply) {
                repositoryBuste = new RepositoryBuste(openspcoop.getStatoRisposta(), false, protocolFactory);
                repositoryBuste.registraBustaIntoOutBox(bustaRisposta, parametriInvioBustaErrore.getPropertiesReader().getRepositoryIntervalloScadenzaMessaggi());
                Integrazione infoIntegrazione = new Integrazione();
                repositoryBuste.aggiornaInfoIntegrazioneIntoOutBox(bustaRisposta.getID(), infoIntegrazione);
                msgResponse = new GestoreMessaggi(openspcoop, true, bustaRisposta.getID(), "OUTBOX", msgDiag, pddContext);
                msgResponse.setOneWayVersione11(parametriInvioBustaErrore.isOnewayVersione11());
                msgResponse.registraMessaggio(parametriInvioBustaErrore.getOpenspcoopMsg(), parametriInvioBustaErrore.getCorrelazioneApplicativa(), parametriInvioBustaErrore.getCorrelazioneApplicativaRisposta());
                msgResponse.aggiornaRiferimentoMessaggio(bustaRisposta.getRiferimentoMessaggio());
                msgResponse.aggiornaProprietarioMessaggio("InoltroRisposte");
                EJBUtils ejb = new EJBUtils(parametriInvioBustaErrore.getIdentitaPdD(), this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), bustaRisposta.getRiferimentoMessaggio(), bustaRisposta.getID(), "OUTBOX", openspcoop, msgDiag, parametriInvioBustaErrore.isFunctionAsRouter(), parametriInvioBustaErrore.getImplementazionePdDMittente(), parametriInvioBustaErrore.getImplementazionePdDDestinatario(), parametriInvioBustaErrore.getProfiloGestione(), parametriInvioBustaErrore.getPddContext());
                ejb.sendToInoltroRisposte(bustaRisposta, false, null, msgResponse, parametriInvioBustaErrore.getCorrelazioneApplicativa(), parametriInvioBustaErrore.getCorrelazioneApplicativaRisposta(), parametriInvioBustaErrore.getServizioApplicativoFruitore(), false);
                OpenSPCoop2Message soapBodyEmpty = SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap);
                this.msgContext.setMessageResponse(soapBodyEmpty);
            } else {
                OpenSPCoop2Message risposta = parametriInvioBustaErrore.getOpenspcoopMsg();
                this.msgContext.setMessageResponse(risposta);
            }
            openspcoop.commit();
            if (msgResponse != null) {
                msgResponse.addMessaggiIntoCache_readFromTable(ID_MODULO, "risposta verso nuova connessione");
            }
            if (msgResponse != null) {
                msgResponse.addProprietariIntoCache_readFromTable(ID_MODULO, "risposta verso nuova connessione", bustaRisposta.getRiferimentoMessaggio(), parametriInvioBustaErrore.isFunctionAsRouter());
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "sendRispostaBustaErrore");
            try {
                IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject("PROTOCOLLO"));
                Imbustamento protocolErroreBuilder = new Imbustamento(protocolFactory);
                this.msgContext.setMessageResponse(protocolErroreBuilder.buildSoapFaultProtocollo_processamento(this.msgContext.getIdentitaPdD(), this.msgContext.getTipoPorta(), this.msgContext.getIdModulo(), ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e, versioneSoap, parametriInvioBustaErrore.getPropertiesReader().isForceSoapPrefixCompatibilitaOpenSPCoopV1()));
            }
            catch (Exception eBustaErrore) {
                this.msgContext.setMessageResponse(this.fac.createFaultMessage(versioneSoap, "ErroreSendBustaErrore: " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlowProperties getFlowPropertiesRequest(Busta bustaRichiesta, ConfigurazionePdDManager configurazionePdDReader, StateMessage state, MsgDiagnostico msgDiag, Logger logCore, OpenSPCoop2Properties properties, RuoloBusta ruoloBustaRicevuta, String implementazionePdDMittente, PdDContext pddContext, PortaApplicativa paFind) throws DriverConfigurazioneException {
        FlowProperties flowProperties = new FlowProperties();
        flowProperties.tipoMessaggio = TipoTraccia.RICHIESTA;
        org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            IDPortaApplicativaByNome idPAbyNome;
            PortaApplicativa pa;
            IDPortaApplicativa idPA;
            PortaDelegata pd;
            IDPortaDelegata idPD;
            RepositoryBuste repository;
            Integrazione integrazione;
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
            if (bustaRichiesta.getProfiloDiCollaborazione() == null && bustaRichiesta.sizeListaRiscontri() > 0 && properties.isGestioneRiscontri(implementazionePdDMittente) && (integrazione = (repository = new RepositoryBuste((IState)state, true, protocolFactory)).getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiscontro(0).getID())).getLocationPD() != null) {
                idPD = new IDPortaDelegata();
                idPD.setLocationPD(integrazione.getLocationPD());
                idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForReceiver(pd);
                flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForReceiver(pd);
            }
            if (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                    pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForReceiver(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForReceiver(pa);
                } else {
                    repository = new RepositoryBuste((IState)state, false, protocolFactory);
                    integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    idPD = new IDPortaDelegata();
                    idPD.setLocationPD(integrazione.getLocationPD());
                    idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                    pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                    flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForReceiver(pd);
                    flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForReceiver(pd);
                    flowProperties.tipoMessaggio = TipoTraccia.RISPOSTA;
                }
            } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                    pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForReceiver(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForReceiver(pa);
                } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    repository = new RepositoryBuste((IState)state, false, protocolFactory);
                    integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    idPD = new IDPortaDelegata();
                    idPD.setLocationPD(integrazione.getLocationPD());
                    idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                    pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                    flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForSender(pd);
                    flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForSender(pd);
                } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                    repository = new RepositoryBuste((IState)state, true, protocolFactory);
                    integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    idPD = new IDPortaDelegata();
                    idPD.setLocationPD(integrazione.getLocationPD());
                    idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                    pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                    flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForReceiver(pd);
                    flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForReceiver(pd);
                    flowProperties.tipoMessaggio = TipoTraccia.RISPOSTA;
                } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    repository = new RepositoryBuste((IState)state, false, protocolFactory);
                    integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    idPD = new IDPortaDelegata();
                    idPD.setLocationPD(integrazione.getLocationPD());
                    idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                    pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                    flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForReceiver(pd);
                    flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForReceiver(pd);
                    flowProperties.tipoMessaggio = TipoTraccia.RISPOSTA;
                }
            } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                    pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForReceiver(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForReceiver(pa);
                } else {
                    profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione((IState)state, protocolFactory);
                    if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                        IDPortaApplicativaByNome idPAbyNome2;
                        idPA = new IDPortaApplicativa();
                        IDServizio idServizioOriginale = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getRiferimentoMessaggio());
                        idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), idServizioOriginale.getTipoServizio(), idServizioOriginale.getServizio(), idServizioOriginale.getAzione()));
                        PortaApplicativa pa2 = paFind;
                        if (pa2 == null && (idPAbyNome2 = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                            pa2 = configurazionePdDReader.getPortaApplicativa(idPAbyNome2);
                        }
                        flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForReceiver(pa2);
                        flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForReceiver(pa2);
                    } else if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                        repository = new RepositoryBuste((IState)state, true, protocolFactory);
                        integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                        idPD = new IDPortaDelegata();
                        idPD.setLocationPD(integrazione.getLocationPD());
                        idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                        pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                        flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForReceiver(pd);
                        flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForReceiver(pd);
                        flowProperties.tipoMessaggio = TipoTraccia.RISPOSTA;
                    } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                        repository = new RepositoryBuste((IState)state, false, protocolFactory);
                        integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                        idPD = new IDPortaDelegata();
                        idPD.setLocationPD(integrazione.getLocationPD());
                        idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                        pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                        flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForReceiver(pd);
                        flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForReceiver(pd);
                        flowProperties.tipoMessaggio = TipoTraccia.RISPOSTA;
                    }
                }
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "lettura_MessageSecurity_MTOM_RequestProperties");
            logCore.error((Object)"Lettura dati Message-Security / MTOM per la ricezione del messaggio non riuscita", (Throwable)e);
        }
        finally {
            if (profiloCollaborazione != null) {
                state.closePreparedStatement();
            }
        }
        return flowProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlowProperties getFlowPropertiesResponse(Busta bustaRichiesta, ConfigurazionePdDManager configurazionePdDReader, StateMessage state, MsgDiagnostico msgDiag, Logger logCore, OpenSPCoop2Properties properties, RuoloBusta ruoloBustaRicevuta, String implementazionePdDMittente, PdDContext pddContext, PortaApplicativa paFind) throws DriverConfigurazioneException {
        FlowProperties flowProperties = new FlowProperties();
        flowProperties.tipoMessaggio = TipoTraccia.RISPOSTA;
        org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
            if (bustaRichiesta.getProfiloDiCollaborazione() == null && bustaRichiesta.sizeListaRiscontri() > 0 && properties.isGestioneRiscontri(implementazionePdDMittente)) {
                if (bustaRichiesta.getTipoServizio() != null && bustaRichiesta.getServizio() != null) {
                    IDPortaApplicativaByNome idPAbyNome;
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                    PortaApplicativa pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForSender(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForSender(pa);
                }
            } else if (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                IDPortaApplicativaByNome idPAbyNome;
                IDPortaApplicativa idPA = new IDPortaApplicativa();
                idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                PortaApplicativa pa = paFind;
                if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                    pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                }
                flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForSender(pa);
                flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForSender(pa);
            } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    IDPortaApplicativaByNome idPAbyNome;
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                    PortaApplicativa pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForSender(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForSender(pa);
                } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    RepositoryBuste repository = new RepositoryBuste((IState)state, false, protocolFactory);
                    Integrazione integrazione = repository.getInfoIntegrazioneFromOutBox(bustaRichiesta.getRiferimentoMessaggio());
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setLocationPD(integrazione.getLocationPD());
                    idPD.setSoggettoFruitore(new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario()));
                    PortaDelegata pd = configurazionePdDReader.getPortaDelegata_SafeMethod(idPD);
                    flowProperties.messageSecurity = configurazionePdDReader.getPD_MessageSecurityForSender(pd);
                    flowProperties.mtom = configurazionePdDReader.getPD_MTOMProcessorForSender(pd);
                }
            } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione((IState)state, protocolFactory);
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    IDPortaApplicativaByNome idPAbyNome;
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), bustaRichiesta.getTipoServizio(), bustaRichiesta.getServizio(), bustaRichiesta.getAzione()));
                    PortaApplicativa pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForSender(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForSender(pa);
                } else if (RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    IDPortaApplicativaByNome idPAbyNome;
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    IDServizio idServizioOriginale = profiloCollaborazione.asincronoAsimmetrico_getDatiConsegnaRisposta(bustaRichiesta.getRiferimentoMessaggio());
                    idPA.setIDServizio(new IDServizio(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), idServizioOriginale.getTipoServizio(), idServizioOriginale.getServizio(), idServizioOriginale.getAzione()));
                    PortaApplicativa pa = paFind;
                    if (pa == null && (idPAbyNome = configurazionePdDReader.convertTo_SafeMethod(idPA.getIDServizio(), this.msgContext.getProprietaFiltroPortaApplicativa())) != null) {
                        pa = configurazionePdDReader.getPortaApplicativa(idPAbyNome);
                    }
                    flowProperties.messageSecurity = configurazionePdDReader.getPA_MessageSecurityForSender(pa);
                    flowProperties.mtom = configurazionePdDReader.getPA_MTOMProcessorForSender(pa);
                }
            }
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "lettura_MessageSecurity_MTOM_ResponseProperties");
            logCore.error((Object)"Lettura dati Message-Security / MTOM per la spedizione del messaggio di risposta non riuscita", (Throwable)e);
        }
        finally {
            if (profiloCollaborazione != null) {
                state.closePreparedStatement();
            }
        }
        return flowProperties;
    }

    private boolean gestioneRispostaAsincrona_checkPresenzaRichiesta(long scadenzaControllo, int checkInterval, Busta bustaRichiesta, IOpenSPCoopState openspcoopstate, MsgDiagnostico msgDiag, boolean newConnectionForResponse, PdDContext pddContext) throws Exception {
        boolean attendiTerminazioneRichiesta = false;
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
        boolean isRicevutaRichiesta = false;
        boolean isRicevutaRisposta = false;
        if (newConnectionForResponse && (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) && bustaRichiesta.getRiferimentoMessaggio() != null) {
            org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta(), protocolFactory);
            isRicevutaRichiesta = profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRichiesta.getRiferimentoMessaggio());
            isRicevutaRisposta = profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRichiesta.getRiferimentoMessaggio());
        }
        while (DateManager.getTimeMillis() < scadenzaControllo) {
            GestoreMessaggi checkRichiesta;
            String idRichiesta;
            msgDiag.mediumDebug("RICHIESTA  NOW[" + DateManager.getTimeMillis() + "] < SCADENZA[" + scadenzaControllo + "]");
            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (!newConnectionForResponse || isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRichiesta == null) {
                    idRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRichiesta = (checkRichiesta = new GestoreMessaggi(openspcoopstate, false, idRichiesta, "OUTBOX", msgDiag, pddContext)).existsMessageInProcessamento())) {
                    break;
                }
            } else {
                if (!ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (!newConnectionForResponse || isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRichiesta == null) {
                    idRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRichiesta = (checkRichiesta = new GestoreMessaggi(openspcoopstate, false, idRichiesta, "INBOX", msgDiag, pddContext)).existsMessageInProcessamento())) break;
            }
            msgDiag.mediumDebug("Busta di risposta con profilo [" + bustaRichiesta.getProfiloDiCollaborazione() + "] non gestibile, si attende il completamento" + " della gestione della richiesta");
            try {
                Thread.sleep(checkInterval);
            }
            catch (Exception eRandom) {}
        }
        return attendiTerminazioneRichiesta;
    }

    private boolean gestioneRispostaAsincrona_checkPresenzaRicevutaRichiesta(long scadenzaControllo, int checkInterval, Busta bustaRichiesta, IOpenSPCoopState openspcoopstate, MsgDiagnostico msgDiag, boolean newConnectionForResponse, PdDContext pddContext) throws Exception {
        boolean attendiTerminazioneRicevutaRichiesta = false;
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
        boolean isRicevutaRichiesta = false;
        boolean isRicevutaRisposta = false;
        if (newConnectionForResponse && (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) && bustaRichiesta.getRiferimentoMessaggio() != null) {
            org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta(), protocolFactory);
            isRicevutaRichiesta = profiloCollaborazione.asincrono_isRicevutaRichiesta(bustaRichiesta.getRiferimentoMessaggio());
            isRicevutaRisposta = profiloCollaborazione.asincrono_isRicevutaRisposta(bustaRichiesta.getRiferimentoMessaggio());
        }
        while (DateManager.getTimeMillis() < scadenzaControllo) {
            GestoreMessaggi checkRicevutaRichiesta;
            String idRicevutaRichiesta;
            msgDiag.mediumDebug("RICEVUTA RICHIESTA  NOW[" + DateManager.getTimeMillis() + "] < SCADENZA[" + scadenzaControllo + "]");
            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (!newConnectionForResponse || isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRicevutaRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRicevutaRichiesta == null) {
                    idRicevutaRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRicevutaRichiesta = (checkRicevutaRichiesta = new GestoreMessaggi(openspcoopstate, false, idRicevutaRichiesta, "INBOX", msgDiag, pddContext)).existsMessageInProcessamentoByReference())) {
                    break;
                }
            } else {
                if (!ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || bustaRichiesta.getRiferimentoMessaggio() == null && (bustaRichiesta.getCollaborazione() == null || bustaRichiesta.getCollaborazione().equals(bustaRichiesta.getID())) || newConnectionForResponse && (!newConnectionForResponse || isRicevutaRichiesta || isRicevutaRisposta)) break;
                idRicevutaRichiesta = bustaRichiesta.getRiferimentoMessaggio();
                if (idRicevutaRichiesta == null) {
                    idRicevutaRichiesta = bustaRichiesta.getCollaborazione();
                }
                if (!(attendiTerminazioneRicevutaRichiesta = (checkRicevutaRichiesta = new GestoreMessaggi(openspcoopstate, false, idRicevutaRichiesta, "OUTBOX", msgDiag, pddContext)).existsMessageInProcessamentoByReference())) break;
            }
            msgDiag.mediumDebug("Busta di risposta con profilo [" + bustaRichiesta.getProfiloDiCollaborazione() + "] non gestibile, si attende il completamento" + " della gestione della ricevuta alla richiesta");
            try {
                Thread.sleep(checkInterval);
            }
            catch (Exception eRandom) {}
        }
        return attendiTerminazioneRicevutaRichiesta;
    }

    private OpenSPCoop2Message generaRisposta_msgGiaRicevuto(boolean printMsg, Busta bustaRichiesta, Integrazione integrazione, MsgDiagnostico msgDiag, IOpenSPCoopState openspcoopstate, Logger log, ConfigurazionePdDManager config, OpenSPCoop2Properties properties, String profiloGestione, RuoloBusta ruoloBustaRicevuta, String implementazionePdDMittente, IProtocolFactory protocolFactory) throws ProtocolException {
        RepositoryBuste repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRichiesta(), true, protocolFactory);
        SOAPVersion versioneSoap = (SOAPVersion)this.msgContext.getPddContext().getObject("SOAP_VERSION");
        Busta bustaHTTPReply = null;
        if (printMsg) {
            msgDiag.logPersonalizzato("sbustamentoBusta.", "ricezioneBustaDuplicata");
        }
        IProtocolVersionManager imbustamentoModule = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.msgContext.getPddContext().getObject("PROTOCOLLO")).createProtocolVersionManager(profiloGestione);
        boolean consegnaAffidabile = false;
        switch (imbustamentoModule.getConsegnaAffidabile(bustaRichiesta.getProfiloDiCollaborazione())) {
            case ABILITATA: {
                consegnaAffidabile = true;
                break;
            }
            case DISABILITATA: {
                consegnaAffidabile = false;
                break;
            }
            default: {
                boolean bl = consegnaAffidabile = properties.isGestioneRiscontri(implementazionePdDMittente) && bustaRichiesta.isConfermaRicezione();
            }
        }
        if (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) && consegnaAffidabile) {
            msgDiag.logPersonalizzato("generazioneRiscontro");
            TipoOraRegistrazione tipoOraRegistrazione = properties.getTipoTempoBusta(implementazionePdDMittente);
            bustaHTTPReply = bustaRichiesta.invertiBusta(tipoOraRegistrazione, protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
            Riscontro r = new Riscontro();
            r.setID(bustaHTTPReply.getID());
            r.setOraRegistrazione(DateManager.getDate());
            r.setTipoOraRegistrazione(properties.getTipoTempoBusta(implementazionePdDMittente));
            bustaHTTPReply.addRiscontro(r);
        } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
            String ricevuta = null;
            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione())) {
                if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                    ricevuta = "ricevuta di una richiesta asincrona simmetrica";
                } else if (ruoloBustaRicevuta != null && RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                    ricevuta = "ricevuta di una risposta asincrona simmetrica";
                }
            } else if (bustaRichiesta.getRiferimentoMessaggio() == null) {
                ricevuta = "ricevuta di una richiesta asincrona asimmetrica";
            } else if (ruoloBustaRicevuta != null && RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                ricevuta = "ricevuta di una risposta asincrona asimmetrica";
            }
            if (ricevuta != null) {
                msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", ricevuta);
                msgDiag.logPersonalizzato("generazioneRicevutaAsincrona");
                TipoOraRegistrazione tipoOraRegistrazione = properties.getTipoTempoBusta(implementazionePdDMittente);
                bustaHTTPReply = bustaRichiesta.invertiBusta(tipoOraRegistrazione, protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                bustaHTTPReply.setVersioneServizio(bustaRichiesta.getVersioneServizio());
                bustaHTTPReply.setServizio(bustaRichiesta.getServizio());
                bustaHTTPReply.setTipoServizio(bustaRichiesta.getTipoServizio());
                bustaHTTPReply.setAzione(bustaRichiesta.getAzione());
                bustaHTTPReply.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                bustaHTTPReply.setRiferimentoMessaggio(bustaRichiesta.getID());
                if (properties.isGestioneElementoCollaborazione(implementazionePdDMittente)) {
                    bustaHTTPReply.setCollaborazione(bustaRichiesta.getCollaborazione());
                }
            }
        }
        try {
            repositoryBuste.aggiornaDuplicatiIntoInBox(bustaRichiesta.getID());
            openspcoopstate.commit();
        }
        catch (Exception e) {
            log.error((Object)("Aggiornamento numero duplicati per busta [" + bustaRichiesta.getID() + "] non riuscito: " + e.getMessage()));
        }
        if (bustaHTTPReply == null) {
            return SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap);
        }
        Imbustamento imbustatore = new Imbustamento(log, protocolFactory);
        OpenSPCoop2Message msg = SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap);
        imbustatore.imbustamento(openspcoopstate.getStatoRichiesta(), msg, bustaHTTPReply, integrazione, false, false, false, null);
        return msg;
    }

    private EsitoLib chiamaLibreria(OpenSPCoopStateless openspcoopstate, Logger log) throws OpenSPCoopStateException, GenericLibException {
        if (openspcoopstate.getDestinatarioRequestMsgLib().startsWith("Sbustamento")) {
            Sbustamento lib = new Sbustamento(log);
            return lib.onMessage(openspcoopstate);
        }
        if (openspcoopstate.getDestinatarioRequestMsgLib().startsWith("ConsegnaContenutiApplicativi")) {
            ConsegnaContenutiApplicativi lib = new ConsegnaContenutiApplicativi(log);
            EsitoLib result = lib.onMessage(openspcoopstate);
            if (result.getStatoInvocazione() == 1) {
                openspcoopstate.setDestinatarioRequestMsgLib("");
            }
            return result;
        }
        if (openspcoopstate.getDestinatarioResponseMsgLib().startsWith("ImbustamentoRisposte")) {
            ImbustamentoRisposte lib = new ImbustamentoRisposte(log);
            return lib.onMessage(openspcoopstate);
        }
        if (openspcoopstate.getDestinatarioResponseMsgLib().startsWith("InoltroRisposte")) {
            InoltroRisposte lib = new InoltroRisposte(log);
            return lib.onMessage(openspcoopstate);
        }
        throw new OpenSPCoopStateException("RicezioneBuste.chiamaLibreria: nome libreria non valido");
    }

    private IDServizio getIdServizioPerAutorizzazione(IDServizio idServizio, IDSoggetto soggettoFruitore, boolean functionAsRouter, Busta bustaRichiesta, RuoloBusta ruoloBustaRicevuta) {
        IDServizio idServizioPerAutorizzazione = new IDServizio();
        idServizioPerAutorizzazione.setServizio(idServizio.getServizio());
        idServizioPerAutorizzazione.setTipoServizio(idServizio.getTipoServizio());
        idServizioPerAutorizzazione.setUriAccordo(idServizio.getUriAccordo());
        idServizioPerAutorizzazione.setAzione(idServizio.getAzione());
        idServizioPerAutorizzazione.setTipologiaServizio(idServizio.getTipologiaServizio());
        IDSoggetto soggettoDestinatarioPerAutorizzazione = null;
        soggettoDestinatarioPerAutorizzazione = functionAsRouter ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()) : (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione()) ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()) : (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) ? (ruoloBustaRicevuta == null ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()) : (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString()) ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()) : new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()))) : (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) ? (ruoloBustaRicevuta == null ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()) : (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString()) ? new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()) : new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()))) : new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()))));
        idServizioPerAutorizzazione.setSoggettoErogatore(soggettoDestinatarioPerAutorizzazione);
        return idServizioPerAutorizzazione;
    }

    private IDSoggetto getIDSoggettoMittentePerAutorizzazione(IDServizio idServizio, IDSoggetto soggettoFruitore, boolean functionAsRouter, Busta bustaRichiesta, RuoloBusta ruoloBustaRicevuta) {
        IDSoggetto soggettoMittentePerAutorizzazione = null;
        soggettoMittentePerAutorizzazione = functionAsRouter ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()) : (ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals(bustaRichiesta.getProfiloDiCollaborazione()) ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()) : (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) ? (ruoloBustaRicevuta == null ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()) : (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString()) ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()) : new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()))) : (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) ? (ruoloBustaRicevuta == null ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()) : (RuoloBusta.RICHIESTA.equals(ruoloBustaRicevuta.toString()) || RuoloBusta.RISPOSTA.equals(ruoloBustaRicevuta.toString()) ? new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()) : new IDSoggetto(idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome(), idServizio.getSoggettoErogatore().getCodicePorta()))) : new IDSoggetto(soggettoFruitore.getTipo(), soggettoFruitore.getNome(), soggettoFruitore.getCodicePorta()))));
        return soggettoMittentePerAutorizzazione;
    }
}

