/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb.threads;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.threshold.ThreadsUtils;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.threads.IProducer;
import org.openspcoop2.pdd.mdb.threads.IWorker;
import org.openspcoop2.pdd.mdb.threads.ThreadsImplProperties;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;

public class ModuloAlternativoMain
extends Thread {
    protected DBManager dbManager;
    protected Logger log;
    protected OpenSPCoop2Properties oSPCpropertiesReader;
    protected ThreadsImplProperties propertiesReader;
    protected String ID_MODULO;
    protected ExecutorService pool;
    protected BlockingQueue<IWorker> coda;
    protected IProducer produttore;
    private boolean inizializzato = false;
    protected boolean stop = false;

    public ModuloAlternativoMain(String IdModulo) {
        this.ID_MODULO = IdModulo;
    }

    private boolean inizializza() {
        while (!OpenSPCoop2Startup.initialize) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            this.initLogger();
            this.initLettoreProperties();
            this.dbManager = this.initDBManager();
            this.initCoda();
            this.initPool();
            return true;
        }
        catch (GenericLibException e) {
            System.out.println(this.ID_MODULO + " Errore in fase di init");
            return false;
        }
    }

    @Override
    public void run() {
        System.out.println(this.ID_MODULO + " Main attivato");
        if (!this.inizializzato) {
            this.inizializza();
        }
        try {
            this.produttore = this.creaProduttore();
            new Thread(this.produttore).start();
        }
        catch (Exception e) {
            this.log.error((Object)(this.ID_MODULO + ": Impossibile creare i consumatori"));
        }
        while (!this.stop) {
            this.consuma();
        }
        this.produttore.setStop(true);
        this.pool.shutdownNow();
        System.out.println(this.ID_MODULO + " Main disattivato");
    }

    protected IProducer creaProduttore() throws Exception {
        return null;
    }

    public void consuma() {
        if (!this.stop) {
            Runnable r = (Runnable)this.coda.poll();
            if (r != null) {
                this.pool.execute(r);
            } else {
                ThreadsUtils.attesa(50L);
            }
        }
    }

    private void initLettoreProperties() throws GenericLibException {
        try {
            this.propertiesReader = ThreadsImplProperties.getInstance();
            this.oSPCpropertiesReader = OpenSPCoop2Properties.getInstance();
        }
        catch (Exception e) {
            throw new GenericLibException("Riscontrato Errore durante l'inizializzazione del Reader della Configurazione");
        }
    }

    private void initLogger() throws GenericLibException {
        try {
            this.log = Logger.getLogger(ModuloAlternativoMain.class);
        }
        catch (Exception e) {
            if (this.log == null) {
                System.out.println("Riscontrato errore durante l'inizializzazione del Logger: " + e.getMessage());
            }
            throw new GenericLibException("Riscontrato Errore durante l'inizializzazione del Logger per il Thread " + this.ID_MODULO);
        }
    }

    private DBManager initDBManager() {
        return DBManager.getInstance();
    }

    private void initPool() {
        String tipoPool = this.propertiesReader.getPoolType();
        if (tipoPool.equals("fixed")) {
            this.pool = Executors.newFixedThreadPool(this.propertiesReader.getPoolDepth());
        } else if (tipoPool.equals("cached")) {
            this.pool = Executors.newCachedThreadPool();
        }
    }

    private void initCoda() {
        String tipoCoda = this.propertiesReader.getCodaType();
        if (tipoCoda.equals("array")) {
            this.coda = new ArrayBlockingQueue<IWorker>(this.propertiesReader.getCodaDepth());
        } else if (tipoCoda.equals("linked")) {
            this.coda = new LinkedBlockingQueue<IWorker>();
        }
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public boolean isStop() {
        return this.stop;
    }
}

