/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.eccezione.details.DettaglioEccezione;
import org.openspcoop2.core.eccezione.details.Eccezione;
import org.openspcoop2.core.eccezione.details.utils.XMLUtils;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.EJBUtils;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.SbustamentoRisposteMessage;
import org.openspcoop2.protocol.engine.builder.ErroreApplicativoBuilder;
import org.openspcoop2.protocol.engine.driver.FiltroDuplicati;
import org.openspcoop2.protocol.engine.driver.History;
import org.openspcoop2.protocol.engine.driver.IFiltroDuplicati;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.state.IState;

public class SbustamentoRisposte
extends GenericLib {
    public static final String ID_MODULO = "SbustamentoRisposte";
    private ErroreApplicativoBuilder erroreApplicativoBuilder;

    public SbustamentoRisposte(Logger log) throws GenericLibException {
        super(ID_MODULO, log);
        this.inizializza();
    }

    @Override
    protected synchronized void inizializza() throws GenericLibException {
        super.inizializza();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EsitoLib _onMessage(IOpenSPCoopState openspcoopstate, RegistroServiziManager registroServiziManager, ConfigurazionePdDManager configurazionePdDManager, MsgDiagnostico msgDiag) throws OpenSPCoopStateException {
        ServizioApplicativo sa;
        PortaDelegata pd;
        EJBUtils ejbUtils;
        String ricevutaAsincrona;
        RepositoryBuste repositoryBuste;
        History historyBuste;
        org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione;
        GestoreMessaggi msgResponse;
        String idMessageRequest;
        IDSoggetto identitaPdD;
        boolean bustaDiServizio;
        boolean isMessaggioErroreProtocollo;
        Vector<org.openspcoop2.protocol.sdk.Eccezione> errors;
        RichiestaDelegata richiestaDelegata;
        String implementazionePdDDestinatario;
        String idResponse;
        Busta bustaRisposta;
        SOAPVersion versioneSoap;
        ITraduttore traduttore;
        IProtocolVersionManager protocolManager;
        IProtocolFactory protocolFactory;
        PdDContext pddContext;
        Exception eParsing;
        SbustamentoRisposteMessage sbustamentoRisposteMsg;
        EsitoLib esito;
        block148: {
            esito = new EsitoLib();
            sbustamentoRisposteMsg = (SbustamentoRisposteMessage)openspcoopstate.getMessageLib();
            eParsing = null;
            if (openspcoopstate instanceof OpenSPCoopStateless) {
                eParsing = ((OpenSPCoopStateless)openspcoopstate).getRispostaMsg().getParsingError();
            }
            pddContext = sbustamentoRisposteMsg.getPddContext();
            String idTransazione = PdDContext.getValue("ID", pddContext);
            protocolFactory = null;
            protocolManager = null;
            traduttore = null;
            try {
                protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
                protocolManager = protocolFactory.createProtocolVersionManager(sbustamentoRisposteMsg.getRichiestaDelegata().getProfiloGestione());
                traduttore = protocolFactory.createTraduttore();
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
            versioneSoap = (SOAPVersion)pddContext.getObject("SOAP_VERSION");
            msgDiag.setPddContext(pddContext, protocolFactory);
            bustaRisposta = sbustamentoRisposteMsg.getBusta();
            idResponse = bustaRisposta.getID();
            implementazionePdDDestinatario = sbustamentoRisposteMsg.getImplementazionePdDSoggettoDestinatario();
            richiestaDelegata = sbustamentoRisposteMsg.getRichiestaDelegata();
            richiestaDelegata.setProfiloCollaborazione(bustaRisposta.getProfiloDiCollaborazione(), bustaRisposta.getProfiloDiCollaborazioneValue());
            errors = sbustamentoRisposteMsg.getErrors();
            isMessaggioErroreProtocollo = sbustamentoRisposteMsg.isMessaggioErroreProtocollo();
            bustaDiServizio = sbustamentoRisposteMsg.getIsBustaDiServizio();
            TipoPdD tipoPdD = TipoPdD.DELEGATA;
            identitaPdD = sbustamentoRisposteMsg.getRichiestaDelegata().getDominio();
            msgDiag.setDominio(identitaPdD);
            msgDiag.setPrefixMsgPersonalizzati("sbustamentoRispostaBusta.");
            msgDiag.addKeywords(richiestaDelegata.getSoggettoFruitore(), richiestaDelegata.getIdServizio(), null);
            msgDiag.addKeywords(bustaRisposta, false);
            msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", richiestaDelegata.getServizioApplicativo());
            msgDiag.setIdCorrelazioneApplicativa(richiestaDelegata.getIdCorrelazioneApplicativa());
            msgDiag.setIdCorrelazioneRisposta(richiestaDelegata.getIdCorrelazioneApplicativaRisposta());
            msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", richiestaDelegata.getIdCorrelazioneApplicativa());
            String profiloGestione = richiestaDelegata.getProfiloGestione();
            msgDiag.mediumDebug("Profilo di gestione [SbustamentoRisposte] della busta: " + profiloGestione);
            try {
                this.erroreApplicativoBuilder = new ErroreApplicativoBuilder(this.log, protocolFactory, identitaPdD, richiestaDelegata.getSoggettoFruitore(), richiestaDelegata.getIdServizio(), this.idModulo, richiestaDelegata.getFault(), versioneSoap, TipoPdD.DELEGATA, richiestaDelegata.getServizioApplicativo());
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "ErroreApplicativoBuilder.instanziazione");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
            msgDiag.mediumDebug("Inizializzo stato per la gestione della richiesta...");
            openspcoopstate.initResource(identitaPdD, ID_MODULO, idTransazione);
            registroServiziManager.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
            configurazionePdDManager.updateState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
            msgDiag.updateState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
            idMessageRequest = openspcoopstate.getIDMessaggioSessione();
            msgDiag.setIdMessaggioRichiesta(idMessageRequest);
            msgDiag.setIdMessaggioRisposta(idResponse);
            msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idMessageRequest);
            msgDiag.setDelegata(true);
            msgDiag.setPorta(richiestaDelegata.getLocationPD());
            msgDiag.setFruitore(richiestaDelegata.getSoggettoFruitore());
            msgDiag.setServizio(richiestaDelegata.getIdServizio());
            msgDiag.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
            msgDiag.setIdCorrelazioneApplicativa(richiestaDelegata.getIdCorrelazioneApplicativa());
            msgDiag.setIdCorrelazioneRisposta(richiestaDelegata.getIdCorrelazioneApplicativaRisposta());
            msgDiag.mediumDebug("Inizializzo contesto per la gestione...");
            msgResponse = null;
            profiloCollaborazione = null;
            try {
                profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRisposta(), protocolFactory);
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "ProfiloDiCollaborazione.new");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
            historyBuste = new History(openspcoopstate.getStatoRisposta());
            repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRisposta(), false, protocolFactory);
            ricevutaAsincrona = null;
            ejbUtils = null;
            try {
                ejbUtils = new EJBUtils(identitaPdD, tipoPdD, ID_MODULO, idMessageRequest, idResponse, "INBOX", openspcoopstate, msgDiag, false, sbustamentoRisposteMsg.getImplementazionePdDSoggettoMittente(), sbustamentoRisposteMsg.getImplementazionePdDSoggettoDestinatario(), profiloGestione, pddContext);
                ejbUtils.setSpedizioneMsgIngresso(sbustamentoRisposteMsg.getSpedizioneMsgIngresso());
                ejbUtils.setRicezioneMsgRisposta(sbustamentoRisposteMsg.getRicezioneMsgRisposta());
                ejbUtils.setScenarioCooperazione(richiestaDelegata.getScenario());
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "EJBUtils.new");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
            boolean oneWayVersione11 = sbustamentoRisposteMsg.isOneWayVersione11();
            ejbUtils.setOneWayVersione11(oneWayVersione11);
            pd = null;
            sa = null;
            try {
                pd = configurazionePdDManager.getPortaDelegata(richiestaDelegata.getIdPortaDelegata());
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "getPortaDelegata()");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
            try {
                sa = configurazionePdDManager.getServizioApplicativo(richiestaDelegata.getIdPortaDelegata(), richiestaDelegata.getServizioApplicativo());
            }
            catch (Exception e) {
                if (e instanceof DriverConfigurazioneNotFound && "Anonimo".equals(richiestaDelegata.getServizioApplicativo())) break block148;
                msgDiag.logErroreGenerico(e, "getServizioApplicativo()");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
        }
        boolean sendRispostaApplicativa = false;
        boolean statelessAsincrono = false;
        if ("Sincrono_InvocazioneServizio".equals(richiestaDelegata.getScenario())) {
            sendRispostaApplicativa = true;
        } else if ("AsincronoAsimmetrico_Polling".equals(richiestaDelegata.getScenario())) {
            try {
                statelessAsincrono = configurazionePdDManager.isModalitaStateless(pd, bustaRisposta.getProfiloDiCollaborazione());
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "AsincronoAsimmetricoPolling.isModalitaStateless(pd)");
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
                return esito;
            }
            sendRispostaApplicativa = true;
        } else {
            if ("AsincronoAsimmetrico_InvocazioneServizio".equals(richiestaDelegata.getScenario()) || "AsincronoSimmetrico_InvocazioneServizio".equals(richiestaDelegata.getScenario()) || "AsincronoSimmetrico_ConsegnaRisposta".equals(richiestaDelegata.getScenario())) {
                try {
                    statelessAsincrono = configurazionePdDManager.isModalitaStateless(pd, bustaRisposta.getProfiloDiCollaborazione());
                    sendRispostaApplicativa = statelessAsincrono || richiestaDelegata.isRicevutaAsincrona();
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "Asincrono.isModalitaStateless(pd)");
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(false);
                    esito.setStatoInvocazioneErroreNonGestito(e);
                    return esito;
                }
            }
            if ("OneWay_InvocazioneServizio".equals(richiestaDelegata.getScenario())) {
                try {
                    sendRispostaApplicativa = configurazionePdDManager.isModalitaStateless(pd, ProfiloDiCollaborazione.ONEWAY);
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "OnewayInvocazioneServizio.isModalitaStateless(pd)");
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(false);
                    esito.setStatoInvocazioneErroreNonGestito(e);
                    return esito;
                }
            }
        }
        boolean rollbackRiferimentoMessaggio = false;
        if (sendRispostaApplicativa) {
            if ("Sincrono_InvocazioneServizio".equals(richiestaDelegata.getScenario())) {
                rollbackRiferimentoMessaggio = true;
            } else if ("AsincronoAsimmetrico_InvocazioneServizio".equals(richiestaDelegata.getScenario()) || "AsincronoSimmetrico_InvocazioneServizio".equals(richiestaDelegata.getScenario())) {
                rollbackRiferimentoMessaggio = true;
            }
        }
        ProprietaErroreApplicativo proprietaErroreAppl = richiestaDelegata.getFault();
        proprietaErroreAppl.setIdModulo(ID_MODULO);
        RuoloBusta ruoloBustaRicevuta = sbustamentoRisposteMsg.getRuoloBustaRicevuta();
        try {
            org.openspcoop2.protocol.sdk.Eccezione ecc;
            OpenSPCoop2Message responseMessageError;
            block160: {
                block161: {
                    block162: {
                        block158: {
                            block159: {
                                boolean checkDuplicato;
                                boolean imbustamentoFiltroDuplicatiAbilitato;
                                boolean ricezioneRiscontri;
                                block152: {
                                    block157: {
                                        block153: {
                                            ErroreIntegrazione erroreIntegrazioneDaInviareServizioApplicativo;
                                            org.openspcoop2.protocol.sdk.Eccezione eccezioneDaInviareServizioApplicativo;
                                            DettaglioEccezione dettaglioEccezione;
                                            block149: {
                                                StringBuffer bfDescrizione;
                                                block154: {
                                                    block156: {
                                                        block155: {
                                                            ricezioneRiscontri = false;
                                                            switch (protocolManager.getConsegnaAffidabile(bustaRisposta.getProfiloDiCollaborazione())) {
                                                                case ABILITATA: {
                                                                    ricezioneRiscontri = true;
                                                                    break;
                                                                }
                                                                case DISABILITATA: {
                                                                    ricezioneRiscontri = false;
                                                                    break;
                                                                }
                                                                default: {
                                                                    ricezioneRiscontri = this.propertiesReader.isGestioneRiscontri(implementazionePdDDestinatario);
                                                                }
                                                            }
                                                            imbustamentoFiltroDuplicatiAbilitato = false;
                                                            switch (protocolManager.getFiltroDuplicati(bustaRisposta.getProfiloDiCollaborazione())) {
                                                                case ABILITATA: {
                                                                    imbustamentoFiltroDuplicatiAbilitato = true;
                                                                    break;
                                                                }
                                                                case DISABILITATA: {
                                                                    imbustamentoFiltroDuplicatiAbilitato = false;
                                                                    break;
                                                                }
                                                                default: {
                                                                    imbustamentoFiltroDuplicatiAbilitato = Inoltro.SENZA_DUPLICATI.equals(bustaRisposta.getInoltro()) || this.propertiesReader.isCheckFromRegistroFiltroDuplicatiAbilitato(implementazionePdDDestinatario) && sbustamentoRisposteMsg.isFiltroDuplicati();
                                                                }
                                                            }
                                                            try {
                                                                IProtocolConfiguration protocolConfiguration = protocolFactory.createProtocolConfiguration();
                                                                if (imbustamentoFiltroDuplicatiAbilitato && !protocolConfiguration.isSupportato(FunzionalitaProtocollo.FILTRO_DUPLICATI)) {
                                                                    throw new Exception(FunzionalitaProtocollo.FILTRO_DUPLICATI.getEngineValue());
                                                                }
                                                            }
                                                            catch (Exception e) {
                                                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                                                                msgDiag.logPersonalizzato("protocolli.funzionalita.unsupported");
                                                                if (sendRispostaApplicativa) {
                                                                    OpenSPCoop2Message responseMessageError2 = this.erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_439_FUNZIONALITA_NOT_SUPPORTED_BY_PROTOCOL.getErrore439_FunzionalitaNotSupportedByProtocol(e.getMessage(), protocolFactory), eParsing);
                                                                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError2, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                                                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("protocolli.funzionalita.unsupported"));
                                                                } else {
                                                                    ejbUtils.releaseInboxMessage(false);
                                                                    esito.setStatoInvocazioneErroreNonGestito(e);
                                                                }
                                                                openspcoopstate.releaseResource();
                                                                esito.setEsitoInvocazione(true);
                                                                return esito;
                                                            }
                                                            if (!isMessaggioErroreProtocollo) break block152;
                                                            msgDiag.mediumDebug("Gestione messaggio errore protocollo...");
                                                            boolean msgErroreProtocolloValido = true;
                                                            if (!configurazionePdDManager.getTipoValidazione(implementazionePdDDestinatario).equals(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO) && errors.size() != 0) {
                                                                StringBuffer eccBuffer = new StringBuffer();
                                                                for (int k = 0; k < errors.size(); ++k) {
                                                                    org.openspcoop2.protocol.sdk.Eccezione er = errors.get(k);
                                                                    if (k > 0) {
                                                                        eccBuffer.append("\n");
                                                                    }
                                                                    eccBuffer.append(er.toString(protocolFactory));
                                                                }
                                                                msgDiag.addKeyword("@NUMERO_ECCEZIONI@", errors.size() + "");
                                                                msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
                                                                msgDiag.logPersonalizzato("validazioneBustaErrore.listaEccezioniMalformata");
                                                                if (configurazionePdDManager.getTipoValidazione(implementazionePdDDestinatario).equals(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO)) {
                                                                    msgErroreProtocolloValido = false;
                                                                }
                                                            }
                                                            if (msgErroreProtocolloValido && bustaRisposta.sizeListaEccezioni() > 0) {
                                                                msgDiag.addKeyword("@ECCEZIONI@", bustaRisposta.toStringListaEccezioni(protocolFactory));
                                                                msgDiag.addKeyword("@NUMERO_ECCEZIONI@", bustaRisposta.sizeListaEccezioni() + "");
                                                                msgDiag.logPersonalizzato("ricezioneBustaErrore");
                                                            }
                                                            if ((dettaglioEccezione = sbustamentoRisposteMsg.getDettaglioEccezione()) != null) {
                                                                msgDiag.addKeyword("@OPENSPCOOP2_DETAILS@", XMLUtils.toString((DettaglioEccezione)dettaglioEccezione));
                                                                msgDiag.logPersonalizzato("ricezioneBustaErroreDetails");
                                                            }
                                                            msgDiag.mediumDebug("Invio eventuale messaggio di errore al servizio applicativo (gestione errore)...");
                                                            if (!sendRispostaApplicativa) break block153;
                                                            eccezioneDaInviareServizioApplicativo = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                                                            erroreIntegrazioneDaInviareServizioApplicativo = null;
                                                            if (!msgErroreProtocolloValido) break block154;
                                                            if (bustaRisposta.sizeListaEccezioni() <= 1) break block155;
                                                            bfDescrizione = new StringBuffer();
                                                            for (int k = 0; k < bustaRisposta.sizeListaEccezioni(); ++k) {
                                                                org.openspcoop2.protocol.sdk.Eccezione eccListaEccezioni = bustaRisposta.getEccezione(k);
                                                                if (eccListaEccezioni.getDescrizione(protocolFactory) == null) continue;
                                                                bfDescrizione.append("[" + traduttore.toString(eccListaEccezioni.getCodiceEccezione(), eccListaEccezioni.getSubCodiceEccezione()) + "] " + eccListaEccezioni.getDescrizione(protocolFactory) + "\n");
                                                            }
                                                            if (bfDescrizione.length() > 0) {
                                                                eccezioneDaInviareServizioApplicativo.setDescrizione(bfDescrizione.toString());
                                                            }
                                                            break block149;
                                                        }
                                                        if (bustaRisposta.sizeListaEccezioni() != 1) break block156;
                                                        eccezioneDaInviareServizioApplicativo = bustaRisposta.getEccezione(0);
                                                        break block149;
                                                    }
                                                    if (dettaglioEccezione != null && dettaglioEccezione.getEccezioni() != null && dettaglioEccezione.getEccezioni().sizeEccezioneList() > 0) {
                                                        Eccezione e = dettaglioEccezione.getEccezioni().getEccezione(0);
                                                        if ("EccezioneProtocollo".equals(e.getTipo())) {
                                                            ErroreCooperazione msgErroreCooperazione = new ErroreCooperazione(e.getDescrizione(), traduttore.toCodiceErroreCooperazione(e.getCodice()));
                                                            eccezioneDaInviareServizioApplicativo = new org.openspcoop2.protocol.sdk.Eccezione(msgErroreCooperazione, false, ID_MODULO, protocolFactory);
                                                            break block149;
                                                        } else {
                                                            eccezioneDaInviareServizioApplicativo = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneProcessamento((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento(e.getDescrizione()), (IProtocolFactory)protocolFactory);
                                                        }
                                                        break block149;
                                                    } else {
                                                        eccezioneDaInviareServizioApplicativo = new org.openspcoop2.protocol.sdk.Eccezione(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione(), false, ID_MODULO, protocolFactory);
                                                    }
                                                    break block149;
                                                }
                                                if (errors.size() > 1) {
                                                    bfDescrizione = new StringBuffer();
                                                    for (int k = 0; k < errors.size(); ++k) {
                                                        org.openspcoop2.protocol.sdk.Eccezione error = errors.get(k);
                                                        if (error.getDescrizione(protocolFactory) == null) continue;
                                                        bfDescrizione.append("[" + traduttore.toString(error.getCodiceEccezione(), error.getSubCodiceEccezione()) + "] " + error.getDescrizione(protocolFactory) + "\n");
                                                    }
                                                    if (bfDescrizione.length() > 0) {
                                                        eccezioneDaInviareServizioApplicativo.setDescrizione(bfDescrizione.toString());
                                                    }
                                                } else {
                                                    eccezioneDaInviareServizioApplicativo = errors.get(0);
                                                }
                                            }
                                            OpenSPCoop2Message responseMessageError3 = null;
                                            responseMessageError3 = eccezioneDaInviareServizioApplicativo != null ? this.erroreApplicativoBuilder.toMessage(eccezioneDaInviareServizioApplicativo, richiestaDelegata.getIdServizio().getSoggettoErogatore(), dettaglioEccezione, eParsing) : this.erroreApplicativoBuilder.toMessage(erroreIntegrazioneDaInviareServizioApplicativo, eParsing);
                                            ejbUtils.sendRispostaApplicativaErrore(responseMessageError3, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                            esito.setStatoInvocazione(2, "BustaErrore");
                                            break block157;
                                        }
                                        ejbUtils.releaseInboxMessage(false);
                                        esito.setStatoInvocazione(3, "BustaErrore");
                                    }
                                    msgDiag.mediumDebug("Rilascio connessione...");
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    return esito;
                                }
                                if (!isMessaggioErroreProtocollo && !configurazionePdDManager.getTipoValidazione(implementazionePdDDestinatario).equals(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO)) {
                                    boolean validazioneConErrori;
                                    boolean bl = validazioneConErrori = errors.size() > 0;
                                    if (protocolManager.isIgnoraEccezioniLivelloNonGrave() || this.propertiesReader.ignoraEccezioniNonGravi_Validazione()) {
                                        validazioneConErrori = Busta.containsEccezioniGravi(errors);
                                    }
                                    if (validazioneConErrori) {
                                        msgDiag.mediumDebug("Gestione messaggio di protocollo che non ha superato la validazione...");
                                        boolean mittenteRegistrato = true;
                                        StringBuffer eccBuffer = new StringBuffer();
                                        Vector<org.openspcoop2.protocol.sdk.Eccezione> errorsClone = new Vector<org.openspcoop2.protocol.sdk.Eccezione>();
                                        for (int k = 0; k < errors.size(); ++k) {
                                            org.openspcoop2.protocol.sdk.Eccezione er = errors.get(k);
                                            errorsClone.add(er);
                                            if (k > 0) {
                                                eccBuffer.append("\n");
                                            }
                                            eccBuffer.append(er.toString(protocolFactory));
                                            if (!CodiceErroreCooperazione.isEccezioneMittente((CodiceErroreCooperazione)er.getCodiceEccezione())) continue;
                                            mittenteRegistrato = false;
                                        }
                                        msgDiag.addKeyword("@ECCEZIONI@", eccBuffer.toString());
                                        msgDiag.addKeyword("@NUMERO_ECCEZIONI@", errors.size() + "");
                                        msgDiag.logPersonalizzato("validazioneBusta.bustaNonCorretta");
                                        if (configurazionePdDManager.getTipoValidazione(implementazionePdDDestinatario).equals(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO)) {
                                            if (mittenteRegistrato) {
                                                msgDiag.mediumDebug("Invio segnalazione di errore ...");
                                                ejbUtils.sendAsRispostaBustaErrore_inoltroSegnalazioneErrore(bustaRisposta, errorsClone);
                                            }
                                            msgDiag.mediumDebug("Invio eventuale messaggio di errore al servizio applicativo (gestione errore)...");
                                            if (sendRispostaApplicativa) {
                                                org.openspcoop2.protocol.sdk.Eccezione eccezioneDaInviareServizioApplicativo = null;
                                                if (errors.size() > 1) {
                                                    eccezioneDaInviareServizioApplicativo = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                                                    StringBuffer bfDescrizione = new StringBuffer();
                                                    for (int k = 0; k < errors.size(); ++k) {
                                                        org.openspcoop2.protocol.sdk.Eccezione error = errors.get(k);
                                                        if (error.getDescrizione(protocolFactory) == null) continue;
                                                        bfDescrizione.append("[" + traduttore.toString(error.getCodiceEccezione(), error.getSubCodiceEccezione()) + "] " + error.getDescrizione(protocolFactory) + "\n");
                                                    }
                                                    if (bfDescrizione.length() > 0) {
                                                        eccezioneDaInviareServizioApplicativo.setDescrizione(bfDescrizione.toString());
                                                    }
                                                } else {
                                                    eccezioneDaInviareServizioApplicativo = errors.get(0);
                                                }
                                                OpenSPCoop2Message responseMessageError4 = this.erroreApplicativoBuilder.toMessage(eccezioneDaInviareServizioApplicativo, richiestaDelegata.getSoggettoFruitore(), eParsing);
                                                ejbUtils.sendRispostaApplicativaErrore(responseMessageError4, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("validazioneBusta.bustaNonCorretta"));
                                            } else {
                                                ejbUtils.releaseInboxMessage(false);
                                                esito.setStatoInvocazione(3, msgDiag.getMessaggio_replaceKeywords("validazioneBusta.bustaNonCorretta"));
                                            }
                                            msgDiag.mediumDebug("Rilascio connessione...");
                                            openspcoopstate.releaseResource();
                                            esito.setEsitoInvocazione(true);
                                            return esito;
                                        }
                                    }
                                }
                                if (!bustaRisposta.containsEccezioniGravi() && bustaRisposta.sizeListaEccezioni() > 0) {
                                    msgDiag.addKeyword("@ECCEZIONI@", bustaRisposta.toStringListaEccezioni(protocolFactory));
                                    msgDiag.logPersonalizzato("ricezioneBusta.eccezioniNonGravi");
                                }
                                if (!Busta.containsEccezioniGravi(errors) && errors.size() > 0) {
                                    msgDiag.addKeyword("@ECCEZIONI@", Busta.toStringListaEccezioni(errors, (IProtocolFactory)protocolFactory));
                                    msgDiag.addKeyword("@NUMERO_ECCEZIONI@", errors.size() + "");
                                    msgDiag.logPersonalizzato("validazioneBusta.eccezioniNonGravi");
                                }
                                if (ricezioneRiscontri && bustaRisposta.sizeListaRiscontri() > 0) {
                                    for (int i = 0; i < bustaRisposta.sizeListaRiscontri(); ++i) {
                                        Riscontro r = bustaRisposta.getRiscontro(i);
                                        msgDiag.addKeyword("@ID_BUSTA_RISCONTRATA@", r.getID());
                                        msgDiag.addKeyword("@DATA_RISCONTRO@", r.getOraRegistrazione().toString());
                                        msgDiag.logPersonalizzato("ricezioneRiscontro");
                                        try {
                                            GestoreMessaggi msgRiscontrato = new GestoreMessaggi(openspcoopstate, true, r.getID(), "OUTBOX", msgDiag, pddContext);
                                            msgRiscontrato.validateAndDeleteMsgOneWayRiscontrato();
                                            continue;
                                        }
                                        catch (Exception e) {
                                            msgDiag.logErroreGenerico(e, "msgRiscontrato.validateAndDeleteMsgOneWayRiscontrato(" + r.getID() + ")");
                                        }
                                    }
                                }
                                msgDiag.mediumDebug("Controllo appartenenza Destinazione Busta (controllo esistenza soggetto)...");
                                boolean existsSoggetto = false;
                                try {
                                    existsSoggetto = configurazionePdDManager.existsSoggetto(new IDSoggetto(bustaRisposta.getTipoDestinatario(), bustaRisposta.getDestinatario()));
                                }
                                catch (Exception e) {
                                    msgDiag.logErroreGenerico(e, "existsSoggetto(" + bustaRisposta.getTipoDestinatario() + "/" + bustaRisposta.getDestinatario() + ")");
                                    if (sendRispostaApplicativa) {
                                        OpenSPCoop2Message responseMessageError5 = this.erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), eParsing);
                                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError5, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                        esito.setStatoInvocazione(2, "existsSoggetto(" + bustaRisposta.getTipoDestinatario() + "/" + bustaRisposta.getDestinatario() + ")");
                                    } else {
                                        ejbUtils.releaseInboxMessage(false);
                                        esito.setStatoInvocazioneErroreNonGestito(e);
                                    }
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    return esito;
                                }
                                if (!existsSoggetto) {
                                    msgDiag.logPersonalizzato("soggettoDestinatarioNonGestito");
                                    if (sendRispostaApplicativa) {
                                        OpenSPCoop2Message responseMessageError6 = this.erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_528_RISPOSTA_RICHIESTA_NON_VALIDA), eParsing);
                                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError6, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("soggettoDestinatarioNonGestito"));
                                    } else {
                                        ejbUtils.releaseInboxMessage(false);
                                        esito.setStatoInvocazione(3, msgDiag.getMessaggio_replaceKeywords("soggettoDestinatarioNonGestito"));
                                    }
                                    openspcoopstate.releaseResource();
                                    esito.setEsitoInvocazione(true);
                                    return esito;
                                }
                                if (bustaDiServizio) {
                                    msgDiag.logPersonalizzato("ricezioneBustaServizio");
                                    if ("OneWay_InvocazioneServizio".equals(richiestaDelegata.getScenario()) && sendRispostaApplicativa) {
                                        msgDiag.mediumDebug("Gestione riscontro per oneway in modalita sincrona...");
                                    } else {
                                        if (sendRispostaApplicativa) {
                                            OpenSPCoop2Message responseMessageError7 = this.erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_517_RISPOSTA_RICHIESTA_NON_RITORNATA), eParsing);
                                            ejbUtils.sendRispostaApplicativaErrore(responseMessageError7, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                            esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaServizio"));
                                        } else {
                                            ejbUtils.releaseInboxMessage(true);
                                            esito.setStatoInvocazione(3, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaServizio"));
                                        }
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        return esito;
                                    }
                                }
                                if (checkDuplicato = imbustamentoFiltroDuplicatiAbilitato) {
                                    try {
                                        boolean bustaDuplicata;
                                        String gestoreFiltroDuplicatiType = this.propertiesReader.getGestoreFiltroDuplicatiRepositoryBuste();
                                        ClassNameProperties prop = ClassNameProperties.getInstance();
                                        String gestoreFiltroDuplicatiClass = prop.getFiltroDuplicati(gestoreFiltroDuplicatiType);
                                        if (gestoreFiltroDuplicatiClass == null) {
                                            throw new Exception("GestoreFiltroDuplicati non registrato (" + gestoreFiltroDuplicatiType + ")");
                                        }
                                        IFiltroDuplicati gestoreFiltroDuplicati = (IFiltroDuplicati)this.loader.newInstance(gestoreFiltroDuplicatiClass);
                                        pddContext.addObject("CONNECTION_PDD", ((OpenSPCoopState)openspcoopstate).getConnectionDB());
                                        gestoreFiltroDuplicati.init((Object)pddContext);
                                        if (gestoreFiltroDuplicati instanceof FiltroDuplicati) {
                                            ((FiltroDuplicati)gestoreFiltroDuplicati).setHistoryBuste(historyBuste);
                                            ((FiltroDuplicati)gestoreFiltroDuplicati).setRepositoryBuste(repositoryBuste);
                                            ((FiltroDuplicati)gestoreFiltroDuplicati).setGestioneStateless(openspcoopstate instanceof OpenSPCoopStateless);
                                            ((FiltroDuplicati)gestoreFiltroDuplicati).setRepositoryIntervalloScadenzaMessaggi(this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                                        }
                                        if (bustaDuplicata = gestoreFiltroDuplicati.isDuplicata(protocolFactory, bustaRisposta.getID())) {
                                            msgDiag.logPersonalizzato("ricezioneBustaDuplicata.count");
                                            gestoreFiltroDuplicati.incrementaNumeroDuplicati(protocolFactory, bustaRisposta.getID());
                                            msgDiag.logPersonalizzato("ricezioneBustaDuplicata");
                                            if (sendRispostaApplicativa) {
                                                OpenSPCoop2Message responseMessageError8 = this.erroreApplicativoBuilder.toMessage(org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.getErroreCooperazione(), (IProtocolFactory)protocolFactory), identitaPdD, eParsing);
                                                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                                ejbUtils.setRollbackRichiestaInCasoErrore_rollbackHistory(false);
                                                ejbUtils.sendRispostaApplicativaErrore(responseMessageError8, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                            } else {
                                                ejbUtils.releaseInboxMessage(false, true);
                                                esito.setStatoInvocazione(3, msgDiag.getMessaggio_replaceKeywords("ricezioneBustaDuplicata"));
                                            }
                                            openspcoopstate.commit();
                                            openspcoopstate.releaseResource();
                                            esito.setEsitoInvocazione(true);
                                            return esito;
                                        }
                                        gestoreFiltroDuplicati.registraBusta(protocolFactory, bustaRisposta);
                                        msgDiag.logPersonalizzato("ricezioneBusta.registrazionePerFiltroDuplicati");
                                    }
                                    catch (Exception e) {
                                        msgDiag.logErroreGenerico(e, "GestioneHistoryBusteRicevute");
                                        if (sendRispostaApplicativa) {
                                            responseMessageError = this.erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), eParsing);
                                            ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                                            esito.setStatoInvocazione(2, "GestioneHistoryBusteRicevute");
                                        } else {
                                            ejbUtils.releaseInboxMessage(false);
                                            esito.setStatoInvocazioneErroreNonGestito(e);
                                        }
                                        openspcoopstate.releaseResource();
                                        esito.setEsitoInvocazione(true);
                                        return esito;
                                    }
                                    pddContext.removeObject("CONNECTION_PDD");
                                }
                                ecc = null;
                                msgDiag.addKeyword("@SCENARIO_COOPERAZIONE_GESTITO@", richiestaDelegata.getScenario());
                                if ("OneWay_InvocazioneServizio".equals(richiestaDelegata.getScenario())) {
                                    msgDiag.mediumDebug("Gestione profilo di collaborazione OneWay...");
                                    if (bustaRisposta.getProfiloDiCollaborazione() != null && !ProfiloDiCollaborazione.ONEWAY.equals(bustaRisposta.getProfiloDiCollaborazione())) {
                                        msgDiag.logPersonalizzato("profiloCollaborazioneRisposta.diversoScenarioGestito");
                                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.PROFILO_COLLABORAZIONE_NON_VALIDO.getErroreProfiloCollaborazioneNonValido("Profilo di collaborazione diverso dallo scenario di cooperazione (atteso OneWay)."), (IProtocolFactory)protocolFactory);
                                    } else if (bustaRisposta.getRiferimentoMessaggio() != null && !idMessageRequest.equals(bustaRisposta.getRiferimentoMessaggio())) {
                                        msgDiag.logPersonalizzato("riferimentoMessaggioNonValido");
                                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                                    }
                                }
                                if (!"Sincrono_InvocazioneServizio".equals(richiestaDelegata.getScenario())) break block158;
                                msgDiag.mediumDebug("Gestione profilo di collaborazione Sincrono...");
                                if (ProfiloDiCollaborazione.SINCRONO.equals(bustaRisposta.getProfiloDiCollaborazione())) break block159;
                                msgDiag.logPersonalizzato("profiloCollaborazioneRisposta.diversoScenarioGestito");
                                ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.PROFILO_COLLABORAZIONE_NON_VALIDO.getErroreProfiloCollaborazioneNonValido("Profilo di collaborazione diverso dallo scenario di cooperazione (atteso Sincrono)."), (IProtocolFactory)protocolFactory);
                                break block160;
                            }
                            if (bustaRisposta.getRiferimentoMessaggio() == null) {
                                msgDiag.logPersonalizzato("riferimentoMessaggioNonPresente");
                                ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_PRESENTE.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                                break block160;
                            } else if (bustaRisposta.getRiferimentoMessaggio() != null && !idMessageRequest.equals(bustaRisposta.getRiferimentoMessaggio())) {
                                msgDiag.logPersonalizzato("riferimentoMessaggioNonValido");
                                ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                            }
                            break block160;
                        }
                        if (!"AsincronoSimmetrico_InvocazioneServizio".equals(richiestaDelegata.getScenario()) && !"AsincronoSimmetrico_ConsegnaRisposta".equals(richiestaDelegata.getScenario())) break block161;
                        msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoSimmetrico...");
                        if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRisposta.getProfiloDiCollaborazione())) break block162;
                        msgDiag.logPersonalizzato("profiloCollaborazioneRisposta.diversoScenarioGestito");
                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.PROFILO_COLLABORAZIONE_NON_VALIDO.getErroreProfiloCollaborazioneNonValido("Profilo di collaborazione diverso dallo scenario di cooperazione (atteso AsincronoSimmetrico)."), (IProtocolFactory)protocolFactory);
                        break block160;
                    }
                    if (bustaRisposta.getRiferimentoMessaggio() == null) {
                        msgDiag.logPersonalizzato("riferimentoMessaggioNonPresente");
                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_PRESENTE.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                        break block160;
                    } else if (bustaRisposta.getRiferimentoMessaggio() != null && !idMessageRequest.equals(bustaRisposta.getRiferimentoMessaggio())) {
                        msgDiag.logPersonalizzato("riferimentoMessaggioNonValido");
                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                    }
                    break block160;
                }
                if ("AsincronoAsimmetrico_InvocazioneServizio".equals(richiestaDelegata.getScenario()) || "AsincronoAsimmetrico_Polling".equals(richiestaDelegata.getScenario())) {
                    msgDiag.mediumDebug("Gestione profilo di collaborazione AsincronoAsimmetrico...");
                    if (!ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRisposta.getProfiloDiCollaborazione())) {
                        msgDiag.logPersonalizzato("profiloCollaborazioneRisposta.diversoScenarioGestito");
                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.PROFILO_COLLABORAZIONE_NON_VALIDO.getErroreProfiloCollaborazioneNonValido("Profilo di collaborazione diverso dallo scenario di cooperazione (atteso AsincronoAsimmetrico)."), (IProtocolFactory)protocolFactory);
                    } else if (bustaRisposta.getRiferimentoMessaggio() == null) {
                        msgDiag.logPersonalizzato("riferimentoMessaggioNonPresente");
                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_PRESENTE.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                    } else if (bustaRisposta.getRiferimentoMessaggio() != null && !idMessageRequest.equals(bustaRisposta.getRiferimentoMessaggio())) {
                        msgDiag.logPersonalizzato("riferimentoMessaggioNonValido");
                        ecc = org.openspcoop2.protocol.sdk.Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), (IProtocolFactory)protocolFactory);
                    }
                }
            }
            if (ecc != null) {
                if (sendRispostaApplicativa) {
                    responseMessageError = this.erroreApplicativoBuilder.toMessage(ecc, richiestaDelegata.getSoggettoFruitore(), eParsing);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                    esito.setStatoInvocazione(2, ecc.toString(protocolFactory));
                } else {
                    ejbUtils.releaseInboxMessage(false);
                    esito.setStatoInvocazione(3, ecc.toString(protocolFactory));
                }
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                return esito;
            }
            msgDiag.mediumDebug("Gestione profilo...");
            if (ProfiloDiCollaborazione.ONEWAY.equals(bustaRisposta.getProfiloDiCollaborazione())) {
                msgDiag.logPersonalizzato("rispostaOneway");
            } else {
                String motivazioneErrore;
                if (ProfiloDiCollaborazione.SINCRONO.equals(bustaRisposta.getProfiloDiCollaborazione())) {
                    msgDiag.mediumDebug("Gestione profilo di collaborazione Sincrono (elimina richiesta in OutBox)...");
                    try {
                        profiloCollaborazione.sincrono_eliminaRichiestaInOutBox(bustaRisposta.getRiferimentoMessaggio());
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "profiloCollaborazione.sincrono_eliminaRichiestaInOutBox");
                        OpenSPCoop2Message responseMessageError9 = this.erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), eParsing);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError9, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "profiloCollaborazione.sincrono_eliminaRichiestaInOutBox");
                        return esito;
                    }
                }
                if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRisposta.getProfiloDiCollaborazione())) {
                    if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                        ricevutaAsincrona = "ricevuta di una richiesta asincrona simmetrica";
                    } else {
                        if (!RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                            motivazioneErrore = "Gestione busta di risposta asincrona simmetrica non permessa (Busta " + bustaRisposta.getID() + "); il modulo attendeva una ricevuta asincrona";
                            msgDiag.logErroreGenerico(motivazioneErrore, "GestioneProfiloAsincronoSimmetrico");
                            ejbUtils.releaseInboxMessage(false);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(3, motivazioneErrore);
                            return esito;
                        }
                        ricevutaAsincrona = "ricevuta di una risposta asincrona simmetrica";
                    }
                } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRisposta.getProfiloDiCollaborazione())) {
                    if (RuoloBusta.RICEVUTA_RICHIESTA.equals(ruoloBustaRicevuta.toString())) {
                        ricevutaAsincrona = "ricevuta di una richiesta asincrona asimmetrica";
                    } else {
                        if (!RuoloBusta.RICEVUTA_RISPOSTA.equals(ruoloBustaRicevuta.toString())) {
                            motivazioneErrore = "Gestione busta di risposta asincrona asimmetrica non permessa (Busta " + bustaRisposta.getID() + "); il modulo attendeva una ricevuta asincrona";
                            msgDiag.logErroreGenerico(motivazioneErrore, "GestioneProfiloAsincronoAsimmetrico");
                            ejbUtils.releaseInboxMessage(false);
                            openspcoopstate.releaseResource();
                            esito.setEsitoInvocazione(true);
                            esito.setStatoInvocazione(3, motivazioneErrore);
                            return esito;
                        }
                        ricevutaAsincrona = "ricevuta di una risposta asincrona asimmetrica contenente l'esito della richiesta stato";
                    }
                }
            }
            if (sendRispostaApplicativa) {
                if ("OneWay_InvocazioneServizio".equals(richiestaDelegata.getScenario())) {
                    msgResponse = new GestoreMessaggi(openspcoopstate, false, bustaRisposta.getID(), "INBOX", msgDiag, pddContext);
                    msgDiag.mediumDebug("Aggiorno proprietario messaggio...");
                    msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                    msgDiag.mediumDebug("Elimino accesso da PdD...");
                    repositoryBuste.eliminaUtilizzoPdDFromInBox(idResponse);
                    msgDiag.mediumDebug("Invio messaggio 'OK' al modulo di RicezioneContenutiApplicativi, oneway con scenario sincrono...");
                    msgResponse = protocolManager.isHttpEmptyResponseOneWay() ? ejbUtils.sendRispostaApplicativaOK(SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap), richiestaDelegata, pd, sa) : ejbUtils.sendRispostaApplicativaOK(ejbUtils.buildOpenSPCoopOK_soapMsg(versioneSoap, idMessageRequest), richiestaDelegata, pd, sa);
                } else {
                    msgDiag.mediumDebug("Send risposta applicativa...");
                    msgResponse = ejbUtils.sendRispostaApplicativa(richiestaDelegata, pd, sa);
                }
            } else {
                msgResponse = new GestoreMessaggi(openspcoopstate, false, bustaRisposta.getID(), "INBOX", msgDiag, pddContext);
                msgDiag.mediumDebug("Aggiorno proprietario messaggio...");
                msgResponse.aggiornaProprietarioMessaggio("GestoreMessaggi");
                msgDiag.mediumDebug("Elimino accesso da PdD...");
                repositoryBuste.eliminaUtilizzoPdDFromInBox(idResponse, statelessAsincrono);
            }
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della busta...");
            openspcoopstate.commit();
        }
        catch (Exception e) {
            this.log.error((Object)"ErroreGenerale", (Throwable)e);
            msgDiag.logErroreGenerico(e, "Generale");
            if (sendRispostaApplicativa) {
                OpenSPCoop2Message responseMessageError = this.erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), eParsing);
                try {
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, rollbackRiferimentoMessaggio, pd, sa);
                    esito.setStatoInvocazione(2, "ErroreGenerale");
                    esito.setEsitoInvocazione(true);
                }
                catch (Exception er) {
                    msgDiag.logErroreGenerico(er, "ejbUtils.sendErroreGenerale(profiloConRisposta)");
                    ejbUtils.rollbackMessage("Spedizione Errore al Mittente durante una richiesta sincrona non riuscita", esito);
                    esito.setStatoInvocazioneErroreNonGestito(er);
                    esito.setEsitoInvocazione(false);
                }
            } else {
                ejbUtils.rollbackMessage("ErroreGenerale:" + e.getMessage(), esito);
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
            }
            openspcoopstate.releaseResource();
            return esito;
        }
        if (msgResponse != null) {
            msgResponse.addMessaggiIntoCache_readFromTable(ID_MODULO, "risposte");
        }
        if (msgResponse != null) {
            msgResponse.addProprietariIntoCache_readFromTable(ID_MODULO, "risposte", idMessageRequest, false);
        }
        if (ricevutaAsincrona != null) {
            msgDiag.mediumDebug("Gestione ricevute asincrone...");
            try {
                boolean forzaEliminazioneMessaggio = false;
                if (openspcoopstate instanceof OpenSPCoopStateless && "ricevuta di una richiesta asincrona simmetrica".equals(ricevutaAsincrona)) {
                    forzaEliminazioneMessaggio = true;
                }
                GestoreMessaggi msgRiscontrato = new GestoreMessaggi(openspcoopstate, false, bustaRisposta.getRiferimentoMessaggio(), "OUTBOX", msgDiag, pddContext);
                msgRiscontrato.setReadyForDrop(forzaEliminazioneMessaggio);
                msgRiscontrato.validateAndDeleteMsgAsincronoRiscontrato(bustaRisposta);
                msgDiag.addKeyword("@TIPO_RICEVUTA_ASINCRONA@", ricevutaAsincrona);
                msgDiag.logPersonalizzato("validazioneRicevutaAsincrona");
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "Validazione(" + ricevutaAsincrona + ")");
            }
        }
        msgDiag.mediumDebug("Rilascio connessione al database...");
        openspcoopstate.releaseResource();
        msgDiag.mediumDebug("Lavoro Terminato.");
        esito.setStatoInvocazione(1, null);
        esito.setEsitoInvocazione(true);
        return esito;
    }
}

