/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.TransactionManager;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.Imbustamento;
import org.openspcoop2.pdd.mdb.ImbustamentoMessage;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;

public class ImbustamentoMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private Logger log = null;
    private MessageDrivenContext ctxMDB;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoop2Startup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (this.log == null) {
                System.out.println("[Imbustamento] Logger nullo. MDB abortito");
                return;
            }
            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                this.log.error((Object)("[Imbustamento] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Tracciamento.tracciamentoDisponibile) {
                this.log.error((Object)("[Imbustamento] Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage()), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                this.log.error((Object)("[Imbustamento] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Dump.sistemaDumpDisponibile) {
                this.log.error((Object)("[Imbustamento] Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage()), (Throwable)Dump.motivoMalfunzionamentoDump);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            Imbustamento lib = null;
            try {
                lib = new Imbustamento(this.log);
            }
            catch (Exception e) {
                this.log.error((Object)("Imbustamento.instanziazione: " + e.getMessage()), (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!lib.inizializzazioneUltimata) {
                this.log = Logger.getLogger(ImbustamentoMDB.class);
                this.log.error((Object)"[Imbustamento] Inizializzazione MDB non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = new MsgDiagnostico("Imbustamento", new IState[0]);
            msgDiag.mediumDebug("Ricezione richiesta (ImbustamentoMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            ImbustamentoMessage imbustamentoMsg = null;
            try {
                imbustamentoMsg = (ImbustamentoMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getObject(ImbustamentoMessage)");
                return;
            }
            String idMessageRequest = null;
            try {
                idMessageRequest = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getStringProperty(ID)");
                return;
            }
            OpenSPCoopStateful stato = null;
            try {
                stato = new OpenSPCoopStateful();
                stato.setIDMessaggioSessione(idMessageRequest);
                stato.setMessageLib(imbustamentoMsg);
            }
            catch (Exception e) {
                this.log.error((Object)"[Imbustamento] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            msgDiag.updateState(stato.getStatoRichiesta(), stato.getStatoRisposta());
            PdDContext pddContext = imbustamentoMsg.getPddContext();
            try {
                msgDiag.setPddContext(pddContext, ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO")));
            }
            catch (ProtocolException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "ProtocolFactory.instanziazione");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "Imbustamento", idMessageRequest, "OUTBOX", received.getJMSMessageID(), pddContext)) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessageRequest);
                    msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", "Imbustamento");
                    msgDiag.logPersonalizzato("all.", "transactionManager.validityCheckError");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            try {
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                this.log.error((Object)"[Imbustamento] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                this.log.info((Object)"[Imbustamento] Invocazione della libreria terminata con esito negativo, verr\u00e0 effettuato un rollback sulla coda JMS");
                this.ctxMDB.setRollbackOnly();
            } else {
                this.log.debug((Object)"[Imbustamento] Invocazione della libreria terminata correttamente");
            }
        }
    }
}

