/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import java.util.Date;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.EJBUtils;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.mdb.GenericLib;
import org.openspcoop2.pdd.mdb.GenericLibException;
import org.openspcoop2.pdd.mdb.ImbustamentoMessage;
import org.openspcoop2.pdd.mdb.InoltroBusteMessage;
import org.openspcoop2.protocol.engine.builder.ErroreApplicativoBuilder;
import org.openspcoop2.protocol.engine.driver.ConsegnaInOrdine;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.driver.Riscontri;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Servizio;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;

public class Imbustamento
extends GenericLib {
    public static final String ID_MODULO = "Imbustamento";

    public Imbustamento(Logger log) throws GenericLibException {
        super(ID_MODULO, log);
        this.inizializza();
    }

    @Override
    protected synchronized void inizializza() throws GenericLibException {
        super.inizializza();
    }

    @Override
    public EsitoLib _onMessage(IOpenSPCoopState openspcoopstate, RegistroServiziManager registroServiziManager, ConfigurazionePdDManager configurazionePdDManager, MsgDiagnostico msgDiag) throws OpenSPCoopStateException {
        EsitoLib esito = new EsitoLib();
        ImbustamentoMessage imbustamentoMsg = (ImbustamentoMessage)openspcoopstate.getMessageLib();
        PdDContext pddContext = imbustamentoMsg.getPddContext();
        String idTransazione = PdDContext.getValue("ID", pddContext);
        IProtocolFactory protocolFactory = null;
        IProtocolVersionManager protocolManager = null;
        ITraduttore traduttore = null;
        try {
            protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO"));
            protocolManager = protocolFactory.createProtocolVersionManager(imbustamentoMsg.getRichiestaDelegata().getProfiloGestione());
            traduttore = protocolFactory.createTraduttore();
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ProtocolFactory.instanziazione");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        SOAPVersion versioneSoap = (SOAPVersion)pddContext.getObject("SOAP_VERSION");
        msgDiag.setPddContext(pddContext, protocolFactory);
        String idMessageRequest = openspcoopstate.getIDMessaggioSessione();
        String implementazionePdDDestinatario = imbustamentoMsg.getImplementazionePdDSoggettoDestinatario();
        RichiestaDelegata richiestaDelegata = imbustamentoMsg.getRichiestaDelegata();
        IDSoggetto identitaPdD = imbustamentoMsg.getRichiestaDelegata().getDominio();
        TipoPdD tipoPdD = TipoPdD.DELEGATA;
        msgDiag.setDominio(identitaPdD);
        msgDiag.setPrefixMsgPersonalizzati("imbustamentoBusta.");
        msgDiag.setIdMessaggioRichiesta(idMessageRequest);
        msgDiag.addKeyword("@ID_MESSAGGIO_RICHIESTA@", idMessageRequest);
        msgDiag.setDelegata(true);
        msgDiag.setPorta(richiestaDelegata.getLocationPD());
        msgDiag.setFruitore(richiestaDelegata.getSoggettoFruitore());
        msgDiag.addKeywords(richiestaDelegata.getSoggettoFruitore());
        msgDiag.setServizio(richiestaDelegata.getIdServizio());
        msgDiag.addKeywords(richiestaDelegata.getIdServizio());
        msgDiag.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
        msgDiag.addKeyword("@SERVIZIO_APPLICATIVO_FRUITORE@", richiestaDelegata.getServizioApplicativo());
        if (richiestaDelegata.getProfiloCollaborazione() != null) {
            msgDiag.addKeyword("@PROFILO_COLLABORAZIONE@", traduttore.toString(richiestaDelegata.getProfiloCollaborazione()));
        }
        msgDiag.setIdCorrelazioneApplicativa(richiestaDelegata.getIdCorrelazioneApplicativa());
        msgDiag.addKeyword("@ID_CORRELAZIONE_APPLICATIVA@", richiestaDelegata.getIdCorrelazioneApplicativa());
        msgDiag.addKeyword("@FUNZIONALITA_COLLABORAZIONE@", imbustamentoMsg.getInfoServizio().getCollaborazione() + "");
        msgDiag.addKeyword("@FUNZIONALITA_CONFERMA_RICEZIONE@", imbustamentoMsg.getInfoServizio().getConfermaRicezione() + "");
        msgDiag.addKeyword("@FUNZIONALITA_FILTRO_DUPLICATI@", Inoltro.SENZA_DUPLICATI.equals(imbustamentoMsg.getInfoServizio().getInoltro()) + "");
        ErroreApplicativoBuilder erroreApplicativoBuilder = null;
        try {
            erroreApplicativoBuilder = new ErroreApplicativoBuilder(this.log, protocolFactory, identitaPdD, richiestaDelegata.getSoggettoFruitore(), richiestaDelegata.getIdServizio(), this.idModulo, richiestaDelegata.getFault(), versioneSoap, tipoPdD, richiestaDelegata.getServizioApplicativo());
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ErroreApplicativoBuilder.instanziazione");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        msgDiag.mediumDebug("Inizializzo stato per la gestione della richiesta...");
        openspcoopstate.initResource(identitaPdD, ID_MODULO, idTransazione);
        registroServiziManager.updateState(new IState[]{openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta()});
        configurazionePdDManager.updateState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
        msgDiag.updateState(openspcoopstate.getStatoRichiesta(), openspcoopstate.getStatoRisposta());
        msgDiag.mediumDebug("Inizializzo contesto per la gestione...");
        EJBUtils ejbUtils = null;
        try {
            ejbUtils = new EJBUtils(identitaPdD, tipoPdD, ID_MODULO, idMessageRequest, idMessageRequest, "OUTBOX", openspcoopstate, msgDiag, false, imbustamentoMsg.getImplementazionePdDSoggettoMittente(), imbustamentoMsg.getImplementazionePdDSoggettoDestinatario(), imbustamentoMsg.getRichiestaDelegata().getProfiloGestione(), pddContext);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "EJBUtils.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        boolean oneWayVersione11 = imbustamentoMsg.isOneWayVersione11();
        ejbUtils.setOneWayVersione11(oneWayVersione11);
        RepositoryBuste repositoryBuste = new RepositoryBuste(openspcoopstate.getStatoRichiesta(), true, protocolFactory);
        Riscontri gestoreRiscontri = new Riscontri(openspcoopstate.getStatoRichiesta());
        org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione(openspcoopstate.getStatoRichiesta(), protocolFactory);
        }
        catch (Exception e) {
            msgDiag.logErroreGenerico(e, "ProfiloDiCollaborazione.new");
            openspcoopstate.releaseResource();
            esito.setEsitoInvocazione(false);
            esito.setStatoInvocazioneErroreNonGestito(e);
            return esito;
        }
        ConsegnaInOrdine ordineConsegna = new ConsegnaInOrdine(openspcoopstate.getStatoRichiesta(), protocolFactory);
        GestoreMessaggi msgRequest = null;
        GestoreMessaggi msgOK = null;
        Servizio infoServizio = imbustamentoMsg.getInfoServizio();
        String riferimentoServizioCorrelato = imbustamentoMsg.getRiferimentoServizioCorrelato();
        boolean isServizioCorrelato = infoServizio.isCorrelato();
        IDServizio idServizio = richiestaDelegata.getIdServizio();
        IDSoggetto soggettoFruitore = richiestaDelegata.getSoggettoFruitore();
        ProprietaErroreApplicativo proprietaErroreAppl = richiestaDelegata.getFault();
        proprietaErroreAppl.setIdModulo(ID_MODULO);
        PortaDelegata pd = null;
        ServizioApplicativo sa = null;
        try {
            boolean consegnaInOrdine;
            boolean idCollaborazione;
            boolean consegnaAffidabile;
            long scadenzaBusta;
            Busta busta;
            block143: {
                msgDiag.mediumDebug("Check utilizzo consegna risposta asincrona...");
                if (!infoServizio.getProfiloDiCollaborazione().equals(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO) || riferimentoServizioCorrelato != null || isServizioCorrelato) {
                    richiestaDelegata.setUtilizzoConsegnaAsincrona(true);
                }
                Utilities.printFreeMemory((String)"Imbustamento - Costruzione busta ...");
                msgDiag.mediumDebug("Costruzione busta ...");
                busta = new Busta(protocolFactory.getProtocol());
                busta.setTipoDestinatario(idServizio.getSoggettoErogatore().getTipo());
                busta.setDestinatario(idServizio.getSoggettoErogatore().getNome());
                busta.setIdentificativoPortaDestinatario(idServizio.getSoggettoErogatore().getCodicePorta());
                busta.setIndirizzoDestinatario(imbustamentoMsg.getIndirizzoSoggettoDestinatario());
                busta.setVersioneServizio(idServizio.getVersioneServizio());
                busta.setServizio(idServizio.getServizio());
                busta.setTipoServizio(idServizio.getTipoServizio());
                busta.setAzione(idServizio.getAzione());
                busta.setTipoMittente(soggettoFruitore.getTipo());
                busta.setMittente(soggettoFruitore.getNome());
                busta.setIdentificativoPortaMittente(soggettoFruitore.getCodicePorta());
                busta.setIndirizzoMittente(imbustamentoMsg.getIndirizzoSoggettoMittente());
                busta.setServizioApplicativoFruitore(richiestaDelegata.getServizioApplicativo());
                msgDiag.highDebug("Costruzione Busta con ID = " + idMessageRequest);
                busta.setID(idMessageRequest);
                Date oraRegistrazione = DateManager.getDate();
                msgDiag.highDebug("Costruzione Busta in data : [" + oraRegistrazione + "]");
                busta.setOraRegistrazione(oraRegistrazione);
                TipoOraRegistrazione tipoOraRegistrazione = this.propertiesReader.getTipoTempoBusta(implementazionePdDDestinatario);
                busta.setTipoOraRegistrazione(tipoOraRegistrazione, protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                busta.setScadenza(infoServizio.getScadenza());
                scadenzaBusta = infoServizio.getScadenzaMinuti();
                if (scadenzaBusta <= 0L) {
                    scadenzaBusta = this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi();
                }
                switch (protocolManager.getFiltroDuplicati(infoServizio.getProfiloDiCollaborazione())) {
                    case ABILITATA: {
                        busta.setInoltro(Inoltro.SENZA_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.SENZA_DUPLICATI));
                        break;
                    }
                    case DISABILITATA: {
                        busta.setInoltro(Inoltro.CON_DUPLICATI, protocolFactory.createTraduttore().toString(Inoltro.CON_DUPLICATI));
                        break;
                    }
                    default: {
                        busta.setInoltro(infoServizio.getInoltro(), protocolFactory.createTraduttore().toString(infoServizio.getInoltro()));
                    }
                }
                consegnaAffidabile = false;
                switch (protocolManager.getConsegnaAffidabile(infoServizio.getProfiloDiCollaborazione())) {
                    case ABILITATA: {
                        consegnaAffidabile = true;
                        break;
                    }
                    case DISABILITATA: {
                        consegnaAffidabile = false;
                        break;
                    }
                    default: {
                        consegnaAffidabile = this.propertiesReader.isGestioneRiscontri(implementazionePdDDestinatario) && infoServizio.getConfermaRicezione();
                    }
                }
                idCollaborazione = false;
                switch (protocolManager.getCollaborazione(infoServizio.getProfiloDiCollaborazione())) {
                    case ABILITATA: {
                        idCollaborazione = true;
                        break;
                    }
                    case DISABILITATA: {
                        idCollaborazione = false;
                        break;
                    }
                    default: {
                        idCollaborazione = this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario) && infoServizio.getCollaborazione();
                    }
                }
                consegnaInOrdine = false;
                switch (protocolManager.getConsegnaInOrdine(infoServizio.getProfiloDiCollaborazione())) {
                    case ABILITATA: {
                        consegnaInOrdine = true;
                        break;
                    }
                    case DISABILITATA: {
                        consegnaInOrdine = false;
                        break;
                    }
                    default: {
                        boolean bl = consegnaInOrdine = this.propertiesReader.isGestioneConsegnaInOrdine(implementazionePdDDestinatario) && infoServizio.getOrdineConsegna();
                    }
                }
                if (consegnaAffidabile) {
                    busta.setConfermaRicezione(true);
                } else {
                    busta.setConfermaRicezione(false);
                }
                pd = configurazionePdDManager.getPortaDelegata(richiestaDelegata.getIdPortaDelegata());
                try {
                    sa = configurazionePdDManager.getServizioApplicativo(richiestaDelegata.getIdPortaDelegata(), richiestaDelegata.getServizioApplicativo());
                }
                catch (DriverConfigurazioneNotFound e) {
                    if ("Anonimo".equals(richiestaDelegata.getServizioApplicativo())) break block143;
                    throw e;
                }
            }
            try {
                IProtocolConfiguration protocolConfiguration = protocolFactory.createProtocolConfiguration();
                if (!protocolConfiguration.isSupportato(infoServizio.getProfiloDiCollaborazione())) {
                    throw new Exception("Profilo di Collaborazione [" + infoServizio.getProfiloDiCollaborazione().getEngineValue() + "]");
                }
                if (busta.getInoltro() != null && Inoltro.SENZA_DUPLICATI.equals(busta.getInoltro()) && !protocolConfiguration.isSupportato(FunzionalitaProtocollo.FILTRO_DUPLICATI)) {
                    throw new Exception(FunzionalitaProtocollo.FILTRO_DUPLICATI.getEngineValue());
                }
                if (consegnaAffidabile && !protocolConfiguration.isSupportato(FunzionalitaProtocollo.CONFERMA_RICEZIONE)) {
                    throw new Exception(FunzionalitaProtocollo.CONFERMA_RICEZIONE.getEngineValue());
                }
                if (idCollaborazione && !protocolConfiguration.isSupportato(FunzionalitaProtocollo.COLLABORAZIONE)) {
                    throw new Exception(FunzionalitaProtocollo.COLLABORAZIONE.getEngineValue());
                }
                if (consegnaInOrdine && !protocolConfiguration.isSupportato(FunzionalitaProtocollo.CONSEGNA_IN_ORDINE)) {
                    throw new Exception(FunzionalitaProtocollo.CONSEGNA_IN_ORDINE.getEngineValue());
                }
                if (infoServizio.getScadenza() != null && !protocolConfiguration.isSupportato(FunzionalitaProtocollo.SCADENZA)) {
                    throw new Exception(FunzionalitaProtocollo.SCADENZA.getEngineValue());
                }
                if (configurazionePdDManager.isGestioneManifestAttachments(pd, protocolFactory) && !protocolConfiguration.isSupportato(FunzionalitaProtocollo.MANIFEST_ATTACHMENTS)) {
                    throw new Exception(FunzionalitaProtocollo.MANIFEST_ATTACHMENTS.getEngineValue());
                }
            }
            catch (Exception e) {
                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", e.getMessage());
                msgDiag.logPersonalizzato("protocolli.funzionalita.unsupported");
                OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_439_FUNZIONALITA_NOT_SUPPORTED_BY_PROTOCOL.getErrore439_FunzionalitaNotSupportedByProtocol(e.getMessage(), protocolFactory), e);
                ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("protocolli.funzionalita.unsupported"));
                return esito;
            }
            if (consegnaInOrdine) {
                OpenSPCoop2Message responseMessageError;
                msgDiag.mediumDebug("Check vincoli consegna in ordine...");
                if (!infoServizio.getProfiloDiCollaborazione().equals(ProfiloDiCollaborazione.ONEWAY)) {
                    msgDiag.addKeyword("@PROFILO_COLLABORAZIONE@", traduttore.toString(infoServizio.getProfiloDiCollaborazione()));
                    msgDiag.logPersonalizzato("consegnaInOrdine.profiloNonOneway");
                    responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_414_CONSEGNA_IN_ORDINE_CON_PROFILO_NO_ONEWAY.getErroreIntegrazione(), null);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("consegnaInOrdine.profiloNonOneway"));
                    return esito;
                }
                if (!this.propertiesReader.isGestioneRiscontri(implementazionePdDDestinatario)) {
                    msgDiag.logPersonalizzato("consegnaInOrdine.confermaRicezioneNonRichiesta");
                    responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_415_CONSEGNA_IN_ORDINE_SENZA_VINCOLI_RICHIESTI.getErroreIntegrazione(), null);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("consegnaInOrdine.confermaRicezioneNonRichiesta"));
                    return esito;
                }
                if (!this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario)) {
                    msgDiag.logPersonalizzato("consegnaInOrdine.idCollaborazioneNonRichiesto");
                    responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_415_CONSEGNA_IN_ORDINE_SENZA_VINCOLI_RICHIESTI.getErroreIntegrazione(), null);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("consegnaInOrdine.idCollaborazioneNonRichiesto"));
                    return esito;
                }
                if (!(infoServizio.getCollaborazione() && infoServizio.getConfermaRicezione() && Inoltro.SENZA_DUPLICATI.equals(infoServizio.getInoltro()))) {
                    msgDiag.logPersonalizzato("consegnaInOrdine.funzionalitaMancanti");
                    responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_415_CONSEGNA_IN_ORDINE_SENZA_VINCOLI_RICHIESTI.getErroreIntegrazione(), null);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("consegnaInOrdine.funzionalitaMancanti"));
                    return esito;
                }
            }
            boolean gestioneConsegnaInOrdineAbilitata = consegnaInOrdine && this.propertiesReader.isGestioneRiscontri(implementazionePdDDestinatario) && this.propertiesReader.isGestioneElementoCollaborazione(implementazionePdDDestinatario) && this.propertiesReader.isGestioneConsegnaInOrdine(implementazionePdDDestinatario);
            Utilities.printFreeMemory((String)"Imbustamento - Gestione profilo di Collaborazione...");
            boolean generazioneMsgOK = false;
            String scenarioCooperazione = null;
            if (infoServizio.getProfiloDiCollaborazione().equals(ProfiloDiCollaborazione.ONEWAY)) {
                msgDiag.mediumDebug("Gestione profilo di Collaborazione OneWay ...");
                busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY);
                scenarioCooperazione = "OneWay_InvocazioneServizio";
                if (idCollaborazione) {
                    if (imbustamentoMsg.getIdCollaborazione() != null) {
                        busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                    } else {
                        busta.setCollaborazione(idMessageRequest);
                    }
                }
                if (gestioneConsegnaInOrdineAbilitata && infoServizio.getOrdineConsegna() && (oneWayVersione11 || openspcoopstate instanceof OpenSPCoopStateful)) {
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione OneWay (consegna in ordine)...");
                    try {
                        ordineConsegna.setNextSequenza_daInviare(busta);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "ordineConsegna.setNextSequenza_daInviare");
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "ordineConsegna.setNextSequenza_daInviare");
                        return esito;
                    }
                }
                generazioneMsgOK = !configurazionePdDManager.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione());
            } else if (infoServizio.getProfiloDiCollaborazione().equals(ProfiloDiCollaborazione.SINCRONO)) {
                msgDiag.mediumDebug("Gestione profilo di Collaborazione Sincrono ...");
                busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO);
                scenarioCooperazione = "Sincrono_InvocazioneServizio";
                try {
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione Sincrono (Registrazione Busta da inviare)...");
                    profiloCollaborazione.registraBustaInviata(idMessageRequest);
                }
                catch (ProtocolException e) {
                    msgDiag.logErroreGenerico((Exception)((Object)e), "profiloDiCollaborazione.registraBustaInviata");
                    OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), (Exception)((Object)e));
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "profiloDiCollaborazione.registraBustaInviata");
                    return esito;
                }
                if (idCollaborazione) {
                    if (imbustamentoMsg.getIdCollaborazione() != null) {
                        busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                    } else {
                        busta.setCollaborazione(idMessageRequest);
                    }
                }
            } else if (infoServizio.getProfiloDiCollaborazione().equals(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO)) {
                msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico ...");
                busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico (check ricevuta abilitata)...");
                richiestaDelegata.setRicevutaAsincrona(configurazionePdDManager.ricevutaAsincronaSimmetricaAbilitata(pd));
                generazioneMsgOK = !configurazionePdDManager.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione()) ? !richiestaDelegata.isRicevutaAsincrona() : false;
                if (riferimentoServizioCorrelato == null && !isServizioCorrelato) {
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico richiesta...");
                    if ("Anonimo".equals(richiestaDelegata.getServizioApplicativo())) {
                        msgDiag.logPersonalizzato("profiloAsincronoSimmetrico.saAnonimo");
                        OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_410_AUTENTICAZIONE_RICHIESTA.getErroreIntegrazione(), null);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincronoSimmetrico.saAnonimo"));
                        return esito;
                    }
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico richiesta (consegna asincrona)...");
                    boolean existsConsegnaRispostaAsincrona = false;
                    try {
                        existsConsegnaRispostaAsincrona = configurazionePdDManager.existsConsegnaRispostaAsincrona(sa);
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "existsConsegnaRispostaAsincrona(" + sa + ")");
                        OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE), e);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "existsConsegnaRispostaAsincrona(" + sa + ")");
                        return esito;
                    }
                    if (!existsConsegnaRispostaAsincrona) {
                        msgDiag.logPersonalizzato("profiloAsincronoSimmetrico.saSenzaRispostaAsincrona");
                        OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_411_RICEZIONE_CONTENUTI_ASINCRONA_RICHIESTA.getErroreIntegrazione(), null);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincronoSimmetrico.saSenzaRispostaAsincrona"));
                        return esito;
                    }
                    scenarioCooperazione = "AsincronoSimmetrico_InvocazioneServizio";
                    if (infoServizio.getServizioCorrelato() == null || infoServizio.getTipoServizioCorrelato() == null) {
                        msgDiag.logPersonalizzato("profiloAsincronoSimmetrico.servizioCorrelatoNonEsistente");
                        OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_408_SERVIZIO_CORRELATO_NON_TROVATO.getErroreIntegrazione(), null);
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, msgDiag.getMessaggio_replaceKeywords("profiloAsincronoSimmetrico.servizioCorrelatoNonEsistente"));
                        return esito;
                    }
                    if (protocolManager.isGenerazioneInformazioniServizioCorrelatoAsincronoSimmetrico() && this.propertiesReader.isGenerazioneAttributiAsincroni(implementazionePdDDestinatario)) {
                        busta.setServizioCorrelato(infoServizio.getServizioCorrelato());
                        busta.setTipoServizioCorrelato(infoServizio.getTipoServizioCorrelato());
                    }
                    if (idCollaborazione) {
                        if (imbustamentoMsg.getIdCollaborazione() != null) {
                            busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                        } else {
                            busta.setCollaborazione(idMessageRequest);
                        }
                    }
                    try {
                        msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico richiesta (registrazione busta da inviare)...");
                        Integrazione infoIntegrazione = null;
                        if (configurazionePdDManager.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione())) {
                            infoIntegrazione = new Integrazione();
                            infoIntegrazione.setIdModuloInAttesa(this.idModulo);
                            infoIntegrazione.setLocationPD(richiestaDelegata.getLocationPD());
                            infoIntegrazione.setServizioApplicativo(richiestaDelegata.getServizioApplicativo());
                            if (busta.getScadenza() == null) {
                                busta.setScadenza(new Date(DateManager.getTimeMillis() + scadenzaBusta * 60L * 1000L));
                            }
                            if (openspcoopstate instanceof OpenSPCoopStateless) {
                                ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(busta);
                            }
                        }
                        profiloCollaborazione.asincronoSimmetrico_registraRichiestaInviata(idMessageRequest, busta.getCollaborazione(), infoServizio.getTipoServizioCorrelato(), infoServizio.getServizioCorrelato(), richiestaDelegata.isRicevutaAsincrona(), infoIntegrazione, scadenzaBusta);
                    }
                    catch (ProtocolException e) {
                        msgDiag.logErroreGenerico((Exception)((Object)e), "profiloDiCollaborazione.asincronoSimmetrico_registraRichiestaInviata");
                        openspcoopstate.releaseResource();
                        OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), (Exception)((Object)e));
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "profiloDiCollaborazione.asincronoSimmetrico_registraRichiestaInviata");
                        return esito;
                    }
                    richiestaDelegata.setUtilizzoConsegnaAsincrona(false);
                } else {
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico risposta...");
                    scenarioCooperazione = "AsincronoSimmetrico_ConsegnaRisposta";
                    msgDiag.addKeyword("@ID_CORRELAZIONE_ASINCRONA@", riferimentoServizioCorrelato);
                    msgDiag.logPersonalizzato("profiloAsincronoSimmetrico.risposta.correlazioneRichiesta");
                    if (openspcoopstate instanceof OpenSPCoopStateless) {
                        if (busta.getScadenza() == null) {
                            busta.setScadenza(new Date(DateManager.getTimeMillis() + scadenzaBusta * 60L * 1000L));
                        }
                        ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(busta);
                    }
                    try {
                        msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico risposta (lettura busta risposta)...");
                        Busta rispostaAsincrona = profiloCollaborazione.asincronoSimmetrico_getBustaRisposta(riferimentoServizioCorrelato, idMessageRequest, scadenzaBusta);
                        msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoSimmetrico risposta (check coerenza)...");
                        if (!busta.getTipoMittente().equals(rispostaAsincrona.getTipoDestinatario())) {
                            throw new ProtocolException("Il tipo di mittente della risposta non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getMittente().equals(rispostaAsincrona.getDestinatario())) {
                            throw new ProtocolException("Il mittente della risposta non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getTipoDestinatario().equals(rispostaAsincrona.getTipoMittente())) {
                            throw new ProtocolException("Il tipo di destinatario della risposta non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getDestinatario().equals(rispostaAsincrona.getMittente())) {
                            throw new ProtocolException("Il destinatario della risposta non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getTipoServizio().equals(rispostaAsincrona.getTipoServizioCorrelato())) {
                            throw new ProtocolException("Il tipo del servizio correlato invocato non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (!busta.getServizio().equals(rispostaAsincrona.getServizioCorrelato())) {
                            throw new ProtocolException("Il servizio correlato invocato non rispetta quello atteso nella gestione del profilo asincrono simmetrico.");
                        }
                        if (protocolManager.isCorrelazioneRichiestaPresenteRispostaAsincronaSimmetrica()) {
                            busta.setRiferimentoMessaggio(riferimentoServizioCorrelato);
                        }
                    }
                    catch (ProtocolException e) {
                        ErroreIntegrazione erroreIntegrazione = null;
                        this.log.error((Object)("Busta per correlazione asincrona simmetrica (" + riferimentoServizioCorrelato + ") non trovata"), (Throwable)e);
                        if (e.getMessage() != null && e.getMessage().indexOf("Busta non trovata") != -1 || e.getMessage().indexOf("Tipo/Nome servizio correlato non trovato") != -1) {
                            msgDiag.logPersonalizzato("profiloAsincronoSimmetrico.rispostaNonCorrelataRichiesta");
                            erroreIntegrazione = ErroriIntegrazione.ERRORE_409_RISPOSTA_ASINCRONA_NON_CORRELATA_ALLA_RICHIESTA.getErroreIntegrazione();
                        } else {
                            msgDiag.logErroreGenerico((Exception)((Object)e), "profiloDiCollaborazione.asincronoSimmetrico_getBustaRisposta");
                            erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO);
                        }
                        OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(erroreIntegrazione, (Exception)((Object)e));
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "Busta per correlazione asincrona simmetrica (" + riferimentoServizioCorrelato + ") non trovata");
                        return esito;
                    }
                    if (idCollaborazione) {
                        if (imbustamentoMsg.getIdCollaborazione() != null) {
                            busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                        } else {
                            busta.setCollaborazione(riferimentoServizioCorrelato);
                        }
                    }
                }
            } else if (infoServizio.getProfiloDiCollaborazione().equals(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO)) {
                msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico ...");
                busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
                if (riferimentoServizioCorrelato == null && !isServizioCorrelato) {
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiesta...");
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiesta (ricevuta abilitata)...");
                    richiestaDelegata.setRicevutaAsincrona(configurazionePdDManager.ricevutaAsincronaAsimmetricaAbilitata(pd));
                    generazioneMsgOK = !configurazionePdDManager.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione()) ? !richiestaDelegata.isRicevutaAsincrona() : false;
                    scenarioCooperazione = "AsincronoAsimmetrico_InvocazioneServizio";
                    if (idCollaborazione) {
                        if (imbustamentoMsg.getIdCollaborazione() != null) {
                            busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                        } else {
                            busta.setCollaborazione(idMessageRequest);
                        }
                    }
                    try {
                        msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiesta (registrazione busta da inviare)...");
                        if (configurazionePdDManager.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione())) {
                            if (busta.getScadenza() == null) {
                                busta.setScadenza(new Date(DateManager.getTimeMillis() + scadenzaBusta * 60L * 1000L));
                            }
                            if (openspcoopstate instanceof OpenSPCoopStateless) {
                                ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(busta);
                            }
                        }
                        profiloCollaborazione.asincronoAsimmetrico_registraRichiestaInviata(idMessageRequest, busta.getCollaborazione(), richiestaDelegata.isRicevutaAsincrona(), scadenzaBusta);
                    }
                    catch (ProtocolException e) {
                        msgDiag.logErroreGenerico((Exception)((Object)e), "profiloDiCollaborazione.asincronoAsimmetrico_registraRichiestaInviata");
                        OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), (Exception)((Object)e));
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "profiloDiCollaborazione.asincronoAsimmetrico_registraRichiestaInviata");
                        return esito;
                    }
                }
                msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiestaStato...");
                scenarioCooperazione = "AsincronoAsimmetrico_Polling";
                msgDiag.addKeyword("@ID_CORRELAZIONE_ASINCRONA@", riferimentoServizioCorrelato);
                msgDiag.logPersonalizzato("profiloAsincronoAsimmetrico.richiestaStato.correlazioneRichiesta");
                richiestaDelegata.setRicevutaAsincrona(true);
                if (openspcoopstate instanceof OpenSPCoopStateless) {
                    if (busta.getScadenza() == null) {
                        busta.setScadenza(new Date(DateManager.getTimeMillis() + scadenzaBusta * 60L * 1000L));
                    }
                    ((StatelessMessage)openspcoopstate.getStatoRichiesta()).setBusta(busta);
                }
                try {
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiestaStato (lettura busta)...");
                    Busta richiestaStatoAsincrona = profiloCollaborazione.asincronoAsimmetrico_getBustaRisposta(riferimentoServizioCorrelato, idMessageRequest, scadenzaBusta);
                    msgDiag.mediumDebug("Gestione profilo di Collaborazione AsincronoAsimmetrico richiestaStato (check coerenza)...");
                    if (!busta.getTipoMittente().equals(richiestaStatoAsincrona.getTipoMittente())) {
                        throw new ProtocolException("Il tipo di mittente della risposta non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getMittente().equals(richiestaStatoAsincrona.getMittente())) {
                        throw new ProtocolException("Il mittente della risposta non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getTipoDestinatario().equals(richiestaStatoAsincrona.getTipoDestinatario())) {
                        throw new ProtocolException("Il tipo di destinatario della risposta non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getDestinatario().equals(richiestaStatoAsincrona.getDestinatario())) {
                        throw new ProtocolException("Il destinatario della risposta non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getTipoServizio().equals(richiestaStatoAsincrona.getTipoServizioCorrelato())) {
                        throw new ProtocolException("Il tipo del servizio correlato invocato non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (!busta.getServizio().equals(richiestaStatoAsincrona.getServizioCorrelato())) {
                        throw new ProtocolException("Il servizio correlato invocato non rispetta quello atteso nella gestione del profilo asincrono asimmetrico.");
                    }
                    if (protocolManager.isCorrelazioneRichiestaPresenteRichiestaStatoAsincronaAsimmetrica()) {
                        busta.setRiferimentoMessaggio(riferimentoServizioCorrelato);
                    }
                }
                catch (ProtocolException e) {
                    ErroreIntegrazione erroreIntegrazione = null;
                    this.log.error((Object)("Busta per correlazione asincrona asimmetrica (" + riferimentoServizioCorrelato + ") non trovata"), (Throwable)e);
                    if (e.getMessage() != null && e.getMessage().indexOf("Busta non trovata") != -1) {
                        msgDiag.logPersonalizzato("profiloAsincronoAsimmetrico.richiestaStatoNonCorrelataRichiesta");
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_409_RISPOSTA_ASINCRONA_NON_CORRELATA_ALLA_RICHIESTA.getErroreIntegrazione();
                    } else {
                        msgDiag.logErroreGenerico((Exception)((Object)e), "profiloDiCollaborazione.asincronoAsimmetrico_getBustaRisposta");
                        erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO);
                    }
                    OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(erroreIntegrazione, (Exception)((Object)e));
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "Busta per correlazione asincrona asimmetrica (" + riferimentoServizioCorrelato + ") non trovata");
                    return esito;
                }
                if (idCollaborazione) {
                    if (imbustamentoMsg.getIdCollaborazione() != null) {
                        busta.setCollaborazione(imbustamentoMsg.getIdCollaborazione());
                    } else {
                        busta.setCollaborazione(riferimentoServizioCorrelato);
                    }
                }
            } else {
                msgDiag.logErroreGenerico("Profilo di Collaborazione [" + infoServizio.getProfiloDiCollaborazione() + "] non gestito", "gestioneProfiloCollaborazione");
                OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), null);
                ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                openspcoopstate.releaseResource();
                esito.setEsitoInvocazione(true);
                esito.setStatoInvocazione(2, "Profilo di Collaborazione [" + infoServizio.getProfiloDiCollaborazione() + "] non gestito");
                return esito;
            }
            richiestaDelegata.setScenario(scenarioCooperazione);
            ejbUtils.setScenarioCooperazione(scenarioCooperazione);
            richiestaDelegata.setIdCollaborazione(busta.getCollaborazione());
            richiestaDelegata.setProfiloCollaborazione(busta.getProfiloDiCollaborazione(), busta.getProfiloDiCollaborazioneValue());
            boolean stateless = configurazionePdDManager.isModalitaStateless(pd, infoServizio.getProfiloDiCollaborazione());
            if (!oneWayVersione11 && !stateless) {
                msgDiag.mediumDebug("Aggiornamento busta nel RepositoryBuste...");
                try {
                    repositoryBuste.aggiornaBustaIntoOutBox(busta, this.propertiesReader.getRepositoryIntervalloScadenzaMessaggi());
                    repositoryBuste.aggiornaInfoIntegrazioneIntoOutBox_Scenario(busta.getID(), scenarioCooperazione);
                }
                catch (ProtocolException e) {
                    msgDiag.logErroreGenerico((Exception)((Object)e), "repositoryBuste.aggiornaBusta/InfoIntegrazione_IntoOutBox");
                    OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), (Exception)((Object)e));
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setEsitoInvocazione(true);
                    esito.setStatoInvocazione(2, "repositoryBuste.aggiornaBusta/InfoIntegrazione_IntoOutBox");
                    return esito;
                }
            }
            if (consegnaAffidabile) {
                if (ProfiloDiCollaborazione.ONEWAY.equals(infoServizio.getProfiloDiCollaborazione())) {
                    msgDiag.logPersonalizzato("consegnaAffidabile.salvataggioInformazioni");
                    try {
                        gestoreRiscontri.registraRiscontroDaRicevere(busta.getID(), DateManager.getDate());
                    }
                    catch (ProtocolException e) {
                        msgDiag.logErroreGenerico((Exception)((Object)e), "gestoreRiscontri.registraRiscontroDaRicevere");
                        OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_525_GESTIONE_FUNZIONALITA_PROTOCOLLO), (Exception)((Object)e));
                        ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                        openspcoopstate.releaseResource();
                        esito.setEsitoInvocazione(true);
                        esito.setStatoInvocazione(2, "gestoreRiscontri.registraRiscontroDaRicevere");
                        return esito;
                    }
                } else {
                    msgDiag.logPersonalizzato("consegnaAffidabile.profiloNonOneway");
                }
            }
            Utilities.printFreeMemory((String)"Imbustamento - Invio messaggio al modulo di InoltroBuste...");
            msgDiag.mediumDebug("Invio messaggio al modulo di InoltroBuste...");
            InoltroBusteMessage inoltroMSG = new InoltroBusteMessage();
            inoltroMSG.setRichiestaDelegata(richiestaDelegata);
            inoltroMSG.setBusta(busta);
            inoltroMSG.setOneWayVersione11(oneWayVersione11);
            inoltroMSG.setImplementazionePdDSoggettoMittente(imbustamentoMsg.getImplementazionePdDSoggettoMittente());
            inoltroMSG.setImplementazionePdDSoggettoDestinatario(imbustamentoMsg.getImplementazionePdDSoggettoDestinatario());
            inoltroMSG.setPddContext(pddContext);
            msgRequest = new GestoreMessaggi(openspcoopstate, true, idMessageRequest, "OUTBOX", msgDiag, pddContext);
            if (!stateless) {
                if (oneWayVersione11) {
                    OpenSPCoopStateless statelessSerializzabile = ((OpenSPCoopStateless)openspcoopstate).rendiSerializzabile();
                    inoltroMSG.setOpenspcoopstate(statelessSerializzabile);
                    msgRequest.setOneWayVersione11(true);
                }
                try {
                    ejbUtils.getNodeSender(this.propertiesReader, this.log).send(inoltroMSG, "InoltroBuste", msgDiag, identitaPdD, ID_MODULO, idMessageRequest, msgRequest);
                }
                catch (Exception e) {
                    this.log.error((Object)"Spedizione->InoltroBuste non riuscita", (Throwable)e);
                    msgDiag.logErroreGenerico(e, "GenericLib.nodeSender.send(InoltroBuste)");
                    OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_512_SEND), e);
                    ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                    openspcoopstate.releaseResource();
                    esito.setStatoInvocazione(2, "Spedizione->InoltroBuste non riuscita");
                    esito.setEsitoInvocazione(true);
                    return esito;
                }
            }
            Utilities.printFreeMemory((String)"Imbustamento - Gestione Risposta");
            if (generazioneMsgOK) {
                pddContext.addObject("DATA_PRESA_IN_CARICO", Costanti.newSimpleDateFormat().format(DateManager.getDate()));
                msgDiag.mediumDebug("Invio messaggio 'OK' al modulo di RicezioneContenutiApplicativi...");
                msgOK = protocolManager.isHttpEmptyResponseOneWay() ? ejbUtils.sendRispostaApplicativaOK(SoapUtils.build_Soap_Empty((SOAPVersion)versioneSoap), richiestaDelegata, pd, sa) : ejbUtils.sendRispostaApplicativaOK(ejbUtils.buildOpenSPCoopOK_soapMsg(versioneSoap, idMessageRequest), richiestaDelegata, pd, sa);
            }
            msgDiag.mediumDebug("Aggiorno proprietario messaggio...");
            msgRequest.aggiornaProprietarioMessaggio("InoltroBuste");
            msgDiag.mediumDebug("Commit delle operazioni per la gestione della richiesta...");
            openspcoopstate.commit();
            if (msgRequest != null) {
                msgRequest.addMessaggiIntoCache_readFromTable(ID_MODULO, "richiesta");
            }
            if (msgOK != null) {
                msgOK.addMessaggiIntoCache_readFromTable(ID_MODULO, "messaggio OK");
            }
            if (msgRequest != null) {
                msgRequest.addProprietariIntoCache_readFromTable(ID_MODULO, "richiesta", null, false);
            }
            if (msgOK != null) {
                msgOK.addProprietariIntoCache_readFromTable(ID_MODULO, "messaggio OK", idMessageRequest, false);
            }
            msgDiag.mediumDebug("Rilascio connessione al database...");
            openspcoopstate.releaseResource();
            msgDiag.mediumDebug("Lavoro Terminato.");
            esito.setEsitoInvocazione(true);
            esito.setStatoInvocazione(1, null);
            if (stateless) {
                ((OpenSPCoopState)openspcoopstate).setMessageLib(inoltroMSG);
            }
            return esito;
        }
        catch (Exception e) {
            this.log.error((Object)"ErroreGenerale", (Throwable)e);
            msgDiag.logErroreGenerico(e, "Generale");
            OpenSPCoop2Message responseMessageError = erroreApplicativoBuilder.toMessage(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreIntegrazione(), e);
            try {
                ejbUtils.sendRispostaApplicativaErrore(responseMessageError, richiestaDelegata, pd, sa);
                esito.setStatoInvocazione(2, "ErroreGenerale");
                esito.setEsitoInvocazione(true);
            }
            catch (Exception er) {
                msgDiag.logErroreGenerico(er, "ejbUtils.sendErroreGenerale");
                ejbUtils.rollbackMessage("Spedizione Errore al Mittente durante una richiesta non riuscita", esito);
                esito.setEsitoInvocazione(false);
                esito.setStatoInvocazioneErroreNonGestito(e);
            }
            openspcoopstate.releaseResource();
            return esito;
        }
    }
}

