/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.mdb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.RichiestaApplicativa;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.TransactionManager;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.Dump;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.logger.Tracciamento;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativi;
import org.openspcoop2.pdd.mdb.ConsegnaContenutiApplicativiMessage;
import org.openspcoop2.pdd.mdb.EsitoLib;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.pdd.timers.TimerMonitoraggioRisorse;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;

public class ConsegnaContenutiApplicativiMDB
implements MessageDrivenBean,
MessageListener {
    private static final long serialVersionUID = 1L;
    private Logger log = null;
    private MessageDrivenContext ctxMDB;

    public void setMessageDrivenContext(MessageDrivenContext mdc) throws EJBException {
        this.ctxMDB = mdc;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void onMessage(Message message) {
        if (message instanceof ObjectMessage) {
            if (!OpenSPCoop2Startup.initialize) {
                this.ctxMDB.setRollbackOnly();
                return;
            }
            this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            if (this.log == null) {
                System.out.println("[ConsegnaContenutiApplicativi] Logger nullo. MDB abortito");
                return;
            }
            if (!TimerMonitoraggioRisorse.risorseDisponibili) {
                this.log.error((Object)("[ConsegnaContenutiApplicativi] Risorse di sistema non disponibili: " + TimerMonitoraggioRisorse.risorsaNonDisponibile.getMessage()), (Throwable)TimerMonitoraggioRisorse.risorsaNonDisponibile);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Tracciamento.tracciamentoDisponibile) {
                this.log.error((Object)("[ConsegnaContenutiApplicativi] Tracciatura non disponibile: " + Tracciamento.motivoMalfunzionamentoTracciamento.getMessage()), (Throwable)Tracciamento.motivoMalfunzionamentoTracciamento);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!MsgDiagnostico.gestoreDiagnosticaDisponibile) {
                this.log.error((Object)("[ConsegnaContenutiApplicativi] Sistema di diagnostica non disponibile: " + MsgDiagnostico.motivoMalfunzionamentoDiagnostici.getMessage()), (Throwable)MsgDiagnostico.motivoMalfunzionamentoDiagnostici);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!Dump.sistemaDumpDisponibile) {
                this.log.error((Object)("[ConsegnaContenutiApplicativi] Sistema di dump dei contenuti applicativi non disponibile: " + Dump.motivoMalfunzionamentoDump.getMessage()), (Throwable)Dump.motivoMalfunzionamentoDump);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            ConsegnaContenutiApplicativi lib = null;
            try {
                lib = new ConsegnaContenutiApplicativi(this.log);
            }
            catch (Exception e) {
                this.log.error((Object)("ConsegnaContenutiApplicativi.instanziazione: " + e.getMessage()), (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!lib.inizializzazioneUltimata) {
                this.log = Logger.getLogger(ConsegnaContenutiApplicativiMDB.class);
                this.log.error((Object)"[ConsegnaContenutiApplicativi] Inizializzazione MDB non riuscita");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            MsgDiagnostico msgDiag = new MsgDiagnostico("ConsegnaContenutiApplicativi", new IState[0]);
            msgDiag.mediumDebug("Ricezione richiesta (ConsegnaContenutiApplicativiMessage)...");
            ObjectMessage received = (ObjectMessage)message;
            ConsegnaContenutiApplicativiMessage consegnaContenutiApplicativiMsg = null;
            try {
                consegnaContenutiApplicativiMsg = (ConsegnaContenutiApplicativiMessage)received.getObject();
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getObject(ConsegnaContenutiApplicativiMessage)");
                return;
            }
            String idMessaggioConsegna = null;
            try {
                idMessaggioConsegna = received.getStringProperty("ID");
            }
            catch (JMSException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "received.getStringProperty(ID)");
                return;
            }
            OpenSPCoopState stato = null;
            try {
                if (consegnaContenutiApplicativiMsg.getOpenspcoopstate() != null) {
                    stato = consegnaContenutiApplicativiMsg.getOpenspcoopstate();
                    if (stato.getStatoRichiesta() == null && consegnaContenutiApplicativiMsg.getBusta() != null) {
                        StatelessMessage statoRichiesta = new StatelessMessage();
                        statoRichiesta.setBusta(consegnaContenutiApplicativiMsg.getBusta());
                        stato.setStatoRichiesta((IState)statoRichiesta);
                    }
                    ((OpenSPCoopStateless)stato).setUseConnection(true);
                    ((OpenSPCoopStateless)stato).setMessageLib(consegnaContenutiApplicativiMsg);
                    ((OpenSPCoopStateless)stato).setIDMessaggioSessione(idMessaggioConsegna);
                } else {
                    stato = new OpenSPCoopStateful();
                    ((OpenSPCoopStateful)stato).setIDMessaggioSessione(idMessaggioConsegna);
                    ((OpenSPCoopStateful)stato).setMessageLib(consegnaContenutiApplicativiMsg);
                }
            }
            catch (Exception e) {
                this.log.error((Object)"[ConsegnaContenutiApplicativi] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            msgDiag.updateState(stato.getStatoRichiesta(), stato.getStatoRisposta());
            PdDContext pddContext = consegnaContenutiApplicativiMsg.getPddContext();
            try {
                msgDiag.setPddContext(pddContext, ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)pddContext.getObject("PROTOCOLLO")));
            }
            catch (ProtocolException e) {
                msgDiag.logErroreGenerico((Exception)((Object)e), "ProtocolFactory.instanziazione");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            RichiestaApplicativa richiestaApplicativa = consegnaContenutiApplicativiMsg.getRichiestaApplicativa();
            RichiestaDelegata richiestaDelegata = consegnaContenutiApplicativiMsg.getRichiestaDelegata();
            String servizioApplicativo = null;
            servizioApplicativo = richiestaApplicativa != null ? richiestaApplicativa.getServizioApplicativo() : richiestaDelegata.getServizioApplicativo();
            msgDiag.mediumDebug("Transaction Manager...");
            try {
                if (!TransactionManager.validityCheck(msgDiag, "ConsegnaContenutiApplicativi", idMessaggioConsegna, "INBOX", received.getJMSMessageID(), pddContext, servizioApplicativo)) {
                    msgDiag.addKeyword("@ID_MESSAGGIO_TRANSACTION_MANAGER@", idMessaggioConsegna);
                    msgDiag.addKeyword("@PROPRIETARIO_MESSAGGIO@", "ConsegnaContenutiApplicativi");
                    msgDiag.logPersonalizzato("all.", "transactionManager.validityCheckError");
                    return;
                }
            }
            catch (Exception e) {
                msgDiag.logErroreGenerico(e, "TransactionManager.validityCheck");
                this.ctxMDB.setRollbackOnly();
                return;
            }
            EsitoLib esito = null;
            try {
                esito = lib.onMessage(stato);
            }
            catch (Exception e) {
                this.log.error((Object)"[ConsegnaContenutiApplicativi] Invocazione della libreria non riuscita (verr\u00e0 effettuato un rollback sulla coda JMS)", (Throwable)e);
                this.ctxMDB.setRollbackOnly();
                return;
            }
            if (!esito.isEsitoInvocazione()) {
                this.log.info((Object)"[ConsegnaContenutiApplicativi] Invocazione della libreria terminata con esito negativo, verr\u00e0 effettuato un rollback sulla coda JMS");
                this.ctxMDB.setRollbackOnly();
            } else {
                this.log.debug((Object)"[ConsegnaContenutiApplicativi] Invocazione della libreria terminata correttamente");
            }
        }
    }
}

