/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openspcoop2.core.config.MessaggiDiagnostici;
import org.openspcoop2.core.config.Tracciamento;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.IPdDContextSerializer;
import org.openspcoop2.pdd.logger.LogLevels;
import org.openspcoop2.protocol.engine.builder.DateBuilder;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.diagnostica.IMsgDiagnosticoOpenSPCoopAppender;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.dump.IDumpOpenSPCoopAppender;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciamentoOpenSPCoopAppender;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.resources.PropertiesUtilities;

public class OpenSPCoop2Logger {
    protected static Logger loggerTracciamento = null;
    protected static boolean loggerTracciamentoAbilitato = false;
    protected static Logger loggerMsgDiagnostico = null;
    protected static boolean loggerMsgDiagnosticoAbilitato = false;
    protected static Logger loggerOpenSPCoop2 = null;
    protected static boolean loggerMsgDiagnosticoReadableAbilitato = false;
    protected static Logger loggerIntegrationManager = null;
    protected static boolean loggerIntegrationManagerAbilitato = false;
    protected static Logger loggerDump = null;
    protected static boolean loggerDumpAbilitato = false;
    protected static Logger loggerOpenSPCoopConsole = Logger.getLogger((String)"openspcoop2.startup");
    protected static boolean loggerOpenSPCoopConsoleStartupAgganciatoLog = false;
    protected static Logger loggerOpenSPCoopCore = null;
    protected static Logger loggerOpenSPCoopTimers = null;
    protected static Logger loggerOpenSPCoopResources = null;
    protected static Logger loggerOpenSPCoopConfigurazioneSistema = null;
    protected static Vector<IMsgDiagnosticoOpenSPCoopAppender> loggerMsgDiagnosticoOpenSPCoopAppender = new Vector();
    protected static Vector<String> tipoMsgDiagnosticoOpenSPCoopAppender = new Vector();
    protected static Vector<ITracciamentoOpenSPCoopAppender> loggerTracciamentoOpenSPCoopAppender = new Vector();
    protected static Vector<String> tipoTracciamentoOpenSPCoopAppender = new Vector();
    protected static Vector<IDumpOpenSPCoopAppender> loggerDumpOpenSPCoopAppender = new Vector();
    protected static Vector<String> tipoDumpOpenSPCoopAppender = new Vector();
    private static IPdDContextSerializer pddContextSerializer = null;

    public static boolean isLoggerOpenSPCoopConsoleStartupAgganciatoLog() {
        return loggerOpenSPCoopConsoleStartupAgganciatoLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initializeLogConsole(Logger logConsole) {
        InputStream isOp2 = null;
        InputStream isLogger = null;
        try {
            Properties loggerPropertiesRidefinito;
            isOp2 = OpenSPCoop2Logger.class.getResourceAsStream("/openspcoop2.properties");
            String confDir = null;
            if (isOp2 != null) {
                Properties op2Properties = new Properties();
                op2Properties.load(isOp2);
                confDir = op2Properties.getProperty("org.openspcoop2.pdd.confDirectory");
            }
            Properties loggerProperties = new Properties();
            isLogger = OpenSPCoop2Logger.class.getResourceAsStream("/logger.log4j.properties");
            if (isLogger != null) {
                loggerProperties.load(isLogger);
            }
            if ((loggerPropertiesRidefinito = PropertiesUtilities.searchLocalImplementation((String)"OPENSPCOOP2_HOME", (Logger)Logger.getLogger(OpenSPCoop2Logger.class), (String)"OPENSPCOOP2_LOGGER_PROPERTIES", (String)"logger_local.properties", (String)confDir)) != null && loggerPropertiesRidefinito.size() > 0) {
                Enumeration<Object> ridefinito = loggerPropertiesRidefinito.keys();
                while (ridefinito.hasMoreElements()) {
                    String key = (String)ridefinito.nextElement();
                    String value = (String)loggerPropertiesRidefinito.get(key);
                    if (loggerProperties.containsKey(key)) {
                        loggerProperties.remove(key);
                    }
                    loggerProperties.put(key, value);
                }
            }
            PropertyConfigurator.configure((Properties)loggerProperties);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            loggerOpenSPCoopConsole.error((Object)("Riscontrato errore durante l'inizializzazione del sistema di logging di OpenSPCoop: " + e.getMessage()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (isOp2 != null) {
                    isOp2.close();
                }
            }
            catch (Exception eClose) {}
            try {
                if (isLogger != null) {
                    isLogger.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initialize(Logger logConsole, String rootDirectory, Properties objectProperties) {
        try {
            String value;
            String key;
            Enumeration<Object> ridefinito;
            Properties loggerProperties = new Properties();
            File loggerFile = new File(rootDirectory + "logger.log4j.properties");
            if (!loggerFile.exists()) {
                loggerProperties.load(OpenSPCoop2Logger.class.getResourceAsStream("/logger.log4j.properties"));
            } else {
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(loggerFile);
                    loggerProperties.load(fin);
                }
                finally {
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (Exception eClose) {}
                }
            }
            Properties loggerPropertiesRidefinito = PropertiesUtilities.searchLocalImplementation((String)"OPENSPCOOP2_HOME", (Logger)logConsole, (String)"OPENSPCOOP2_LOGGER_PROPERTIES", (String)"logger_local.properties", (String)rootDirectory);
            if (loggerPropertiesRidefinito != null && loggerPropertiesRidefinito.size() > 0) {
                ridefinito = loggerPropertiesRidefinito.keys();
                while (ridefinito.hasMoreElements()) {
                    key = (String)ridefinito.nextElement();
                    value = (String)loggerPropertiesRidefinito.get(key);
                    if (loggerProperties.containsKey(key)) {
                        loggerProperties.remove(key);
                    }
                    loggerProperties.put(key, value);
                }
            }
            if (objectProperties != null && objectProperties.size() > 0) {
                ridefinito = objectProperties.keys();
                while (ridefinito.hasMoreElements()) {
                    key = (String)ridefinito.nextElement();
                    value = (String)objectProperties.get(key);
                    if (loggerProperties.containsKey(key)) {
                        loggerProperties.remove(key);
                    }
                    loggerProperties.put(key, value);
                }
            }
            PropertyConfigurator.configure((Properties)loggerProperties);
            String tmp = loggerProperties.getProperty("log4j.category.openspcoop2.startup");
            if (tmp != null && !tmp.startsWith("OFF")) {
                loggerOpenSPCoopConsoleStartupAgganciatoLog = true;
            }
            if ((loggerTracciamento = Logger.getLogger((String)"openspcoop2.tracciamento")) == null) {
                throw new Exception("Logger openspcoop2.tracciamento non trovato");
            }
            tmp = loggerProperties.getProperty("log4j.category.openspcoop2.tracciamento");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging delle tracce disabilitato da log4j (OFF).");
                    loggerTracciamentoAbilitato = false;
                } else {
                    loggerTracciamentoAbilitato = true;
                }
            }
            if ((loggerMsgDiagnostico = Logger.getLogger((String)"openspcoop2.msgDiagnostico")) == null) {
                throw new Exception("Logger openspcoop2.msgDiagnostico non trovato");
            }
            tmp = loggerProperties.getProperty("log4j.category.openspcoop2.msgDiagnostico");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging dei messaggi diagnostici disabilitato da log4j (OFF).");
                    loggerMsgDiagnosticoAbilitato = false;
                } else {
                    loggerMsgDiagnosticoAbilitato = true;
                }
            }
            if ((loggerOpenSPCoop2 = Logger.getLogger((String)"openspcoop2.portaDiDominio")) == null) {
                throw new Exception("Logger openspcoop2.portaDiDominio non trovato");
            }
            tmp = loggerProperties.getProperty("log4j.category.openspcoop2.portaDiDominio");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging dei messaggi diagnostici 'readable' disabilitato da log4j (OFF).");
                    loggerMsgDiagnosticoReadableAbilitato = false;
                } else {
                    loggerMsgDiagnosticoReadableAbilitato = true;
                }
            }
            if ((loggerIntegrationManager = Logger.getLogger((String)"openspcoop2.integrationManager")) == null) {
                throw new Exception("Logger openspcoop2.integrationManager non trovato");
            }
            tmp = loggerProperties.getProperty("log4j.category.openspcoop2.integrationManager");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging dei messaggi diagnostici 'readable' per il servizio di IntegrationManager disabilitato da log4j (OFF).");
                    loggerIntegrationManagerAbilitato = false;
                } else {
                    loggerIntegrationManagerAbilitato = true;
                }
            }
            if ((loggerDump = Logger.getLogger((String)"openspcoop2.dump")) == null) {
                throw new Exception("Logger openspcoop2.dump non trovato");
            }
            tmp = loggerProperties.getProperty("log4j.category.openspcoop2.dump");
            if (tmp != null) {
                tmp.trim();
                if (tmp.startsWith("OFF")) {
                    loggerOpenSPCoopConsole.info((Object)"Sistema di logging dei contenuti applicativi (dump) disabilitato da log4j (OFF).");
                    loggerDumpAbilitato = false;
                } else {
                    loggerDumpAbilitato = true;
                }
            }
            if ((loggerOpenSPCoopCore = Logger.getLogger((String)"openspcoop2.core")) == null) {
                throw new Exception("Logger openspcoop2.core non trovato");
            }
            loggerOpenSPCoopTimers = Logger.getLogger((String)"openspcoop2.timers");
            if (loggerOpenSPCoopTimers == null) {
                throw new Exception("Logger openspcoop2.timers non trovato");
            }
            loggerOpenSPCoopResources = Logger.getLogger((String)"openspcoop2.resources");
            if (loggerOpenSPCoopResources == null) {
                throw new Exception("Logger openspcoop2.resources non trovato");
            }
            loggerOpenSPCoopConfigurazioneSistema = Logger.getLogger((String)"openspcoop2.configurazioneSistema");
            if (loggerOpenSPCoopConfigurazioneSistema == null) {
                throw new Exception("Logger openspcoop2.configurazioneSistema non trovato");
            }
            loggerOpenSPCoopConsole.info((Object)"Sistema di logging correttamente inizializzato.");
            OpenSPCoop2Properties propertiesReader = OpenSPCoop2Properties.getInstance();
            String pddContextSerializerClass = propertiesReader.getPddContextSerializer();
            if (pddContextSerializerClass != null && !"none".equals(pddContextSerializerClass)) {
                try {
                    pddContextSerializer = (IPdDContextSerializer)Loader.getInstance().newInstance(pddContextSerializerClass);
                }
                catch (Exception e) {
                    throw new Exception("Inizializzione IPdDContextSerializer non riuscita [" + pddContextSerializerClass + "]:" + e.getMessage(), e);
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerOpenSPCoopConsole.error((Object)("Riscontrato errore durante l'inizializzazione del sistema di logging di OpenSPCoop: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static boolean initializeMsgDiagnosticiOpenSPCoopAppender(MessaggiDiagnostici msgDiagConfig) {
        try {
            if (msgDiagConfig != null) {
                ClassNameProperties prop = ClassNameProperties.getInstance();
                for (int i = 0; i < msgDiagConfig.sizeOpenspcoopAppenderList(); ++i) {
                    String msgDiagAppenderClass = prop.getMsgDiagnosticoOpenSPCoopAppender(msgDiagConfig.getOpenspcoopAppender(i).getTipo());
                    if (msgDiagAppenderClass == null) {
                        throw new Exception("Riscontrato errore durante il caricamento del msg diagnostico appender [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "]: appender non registrato.");
                    }
                    IMsgDiagnosticoOpenSPCoopAppender appender = null;
                    try {
                        appender = (IMsgDiagnosticoOpenSPCoopAppender)Loader.getInstance().newInstance(msgDiagAppenderClass);
                        appender.initializeAppender(msgDiagConfig.getOpenspcoopAppender(i));
                    }
                    catch (ClassNotFoundException e) {
                        throw new Exception("Riscontrato errore durante il caricamento del msg diagnostico appender specificato [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante l'inizializzazione del msg diagnostico appender specificato [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    loggerMsgDiagnosticoOpenSPCoopAppender.add(appender);
                    tipoMsgDiagnosticoOpenSPCoopAppender.add(msgDiagConfig.getOpenspcoopAppender(i).getTipo());
                    loggerOpenSPCoopConsole.info((Object)("Sistema di logging: MsgDiagnosticoOpenSPCoopAppender di tipo [" + msgDiagConfig.getOpenspcoopAppender(i).getTipo() + "] correttamente inizializzato."));
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerMsgDiagnosticoOpenSPCoopAppender.clear();
            loggerOpenSPCoopConsole.error((Object)("Riscontrato errore durante l'inizializzazione degli appender personalizzati per msg diagnostici: " + e.getMessage()));
            return false;
        }
    }

    public static boolean initializeTracciamentoOpenSPCoopAppender(Tracciamento tracciamentoConfig) {
        try {
            if (tracciamentoConfig != null) {
                ClassNameProperties prop = ClassNameProperties.getInstance();
                for (int i = 0; i < tracciamentoConfig.sizeOpenspcoopAppenderList(); ++i) {
                    String tracciamentoAppenderClass = prop.getTracciamentoOpenSPCoopAppender(tracciamentoConfig.getOpenspcoopAppender(i).getTipo());
                    if (tracciamentoAppenderClass == null) {
                        throw new Exception("Riscontrato errore durante il caricamento del tracciamento appender [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: appender non registrato.");
                    }
                    ITracciamentoOpenSPCoopAppender appender = null;
                    try {
                        Object o = Loader.getInstance().newInstance(tracciamentoAppenderClass);
                        if (o instanceof ITracciamentoOpenSPCoopAppender) {
                            appender = (ITracciamentoOpenSPCoopAppender)o;
                            appender.initializeAppender(tracciamentoConfig.getOpenspcoopAppender(i));
                        } else if (!(o instanceof IDumpOpenSPCoopAppender)) {
                            throw new Exception("OpenSPCoop Appender non \u00e8 compatibile ne per registrare le tracce, ne per registrare i contenuti applicativi");
                        }
                        if (appender == null) continue;
                        loggerTracciamentoOpenSPCoopAppender.add(appender);
                        tipoTracciamentoOpenSPCoopAppender.add(tracciamentoConfig.getOpenspcoopAppender(i).getTipo());
                        loggerOpenSPCoopConsole.info((Object)("Sistema di logging: TracciamentoOpenSPCoopAppender di tipo [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new Exception("Riscontrato errore durante il caricamento del tracciamento appender specificato [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante l'inizializzazione del tracciamento appender specificato [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerTracciamentoOpenSPCoopAppender.clear();
            loggerOpenSPCoopConsole.error((Object)("Riscontrato errore durante l'inizializzazione degli appender personalizzati per il tracciamento: " + e.getMessage()));
            return false;
        }
    }

    public static boolean initializeDumpOpenSPCoopAppender(Tracciamento tracciamentoConfig) {
        try {
            if (tracciamentoConfig != null) {
                ClassNameProperties prop = ClassNameProperties.getInstance();
                for (int i = 0; i < tracciamentoConfig.sizeOpenspcoopAppenderList(); ++i) {
                    String dumpAppenderClass = prop.getTracciamentoOpenSPCoopAppender(tracciamentoConfig.getOpenspcoopAppender(i).getTipo());
                    if (dumpAppenderClass == null) {
                        throw new Exception("Riscontrato errore durante il caricamento del tracciamento appender [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: appender non registrato.");
                    }
                    IDumpOpenSPCoopAppender appender = null;
                    try {
                        Object o = Loader.getInstance().newInstance(dumpAppenderClass);
                        if (o instanceof IDumpOpenSPCoopAppender) {
                            appender = (IDumpOpenSPCoopAppender)o;
                            appender.initializeAppender(tracciamentoConfig.getOpenspcoopAppender(i));
                        } else if (!(o instanceof ITracciamentoOpenSPCoopAppender)) {
                            throw new Exception("OpenSPCoop Appender non \u00e8 compatibile ne per registrare le tracce, ne per registrare i contenuti applicativi");
                        }
                        if (appender == null) continue;
                        loggerDumpOpenSPCoopAppender.add(appender);
                        tipoDumpOpenSPCoopAppender.add(tracciamentoConfig.getOpenspcoopAppender(i).getTipo());
                        loggerOpenSPCoopConsole.info((Object)("Sistema di logging: DumpOpenSPCoopAppender di tipo [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new Exception("Riscontrato errore durante il caricamento del dump appender specificato [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw new Exception("Riscontrato errore durante l'inizializzazione del dump appender specificato [" + tracciamentoConfig.getOpenspcoopAppender(i).getTipo() + "]: " + e.getMessage());
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            loggerDumpOpenSPCoopAppender.clear();
            loggerOpenSPCoopConsole.error((Object)("Riscontrato errore durante l'inizializzazione degli appender personalizzati per il dump applicativo: " + e.getMessage()));
            return false;
        }
    }

    public static String humanReadable(MsgDiagnostico msgDiag, String protocol) {
        return OpenSPCoop2Logger.humanReadable(msgDiag, null, null, null, false, null, null, null, protocol);
    }

    public static String humanReadable(MsgDiagnostico msgDiag, IProtocolFactory protocolFactory) {
        return OpenSPCoop2Logger.humanReadable(msgDiag, null, null, null, false, null, null, null, protocolFactory.getProtocol());
    }

    public static String humanReadable(MsgDiagnostico msgDiag, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String porta, boolean delegata, IDSoggetto fruitore, IDServizio servizio, String servizioApplicativo, IProtocolFactory protocolFactory) {
        return OpenSPCoop2Logger.humanReadable(msgDiag, idCorrelazioneApplicativa, idCorrelazioneApplicativaRisposta, porta, delegata, fruitore, servizio, servizioApplicativo, protocolFactory.getProtocol());
    }

    public static String humanReadable(MsgDiagnostico msgDiag, String idCorrelazioneApplicativa, String idCorrelazioneApplicativaRisposta, String porta, boolean delegata, IDSoggetto fruitore, IDServizio servizio, String servizioApplicativo, String protocol) {
        Hashtable<String, String> contextSerializerParameters;
        Date gdo = msgDiag.getGdo();
        String idPorta = msgDiag.getIdSoggetto().getCodicePorta() + "." + msgDiag.getIdSoggetto().toString();
        String idFunzione = msgDiag.getIdFunzione();
        int valueLivello = msgDiag.getSeverita();
        String text = msgDiag.getMessaggio();
        String idBusta = msgDiag.getIdBusta();
        String codiceDiagnostico = msgDiag.getCodice();
        StringBuffer showMsg = new StringBuffer();
        if (protocol != null) {
            showMsg.append("<").append(protocol).append(">");
        }
        if (pddContextSerializer != null && (contextSerializerParameters = pddContextSerializer.getLoggerKeywords()) != null && contextSerializerParameters.size() > 0) {
            Enumeration<String> keywordContext = contextSerializerParameters.keys();
            while (keywordContext.hasMoreElements()) {
                String keyword = keywordContext.nextElement();
                if (msgDiag.getPropertiesNames() == null) continue;
                String[] propertyNames = msgDiag.getPropertiesNames();
                for (int i = 0; i < propertyNames.length; ++i) {
                    if (!keyword.equals(propertyNames[i])) continue;
                    if (showMsg.length() > 0) {
                        showMsg.append(" ");
                    }
                    showMsg.append(propertyNames[i] + ":");
                    showMsg.append(msgDiag.getProperty(propertyNames[i]));
                }
            }
        }
        if (codiceDiagnostico != null) {
            if (showMsg.length() > 0) {
                showMsg.append(" ");
            }
            showMsg.append(codiceDiagnostico);
            showMsg.append(" ");
        }
        showMsg.append(idPorta);
        showMsg.append(" ");
        showMsg.append(idFunzione);
        showMsg.append(" <");
        showMsg.append(DateBuilder.getDate_Format((Date)gdo));
        showMsg.append("> ");
        showMsg.append("(");
        showMsg.append(LogLevels.toLog4J(valueLivello).toString());
        showMsg.append(")");
        if (idBusta != null) {
            showMsg.append(" ID:");
            showMsg.append(idBusta);
        }
        if (idCorrelazioneApplicativa != null) {
            showMsg.append(" IDApplicativo:");
            showMsg.append(idCorrelazioneApplicativa);
        }
        if (idCorrelazioneApplicativaRisposta != null) {
            showMsg.append(" IDApplicativoRisposta:");
            showMsg.append(idCorrelazioneApplicativaRisposta);
        }
        if (delegata) {
            if (porta != null) {
                showMsg.append(" PD:" + porta);
            } else {
                showMsg.append(" PA:" + porta);
            }
        }
        if (servizioApplicativo != null) {
            showMsg.append(" SA:" + servizioApplicativo);
        }
        if (fruitore != null) {
            showMsg.append(" FR:");
            showMsg.append(fruitore.toString());
        }
        if (fruitore != null && servizio != null) {
            showMsg.append(" -> ");
        }
        if (servizio != null) {
            if (servizio.getSoggettoErogatore() != null) {
                showMsg.append(" ER:");
                showMsg.append(servizio.getSoggettoErogatore().toString());
            }
            if (servizio.getServizio() != null && servizio.getTipoServizio() != null) {
                if (servizio.getVersioneServizio() != null) {
                    showMsg.append(" S(v" + servizio.getVersioneServizio() + "):");
                } else {
                    showMsg.append(" S:");
                }
                showMsg.append(servizio.getTipoServizio());
                showMsg.append("/");
                showMsg.append(servizio.getServizio());
            }
            if (servizio.getAzione() != null) {
                showMsg.append(" A:");
                showMsg.append(servizio.getAzione());
            }
        }
        showMsg.append("\n");
        showMsg.append(text);
        showMsg.append("\n");
        return showMsg.toString();
    }

    public static Logger getLoggerOpenSPCoopConsole() {
        return loggerOpenSPCoopConsole;
    }

    public static Logger getLoggerOpenSPCoopCore() {
        return loggerOpenSPCoopCore;
    }

    public static Logger getLoggerOpenSPCoopTimers() {
        return loggerOpenSPCoopTimers;
    }

    public static Logger getLoggerOpenSPCoopResources() {
        return loggerOpenSPCoopResources;
    }

    public static Logger getLoggerOpenSPCoopConfigurazioneSistema() {
        return loggerOpenSPCoopConfigurazioneSistema;
    }

    public static Vector<IMsgDiagnosticoOpenSPCoopAppender> getLoggerMsgDiagnosticoOpenSPCoopAppender() {
        return loggerMsgDiagnosticoOpenSPCoopAppender;
    }

    public static Vector<String> getTipoMsgDiagnosticoOpenSPCoopAppender() {
        return tipoMsgDiagnosticoOpenSPCoopAppender;
    }

    public static Vector<ITracciamentoOpenSPCoopAppender> getLoggerTracciamentoOpenSPCoopAppender() {
        return loggerTracciamentoOpenSPCoopAppender;
    }

    public static Vector<String> getTipoTracciamentoOpenSPCoopAppender() {
        return tipoTracciamentoOpenSPCoopAppender;
    }
}

