/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.diagnostica.IMsgDiagnosticoOpenSPCoopAppender;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnosticoCorrelazione;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnosticoCorrelazioneApplicativa;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnosticoCorrelazioneServizioApplicativo;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnosticoException;
import org.openspcoop2.utils.resources.MapReader;

public class MsgDiagnosticoOpenSPCoopProtocolAppender
implements IMsgDiagnosticoOpenSPCoopAppender {
    private static Hashtable<String, IMsgDiagnosticoOpenSPCoopAppender> mappingProtocolToAppenders = new Hashtable();

    private static synchronized void initProtocolAppender(String protocol, OpenspcoopAppender appenderProperties) throws ProtocolException {
        if (!mappingProtocolToAppenders.containsKey(protocol)) {
            IProtocolFactory p = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
            IMsgDiagnosticoOpenSPCoopAppender msgDiag = p.createMsgDiagnosticoOpenSPCoopAppender();
            if (msgDiag == null) {
                throw new ProtocolException("IMsgDiagnosticoOpenSPCoopAppender not defined for protocol [" + protocol + "]");
            }
            try {
                msgDiag.initializeAppender(appenderProperties);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            mappingProtocolToAppenders.put(protocol, msgDiag);
        }
    }

    private static IMsgDiagnosticoOpenSPCoopAppender getProtocolAppender(String protocol) throws ProtocolException {
        if (!mappingProtocolToAppenders.containsKey(protocol)) {
            throw new ProtocolException("ProtocolAppender per protocollo[" + protocol + "] non inizializzato");
        }
        return mappingProtocolToAppenders.get(protocol);
    }

    public void initializeAppender(OpenspcoopAppender appenderProperties) throws MsgDiagnosticoException {
        try {
            MapReader table = ProtocolFactoryManager.getInstance().getProtocolFactories();
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                String protocol = (String)keys.nextElement();
                MsgDiagnosticoOpenSPCoopProtocolAppender.initProtocolAppender(protocol, appenderProperties);
            }
        }
        catch (Exception e) {
            throw new MsgDiagnosticoException(e.getMessage(), (Throwable)e);
        }
    }

    public void log(Connection conOpenSPCoopPdD, MsgDiagnostico msgDiagnostico) throws MsgDiagnosticoException {
        try {
            if (msgDiagnostico.getProtocollo() != null) {
                MsgDiagnosticoOpenSPCoopProtocolAppender.getProtocolAppender(msgDiagnostico.getProtocollo()).log(conOpenSPCoopPdD, msgDiagnostico);
            }
        }
        catch (Exception e) {
            throw new MsgDiagnosticoException(e.getMessage(), (Throwable)e);
        }
    }

    public void logCorrelazione(Connection conOpenSPCoopPdD, MsgDiagnosticoCorrelazione msgDiagCorrelazione) throws MsgDiagnosticoException {
        try {
            if (msgDiagCorrelazione.getProtocollo() != null) {
                MsgDiagnosticoOpenSPCoopProtocolAppender.getProtocolAppender(msgDiagCorrelazione.getProtocollo()).logCorrelazione(conOpenSPCoopPdD, msgDiagCorrelazione);
            }
        }
        catch (Exception e) {
            throw new MsgDiagnosticoException(e.getMessage(), (Throwable)e);
        }
    }

    public void logCorrelazioneServizioApplicativo(Connection conOpenSPCoopPdD, MsgDiagnosticoCorrelazioneServizioApplicativo msgDiagCorrelazioneSA) throws MsgDiagnosticoException {
        try {
            if (msgDiagCorrelazioneSA.getProtocollo() != null) {
                MsgDiagnosticoOpenSPCoopProtocolAppender.getProtocolAppender(msgDiagCorrelazioneSA.getProtocollo()).logCorrelazioneServizioApplicativo(conOpenSPCoopPdD, msgDiagCorrelazioneSA);
            }
        }
        catch (Exception e) {
            throw new MsgDiagnosticoException(e.getMessage(), (Throwable)e);
        }
    }

    public void logCorrelazioneApplicativaRisposta(Connection conOpenSPCoopPdD, MsgDiagnosticoCorrelazioneApplicativa msgDiagCorrelazioneApplicativa) throws MsgDiagnosticoException {
        try {
            if (msgDiagCorrelazioneApplicativa.getProtocollo() != null) {
                MsgDiagnosticoOpenSPCoopProtocolAppender.getProtocolAppender(msgDiagCorrelazioneApplicativa.getProtocollo()).logCorrelazioneApplicativaRisposta(conOpenSPCoopPdD, msgDiagCorrelazioneApplicativa);
            }
        }
        catch (Exception e) {
            throw new MsgDiagnosticoException(e.getMessage(), (Throwable)e);
        }
    }

    public void isAlive() throws CoreException {
        try {
            Enumeration protocols = ProtocolFactoryManager.getInstance().getProtocolNames();
            while (protocols.hasMoreElements()) {
                String protocol = (String)protocols.nextElement();
                MsgDiagnosticoOpenSPCoopProtocolAppender.getProtocolAppender(protocol).isAlive();
            }
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    public IProtocolFactory getProtocolFactory() {
        return null;
    }
}

