/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.logger;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.MsgDiagnosticiInstanceProperties;
import org.openspcoop2.pdd.logger.LogLevels;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.PropertiesReader;

public class MsgDiagnosticiProperties {
    private Logger log = OpenSPCoop2Startup.initialize ? OpenSPCoop2Logger.getLoggerOpenSPCoopCore() : Logger.getLogger(MsgDiagnosticiProperties.class);
    private MsgDiagnosticiInstanceProperties reader;
    private static MsgDiagnosticiProperties msgDiagnosticiProperties = null;
    private static Integer filtroMsgDiagnostico_OpenSPCoop2_0 = null;
    private static Integer filtroMsgDiagnostico_OpenSPCoop2_1 = null;
    private static Integer filtroMsgDiagnostico_OpenSPCoop2_2 = null;
    private static Integer filtroMsgDiagnostico_OpenSPCoop2_3 = null;
    private static Integer filtroMsgDiagnostico_OpenSPCoop2_4 = null;
    private static Integer filtroMsgDiagnostico_OpenSPCoop2_5 = null;
    private static Integer filtroMsgDiagnostico_OpenSPCoop2_6 = null;
    private static Integer filtroMsgDiagnostico_OpenSPCoop2_7 = null;
    private static PropertiesReader livelliMsgDiagnosticiPersonalizzati = null;
    private static PropertiesReader codiciMsgDiagnosticiPersonalizzati = null;
    private static PropertiesReader messaggiMsgDiagnosticiPersonalizzati = null;
    private static PropertiesReader codiciIdentificativiFunzione = null;
    private static PropertiesReader mappingCodiceToKeywordMsgDiagnosticiPersonalizzati = null;
    public static final String MSG_DIAG_RICEZIONE_CONTENUTI_APPLICATIVI = "ricezioneContenutiApplicativi.";
    public static final String MSG_DIAG_IMBUSTAMENTO = "imbustamentoBusta.";
    public static final String MSG_DIAG_IMBUSTAMENTO_RISPOSTE = "imbustamentoRispostaBusta.";
    public static final String MSG_DIAG_INOLTRO_BUSTE = "inoltroBuste.";
    public static final String MSG_DIAG_RICEZIONE_BUSTE = "ricezioneBuste.";
    public static final String MSG_DIAG_SBUSTAMENTO = "sbustamentoBusta.";
    public static final String MSG_DIAG_SBUSTAMENTO_RISPOSTE = "sbustamentoRispostaBusta.";
    public static final String MSG_DIAG_CONSEGNA_CONTENUTI_APPLICATIVI = "consegnaContenutiApplicativi.";
    public static final String MSG_DIAG_INTEGRATION_MANAGER = "integrationManager.";
    public static final String MSG_DIAG_TRACCIAMENTO = "tracciamento.";
    public static final String MSG_DIAG_TIMER_GESTORE_RISCONTRI_RICEVUTE = "timerGestoreRiscontriRicevute.";
    public static final String MSG_DIAG_TIMER_GESTORE_MESSAGGI = "timerGestoreMessaggi.";
    public static final String MSG_DIAG_TIMER_GESTORE_MESSAGGI_INCONSISTENTI = "timerGestoreMessaggiInconsistenti.";
    public static final String MSG_DIAG_TIMER_GESTORE_REPOSITORY_BUSTE = "timerGestoreRepositoryBuste.";
    public static final String MSG_DIAG_TIMER_MONITORAGGIO_RISORSE = "timerMonitoraggioRisorse.";
    public static final String MSG_DIAG_TIMER_THRESHOLD = "timerThreshold.";
    public static final String MSG_DIAG_TIMER_CONSEGNA_CONTENUTI_APPLICATIVI = "timerConsegnaContenutiApplicativi.";
    public static final String MSG_DIAG_OPENSPCOOP_STARTUP = "openspcoopStartup.";
    public static final String MSG_DIAG_ALL = "all.";
    private static final String[] MSG_DIAGNOSTICI_PERSONALIZZATI = new String[]{"ricezioneContenutiApplicativi.correlazioneApplicativaEsistente", "ricezioneContenutiApplicativi.correlazioneApplicativaInstaurata", "ricezioneContenutiApplicativi.ricevutaRichiestaApplicativa", "ricezioneContenutiApplicativi.consegnaRispostaApplicativa", "ricezioneContenutiApplicativi.consegnaRispostaApplicativaOkEffettuata", "ricezioneContenutiApplicativi.consegnaRispostaApplicativaKoEffettuata", "ricezioneContenutiApplicativi.consegnaRispostaApplicativaVuota", "ricezioneContenutiApplicativi.consegnaRispostaApplicativaFallita", "ricezioneContenutiApplicativi.timeoutRicezioneRisposta", "ricezioneContenutiApplicativi.richiestaContenenteBusta", "ricezioneContenutiApplicativi.portaDelegataNonEsistente", "ricezioneContenutiApplicativi.servizioApplicativoFruitore.identificazioneTramiteInfoIntegrazioneNonRiuscita", "ricezioneContenutiApplicativi.servizioApplicativoFruitore.identificazioneTramiteCredenziali", "ricezioneContenutiApplicativi.identificazioneDinamicaServizioNonRiuscita", "ricezioneContenutiApplicativi.servizioApplicativoFruitore.nonAutorizzato", "ricezioneContenutiApplicativi.servizioApplicativoFruitore.contenuto.nonAutorizzato", "ricezioneContenutiApplicativi.validazioneContenutiApplicativiNonRiuscita", "ricezioneContenutiApplicativi.portaDelegataInvocabilePerRiferimento.riferimentoNonPresente", "ricezioneContenutiApplicativi.portaDelegataInvocabileNormalmente.riferimentoPresente", "ricezioneContenutiApplicativi.funzionalitaScartaBodyNonEffettuabile", "ricezioneContenutiApplicativi.funzionalitaAllegaBodyNonEffettuabile", "ricezioneContenutiApplicativi.headerIntegrazione.letturaFallita", "ricezioneContenutiApplicativi.messaggioInGestione", "ricezioneContenutiApplicativi.messaggioInGestione.marcatoDaEliminare", "ricezioneContenutiApplicativi.mustUnderstand.unknown", "ricezioneContenutiApplicativi.contentType.unsupported", "ricezioneContenutiApplicativi.mustUnderstand.unknown", "ricezioneContenutiApplicativi.contentType.unsupported", "ricezioneContenutiApplicativi.soapEnvelopeNamespace.versionMismatch", "ricezioneContenutiApplicativi.gestoreCredenziali.errore", "ricezioneContenutiApplicativi.gestoreCredenziali.nuoveCredenziali", "ricezioneContenutiApplicativi.contentType.notDefined", "ricezioneContenutiApplicativi.integrationManager.consegnaRispostaApplicativaEffettuata", "ricezioneContenutiApplicativi.integrationManager.consegnaRispostaApplicativaVuota", "ricezioneContenutiApplicativi.integrationManager.consegnaRispostaApplicativaFallita", "ricezioneContenutiApplicativi.localForward.logInfo", "ricezioneContenutiApplicativi.localForward.configError", "ricezioneContenutiApplicativi.protocolli.tipoSoggetto.fruitore.unsupported", "ricezioneContenutiApplicativi.protocolli.tipoSoggetto.erogatore.unsupported", "ricezioneContenutiApplicativi.protocolli.tipoServizio.unsupported", "imbustamentoBusta.registroServizi.ricercaServizioInCorso", "imbustamentoBusta.registroServizi.ricercaServizioEffettuata", "imbustamentoBusta.registroServizi.ricercaServizioFallita", "imbustamentoBusta.consegnaAffidabile.salvataggioInformazioni", "imbustamentoBusta.consegnaAffidabile.profiloNonOneway", "imbustamentoBusta.consegnaInOrdine.profiloNonOneway", "imbustamentoBusta.consegnaInOrdine.confermaRicezioneNonRichiesta", "imbustamentoBusta.consegnaInOrdine.idCollaborazioneNonRichiesto", "imbustamentoBusta.consegnaInOrdine.funzionalitaMancanti", "imbustamentoBusta.profiloAsincronoSimmetrico.saAnonimo", "imbustamentoBusta.profiloAsincronoSimmetrico.saSenzaRispostaAsincrona", "imbustamentoBusta.profiloAsincronoSimmetrico.servizioCorrelatoNonEsistente", "imbustamentoBusta.profiloAsincronoSimmetrico.rispostaNonCorrelataRichiesta", "imbustamentoBusta.profiloAsincronoAsimmetrico.richiestaStatoNonCorrelataRichiesta", "imbustamentoBusta.profiloAsincronoSimmetrico.risposta.correlazioneRichiesta", "imbustamentoBusta.profiloAsincronoAsimmetrico.richiestaStato.correlazioneRichiesta", "imbustamentoBusta.protocolli.funzionalita.unsupported", "inoltroBuste.routingTable.esaminaInCorso", "inoltroBuste.routingTable.esaminaInCorsoFallita", "inoltroBuste.routingTable.esaminaEffettuata", "inoltroBuste.routingTable.utilizzoIndirizzoTelematico", "inoltroBuste.routingTable.soggettoFruitoreNonGestito", "inoltroBuste.inoltroInCorso", "inoltroBuste.inoltroEffettuato", "inoltroBuste.inoltroConErrore", "inoltroBuste.ricezioneMessaggio", "inoltroBuste.ricezioneMessaggioErrore", "inoltroBuste.ricezioneMessaggioErrore.rollback", "inoltroBuste.inoltroBustaScaduta", "inoltroBuste.ricezioneSoapFault", "inoltroBuste.profiloSincrono.rispostaNonPervenuta", "inoltroBuste.validazioneContenutiApplicativiNonRiuscita", "inoltroBuste.ricezioneSoapMessage.headerProtocolloNonPresente", "inoltroBuste.ricezioneSoapMessage.msgGiaPresente", "inoltroBuste.riconsegnaMessaggioPrematura", "inoltroBuste.rispostaRicevuta.messaggio", "inoltroBuste.rispostaRicevuta.messaggioErrore", "inoltroBuste.gestioneConsegnaTerminata", "inoltroBuste.headerIntegrazione.letturaFallita", "inoltroBuste.profiloAsincrono.rispostaNonPervenuta", "ricezioneBuste.ricezioneMessaggio", "ricezioneBuste.ricezioneMessaggioErrore", "ricezioneBuste.autorizzazioneBusteInCorso", "ricezioneBuste.autorizzazioneBusteEffettuata", "ricezioneBuste.autorizzazioneBusteFallita", "ricezioneBuste.generazioneMessaggioRisposta", "ricezioneBuste.generazioneMessaggioErroreRisposta", "ricezioneBuste.generazioneMessaggioErroreRisposta.destinatarioSconosciuto", "ricezioneBuste.generazioneRiscontro", "ricezioneBuste.generazioneRicevutaAsincrona", "ricezioneBuste.consegnaMessaggioOkEffettuata", "ricezioneBuste.consegnaMessaggioKoEffettuata", "ricezioneBuste.consegnaMessaggioNonPresente", "ricezioneBuste.consegnaMessaggioFallita", "ricezioneBuste.timeoutRicezioneRisposta", "ricezioneBuste.messaggioInGestione.marcatoDaEliminare", "ricezioneBuste.messaggioInGestione.gestioneSincrona", "ricezioneBuste.messaggioInGestione.gestioneAsincrona", "ricezioneBuste.messaggioInGestione.attesaFineProcessamento.filtroDuplicatiAbilitato", "ricezioneBuste.messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato", "ricezioneBuste.messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.attesaTerminata", "ricezioneBuste.messaggioInGestione.attesaFineProcessamento.filtroDuplicatiDisabilitato.forzoEliminazione", "ricezioneBuste.messaggioInGestione.attesaFineProcessamento.timeoutScaduto", "ricezioneBuste.attesaFineProcessamento.richiestaAsincrona.timeoutScaduto", "ricezioneBuste.attesaFineProcessamento.ricevutaRichiestaAsincrona.timeoutScaduto", "ricezioneBuste.validazioneContenutiApplicativiNonRiuscita", "ricezioneBuste.headerIntegrazione.letturaFallita", "ricezioneBuste.mustUnderstand.unknown", "ricezioneBuste.contentType.unsupported", "ricezioneBuste.soapEnvelopeNamespace.versionMismatch", "ricezioneBuste.gestoreCredenziali.errore", "ricezioneBuste.gestoreCredenziali.nuoveCredenziali", "ricezioneBuste.contentType.notDefined", "ricezioneBuste.identificazionePAErrore", "ricezioneBuste.protocolli.tipoSoggetto.fruitore.unsupported", "ricezioneBuste.protocolli.tipoSoggetto.erogatore.unsupported", "ricezioneBuste.protocolli.tipoServizio.unsupported", "sbustamentoBusta.ricezioneBustaErrore", "sbustamentoBusta.ricezioneBusta.eccezioniNonGravi", "sbustamentoBusta.validazioneNonRiuscita", "sbustamentoBusta.validazioneBustaErrore.listaEccezioniMalformata", "sbustamentoBusta.validazioneBusta.bustaNonCorretta", "sbustamentoBusta.validazioneBusta.eccezioniNonGravi", "sbustamentoBusta.validazioneRicevutaAsincrona", "sbustamentoBusta.ricezioneRiscontro", "sbustamentoBusta.ricezioneBustaServizio", "sbustamentoBusta.ricezioneBustaDuplicata", "sbustamentoBusta.ricezioneBustaDuplicata.count", "sbustamentoBusta.ricezioneBusta.registrazionePerFiltroDuplicati", "sbustamentoBusta.funzionalitaRichiestaAccordo.confermaRicezioneNonPresente", "sbustamentoBusta.funzionalitaRichiestaAccordo.consegnaInOrdineNonPresente", "sbustamentoBusta.consegnaInOrdine.profiloDiversoOneway", "sbustamentoBusta.soggettoDestinatarioNonGestito", "sbustamentoBusta.portaApplicativaNonEsistente", "sbustamentoBusta.ricezioneRispostaSincrona", "sbustamentoBusta.profiloAsincrono.flussoRicevutaRichiestaRispostaNonCorretto", "sbustamentoBusta.profiloAsincronoAsimmetrico.saSenzaRispostaAsincrona", "sbustamentoBusta.profiloAsincronoAsimmetrico.servizioCorrelatoNonEsistente", "sbustamentoBusta.ricezioneBustaErroreDetails", "sbustamentoBusta.protocolli.funzionalita.unsupported", "sbustamentoRispostaBusta.ricezioneBustaErrore", "sbustamentoRispostaBusta.ricezioneBusta.eccezioniNonGravi", "sbustamentoRispostaBusta.validazioneBustaErrore.listaEccezioniMalformata", "sbustamentoRispostaBusta.validazioneBusta.eccezioniNonGravi", "sbustamentoRispostaBusta.validazioneBusta.bustaNonCorretta", "sbustamentoRispostaBusta.validazioneRicevutaAsincrona", "sbustamentoRispostaBusta.ricezioneRiscontro", "sbustamentoRispostaBusta.ricezioneBustaServizio", "sbustamentoRispostaBusta.ricezioneBustaDuplicata", "sbustamentoRispostaBusta.ricezioneBustaDuplicata.count", "sbustamentoRispostaBusta.ricezioneBusta.registrazionePerFiltroDuplicati", "sbustamentoRispostaBusta.rispostaOneway", "sbustamentoRispostaBusta.soggettoDestinatarioNonGestito", "sbustamentoRispostaBusta.profiloCollaborazioneRisposta.diversoScenarioGestito", "sbustamentoRispostaBusta.riferimentoMessaggioNonValido", "sbustamentoRispostaBusta.riferimentoMessaggioNonPresente", "sbustamentoRispostaBusta.ricezioneBustaErroreDetails", "sbustamentoRispostaBusta.protocolli.funzionalita.unsupported", "consegnaContenutiApplicativi.integrationManager.messaggioDisponibile", "consegnaContenutiApplicativi.consegnaNonDefinita", "consegnaContenutiApplicativi.trasmissioneSincrona.servizioNonUtilizzabile", "consegnaContenutiApplicativi.gestioneProfiloAsincrono.servizioNonUtilizzabile", "consegnaContenutiApplicativi.servizioApplicativoNonDefinito", "consegnaContenutiApplicativi.gestioneProfiloNonOneway.consegnaVersoNServiziApplicativi", "consegnaContenutiApplicativi.gestioneStateless.consegnaVersoNServiziApplicativi", "consegnaContenutiApplicativi.gestioneStateless.integrationManager", "consegnaContenutiApplicativi.consegnaInOrdine.messaggioFuoriOrdine", "consegnaContenutiApplicativi.consegnaInOrdine.messaggioGiaConsegnato", "consegnaContenutiApplicativi.consegnaInCorso", "consegnaContenutiApplicativi.consegnaEffettuata", "consegnaContenutiApplicativi.consegnaConErrore", "consegnaContenutiApplicativi.ricezioneSoapFault", "consegnaContenutiApplicativi.validazioneContenutiApplicativiNonRiuscita", "consegnaContenutiApplicativi.funzionalitaScartaBodyNonRiuscita", "consegnaContenutiApplicativi.funzionalitaAllegaBodyNonRiuscita", "consegnaContenutiApplicativi.riconsegnaMessaggioPrematura", "consegnaContenutiApplicativi.gestioneConsegnaTerminata", "consegnaContenutiApplicativi.rispostaContenenteBusta", "consegnaContenutiApplicativi.headerIntegrazione.letturaFallita", "consegnaContenutiApplicativi.behaviour.servizioApplicativoNonDefinito", "integrationManager.logInvocazioneOperazione", "integrationManager.autenticazioneNonImpostata", "integrationManager.servizioApplicativo.identificazioneTramiteCredenziali", "integrationManager.servizioApplicativo.nonAutorizzato", "integrationManager.mappingRifMsgToIdBusta.nonRiuscito", "integrationManager.buildMsg.nonRiuscito", "integrationManager.buildMsg.imbustamentoSOAP.nonRiuscito", "integrationManager.invocazionePortaDelegata.contenutoApplicativoNonPresente", "integrationManager.invocazionePortaDelegata.profiloAsincrono.riferimentoMessaggioNonPresente", "integrationManager.invocazionePortaDelegataPerRiferimento.riferimentoMessaggioNonPresente", "integrationManager.messaggiNonPresenti", "integrationManager.messaggioNonTrovato", "integrationManager.gestoreCredenziali.errore", "integrationManager.gestoreCredenziali.nuoveCredenziali", "tracciamento.registrazioneNonRiuscita", "tracciamento.registrazioneNonRiuscita.openspcoopAppender", "tracciamento.dumpContenutiApplicativi.registrazioneNonRiuscita", "tracciamento.dumpContenutiApplicativi.registrazioneNonRiuscita.openspcoopAppender", "tracciamento.errore.bloccoServizi", "tracciamento.dumpContenutiApplicativi.errore.bloccoServizi", "timerGestoreRiscontriRicevute.avvioInCorso", "timerGestoreRiscontriRicevute.avvioEffettuato", "timerGestoreRiscontriRicevute.timerGiaAvviato", "timerGestoreRiscontriRicevute.disabilitato", "timerGestoreRiscontriRicevute.controlloInCorso", "timerGestoreRiscontriRicevute.bustaNonRiscontrata", "timerGestoreRiscontriRicevute.bustaNonRiscontrataScaduta", "timerGestoreRiscontriRicevute.bustaNonRiscontrata.messaggioNonEsistente", "timerGestoreRiscontriRicevute.ricevutaAsincronaNonRicevuta", "timerGestoreRiscontriRicevute.ricevutaAsincronaNonRicevuta.bustaScaduta", "timerGestoreRiscontriRicevute.ricevutaAsincronaNonRicevuta.messaggioNonEsistente", "timerGestoreRiscontriRicevute.precedenteEsecuzioneInCorso", "timerGestoreRiscontriRicevute.precedenteEsecuzioneInCorso.stopTimer", "timerGestoreMessaggi.avvioInCorso", "timerGestoreMessaggi.avvioEffettuato", "timerGestoreMessaggi.timerGiaAvviato", "timerGestoreMessaggi.disabilitato", "timerGestoreMessaggi.controlloInCorso", "timerGestoreMessaggi.ricercaMessaggiDaEliminare", "timerGestoreMessaggi.eliminazioneMessaggio", "timerGestoreMessaggi.eliminazioneDestinatarioMessaggio", "timerGestoreMessaggi.messaggioNonConsumato.codaJMS", "timerGestoreMessaggi.ricercaCorrelazioniApplicativeScadute", "timerGestoreMessaggi.ricercaCorrelazioniApplicativeScaduteRispettoOraRegistrazione", "timerGestoreMessaggi.eliminazioneCorrelazioneApplicativaScaduta", "timerGestoreMessaggi.precedenteEsecuzioneInCorso", "timerGestoreMessaggi.precedenteEsecuzioneInCorso.stopTimer", "timerGestoreMessaggi.connessioneScaduta.EliminazioneInCorso", "timerGestoreMessaggi.connessioneScaduta.EliminazioneEffettuata", "timerGestoreMessaggiInconsistenti.avvioInCorso", "timerGestoreMessaggiInconsistenti.avvioEffettuato", "timerGestoreMessaggiInconsistenti.timerGiaAvviato", "timerGestoreMessaggiInconsistenti.disabilitato", "timerGestoreMessaggiInconsistenti.controlloInCorso", "timerGestoreMessaggiInconsistenti.ricercaMessaggiDaEliminare", "timerGestoreMessaggiInconsistenti.eliminazioneMessaggio", "timerGestoreMessaggiInconsistenti.precedenteEsecuzioneInCorso", "timerGestoreMessaggiInconsistenti.precedenteEsecuzioneInCorso.stopTimer", "timerGestoreRepositoryBuste.avvioInCorso", "timerGestoreRepositoryBuste.avvioEffettuato", "timerGestoreRepositoryBuste.timerGiaAvviato", "timerGestoreRepositoryBuste.disabilitato", "timerGestoreRepositoryBuste.controlloInCorso", "timerGestoreRepositoryBuste.ricercaMessaggiDaEliminare", "timerGestoreRepositoryBuste.eliminazioneMessaggio", "timerGestoreRepositoryBuste.precedenteEsecuzioneInCorso", "timerGestoreRepositoryBuste.precedenteEsecuzioneInCorso.stopTimer", "timerMonitoraggioRisorse.avvioEffettuato", "timerMonitoraggioRisorse.risorsaNonDisponibile", "timerMonitoraggioRisorse.validazioneSemanticaFallita", "timerMonitoraggioRisorse.risorsaRitornataDisponibile", "timerThreshold.avvioEffettuato", "timerThreshold.controlloInCorso", "timerThreshold.risorsaNonDisponibile", "timerThreshold.risorsaRitornataDisponibile", "timerConsegnaContenutiApplicativi.avvioInCorso", "timerConsegnaContenutiApplicativi.avvioEffettuato", "timerConsegnaContenutiApplicativi.timerGiaAvviato", "timerConsegnaContenutiApplicativi.disabilitato", "timerConsegnaContenutiApplicativi.controlloInCorso", "timerConsegnaContenutiApplicativi.ricercaMessaggiDaInoltrare", "timerConsegnaContenutiApplicativi.inoltroMessaggio", "timerConsegnaContenutiApplicativi.precedenteEsecuzioneInCorso", "timerConsegnaContenutiApplicativi.precedenteEsecuzioneInCorso.stopTimer", "openspcoopStartup.pdd", "openspcoopStartup.IntegrationManager", "openspcoopStartup.erroreGenerico", "all.erroreGenerico", "all.erroreGenericoMalfunzionamentoPdD", "all.transactionManager.validityCheckError", "all.connessioneUscita.disconnectError", "all.deleteMessage.acquisizioneLock.inCorso", "all.deleteMessage.acquisizioneLock.wait.withoutOwner", "all.deleteMessage.acquisizioneLock.wait.existsOldOwner", "all.deleteMessage.acquisizioneLock.ok", "all.deleteMessage.acquisizioneUnlock.inCorso", "all.deleteMessage.acquisizioneUnlock.ok", "all.deleteMessage.acquisizioneUnlock.ko"};
    private static final String PREFIX_MSG_DIAGNOSTICO = "org.openspcoop2.pdd.msgdiagnostico.";
    private static final String SUFFIX_LIVELLO_MSG_DIAGNOSTICO = ".livello";
    private static final String SUFFIX_CODICE_MSG_DIAGNOSTICO = ".codice";
    private static final String SUFFIX_MESSAGGIO_MSG_DIAGNOSTICO = ".messaggio";
    private static final String SUFFIX_CODICE_MODULO_MSG_DIAGNOSTICO = ".codiceModulo";
    private static final String PREFIX_UNKNOW_CODE_PREFIX = "org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.";
    private static final String PREFIX_UNKNOW_CODE_SUFFIX = ".codice";
    private static boolean codiceDiagnosticoInitialized = false;
    private static String codiceDiagnosticoFatal = null;
    private static String codiceDiagnosticoErrorProtocol = null;
    private static String codiceDiagnosticoErrorIntegration = null;
    private static String codiceDiagnosticoInfoProtocol = null;
    private static String codiceDiagnosticoInfoIntegration = null;
    private static String codiceDiagnosticoDebugLow = null;
    private static String codiceDiagnosticoDebugMedium = null;
    private static String codiceDiagnosticoDebugHigh = null;

    public MsgDiagnosticiProperties(String location, String confDir) throws Exception {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = location != null ? new FileInputStream(location) : MsgDiagnosticiProperties.class.getResourceAsStream("/msgDiagnostici.properties");
            if (properties == null) {
                throw new Exception("File '/msgDiagnostici.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante la lettura del file 'msgDiagnostici.properties': \n\n" + e.getMessage()));
            throw new Exception("MsgDiagnosticiProperties initialize error: " + e.getMessage());
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception er) {}
        }
        this.reader = new MsgDiagnosticiInstanceProperties(propertiesReader, this.log, confDir);
    }

    public static boolean initialize(String location, String confDir) {
        try {
            if (msgDiagnosticiProperties == null) {
                MsgDiagnosticiProperties._initialize(location, confDir);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static synchronized void _initialize(String location, String confDir) throws Exception {
        if (msgDiagnosticiProperties == null) {
            msgDiagnosticiProperties = new MsgDiagnosticiProperties(location, confDir);
        }
    }

    public static MsgDiagnosticiProperties getInstance() {
        return msgDiagnosticiProperties;
    }

    public static void updateLocalImplementation(Properties prop) {
        MsgDiagnosticiProperties.msgDiagnosticiProperties.reader.setLocalObjectImplementation(prop);
    }

    public static boolean initialize() {
        try {
            if (msgDiagnosticiProperties == null) {
                MsgDiagnosticiProperties._initialize(null, null);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getFiltroMsgDiagnostico_OpenSPCoop2_0() {
        if (filtroMsgDiagnostico_OpenSPCoop2_0 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.0");
                if (value == null) {
                    filtroMsgDiagnostico_OpenSPCoop2_0 = LogLevels.toIntervalloLog4J(0);
                } else {
                    filtroMsgDiagnostico_OpenSPCoop2_0 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_OpenSPCoop2_0 < 0 || filtroMsgDiagnostico_OpenSPCoop2_0 > 9999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [0,9999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.0': " + e.getMessage()));
                filtroMsgDiagnostico_OpenSPCoop2_0 = LogLevels.toIntervalloLog4J(0);
            }
        }
        return filtroMsgDiagnostico_OpenSPCoop2_0;
    }

    public int getFiltroMsgDiagnostico_OpenSPCoop2_1() {
        if (filtroMsgDiagnostico_OpenSPCoop2_1 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.1");
                if (value == null) {
                    filtroMsgDiagnostico_OpenSPCoop2_1 = LogLevels.toIntervalloLog4J(1);
                } else {
                    filtroMsgDiagnostico_OpenSPCoop2_1 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_OpenSPCoop2_1 < 1 || filtroMsgDiagnostico_OpenSPCoop2_1 > 19999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [1,19999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.1': " + e.getMessage()));
                filtroMsgDiagnostico_OpenSPCoop2_1 = LogLevels.toIntervalloLog4J(1);
            }
        }
        return filtroMsgDiagnostico_OpenSPCoop2_1;
    }

    public int getFiltroMsgDiagnostico_OpenSPCoop2_2() {
        if (filtroMsgDiagnostico_OpenSPCoop2_2 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.2");
                if (value == null) {
                    filtroMsgDiagnostico_OpenSPCoop2_2 = LogLevels.toIntervalloLog4J(2);
                } else {
                    filtroMsgDiagnostico_OpenSPCoop2_2 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_OpenSPCoop2_2 < 10001 || filtroMsgDiagnostico_OpenSPCoop2_2 > 29999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [10001,29999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.2': " + e.getMessage()));
                filtroMsgDiagnostico_OpenSPCoop2_2 = LogLevels.toIntervalloLog4J(2);
            }
        }
        return filtroMsgDiagnostico_OpenSPCoop2_2;
    }

    public int getFiltroMsgDiagnostico_OpenSPCoop2_3() {
        if (filtroMsgDiagnostico_OpenSPCoop2_3 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.3");
                if (value == null) {
                    filtroMsgDiagnostico_OpenSPCoop2_3 = LogLevels.toIntervalloLog4J(3);
                } else {
                    filtroMsgDiagnostico_OpenSPCoop2_3 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_OpenSPCoop2_3 < 20001 || filtroMsgDiagnostico_OpenSPCoop2_3 > 39999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [20001,39999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.3': " + e.getMessage()));
                filtroMsgDiagnostico_OpenSPCoop2_3 = LogLevels.toIntervalloLog4J(3);
            }
        }
        return filtroMsgDiagnostico_OpenSPCoop2_3;
    }

    public int getFiltroMsgDiagnostico_OpenSPCoop2_4() {
        if (filtroMsgDiagnostico_OpenSPCoop2_4 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.4");
                if (value == null) {
                    filtroMsgDiagnostico_OpenSPCoop2_4 = LogLevels.toIntervalloLog4J(4);
                } else {
                    filtroMsgDiagnostico_OpenSPCoop2_4 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_OpenSPCoop2_4 < 30001 || filtroMsgDiagnostico_OpenSPCoop2_4 > 49999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [30001,49999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.4': " + e.getMessage()));
                filtroMsgDiagnostico_OpenSPCoop2_4 = LogLevels.toIntervalloLog4J(4);
            }
        }
        return filtroMsgDiagnostico_OpenSPCoop2_4;
    }

    public int getFiltroMsgDiagnostico_OpenSPCoop2_5() {
        if (filtroMsgDiagnostico_OpenSPCoop2_5 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.5");
                if (value == null) {
                    filtroMsgDiagnostico_OpenSPCoop2_5 = LogLevels.toIntervalloLog4J(5);
                } else {
                    filtroMsgDiagnostico_OpenSPCoop2_5 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_OpenSPCoop2_5 < 40001 || filtroMsgDiagnostico_OpenSPCoop2_5 > 59999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [40001,59999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.5': " + e.getMessage()));
                filtroMsgDiagnostico_OpenSPCoop2_5 = LogLevels.toIntervalloLog4J(5);
            }
        }
        return filtroMsgDiagnostico_OpenSPCoop2_5;
    }

    public int getFiltroMsgDiagnostico_OpenSPCoop2_6() {
        if (filtroMsgDiagnostico_OpenSPCoop2_6 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.6");
                if (value == null) {
                    filtroMsgDiagnostico_OpenSPCoop2_6 = LogLevels.toIntervalloLog4J(6);
                } else {
                    filtroMsgDiagnostico_OpenSPCoop2_6 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_OpenSPCoop2_6 < 50001 || filtroMsgDiagnostico_OpenSPCoop2_6 > 69999) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [50001,69999]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.6': " + e.getMessage()));
                filtroMsgDiagnostico_OpenSPCoop2_6 = LogLevels.toIntervalloLog4J(6);
            }
        }
        return filtroMsgDiagnostico_OpenSPCoop2_6;
    }

    public int getFiltroMsgDiagnostico_OpenSPCoop2_7() {
        if (filtroMsgDiagnostico_OpenSPCoop2_7 == null) {
            try {
                String value = null;
                value = this.reader.getValue("filtroMsgDiagnostici.livelloOpenSPCoop2.7");
                if (value == null) {
                    filtroMsgDiagnostico_OpenSPCoop2_7 = LogLevels.toIntervalloLog4J(7);
                } else {
                    filtroMsgDiagnostico_OpenSPCoop2_7 = Integer.parseInt(value.trim());
                    if (filtroMsgDiagnostico_OpenSPCoop2_7 < 60001 || filtroMsgDiagnostico_OpenSPCoop2_7 > 70000) {
                        throw new Exception("Il valore della proprieta' deve essere compreso nell'intervallo [60001,70000]");
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Riscontrato errore durante la lettura della proprieta' 'filtroMsgDiagnostici.livelloOpenSPCoop2.7': " + e.getMessage()));
                filtroMsgDiagnostico_OpenSPCoop2_7 = LogLevels.toIntervalloLog4J(7);
            }
        }
        return filtroMsgDiagnostico_OpenSPCoop2_7;
    }

    public int getValoreFiltroFromValoreOpenSPCoop2(int livello) {
        if (livello == 0) {
            return this.getFiltroMsgDiagnostico_OpenSPCoop2_0();
        }
        if (livello == 1) {
            return this.getFiltroMsgDiagnostico_OpenSPCoop2_1();
        }
        if (livello == 2) {
            return this.getFiltroMsgDiagnostico_OpenSPCoop2_2();
        }
        if (livello == 3) {
            return this.getFiltroMsgDiagnostico_OpenSPCoop2_3();
        }
        if (livello == 4) {
            return this.getFiltroMsgDiagnostico_OpenSPCoop2_4();
        }
        if (livello == 5) {
            return this.getFiltroMsgDiagnostico_OpenSPCoop2_5();
        }
        if (livello == 6) {
            return this.getFiltroMsgDiagnostico_OpenSPCoop2_6();
        }
        if (livello == 7) {
            return this.getFiltroMsgDiagnostico_OpenSPCoop2_7();
        }
        return livello;
    }

    public boolean checkValoriFiltriMsgDiagnostici(Logger log) {
        int openspcoop2_7;
        int openspcoop2_6;
        int openspcoop2_5;
        int openspcoop2_4;
        int openspcoop2_3;
        int openspcoop2_2;
        int openspcoop2_1;
        int openspcoop2_0 = this.getFiltroMsgDiagnostico_OpenSPCoop2_0();
        if (openspcoop2_0 != LogLevels.toIntervalloLog4J(0)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 0) al valore openspcoop: " + openspcoop2_0));
        }
        if ((openspcoop2_1 = this.getFiltroMsgDiagnostico_OpenSPCoop2_1()) <= openspcoop2_0) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 1 (valore: " + openspcoop2_1 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 0 (valore: " + openspcoop2_0 + ")."));
            return false;
        }
        if (openspcoop2_1 != LogLevels.toIntervalloLog4J(1)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 1) al valore openspcoop: " + openspcoop2_1));
        }
        if ((openspcoop2_2 = this.getFiltroMsgDiagnostico_OpenSPCoop2_2()) <= openspcoop2_1) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 2 (valore: " + openspcoop2_2 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 1 (valore: " + openspcoop2_1 + ")."));
            return false;
        }
        if (openspcoop2_2 != LogLevels.toIntervalloLog4J(2)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 2) al valore openspcoop: " + openspcoop2_2));
        }
        if ((openspcoop2_3 = this.getFiltroMsgDiagnostico_OpenSPCoop2_3()) <= openspcoop2_2) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 3 (valore: " + openspcoop2_3 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 2 (valore: " + openspcoop2_2 + ")."));
            return false;
        }
        if (openspcoop2_3 != LogLevels.toIntervalloLog4J(3)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 3) al valore openspcoop: " + openspcoop2_3));
        }
        if ((openspcoop2_4 = this.getFiltroMsgDiagnostico_OpenSPCoop2_4()) <= openspcoop2_3) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 4 (valore: " + openspcoop2_4 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 3 (valore: " + openspcoop2_3 + ")."));
            return false;
        }
        if (openspcoop2_4 != LogLevels.toIntervalloLog4J(4)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 4) al valore openspcoop: " + openspcoop2_4));
        }
        if ((openspcoop2_5 = this.getFiltroMsgDiagnostico_OpenSPCoop2_5()) <= openspcoop2_4) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 5 (valore: " + openspcoop2_5 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 4 (valore: " + openspcoop2_4 + ")."));
            return false;
        }
        if (openspcoop2_5 != LogLevels.toIntervalloLog4J(5)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 5) al valore openspcoop: " + openspcoop2_5));
        }
        if ((openspcoop2_6 = this.getFiltroMsgDiagnostico_OpenSPCoop2_6()) <= openspcoop2_5) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 6 (valore: " + openspcoop2_6 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 5 (valore: " + openspcoop2_5 + ")."));
            return false;
        }
        if (openspcoop2_6 != LogLevels.toIntervalloLog4J(6)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 6) al valore openspcoop: " + openspcoop2_6));
        }
        if ((openspcoop2_7 = this.getFiltroMsgDiagnostico_OpenSPCoop2_7()) <= openspcoop2_6) {
            log.error((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici OpenSPCoop2 7 (valore: " + openspcoop2_7 + ") deve essere maggiore del valore impostato per il livello OpenSPCoop2 6 (valore: " + openspcoop2_6 + ")."));
            return false;
        }
        if (openspcoop2_7 != LogLevels.toIntervalloLog4J(7)) {
            log.info((Object)("Personalizzazione del livello di filtro dei messaggi diagnostici (OpenSPCoop2 7) al valore openspcoop: " + openspcoop2_7));
        }
        return true;
    }

    public static PropertiesReader getLivelliMsgDiagnosticiPersonalizzati() {
        return livelliMsgDiagnosticiPersonalizzati;
    }

    public static PropertiesReader getCodiciMsgDiagnosticiPersonalizzati() {
        return codiciMsgDiagnosticiPersonalizzati;
    }

    public static PropertiesReader getMessaggiMsgDiagnosticiPersonalizzati() {
        return messaggiMsgDiagnosticiPersonalizzati;
    }

    public static PropertiesReader getCodiciIdentificativiFunzione() {
        return codiciIdentificativiFunzione;
    }

    public static PropertiesReader getMappingCodiceToKeywordMsgDiagnosticiPersonalizzati() {
        return mappingCodiceToKeywordMsgDiagnosticiPersonalizzati;
    }

    public synchronized boolean initializeMsgDiagnosticiPersonalizzati() {
        try {
            if (livelliMsgDiagnosticiPersonalizzati == null) {
                String key;
                Properties tmp_livelliMsgDiagnosticiPersonalizzati = new Properties();
                Properties tmp_codiciMsgDiagnosticiPersonalizzati = new Properties();
                Properties tmp_codiciIdentificativiFunzione = new Properties();
                Properties tmp_messaggiMsgDiagnosticiPersonalizzati = new Properties();
                Properties tmp_mappingCodiceToKeywordMsgDiagnosticiPersonalizzati = new Properties();
                Properties msgDiagnostici = this.reader.readProperties(PREFIX_MSG_DIAGNOSTICO);
                Enumeration<Object> nomi = msgDiagnostici.keys();
                while (nomi.hasMoreElements()) {
                    key = (String)nomi.nextElement();
                    if (!key.endsWith(SUFFIX_CODICE_MODULO_MSG_DIAGNOSTICO)) continue;
                    String value = msgDiagnostici.getProperty(key);
                    String[] tmpSplit = key.split("\\.");
                    String modulo = tmpSplit[0].trim();
                    if (tmp_codiciIdentificativiFunzione.containsKey(modulo)) {
                        throw new Exception("Per Il modulo funzionale [" + modulo + "] sono stati definiti piu' codici??");
                    }
                    if (tmp_codiciIdentificativiFunzione.containsValue(value)) {
                        throw new Exception("Il codice fornito (" + modulo + "=" + value + ") e' gia' utilizzato da un altro modulo funzionale");
                    }
                    tmp_codiciIdentificativiFunzione.put(modulo, value);
                }
                msgDiagnostici = this.reader.readProperties(PREFIX_MSG_DIAGNOSTICO);
                nomi = msgDiagnostici.keys();
                while (nomi.hasMoreElements()) {
                    String valore;
                    String chiave;
                    key = (String)nomi.nextElement();
                    if (key.endsWith(SUFFIX_LIVELLO_MSG_DIAGNOSTICO)) {
                        chiave = key.substring(0, key.length() - SUFFIX_LIVELLO_MSG_DIAGNOSTICO.length());
                        valore = msgDiagnostici.getProperty(key);
                        try {
                            Integer v = Integer.parseInt(valore);
                            v.toString();
                            tmp_livelliMsgDiagnosticiPersonalizzati.put(chiave, valore);
                            continue;
                        }
                        catch (Exception e) {
                            throw new Exception("Valore della proprieta' [" + key + "] non valido [" + valore + "]: " + e.getMessage());
                        }
                    }
                    if (key.endsWith(".codice")) {
                        chiave = key.substring(0, key.length() - ".codice".length());
                        valore = msgDiagnostici.getProperty(key);
                        String[] tmp = chiave.split("\\.");
                        String moduloFunzionale = tmp[0].trim();
                        Object codiceModuloFunzionaleObject = tmp_codiciIdentificativiFunzione.get(moduloFunzionale);
                        if (codiceModuloFunzionaleObject == null) {
                            throw new Exception("Per il modulo funzionale [" + moduloFunzionale + "] non e' stato definito il codice");
                        }
                        String codiceModuloFunzionale = (String)codiceModuloFunzionaleObject;
                        String codiceDefinitivo = codiceModuloFunzionale + valore;
                        if (tmp_codiciMsgDiagnosticiPersonalizzati.containsValue(codiceDefinitivo)) {
                            throw new Exception("Proprieta' " + chiave + " contiene un codice [" + valore + "] gia' definito per un altro messaggio diagnostico del modulo funzionale " + moduloFunzionale + " (" + codiceModuloFunzionale + ")");
                        }
                        tmp_codiciMsgDiagnosticiPersonalizzati.put(chiave, codiceDefinitivo);
                        tmp_mappingCodiceToKeywordMsgDiagnosticiPersonalizzati.put(codiceDefinitivo, chiave);
                        continue;
                    }
                    if (key.endsWith(SUFFIX_MESSAGGIO_MSG_DIAGNOSTICO)) {
                        chiave = key.substring(0, key.length() - SUFFIX_MESSAGGIO_MSG_DIAGNOSTICO.length());
                        valore = msgDiagnostici.getProperty(key);
                        tmp_messaggiMsgDiagnosticiPersonalizzati.put(chiave, valore);
                        continue;
                    }
                    if (key.endsWith(SUFFIX_CODICE_MODULO_MSG_DIAGNOSTICO)) continue;
                    throw new Exception("Proprieta' malformata [" + key + "]");
                }
                for (int i = 0; i < MSG_DIAGNOSTICI_PERSONALIZZATI.length; ++i) {
                    String prefix = PREFIX_MSG_DIAGNOSTICO + MSG_DIAGNOSTICI_PERSONALIZZATI[i];
                    String livello = prefix + SUFFIX_LIVELLO_MSG_DIAGNOSTICO;
                    String codice = prefix + ".codice";
                    String messaggio = prefix + SUFFIX_MESSAGGIO_MSG_DIAGNOSTICO;
                    if (!tmp_livelliMsgDiagnosticiPersonalizzati.containsKey(MSG_DIAGNOSTICI_PERSONALIZZATI[i])) {
                        throw new Exception("Proprieta' " + livello + " non definita");
                    }
                    if (!tmp_codiciMsgDiagnosticiPersonalizzati.containsKey(MSG_DIAGNOSTICI_PERSONALIZZATI[i])) {
                        throw new Exception("Proprieta' " + codice + " non definita");
                    }
                    if (tmp_messaggiMsgDiagnosticiPersonalizzati.containsKey(MSG_DIAGNOSTICI_PERSONALIZZATI[i])) continue;
                    throw new Exception("Proprieta' " + messaggio + " non definita");
                }
                livelliMsgDiagnosticiPersonalizzati = new PropertiesReader(tmp_livelliMsgDiagnosticiPersonalizzati, true);
                codiciMsgDiagnosticiPersonalizzati = new PropertiesReader(tmp_codiciMsgDiagnosticiPersonalizzati, true);
                messaggiMsgDiagnosticiPersonalizzati = new PropertiesReader(tmp_messaggiMsgDiagnosticiPersonalizzati, true);
                mappingCodiceToKeywordMsgDiagnosticiPersonalizzati = new PropertiesReader(tmp_mappingCodiceToKeywordMsgDiagnosticiPersonalizzati, true);
                codiciIdentificativiFunzione = new PropertiesReader(tmp_codiciIdentificativiFunzione, true);
            }
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante la lettura dei messaggi diagnostici personalizzati: " + e.getMessage()));
            if (OpenSPCoop2Logger.getLoggerOpenSPCoopCore() != null) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)("Riscontrato errore durante la lettura dei messaggi diagnostici personalizzati: " + e.getMessage()), (Throwable)e);
            }
            livelliMsgDiagnosticiPersonalizzati = null;
            messaggiMsgDiagnosticiPersonalizzati = null;
            return false;
        }
    }

    public int getLivello(String modulo, String keyLivelloPersonalizzato) {
        try {
            String livello = livelliMsgDiagnosticiPersonalizzati.getValue(modulo + keyLivelloPersonalizzato);
            if (livello != null) {
                return Integer.parseInt(livello);
            }
            return -1;
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'esecuzione del metodo getLivello(" + modulo + "," + keyLivelloPersonalizzato + ")"), (Throwable)e);
            return -1;
        }
    }

    public String getCodice(String modulo, String keyCodicePersonalizzato) {
        try {
            return codiciMsgDiagnosticiPersonalizzati.getValue(modulo + keyCodicePersonalizzato);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'esecuzione del metodo getCodice(" + modulo + "," + keyCodicePersonalizzato + ")"), (Throwable)e);
            return null;
        }
    }

    public String getMessaggio(String modulo, String keyMsgPersonalizzato) {
        try {
            return messaggiMsgDiagnosticiPersonalizzati.getValue(modulo + keyMsgPersonalizzato);
        }
        catch (Exception e) {
            this.log.error((Object)("Errore durante l'esecuzione del metodo getMessaggio(" + modulo + "," + keyMsgPersonalizzato + ")"), (Throwable)e);
            return null;
        }
    }

    public String getKeyMessaggio(String codice) throws Exception {
        if (mappingCodiceToKeywordMsgDiagnosticiPersonalizzati.containsKey((Object)codice)) {
            String keyword = mappingCodiceToKeywordMsgDiagnosticiPersonalizzati.getValue(codice);
            if (keyword == null) {
                throw new Exception("MsgDiagnostico con codice [" + codice + "] non registrato?");
            }
            return keyword;
        }
        throw new Exception("MsgDiagnostico con codice [" + codice + "] non registrato");
    }

    public String getModulo(String codice) throws Exception {
        Enumeration moduli = codiciIdentificativiFunzione.propertyNames();
        while (moduli.hasMoreElements()) {
            String modulo = (String)moduli.nextElement();
            String codiceModulo = codiciIdentificativiFunzione.getValue(modulo);
            if (codiceModulo == null) {
                throw new Exception("Modulo [" + modulo + "] senza un codice registrato");
            }
            if (!codiceModulo.equals(codice)) continue;
            return modulo;
        }
        throw new Exception("Modulo con codice [" + codice + "] non registrato");
    }

    private static synchronized void initCodiceDiagnostico(MsgDiagnosticiInstanceProperties reader) throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            codiceDiagnosticoFatal = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.fatal.codice");
            codiceDiagnosticoErrorProtocol = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.errorProtocol.codice");
            codiceDiagnosticoErrorIntegration = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.errorIntegration.codice");
            codiceDiagnosticoInfoProtocol = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.infoProtocol.codice");
            codiceDiagnosticoInfoIntegration = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.infoIntegration.codice");
            codiceDiagnosticoDebugLow = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.debugLow.codice");
            codiceDiagnosticoDebugMedium = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.debugMedium.codice");
            codiceDiagnosticoDebugHigh = reader.getValue("org.openspcoop2.pdd.msgdiagnosticoNonRegistrato.debugHigh.codice");
            codiceDiagnosticoInitialized = true;
        }
    }

    public String getCodiceDiagnosticoFatal() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoFatal;
    }

    public String getCodiceDiagnosticoErrorProtocol() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoErrorProtocol;
    }

    public String getCodiceDiagnosticoErrorIntegration() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoErrorIntegration;
    }

    public String getCodiceDiagnosticoInfoProtocol() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoInfoProtocol;
    }

    public String getCodiceDiagnosticoInfoIntegration() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoInfoIntegration;
    }

    public String getCodiceDiagnosticoDebugLow() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoDebugLow;
    }

    public String getCodiceDiagnosticoDebugMedium() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoDebugMedium;
    }

    public String getCodiceDiagnosticoDebugHigh() throws UtilsException {
        if (!codiceDiagnosticoInitialized) {
            MsgDiagnosticiProperties.initCodiceDiagnostico(this.reader);
        }
        return codiceDiagnosticoDebugHigh;
    }
}

