/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.node;

import java.sql.Connection;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.NodeException;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.utils.date.DateManager;

public class TransactionManager {
    private static Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    public static final String ID_MODULO = "TransactionManager";

    public static boolean validityCheck(MsgDiagnostico msgDiag, String idModulo, String idBusta, String tipo, String idJMS, PdDContext pddContext) throws Exception {
        return TransactionManager.validityCheck(msgDiag, idModulo, idBusta, tipo, idJMS, pddContext, null);
    }

    public static boolean validityCheck(MsgDiagnostico msgDiag, String idModulo, String idBusta, String tipo, String idJMS, PdDContext pddContext, String servizioApplicativo) throws Exception {
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        IDSoggetto dominio = properties.getIdentitaPortaDefault(null);
        String idModuloTransaction = "TransactionManager_" + idModulo;
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        OpenSPCoopStateful openspcoopstate = new OpenSPCoopStateful();
        StatefulMessage state = new StatefulMessage(null, log);
        openspcoopstate.setStatoRichiesta((IState)state);
        GestoreMessaggi msg = new GestoreMessaggi(openspcoopstate, true, idBusta, tipo, msgDiag, null);
        long scadenzaWhile = DateManager.getTimeMillis() + properties.getTransactionManager_AttesaAttiva();
        try {
            int refreshOnlyCacheCount = 0;
            while (DateManager.getTimeMillis() < scadenzaWhile) {
                boolean checkOnlyCache = properties.isAbilitataCacheGestoreMessaggi();
                if (++refreshOnlyCacheCount == properties.getTransactionManager_CheckDBInterval()) {
                    msgDiag.highDebug("Re-inizializzo contatore refreshOnlyCacheCount");
                    refreshOnlyCacheCount = 1;
                    checkOnlyCache = false;
                }
                msgDiag.highDebug("Transaction su IDM[" + idModulo + "] IDBusta[" + idBusta + "] Tipo[" + tipo + "] IDJMS[" + idJMS + "] SA[" + servizioApplicativo + "] ancora interval[" + properties.getTransactionManager_CheckInterval() + "]  millisecondi " + (scadenzaWhile - DateManager.getTimeMillis()));
                boolean needConnection = false;
                if (!properties.singleConnection_TransactionManager()) {
                    needConnection = true;
                } else if (resource == null) {
                    needConnection = true;
                }
                if (!checkOnlyCache && needConnection) {
                    msgDiag.highDebug("Prendo Connessione per TransactionManager");
                    try {
                        resource = dbManager.getResource(dominio, idModuloTransaction, PdDContext.getValue("ID", pddContext));
                    }
                    catch (Exception e) {
                        throw new NodeException("Impossibile ottenere una Risorsa dal DBManager", e);
                    }
                    if (resource == null) {
                        throw new NodeException("Risorsa is null");
                    }
                    if (resource.getResource() == null) {
                        throw new NodeException("Connessione is null");
                    }
                    Connection connectionDB = (Connection)resource.getResource();
                    state.setConnectionDB(connectionDB);
                }
                msgDiag.highDebug("getProprietario(" + checkOnlyCache + ")");
                String proprietarioMessaggio = msg.getProprietario(idModulo, checkOnlyCache);
                msgDiag.highDebug("getProprietario(" + checkOnlyCache + ") proprietario=" + proprietarioMessaggio);
                if (proprietarioMessaggio == null) {
                    msgDiag.highDebug("Messaggio per il modulo [" + idModulo + "]: Attesa attiva, modulo precendente [Punto di inizio]");
                    if (!properties.singleConnection_TransactionManager() && !checkOnlyCache) {
                        msgDiag.highDebug("Rilascio connessione per TransactionManager");
                        dbManager.releaseResource(dominio, idModuloTransaction, resource);
                    }
                    try {
                        Thread.sleep(properties.getTransactionManager_CheckInterval());
                    }
                    catch (Exception eRandom) {}
                    continue;
                }
                if (proprietarioMessaggio.equals(idModulo)) {
                    msgDiag.highDebug("Messaggio per il modulo [" + idModulo + "]: proprietario[" + proprietarioMessaggio + "] OK");
                    if (properties.singleConnection_TransactionManager() && resource != null || !checkOnlyCache) {
                        msgDiag.highDebug("Rilascio connessione per TransactionManager");
                        dbManager.releaseResource(dominio, idModuloTransaction, resource);
                    }
                    return true;
                }
                if (!TransactionManager.isModuloPrecedente(idModulo, proprietarioMessaggio, false)) {
                    msgDiag.highDebug("Messaggio per il modulo [" + idModulo + "]: proprietario[" + proprietarioMessaggio + "], scarta");
                    if (properties.singleConnection_TransactionManager() && resource != null || !checkOnlyCache) {
                        msgDiag.highDebug("Rilascio connessione per TransactionManager");
                        dbManager.releaseResource(dominio, idModuloTransaction, resource);
                    }
                    return false;
                }
                if (needConnection && checkOnlyCache) {
                    msgDiag.highDebug("Prendo Connessione per TransactionManager NeedForJMS");
                    try {
                        resource = dbManager.getResource(dominio, idModuloTransaction, PdDContext.getValue("ID", pddContext));
                    }
                    catch (Exception e) {
                        throw new NodeException("Impossibile ottenere una Risorsa dal DBManager", e);
                    }
                    if (resource == null) {
                        throw new NodeException("Risorsa is null");
                    }
                    if (resource.getResource() == null) {
                        throw new NodeException("Connessione is null");
                    }
                    Connection connectionDB = (Connection)resource.getResource();
                    state.setConnectionDB(connectionDB);
                }
                String idJMSRicevutoPrecedentemente = null;
                idJMSRicevutoPrecedentemente = "ConsegnaContenutiApplicativi".equals(idModulo) ? msg.getIDJMSRicevuto(idModulo, servizioApplicativo) : msg.getIDJMSRicevuto(idModulo);
                if (idJMSRicevutoPrecedentemente == null) {
                    if ("ConsegnaContenutiApplicativi".equals(idModulo)) {
                        msg.aggiornaIDHeaderJMS(idModulo, idJMS, servizioApplicativo);
                    } else {
                        msg.aggiornaIDHeaderJMS(idModulo, idJMS);
                    }
                } else if (!idJMSRicevutoPrecedentemente.equals(idJMS)) {
                    msgDiag.highDebug("Messaggio per il modulo [" + idModulo + "]: un altro messaggio JMS e' gia stato ricevuto, scarta");
                    msgDiag.highDebug("Rilascio connessione per TransactionManager");
                    dbManager.releaseResource(dominio, idModuloTransaction, resource);
                    return false;
                }
                msgDiag.highDebug("Messaggio per il modulo [" + idModulo + "]: Attesa attiva, modulo precedente[" + proprietarioMessaggio + "]");
                if (!properties.singleConnection_TransactionManager()) {
                    msgDiag.highDebug("Rilascio connessione per TransactionManager");
                    dbManager.releaseResource(dominio, idModuloTransaction, resource);
                }
                try {
                    Thread.sleep(properties.getTransactionManager_CheckInterval());
                }
                catch (Exception eRandom) {}
            }
            if (properties.singleConnection_TransactionManager()) {
                msgDiag.highDebug("Rilascio connessione per TransactionManager");
                dbManager.releaseResource(dominio, idModuloTransaction, resource);
            }
            String msgTerminato = "TransactionManager: Attesa attiva terminata, probabilmente il messaggio e' stato gia gestito ed eliminato IDModulo[" + idModulo + "] IDBusta[" + idBusta + "] Tipo[" + tipo + "]";
            msgDiag.highDebug(msgTerminato);
            log.warn((Object)msgTerminato);
            return false;
        }
        catch (Exception e) {
            log.error((Object)("TransactionManager exception: " + e.getMessage()), (Throwable)e);
            if (resource != null) {
                dbManager.releaseResource(dominio, idModuloTransaction, resource);
            }
            throw e;
        }
    }

    public static boolean isModuloPrecedente(String idModulo, String proprietarioMessaggio, boolean checkProprietarioNull) throws Exception {
        if (idModulo.startsWith("RicezioneContenutiApplicativi")) {
            if ("Imbustamento".equals(proprietarioMessaggio)) {
                return true;
            }
            if ("InoltroBuste".equals(proprietarioMessaggio)) {
                return true;
            }
            if ("SbustamentoRisposte".equals(proprietarioMessaggio)) {
                return true;
            }
            return "Sbustamento".equals(proprietarioMessaggio);
        }
        if (idModulo.startsWith("RicezioneBuste")) {
            if ("Sbustamento".equals(proprietarioMessaggio)) {
                return true;
            }
            if ("ConsegnaContenutiApplicativi".equals(proprietarioMessaggio)) {
                return true;
            }
            return "ImbustamentoRisposte".equals(proprietarioMessaggio);
        }
        if ("Imbustamento".equals(idModulo)) {
            if (checkProprietarioNull && proprietarioMessaggio == null) {
                return true;
            }
            return proprietarioMessaggio.startsWith("RicezioneContenutiApplicativi");
        }
        if ("ImbustamentoRisposte".equals(idModulo)) {
            return "ConsegnaContenutiApplicativi".equals(proprietarioMessaggio);
        }
        if ("Sbustamento".equals(idModulo)) {
            if (checkProprietarioNull && proprietarioMessaggio == null) {
                return true;
            }
            return proprietarioMessaggio.startsWith("RicezioneBuste");
        }
        if ("SbustamentoRisposte".equals(idModulo)) {
            return "InoltroBuste".equals(proprietarioMessaggio);
        }
        if ("InoltroBuste".equals(idModulo)) {
            return "Imbustamento".equals(proprietarioMessaggio);
        }
        if ("InoltroRisposte".equals(idModulo)) {
            return true;
        }
        if ("ConsegnaContenutiApplicativi".equals(idModulo)) {
            if ("Sbustamento".equals(proprietarioMessaggio)) {
                return true;
            }
            if ("SbustamentoRisposte".equals(proprietarioMessaggio)) {
                return true;
            }
            if ("Imbustamento".equals(proprietarioMessaggio)) {
                return true;
            }
            return "InoltroBuste".equals(proprietarioMessaggio);
        }
        return false;
    }
}

