/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.node;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.GestoreMessaggiException;
import org.openspcoop2.pdd.core.node.INodeSender;
import org.openspcoop2.pdd.core.node.NodeException;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.mdb.GenericMessage;
import org.openspcoop2.pdd.mdb.threads.MessaggioSerializzato;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.resources.Loader;

public class NodeSenderDB
extends AbstractCore
implements INodeSender {
    private static final String ID_MODULO = "NODE_SENDER_DB";
    private static IJDBCAdapter adapter = null;
    private static OpenSPCoop2Properties propertiesReader;
    private static Logger log;
    private static boolean isInitialized;

    private synchronized void init() throws NodeException {
        if (!isInitialized) {
            try {
                propertiesReader = OpenSPCoop2Properties.getInstance();
                log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
                String jdbcAdapter = propertiesReader.getRepositoryJDBCAdapter();
                if (propertiesReader.getDatabaseType() != null && TipiDatabase.DEFAULT.equals(jdbcAdapter)) {
                    adapter = JDBCAdapterFactory.createJDBCAdapter((String)propertiesReader.getDatabaseType());
                } else {
                    ClassNameProperties classNameProperties = ClassNameProperties.getInstance();
                    String adapterClass = classNameProperties.getJDBCAdapter(jdbcAdapter);
                    if (adapterClass == null) {
                        log.error((Object)("Inizializzione GestoreMessaggi non riuscita: AdapterClass non registrata [" + propertiesReader.getRepositoryJDBCAdapter() + "]"));
                    }
                    adapter = (IJDBCAdapter)Loader.getInstance().newInstance(adapterClass);
                }
            }
            catch (Exception e) {
                log.error((Object)("Inizializzione GestoreMessaggi non riuscita: AdapterClass non trovata [" + propertiesReader.getRepositoryJDBCAdapter() + "]:" + e.getMessage()), (Throwable)e);
                System.out.println("Inizializzazione NODESENDER FALLITA: " + e);
                return;
            }
            isInitialized = true;
        }
    }

    @Override
    public void send(Serializable msg, String destinazione, MsgDiagnostico msgDiag, IDSoggetto codicePorta, String idModulo, String idMessaggio, GestoreMessaggi gm) throws NodeException {
        byte[] msgByte;
        if (!isInitialized) {
            try {
                this.init();
            }
            catch (Exception e) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)"Inizializzazione NODESENDER FALLITA", (Throwable)e);
                return;
            }
        }
        MessaggioSerializzato messaggioSerializzato = new MessaggioSerializzato(idMessaggio, (GenericMessage)msg);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(messaggioSerializzato);
            out.close();
            msgByte = bos.toByteArray();
        }
        catch (IOException e) {
            log.error((Object)("NODE_SENDER_DB Serializzazione messaggio fallita: " + e.getMessage()), (Throwable)e);
            return;
        }
        try {
            gm.aggiungiMessaggioSerializzato(adapter, msgByte);
        }
        catch (GestoreMessaggiException e) {
            throw new NodeException(e);
        }
        msgDiag.highDebug("ObjectMessage send (NOP operation).");
    }

    static {
        isInitialized = false;
    }
}

