/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.node;

import javax.jms.JMSException;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.JMSReceiver;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.node.INodeReceiver;
import org.openspcoop2.pdd.core.node.NodeException;
import org.openspcoop2.pdd.core.node.NodeTimeoutException;
import org.openspcoop2.pdd.core.node.TransactionManager;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.RicezioneBusteMessage;
import org.openspcoop2.pdd.services.RicezioneContenutiApplicativiMessage;
import org.openspcoop2.protocol.sdk.Busta;

public class NodeReceiverJMS
extends AbstractCore
implements INodeReceiver {
    private static OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();

    @Override
    public Object receive(MsgDiagnostico msgDiag, IDSoggetto codicePorta, String idModulo, String idMessaggio, long timeout, long checkInterval) throws NodeException, NodeTimeoutException {
        Object objReturn = null;
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        try {
            JMSReceiver receiverJMS = new JMSReceiver(codicePorta, idModulo, openspcoopProperties.singleConnection_NodeReceiver(), log, PdDContext.getValue("ID", this.getPddContext()));
            while (true) {
                String strMessageSelector = "ID = '" + idMessaggio + "'";
                msgDiag.highDebug("Ricezione messaggio selector[" + strMessageSelector + "]....");
                if (!receiverJMS.receive(idModulo, strMessageSelector, timeout, checkInterval)) {
                    throw new JMSException(receiverJMS.getErrore());
                }
                msgDiag.highDebug("Ricezione effettuata");
                objReturn = receiverJMS.getObjectReceived();
                if (objReturn == null) {
                    throw new JMSException("Oggetto ricevuto dalla coda jms is null");
                }
                String idRisposta = null;
                String tipoMessaggio = null;
                if (idModulo.startsWith("RicezioneContenutiApplicativi")) {
                    msgDiag.highDebug("Lettura risposta per RicezioneContenutiApplicativi...");
                    idRisposta = ((RicezioneContenutiApplicativiMessage)objReturn).getIdBustaRisposta();
                    tipoMessaggio = "INBOX";
                    msgDiag.highDebug("Lettura risposta per RicezioneContenutiApplicativi effettuata");
                } else if (idModulo.startsWith("RicezioneBuste")) {
                    msgDiag.highDebug("Lettura risposta per RicezioneBuste...");
                    Busta bustaRisposta = ((RicezioneBusteMessage)objReturn).getBustaRisposta();
                    idRisposta = bustaRisposta != null ? bustaRisposta.getID() : ((RicezioneBusteMessage)objReturn).getIdMessaggioSblocco();
                    tipoMessaggio = "OUTBOX";
                    msgDiag.highDebug("Lettura risposta per RicezioneBuste effettuata");
                }
                if (!TransactionManager.validityCheck(msgDiag, idModulo, idRisposta, tipoMessaggio, receiverJMS.getIdHeaderJMS(), this.getPddContext())) {
                    msgDiag.highDebug("Messaggio con id[" + idMessaggio + "] non ha superato il validity check");
                    log.error((Object)("Messaggio con id[" + idMessaggio + "] non ha superato il validity check"));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                if (e.getMessage().indexOf("Messaggio non ricevuto") >= 0) {
                    throw new NodeTimeoutException("Risposta per la gestione della richiesta, " + e.getMessage(), e);
                }
                throw new NodeException("Riscontrato errore nella ricezione del messaggio di risposta per la gestione della richiesta:" + e.getMessage(), e);
            }
            throw new NodeException("Riscontrato errore nella ricezione del messaggio di risposta per la gestione della richiesta", e);
        }
        return objReturn;
    }
}

