/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.jmx;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.SystemPropertiesManager;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;

public class SysPropsJMXResource
extends NotificationBroadcasterSupport
implements DynamicMBean {
    public static final String OPENSPCOOP2_SYSTEM_PROPERTIES = "OpenSPCoop2Properties";
    public static final String REFRESH_PERSISTENT_SYSTEM_PROPERTIES = "refreshPersistentConfiguration";
    public static final String READ_ALL_SYSTEM_PROPERTIES = "readAllProperties";
    public static final String READ_OPENSPCOOP2_SYSTEM_PROPERTIES = "readOpenSPCoop2Properties";
    public static final String GET_SYSTEM_PROPERTY_VALUE = "getPropertyValue";
    public static final String REMOVE_SYSTEM_PROPERTY = "removeProperty";
    public static final String UPDATE_SYSTEM_PROPERTY = "updateProperty";
    public static final String INSERT_SYSTEM_PROPERTY = "insertProperty";
    public static final String EFFETTUATO_SUCCESSO = "Operazione effettuata con successo";
    public static final String EFFETTUATO_SUCCESSO_INFO = "Operazione effettuata con successo (Nota la Modifica non \u00e8 persistente, inoltre in caso di invocazione del pulsante 'refreshPersistentConfiguration' questa impostazione non viene mantenuta)";
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    ConfigurazionePdDManager configReader = ConfigurazionePdDManager.getInstance();
    OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
    private SystemPropertiesManager spm = new SystemPropertiesManager(this.configReader, this.log);

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null || attributeName.equals("")) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo o vuoto");
        }
        if (attributeName.equals(OPENSPCOOP2_SYSTEM_PROPERTIES)) {
            String v = this.spm.getPropertyValue("OpenSPCoop2SystemProperties");
            if (v == null || v.length() <= 0) {
                return "";
            }
            return v;
        }
        throw new AttributeNotFoundException("Attributo " + attributeName + " non trovato");
    }

    @Override
    public AttributeList getAttributes(String[] attributesNames) {
        if (attributesNames == null) {
            throw new IllegalArgumentException("Array nullo");
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributesNames.length; ++i) {
            try {
                list.add(new Attribute(attributesNames[i], this.getAttribute(attributesNames[i])));
                continue;
            }
            catch (JMException ex) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new IllegalArgumentException("Il nome dell'attributo e' nullo");
        }
        try {
            if (!attribute.getName().equals(OPENSPCOOP2_SYSTEM_PROPERTIES)) {
                throw new AttributeNotFoundException("Attributo " + attribute.getName() + " non trovato");
            }
        }
        catch (ClassCastException ce) {
            throw new InvalidAttributeValueException("il tipo " + attribute.getValue().getClass() + " dell'attributo " + attribute.getName() + " non e' valido");
        }
        catch (JMException j) {
            throw new MBeanException(j);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList list) {
        if (list == null) {
            throw new IllegalArgumentException("Lista degli attributi e' nulla");
        }
        AttributeList ret = new AttributeList();
        Iterator it = ret.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                ret.add(attribute);
            }
            catch (JMException ex) {}
        }
        return ret;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName == null || actionName.equals("")) {
            throw new IllegalArgumentException("Nessuna operazione definita");
        }
        if (actionName.equals(REFRESH_PERSISTENT_SYSTEM_PROPERTIES)) {
            return this.refreshPersistentConfigSystemProperty();
        }
        if (actionName.equals(READ_ALL_SYSTEM_PROPERTIES)) {
            return this.readAllSystemProperties();
        }
        if (actionName.equals(READ_OPENSPCOOP2_SYSTEM_PROPERTIES)) {
            return this.readOpenSPCoop2SystemProperties();
        }
        if (actionName.equals(GET_SYSTEM_PROPERTY_VALUE)) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[getPropertyValue] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.getSystemPropertyValue(param1);
        }
        if (actionName.equals(REMOVE_SYSTEM_PROPERTY)) {
            if (params.length != 1) {
                throw new MBeanException(new Exception("[removeProperty] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            return this.removeSystemProperty(param1);
        }
        if (actionName.equals(UPDATE_SYSTEM_PROPERTY)) {
            if (params.length != 2) {
                throw new MBeanException(new Exception("[updateProperty] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            String param2 = null;
            if (params[1] != null && !"".equals(params[1])) {
                param2 = (String)params[1];
            }
            return this.updateSystemProperty(param1, param2);
        }
        if (actionName.equals(INSERT_SYSTEM_PROPERTY)) {
            if (params.length != 2) {
                throw new MBeanException(new Exception("[insertProperty] Lunghezza parametri non corretta: " + params.length));
            }
            String param1 = null;
            if (params[0] != null && !"".equals(params[0])) {
                param1 = (String)params[0];
            }
            String param2 = null;
            if (params[1] != null && !"".equals(params[1])) {
                param2 = (String)params[1];
            }
            return this.insertSystemProperty(param1, param2);
        }
        throw new UnsupportedOperationException("Operazione " + actionName + " sconosciuta");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        String className = this.getClass().getName();
        String description = "Risorsa per la gestione delle propriet\u00e0 di sistema utilizzate dalla Porta di Dominio " + this.openspcoopProperties.getVersione();
        MBeanAttributeInfo propertiesVAR = new MBeanAttributeInfo(OPENSPCOOP2_SYSTEM_PROPERTIES, String.class.getName(), "propriet\u00e0 di sistema impostate tramite la configurazione della Porta di Dominio", true, false, false);
        MBeanOperationInfo refreshPersistentConfigurazioneOP = new MBeanOperationInfo(REFRESH_PERSISTENT_SYSTEM_PROPERTIES, "Reimposta le propriet\u00e0 di sistema indicate nella configurazione della Porta di Dominio", null, String.class.getName(), 1);
        MBeanOperationInfo readAllPropertiesOP = new MBeanOperationInfo(READ_ALL_SYSTEM_PROPERTIES, "Visualizza tutte le propriet\u00e0 di sistema", null, String.class.getName(), 1);
        MBeanOperationInfo readOpenSPCoop2PropertiesOP = new MBeanOperationInfo(READ_OPENSPCOOP2_SYSTEM_PROPERTIES, "Visualizza le propriet\u00e0 di sistema impostate tramite la configurazione della Porta di Dominio", null, String.class.getName(), 1);
        MBeanOperationInfo getPropertyValueOP = new MBeanOperationInfo(GET_SYSTEM_PROPERTY_VALUE, "Ritorna il valore di una propriet\u00e0 di sistema", new MBeanParameterInfo[]{new MBeanParameterInfo("nome", String.class.getName(), "Nome della propriet\u00e0")}, String.class.getName(), 1);
        MBeanOperationInfo removePropertyValueOP = new MBeanOperationInfo(REMOVE_SYSTEM_PROPERTY, "Elimina una propriet\u00e0 di sistema", new MBeanParameterInfo[]{new MBeanParameterInfo("nome", String.class.getName(), "Nome della propriet\u00e0")}, String.class.getName(), 1);
        MBeanOperationInfo updatePropertyValueOP = new MBeanOperationInfo(UPDATE_SYSTEM_PROPERTY, "Aggiorna una propriet\u00e0 di sistema", new MBeanParameterInfo[]{new MBeanParameterInfo("nome", String.class.getName(), "Nome della propriet\u00e0"), new MBeanParameterInfo("valore", String.class.getName(), "Valore della propriet\u00e0")}, String.class.getName(), 1);
        MBeanOperationInfo insertPropertyValueOP = new MBeanOperationInfo(INSERT_SYSTEM_PROPERTY, "Crea una nuova propriet\u00e0 di sistema", new MBeanParameterInfo[]{new MBeanParameterInfo("nome", String.class.getName(), "Nome della propriet\u00e0"), new MBeanParameterInfo("valore", String.class.getName(), "Valore della propriet\u00e0")}, String.class.getName(), 1);
        MBeanConstructorInfo defaultConstructor = new MBeanConstructorInfo("Default Constructor", "Crea e inizializza una nuova istanza del MBean", null);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{propertiesVAR};
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{defaultConstructor};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{refreshPersistentConfigurazioneOP, readAllPropertiesOP, readOpenSPCoop2PropertiesOP, getPropertyValueOP, removePropertyValueOP, updatePropertyValueOP, insertPropertyValueOP};
        return new MBeanInfo(className, description, attributes, constructors, operations, null);
    }

    public String readAllSystemProperties() {
        try {
            String p = this.spm.readAllSystemProperties("\n");
            if (p == null || p.length() <= 0) {
                return "propriet\u00e0 non presenti";
            }
            return p;
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String readOpenSPCoop2SystemProperties() {
        try {
            String p = this.spm.readOpenSPCoop2SystemProperties("\n");
            if (p == null || p.length() <= 0) {
                return "propriet\u00e0 impostate tramite OpenSPCoop2 non trovate";
            }
            return p;
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String getSystemPropertyValue(String key) {
        try {
            String v = this.spm.getPropertyValue(key);
            if (v == null || v.length() <= 0) {
                return "propriet\u00e0 [" + key + "] non presente";
            }
            return "[" + key + "]=[" + v + "]";
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String removeSystemProperty(String key) {
        try {
            this.spm.removeProperty(key);
            return EFFETTUATO_SUCCESSO_INFO;
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String updateSystemProperty(String key, String value) {
        try {
            this.spm.updateProperty(key, value);
            return EFFETTUATO_SUCCESSO_INFO;
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String insertSystemProperty(String key, String value) {
        try {
            this.spm.insertProperty(key, value);
            return EFFETTUATO_SUCCESSO_INFO;
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }

    public String refreshPersistentConfigSystemProperty() {
        try {
            this.spm.updateSystemProperties();
            return EFFETTUATO_SUCCESSO;
        }
        catch (Throwable e) {
            this.log.error((Object)("Operazione non riuscita: " + e.getMessage()), e);
            return "Operazione non riuscita: " + e.getMessage();
        }
    }
}

