/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.handlers;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.handlers.ExitContext;
import org.openspcoop2.pdd.core.handlers.ExitHandler;
import org.openspcoop2.pdd.core.handlers.GeneratoreCasualeDate;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.InRequestContext;
import org.openspcoop2.pdd.core.handlers.InRequestHandler;
import org.openspcoop2.pdd.core.handlers.InRequestProtocolContext;
import org.openspcoop2.pdd.core.handlers.InRequestProtocolHandler;
import org.openspcoop2.pdd.core.handlers.InResponseContext;
import org.openspcoop2.pdd.core.handlers.InResponseHandler;
import org.openspcoop2.pdd.core.handlers.InitContext;
import org.openspcoop2.pdd.core.handlers.InitHandler;
import org.openspcoop2.pdd.core.handlers.IntegrationManagerRequestContext;
import org.openspcoop2.pdd.core.handlers.IntegrationManagerRequestHandler;
import org.openspcoop2.pdd.core.handlers.IntegrationManagerResponseContext;
import org.openspcoop2.pdd.core.handlers.IntegrationManagerResponseHandler;
import org.openspcoop2.pdd.core.handlers.OutRequestContext;
import org.openspcoop2.pdd.core.handlers.OutRequestHandler;
import org.openspcoop2.pdd.core.handlers.OutResponseContext;
import org.openspcoop2.pdd.core.handlers.OutResponseHandler;
import org.openspcoop2.pdd.core.handlers.PostOutRequestContext;
import org.openspcoop2.pdd.core.handlers.PostOutRequestHandler;
import org.openspcoop2.pdd.core.handlers.PostOutResponseContext;
import org.openspcoop2.pdd.core.handlers.PostOutResponseHandler;
import org.openspcoop2.pdd.core.handlers.PreInRequestContext;
import org.openspcoop2.pdd.core.handlers.PreInRequestHandler;
import org.openspcoop2.pdd.core.handlers.PreInResponseContext;
import org.openspcoop2.pdd.core.handlers.PreInResponseHandler;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierInRequestHandler;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierInRequestProtocolHandler;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierInResponseHandler;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierOutRequestHandler;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierOutResponseHandler;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierPostOutRequestHandler;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierPostOutResponseHandler;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierPreInRequestHandler;
import org.openspcoop2.pdd.core.handlers.notifier.NotifierPreInResponseHandler;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.resources.Loader;

public class GestoreHandlers {
    private static boolean initialize = false;
    private static OpenSPCoop2Properties properties = null;
    private static GeneratoreCasualeDate generatoreCasualeDati = null;
    private static InitHandler[] initHandlers = null;
    private static String[] tipiInitHandlers = null;
    private static ExitHandler[] exitHandlers = null;
    private static String[] tipiExitHandlers = null;
    private static PreInRequestHandler[] preInRequestHandlers = null;
    private static String[] tipiPreInRequestHandlers = null;
    private static InRequestHandler[] inRequestHandlers = null;
    private static String[] tipiInRequestHandlers = null;
    private static InRequestProtocolHandler[] inRequestProtocolHandlers = null;
    private static String[] tipiInRequestProtocolHandlers = null;
    private static OutRequestHandler[] outRequestHandlers = null;
    private static String[] tipiOutRequestHandlers = null;
    private static PostOutRequestHandler[] postOutRequestHandlers = null;
    private static String[] tipiPostOutRequestHandlers = null;
    private static PreInResponseHandler[] preInResponseHandlers = null;
    private static String[] tipiPreInResponseHandlers = null;
    private static InResponseHandler[] inResponseHandlers = null;
    private static String[] tipiInResponseHandlers = null;
    private static OutResponseHandler[] outResponseHandlers = null;
    private static String[] tipiOutResponseHandlers = null;
    private static PostOutResponseHandler[] postOutResponseHandlers = null;
    private static String[] tipiPostOutResponseHandlers = null;
    private static IntegrationManagerRequestHandler[] integrationManagerRequestHandlers = null;
    private static String[] tipiIntegrationManagerRequestHandlers = null;
    private static IntegrationManagerResponseHandler[] integrationManagerResponseHandlers = null;
    private static String[] tipiIntegrationManagerResponseHandlers = null;

    private static synchronized void initialize(MsgDiagnostico msgDiag, Logger logConsoleInit) {
        if (!initialize) {
            String classe;
            String tipo;
            int i;
            properties = OpenSPCoop2Properties.getInstance();
            ClassNameProperties classNameProperties = ClassNameProperties.getInstance();
            Loader loader = Loader.getInstance();
            if (properties.generazioneDateCasualiLogAbilitato() && !UniqueIdentifierManager.isGenerazioneUIDDisabilitata()) {
                generatoreCasualeDati = GeneratoreCasualeDate.getGeneratoreCasualeDate();
            }
            boolean printInfo = properties.isPrintInfoHandler();
            tipiInitHandlers = properties.getInitHandler();
            if (tipiInitHandlers != null) {
                initHandlers = new InitHandler[tipiInitHandlers.length];
                for (i = 0; i < tipiInitHandlers.length; ++i) {
                    try {
                        tipo = tipiInitHandlers[i];
                        classe = classNameProperties.getInitHandler(tipo);
                        GestoreHandlers.initHandlers[i] = (InitHandler)loader.newInstance(classe);
                        if (!printInfo) continue;
                        logConsoleInit.info((Object)("InitHandler di tipo [" + tipo + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione InitHandler [" + tipiInitHandlers[i] + "]");
                    }
                }
            }
            if ((tipiExitHandlers = properties.getExitHandler()) != null) {
                exitHandlers = new ExitHandler[tipiExitHandlers.length];
                for (i = 0; i < tipiExitHandlers.length; ++i) {
                    try {
                        tipo = tipiExitHandlers[i];
                        classe = classNameProperties.getExitHandler(tipo);
                        GestoreHandlers.exitHandlers[i] = (ExitHandler)loader.newInstance(classe);
                        if (!printInfo) continue;
                        logConsoleInit.info((Object)("ExitHandler di tipo [" + tipo + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione ExitHandler [" + tipiExitHandlers[i] + "]");
                    }
                }
            }
            tipiPreInRequestHandlers = properties.getPreInRequestHandler();
            if ((tipiPreInRequestHandlers = GestoreHandlers.updateNotifierCallback(tipiPreInRequestHandlers)) != null) {
                preInRequestHandlers = new PreInRequestHandler[tipiPreInRequestHandlers.length];
                for (i = 0; i < tipiPreInRequestHandlers.length; ++i) {
                    try {
                        tipo = tipiPreInRequestHandlers[i];
                        classe = null;
                        classe = "__notifier__".equals(tipo) ? NotifierPreInRequestHandler.class.getName() : classNameProperties.getPreInRequestHandler(tipo);
                        GestoreHandlers.preInRequestHandlers[i] = (PreInRequestHandler)loader.newInstance(classe);
                        if (!printInfo) continue;
                        logConsoleInit.info((Object)("PreInRequestHandler di tipo [" + tipo + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione PreInRequestHandler [" + tipiPreInRequestHandlers[i] + "]");
                    }
                }
            }
            tipiInRequestHandlers = properties.getInRequestHandler();
            if ((tipiInRequestHandlers = GestoreHandlers.updateNotifierCallback(tipiInRequestHandlers)) != null) {
                inRequestHandlers = new InRequestHandler[tipiInRequestHandlers.length];
                for (i = 0; i < tipiInRequestHandlers.length; ++i) {
                    try {
                        tipo = tipiInRequestHandlers[i];
                        classe = null;
                        classe = "__notifier__".equals(tipo) ? NotifierInRequestHandler.class.getName() : classNameProperties.getInRequestHandler(tipo);
                        GestoreHandlers.inRequestHandlers[i] = (InRequestHandler)loader.newInstance(classe);
                        if (!printInfo) continue;
                        logConsoleInit.info((Object)("InRequestHandler di tipo [" + tipo + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione InRequestHandler [" + tipiInRequestHandlers[i] + "]");
                    }
                }
            }
            tipiInRequestProtocolHandlers = properties.getInRequestProtocolHandler();
            if ((tipiInRequestProtocolHandlers = GestoreHandlers.updateNotifierCallback(tipiInRequestProtocolHandlers)) != null) {
                inRequestProtocolHandlers = new InRequestProtocolHandler[tipiInRequestProtocolHandlers.length];
                for (i = 0; i < tipiInRequestProtocolHandlers.length; ++i) {
                    try {
                        tipo = tipiInRequestProtocolHandlers[i];
                        classe = null;
                        classe = "__notifier__".equals(tipo) ? NotifierInRequestProtocolHandler.class.getName() : classNameProperties.getInRequestProtocolHandler(tipo);
                        GestoreHandlers.inRequestProtocolHandlers[i] = (InRequestProtocolHandler)loader.newInstance(classe);
                        if (!printInfo) continue;
                        logConsoleInit.info((Object)("InRequestProtocolHandler di tipo [" + tipo + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione InRequestProtocolHandler [" + tipiInRequestProtocolHandlers[i] + "]");
                    }
                }
            }
            tipiOutRequestHandlers = properties.getOutRequestHandler();
            if ((tipiOutRequestHandlers = GestoreHandlers.updateNotifierCallback(tipiOutRequestHandlers)) != null) {
                outRequestHandlers = new OutRequestHandler[tipiOutRequestHandlers.length];
                for (i = 0; i < tipiOutRequestHandlers.length; ++i) {
                    try {
                        tipo = tipiOutRequestHandlers[i];
                        classe = null;
                        classe = "__notifier__".equals(tipo) ? NotifierOutRequestHandler.class.getName() : classNameProperties.getOutRequestHandler(tipo);
                        GestoreHandlers.outRequestHandlers[i] = (OutRequestHandler)loader.newInstance(classe);
                        if (!printInfo) continue;
                        logConsoleInit.info((Object)("OutRequestHandler di tipo [" + tipo + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione OutRequestHandler [" + tipiOutRequestHandlers[i] + "]");
                    }
                }
            }
            tipiPostOutRequestHandlers = properties.getPostOutRequestHandler();
            if ((tipiPostOutRequestHandlers = GestoreHandlers.updateNotifierCallback(tipiPostOutRequestHandlers)) != null) {
                postOutRequestHandlers = new PostOutRequestHandler[tipiPostOutRequestHandlers.length];
                for (i = 0; i < tipiPostOutRequestHandlers.length; ++i) {
                    try {
                        tipo = tipiPostOutRequestHandlers[i];
                        classe = null;
                        classe = "__notifier__".equals(tipo) ? NotifierPostOutRequestHandler.class.getName() : classNameProperties.getPostOutRequestHandler(tipo);
                        GestoreHandlers.postOutRequestHandlers[i] = (PostOutRequestHandler)loader.newInstance(classe);
                        if (!printInfo) continue;
                        logConsoleInit.info((Object)("PostOutRequestHandler di tipo [" + tipo + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione PostOutRequestHandler [" + tipiPostOutRequestHandlers[i] + "]");
                    }
                }
            }
            tipiPreInResponseHandlers = properties.getPreInResponseHandler();
            if ((tipiPreInResponseHandlers = GestoreHandlers.updateNotifierCallback(tipiPreInResponseHandlers)) != null) {
                preInResponseHandlers = new PreInResponseHandler[tipiPreInResponseHandlers.length];
                for (i = 0; i < tipiPreInResponseHandlers.length; ++i) {
                    try {
                        tipo = tipiPreInResponseHandlers[i];
                        classe = null;
                        classe = "__notifier__".equals(tipo) ? NotifierPreInResponseHandler.class.getName() : classNameProperties.getPreInResponseHandler(tipo);
                        GestoreHandlers.preInResponseHandlers[i] = (PreInResponseHandler)loader.newInstance(classe);
                        if (!printInfo) continue;
                        logConsoleInit.info((Object)("PreInResponseHandler di tipo [" + tipo + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione PreInResponseHandler [" + tipiPreInResponseHandlers[i] + "]");
                    }
                }
            }
            tipiInResponseHandlers = properties.getInResponseHandler();
            if ((tipiInResponseHandlers = GestoreHandlers.updateNotifierCallback(tipiInResponseHandlers)) != null) {
                inResponseHandlers = new InResponseHandler[tipiInResponseHandlers.length];
                for (i = 0; i < tipiInResponseHandlers.length; ++i) {
                    try {
                        tipo = tipiInResponseHandlers[i];
                        classe = null;
                        classe = "__notifier__".equals(tipo) ? NotifierInResponseHandler.class.getName() : classNameProperties.getInResponseHandler(tipo);
                        GestoreHandlers.inResponseHandlers[i] = (InResponseHandler)loader.newInstance(classe);
                        if (!printInfo) continue;
                        logConsoleInit.info((Object)("InResponseHandler di tipo [" + tipo + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione InResponseHandler [" + tipiInResponseHandlers[i] + "]");
                    }
                }
            }
            tipiOutResponseHandlers = properties.getOutResponseHandler();
            if ((tipiOutResponseHandlers = GestoreHandlers.updateNotifierCallback(tipiOutResponseHandlers)) != null) {
                outResponseHandlers = new OutResponseHandler[tipiOutResponseHandlers.length];
                for (i = 0; i < tipiOutResponseHandlers.length; ++i) {
                    try {
                        tipo = tipiOutResponseHandlers[i];
                        classe = null;
                        classe = "__notifier__".equals(tipo) ? NotifierOutResponseHandler.class.getName() : classNameProperties.getOutResponseHandler(tipo);
                        GestoreHandlers.outResponseHandlers[i] = (OutResponseHandler)loader.newInstance(classe);
                        if (!printInfo) continue;
                        logConsoleInit.info((Object)("OutResponseHandler di tipo [" + tipo + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione OutResponseHandler [" + tipiOutResponseHandlers[i] + "]");
                    }
                }
            }
            tipiPostOutResponseHandlers = properties.getPostOutResponseHandler();
            if ((tipiPostOutResponseHandlers = GestoreHandlers.updateNotifierCallback(tipiPostOutResponseHandlers)) != null) {
                postOutResponseHandlers = new PostOutResponseHandler[tipiPostOutResponseHandlers.length];
                for (i = 0; i < tipiPostOutResponseHandlers.length; ++i) {
                    try {
                        tipo = tipiPostOutResponseHandlers[i];
                        classe = null;
                        classe = "__notifier__".equals(tipo) ? NotifierPostOutResponseHandler.class.getName() : classNameProperties.getPostOutResponseHandler(tipo);
                        GestoreHandlers.postOutResponseHandlers[i] = (PostOutResponseHandler)loader.newInstance(classe);
                        if (!printInfo) continue;
                        logConsoleInit.info((Object)("PostOutResponseHandler di tipo [" + tipo + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione PostOutResponseHandler [" + tipiPostOutResponseHandlers[i] + "]");
                    }
                }
            }
            if ((tipiIntegrationManagerRequestHandlers = properties.getIntegrationManagerRequestHandler()) != null) {
                integrationManagerRequestHandlers = new IntegrationManagerRequestHandler[tipiIntegrationManagerRequestHandlers.length];
                for (i = 0; i < tipiIntegrationManagerRequestHandlers.length; ++i) {
                    try {
                        tipo = tipiIntegrationManagerRequestHandlers[i];
                        classe = classNameProperties.getIntegrationManagerRequestHandler(tipo);
                        GestoreHandlers.integrationManagerRequestHandlers[i] = (IntegrationManagerRequestHandler)loader.newInstance(classe);
                        if (!printInfo) continue;
                        logConsoleInit.info((Object)("IntegrationManagerRequestHandler di tipo [" + tipo + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione IntegrationManagerRequestHandler [" + tipiIntegrationManagerRequestHandlers[i] + "]");
                    }
                }
            }
            if ((tipiIntegrationManagerResponseHandlers = properties.getIntegrationManagerResponseHandler()) != null) {
                integrationManagerResponseHandlers = new IntegrationManagerResponseHandler[tipiIntegrationManagerResponseHandlers.length];
                for (i = 0; i < tipiIntegrationManagerResponseHandlers.length; ++i) {
                    try {
                        tipo = tipiIntegrationManagerResponseHandlers[i];
                        classe = classNameProperties.getIntegrationManagerResponseHandler(tipo);
                        GestoreHandlers.integrationManagerResponseHandlers[i] = (IntegrationManagerResponseHandler)loader.newInstance(classe);
                        if (!printInfo) continue;
                        logConsoleInit.info((Object)("IntegrationManagerResponseHandler di tipo [" + tipo + "] correttamente inizializzato."));
                        continue;
                    }
                    catch (Exception e) {
                        msgDiag.logErroreGenerico(e, "Inizializzazione IntegrationManagerResponseHandler [" + tipiIntegrationManagerResponseHandlers[i] + "]");
                    }
                }
            }
        }
        initialize = true;
    }

    private static String[] updateNotifierCallback(String[] tipi) {
        String notifierInputStreamCallback = null;
        try {
            notifierInputStreamCallback = properties.getNotifierInputStreamCallback();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (notifierInputStreamCallback != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("__notifier__");
            if (tipi != null) {
                for (int i = 0; i < tipi.length; ++i) {
                    list.add(tipi[i]);
                }
            }
            return list.toArray(new String[1]);
        }
        return tipi;
    }

    public static void init(InitContext context, MsgDiagnostico msgDiag, Logger log) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag, log);
        }
        if (initHandlers != null) {
            for (int i = 0; i < initHandlers.length; ++i) {
                try {
                    initHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("InitHandler[" + initHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void exit(ExitContext context) {
        Logger log = null;
        if (context != null) {
            log = context.getLogCore() != null ? context.getLogCore() : context.getLogConsole();
        }
        if (initialize && exitHandlers != null) {
            for (int i = 0; i < exitHandlers.length; ++i) {
                try {
                    exitHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    if (log == null) continue;
                    log.error((Object)("ExitHandler[" + tipiExitHandlers[i] + "]"), (Throwable)e);
                }
            }
        }
    }

    public static void preInRequest(PreInRequestContext context, MsgDiagnostico msgDiag, Logger log) {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag, log);
        }
        if (preInRequestHandlers != null) {
            for (int i = 0; i < preInRequestHandlers.length; ++i) {
                try {
                    preInRequestHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "PreInRequestHandler[" + tipiPreInRequestHandlers[i] + "]");
                }
            }
        }
    }

    public static void inRequest(InRequestContext context, MsgDiagnostico msgDiag, Logger log) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag, log);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (inRequestHandlers != null) {
            for (int i = 0; i < inRequestHandlers.length; ++i) {
                try {
                    inRequestHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("InRequestHandler[" + tipiInRequestHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void inRequestProtocol(InRequestProtocolContext context, MsgDiagnostico msgDiag, Logger log) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag, log);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (inRequestProtocolHandlers != null) {
            for (int i = 0; i < inRequestProtocolHandlers.length; ++i) {
                try {
                    inRequestProtocolHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("inRequestProtocolHandlers[" + tipiInRequestProtocolHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void outRequest(OutRequestContext context, MsgDiagnostico msgDiag, Logger log) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag, log);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (outRequestHandlers != null) {
            for (int i = 0; i < outRequestHandlers.length; ++i) {
                try {
                    outRequestHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("OutRequestHandler[" + tipiOutRequestHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void postOutRequest(PostOutRequestContext context, MsgDiagnostico msgDiag, Logger log) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag, log);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (postOutRequestHandlers != null) {
            for (int i = 0; i < postOutRequestHandlers.length; ++i) {
                try {
                    postOutRequestHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("PostOutRequestHandler[" + tipiPostOutRequestHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void preInResponse(PreInResponseContext context, MsgDiagnostico msgDiag, Logger log) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag, log);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (preInResponseHandlers != null) {
            for (int i = 0; i < preInResponseHandlers.length; ++i) {
                try {
                    preInResponseHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("PreInResponseHandler[" + tipiPreInResponseHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void inResponse(InResponseContext context, MsgDiagnostico msgDiag, Logger log) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag, log);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (inResponseHandlers != null) {
            for (int i = 0; i < inResponseHandlers.length; ++i) {
                try {
                    inResponseHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("InResponseHandler[" + tipiInResponseHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void outResponse(OutResponseContext context, MsgDiagnostico msgDiag, Logger log) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag, log);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (outResponseHandlers != null) {
            for (int i = 0; i < outResponseHandlers.length; ++i) {
                try {
                    outResponseHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("OutResponseHandler[" + tipiOutResponseHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void postOutResponse(PostOutResponseContext context, MsgDiagnostico msgDiag, Logger log) {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag, log);
        }
        if (context.getDataElaborazioneMessaggio() == null) {
            context.setDataElaborazioneMessaggio(DateManager.getDate());
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            context.setDataElaborazioneMessaggio(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (postOutResponseHandlers != null) {
            for (int i = 0; i < postOutResponseHandlers.length; ++i) {
                try {
                    postOutResponseHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    msgDiag.logErroreGenerico(e, "PostOutResponseHandler[" + tipiPostOutResponseHandlers[i] + "]");
                }
            }
        }
        GestoreHandlers.rilasciaRisorseDemoMode((String)context.getPddContext().getObject("ID"));
    }

    public static void integrationManagerRequest(IntegrationManagerRequestContext context, MsgDiagnostico msgDiag, Logger log) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag, log);
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null && context.getDataRichiestaOperazione() != null) {
            context.setDataRichiestaOperazione(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
        }
        if (integrationManagerRequestHandlers != null) {
            for (int i = 0; i < integrationManagerRequestHandlers.length; ++i) {
                try {
                    integrationManagerRequestHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("IntegrationManagerRequestHandler[" + tipiIntegrationManagerRequestHandlers[i] + "]");
                    throw ex;
                }
            }
        }
    }

    public static void integrationManagerResponse(IntegrationManagerResponseContext context, MsgDiagnostico msgDiag, Logger log) throws HandlerException {
        if (!initialize) {
            GestoreHandlers.initialize(msgDiag, log);
        }
        if (properties.generazioneDateCasualiLogAbilitato() && context.getPddContext().getObject("ID") != null) {
            if (context.getDataRichiestaOperazione() != null) {
                context.setDataRichiestaOperazione(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
            }
            if (context.getDataCompletamentoOperazione() != null) {
                context.setDataCompletamentoOperazione(generatoreCasualeDati.getProssimaData((String)context.getPddContext().getObject("ID")));
            }
        }
        if (integrationManagerResponseHandlers != null) {
            for (int i = 0; i < integrationManagerResponseHandlers.length; ++i) {
                try {
                    integrationManagerResponseHandlers[i].invoke(context);
                    continue;
                }
                catch (Exception e) {
                    HandlerException ex = new HandlerException(e.getMessage(), e);
                    ex.setIdentitaHandler("IntegrationManagerResponseHandler[" + tipiIntegrationManagerResponseHandlers[i] + "]");
                    throw ex;
                }
            }
        }
        GestoreHandlers.rilasciaRisorseDemoMode((String)context.getPddContext().getObject("ID"));
    }

    private static void rilasciaRisorseDemoMode(String idCluster) {
        if (properties.generazioneDateCasualiLogAbilitato() && idCluster != null) {
            GeneratoreCasualeDate.getGeneratoreCasualeDate().releaseResource(idCluster);
        }
    }
}

