/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreRicezioneBusteDirectVM;
import org.openspcoop2.pdd.core.connettori.ConnettoreRicezioneContenutiApplicativiDirectVM;
import org.openspcoop2.pdd.core.connettori.ConnettoreRicezioneContenutiApplicativiHTTPtoSOAPDirectVM;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.utils.resources.TransportUtils;

public class ConnettoreUtils {
    public static String getAndReplaceLocationWithBustaValues(ConnettoreMsg connettoreMsg, Busta busta, Logger log) {
        String location = null;
        if (TipiConnettore.NULL.getNome().equals(connettoreMsg.getTipoConnettore())) {
            location = "openspcoop2://dev/null";
        } else if (TipiConnettore.NULLECHO.getNome().equals(connettoreMsg.getTipoConnettore())) {
            location = "openspcoop2://echo";
        } else if ("stresstest".equals(connettoreMsg.getTipoConnettore())) {
            location = "openspcoop2://stresstest";
        } else if ("vmPA".equals(connettoreMsg.getTipoConnettore())) {
            ConnettoreRicezioneBusteDirectVM c = new ConnettoreRicezioneBusteDirectVM();
            try {
                c.validate(connettoreMsg);
                c.buildLocation(connettoreMsg.getConnectorProperties(), false);
            }
            catch (Exception e) {
                log.error((Object)("Errore durante la costruzione della location: " + e.getMessage()), (Throwable)e);
            }
            location = c.getLocation();
        } else if ("vmPD".equals(connettoreMsg.getTipoConnettore())) {
            ConnettoreRicezioneContenutiApplicativiDirectVM c = new ConnettoreRicezioneContenutiApplicativiDirectVM();
            try {
                c.validate(connettoreMsg);
                c.buildLocation(connettoreMsg.getConnectorProperties(), false);
            }
            catch (Exception e) {
                log.error((Object)("Errore durante la costruzione della location: " + e.getMessage()), (Throwable)e);
            }
            location = c.getLocation();
        } else if ("vmPDtoSOAP".equals(connettoreMsg.getTipoConnettore())) {
            ConnettoreRicezioneContenutiApplicativiHTTPtoSOAPDirectVM c = new ConnettoreRicezioneContenutiApplicativiHTTPtoSOAPDirectVM();
            try {
                c.validate(connettoreMsg);
                c.buildLocation(connettoreMsg.getConnectorProperties(), false);
            }
            catch (Exception e) {
                log.error((Object)("Errore durante la costruzione della location: " + e.getMessage()), (Throwable)e);
            }
            location = c.getLocation();
        } else if (connettoreMsg.getConnectorProperties().get("location") != null) {
            location = connettoreMsg.getConnectorProperties().get("location");
        }
        if (location != null && !location.equals("")) {
            location = location.replace("#TipoServizio", busta.getTipoServizio());
            location = location.replace("#Servizio", busta.getServizio());
            if (busta.getAzione() != null) {
                location = location.replace("#Azione", busta.getAzione());
            }
            connettoreMsg.getConnectorProperties().put("location", location);
        }
        return location;
    }

    public static String buildLocationWithURLBasedParameter(Properties propertiesURLBased, String location) {
        return TransportUtils.buildLocationWithURLBasedParameter((Properties)propertiesURLBased, (String)location, (Logger)OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
    }

    public static String limitLocation255Character(String location) {
        return TransportUtils.limitLocation255Character((String)location);
    }
}

