/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.OutputStream;
import java.sql.Connection;
import java.util.Random;
import java.util.Vector;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;

public class ConnettoreStresstest
extends ConnettoreBase {
    private Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
    public static final String TIPO = "stresstest";
    public static final String LOCATION = "openspcoop2://stresstest";
    private static final String SOAP_ENVELOPE_RISPOSTA = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Header>@HDR@</soapenv:Header>";
    private static final String SOAP_ENVELOPE_RISPOSTA_END = "<soapenv:Body><prova>test</prova></soapenv:Body></soapenv:Envelope>";
    private Resource resource = null;
    private DBManager dbManager = DBManager.getInstance();
    private OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(ConnettoreMsg request) {
        this.outRequestContext = request.getOutRequestContext();
        this.msgDiagnostico = request.getMsgDiagnostico();
        this.codice = 200;
        try {
            NullOutputStream nullOutputStream = new NullOutputStream();
            request.getRequestMessage().writeTo((OutputStream)nullOutputStream, true);
            nullOutputStream.flush();
            nullOutputStream.close();
            this.postOutRequest();
            if (request.getConnectorProperties() != null) {
                String max = request.getConnectorProperties().get("sleepMax");
                String min = request.getConnectorProperties().get("sleepMin");
                if (max != null) {
                    Random r;
                    int sleep;
                    int maxSleep = Integer.parseInt(max);
                    int minSleep = 0;
                    if (min != null) {
                        minSleep = Integer.parseInt(min);
                    }
                    if ((sleep = minSleep + (r = new Random()).nextInt(maxSleep - minSleep)) > 1000) {
                        int count = sleep / 1000;
                        int resto = sleep % 1000;
                        this.log.info((Object)("sleep " + sleep + "ms ..."));
                        for (int i = 0; i < count; ++i) {
                            try {
                                Thread.sleep(1000L);
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        try {
                            Thread.sleep(resto);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.log.info((Object)("sleep " + sleep + "ms terminated"));
                    } else {
                        this.log.info((Object)("sleep " + sleep + "ms ..."));
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.log.info((Object)("sleep " + sleep + "ms terminated"));
                    }
                }
            }
            this.preInResponse();
            NotifierInputStreamParams notifierInputStreamParams = null;
            if (this.preInResponseContext != null) {
                notifierInputStreamParams = this.preInResponseContext.getNotifierInputStreamParams();
            }
            if (!(!org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals(request.getBusta().getProfiloDiCollaborazione()) || request.getBusta().isConfermaRicezione() && this.properties.isGestioneRiscontri("standard"))) {
                boolean min = true;
                return min;
            }
            String protocolHeader = this.buildProtocolHeader(request);
            String messaggio = SOAP_ENVELOPE_RISPOSTA.replace("@HDR@", protocolHeader) + SOAP_ENVELOPE_RISPOSTA_END;
            byte[] messaggioArray = messaggio.getBytes();
            this.responseMsg = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(SOAPVersion.SOAP11, messaggioArray, notifierInputStreamParams);
            if (this.responseMsg != null) {
                this.contentLength = messaggioArray.length;
            }
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.log.error((Object)"Riscontrato errore durante l'echo del msg soap", (Throwable)e);
            this.errore = "Riscontrato errore durante l'echo del msg soap:" + e.getMessage();
            boolean bl = false;
            return bl;
        }
        finally {
            this.dbManager.releaseResource(this.properties.getIdentitaPortaDefault(this.getProtocolFactory().getProtocol()), "ConnettoreStresstest", this.resource);
        }
        return true;
    }

    @Override
    public String getLocation() {
        return LOCATION;
    }

    private String buildProtocolHeader(ConnettoreMsg request) throws Exception {
        Busta bustaRichiesta = request.getBusta();
        if ("spcoop".equals(bustaRichiesta.getProtocollo())) {
            return this.buildSPCoopProtocolHeader(request);
        }
        return "";
    }

    private String buildSPCoopProtocolHeader(ConnettoreMsg request) throws Exception {
        Busta bustaRichiesta = request.getBusta();
        StatefulMessage state = new StatefulMessage(null, this.log);
        Object id = this.getPddContext().getObject("ID");
        String idTransazione = null;
        if (id != null) {
            idTransazione = (String)id;
        }
        StringBuffer protocolHeader = new StringBuffer();
        if (bustaRichiesta != null && bustaRichiesta.sizeListaEccezioni() == 0 && !"ConsegnaContenutiApplicativi".equals(request.getIdModulo())) {
            String idRiscontro = null;
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(bustaRichiesta.getProtocollo());
            ITraduttore traduttore = protocolFactory.createTraduttore();
            protocolHeader.append("<eGov_IT:Intestazione SOAP_ENV:actor=\"http://www.cnipa.it/eGov_it/portadominio\" SOAP_ENV:mustUnderstand=\"1\" xmlns:SOAP_ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:eGov_IT=\"http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/\"><eGov_IT:IntestazioneMessaggio>");
            protocolHeader.append("<eGov_IT:Mittente><eGov_IT:IdentificativoParte tipo=\"" + bustaRichiesta.getTipoDestinatario() + "\">" + bustaRichiesta.getDestinatario() + "</eGov_IT:IdentificativoParte></eGov_IT:Mittente>");
            protocolHeader.append("<eGov_IT:Destinatario><eGov_IT:IdentificativoParte tipo=\"" + bustaRichiesta.getTipoMittente() + "\">" + bustaRichiesta.getMittente() + "</eGov_IT:IdentificativoParte></eGov_IT:Destinatario>");
            if (bustaRichiesta.getProfiloDiCollaborazione() != null) {
                if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals(bustaRichiesta.getProfiloDiCollaborazione()) && bustaRichiesta.isConfermaRicezione() && this.properties.isGestioneRiscontri("standard")) {
                    protocolHeader.append("<eGov_IT:ProfiloCollaborazione>" + traduttore.toString(bustaRichiesta.getProfiloDiCollaborazione()) + "</eGov_IT:ProfiloCollaborazione>");
                    idRiscontro = bustaRichiesta.getID();
                } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) && bustaRichiesta.getRiferimentoMessaggio() == null) {
                    protocolHeader.append("<eGov_IT:ProfiloCollaborazione tipo=\"" + bustaRichiesta.getTipoServizio() + "\" servizioCorrelato=\"" + bustaRichiesta.getServizio() + "Correlato" + "\" >" + traduttore.toString(bustaRichiesta.getProfiloDiCollaborazione()) + "</eGov_IT:ProfiloCollaborazione>");
                } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(bustaRichiesta.getProfiloDiCollaborazione()) && bustaRichiesta.getRiferimentoMessaggio() == null) {
                    try {
                        this.resource = this.dbManager.getResource(this.properties.getIdentitaPortaDefault(this.getProtocolFactory().getProtocol()), "ConnettoreStresstest", idTransazione);
                    }
                    catch (Exception e) {
                        throw new Exception("Risorsa non ottenibile", e);
                    }
                    if (this.resource == null) {
                        throw new Exception("Risorsa is null");
                    }
                    if (this.resource.getResource() == null) {
                        throw new Exception("Connessione is null");
                    }
                    Connection connectionDB = (Connection)this.resource.getResource();
                    state.setConnectionDB(connectionDB);
                    RepositoryBuste repositoryBuste = new RepositoryBuste((IState)state, true, this.getProtocolFactory());
                    repositoryBuste.registraBustaIntoInBox(bustaRichiesta, new Vector(), OpenSPCoop2Properties.getInstance().getRepositoryIntervalloScadenzaMessaggi());
                    Integrazione infoIntegrazione = new Integrazione();
                    infoIntegrazione.setIdModuloInAttesa(null);
                    repositoryBuste.aggiornaInfoIntegrazioneIntoInBox(bustaRichiesta.getID(), infoIntegrazione);
                    ProfiloDiCollaborazione profiloCollaborazione = new ProfiloDiCollaborazione((IState)state, this.getProtocolFactory());
                    profiloCollaborazione.asincronoSimmetrico_registraRichiestaRicevuta(bustaRichiesta.getID(), bustaRichiesta.getCollaborazione(), bustaRichiesta.getTipoServizioCorrelato(), bustaRichiesta.getServizioCorrelato(), true, this.properties.getRepositoryIntervalloScadenzaMessaggi());
                    try {
                        connectionDB.setAutoCommit(false);
                        state.executePreparedStatement();
                        connectionDB.commit();
                        connectionDB.setAutoCommit(true);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Riscontrato errore durante la gestione transazione del DB per la richiesta: " + e.getMessage()));
                        try {
                            connectionDB.rollback();
                        }
                        catch (Exception er) {
                            // empty catch block
                        }
                        try {
                            connectionDB.setAutoCommit(true);
                        }
                        catch (Exception er) {
                            // empty catch block
                        }
                        state.closePreparedStatement();
                    }
                    protocolHeader.append("<eGov_IT:ProfiloCollaborazione>" + traduttore.toString(bustaRichiesta.getProfiloDiCollaborazione()) + "</eGov_IT:ProfiloCollaborazione>");
                } else {
                    protocolHeader.append("<eGov_IT:ProfiloCollaborazione>" + traduttore.toString(bustaRichiesta.getProfiloDiCollaborazione()) + "</eGov_IT:ProfiloCollaborazione>");
                }
            }
            if (bustaRichiesta.getTipoServizio() != null && bustaRichiesta.getServizio() != null) {
                protocolHeader.append("<eGov_IT:Servizio tipo=\"" + bustaRichiesta.getTipoServizio() + "\">" + bustaRichiesta.getServizio() + "</eGov_IT:Servizio>");
            }
            if (bustaRichiesta.getAzione() != null) {
                protocolHeader.append("<eGov_IT:Azione>" + bustaRichiesta.getAzione() + "</eGov_IT:Azione>");
            }
            protocolHeader.append("<eGov_IT:Messaggio>");
            String dominio = null;
            if (request.getConnectorProperties() != null) {
                dominio = request.getConnectorProperties().get("identificativo-porta");
            }
            if (dominio == null) {
                dominio = bustaRichiesta.getDestinatario() + "SPCoopIT";
            }
            String idBustaRisposta = null;
            Imbustamento imbustatore = new Imbustamento(this.getProtocolFactory());
            idBustaRisposta = imbustatore.buildID((IState)state, new IDSoggetto(bustaRichiesta.getTipoDestinatario(), bustaRichiesta.getDestinatario(), dominio), null, this.properties.getGestioneSerializableDB_AttesaAttiva(), this.properties.getGestioneSerializableDB_CheckInterval(), Boolean.FALSE);
            protocolHeader.append("<eGov_IT:Identificatore>" + idBustaRisposta + "</eGov_IT:Identificatore>");
            String oraS = traduttore.getDate_protocolFormat(bustaRichiesta.getOraRegistrazione());
            protocolHeader.append("<eGov_IT:OraRegistrazione tempo=\"" + traduttore.toString(bustaRichiesta.getTipoOraRegistrazione()) + "\">" + oraS + "</eGov_IT:OraRegistrazione>");
            protocolHeader.append("<eGov_IT:RiferimentoMessaggio>" + bustaRichiesta.getID() + "</eGov_IT:RiferimentoMessaggio>");
            protocolHeader.append("</eGov_IT:Messaggio>");
            protocolHeader.append("</eGov_IT:IntestazioneMessaggio>");
            if (idRiscontro != null) {
                protocolHeader.append("<eGov_IT:ListaRiscontri><eGov_IT:Riscontro><eGov_IT:Identificatore>" + idRiscontro + "</eGov_IT:Identificatore>" + "<eGov_IT:OraRegistrazione tempo=\"" + traduttore.toString(bustaRichiesta.getTipoOraRegistrazione()) + "\">" + oraS + "</eGov_IT:OraRegistrazione>" + "</eGov_IT:Riscontro> </eGov_IT:ListaRiscontri>");
            }
            protocolHeader.append("</eGov_IT:Intestazione>");
        }
        return protocolHeader.toString();
    }
}

