/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.util.Hashtable;
import java.util.Properties;
import javax.xml.soap.SOAPElement;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.handlers.OutRequestContext;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.engine.builder.Sbustamento;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.state.IState;

public class ConnettoreMsg {
    private String tipoConnector;
    private OpenSPCoop2Message request;
    private Hashtable<String, String> properties;
    private boolean sbustamentoSoap;
    private boolean sbustamentoInformazioniProtocollo;
    private Properties propertiesTrasporto;
    private Properties propertiesUrlBased;
    private String tipoAutenticazione;
    private Credenziali credenziali;
    private Busta busta;
    private String idModulo;
    private IProtocolFactory protocolFactory;
    private boolean gestioneManifest = false;
    private ProprietaManifestAttachments proprietaManifestAttachments = null;
    private SOAPElement soapProtocolInfo = null;
    private boolean localForward = false;
    private boolean isRichiesta = true;
    private OutRequestContext outRequestContext;
    private MsgDiagnostico msgDiagnostico;
    private IState state;
    private boolean sbustamentoProtocolInfoEffettuato = false;

    public ConnettoreMsg() {
    }

    public ConnettoreMsg(String type, OpenSPCoop2Message r, Property[] p) {
        Hashtable<String, String> pr = new Hashtable<String, String>();
        if (p != null) {
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == null) continue;
                pr.put(p[i].getNome(), p[i].getValore());
            }
        }
        this.tipoConnector = type;
        this.request = r;
        this.properties = pr;
    }

    public ConnettoreMsg(String type, OpenSPCoop2Message r, Hashtable<String, String> p) {
        this(type, r, p, false, null, null, true);
    }

    public ConnettoreMsg(String type, OpenSPCoop2Message r, Property[] p, boolean sb, String tipoAuth, Credenziali cr, boolean isRichiesta) {
        this(type, r, new Hashtable<String, String>(), sb, tipoAuth, cr, isRichiesta);
        Hashtable<String, String> pr = new Hashtable<String, String>();
        if (p != null) {
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == null) continue;
                pr.put(p[i].getNome(), p[i].getValore());
            }
        }
        this.properties = pr;
    }

    public ConnettoreMsg(String type, OpenSPCoop2Message r, Hashtable<String, String> p, boolean sb, String tipoAuth, Credenziali cr, boolean isRichiesta) {
        this.tipoConnector = type;
        this.request = r;
        this.properties = p;
        this.sbustamentoSoap = sb;
        this.tipoAutenticazione = tipoAuth;
        this.credenziali = cr;
    }

    public void setTipoConnettore(String tipo) {
        this.tipoConnector = tipo;
    }

    public void setRequestMessage(OpenSPCoop2Message r) {
        this.request = r;
    }

    public void setConnectorProperties(Hashtable<String, String> p) {
        this.properties = p;
    }

    public void setSbustamentoSOAP(boolean sb) {
        this.sbustamentoSoap = sb;
    }

    public void setAutenticazione(String tipoAuth) {
        this.tipoAutenticazione = tipoAuth;
    }

    public void setCredenziali(Credenziali cr) {
        this.credenziali = cr;
    }

    public String getTipoConnettore() {
        return this.tipoConnector;
    }

    public OpenSPCoop2Message getRequestMessage() throws ProtocolException {
        if (!this.localForward && this.sbustamentoInformazioniProtocollo && !this.sbustamentoProtocolInfoEffettuato) {
            Sbustamento sbustatore = new Sbustamento(this.protocolFactory);
            this.soapProtocolInfo = sbustatore.sbustamento(this.state, this.request, this.busta, this.isRichiesta, this.gestioneManifest, this.proprietaManifestAttachments);
            this.sbustamentoProtocolInfoEffettuato = true;
        }
        return this.request;
    }

    public Hashtable<String, String> getConnectorProperties() {
        return this.properties;
    }

    public boolean isSbustamentoSOAP() {
        return this.sbustamentoSoap;
    }

    public String getAutenticazione() {
        return this.tipoAutenticazione;
    }

    public Credenziali getCredenziali() {
        return this.credenziali;
    }

    public Properties getPropertiesTrasporto() {
        return this.propertiesTrasporto;
    }

    public Properties getPropertiesUrlBased() {
        return this.propertiesUrlBased;
    }

    public void setPropertiesTrasporto(Properties propertiesTrasporto) {
        this.propertiesTrasporto = propertiesTrasporto;
    }

    public void setPropertiesUrlBased(Properties propertiesUrlBased) {
        this.propertiesUrlBased = propertiesUrlBased;
    }

    public Busta getBusta() {
        return this.busta;
    }

    public void setBusta(Busta busta) {
        this.busta = busta;
    }

    public String getIdModulo() {
        return this.idModulo;
    }

    public void setIdModulo(String idModulo) {
        this.idModulo = idModulo;
    }

    public boolean isSbustamentoInformazioniProtocollo() {
        return this.sbustamentoInformazioniProtocollo;
    }

    public void setSbustamentoInformazioniProtocollo(boolean sbustamentoInformazioniProtocollo) {
        this.sbustamentoInformazioniProtocollo = sbustamentoInformazioniProtocollo;
    }

    public boolean isRichiesta() {
        return this.isRichiesta;
    }

    public void setRichiesta(boolean isRichiesta) {
        this.isRichiesta = isRichiesta;
    }

    public void setProtocolFactory(IProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public void setGestioneManifest(boolean gestioneManifest) {
        this.gestioneManifest = gestioneManifest;
    }

    public void setProprietaManifestAttachments(ProprietaManifestAttachments proprietaManifestAttachments) {
        this.proprietaManifestAttachments = proprietaManifestAttachments;
    }

    public SOAPElement getSoapProtocolInfo() {
        return this.soapProtocolInfo;
    }

    public boolean isLocalForward() {
        return this.localForward;
    }

    public void setLocalForward(boolean localForward) {
        this.localForward = localForward;
    }

    public OutRequestContext getOutRequestContext() {
        return this.outRequestContext;
    }

    public void setOutRequestContext(OutRequestContext outRequestContext) {
        this.outRequestContext = outRequestContext;
    }

    public MsgDiagnostico getMsgDiagnostico() {
        return this.msgDiagnostico;
    }

    public void setMsgDiagnostico(MsgDiagnostico msgDiagnostico) {
        this.msgDiagnostico = msgDiagnostico;
    }

    public IState getState() {
        return this.state;
    }

    public void setState(IState state) {
        this.state = state;
    }
}

