/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.SoapUtils;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreJMSProperties;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.IConnettoreJMSSetProperties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.utils.resources.Loader;

public class ConnettoreJMS
extends ConnettoreBase {
    private static final String QUEUE = "queue";
    private static final String TOPIC = "topic";
    private static final String TEXT_MESSAGE = "TextMessage";
    private static final String BYTES_MESSAGE = "BytesMessage";
    private static final String LOCATIONS_CACHE_ABILITATA = "abilitata";
    private static final String LOCATIONS_CACHE_DISABILITATA = "disabilitata";
    private static Hashtable<String, Destination> locations = new Hashtable();
    private Logger log = null;
    private OpenSPCoop2Message requestMsg;
    private Hashtable<String, String> properties;
    private boolean sbustamentoSoap;
    private Properties propertiesTrasporto;
    private Busta busta;
    private String tipoConnettore;
    private String idMessaggio;
    private Credenziali credenziali;
    private boolean debug = false;
    private int acknowledgeModeSessione = 1;
    private Loader loader = null;

    @Override
    public boolean send(ConnettoreMsg request) {
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        this.outRequestContext = request.getOutRequestContext();
        this.msgDiagnostico = request.getMsgDiagnostico();
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        this.loader = Loader.getInstance();
        try {
            this.requestMsg = request.getRequestMessage();
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.log.error((Object)("Errore durante la lettura del messaggio da consegnare: " + e.getMessage()), (Throwable)e);
            this.errore = "Errore durante la lettura del messaggio da consegnare: " + e.getMessage();
            return false;
        }
        this.properties = request.getConnectorProperties();
        this.sbustamentoSoap = request.isSbustamentoSOAP();
        this.propertiesTrasporto = request.getPropertiesTrasporto();
        this.busta = request.getBusta();
        if (this.busta != null) {
            this.idMessaggio = this.busta.getID();
        }
        this.credenziali = request.getCredenziali();
        if (this.requestMsg == null) {
            this.errore = "Messaggio da consegnare is Null (Msg)";
            return false;
        }
        if (this.properties == null) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.size() == 0) {
            this.errore = "Proprieta' del connettore non definite";
        }
        this.tipoConnettore = request.getTipoConnettore();
        if (this.properties.get("location") == null) {
            this.errore = "Proprieta' 'location' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (this.properties.get("tipo") == null) {
            this.errore = "Proprieta' 'tipo' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (!this.properties.get("tipo").equalsIgnoreCase(QUEUE) && !this.properties.get("tipo").equalsIgnoreCase(TOPIC)) {
            this.errore = "Proprieta' 'tipo' non correttamente fornita per il connettore [" + request.getTipoConnettore() + "] \n(Valori possibili sono 'queue' o 'topic')";
            return false;
        }
        if (this.properties.get("locations-cache") != null && !this.properties.get("locations-cache").equalsIgnoreCase(LOCATIONS_CACHE_ABILITATA) && !this.properties.get("locations-cache").equalsIgnoreCase(LOCATIONS_CACHE_DISABILITATA)) {
            this.errore = "Proprieta' 'locations-cache' non correttamente fornita per il connettore [" + request.getTipoConnettore() + "] \n(Valori possibili sono 'abilitata' o 'disabilitata')";
            return false;
        }
        if (this.properties.get("connection-factory") == null) {
            this.errore = "Proprieta' 'connection-factory' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (this.properties.get("send-as") == null) {
            this.errore = "Proprieta' 'send-as' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (!this.properties.get("send-as").equalsIgnoreCase(TEXT_MESSAGE) && !this.properties.get("send-as").equalsIgnoreCase(BYTES_MESSAGE)) {
            this.errore = "Proprieta' 'send-as' non correttamente fornita per il connettore [" + request.getTipoConnettore() + "] \n(Valori possibili sono 'TextMessage' o 'BytesMessage')";
            return false;
        }
        if (this.properties.get("acknowledgeMode") != null) {
            if ("AUTO_ACKNOWLEDGE".equals(this.properties.get("acknowledgeMode"))) {
                this.acknowledgeModeSessione = 1;
            } else if ("CLIENT_ACKNOWLEDGE".equals(this.properties.get("acknowledgeMode"))) {
                this.acknowledgeModeSessione = 2;
            } else if ("DUPS_OK_ACKNOWLEDGE".equals(this.properties.get("acknowledgeMode"))) {
                this.acknowledgeModeSessione = 3;
            } else {
                this.log.error((Object)"Tipo di acknowledgeModeSessione non conosciuto (viene utilizzato il default:AUTO_ACKNOWLEDGE)");
            }
        }
        if (this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        return this.sendJMS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendJMS() {
        boolean bl;
        Connection qc = null;
        Session qs = null;
        ConnectionFactory qcf = null;
        MessageProducer sender = null;
        Queue queueDestination = null;
        Topic topicDestination = null;
        InitialContext ctxJMS = null;
        InitialContext ctxLocalPool = null;
        try {
            String connectionFactory;
            ConnettoreJMSProperties overwriteProperties;
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] trasformazione del messaggio in byte..."));
            }
            byte[] consegna = null;
            if (this.sbustamentoSoap) {
                consegna = SoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)this.requestMsg);
            } else {
                ByteArrayOutputStream reqBuffer = new ByteArrayOutputStream();
                this.requestMsg.writeTo((OutputStream)reqBuffer, true);
                consegna = reqBuffer.toByteArray();
                reqBuffer.close();
            }
            if (consegna == null) {
                this.errore = "Errore avvenuto durante la consegna JMS: Trasformazione del messaggio in byte[] non riuscita";
                boolean reqBuffer = false;
                return reqBuffer;
            }
            if (this.debug) {
                try {
                    String contentTypeRichiesta = this.requestMsg.getContentType();
                    this.log.debug((Object)("[" + this.idMessaggio + "] Messaggio inviato (ContentType:" + contentTypeRichiesta + ") :\n" + new String(consegna)));
                }
                catch (Exception e) {
                    this.log.error((Object)("[" + this.idMessaggio + "] DebugMode, log del messaggio inviato non riuscito"), (Throwable)e);
                }
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] raccolta credenziali..."));
            }
            String user = null;
            String password = null;
            if (this.credenziali != null) {
                user = this.credenziali.getUsername();
                password = this.credenziali.getPassword();
            } else {
                user = this.properties.get("user");
                password = this.properties.get("password");
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] creazione jndi context ed eventuale pool-local-context..."));
            }
            Properties propertiesJMS = new Properties();
            Properties propertiesLocalPool = new Properties();
            if (user != null && password != null) {
                propertiesJMS.put("java.naming.security.principal", user);
                propertiesJMS.put("java.naming.security.credentials", password);
                propertiesLocalPool.put("java.naming.security.principal", user);
                propertiesLocalPool.put("java.naming.security.credentials", password);
            }
            Enumeration<String> enumCTX = this.properties.keys();
            while (enumCTX.hasMoreElements()) {
                String key = enumCTX.nextElement();
                String value = this.properties.get(key);
                if (key.startsWith("context-")) {
                    key = key.substring("context-".length());
                    propertiesJMS.put(key, value);
                    continue;
                }
                if (key.startsWith("pool-")) {
                    key = key.substring("pool-".length());
                    propertiesLocalPool.put(key, value);
                    continue;
                }
                if (!key.startsWith("lookupDestination-")) continue;
                if (!((key = key.substring("lookupDestination-".length())).indexOf("#Azione") == -1 && value.indexOf("#Azione") == -1 || this.busta != null && this.busta.getAzione() != null)) {
                    throw new Exception("Proprieta' 'location' definita dinamicamente (#Azione), ma busta e Azione non definita per questo Connettore[" + this.tipoConnettore + "]");
                }
                if (!(key.indexOf("#Servizio") == -1 && value.indexOf("#Servizio") == -1 || this.busta != null && this.busta.getServizio() != null)) {
                    throw new Exception("Proprieta' 'location' definita dinamicamente (#Servizio), ma busta e Servizio non definito per questo Connettore[" + this.tipoConnettore + "]");
                }
                if (!(key.indexOf("#TipoServizio") == -1 && value.indexOf("#TipoServizio") == -1 || this.busta != null && this.busta.getTipoServizio() != null)) {
                    throw new Exception("Proprieta' 'location' definita dinamicamente (#TipoServizio), ma busta e TipoServizio non definito per questo Connettore[" + this.tipoConnettore + "]");
                }
                if (this.busta.getAzione() != null) {
                    key = key.replace("#Azione", this.busta.getAzione());
                }
                if (this.busta.getServizio() != null) {
                    key = key.replace("#Servizio", this.busta.getServizio());
                }
                if (this.busta.getTipoServizio() != null) {
                    key = key.replace("#TipoServizio", this.busta.getTipoServizio());
                }
                if (this.busta.getAzione() != null) {
                    value = value.replace("#Azione", this.busta.getAzione());
                }
                if (this.busta.getServizio() != null) {
                    value = value.replace("#Servizio", this.busta.getServizio());
                }
                if (this.busta.getTipoServizio() != null) {
                    value = value.replace("#TipoServizio", this.busta.getTipoServizio());
                }
                propertiesJMS.put(key, value);
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] creazione jndi context ed eventuale pool-local-context, Overwrite da file properties..."));
            }
            if ((overwriteProperties = ConnettoreJMSProperties.getInstance()) != null) {
                Hashtable<String, IDServizio> idServizi = overwriteProperties.getIDServizi_Pubblicazione();
                String indiceServizio = null;
                Enumeration<String> e = idServizi.keys();
                while (e.hasMoreElements()) {
                    String keyElement;
                    IDServizio match;
                    if (this.busta == null || (match = idServizi.get(keyElement = e.nextElement())) == null || match.getServizio() == null || match.getTipoServizio() == null || match.getSoggettoErogatore() == null || match.getSoggettoErogatore().getNome() == null || match.getSoggettoErogatore().getTipo() == null || !match.getServizio().equals(this.busta.getServizio()) || !match.getTipoServizio().equals(this.busta.getTipoServizio()) || !match.getSoggettoErogatore().getNome().equals(this.busta.getDestinatario()) || !match.getSoggettoErogatore().getTipo().equals(this.busta.getTipoDestinatario())) continue;
                    indiceServizio = keyElement;
                    break;
                }
                if (indiceServizio != null) {
                    Properties propertiesPoolOver;
                    Properties propertiesContextOver = overwriteProperties.getJNDIContext_Configurazione(indiceServizio);
                    if (propertiesContextOver != null) {
                        Enumeration<Object> el = propertiesContextOver.keys();
                        while (el.hasMoreElements()) {
                            String keyP = (String)el.nextElement();
                            propertiesJMS.setProperty(keyP, propertiesContextOver.getProperty(keyP));
                        }
                    }
                    if ((propertiesPoolOver = overwriteProperties.getJNDIPool_Configurazione(indiceServizio)) != null) {
                        Enumeration<Object> el = propertiesPoolOver.keys();
                        while (el.hasMoreElements()) {
                            String keyP = (String)el.nextElement();
                            propertiesLocalPool.setProperty(keyP, propertiesPoolOver.getProperty(keyP));
                        }
                    }
                }
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] impostazione contesto..."));
            }
            ctxJMS = new InitialContext(propertiesJMS);
            if (propertiesLocalPool.size() > 0) {
                ctxLocalPool = new InitialContext(propertiesLocalPool);
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] lookup connection factory..."));
            }
            if ((connectionFactory = this.properties.get("connection-factory")) != null) {
                connectionFactory = connectionFactory.trim();
            }
            if (ctxLocalPool != null) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] lookup connection factory da ctxLocalPool..."));
                }
                qcf = (ConnectionFactory)ctxLocalPool.lookup(connectionFactory);
            } else {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] lookup connection factory da ctxJMS..."));
                }
                qcf = (ConnectionFactory)ctxJMS.lookup(connectionFactory);
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] lookup coda/topic..."));
            }
            this.location = this.properties.get("location");
            boolean findDestinationInCache = false;
            if (LOCATIONS_CACHE_ABILITATA.equals(this.properties.get("locations-cache"))) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] lookup coda/topic in cache [" + locations.containsKey(this.location) + "]..."));
                }
                if (locations.containsKey(this.location)) {
                    if (QUEUE.equalsIgnoreCase(this.properties.get("tipo"))) {
                        queueDestination = (Queue)locations.get(this.location);
                    } else {
                        topicDestination = (Topic)locations.get(this.location);
                    }
                    findDestinationInCache = true;
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idMessaggio + "] lookup coda/topic in cache effettuata con successo..."));
                    }
                }
            }
            if (!findDestinationInCache) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] lookup coda/topic (non e' presente in cache, o cache non abilitata)..."));
                }
                if (QUEUE.equalsIgnoreCase(this.properties.get("tipo"))) {
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idMessaggio + "] lookup coda..."));
                    }
                    queueDestination = (Queue)ctxJMS.lookup(this.location);
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idMessaggio + "] lookup coda effettuata..."));
                    }
                } else {
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idMessaggio + "] lookup topic..."));
                    }
                    topicDestination = (Topic)ctxJMS.lookup(this.location);
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idMessaggio + "] lookup topic effettuato..."));
                    }
                }
            }
            if (!findDestinationInCache && LOCATIONS_CACHE_ABILITATA.equals(this.properties.get("locations-cache"))) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] aggiunto coda/topic in cache..."));
                }
                if (QUEUE.equalsIgnoreCase(this.properties.get("tipo"))) {
                    this.putDestination(this.location, (Destination)queueDestination);
                } else {
                    this.putDestination(this.location, (Destination)topicDestination);
                }
            }
            if (user != null && password != null) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] create connection (user:" + user + " password:" + password + ")..."));
                }
                qc = qcf.createConnection(user, password);
            } else {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] create connection..."));
                }
                qc = qcf.createConnection();
            }
            if (qc == null) {
                throw new Exception("Connessione JMS non ritornata (is null) dalla ConnectionFactory[" + connectionFactory + "]");
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] create sessione [" + this.acknowledgeModeSessione + "]..."));
            }
            if ((qs = qc.createSession(false, this.acknowledgeModeSessione)) == null) {
                throw new Exception("Sessione JMS non ritornata (is null) dalla Connessione creata con la ConnectionFactory[" + connectionFactory + "]");
            }
            if (QUEUE.equalsIgnoreCase(this.properties.get("tipo"))) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] create queue producer..."));
                }
                sender = qs.createProducer((Destination)queueDestination);
            } else {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] create topic producer..."));
                }
                sender = qs.createProducer((Destination)topicDestination);
            }
            if (sender == null) {
                throw new Exception("Sender JMS non creato (is null) attraverso la Sessione creata con la Connessione presa dalla ConnectionFactory[" + connectionFactory + "]");
            }
            BytesMessage messageJMS = null;
            if (BYTES_MESSAGE.equalsIgnoreCase(this.properties.get("send-as"))) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] create BytesMessage..."));
                }
                messageJMS = qs.createBytesMessage();
                messageJMS.writeBytes(consegna);
            } else {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] create TextMessage..."));
                }
                messageJMS = qs.createTextMessage(new String(consegna));
            }
            if (messageJMS == null) {
                throw new Exception("Messaggio JMS non creato (is null) attraverso la Sessione creata con la Connessione presa dalla ConnectionFactory[" + connectionFactory + "]");
            }
            if (this.propertiesTrasporto != null) {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] set proprieta' jms..."));
                }
                Enumeration<Object> enumSPC = this.propertiesTrasporto.keys();
                while (enumSPC.hasMoreElements()) {
                    String key = (String)enumSPC.nextElement();
                    String value = (String)this.propertiesTrasporto.get(key);
                    key = key.replace("X-", "");
                    key = key.replaceAll("-", "");
                    if (this.debug) {
                        this.log.debug((Object)("[" + this.idMessaggio + "] set proprieta' [" + key + "]=[" + value + "]..."));
                    }
                    messageJMS.setStringProperty(key, value);
                }
            }
            if (overwriteProperties != null) {
                String[] classiJMSSetProprieties;
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] set proprieta' dinamiche..."));
                }
                if ((classiJMSSetProprieties = overwriteProperties.getClassNameSetPropertiesJMS()) != null) {
                    for (int i = 0; i < classiJMSSetProprieties.length; ++i) {
                        if (this.debug) {
                            this.log.debug((Object)("[" + this.idMessaggio + "] set proprieta' dinamiche con classe[" + classiJMSSetProprieties[i] + "]..."));
                        }
                        try {
                            IConnettoreJMSSetProperties setProperties = (IConnettoreJMSSetProperties)this.loader.newInstance(classiJMSSetProprieties[i]);
                            setProperties.setProperties(this.requestMsg, (Message)messageJMS);
                            continue;
                        }
                        catch (Exception e) {
                            this.log.error((Object)("Setting delle proprieta' JMS tramite classe [" + classiJMSSetProprieties[i] + "] non riuscita"), (Throwable)e);
                        }
                    }
                }
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] send message..."));
            }
            sender.send((Message)messageJMS);
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] send message effettuata..."));
            }
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] sender.close ..."));
            }
            sender.close();
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] session.close ..."));
            }
            qs.close();
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] connection.close ..."));
            }
            qc.close();
            this.codice = 200;
            if (this.debug) {
                this.log.debug((Object)("[" + this.idMessaggio + "] connettore jms ha pubblicato con successo"));
            }
            this.postOutRequest();
            bl = true;
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.log.error((Object)"Errore avvenuto durante la consegna JMS", (Throwable)e);
            this.errore = "Errore avvenuto durante la consegna JMS: " + e.getMessage();
            try {
                sender.close();
            }
            catch (Exception ec) {
                // empty catch block
            }
            try {
                if (qs != null) {
                    qs.close();
                }
            }
            catch (Exception ec) {
                // empty catch block
            }
            try {
                if (qc != null) {
                    qc.close();
                }
            }
            catch (Exception ec) {
                // empty catch block
            }
            boolean bl2 = false;
            return bl2;
        }
        finally {
            try {
                if (ctxJMS != null) {
                    ctxJMS.close();
                }
            }
            catch (Exception close) {}
            try {
                if (ctxLocalPool != null) {
                    ctxLocalPool.close();
                }
            }
            catch (Exception close) {}
        }
        return bl;
    }

    public synchronized void putDestination(String key, Destination destination) {
        try {
            locations.put(key, destination);
        }
        catch (Exception e) {
            this.log.error((Object)("ERROR INSERT CODA IN CACHE: " + e.getMessage()), (Throwable)e);
        }
    }
}

