/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreHTTPSProperties;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.utils.resources.Loader;

public class ConnettoreHTTP
extends ConnettoreBase {
    public static final String REDIRECT_LOCATION_HEADER = "Location";
    public ByteArrayOutputStream outByte = new ByteArrayOutputStream();
    private OpenSPCoop2Message requestMsg;
    private Hashtable<String, String> properties;
    private boolean sbustamentoSoap;
    private Properties propertiesTrasporto;
    private Properties propertiesUrlBased;
    private Credenziali credenziali;
    private Busta busta;
    private boolean debug = false;
    private OpenSPCoop2Properties openspcoopProperties = null;
    private String idMessaggio;
    private Logger log = null;
    private Loader loader = null;
    private String idModulo = null;
    private boolean https = false;
    private ConnettoreHTTPSProperties sslContextProperties;
    private Proxy.Type proxyType = null;
    private String proxyUrl = null;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private boolean followRedirects = false;
    private String routeRedirect = null;
    private int numberRedirect = 0;
    private int maxNumberRedirects = 5;
    private InputStream is = null;
    private HttpURLConnection httpConn = null;
    private String httpMethod = null;
    private boolean sbustamentoApi;

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public boolean isSbustamentoApi() {
        return this.sbustamentoApi;
    }

    public ConnettoreHTTP() {
        this.https = false;
    }

    public ConnettoreHTTP(boolean https) {
        this.https = https;
    }

    @Override
    public boolean send(ConnettoreMsg request) {
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
        this.loader = Loader.getInstance();
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        try {
            this.requestMsg = request.getRequestMessage();
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.log.error((Object)("Errore durante la lettura del messaggio da consegnare: " + e.getMessage()), (Throwable)e);
            this.errore = "Errore durante la lettura del messaggio da consegnare: " + e.getMessage();
            return false;
        }
        this.properties = request.getConnectorProperties();
        this.sbustamentoSoap = request.isSbustamentoSOAP();
        this.propertiesTrasporto = request.getPropertiesTrasporto();
        this.propertiesUrlBased = request.getPropertiesUrlBased();
        this.busta = request.getBusta();
        if (this.busta != null) {
            this.idMessaggio = this.busta.getID();
        }
        try {
            Object o = this.requestMsg.getContextProperty("MESSAGGIO_API");
            if (o != null) {
                this.sbustamentoApi = (Boolean)o;
            }
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.log.error((Object)("Errore durante la lettura del messaggio da consegnare: " + e.getMessage()), (Throwable)e);
            this.errore = "Errore durante la lettura del messaggio da consegnare: " + e.getMessage();
            return false;
        }
        this.credenziali = request.getCredenziali();
        if (this.requestMsg == null) {
            this.errore = "Messaggio da consegnare is Null (Msg)";
            return false;
        }
        if (this.properties == null) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.size() == 0) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.get("location") == null) {
            this.errore = "Proprieta' 'location' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        if (this.https) {
            try {
                this.sslContextProperties = ConnettoreHTTPSProperties.readProperties(this.properties);
            }
            catch (Exception e) {
                this.eccezioneProcessamento = e;
                this.log.error((Object)("[HTTPS error]" + e.getMessage()));
                this.errore = "[HTTPS error]" + e.getMessage();
                return false;
            }
        }
        if (this.properties.get("proxyType") != null) {
            String tipo = this.properties.get("proxyType").trim();
            if ("http".equals(tipo)) {
                this.proxyType = Proxy.Type.HTTP;
            } else if ("https".equals(tipo)) {
                this.proxyType = Proxy.Type.HTTP;
            } else {
                this.errore = "Proprieta' 'proxyType' non corretta. Impostato un tipo sconosciuto [" + tipo + "] (valori ammessi: http,https)";
                return false;
            }
            this.proxyUrl = this.properties.get("proxyUrl");
            if (this.proxyUrl == null) {
                this.errore = "Proprieta' 'proxyUrl' non impostata, obbligatoria in presenza della propriet\u00e0 'proxyType'";
                return false;
            }
            this.proxyUrl = this.proxyUrl.trim();
            String proxyPortTmp = this.properties.get("proxyPort");
            if (proxyPortTmp == null) {
                this.errore = "Proprieta' 'proxyPort' non impostata, obbligatoria in presenza della propriet\u00e0 'proxyType'";
                return false;
            }
            proxyPortTmp = proxyPortTmp.trim();
            try {
                this.proxyPort = Integer.parseInt(proxyPortTmp);
            }
            catch (Exception e) {
                this.errore = "Proprieta' 'proxyPort' non corretta: " + e.getMessage();
                return false;
            }
            this.proxyUsername = this.properties.get("proxyUsername");
            if (this.proxyUsername != null) {
                this.proxyUsername = this.proxyUsername.trim();
            }
            this.proxyPassword = this.properties.get("proxyPassword");
            if (this.proxyPassword != null) {
                this.proxyPassword = this.proxyPassword.trim();
            } else if (this.proxyUsername != null) {
                this.errore = "Proprieta' 'proxyPassword' non impostata, obbligatoria in presenza della propriet\u00e0 'proxyUsername'";
                return false;
            }
        }
        this.idModulo = request.getIdModulo();
        this.outRequestContext = request.getOutRequestContext();
        this.msgDiagnostico = request.getMsgDiagnostico();
        if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
            this.followRedirects = this.openspcoopProperties.isFollowRedirects_consegnaContenutiApplicativi();
            this.maxNumberRedirects = this.openspcoopProperties.getFollowRedirectsMaxHop_consegnaContenutiApplicativi();
        } else {
            this.followRedirects = this.openspcoopProperties.isFollowRedirects_inoltroBuste();
            this.maxNumberRedirects = this.openspcoopProperties.getFollowRedirectsMaxHop_inoltroBuste();
        }
        String redirectTmp = this.properties.get("followRedirects");
        if (redirectTmp != null) {
            redirectTmp = redirectTmp.trim();
            this.followRedirects = Boolean.parseBoolean(redirectTmp);
        }
        if (this.followRedirects) {
            redirectTmp = this.properties.get("numberRedirect");
            if (redirectTmp != null) {
                redirectTmp = redirectTmp.trim();
                this.numberRedirect = Integer.parseInt(redirectTmp);
            }
            if ((redirectTmp = this.properties.get("routeRedirect")) != null) {
                this.routeRedirect = redirectTmp = redirectTmp.trim();
            }
        }
        return this.sendHTTP(request);
    }

    /*
     * Exception decompiling
     */
    private boolean sendHTTP(ConnettoreMsg request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 89[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void disconnect() throws ConnettoreException {
        try {
            if (this.is != null) {
                if (this.debug && this.log != null) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] chiusura socket..."));
                }
                this.is.close();
            }
            if (this.httpConn != null) {
                if (this.debug && this.log != null) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] chiusura connessione..."));
                }
                this.httpConn.disconnect();
            }
            super.disconnect();
        }
        catch (Exception e) {
            throw new ConnettoreException("Chiusura connessione non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public String getLocation() {
        if (this.routeRedirect == null) {
            return this.location;
        }
        return this.location + " [redirects route path: " + this.routeRedirect + "]";
    }
}

