/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.util.Date;
import java.util.Properties;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.IConnettore;
import org.openspcoop2.pdd.core.handlers.GestoreHandlers;
import org.openspcoop2.pdd.core.handlers.HandlerException;
import org.openspcoop2.pdd.core.handlers.OutRequestContext;
import org.openspcoop2.pdd.core.handlers.PostOutRequestContext;
import org.openspcoop2.pdd.core.handlers.PreInResponseContext;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;

public abstract class ConnettoreBase
extends AbstractCore
implements IConnettore {
    protected String errore = null;
    protected OpenSPCoop2Message responseMsg = null;
    protected int codice;
    protected long contentLength = -1L;
    protected String location = null;
    protected Exception eccezioneProcessamento = null;
    protected Properties propertiesTrasportoRisposta = new Properties();
    protected Date creationDate = DateManager.getDate();
    protected MsgDiagnostico msgDiagnostico;
    protected OutRequestContext outRequestContext;
    protected PostOutRequestContext postOutRequestContext;
    protected PreInResponseContext preInResponseContext;

    protected ConnettoreBase() {
    }

    @Override
    public String getErrore() {
        return this.errore;
    }

    @Override
    public int getCodiceTrasporto() {
        return this.codice;
    }

    @Override
    public Properties getHeaderTrasporto() {
        if (this.propertiesTrasportoRisposta.size() <= 0) {
            return null;
        }
        return this.propertiesTrasportoRisposta;
    }

    @Override
    public OpenSPCoop2Message getResponse() {
        return this.responseMsg;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public Exception getEccezioneProcessamento() {
        return this.eccezioneProcessamento;
    }

    @Override
    public void disconnect() throws ConnettoreException {
        try {
            if (this.responseMsg != null && this.responseMsg.getNotifierInputStream() != null) {
                this.responseMsg.getNotifierInputStream().close();
            }
        }
        catch (Exception e) {
            throw new ConnettoreException("Chiusura connessione non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public Date getCreationDate() throws ConnettoreException {
        return this.creationDate;
    }

    @Override
    public NotifierInputStreamParams getNotifierInputStreamParamsResponse() throws ConnettoreException {
        if (this.preInResponseContext != null) {
            return this.preInResponseContext.getNotifierInputStreamParams();
        }
        return null;
    }

    protected void postOutRequest() throws Exception {
        if (this.msgDiagnostico != null && this.outRequestContext != null) {
            this.postOutRequestContext = new PostOutRequestContext(this.outRequestContext);
            this.postOutRequestContext.setCodiceTrasporto(this.getCodiceTrasporto());
            this.postOutRequestContext.setPropertiesTrasportoRisposta(this.getHeaderTrasporto());
            try {
                GestoreHandlers.postOutRequest(this.postOutRequestContext, this.msgDiagnostico, OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    this.msgDiagnostico.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                } else {
                    this.msgDiagnostico.logErroreGenerico(e, "PostOutRequestHandler");
                }
                throw e;
            }
        }
    }

    protected void preInResponse() throws Exception {
        if (this.msgDiagnostico != null && this.outRequestContext != null) {
            PostOutRequestContext postContext = this.postOutRequestContext;
            if (postContext == null) {
                postContext = new PostOutRequestContext(this.outRequestContext);
                postContext.setCodiceTrasporto(this.getCodiceTrasporto());
                postContext.setPropertiesTrasportoRisposta(this.getHeaderTrasporto());
            }
            this.preInResponseContext = new PreInResponseContext(postContext);
            try {
                GestoreHandlers.preInResponse(this.preInResponseContext, this.msgDiagnostico, OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
            }
            catch (Exception e) {
                if (e instanceof HandlerException) {
                    this.msgDiagnostico.logErroreGenerico(e, ((HandlerException)e).getIdentitaHandler());
                } else {
                    this.msgDiagnostico.logErroreGenerico(e, "PreInResponseHandler");
                }
                throw e;
            }
        }
    }
}

