/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.connettori.ConnettoreBase;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.DirectVMConnectorInMessage;
import org.openspcoop2.pdd.services.connector.DirectVMConnectorOutMessage;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.constants.IDService;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;

public abstract class AbstractConnettoreDirectVM
extends ConnettoreBase {
    private Logger log = null;
    private OpenSPCoop2Message requestMsg;
    private Hashtable<String, String> properties;
    private Busta busta;
    private Properties propertiesTrasporto;
    private Properties propertiesUrlBased;
    private Credenziali credenziali;
    private String idMessaggio;
    private boolean debug = false;

    @Override
    public boolean send(ConnettoreMsg request) {
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        if (request == null) {
            this.errore = "Messaggio da consegnare is Null (ConnettoreMsg)";
            return false;
        }
        try {
            this.requestMsg = request.getRequestMessage();
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.log.error((Object)("Errore durante la lettura del messaggio da consegnare: " + e.getMessage()), (Throwable)e);
            this.errore = "Errore durante la lettura del messaggio da consegnare: " + e.getMessage();
            return false;
        }
        this.properties = request.getConnectorProperties();
        this.busta = request.getBusta();
        if (this.busta != null) {
            this.idMessaggio = this.busta.getID();
        }
        this.propertiesTrasporto = request.getPropertiesTrasporto();
        this.propertiesUrlBased = request.getPropertiesUrlBased();
        this.credenziali = request.getCredenziali();
        if (this.requestMsg == null) {
            this.errore = "Messaggio da consegnare is Null (Msg)";
            return false;
        }
        if (this.properties == null) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.size() == 0) {
            this.errore = "Proprieta' del connettore non definite";
        }
        if (this.properties.get("debug") != null && "true".equalsIgnoreCase(this.properties.get("debug").trim())) {
            this.debug = true;
        }
        this.outRequestContext = request.getOutRequestContext();
        this.msgDiagnostico = request.getMsgDiagnostico();
        IProtocolFactory pFactory = null;
        try {
            pFactory = this.buildProtocolFactoryForForwardMessage(this.properties);
        }
        catch (Exception e) {
            this.errore = e.getMessage();
            return false;
        }
        if (this.credenziali == null) {
            String user = this.properties.get("user");
            String password = this.properties.get("password");
            String subject = this.properties.get("subject");
            if (user != null || password != null || subject != null) {
                this.credenziali = new Credenziali();
                this.credenziali.setUsername(user);
                this.credenziali.setPassword(password);
                this.credenziali.setSubject(subject);
            }
        }
        if (this.validate(request)) {
            try {
                if (this.debug) {
                    this.log.debug((Object)("[" + this.idMessaggio + "] creazione URL..."));
                }
                this.buildLocation(this.properties, true);
            }
            catch (Exception e) {
                this.errore = e.getMessage();
                return false;
            }
            return this.sendByVM(pFactory);
        }
        return false;
    }

    private IProtocolFactory buildProtocolFactoryForForwardMessage(Hashtable<String, String> properties) throws Exception {
        IProtocolFactory pFactory = this.getProtocolFactory();
        String protocol = properties.get("protocol");
        if (protocol != null) {
            try {
                pFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
            }
            catch (Exception e) {
                throw new Exception("Proprieta' 'protocol' fornita contiene un tipo di protocollo [" + protocol + "] non valido: " + e.getMessage());
            }
        }
        return pFactory;
    }

    public void buildLocation(Hashtable<String, String> properties, boolean setFormBasedParameter) throws Exception {
        IProtocolFactory pFactory = this.buildProtocolFactoryForForwardMessage(properties);
        String webContext = "openspcoop2";
        String context = properties.get("context");
        if (context != null) {
            webContext = context;
        }
        this.location = "/" + webContext + "/" + pFactory.getProtocol() + "/" + this.getFunction();
        String suffix = this.getFunctionParameters();
        if (suffix != null && !"".equals(suffix)) {
            this.location = this.location + "/" + suffix;
        }
        if (setFormBasedParameter && this.propertiesUrlBased != null && this.propertiesUrlBased.size() > 0) {
            this.location = ConnettoreUtils.buildLocationWithURLBasedParameter(this.propertiesUrlBased, this.location);
        }
    }

    private boolean sendByVM(IProtocolFactory pFactory) {
        try {
            DirectVMConnectorInMessage inMessage = new DirectVMConnectorInMessage(this.requestMsg, this.getIdModuloAsIDService(), this.getIdModulo(), this.propertiesTrasporto, this.propertiesUrlBased, pFactory, this.getFunction(), this.location, this.credenziali, this.getFunctionParameters());
            DirectVMConnectorOutMessage outMessage = new DirectVMConnectorOutMessage();
            this.process(inMessage, outMessage);
            this.responseMsg = outMessage.getMessage();
            this.contentLength = outMessage.getContentLength();
            this.propertiesTrasportoRisposta = outMessage.getHeaders();
            this.codice = outMessage.getResponseStatus();
            this.postOutRequest();
            return true;
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.log.error((Object)("Errore avvenuto durante la consegna SOAP: " + e.getMessage()));
            this.errore = "Errore avvenuto durante la consegna SOAP: " + e.getMessage();
            return false;
        }
    }

    public abstract boolean validate(ConnettoreMsg var1);

    public abstract String getFunctionParameters();

    public abstract String getIdModulo();

    public abstract IDService getIdModuloAsIDService();

    public abstract String getFunction();

    public abstract void process(DirectVMConnectorInMessage var1, DirectVMConnectorOutMessage var2) throws ConnectorException;

    protected String normalizeFunctionParamters(String value) {
        if (value == null) {
            return null;
        }
        if (value.contains("?")) {
            return value.substring(0, value.indexOf("?"));
        }
        return value;
    }
}

