/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop2.pdd.core.autorizzazione.EsitoAutorizzazioneCooperazione;
import org.openspcoop2.pdd.core.autorizzazione.IAutorizzazioneBuste;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.resources.Loader;

public class GestoreAutorizzazioneBuste {
    private static String tipoAutorizzazioneBuste = null;
    private static final String AUTORIZZAZIONE_BUSTE_CACHE_NAME = "autorizzazioneBuste";
    private static Cache cacheAutorizzazioneBuste = null;
    private static Logger logger = null;
    private static Logger logConsole = OpenSPCoop2Logger.getLoggerOpenSPCoopConsole();
    private static ClassNameProperties className = ClassNameProperties.getInstance();
    private static boolean isAttivoAutorizzazioneBuste = false;

    public static void resetCache() throws AutorizzazioneException {
        if (cacheAutorizzazioneBuste != null) {
            try {
                cacheAutorizzazioneBuste.clear();
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
    }

    public static String printStatsCache(String separator) throws AutorizzazioneException {
        try {
            if (cacheAutorizzazioneBuste != null) {
                return cacheAutorizzazioneBuste.printStats(separator);
            }
            throw new Exception("Cache non abilitata");
        }
        catch (Exception e) {
            throw new AutorizzazioneException("Visualizzazione Statistiche riguardante la cache delle autorizzazioni della Porta di Dominio non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache() throws AutorizzazioneException {
        if (cacheAutorizzazioneBuste != null) {
            throw new AutorizzazioneException("Cache gia' abilitata");
        }
        try {
            cacheAutorizzazioneBuste = new Cache(AUTORIZZAZIONE_BUSTE_CACHE_NAME);
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
    }

    public static void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) throws AutorizzazioneException {
        if (cacheAutorizzazioneBuste != null) {
            throw new AutorizzazioneException("Cache gia' abilitata");
        }
        try {
            int dimensioneCacheInt = -1;
            if (dimensioneCache != null) {
                dimensioneCacheInt = dimensioneCache.intValue();
            }
            String algoritmoCache = null;
            algoritmoCache = algoritmoCacheLRU != null ? (algoritmoCacheLRU.booleanValue() ? CostantiConfigurazione.CACHE_LRU.toString() : CostantiConfigurazione.CACHE_MRU.toString()) : CostantiConfigurazione.CACHE_LRU.toString();
            long itemIdleTimeLong = -1L;
            if (itemIdleTime != null) {
                itemIdleTimeLong = itemIdleTime;
            }
            long itemLifeSecondLong = -1L;
            if (itemLifeSecond != null) {
                itemLifeSecondLong = itemLifeSecond;
            }
            GestoreAutorizzazioneBuste.initCacheAutorizzazione(dimensioneCacheInt, algoritmoCache, itemIdleTimeLong, itemLifeSecondLong, null);
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
    }

    public static void disabilitaCache() throws AutorizzazioneException {
        if (cacheAutorizzazioneBuste == null) {
            throw new AutorizzazioneException("Cache gia' disabilitata");
        }
        try {
            cacheAutorizzazioneBuste.clear();
            cacheAutorizzazioneBuste = null;
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
    }

    public static boolean isCacheAbilitata() {
        return cacheAutorizzazioneBuste != null;
    }

    public static String listKeysCache(String separator) throws AutorizzazioneException {
        if (cacheAutorizzazioneBuste != null) {
            try {
                return cacheAutorizzazioneBuste.printKeys(separator);
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
        throw new AutorizzazioneException("Cache non abilitata");
    }

    public static String getObjectCache(String key) throws AutorizzazioneException {
        if (cacheAutorizzazioneBuste != null) {
            try {
                Object o = cacheAutorizzazioneBuste.get(key);
                if (o != null) {
                    return o.toString();
                }
                return "oggetto con chiave [" + key + "] non presente";
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
        throw new AutorizzazioneException("Cache non abilitata");
    }

    public static void initialize(String tipoAutorizzazioneBuste, Logger log) throws Exception {
        GestoreAutorizzazioneBuste.initialize(tipoAutorizzazioneBuste, false, -1, null, -1L, -1L, log);
    }

    public static void initialize(String tipoAutorizzazioneBuste, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        GestoreAutorizzazioneBuste.initialize(tipoAutorizzazioneBuste, true, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
    }

    private static void initialize(String tipoAutorizzazioneBuste, boolean cacheAbilitata, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        logger = log;
        GestoreAutorizzazioneBuste.tipoAutorizzazioneBuste = tipoAutorizzazioneBuste;
        if ("none".equalsIgnoreCase(tipoAutorizzazioneBuste)) {
            return;
        }
        if (cacheAbilitata) {
            GestoreAutorizzazioneBuste.initCacheAutorizzazione(dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
        }
        isAttivoAutorizzazioneBuste = true;
    }

    public static void initCacheAutorizzazione(int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        String msg;
        if (log != null) {
            log.info((Object)"Inizializzazione cache Autorizzazione Buste");
        }
        cacheAutorizzazioneBuste = new Cache(AUTORIZZAZIONE_BUSTE_CACHE_NAME);
        if (dimensioneCache > 0 || algoritmoCache != null) {
            if (dimensioneCache > 0) {
                try {
                    msg = "Dimensione della cache (Autorizzazione Buste) impostata al valore: " + dimensioneCache;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    logConsole.info((Object)msg);
                    cacheAutorizzazioneBuste.setCacheSize(dimensioneCache);
                }
                catch (Exception error) {
                    throw new AutorizzazioneException("Parametro errato per la dimensione della cache (Gestore Messaggi): " + error.getMessage(), error);
                }
            }
            if (algoritmoCache != null) {
                msg = "Algoritmo di cache (Autorizzazione Buste) impostato al valore: " + algoritmoCache;
                if (log != null) {
                    log.info((Object)msg);
                }
                logConsole.info((Object)msg);
                if (CostantiConfigurazione.CACHE_MRU.toString().equalsIgnoreCase(algoritmoCache)) {
                    cacheAutorizzazioneBuste.setCacheAlgoritm(CacheAlgorithm.MRU);
                } else {
                    cacheAutorizzazioneBuste.setCacheAlgoritm(CacheAlgorithm.LRU);
                }
            }
        }
        if (idleTime > 0L || itemLifeSecond > 0L) {
            if (idleTime > 0L) {
                try {
                    msg = "Attributo 'IdleTime' (Autorizzazione Buste) impostato al valore: " + idleTime;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    logConsole.info((Object)msg);
                    cacheAutorizzazioneBuste.setItemIdleTime(idleTime);
                }
                catch (Exception error) {
                    throw new AutorizzazioneException("Parametro errato per l'attributo 'IdleTime' (Gestore Messaggi): " + error.getMessage(), error);
                }
            }
            if (itemLifeSecond > 0L) {
                try {
                    msg = "Attributo 'MaxLifeSecond' (Autorizzazione Buste) impostato al valore: " + itemLifeSecond;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    logConsole.info((Object)msg);
                    cacheAutorizzazioneBuste.setItemLifeTime(itemLifeSecond);
                }
                catch (Exception error) {
                    throw new AutorizzazioneException("Parametro errato per l'attributo 'MaxLifeSecond' (Gestore Messaggi): " + error.getMessage(), error);
                }
            }
        }
    }

    public static EsitoAutorizzazioneCooperazione verificaAutorizzazioneBuste(InfoConnettoreIngresso infoConnettoreIngresso, Credenziali credenzialiPdDMittente, String identitaServizioApplicativo, String subjectMessageSecurityServizioApplicativo, IDSoggetto soggettoFruitore, IDServizio idServizio, IState state, PdDContext pddContext, IProtocolFactory protocolFactory) throws Exception {
        String classType = null;
        IAutorizzazioneBuste auth = null;
        try {
            classType = className.getAutorizzazioneBuste(tipoAutorizzazioneBuste);
            auth = (IAutorizzazioneBuste)Loader.getInstance().newInstance(classType);
            AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
        }
        catch (Exception e) {
            throw new AutorizzazioneException("Riscontrato errore durante il caricamento della classe [" + classType + "] da utilizzare per l'autorizzazione delle buste: " + e.getMessage(), e);
        }
        if (cacheAutorizzazioneBuste == null) {
            return auth.process(infoConnettoreIngresso, credenzialiPdDMittente, identitaServizioApplicativo, subjectMessageSecurityServizioApplicativo, soggettoFruitore, idServizio, state);
        }
        if (soggettoFruitore == null || soggettoFruitore.getTipo() == null || soggettoFruitore.getNome() == null) {
            throw new AutorizzazioneException("(Parametri) Soggetto fruitore non definito");
        }
        if (idServizio == null) {
            throw new AutorizzazioneException("(Parametri) IDServizio non definito");
        }
        if (idServizio.getTipoServizio() == null || idServizio.getServizio() == null) {
            throw new AutorizzazioneException("(Parametri) Servizio non definito");
        }
        if (idServizio.getSoggettoErogatore() == null || idServizio.getSoggettoErogatore().getTipo() == null || idServizio.getSoggettoErogatore().getNome() == null) {
            throw new AutorizzazioneException("(Parametri) Soggetto erogatore non definito");
        }
        String keyCache = null;
        keyCache = soggettoFruitore.toString() + " -> " + idServizio.toString();
        if (credenzialiPdDMittente != null) {
            keyCache = keyCache + " mittente(" + credenzialiPdDMittente.toString() + ")";
        }
        if (identitaServizioApplicativo != null) {
            keyCache = keyCache + " identitaSA(" + identitaServizioApplicativo + ")";
        }
        if (subjectMessageSecurityServizioApplicativo != null) {
            keyCache = keyCache + " subjectMessageSecurity(" + subjectMessageSecurityServizioApplicativo + ")";
        }
        Cache cache = cacheAutorizzazioneBuste;
        synchronized (cache) {
            CacheResponse response = (CacheResponse)cacheAutorizzazioneBuste.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug((Object)("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:verificaAutorizzazioneBuste) in cache."));
                    return (EsitoAutorizzazioneCooperazione)response.getObject();
                }
                if (response.getException() != null) {
                    logger.debug((Object)("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:verificaAutorizzazioneBuste) in cache."));
                    throw (Exception)response.getException();
                }
                logger.error((Object)"In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            logger.debug((Object)("oggetto con chiave [" + keyCache + "] (methodo:verificaAutorizzazioneBuste) ricerco nella configurazione..."));
            EsitoAutorizzazioneCooperazione esito = auth.process(infoConnettoreIngresso, credenzialiPdDMittente, identitaServizioApplicativo, subjectMessageSecurityServizioApplicativo, soggettoFruitore, idServizio, state);
            if (esito != null) {
                if (esito.isServizioAutorizzato() || CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA.equals(esito.getErroreCooperazione().getCodiceErrore())) {
                    logger.info((Object)("Aggiungo oggetto [" + keyCache + "] in cache"));
                    try {
                        CacheResponse responseCache = new CacheResponse();
                        responseCache.setObject((Serializable)esito);
                        cacheAutorizzazioneBuste.put(keyCache, responseCache);
                    }
                    catch (UtilsException e) {
                        logger.error((Object)("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage()));
                    }
                }
                return esito;
            }
            throw new AutorizzazioneException("Metodo (GestoreAutorizzazioneBuste.autorizzazioneBuste.process) ha ritornato un valore di esito null");
        }
    }

    public static boolean isAttivoAutorizzazioneBuste() {
        return isAttivoAutorizzazioneBuste;
    }

    public static String getTipoAutorizzazioneBuste() {
        return tipoAutorizzazioneBuste;
    }
}

