/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione;

import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop2.pdd.core.autorizzazione.EsitoAutorizzazioneIntegrazione;
import org.openspcoop2.pdd.core.autorizzazione.IAutorizzazione;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.state.IState;

public class AutorizzazioneOpenSPCoop
extends AbstractCore
implements IAutorizzazione {
    @Override
    public EsitoAutorizzazioneIntegrazione process(InfoConnettoreIngresso infoConnettoreIngresso, String servizioApplicativo, IDPortaDelegata idPD, IDServizio servizio, PortaDelegata pd, IState state) throws AutorizzazioneException {
        EsitoAutorizzazioneIntegrazione esito = new EsitoAutorizzazioneIntegrazione();
        try {
            if (!ConfigurazionePdDManager.getInstance(state).autorizzazione(pd, servizioApplicativo)) {
                esito.setErroreIntegrazione(ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA.getErrore404_AutorizzazioneFallita(servizioApplicativo));
                esito.setServizioAutorizzato(false);
                return esito;
            }
        }
        catch (DriverConfigurazioneNotFound e) {
            esito.setErroreIntegrazione(ErroriIntegrazione.ERRORE_401_PD_INESISTENTE.getErrore401_PortaDelegataInesistente(e.getMessage(), servizioApplicativo));
            esito.setServizioAutorizzato(false);
            return esito;
        }
        catch (DriverConfigurazioneException e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error((Object)"AutorizzazioneOpenSPCoop non riuscita", (Throwable)e);
            esito.setErroreIntegrazione(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
            esito.setServizioAutorizzato(false);
            esito.setEccezioneProcessamento((Exception)((Object)e));
            return esito;
        }
        esito.setServizioAutorizzato(true);
        return esito;
    }
}

